<?php 
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$tag = (is_category() || is_singular() ) ? 'h3' : 'h2';
$comp = [
  'name' => get_post_meta($post->ID, "comp_name", true ) ? get_post_meta($post->ID, "comp_name", true ) : get_the_title(),
  'auth' => get_post_meta($post->ID, "comp_auth", true ) ? get_post_meta($post->ID, "comp_auth", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
  'city' => get_post_meta($post->ID, "comp_city", true ) ? get_post_meta($post->ID, "comp_city", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
  'address' => get_post_meta($post->ID, "comp_adress", true ) ? get_post_meta($post->ID, "comp_adress", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
  'phone' => get_post_meta($post->ID, "comp_tel", true ) ? get_post_meta($post->ID, "comp_tel", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
  'fax' => get_post_meta($post->ID, "comp_fax", true ) ? get_post_meta($post->ID, "comp_fax", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
  'site' => get_post_meta($post->ID, "comp_site", true ) ? get_post_meta($post->ID, "comp_site", true ) : esc_html__( 'Belirtilmemiş', 'kanews' ),
  'map' => get_post_meta($post->ID, "comp_map", true )
];
?>
<div class="col-12 toinfinite">
  <div class="kanews-post-item kanews-post-special-item kanews-post-comp">
  <?php
    if( empty( $GLOBALS['timeline_time'] ) || $GLOBALS['timeline_time'] != get_the_time('D M Y') ){
      echo '<div class="kanews-post-special-item-date"><span>'. get_the_time('j') .'</span><div>'. get_the_time('F') .'</div></div>';
    }
    $GLOBALS['timeline_time'] = get_the_time('D M Y');
    ?>	
    <div class="kanews-post-special-item-time"><span><?php the_time( 'G:i');  ?></span></div>
    <div class="row align-items-center">
      <a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>
      <?php $content_class = 'col-12 col-md-4'; $content_class2 = 'col-12 col-md-8';  if(has_post_thumbnail()) :  $content_class = $content_class2 = 'col-12 col-md-4';  ?>
        <div class="col-12 col-md-4">
          <?php kanews_post_thumbnail('full', 'kanews-post-comp-thumb'); ?>
        </div>
      <?php endif; ?>
      <div class="<?php echo $content_class; ?>">
        <div class="kanews-post-content">

          <?php the_title( sprintf( '<'.$tag.' class="kanews-post-headline truncate truncate-3"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></'.$tag.'>' ); ?>
          <div class="d-flex">
            <div><i class="icon-location"></i> <?php echo $comp['city']; ?></div>
            <div style="margin-left: 1em"><i class="icon-star"></i> <?php echo ci_comment_rating_get_average_ratings($post->ID); ?></div>
          </div>
        </div>
      </div>
      <div class="<?php echo $content_class2; ?>">
        <?php if (kanews_get_option('excerpt-length') != ''): ?>
          <?php the_excerpt(); ?>
        <?php endif; ?>
      </div>
      
    </div>
  </div>
</div>