<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$col = 'col-12 col-lg-4';
$sidebar = '';
if( is_page() ) {
	if(kan_is_mobile() && !kanews_get_option('page-sidebar') )
	return;
	$page = get_queried_object_id();
	if(is_active_sidebar( 'home-sidebar-'.$page ) ) {
		$sidebar = 'home-sidebar-'.$page;
	} else {
		$sidebar = 'home-sidebar-page';
	}
	$col = 'col-12 col-lg-3';
} elseif( is_singular() ) {
	if(kan_is_mobile() && !kanews_get_option('single-sidebar') )
	return;
	$sidebar = 'home-sidebar-post';
	$col = 'col-12 col-lg-3';
} else {
	if(kan_is_mobile() && !kanews_get_option('archive-sidebar') )
	return;
	$sidebar = 'home-sidebar-archive';
}
?>

<div id="sidebar" class="<?php echo $col; ?> sidebar-right kanews-sticky">
	<div class="row" role="complementary">
		<?php dynamic_sidebar( sanitize_title( $sidebar ) ); ?>
	</div>
</div>
