<div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Döviz Fiyatları', 'kanews' ), 'h3'); ?>
                <?php 
                $response2 = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/currencies/currencies.json");
                $data2 = json_decode($response2, true); 
                if(isset($data2['data']) ) {
                  $last_update_date  = $data2['lastUpdate']['formatted'];
                  $data2 = $data2['data'];
                  $data2['Update_Date'] = $last_update_date;
                } 
                ?>

                <table class="kanews-table table-search table-currencies table-auto mb-0">
                  <thead>
                    <tr>
                      <th><span class="nobr"><?php esc_html_e( 'Döviz', 'kanews' ); ?></span></th>
                      <th><span class="nobr"><?php esc_html_e( 'Fiyat', 'kanews' ); ?></span></th>
                      <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    if(!empty($data2) && is_array($data2) && isset($data2['USD'])) {

                      foreach(array_slice($data2, 1) as $key => $currency) {
                        $valid_keys = array('USD', 'EUR', 'JPY', 'GBP', 'CHF', 'CNY', 'RUB', 'AUD');

                        if (in_array($key, $valid_keys)) {
                          if( isset($currency['Type']) && $currency['Type'] != 'Gold' ) {
                            if (isset($currency['Change']) && $currency['Change'] < 0) {
                              $class = 'color-danger';
                            } else {
                              $class = 'color-success';
                            }
                            $search  = array( 'CSK' );
                            $replace = array( 'CZK' );
                            $key = str_replace($search, $replace, $key);
                            echo '<tr onclick="window.location=\''.kanews_get_page_link('parite', strtolower($key), 'doviz').'\';">';
                              echo '<td><img loading="lazy" src="https://s3-symbol-logo.tradingview.com/country/'.substr($key, 0, -1).'.svg" width="18" height="18" alt="'.$key.'" /><a href="'.kanews_get_page_link('parite', strtolower($key), 'doviz').'">'.$key.'/TRY</a></td>';

                              echo '<td>'.(string)$currency['Selling'].'</td>';
                              echo '<td class="'.$class.'"><span>'.(string)$currency['Change'].'%</span></td>';
                            echo '</tr>';
                          }
                        }
                      }

                      // echo '<tr>';
                      //   echo '<td>EUR/USD</td>';
                      //   echo '<td>'. number_format(( $data2['EUR']['Selling'] / $data2['USD']['Selling'] ), 5) .'</td>';
                      // echo '</tr>';
                      
                    } else {
                      echo '<tr><td>'.esc_html__( ('Veri alınamadı'), 'kanews' ).'</td></tr>';
                    }
                    ?>
                  </tbody>
                </table>
            
              
              </div>

<div class="kanews-section">
  <?php echo kanews_widget_title(esc_html__( 'Kripto Para Fiyatları', 'kanews' ), 'h3'); ?>
  <table class="kanews-table table-currencies">
    <tbody>
      <?php
      $indexes = [
        'try' => esc_html__( 'Türk Lirası', 'kanews' ),
        'usdt' => esc_html__( 'Amerikan Doları', 'kanews' ),
        'eur' => esc_html__( 'Euro', 'kanews' ),
        'btc' => esc_html__( 'Bitcoin', 'kanews' ),
        'eth' => esc_html__( 'Ethereum', 'kanews' ),
      ];
      $index = isset($_GET['index']) ? esc_html($_GET['index']) : kanews_get_option('crypto-page-index', 'try');
      $data = json_decode(kanews_crypto_data($index)); 
      
      if(!empty($data)) {
        foreach($data as $coin) {
          if($coin->market_cap_rank == 8) 
          break;
          $change =  $coin->price_change_percentage_24h;
          if ($change > 0 ) {
            $class = 'color-danger';
            $icon = '-';
          } else {
            $class = 'color-success';
            $icon = '';
          }
          echo '<tr onclick="window.location=\''.kanews_get_page_link('coin', strtolower($coin->id), 'crypto').'\';">';
            echo '<td><div class="d-flex align-items-center">'.kanews_get_local_image($coin->image, array('width' => 32, 'height' => 32, 'alt' => $coin->symbol)).'<a href="'.kanews_get_page_link('coin', strtolower($coin->id), 'crypto').'"><div>'.strtoupper($coin->symbol).'</div><div class="color-muted">'. $coin->name .'</div></a></div></td>';
            echo '<td class="text-right"><div class="d-flex align-items-center justify-content-end"><div>'.currency_format_number($coin->current_price).' '.strtoupper($index).'<div class="'.$class.'">'.$icon.currency_format_number($change).'%</div></div></div></td>';
          echo '</tr>';
        }
      } else {
        echo '<tr><td>'.esc_html__( 'Veri alınamadı', 'kanews' ).'</td></tr>';
      }
      
      ?>
    </tbody>
  </table>
</div>  

