<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly ?>
<div class="col-12 col-lg-3">
  <div class="kanews-section widget_accordion_menu">
  <?php echo kanews_widget_title(esc_html__( 'Kategoriler', 'kanews' ), 'h4'); ?>
    <?php 
      $taxonomies = get_terms( array(
        'taxonomy' => 'ilan-kategori',
        'hide_empty' => false,
        'parent' => 0 
      ) );
      if ( !is_wp_error($taxonomies) && !empty($taxonomies) ) :
      $output = '<div><ul class="widget-accordion-menu">';
      foreach( $taxonomies as $category ) {
        $children = get_terms( array(
          'parent' => $category->term_id,
          'taxonomy' => 'ilan-kategori',
          'hide_empty' => false,
        ) );
        $output.= '<li class="page_item menu-item-has-children"><a class="d-flex justify-content-between" href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori-ilan')).'">'. $category->name .' <i class="icon-arrow icon-180deg"></i></a>';
        if(!is_wp_error($children)) {
          $output .= '<ul class="sub-menu">';
          $output .= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori-ilan')).'">'.esc_html__( 'Hepsi', 'kanews' ).'</a></li>';
          foreach($children as $child) {
            $output.= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($child, 'kategori-ilan')).'">'. $child->name .' ('.$child->count.')</a>';
          }
          $output .= '</ul>';
        }
        $output .= '</li>';
      }
      $output.='</ul></div>';
      echo $output;
      endif;
    ?>
  </div>
  <div class="kanews-section">
    <?php echo kanews_widget_title(esc_html__( 'İlan Bul', 'kanews' ), 'h4'); ?>
    <form class="p-1 kanews-form-filter" action="<?php echo get_post_type_archive_link('ilan'); ?>">
      <div class="empty" style="display: block;height: 10px"></div>
      <div class="row no-gutters">
        <div class="col-12">
          <div class="kanews-form2 bgw">
            <select name="il" id="ilan-il">
              <option value="-1"><?php esc_html_e( 'İl', 'kanews' ); ?></option>
            </select>
          </div>
        </div>
        <div class="col-12">
          <div class="kanews-form2 bgw">
            <select name="ilce" id="ilan-ilce" disabled="disabled">
              <option value="-1"><?php esc_html_e( 'İlçe', 'kanews' ); ?></option>
            </select>
          </div>
        </div>
      </div>
      <?php 
    
        $taxonomies = get_terms( array(
            'taxonomy' => 'ilan-etiket',
            'hide_empty' => false
        ) );
        if ( !empty($taxonomies) ) :
          $output = '<div class="empty" style="display: block;height: 10px"></div><div class="row kanews-scroll" style="max-height: 200px">';
          foreach( $taxonomies as $category ) {
            $output .= '<div class="col-12 d-flex"><div class="kanews-form"><input type="checkbox" name="labels[]" value="'.esc_attr( $category->term_id ).'" id="ilan-etiket-'.$category->slug.'" />
            </div><label for="ilan-etiket-'.$category->slug.'">'.esc_html( $category->name ).'</label></div>';
          }
          $output.='</div>';
          echo $output;
        endif;
      ?>
      <div class="kanews-form2 bgw">
        <input class="mb-0" type="text" name="search" placeholder="<?php esc_html_e('Kelime Ara', 'kanews'); ?>" />
      </div>
      <button type="submit" class="kanews-btn kanews-btn-block kanews-btn-sm mb-0"><?php esc_html_e( 'Filtrele', 'kanews' ); ?></button>
    </form>
  </div>
</div>