<?php defined( 'ABSPATH' ) || exit; // Exit if accessed directly ?>
<div class="col-12 col-lg-4">

  <?php if( kanews_get_option('firma-widgets', true) ) : ?>

  <div class="kanews-section">
    <div class="kanews-icon-box">
      <div class="kanews-icon-box-header">
        <i class="icon-star"></i>
      </div>
      

      <h4><?php esc_html_e( 'Firma Ekle', 'kanews' ); ?></h4>
      <p class="kanews-icon-box-content"><?php esc_html_e( 'Tamamen ücretsiz olarak firmanı rehberimize ekleyebilirsiniz.', 'kanews' ); ?></p>


      <a href="<?php echo kanews_account_page_url(); ?>?islem=firma-ekle" class="kanews-btn kanews-btn-sm mt-0"><?php echo esc_html_e( 'Yeni Firma Ekle', 'kanews' ); ?></a>
    </div>
  </div>
  
  <div class="kanews-section">
    <?php echo kanews_widget_title(esc_html__( 'Firma Ara', 'kanews' )); ?>
    <form method="GET" action="<?php echo get_post_type_archive_link('firma'); ?> ">
      <div class="d-flex flex-wrap" style="padding: 1em 0">
        <div class="col-12 col-lg-6">
          <div class="kanews-form2">
            <input value="<?php echo isset($_GET['comp_name']) ? $_GET['comp_name'] : ''; ?>" type="text" name="comp_name" placeholder="<?php esc_html_e( 'Firma Adı', 'kanews' ); ?>">
          </div>
        </div>
        <div class="col-12 col-lg-6">
          <div class="kanews-form2 ">
            <input value="<?php echo isset($_GET['comp_city'])? $_POST['comp_city'] : ''; ?>" type="text" name="comp_city" placeholder="<?php esc_html_e( 'Şehir', 'kanews' ); ?>">
          </div>
        </div>
        <div class="col-12">
          <div class="kanews-form2">
            <?php $select_value = isset($_POST['comp_cat']) ? $_POST['comp_cat'] : ''; ?>
            <?php 
            if( $terms = get_terms( array(
              'taxonomy' => 'kategori', // to make it simple I use default categories
              'orderby' => 'name'
          ) ) ) : 
            // if categories exist, display the dropdown
            echo '<select value="'.$select_value.'" name="comp_cat"><option value="">'.esc_html__( 'Kategori', 'kanews' ).'</option>';
            foreach ( $terms as $term ) :
              echo '<option value="' . $term->term_id . '">' . $term->name . '</option>'; // ID of the category as an option value
            endforeach;
            echo '</select>';
          endif;
          ?>
          </div>
        </div>
        <div class="col-12">
          <div class="kanews-form2">
            <select name="comp_rating_min">
              <option value=""><?php esc_html_e( 'Minumum Puan', 'kanews' ); ?></option>
              <option <?php echo $_GET['comp_rating_min'] == '1' ? 'selected="select""': ''; ?> value="1">1</option>
              <option <?php echo $_GET['comp_rating_min'] == '2' ? 'selected="select""': ''; ?>  value="2">2</option>
              <option <?php echo $_GET['comp_rating_min'] == '3' ? 'selected="select""': ''; ?>  value="3">3</option>
              <option <?php echo $_GET['comp_rating_min'] == '4' ? 'selected="select""': ''; ?>  value="4">4</option>
              <option <?php echo $_GET['comp_rating_min'] == '5' ? 'selected="select"': ''; ?>  value="5">5</option>
            </select>
          </div>
        </div>
        <div class="col-12">
          <div class="kanews-form2 mb-0">
            <select name="comp_rating_max">
              <option value=""><?php esc_html_e( 'Maksimum Puan', 'kanews' ); ?></option>
              <option <?php echo $_GET['comp_rating_max'] == '1' ? 'selected="select""': ''; ?> value="1">1</option>
              <option <?php echo $_GET['comp_rating_max'] == '2' ? 'selected="select""': ''; ?>  value="2">2</option>
              <option <?php echo $_GET['comp_rating_max'] == '3' ? 'selected="select""': ''; ?>  value="3">3</option>
              <option <?php echo $_GET['comp_rating_max'] == '4' ? 'selected="select""': ''; ?>  value="4">4</option>
              <option <?php echo $_GET['comp_rating_max'] == '5' ? 'selected="select"': ''; ?>  value="5">5</option>
            </select>
          </div>
        </div>
        <div class="col-12">
          <button type="submit" class="kanews-btn kanews-btn-block mb-0 kanews-btn-sm"><?php esc_html_e( 'Arama Yap', 'kanews' ); ?></button>
        </div>
      </div>
    </form>
  </div>

  <?php 
    $slick_options = [
      'slidesToShow'  => 2,
      'dots'  => true,
      'adaptiveHeight'  => false,
      'arrows'			  => false,
      'autoplay'			=> true,
      'responsive' 			=> [
        [
          'breakpoint' 	 => 992,
          'settings'		 => [
            'slidesToShow' => 3
          ]
        ],
        [
          'breakpoint' 	 => 525,
          'settings'		 => [
            'slidesToShow' => 2
          ]
        ],
      ]
    ];
    $kanews_query = new WP_Query(
      array( 
        'showposts'    => 10,
        'post_type'    => 'firma',
        'meta_key' => '_kanews_post_rating_overall',
        'type' => 'numeric',
        'orderby' => 'meta_value_num',
      )
    );
    if ($kanews_query->have_posts()) : ?>
  
    <div class="kanews-section">
      <?php echo kanews_widget_title(esc_html__( 'En İyi Firmalar', 'kanews' )); ?>
      <div class="kanews-slider-c0">


        <div class="kanews-slider-wrapper" data-slick='<?php echo wp_json_encode( $slick_options ); ?>'>
          <?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post;  ?>
          
            <div class="kanews-post-item kanews-post-comp kanews-post-grid-item">
              <a href="<?php the_permalink(); ?>" class="kanews-post-href"></a>
              <?php kanews_post_thumbnail('full', 'kanews-post-comp-thumb'); ?>
              <div class="kanews-post-content">
                <?php the_title( sprintf( '<h4 class="kanews-post-headline truncate truncate-1"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' ); ?>
              </div>
            </div>
            
          <?php endwhile; ?>
        </div>

      
      </div>
    </div>
  <?php endif; ?>

  <?php 
  echo '<div class="kanews-section widget_accordion_menu">'; ?>
			
  <?php echo kanews_widget_title(esc_html__( 'Firma Kategorileri', 'kanews' ), 'h4'); ?>

  <?php 
    $taxonomies = get_terms( array(
      'taxonomy' => 'kategori',
      'hide_empty' => false,
      'parent' => 0 
    ) );
    if ( !is_wp_error($taxonomies) && !empty($taxonomies) ) :
    $output = '<div><ul class="widget-accordion-menu">';
    foreach( $taxonomies as $category ) {
      $children = get_terms( array(
        'parent' => $category->term_id,
        'taxonomy' => 'kategori',
        'hide_empty' => false,
      ) );
      $output.= '<li class="page_item menu-item-has-children"><a class="d-flex justify-content-between" href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori')).'">'. $category->name .' <i class="icon-arrow icon-180deg"></i></a>';
      if(!is_wp_error($children)) {
        $output .= '<ul class="sub-menu">';
        $output .= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori')).'">'.esc_html__( 'Hepsi', 'kanews' ).'</a></li>';
        foreach($children as $child) {
          $output.= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($child, 'kategori')).'">'. $child->name;
          if($args['show_count'])
          $output.= '('.$child->count.')';
          $output.= '</a>';
        }
        $output .= '</ul>';
      }
      $output .= '</li>';
    }
    $output.='</ul></div>';
    echo $output;
    endif;
  ?>

  <?php echo '</div>';
  endif; 
  ?>


	<?php dynamic_sidebar( 'firma-sidebar' ); ?>

  
  
</div>