<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Kanews
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
wp_enqueue_style('kanews-theme-single');

// Datapicker
function wpse_enqueue_datepicker() {
	wp_enqueue_script( 'moment', 'https://cdn.jsdelivr.net/momentjs/latest/moment.min.js', array('jquery'), null, true );
	wp_enqueue_script( 'daterangepicker', 'https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js', array('jquery'), null, true );
	wp_enqueue_style( 'daterangepicker', 'https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css' );
	wp_add_inline_script( 'daterangepicker', "
	(function($) {
		'use strict';

			$('.datefilter' ).daterangepicker({
				'singleDatePicker': false,
				'showDropdowns': true,
				'autoApply': false,
				ranges: {
						'Bugün': [moment(), moment()],
						'Dün': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Son 7 Gün': [moment().subtract(6, 'days'), moment()],
						'Son 30 Gün': [moment().subtract(29, 'days'), moment()],
						'Bu Ay': [moment().startOf('month'), moment().endOf('month')],
						'Geçen Ay': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
				},
				'alwaysShowCalendars': true,
				'opens': 'center',
				'drops': 'down',
				'autoUpdateInput': false,
				locale: {
						'cancelLabel': 'Temizle',
						'applyLabel': 'Uygula'
				},
		}, function(start, end, label) {
			console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
		});

		$('.datefilter').on('apply.daterangepicker', function(ev, picker) {
			$(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
			$(this).addClass('used')
	});

	$('.datefilter').on('cancel.daterangepicker', function(ev, picker) {
			$(this).val('');
			$(this).removeClass('used');
	});


	})(jQuery)" );
}
add_action( 'wp_enqueue_scripts', 'wpse_enqueue_datepicker' );


global $wp_query;
$args = array_merge( $wp_query->query_vars, array( 'post_type' => array('post', 'columist') ) );

if( isset($_GET['category']) )
$args = array_merge( $args, array( 'category__in' => $_GET['category'] ));

if( isset($_GET['tags']) && is_array( $_GET['tags'] )  )
$args = array_merge($args, array('tag__and' => $_GET['tags']));

if( isset($_GET['sort']) && $_GET['sort'] == 'da'  )
$args = array_merge($args, array('order' => 'ASC'));

if( isset($_GET['datefilter']) ) {
	$date_filter = explode('-', $_GET['datefilter']);
	if( isset($date_filter[0]) && isset($date_filter[1]) ) {
		$date_query = array(
			array(
				'after' => $date_filter[0]. '00:00:00',
				'before' => $date_filter[1].' 23:59:59',
				'inclusive' => true,
			)
			);
			$args = array_merge($args, array('date_query' => $date_query));
	}
}

query_posts( $args );
$found_posts = $wp_query->found_posts;
get_header(); ?>
<?php do_action('kanews_header_ad'); ?>
<main id="main" class="site-main">
	<div class="container">
		<div class="row">
			<div class="kanews-widget-area kanews-widgets-top">
				<div class="col-12">
					<div class="single-layout-flat">
						<div class="kanews-section-box">
							<div class="kanews-article-header p-0 mb-1">
								<h2 class="kanews-article-title mb-0"><?php echo sprintf( __( '<span>%s</span> için arama sonuçları', 'kanews' ), '<span>' . get_search_query() . '</span>' ); ?></h2>
								<p><?php echo sprintf( __( 'Yaklaşık %s sonuç bulundu.', 'kanews' ),  $found_posts ); ?></p>
							</div>
							<div class="row justify-content-between no-gutters">
                <div class="kanews-tab-3">
                  <ul class="nav nav-tabs d-flex flex-wrap p-0 mb-0">
                    <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'style', 'list', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo ( !isset($_GET['style']) || (isset($_GET['style']) && $_GET['style'] != 'grid')) ? 'active' : ''; ?>"><svg fill="currentColor" width="20px" height="20px" viewBox="0 0 64 64" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" xmlns:serif="http://www.serif.com/" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;"><rect id="Icons" x="-448" y="0" width="1280" height="800" style="fill:none;"/><g id="Icons1" serif:id="Icons"><g id="Strike"></g><g id="H1"></g><g id="H2"></g><g id="H3"></g><g id="list-ul"><path d="M12.016,12.164c-2.204,0 -3.983,1.778 -3.983,3.983c0,2.203 1.779,3.982 3.983,3.982c2.204,0 3.982,-1.779 3.982,-3.982c0,-2.205 -1.778,-3.983 -3.982,-3.983Z" style="fill-rule:nonzero;"/><path d="M12.016,28.094c-2.204,0 -3.983,1.779 -3.983,3.983c0,2.203 1.779,3.982 3.983,3.982c2.204,0 3.982,-1.779 3.982,-3.982c0,-2.204 -1.778,-3.983 -3.982,-3.983Z" style="fill-rule:nonzero;"/><path d="M12.016,44.024c-2.217,0 -3.983,1.792 -3.983,3.983c0,2.19 1.792,3.982 3.983,3.982c2.19,0 3.982,-1.792 3.982,-3.982c0,-2.191 -1.765,-3.983 -3.982,-3.983Z" style="fill-rule:nonzero;"/><rect x="23.981" y="45.848" width="32.083" height="4.023" style="fill-rule:nonzero;"/><rect x="23.981" y="13.997" width="32.083" height="3.984" style="fill-rule:nonzero;"/><rect x="23.981" y="29.915" width="32.083" height="4" style="fill-rule:nonzero;"/></g><g id="hamburger-1"></g><g id="hamburger-2"></g><g id="list-ol"></g><g id="list-task"></g><g id="trash"></g><g id="vertical-menu"></g><g id="horizontal-menu"></g><g id="sidebar-2"></g><g id="Pen"></g><g id="Pen1" serif:id="Pen"></g><g id="clock"></g><g id="external-link"></g><g id="hr"></g><g id="info"></g><g id="warning"></g><g id="plus-circle"></g><g id="minus-circle"></g><g id="vue"></g><g id="cog"></g><g id="logo"></g><g id="radio-check"></g><g id="eye-slash"></g><g id="eye"></g><g id="toggle-off"></g><g id="shredder"></g><g id="spinner--loading--dots-" serif:id="spinner [loading, dots]"></g><g id="react"></g><g id="check-selected"></g><g id="turn-off"></g><g id="code-block"></g><g id="user"></g><g id="coffee-bean"></g><g id="coffee-beans"><g id="coffee-bean1" serif:id="coffee-bean"></g></g><g id="coffee-bean-filled"></g><g id="coffee-beans-filled"><g id="coffee-bean2" serif:id="coffee-bean"></g></g><g id="clipboard"></g><g id="clipboard-paste"></g><g id="clipboard-copy"></g><g id="Layer1"></g></g></svg></a></li>
										<li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'style', 'grid', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo ( isset($_GET['style']) && $_GET['style'] == 'grid') ? 'active' : ''; ?>"><i aria-hidden="true" class="icon-grid icon-2x"></i></a></li>
									</ul>
                </div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="kanews-widget-area kanews-widgets-content">
				
				<div class="col-12 col-lg-8">
					<div class="row">
					
						<?php 
							$title = esc_html__('Arama Sonuçları', 'kanews');
							kanews_recent_posts('search', $title, 'h4'); 

							$out = '<div class="kanews-dropdown kanews-dropdown-search">'; 
                $out .= '<div data-toggle="kanews-search-sort" class="kanews-dropdown-item">'.esc_html__( 'Sıralama Ölçütü', 'kanews' ).'</div>';
                $out .= '<div id="kanews-search-sort" class="kanews-dropdown-content">';
                  $out .= '<ul>';
                    $out .= '<li><a href="'.esc_url( add_query_arg( 'sort', 'da', $_SERVER['REQUEST_URI'] ) ).'">'.esc_html__( 'Eklenme Tarihi (En Eski)', 'kanews' ).'</a></li>';
                    $out .= '<li><a href="'.esc_url( add_query_arg( 'sort', 'dd', $_SERVER['REQUEST_URI'] ) ).'">'.esc_html__( 'Eklenme Tarihi (En Yeni)', 'kanews' ).'</a></li>';
                  $out .= '</ul>';
                $out .= '</div>'; 
              $out .= '</div>';

							echo $out;
						?>
					</div>
				</div>

				<div class="col-12 col-lg-4">

					<div class="kanews-section">
						<?php echo kanews_widget_title(esc_html__( 'Detaylı Arama', 'kanews' ), 'h4'); ?>
						<form class="p-1" action="<?php echo esc_url( home_url( '/' ) ); ?>?>">
							<div class="kanews-form">
								<input autocomplete="off"  type="text" class="datefilter" name="datefilter" value="<?php echo isset($_GET['datefilter']) ? esc_attr($_GET['datefilter']) : ''; ?>" />
								<label><?php _e('Tarih Aralığı', 'kanews'); ?></label>
							</div>
							<div class="kanews-form-filter">
							<div class="kanews-form2">
								<?php wp_dropdown_categories( 'show_option_none='.esc_html__('Kategori Seç', 'kanews') ); ?>
							</div>
							<?php 
								$taxonomies = get_terms( array(
										'taxonomy' => 'post_tag',
										'hide_empty' => true
								) );
								if ( !empty($taxonomies) ) :
									$output = '<div class="empty" style="display: block;height: 10px"></div><div class="row kanews-scroll" style="max-height: 200px">';
									foreach( $taxonomies as $category ) {
										$checked = (isset($_GET['tags']) && $category->term_id && in_array($category->term_id, $_GET['tags'])) ? 'checked="checked"' : '';
										$output .= '<div class="col-12 d-flex"><div class="kanews-form"><input '.$checked.' type="checkbox" name="tags[]" value="'.esc_attr( $category->term_id ).'" id="category-'.$category->slug.'" />
										</div><label for="category-'.$category->slug.'">'.esc_html( $category->name ).'</label></div>';
									}
									$output.='</div>';
									echo $output;
								endif;
							?>
							<div class="kanews-form2">
								<input required class="mb-0" type="text" name="s" value="<?php echo isset($_GET['s']) ? esc_attr($_GET['s']) : ''; ?>" placeholder="<?php esc_html_e('Kelime Ara', 'kanews'); ?>" />
							</div>
							<button type="submit" class="kanews-btn kanews-btn-block kanews-btn-sm mb-0"><?php esc_html_e( 'Sonuçları Görüntüle', 'kanews' ); ?></button>
							</div>
						</form>
					</div>

					<div class="kanews-section widget_accordion_menu">
						<?php echo kanews_widget_title(esc_html__( 'Kategoriler', 'kanews' ), 'h4'); ?>
						<?php 
							$taxonomies = get_terms( array(
								'taxonomy' => 'category',
								'hide_empty' => true,
								'parent' => 0 
							) );
							if ( !is_wp_error($taxonomies) && !empty($taxonomies) ) :
							$output = '<div><ul class="widget-accordion-menu">';
							foreach( $taxonomies as $category ) {
								$children = get_terms( array(
									'parent' => $category->term_id,
									'taxonomy' => 'category',
									'hide_empty' => false,
								) );
								$output.= '<li class="page_item menu-item-has-children"><a class="d-flex justify-content-between" href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori-ilan')).'">'. $category->name .' <i class="icon-arrow icon-180deg"></i></a>';
								if(!is_wp_error($children)) {
									$output .= '<ul class="sub-menu">';
									$output .= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, 'kategori-ilan')).'">'.esc_html__( 'Tüm Yazılar', 'kanews' ).'</a></li>';
									foreach($children as $child) {
										$output.= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($child, 'kategori-ilan')).'">'. $child->name .' ('.$child->count.')</a>';
									}
									$output .= '</ul>';
								}
								$output .= '</li>';
							}
							$output.='</ul></div>';
							echo $output;
							endif;
						?>
					</div>

				</div>

			</div>
		</div>
	</div>
</main>
<?php get_footer();