<?php
/**
 * Template Name: Hava Durumu
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Hava Durumu', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
get_header(); ?>
<?php while ( have_posts() ) : the_post(); ?>
<?php endwhile; ?>

  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main m-0" style="background-color: #203259; background-image: url(https://assets.msn.com/weathermapdata/1/static/background/midImage5/Mid30.png);background-repeat: no-repeat;background-size: contain;">
    <div class="container">
      <div class="row">

        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
          <div class="col-12 mt-3">
            <?php $cities = kanews_get_turkey_cities2();  $default_city = !empty(kanews_get_option('weather-cities')) ? kanews_get_option('weather-cities') : '745042'; ?> 
            <div class="kanews-weather-form mb-2">
              
              <select name="sehir" id="sehir">
                <option value="742902"><?php esc_html_e( 'Şehir Seçin', 'kanews' ); ?></option>
                <?php echo $default_city; foreach ($cities as $key => $city) {?>
                  <option value="<?php echo $key; ?>" <?php if($key==$default_city){ echo 'selected'; $city2 = $city; } ?>><?php echo sprintf(esc_html__( '%s için Saatlik Hava Tahminleri', 'kanews' ), $city); ?></option>
                <?php  }?>
              </select>
              <h1 hidden><?php echo sprintf(esc_html__( '%s için Saatlik Hava Tahminleri', 'kanews' ), $city2); ?></h1>
          
            </div>
          </div>

        </div>
        
        <div id="havadonen" class="row">
          <div id="kanews-weather-loader"></div>
          <?php $counter = 0; foreach (kanews_weather_data($default_city) as $key => $value) { $counter++;
            ?>
            <div class="col-12">
  
              <div class="kanews-weather-wrapper">
                <?php if($counter == 1): ?>
                  <h2 class="kanews-weather-day"><?php _e('Bugün', 'kanews'); echo ' <span>'.$key.'</span>'; ?></h2>
                <?php else: ?>
                  <?php $nameOfDay = date('D', strtotime($key)); $day = kanews_translate_days($nameOfDay); 
                  echo '<h2 class="kanews-weather-day">'.$day.' <span>'.__('Günü Hava Tahminleri', 'kanews').'</span> </h2>'; ?>
                <?php endif; ?>
                
                  <div>
                    <?php
                    foreach ($value as $key => $val) {
                      ?>
                      <div class="kanews-weather-item d-flex flex-wrap align-items-center">
                        <div class="kanews-weather-time col-auto"><span class="kanews-label kanews-label-sm"><?=$key; ?></span></div>
                        <div class="kanews-weather-temp col-auto"><?=round($val['sicaklik'], 1); ?> °</div>
                        <div class="kanews-weather-icon col-auto">
                          <?php echo kanews_get_local_image( KAN_TEMPLATE_URL.'/assets/img/weather/svg/'.$val['icon'].'.svg', array('width' => 48, 'height' => 48, 'alt' => 'img'), '1e1');?>
                        </div>
                        <div class="kanews-weather-desc col-12 col-lg"><?=$val['desc']; ?></div>
                        <div class="kanews-weather-label col-12 col-lg d-flex justify-content-end">
                          <div class="kanews-weather-feels-like" title="<?php _e('Hissedilen Sıcaklık', 'kanews'); ?>"><svg aria-label="Hissedilen" aria-hidden="false" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><g><g><path d="M341.333,288.593V85.333C341.333,38.205,303.128,0,256,0s-85.333,38.205-85.333,85.333v203.259 C144.48,312.03,128,346.091,128,384c0,70.693,57.308,128,128,128s128-57.307,128-128C384,346.091,367.52,312.03,341.333,288.593z M256,469.333c-47.128,0-85.333-38.205-85.333-85.333c0-24.637,10.441-47.492,28.455-63.615l14.212-12.72V85.333 c0-23.564,19.103-42.667,42.667-42.667s42.667,19.102,42.667,42.667v222.332l14.212,12.72 c18.014,16.123,28.455,38.977,28.455,63.615C341.333,431.128,303.128,469.333,256,469.333z"></path></g></g><g><g><rect x="234.667" y="170.667" width="42.667" height="256"></rect></g></g><g><g><circle cx="256" cy="384" r="64"></circle></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg><span><?=round($val['hissedilen'], 1); ?> °</span></div>
                          <div class="kanews-weather-wind" title="<?php _e('Rüzgar Hızı', 'kanews'); ?>"><svg aria-label="Rüzgar" aria-hidden="false" role="img" viewBox="0 0 24 24"><path d="M6 8.67h5.354c1.457 0 2.234-1.158 2.234-2.222S12.687 4.4 11.354 4.4c-.564 0-1.023.208-1.366.488M3 11.67h15.54c1.457 0 2.235-1.158 2.235-2.222S19.873 7.4 18.54 7.4c-.747 0-1.311.365-1.663.78M6 15.4h9.389c1.457 0 2.234 1.159 2.234 2.223 0 1.064-.901 2.048-2.234 2.048a2.153 2.153 0 0 1-1.63-.742" stroke-width="2" stroke="currentColor" stroke-linecap="round" fill="none"></path></svg><span><?=$val['hiz']; ?> mph</span></div>
                          <div class="kanews-weather-nem" title="<?php _e('Nem', 'kanews'); ?>"><svg aria-label="Nem" aria-hidden="false" enable-background="new 0 0 510.013 510.013" height="512" viewBox="0 0 510.013 510.013" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m179.207 446c-26.473 0-47.2-21.354-47.2-47 0-20.68 13.41-38.27 32-44.55v-52.45h-33v-30h33v-34h-33v-30h33v-34h-33v-30h33v-73h30v222.14c26.941-52.674 66.638-108.692 104-156.58v-17.56c0-65.77-53.215-119-119-119-65.62 0-119 53.38-119 119v391h170.79c-22.39-16.3-40.32-38.37-51.59-64z"></path><path d="m323.007 153.29c-38.46 49.295-128.75 170.151-126.96 232.86 0 47.318 32.114 97.368 82.72 115.9 10.498 4.155 28.195 7.7 36.24 7.7 72.982 4.68 135-53.608 135-126.75 0-61.183-89.706-181.909-127-229.71zm47.5 268.71c-8 0-14.5-6.5-14.5-14.5s6.5-14.5 14.5-14.5 14.5 6.5 14.5 14.5-6.5 14.5-14.5 14.5zm-88-101c10.053 0 17.047 10.004 13.63 19.46v.01c-2.04 5.55-7.37 9.53-13.63 9.53-8 0-14.5-6.5-14.5-14.5s6.5-14.5 14.5-14.5zm28.71 109.11c-5.692-3.065-1.13-.609-26.42-14.22 21.799-40.488 10.782-20.028 56-104l26.42 14.22z"></path></g></svg><span><?=$val['nem']; ?>%</span></div>
                        </div>
                      </div>
                    <?php 
                    }
                    ?>
                  </div>
                </div>
              
            </div>
          <?php } ?>

          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-box kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
            <?php if ( comments_open() || get_comments_number() ) : ?>
              <div class="col-12">
                  <?php comments_template(); ?>
                </div>
            <?php endif;?> 
          <?php endwhile; ?>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();