(function() {
  tinymce.PluginManager.add('kanews_add_shortcode_button', function( editor, url ) {
      editor.addButton( 'kanews_add_shortcode_button', {
          icon: 'shortcodes-icon',
          type: 'menubutton',
          plugins: ['colorpicker', 'media'],
          menu: [

            // Button
            {
              text: 'Button',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Button',
                  body: [
                    {
                      type: 'listbox',
                      name: 'ButtonColor',
                      label: 'Renk',
                      'values': [
                        {text: 'Birincil Renk', value: ''},
                        {text: 'Mavi', value: 'bg-info'},
                        {text: 'Kırmızı', value: 'bg-danger'},
                        {text: 'Turuncu', value: 'bg-warning'},
                        {text: 'Siyah', value: 'bg-dark'},
                        {text: 'Yeşil', value: 'bg-success'},
                        {text: 'Gri', value: 'kanews-btn-light'},
                      ]
                    },
                    {
                      type: 'listbox',
                      name: 'ButtonSize',
                      label: 'Boyut',
                      'values': [
                        {text: 'Küçük', value: 'kanews-btn-sm'},
                        {text: 'Büyük', value: ''},
                        {text: 'Blok', value: 'kanews-btn-block'},
                      ]
                    },
                    {
                      type: 'textbox',
                      name: 'ButtonLink',
                      label: 'Link',
                      minWidth: 300,
                      value: 'http://'
                    },
                    {
                      type: 'textbox',
                      name: 'ButtonText',
                      label: 'Yazı',
                      value: 'Kanews'
                    },
                    {
                      type: 'checkbox',
                      name: 'ButtonTarget',
                      label: 'Yeni Sekmede Aç',
                      value: 'blank',
                    }

                  ],
                  onsubmit: function( e ) {
                    editor.insertContent( '[kanews-btn  color="' + e.data.ButtonColor + '" size="' + e.data.ButtonSize + '" link="' + e.data.ButtonLink + '" target="' + e.data.ButtonTarget + '"]'+ e.data.ButtonText +'[/kanews-btn]');
                  }
                });
              }
            },
            
            // Alert
            {
              text: 'Bilgi Kutusu',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Bilgi Kutusu',
                  body: [
                    {
                      type: 'listbox',
                      name: 'color',
                      label: 'Renk',
                      'values': [
                        {text: 'Birincil Renk', value: ''},
                        {text: 'Mavi', value: 'bg-info'},
                        {text: 'Kırmızı', value: 'bg-danger'},
                        {text: 'Turuncu', value: 'bg-warning'},
                        {text: 'Siyah', value: 'bg-dark'},
                        {text: 'Yeşil', value: 'bg-success'},
                        // {text: 'Gri', value: 'bg-light'},
                      ]
                    },
                    {
                      type: 'textbox',
                      name: 'text',
                      label: 'İçerik',
                      value: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.'
                    }

                  ],
                  onsubmit: function( e ) {
                    editor.insertContent( '[kanews-alert color="' + e.data.color + '" ]'+ e.data.text +'[/kanews-alert]');
                  }
                });
              }
            },

            // Açılır Menü
            {
              text: 'Açılır Menü',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Açılır Menü',
                  width: 350,
                  height: 275,
                  body: [
                    {
                      type: 'textbox',
                      name: 'title',
                      label: 'Başlık',
                      value: 'Kanews Wordpress Haber Teması'
                    },
                    {
                      type: 'listbox',
                      name: 'status',
                      label: 'Durum',
                      'values': [
                        {text: 'Aktif Değil', value: ''},
                        {text: 'Aktif', value: 'true'},
                      ]
                    },
                    {
                      type: 'textbox',
                      name: 'title2',
                      label: 'Başlık',
                      value: 'Kanews Nedir?'
                    },
                    {
                      type: 'listbox',
                      name: 'status2',
                      label: 'Status',
                      'values': [
                        {text: 'Aktif Değil', value: ''},
                        {text: 'Aktif', value: 'true'},
                      ]
                    },
                    {
                      type: 'textbox',
                      name: 'title3',
                      label: 'Başlık',
                      value: 'Kanews Nasıl Kullanılır?'
                    },
                    {
                      type: 'listbox',
                      name: 'status3',
                      label: 'Status',
                      'values': [
                        {text: 'Aktif Değil', value: ''},
                        {text: 'Aktif', value: 'true'},
                      ]
                    },
                  ],					
    
                  onsubmit: function( e ) {
                    editor.insertContent( '\
                    [kanews-accordion]<br />\
                      [kanews-collapse active="'+ e.data.status +'" title="'+ e.data.title +'"]<p>Yaygın inancın tersine, Lorem Ipsum rastgele sözcüklerden oluşmaz. Kökleri M.Ö. 45 tarihinden bu yana klasik Latin edebiyatına kadar uzanan 2000 yıllık bir geçmişi vardır.</p>[/kanews-collapse]<br />\
                      [kanews-collapse active="'+ e.data.status2 +'" title="'+ e.data.title2 +'"]<p>Yaygın inancın tersine, Lorem Ipsum rastgele sözcüklerden oluşmaz. Kökleri M.Ö. 45 tarihinden bu yana klasik Latin edebiyatına kadar uzanan 2000 yıllık bir geçmişi vardır.</p>[/kanews-collapse]<br />\
                      [kanews-collapse active="'+ e.data.status3 +'" title="'+ e.data.title3 +'"]<p>Yaygın inancın tersine, Lorem Ipsum rastgele sözcüklerden oluşmaz. Kökleri M.Ö. 45 tarihinden bu yana klasik Latin edebiyatına kadar uzanan 2000 yıllık bir geçmişi vardır.</p>[/kanews-collapse]<br />\
                    [/kanews-accordion]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },

            // Author
            {
              text: 'Yazarlarımız',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Yazalarımız',
                  width: 550,
                  height: 150,
                  body: [
                    {
                      type: 'textbox',
                      name: 'ids',
                      label: 'Yazar ID\'leri (Virgül il Ayır)',
                    },
                    {
                      type: 'listbox',
                      name: 'role',
                      label: 'Gösterilecek Rol',
                      'values': [
                        {text: 'Hepsi', value: ''},
                        {text: 'Yönetici', value: 'Administrator'},
                        {text: 'Editör', value: 'Editor'},
                        {text: 'Yazar', value: 'Author'},
                        {text: 'Köşe Yazarları', value: 'columist'},
                        {text: 'İçerik Sağlayıcı', value: 'Contributor'},
                        {text: 'Üye', value: 'Subscriber'},
                      ]
                    },
                    {
                      type: 'listbox',
                      name: 'role__not_in',
                      label: 'Gösterilmeyecek Rol',
                      'values': [
                        {text: '', value: ''},
                        {text: 'Yönetici', value: 'Administrator'},
                        {text: 'Editör', value: 'Editor'},
                        {text: 'Yazar', value: 'Author'},
                        {text: 'Köşe Yazarları', value: 'columist'},
                        {text: 'İçerik Sağlayıcı', value: 'Contributor'},
                        {text: 'Üye', value: 'Subscriber'},
                      ]
                    },
                    {
                      type: 'listbox',
                      name: 'col',
                      label: 'Sütun Sayısı',
                      'values': [
                        {value: 'col-md-4 col-lg-2', text: '6'},
                        {value: 'col-md-4 col-lg-3', text: '4'},
                        {value: 'col-md-4 col-lg-4', text: '3'},
                        {value: 'col-md-4 col-lg-6', text: '2'},
                      ]
                    },
                  ],					
    
                  onsubmit: function( e ) {
                    editor.insertContent( '[kanews-authors ids="'+ e.data.ids +'" col="'+ e.data.col +'" role="'+ e.data.role +'" role__not_in="'+ e.data.role__not_in +'"]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },

            {
              text: 'Çeviriciler',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Çeviriciler',
                  width: 350,
                  height: 150,
                  body: [
                    {
                      type: 'listbox',
                      name: 'type',
                      label: 'Araçlar',
                      'values': [
                        {text: 'Döviz Çevirici', value: 'doviz'},
                        {text: 'Kripto Para Çevirici', value: 'coin'},
                        {text: 'Emtia Çevirici', value: 'emtia'},
                        {text: 'Burç Hesaplayıcı', value: 'burc'},
                        {text: 'BMI Hesaplayıcı', value: 'vki'},
                        {text: 'Kredi Hesaplayıcı', value: 'kredi'},
                        {text: 'Bireysel Yatırım Hesaplayıcı', value: 'birikim'},
                      ]
                    },
                  ],					
    
                  onsubmit: function( e ) {
                    editor.insertContent( '[kanews-calculator tur="'+ e.data.type +'"]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },

            // Highlight
            {
              text: 'Vurgula',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Vurgula',
                  width: 350,
                  height: 200,
                  body: [
                    {
                      type: 'textbox',
                      name: 'text',
                      label: 'Text',
                      value: 'Kanews Wordpress Haber Teması'
                    }
                  ],					
    
                  onsubmit: function( e ) {
                    editor.insertContent( '\
                    [kanews-highlight]\
                      '+ e.data.text +' \
                    [/kanews-highlight]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },

            // Dropcap
            {
              text: 'Büyük Harf',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Büyük Harf',
                  width: 350,
                  height: 120,
                  body: [
                    {
                      type: 'listbox',
                      name: 'color',
                      label: 'Renk',
                      'values': [
                        {text: 'Varsayılan', value: ''},
                        {text: 'Birincil Renk', value: 'color-primary'},
                        {text: 'Mavi', value: 'color-info'},
                        {text: 'Kırmızı', value: 'color-danger'},
                        {text: 'Turuncu', value: 'color-warning'},
                        {text: 'Siyah', value: 'color-dark'},
                        {text: 'Yeşil', value: 'color-success'},
                        {text: 'Gri', value: 'color-light'},
                      ]
                    },
                    {
                      type: 'textbox',
                      name: 'text',
                      label: 'Harf',
                      value: 'A'
                    },
                  ],					
    
                  onsubmit: function( e ) {
                    editor.insertContent( '\
                    [kanews-dropcap color="'+ e.data.color +'"]\
                      '+ e.data.text +' \
                    [/kanews-dropcap]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },

            // Başlık
            {
              text: 'Başlık',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Başlık',
                  width: 350,
                  height: 120,
                  body: [
                    {
                      type: 'textbox',
                      name: 'text',
                      label: 'Başlık',
                      value: 'Kanews Wordpress Haber Teması'
                    },
                    {
                      type: 'listbox',
                      name: 'htag',
                      label: 'HTML Tag',
                      'values': [
                        {text: 'div', value: 'div'},
                        {text: 'h1', value: 'h1'},
                        {text: 'h2', value: 'h2'},
                        {text: 'h3', value: 'h3'},
                        {text: 'h4', value: 'h4'},
                        {text: 'h5', value: 'h5'},
                        {text: 'h6', value: 'h6'},
                      ]
                    },
                  ],					
    
                  onsubmit: function( e ) {
                    editor.insertContent( '\
                    [kanews-title tag="'+ e.data.htag +'"]\
                      '+ e.data.text +' \
                    [/kanews-title]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },

            // Covid
            {
              text: 'Covid Verileri',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Covid Verileri',
                  width: 350,
                  height: 120,
                  body: [
                    {
                      type: 'listbox',
                      name: 'data',
                      label: 'Veriler',
                      'values': [
                        {text: 'Türkiye', value: 'turkey'},
                        {text: 'Global', value: 'global'},
                      ]
                    },
                  ],					
    
                  onsubmit: function( e ) {
                    editor.insertContent( '\
                    [kanews-covid data="'+ e.data.data +'"]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },

            // Related Posts
            {
              text: 'Benzer Yazılar',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Benzer Yazılar',
                  width: 350,
                  height: 200,
                  body: [
                    {
                      type: 'textbox',
                      name: 'title',
                      label: 'Başlık',
                      value: 'Benzer Yazılar'
                    },
                    {
                      type: 'textbox',
                      name: 'pids',
                      label: 'Yazı IDleri:',
                      value: '1'
                    },
                    {
                      type: 'listbox',
                      name: 'htag',
                      label: 'HTML Tag',
                      'values': [
                        {text: 'div', value: 'div'},
                        {text: 'h1', value: 'h1'},
                        {text: 'h2', value: 'h2'},
                        {text: 'h3', value: 'h3'},
                        {text: 'h4', value: 'h4'},
                        {text: 'h5', value: 'h5'},
                        {text: 'h6', value: 'h6'},
                      ]
                    },
                    {
                      type: 'listbox',
                      name: 'style',
                      label: 'Stil',
                      'values': [
                        {text: '1', value: '1'},
                        {text: '2', value: '2'},
                      ]
                    },
                  ],					
      
                  onsubmit: function( e ) {
                    editor.insertContent( '\
                    [kanews-related-posts tag="'+ e.data.htag +'" style="'+ e.data.style +'" p="'+ e.data.pids +'" title="'+ e.data.title +'"]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },

            // Related Post
            {
              text: 'İlişkili Yazı',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'İlişkili Yazı',
                  width: 350,
                  height: 150,
                  body: [
                    {
                      type: 'textbox',
                      name: 'title',
                      label: 'Başlık',
                      value: 'İlişkili Yazı'
                    },
                    {
                      type: 'textbox',
                      name: 'pids',
                      label: 'Yazı ID:',
                      value: '1'
                    },
                    {
                      type: 'listbox',
                      name: 'htag',
                      label: 'HTML Tag',
                      'values': [
                        {text: 'div', value: 'div'},
                        {text: 'h1', value: 'h1'},
                        {text: 'h2', value: 'h2'},
                        {text: 'h3', value: 'h3'},
                        {text: 'h4', value: 'h4'},
                        {text: 'h5', value: 'h5'},
                        {text: 'h6', value: 'h6'},
                      ]
                    },
                  ],					
                  onsubmit: function( e ) {
                    editor.insertContent( '\
                    [kanews-related-post tag="'+ e.data.htag +'" ids="'+ e.data.pids +'" title="'+ e.data.title +'"]');
                  }
                },
                {
                  plugin_url : url
                });
              }
            },
            
            {
              text: 'Devamını Oku',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Devamını Oku',
                  body: [
                    {
                      type: 'textbox',
                      name: 'readText',
                      label: 'Devamını Oku',
                      value: 'Gizlenecek içerik buraya.'
                    },
                ],
                  onsubmit: function( e ) {
                  editor.insertContent( '[kanews-read-more]'+ e.data.readText +'[/kanews-read-more]');
                  }
                });
              }
            },
            {
              text: 'Yazı Kaynağı',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Yazı Kaynağı',
                  body: [
                    {
                      type: 'textbox',
                      name: 'name',
                      label: 'Görünecek Ad',
                      value: 'kanthemes.com'
                    },
                    {
                      type: 'textbox',
                      name: 'link',
                      label: 'Şink',
                      value: 'https://www.kanthemes.com'
                    },
                ],
                  onsubmit: function( e ) {
                  editor.insertContent( '[kanews-sources][kanews-source] link="'+ e.data.link +'"]'+ e.data.name +'[/kanews-source][/kanews-sources]');
                  }
                });
              }
            },
            {
              text: 'Reklam',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Kısakod Reklam',
                  body: [
                    {
                      type: 'textbox',
                      name: 'shortcodeAd',
                      label: 'Kısakod Reklam',
                      value: '[kanews-ad]'
                    },
                ],
                  onsubmit: function( e ) {
                  editor.insertContent( '[kanews-ad]');
                  }
                });
              }
            },
            {
              text: 'Sayfa Arası',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Sayfa Arası',
                  width: 350,
                  height: 120,
                  body: [
                    {
                      type: 'textbox',
                      name: 'relatedPostID',
                      label: 'ara:',
                      value: '<!--nextpage-->'
                    },
                  ],					

                  onsubmit: function( e ) {
                    editor.insertContent( '\
                    <!--nextpage-->]');
                  }
                },
                {
                      plugin_url : url
                });
              }
            },
            {
              text: 'Namaz Vakitleri',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Namaz Vakitleri',
                  body: [
                    {
                      type: 'textbox',
                      name: 'city',
                      label: 'İl Adı',
                      value: ''
                    },
                ],
                  onsubmit: function( e ) {
                  editor.insertContent( '[kanews-prayer city="'+ e.data.city +'"]');
                  }
                });
              }
            },
            {
              text: 'Borsa',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Borsa',
                  body: [
                    {
                      type: 'textbox',
                      name: 'hisse',
                      label: 'Hisse Kısaltması',
                      value: ''
                    },
                ],
                  onsubmit: function( e ) {
                  editor.insertContent( '[kanews-exchange hisse="'+ e.data.hisse +'"]');
                  }
                });
              }
            },
            {
              text: 'Piyasalar',
              onclick: function() {
                editor.windowManager.open( {
                  title: 'Namaz Vakitleri',
                  body: [
                    {
                      type: 'checkbox',
                      name: 'usd',
                      label: 'Dolar',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'euro',
                      label: 'Euro',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'gbp',
                      label: 'Sterlin',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'chf',
                      label: 'İsviçre Frangı',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'cny',
                      label: 'Çin Yuanı',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'jpy',
                      label: 'Japon Yeni',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'rub',
                      label: 'Rus Rublesi',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'eur_usd',
                      label: 'Euro / Dolar',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'ise_100',
                      label: 'Bist',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'gau',
                      label: 'Gram Altın',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'btc',
                      label: 'Bitcoin',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'eth',
                      label: 'Ethereum',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'bch',
                      label: 'Bitcoin Cash',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'xrp',
                      label: 'XRP',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'ltc',
                      label: 'Litecoin',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'bnb',
                      label: 'Binance Coin',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'sol',
                      label: 'Solana',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'avax',
                      label: 'Avalanche',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'ada',
                      label: 'Cardano',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'dot',
                      label: 'Polkadot',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'doge',
                      label: 'Doge Coin',
                      value: true,
                    },
                    {
                      type: 'checkbox',
                      name: 'shib',
                      label: 'Shiba Inu',
                      value: true,
                    },
                  ],
                  onsubmit: function( e ) {
                  editor.insertContent( '[kanews-currencies usd="'+ e.data.usd +'" euro="'+ e.data.euro +'" gbp="'+ e.data.gbp +'" eur-usd="'+ e.data.eur_usd +'" ise-100="'+ e.data.ise_100 +'" gau="'+ e.data.gau +'" btc="'+ e.data.btc +'" eth="'+ e.data.eth +'" bch="'+ e.data.bch +'" xrp="'+ e.data.xrp +'" ltc="'+ e.data.ltc +'" bnb="'+ e.data.bnb +'" sol="'+ e.data.sol +'" avax="'+ e.data.avax +'" ada="'+ e.data.ada +'" dot="'+ e.data.dot +'" doge="'+ e.data.doge +'" shib="'+ e.data.shib +'"]');
                  }
                });
              }
            },

            
          ]
      });
  });
})();