<?php
/**
 * Template Name: Namaz Vakitleri
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Namaz Vakitleri', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

// $country = (isset($_GET['ulke']) && $_GET['ulke'] != 'null' && !empty($_GET['ulke'])) ? ucwords($_GET['ulke']) : 'Turkey';
$country = 'Turkey';
$region = (isset($_GET['sehir']) &&  $_GET['sehir'] != 'null' && !empty($_GET['sehir'])) ? esc_html(ucwords($_GET['sehir'])) : kanews_get_option('prayer-page-city', 'Ankara');
$city = (isset($_GET['ilce']) && $_GET['ilce'] != 'null' && !empty($_GET['ilce'])) ? esc_html(ucwords($_GET['ilce'])) : kanews_get_option('prayer-page-city2', $region);
if( empty($city) )
$city = $region;

$date = date('Y-m-d');


if( $region == 'Kocaeli' && $region == $city )
$city = 'İzmit';

$data = kanews_prayer_times_api( $country, $region, $city, $date, 30);

if( $city != kanews_get_option('prayer-page-city', 'Ankara') && ( empty($data) || !isset( $data['times'] ) ) ) {
  wp_redirect( get_the_permalink(), 301);
  die;
} else {
  $title = wp_sprintf( esc_html__('%1$s Namaz Vakitleri', 'kanews'), $city );
  $new_title = $title.' - '.get_bloginfo( 'name' );

  function generate_custom_title($title) {
    global $new_title;
    if($new_title)
    $title = $new_title;
    return $title;  
  }
  add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
  add_filter( 'wpseo_title', 'generate_custom_title', 15 );
}

get_header(); ?>
  <?php while ( have_posts() ) : the_post(); ?>
  <div class="kanews-page-header">
			<div class="container">
				<div class="row align-items-center flex-column">
        <div class="col-12 kanews-flat-breadcrumb mb-1">
            <?php kanews_breadcrumb(get_the_ID()); ?>
            </div>
						<div class="col-12"><h1 class="kanews-page-title"><?php echo $title; ?></h1></div>
						<div class="col-12"><h2 class="kanews-page-subtitle"><?php echo wp_sprintf( __('%1$s namaz vakitlerini 30 günlük periyotla takip edin! Güncel namaz saatleri takip edin ve ibadetlerinizi zamanında yerine getirin.', 'kanews'), $city); ?></h2></div>
            <div class="col-12 mt-2 ">
              <div class="pfg21" style="    background: #fff;
    padding: 1em;
    margin: 0 0px -35px;">

                <div class="col">
                <div class="kanews-form mb-0">
                  <select id="regionSelect">
                    <option option option value="<?php echo esc_attr($region); ?>"><?php echo $region; ?></option>

                    <?php if( $country == 'Turkey' ): ?>
                      <?php $sehirler = kanews_get_sehir(); unset($sehirler[0]); foreach( $sehirler as $sehir2 ): ?>
                        <?php if( $region != $sehir2 ) : ?>
                        <option value="<?php echo esc_attr($sehir2); ?>"><?php echo $sehir2; ?></option>
                        <?php endif; ?>

                      <?php endforeach; ?>
                    <?php endif; ?>
                  </select>
                  <label><?php esc_html_e( 'Şehir', 'kanews' ); ?></label>

                </div>
                </div>
                <div class="col">
                <div class="kanews-form mb-0">

                  <select id="citySelect">
                    <option value="" disabled selected><?php esc_html_e( 'İlçe Seçin', 'kanews' ); ?></option>
                  </select>
                  <label><?php esc_html_e( 'İlçe', 'kanews' ); ?></label>

                </div>
                </div>

                <div class="col-12">
                  <button class="kanews-btn kanews-btn-sm mb-0 kanews-btn-block" id="getirButton"><?php esc_html_e('Getir', 'kanews'); ?></button>

                </div>        
              </div>
            </div>

            <?php if( isset($data['times'][$date]) ) : $adlar = array("İmsak", "Güneş", "Öğle", "İkindi", "Akşam", "Yatsı"); ?>
              <div class="col-12">
                <div class="prayer-timeline row">
                  <?php foreach( $data['times'][$date] as $index => $timeline): ?>
                  <div class="col">
                    <div class="item">
                    <span class="name"><?php echo $adlar[$index]; ?></span>
                      
                      <span class="time"><?php echo $timeline; ?></span>
                    </div>
                  </div>
                  <?php endforeach; ?>
                </div>
              </div>
            <?php endif; ?>

          </div>
			</div>
		</div>  <?php endwhile; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>

          <div class="col-12">
            <div class="kanews-section" style="overflow:auto">
              <?php echo kanews_widget_title(sprintf( esc_html__( '%s İçin Aylık Namaz Vakitleri', 'kanews' ), $city ), 'h2'); ?>
                <table class="kanews-table table-currencies" style="table-layout: auto;">
                <thead>
                  <tr>
                    <th><span class="nobr"><?php esc_html_e( 'Tarih', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'İmsak', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Güneş', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Öğle', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'İkindi', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Akşam', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Yatsı', 'kanews' ); ?></span></th>
                  </tr>
                </thead>
                <tbody>
                  <?php
              
                  if(!empty($data) && isset( $data['times'] ) ) {
                    foreach($data['times'] as $key=>$value) {
                      echo '<tr class="'.(( $key == $date ) ? 'active' : '' ).'">';
                      $tarih_objesi = new DateTime($key);
                      $gun = $tarih_objesi->format('D');
                      $ay = $tarih_objesi->format('M');
                      $yil = $tarih_objesi->format('Y');
                      $tarih_turkce = $tarih_objesi->format('d') . ' ' . kanews_translate_months($ay) . ' ' . $tarih_objesi->format('Y') . ' ' . kanews_translate_days($gun);

                        echo '<td style="font-weight: 600">'.$tarih_turkce.'</td>';
                        foreach( $value as $time ) {
                          echo '<td>'.$time.'</td>';
                        }
                      echo '</tr>';

                    }
                  } else {
                    echo '<tr><td>'.esc_html__( ('Veri alınamadı'), 'kanews' ).'</td></tr>';
                  }
                  ?>
                </tbody>
              </table>

            </div>
          </div>

          <div class="col-12">
            <div class="kanews-section p-1">
              <div class="d-flex flex-wrap" style="gap: 10px">
                <?php if( $country == 'Turkey' ): ?>
                  <?php $sehirler = kanews_get_sehir(); unset($sehirler[0]); foreach( $sehirler as $sehir2 ): ?>
         
                    <a class="kanews-label <?php echo ($sehir2 == $region) ? 'bg-primary border-primary color-white' : ''; ?>" href="<?php echo esc_url( add_query_arg( 'sehir', $sehir2, get_permalink() ) ); ?>"><?php echo $sehir2; ?></a>
              

                  <?php endforeach; ?>
                <?php endif; ?>
              </div>
            </div>
          </div>

          <div class="col-12">
            <?php 

            get_template_part('template-parts/content/components/related', 'page2', array( 
              'posts_per_page' => 10,
              's' => $region.' namaz'
            ) ); ?>
          </div>

          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-box kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
            <?php if ( comments_open() || get_comments_number() ) : ?>
              
              <div class="col-12">
                <?php comments_template(); ?>
              </div>
            <?php endif;?> 
          <?php endwhile; ?>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();
