<?php 
/**
* Open Graph Meta for posts
*/
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
add_action('amp_post_template_head', 'kanews_add_open_graph_meta_meta');
add_action('wp_head', 'kanews_add_open_graph_meta_meta', 5);
function kanews_add_open_graph_meta_meta(){

if( ! kanews_get_option('open-graph') )
return;

echo '<!-- Kanews Theme -->';

global $post;
$site_name = get_bloginfo( 'name' );
$site_desc = get_bloginfo( 'description' );
$default_thumb = kanews_get_option('default-thumbnail') ? kanews_get_option('default-thumbnail') : '';

$output_meta = [    
    'title'       => $site_name,
    'description' => $site_desc,
    'type'        => 'website',
    'url'         => home_url('/'),
];
$name = '';


if( is_page() ) {
    $output_meta['title'] = get_the_title($post->ID);
    $output_meta['type'] = 'website';
    $output_meta['url'] = get_permalink($post->ID);

    if( get_the_excerpt($post) != '' )
    $output_meta['description'] = get_the_excerpt($post);
    if( is_page_template( 'inc/currencies.php' )  ) {
        $name = isset($_GET['parite']) && !empty($_GET['parite']) ? $_GET['parite'] : get_query_var('parite');
        if( $name ) {
        $output_meta['url'] = kanews_get_page_link('parite', $name, 'doviz');
        $output_meta['title'] = wp_sprintf( __('%1$s Grafiği ve Piyasa Değeri', 'kanews'), strtoupper($name).'/TRY' );
        $output_meta['description'] = wp_sprintf( __('%1$s kuru ve analizi ile ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), strtoupper($name).'/TRY' );
        }
    }elseif( is_page_template( 'inc/standings.php' ) ) {
        $name = isset($_GET['lig']) && !empty($_GET['lig']) ? $_GET['lig'] : '';
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('lig', $name, 'puan');

            $output_meta['title'] = wp_sprintf( __('%1$s Puan Durumu', 'kanews'), ucwords( str_replace("-", " ", $name)) );
            $output_meta['description'] = wp_sprintf( __('%1$s puan durumunu, genel, ev/deplasman puan durumunu ve %1$s 2025 puan durumunda form durumunu (son 5 maç) görün.', 'kanews'), ucwords( str_replace("-", " ", $name)) );
        } else {
            $name = isset($_GET['lig']) && !empty($_GET['lig']) ? $_GET['lig'] : kanews_get_option('league-default', 'super-lig');
            $output_meta['title'] = wp_sprintf( __('%1$s Puan Durumu', 'kanews'), ucwords( str_replace("-", " ", $name)) );
            $output_meta['description'] = wp_sprintf( __('%1$s puan durumunu, genel, ev/deplasman puan durumunu ve %1$s 2025 puan durumunda form durumunu (son 5 maç) görün.', 'kanews'), ucwords( str_replace("-", " ", $name)) );

        }
    }elseif( is_page_template( 'inc/livescore.php' ) ) {
        global $wp;
        $name = isset($_GET['lig']) && !empty($_GET['lig']) ? $_GET['lig'] : get_query_var('lig');
        $tarih = isset($_GET['tarih']) && !empty($_GET['tarih']) ? $_GET['tarih'] : date('Y-m-d');
        if( $name ) {
            $output_meta['url'] = home_url(add_query_arg( array('lig' => urlencode( $name ), 'tarih' => $tarih), $wp->request));

            $lig_title = kanews_correct_league_title2($name);
            $output_meta['title'] = sprintf(esc_html__('%s Canlı Maç Sonuçları (%s)', 'kanews'), $lig_title, $tarih);
            $output_meta['description'] = wp_sprintf( __('%1$s (%2$s) canlı maç sonuçlarını anlık olarak takip edin! Güncel skorlar, puan durumu ve takım istatistikleri bir arada.', 'kanews'), $lig_title, $tarih );
        }
    }elseif( is_page_template( 'inc/newspaper.php' ) ) {
        $name = isset($_GET['gazete']) && !empty($_GET['gazete']) ? $_GET['gazete'] : get_query_var('gazete');
        if( $name ) {
            date_default_timezone_set('Europe/Istanbul');
            $day = date("n");
            if($day < 10)
            $day = '0'.$day;
            $gazetetarih = date("d".$day."y");

            if (class_exists('IntlDateFormatter')) {
            $formatter = new IntlDateFormatter('tr_TR', IntlDateFormatter::LONG, IntlDateFormatter::NONE);
            $today = $formatter->format(time());
            } else {
            setlocale(LC_TIME, 'tr_TR.UTF-8');
            $today = strftime('%e %B %Y, %A');
            }

            $newspapers = [
            'aksam' => 'Akşam',
            // 'yeni-safak' => 'Yeni Şafak',
            // 'fanatik' => 'Fanatik',
            'fotomac' => 'Fotomaç',
            'milliyet' => 'Milliyet',
            // 'sozcu' => 'Sözcü',
            'takvim-gazetesi' => 'Takvim',
            'hurriyet' => 'Hürriyet',
            'sabah' => 'Sabah',
            'milli-gazete' => 'Milli',
            'yenicag' => 'Yeni Çağ',
            'milat' => 'Milat',
            'turkiye' => 'Türkiye',
            'turkgun' => 'Türkgün',
            'dunya' => 'Dünya',
            'yenisoz' => 'Yenisöz',
            // 'harbi-gazete' => 'Harbi Gazete',
            'dogru-haber' => 'Doğru Haber',
            'yeni-birlik' => 'Yeni Birlik',
            'aydinlik' => 'Aydınlık',
            ];
            if( isset($newspapers[$name]) ) {
                $output_meta['title'] =  wp_sprintf(esc_html__('%1$s Gazetesi %2$s Günü Gazete Manşetleri', 'kanews'), $newspapers[$name], $today);
                $output_meta['url'] = kanews_get_page_link('gazete', $name, 'gazete');
                $output_meta['description'] = wp_sprintf( __('%1$s gazetesinin %2$s tarihli gazete manşetlerine göz atın, en son gelişmeler ve öne çıkan haberlerle Türkiye\'nin gündemini takip edin!', 'kanews'), $newspapers[$name], $today );
            }
        }
    }elseif( is_page_template( 'inc/exchange.php' ) ) {
        $name = isset($_GET['hisse']) && !empty($_GET['hisse']) ? $_GET['hisse'] : get_query_var('hisse');
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('hisse', $name, 'exchange');

        $output_meta['title'] = wp_sprintf( __('%1$s — Hisse Senedi Grafiği ve Piyasa Değeri', 'kanews'), strtoupper($name) );
        $output_meta['description'] = wp_sprintf( __('%1$s hisse senedi ile ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), strtoupper($name) );
        }
    }elseif( is_page_template( 'inc/exchange2.php' ) ) {
        $name = isset($_GET['hisse']) && !empty($_GET['hisse']) ? $_GET['hisse'] : get_query_var('hisse');
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('hisse', $name, 'exchange2');

        $output_meta['title'] = wp_sprintf( __('%1$s — Hisse Senedi Grafiği ve Piyasa Değeri', 'kanews'), explode(':', $name)[1] );
        $output_meta['description'] = wp_sprintf( __('%1$s hisse senedi ile ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), explode(':', $name)[1] );
        }
    }elseif( (is_page_template( 'inc/cryptocurrencies.php' ) || is_page_template( 'inc/cryptocurrencies2.php'))  ) {
        $index = isset($_GET['index']) ? $_GET['index'] : kanews_get_option('crypto-page-index', 'try');
        $name = isset($_GET['coin']) && !empty($_GET['coin']) ? $_GET['coin'] : get_query_var('coin');
        if( $name ) {
        
        $output_meta['url'] = kanews_get_page_link('coin', $name, 'crypto');
        $output_meta['title'] = wp_sprintf( __('%1$s Grafiği ve Piyasa Değeri', 'kanews'), strtoupper($name.'/'.$index));
        $output_meta['description'] = wp_sprintf( __('%1$s kripto parası ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), strtoupper($name.'/'.$index));
        }
    }elseif( is_page_template( 'inc/emtia.php' ) ) {
        $name = isset($_GET['emtia']) && !empty($_GET['emtia']) ? $_GET['emtia'] : get_query_var('emtia');
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('emtia', $name, 'emtia');

            $search  = array('ONS', 'GRA', 'CEY', 'YAR', 'TAM', 'CUM', 'ATA', 'RES', 'HAM', 'IKI', 'GRE', 'BES', 'ODA', 'OSA', 'YIA', 'GUM' );
            $replace = array('ONS Altın ', 'Gram Altın', 'Çeyrek Altın', 'Yarım Altın', 'Tam Altın', 'Cumhuriyet Altın', 'Ata Altın', 'Reşat Altın', 'Hamit Altın', 'İkibuçuk Altın', 'Gremse Altın', 'Beşli Altın', '14 Ayar Altın', '18 Ayar Altın', '22 Ayar Altın', 'Gümüş Gram');

            $output_meta['title'] = wp_sprintf( esc_html__('%1$s Ne Kadar, Kaç TL?', 'kanews'), esc_html(str_replace($search, $replace, strtoupper($name))) );
            $output_meta['description'] = wp_sprintf( __('1 %1$s ne kadar? 1 %1$s bugün kaç TL?, %1$s ile ilgili anlık verilere ve analizlere ulaşabilirsiniz.', 'kanews'), esc_html(str_replace($search, $replace, strtoupper($name))));
        }
    }elseif( is_page_template( 'inc/weather-2.php' ) ) {
        $name = isset($_GET['sehir']) && !empty($_GET['sehir']) ? $_GET['sehir'] : get_query_var('sehir');
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('sehir', $name, 'weather');
            $output_meta['title'] = wp_sprintf( esc_attr__('%s için Hava Durumu', 'kanews'), ucfirst($name));
            $output_meta['description'] = wp_sprintf( __('%1$s için detaylı hava durumu, sıcaklık, nem ve yağış bilgisi, saatlik ve 5 günlük saatlik hava tahmini verilmektedir.', 'kanews'), ucfirst($name) );
        } else {
            $default_city = kanews_get_option('weather-cities') ? kanews_get_option('weather-cities') : '745042';
            $name = ucwords(kanews_get_turkey_cities2('key', $default_city));
            $output_meta['title'] = wp_sprintf( esc_attr__('%s için Hava Durumu', 'kanews'), ucfirst($name));
            $output_meta['description'] = wp_sprintf( __('%1$s için detaylı hava durumu, sıcaklık, nem ve yağış bilgisi, saatlik ve 5 günlük saatlik hava tahmini verilmektedir.', 'kanews'), ucfirst($name) );
        }
    }elseif( is_page_template( 'inc/prayer.php' ) ) {
        $name = isset($_GET['sehir']) && !empty($_GET['sehir']) ? $_GET['sehir'] : get_query_var('sehir');
        $region = (isset($_GET['sehir']) &&  $_GET['sehir'] != 'null' && !empty($_GET['sehir'])) ? esc_html(ucwords($_GET['sehir'])) : kanews_get_option('prayer-page-city', 'Ankara');
        $city = (isset($_GET['ilce']) && $_GET['ilce'] != 'null' && !empty($_GET['ilce'])) ? esc_html(ucwords($_GET['ilce'])) : kanews_get_option('prayer-page-city2', $region);
        if( empty($city) )
        $city = $region;

        if( $region == 'Kocaeli' && $region == $city )
        $city = 'İzmit';

        if( $name ) 
        $output_meta['url'] = kanews_get_page_link('sehir', $name, 'namaz');
        $output_meta['title'] = wp_sprintf( esc_html__('%1$s Namaz Vakitleri', 'kanews'), $city );
        $output_meta['description'] = wp_sprintf( __('%1$s namaz vakitlerini 30 günlük periyotla takip edin! Güncel namaz saatleri takip edin ve ibadetlerinizi zamanında yerine getirin.', 'kanews'), $city);

    }elseif( is_page_template( 'inc/eczane.php' ) ) {
        $name = (isset($_GET['sehir']) &&  $_GET['sehir'] != 'null' && !empty($_GET['sehir'])) ? ucwords($_GET['sehir']) : get_query_var('sehir');
        if( $name ) {
            $output_meta['url'] = kanews_get_page_link('sehir', strtolower($name), 'eczane');
            $output_meta['title'] = wp_sprintf( esc_html__('%1$s Nöbetçi Eczaneler', 'kanews'), $name );
            $output_meta['description'] = wp_sprintf( __('%1$s nöbetçi eczaneleri hızlıca bulun! Güncel adres, telefon ve konum bilgileriyle ihtiyaçlarınıza anında ulaşın.', 'kanews'), ucfirst($name) );
        } else {
            $name = kanews_get_option('eczane-page-city', 'Ankara');
            $output_meta['title'] = wp_sprintf( esc_html__('%1$s Nöbetçi Eczaneler', 'kanews'), $name );
            $output_meta['description'] = wp_sprintf( __('%1$s nöbetçi eczaneleri hızlıca bulun! Güncel adres, telefon ve konum bilgileriyle ihtiyaçlarınıza anında ulaşın.', 'kanews'), ucfirst($name) );
        }
    }elseif( is_page_template( 'inc/live.php' ) ) {
        $name = (isset($_GET['kanal']) &&  $_GET['kanal'] != 'null' && !empty($_GET['kanal'])) ? ucwords($_GET['kanal']) : get_query_var('kanal');
        if( $name ) {
            $output_meta['description'] = wp_sprintf( __('%1$s canlı yayını HD kalitesinde izle! Sevilen dizi, film, haber ve eğlence programlarını kesintisiz takip edin..', 'kanews'), ucfirst($name) );
        } else {
            $output_meta['description'] = wp_sprintf( __('Canlı TV kanallarını HD kalitesinde izleyin! Haber, spor, eğlence ve daha fazlasını kesintisiz takip edin."', 'kanews'), ucfirst($name) );
        }
    }
} elseif( is_singular() ) {

    $excerpt = '';
    $custom_excerpt = get_post_meta( $post->ID, 'kanews_post_excerpt', true ) ? get_post_meta( $post->ID, 'kanews_post_excerpt', true ) : '';
    if($custom_excerpt)
    $excerpt = $custom_excerpt;
    elseif(has_excerpt($post))
    $excerpt = get_the_excerpt($post);

    $output_meta['type'] = 'article';
    $output_meta['title'] = get_the_title();
    $output_meta['published'] = get_the_time('c', $post->ID);
    $output_meta['modified'] = get_the_modified_time('c', $post->ID);
    $output_meta['description'] = $excerpt;
    $output_meta['url'] = get_permalink($post->ID);
    $output_meta['image'] = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');

    // Get post type for article section
    $post_type = get_post_type($post->ID);
    if ($post_type === 'columist') {
        $output_meta['article_section'] = 'columnist';
    } elseif ($post_type === 'video') {
        $output_meta['article_section'] = 'video';
    } else {
        $output_meta['article_section'] = 'news';
    }

    // Get author information
    $author_id = get_post_field('post_author', $post->ID);
    $author_name = get_the_author_meta('display_name', $author_id);
    
    // Check for custom author meta field (for external sources like İHA, BÜLTEN)
    $custom_author = get_post_meta($post->ID, 'kanews_article_author', true);
    if (!empty($custom_author)) {
        $output_meta['article_author'] = $custom_author;
    } else {
        $output_meta['article_author'] = $author_name;
    }

    // Output article structured data meta tags
    echo '<meta name="datePublished" content="'.esc_attr($output_meta['published']).'" />';
    echo '<meta name="dateModified" content="'.esc_attr($output_meta['modified']).'" />';
    echo '<meta name="url" content="'.esc_url($output_meta['url']).'" />';
    echo '<meta name="articleSection" content="'.esc_attr($output_meta['article_section']).'" />';
    echo '<meta name="articleAuthor" content="'.esc_attr($output_meta['article_author']).'" />';
    
    echo '<meta property="article:published_time" content="'.esc_attr($output_meta['published']).'" />';
} elseif( is_post_type_archive( 'columist' )  ) {

    $output_meta['title'] = esc_html__( 'Yazarlarımız', 'kanews');
    $output_meta['description'] = esc_html__( 'Deneyimli editörlerimiz ve uzman yazarlarımızla güncel, doğru ve etkileyici haber içerikleri sunuyoruz. Ekibimizi keşfedin!', 'kanews' );
    
}

if( get_the_archive_description() ){
    $output_meta['description'] = get_the_archive_description();
}

$url = filter_var($output_meta['url'], FILTER_SANITIZE_URL); // URL'i temizle


echo '
<meta property="og:site_name" content="'.esc_attr($site_name) .'" />
<meta property="og:type" content="'.$output_meta['type'].'" />
<meta property="og:url" content="'.esc_url_raw($url).'" />';
if( is_home() || is_front_page() ) { 
echo '<meta property="og:title" content="'.esc_attr($output_meta['title']).' - '.$site_desc .'" />
<meta property="twitter:title" content="'.esc_attr($output_meta['title']).' - '.$site_desc .'" />'; 
} else {
echo '<meta property="og:title" content="'.esc_attr($output_meta['title']) .' - '.$site_name.'" />
<meta property="twitter:title" content="'.esc_attr($output_meta['title']) .' - '.$site_name.'" />'; 
}

if(isset($output_meta['description']) && $output_meta['description'] != '') {
    $output_meta['description'] = strip_tags( strip_shortcodes( $output_meta['description'] ) );
    echo '<meta property="og:description" content="'.esc_attr(wp_html_excerpt($output_meta['description'], 150, '..')).'" />';
    echo '<meta property="twitter:description" content="'.esc_attr(wp_html_excerpt($output_meta['description'], 150, '..')).'" />';
    echo '<meta name="description" content="'.esc_attr(wp_html_excerpt($output_meta['description'], 150, '..')).'" />';
}

if (is_singular() && has_post_thumbnail($post->ID) && isset($output_meta['image'][0]) && isset($output_meta['image'][0])) 
echo '<meta name="twitter:card" content="summary_large_image" />
<meta property="og:image:width" content="'.esc_attr($output_meta['image'][1]).'" />
<meta property="og:image:height" content="'.esc_attr($output_meta['image'][2]).'" />
<meta property="og:image" content="'.esc_url($output_meta['image'][0]).'" />
<meta property="twitter:image" content="'.esc_url($output_meta['image'][0]).'" />';	
elseif(isset($default_thumb['id']) && $default_thumb['url'] != '')
echo '<meta name="twitter:card" content="summary_large_image" />
<meta property="og:image:width" content="'.esc_attr($default_thumb['width']).'" />
<meta property="og:image:height" content="'.esc_attr($default_thumb['height']).'" />
<meta property="og:image" content="'.esc_url($default_thumb['url']).'" />
<meta property="twitter:image" content="'.esc_url($default_thumb['url']).'" />';
echo '
<!-- /Kanews Theme -->
';
}

/**
* Open Graph namespace
*/
add_filter('language_attributes', 'opengraph_namespace');
function opengraph_namespace( $input ){
    if( is_admin() || ( ! is_singular() && ! is_home() && ! is_front_page()) ) {
        return $input;
    }
    return $input.' prefix="og: http://ogp.me/ns#"';
}

/**
* Check Seo Plugins
*/
function check_opengraph_plugins(){

    $is_active = false;

    // Yoast SEO
    if( class_exists( 'WPSEO_Frontend' ) ){
        $yoast = get_option( 'wpseo_social' );
        if( ! empty( $yoast['opengraph'] ) ) {
            $is_active = true;
        }
    }

    // Open Graph and Twitter Card Tags
    elseif( class_exists( 'Webdados_FB' ) )
    $is_active = true;

    // Rank Math SEO
    elseif( function_exists('rank_math') )
    $is_active = true;

    return $is_active;
}
