<?php
/**
 * Template Name: Borsa
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Borsa', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$hisse = isset($_GET['hisse']) ? esc_html(strtoupper($_GET['hisse'])) : NULL;

$response = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/exchange/exchange.json");
$data = json_decode($response);

if($hisse != NULL) {

  if(empty($data) || !is_object($data) || !isset($data->$hisse->satis)) {
    wp_redirect( get_the_permalink(), 301);
    die;
  }
  
  $new_title = wp_sprintf( esc_html__('%1$s — Hisse Senedi Grafiği ve Piyasa Değeri', 'kanews'), $hisse ).' - '.get_bloginfo( 'name' );
  

  function generate_custom_title($title) {
    global $new_title;
    if($new_title)
    $title = $new_title;
    return $title;  
  }
  add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
  add_filter( 'wpseo_title', 'generate_custom_title', 15 );
}

$lang = get_locale();
if ( strlen( $lang ) > 0 ) {
$lang = explode( '_', $lang )[0];
}

get_header(); ?>
  <?php while ( have_posts() ) : the_post(); ?>

    <?php kanews_page_header($post->ID); ?>

  <?php endwhile; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
    
          <?php if($hisse == NULL) : ?>
            
            <div class="col-12">
              <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Hisse Senetleri', 'kanews' )); ?>
                <input placeholder="<?php _e('Görmek İstediğin Hisse Senetini Yaz', 'kanews'); ?>" id="kanews-currencies-search">
                <div class="kanews-scroll" style="max-height: 725px">
                  <table class="kanews-table table-search table-currencies ">
                  <thead>
                    <tr>
                      <th><span class="nobr"><?php esc_html_e( 'Menkul', 'kanews' ); ?></span></th>
                      <th><span class="nobr"><?php esc_html_e( 'Alış', 'kanews' ); ?></span></th>
                      <th><span class="nobr"><?php esc_html_e( 'Satış', 'kanews' ); ?></span></th>
                      <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                      <th><span class="nobr"><?php esc_html_e( 'Güncelleme', 'kanews' ); ?></span></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                
                    if(!empty($data)) {
                      foreach($data as $key=>$value) {
                        echo '<tr onclick="window.location=\''.kanews_get_page_link('hisse', $key, 'exchange').'\';" data-code="'. $key.'">';

                          echo '<td style="font-weight: 700"><a href="'.kanews_get_page_link('hisse', $key, 'exchange').'">'.$key.'</a></td>';
                          if(isset($value->alis)) echo '<td>'.$value->alis.'</td>';
                          if(isset($value->satis)) echo '<td>'.$value->satis.'</td>';
                          if(isset($value->degisim)) {
                            if ($value->degisim < 0) {
                              $class = 'color-danger';
                              $icon = '<i class="icon-caret icon-180deg icon-2x"></i>';
                            } else {
                              $class = 'color-success';
                              $icon = '<i class="icon-caret icon-2x"></i>';
                            }
                            echo '<td class="'.$class.'">'.$value->degisim.'</td>';
                            if(isset($value->tarih)) echo '<td>'.$value->tarih.'</td>';
                          }
                        echo '</tr>';

                      }
                    } else {
                      echo '<tr><td>'.esc_html__( 'Veri alınamadı', 'kanews' ).'</td></tr>';
                    }
                    ?>
                  </tbody>
                </table>
              </div>
              </div>
            </div>


            <div class="col-12 col-lg-8">
              <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Endeksler', 'kanews' ), 'h2'); ?>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/markets/" rel="noopener" target="_blank"><span class="blue-text">Market summary</span></a> by TradingView</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-market-quotes.js" async>
                  {
                  "width": "100%",
                  "height": "425",
                  "symbolsGroups": [
                    {
                      "name": "Indices",
                      "originalName": "Indices",
                      "symbols": [
                        {
                          "name": "CAPITALCOM:DXY",
                          "displayName": "DXY"
                        },
                        {
                          "name": "FOREXCOM:SPXUSD",
                          "displayName": "S&P 500"
                        },
                        {
                          "name": "FOREXCOM:NSXUSD",
                          "displayName": "US 100"
                        },
                        {
                          "name": "FOREXCOM:DJI",
                          "displayName": "Dow 30"
                        },
                        {
                          "name": "INDEX:NKY",
                          "displayName": "Nikkei 225"
                        },
                        {
                          "name": "INDEX:DEU40",
                          "displayName": "DAX Index"
                        },
                        {
                          "name": "FOREXCOM:UKXGBP",
                          "displayName": "UK 100"
                        },
                        {
                          "name": "BIST:XU100",
                          "displayName": "BIST 100"
                        },
                        {
                          "name": "BIST:XU050",
                          "displayName": "BIST 50"
                        },
                        {
                          "name": "BIST:XU030",
                          "displayName": "BIST 30"
                        },
                        {
                          "name": "BIST:XBANK",
                          "displayName": "BIST Banka"
                        }
                      ]
                    }
                  ],
                  "showSymbolLogo": true,
                  "colorTheme": "light",
                  "isTransparent": false,
                  "locale": "<?php echo $lang; ?>"
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
            </div>

            <div class="col-12 col-lg-4">
              <div class="kanews-section">
              <?php echo kanews_widget_title(esc_html__( 'Ekonomik Takvim', 'kanews' ), 'h2'); ?>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/economic-calendar/" rel="noopener" target="_blank"><span class="blue-text">Ekonomik takvim</span></a> TradingView tarafından</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-events.js" async>
                  {
                  "width": "100%",
                  "height": "425",
                  "colorTheme": "light",
                  "isTransparent": false,
                  "locale": "tr",
                  "importanceFilter": "0,1",
                  "currencyFilter": "USD,EUR,TRL"
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
            </div>
            <div class="col-12">
              <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Tüm piyasaları TradingView üzerinden takip edin</span></a></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-stock-heatmap.js" async>
  {
  "exchanges": [],
  "dataSource": "BIST100",
  "grouping": "sector",
  "blockSize": "market_cap_basic",
  "blockColor": "change",
  "locale": "tr",
  "symbolUrl": "",
  "colorTheme": "light",
  "hasTopBar": true,
  "isDataSetEnabled": true,
  "isZoomEnabled": true,
  "hasSymbolTooltip": true,
  "width": "100%",
  "height": "1000"
}
  </script>
</div>
<!-- TradingView Widget END -->
            </div>
    
            
            <?php while ( have_posts() ) : the_post(); 
              if ($post->post_content): ?>
                <div class="col-12">
                  <div class="kanews-article kanews-section-box kanews-article-1">
                    <div class="kanews-article-content entry-content">
                      <?php the_content(); ?>
                    </div>
                  </div>
                </div>
              <?php endif; ?>
              <?php if ( comments_open() || get_comments_number() ) : ?>
                
                <div class="col-12">
                  <?php comments_template(); ?>
                </div>
              <?php endif;?> 
            <?php endwhile; ?>

            <?php get_template_part('template-parts/content/components/related', 'page'); ?>
          <?php else: $change =  $data->$hisse->degisim; ?>

            <div class="col-12">

              <div class="single-layout-flat">
                <div class="kanews-section-box">
                  <div class="kanews-article-header p-0 mb-1">
                  <div class="d-flex align-items-center g-10 mb-1">
                    <img loading="lazy" src="https://s3-symbol-logo.tradingview.com/country/TR.svg" width="48" height="48" alt="<?php echo esc_attr($hisse); ?>" />
                    <h2 class="kanews-article-title mb-0"><?php echo $hisse; ?></h2>
                    </div>
                    <p><?php $page_desc = sprintf(esc_html__('%1$s anlık olarak %2$s fiyatından işlem görmektedir. Fiyatı son 24 saatte %3$s%% değişim göstermiştir..', 'kanews'), $hisse, currency_format_number($data->$hisse->satis).' '.esc_html__( 'Türk Lirası', 'kanews' ), $change ); echo $page_desc; ?></p>
                    
                    <div class="d-flex flex-wrap align-items-center mt-1 g-10">
                    <?php 
                    echo '<div style="font-size: 2rem">';
                    echo '<strong>'.$data->$hisse->satis.'</strong> ';
                    echo esc_html__( 'Türk Lirası', 'kanews' );
                    echo '</div>';
          
                    ?>
                    </div>
        
                  </div>

                  <div class="mt-0">
                    <ul class="row">
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Alış', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo $data->$hisse->alis; ?> <span class="currency">TRY</span></div>
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Satış', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo $data->$hisse->satis; ?> <span class="currency">TRY</span></div>
                      </li>
                      </li>
                      <li class="col-auto">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Değişim', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo $data->$hisse->degisim; ?><span class="currency">%</span></div>
                      </li>


                      <li class="col-auto">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Son Güncelleme', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo $data->$hisse->tarih; ?></div>
                      </li>
                    </ul>
                  </div>

                </div>
              </div>

              <div class="row justify-content-between no-gutters">
                <div class="kanews-tab-3">
                  <ul class="nav nav-tabs d-flex flex-wrap p-0 mb-0">
                    <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'chart', 'tradingview', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link active"><?php _e('Tradingview', 'kanews'); ?></a></li>
                    <li class="nav-item"><a href="<?php the_permalink(); ?>" class="nav-link"><?php _e('Diğer Hisselere Göz At', 'kanews'); ?></a></li>
                  </ul>
                </div>
              </div>
            
              <div class="kanews-section" style="overflow:hidden">
                <div class="p-1 text-center"><i class="icon-unlock"></i> <?php esc_html_e( 'Grafikler son kapanışı temsil etmektedir.', 'kanews' ); ?></div>
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div id="tradingview_12510"></div>
                  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/symbols/<?php echo $hisse; ?>?exchange=BIST" rel="noopener" target="_blank"><span class="blue-text"><?php echo $hisse; ?> Chart</span></a> by TradingView</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
                  <script type="text/javascript">
                  new TradingView.widget(
                  {
                    "width": 1170,
                    "height": 610,
                    "symbol": "BIST:<?php echo $hisse; ?>",
                    "timezone": "Europe/Istanbul",
                    "interval": "D",
                    "theme": "light",
                    "style": "1",
                    "locale": "tr",
                    "toolbar_bg": "#ccc",
                    "enable_publishing": false,
                    "hide_top_toolbar": false,
                    "withdateranges": false,
                    "details": true,
                    "hide_side_toolbar": false,
                    "allow_symbol_change": true,
                    "show_popup_button": true,
                    "studies": [
                      // "MACD@tv-basicstudies",
                      "RSI@tv-basicstudies"
                    ],
                    "hotlist": true,
                    "popup_width": "1000",
                    "popup_height": "650",
                    "container_id": "tradingview_e8ead",
                    "isTransparent": false,
                  }
                  );
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>

              <div class="kanews-section">
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text">Tüm piyasaları TradingView üzerinden takip edin</span></a></div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-financials.js" async>
                  {
                    "colorTheme": "light",
                    "isTransparent": false,
                    "largeChartUrl": "<?php the_permalink(); ?>?hisse={tvsymbol}",
                    "displayMode": "regular",
                    "width": "100%",
                    "height": "625",
                    "symbol": "BIST:<?php echo $hisse; ?>",
                    "locale": "tr"
                  }
                  </script>
                </div>
                <!-- TradingView Widget END -->
              </div>
        
              <?php get_template_part('template-parts/content/components/related', 'page2', array( 
                'posts_per_page' => 10,
                's' => $hisse 
              ) ); ?>

            </div>

            <script>
              document.getElementsByTagName('title')[0].innerHTML = "<?php echo $new_title; ?>";
              document.getElementsByTagName('meta')["description"].content = "<?php echo $page_desc; ?>";
            </script>
          <?php endif; ?>

        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();
