<?php
/**
 * Template Name: Emtia
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Emtia', 'kanews' );
wp_enqueue_script('kanews-calculator');

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

$emtia = isset($_GET['emtia']) ? esc_html($_GET['emtia']) : NULL;

$response = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/gold/gold.json");
$data = json_decode($response, true);

if(isset($data['data']) ) {
  $last_update_date  = $data['lastUpdate']['formatted'];
  $data = $data['data'];
  $data['Update_Date'] = $last_update_date;
}


if($emtia != NULL) {

  $emtia_name = ucwords(str_replace("-", " ", $data[strtoupper($emtia)]['Name']));

  if(empty($data) || !is_array($data) || !isset($data['Update_Date']) || !isset($data[strtoupper($emtia)]) ) {
    wp_redirect( get_the_permalink(), 301);
    die;
  }
  
  $new_title = wp_sprintf( esc_html__('%1$s Ne Kadar, Kaç TL?', 'kanews'), $emtia_name ).' - '.get_bloginfo( 'name' );

  function generate_custom_title($title) {
    global $new_title;
    if($new_title)
    $title = $new_title;
    return $title;  
  }
  add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
  add_filter( 'wpseo_title', 'generate_custom_title', 15 );
}

get_header(); ?>
  <?php if( $emtia == NULL ): while ( have_posts() ) : the_post(); ?>
    <?php kanews_page_header($post->ID); ?>
  <?php endwhile; endif; ?>
  <?php do_action('kanews_header_ad'); ?>
  <main id="main" class="site-main">
    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>
          <?php 
          
          
          if($emtia != NULL && isset($data[strtoupper($emtia)]) && is_numeric($data[strtoupper($emtia)]['Buying']) ): 
       
            $emtia_selling = $data[strtoupper($emtia)]['Selling'];
            $emtia_buying = $data[strtoupper($emtia)]['Buying'];
            $emtia_change = $data[strtoupper($emtia)]['Change'];
            ?>
            <div class="col-12 kanews-flat-breadcrumb mb-1">
            <?php kanews_breadcrumb(get_the_ID()); ?>
            </div>
            <div class="col-12 col-lg-8">
              <div class="kanews-section p-1">
                <div class="kanews-xpage-header d-flex justify-content-between align-items-center">
                  <h1 class="mb-0">
                  <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"><g fill="none"><circle cx="16" cy="16" r="16" fill="#F1B32B"/><path d="M15.75 4C9.26 4 4 9.26 4 15.75S9.26 27.5 15.75 27.5 27.5 22.24 27.5 15.75A11.75 11.75 0 0015.75 4zm0 20.57a8.82 8.82 0 110-17.64 8.82 8.82 0 010 17.64zm-2.93-8.81l2.94 4.4 2.92-4.4-2.92-4.41-2.94 4.41z" fill="#FFF"/></g></svg>  
                  <?php echo esc_html($emtia_name); ?></h1>
                  <?php kanews_post_share(get_the_ID(), 4);?>
                </div>
                <div class="kanews-xpage-top">
                  <div class="mt-0">
                    <ul class="row">
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Alış', 'kanews' ); ?> (TL)</div>
                        <div class="kanews-mgfsa141 <?php echo ( $emtia_change > 0 ) ? 'color-success' : 'color-danger'; ?>"><?php echo $emtia_buying; ?> TL</div>
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Satış', 'kanews' ); ?> (TL)</div>
                        <div class="kanews-mgfsa141 <?php echo ( $emtia_change > 0 ) ? 'color-success' : 'color-danger'; ?>"><?php echo $emtia_selling; ?> TL</div>
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Değişim', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141 <?php echo ( $emtia_change > 0 ) ? 'color-success' : 'color-danger'; ?>"><?php echo $emtia_change ?> %</div>
                      </li>
                      <li class="col-auto">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Son Güncelleme', 'kanews' ); ?> </div>
                        <div class="kanews-mgfsa141"><?php echo $data['Update_Date']; ?></div>
                      </li>
                    </ul>
                  </div>
                  <p><?php $page_desc = sprintf(esc_html__('%1$s anlık olarak %2$s fiyatından işlem görmektedir. Fiyatı son 24 saatte %3$s%% değişim göstermiştir..', 'kanews'), $emtia_name, currency_format_number($emtia_selling).' TL', currency_format_number($emtia_change) ); echo $page_desc; ?></p>

                </div>
  
              </div>
              <div class="kanews-section kanews-section-shortcode">
                <?php echo kanews_widget_title(esc_html__( 'Altın Çevirici', 'kanews' ), 'h2'); ?>
                <?php echo do_shortcode( '[kanews-calculator tur="emtia" show_tabs="true" exclude_types="burc,vki"]' ); ?>
              </div>

              <div class="kanews-section kanews-section-flat">
                  <div class="kanews-section-box">
                    <div class="kanews-article-content entry-content">
                      <div class="entry-content-wrapper">
                        <div class="entry-content-inner" id="glkj1">
                          <h2><?php echo sprintf(esc_html__('1 %1$s ne kadar? 1 %1$s  bugün kaç TL?', 'kanews'), $emtia_name); ?></h2>
                          <p><?php echo sprintf(esc_html__('Güncel verilere göre, %1$s alış fiyatı %2$s, satış fiyatı ise %3$s olarak belirlenmiştir. Bu fiyatlar, %4$s itibarıyla güncellenmiştir ve 15 dakikada bir yenilenerek canlı rakamlarla sunulmaktadır. %1$s fiyatları hakkında anlık bilgilere erişmek için %1$s sayfasını ziyaret edebilirsiniz.', 'kanews'), $emtia_name, currency_format_number($emtia_buying).' TL', currency_format_number($emtia_selling), $data['Update_Date'] ); ?></p>

                          <?php if ($emtia_change < 0): ?>
                          <h3><?php echo sprintf(esc_html__('%s (%s) fiyatı bugün yükseldi.', 'kanews'), $emtia_name, 'TL'); ?></h3>
                          <?php else: ?>
                          <h3><?php echo sprintf(esc_html__('%s (%s) fiyatı bugün düştü.', 'kanews'), $emtia_name, 'TL'); ?></h3>
                          <?php endif; ?>
                          <p><?php echo sprintf(esc_html__('%1$s anlık olarak %2$s fiyatından işlem görmektedir ve 24 saatlik yaklaşık işlem hacmi %3$s. Fiyatı son 24 saatte %4$s değişim göstermiştir..', 'kanews'), $emtia_name, currency_format_number($emtia_selling).' TL', 0, currency_format_number($emtia_change) ); ?></p>
                          <p><?php echo sprintf(esc_html__('%1$s hesaplama işlemleri için, sayfanın üstünde yer alan çevirici aracını kullanarak mevcut fiyatlar üzerinden hızlı ve kolay bir şekilde çevirme işlemlerinizi gerçekleştirebilirsiniz. %1$s fiyatları hakkında detaylı bilgi ve anlık güncellemeler için doğru adrestesiniz..', 'kanews'), $emtia_name ); ?></p>
                          <ul>
                          <li><a href="<?php echo kanews_get_page_link('emtia', 'gra', 'emtia'); ?>">1 Gram Altın Ne Kadar 1 Gram Altın Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('emtia', 'cey', 'emtia'); ?>">1 Çeyrek Altın Ne Kadar 1 Gram Altın Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('emtia', 'tam', 'emtia'); ?>">1 Tam Altın Ne Kadar 1 Gram Altın Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('emtia', 'cum', 'emtia'); ?>">1 Cumhuriyet Altın Ne Kadar 1 Gram Altın Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('emtia', 'ons', 'emtia'); ?>">1 Ons Altın Ne Kadar 1 Tam Altın Kaç TL ?</a></li>
                          <li><a href="<?php echo kanews_get_page_link('emtia', 'yia', 'emtia'); ?>">1 Bilezik Ne Kadar 1 Bilezik Kaç TL ?</a></li>
                          </ul>
                          <div class="css-17eoayh"></div>
                        </div>
                        <p class="css-15q1ax4" role="button"><?php esc_html_e( 'Daha Fazla', 'kanews' ); ?><svg viewBox="0 0 24 24" focusable="false" class="chakra-icon css-2yee4i"><path fill="currentColor" d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path></svg></p>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Altın Fiyatları', 'kanews' ), 'h3'); ?>

              <table class="kanews-table table-currencies">
                <thead>
                  <tr>
                    <th><span class="nobr"><?php esc_html_e( 'Altın', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Alış', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Satış', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                    <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Saat', 'kanews' ); ?></span></th>
                  </tr>
                </thead>
                <tbody>
                  <?php
              
                  if(!empty($data)) {
                    $counter = 0;
                    foreach($data as $key=>$value) {
                      if(isset($value['Selling']) && isset($value['Buying'])) {
                        $name = ucwords(str_replace("-", " ", $key));
                        echo '<tr onclick="window.location=\''.kanews_get_page_link('emtia', strtolower($name), 'emtia').'\';">';
                        
                        $search  = array('ONS', 'GRA', 'CEY', 'YAR', 'TAM', 'CUM', 'ATA', 'RES', 'HAM', 'IKI', 'GRE', 'BES', 'ODA', 'OSA', 'YIA', 'GUM' );
                        $replace = array('ONS Altın ', 'Gram Altın', 'Çeyrek Altın', 'Yarım Altın', 'Tam Altın', 'Cumhuriyet Altın', 'Ata Altın', 'Reşat Altın', 'Hamit Altın', 'İkibuçuk Altın', 'Gremse Altın', 'Beşli Altın', '14 Ayar Altın', '18 Ayar Altın', '22 Ayar Altın', 'Gümüş Gram');
        
                        echo '<td><a href="'.kanews_get_page_link('emtia', strtolower($name), 'emtia').'">'.str_replace($search, $replace, $name).'</a></td>';
                        echo '<td>'.$value['Buying'].'</td>';
                        echo '<td>'.$value['Selling'].'</td>';
                        if(isset($value['Change'])) {
                          if (substr($value['Change'], 1) < 0) {
                            $class = 'color-danger';
                            $icon = '<i class="icon-caret icon-180deg icon-2x"></i>';
                          } else {
                            $class = 'color-success';
                            $icon = '<i class="icon-caret icon-2x"></i>';
                          }
                          echo '<td class="'.$class.'">'.$icon.$value['Change'].'%</td>';
                        }
                        if(isset($data['Update_Date']))
                        echo '<td class="hidden-mobile">'.$data['Update_Date'].'</td>';
                      echo '</tr>';
                      }
                    }
                  } else {
                    echo '<tr><td>'.esc_html__( ('Veri alınamadı'), 'kanews' ).'</td></tr>';
                  }
                  ?>
                </tbody>
              </table>
            </div>

            </div>
            
          <?php else: ?>
          <div class="col-12 col-lg-8">
            <div class="kanews-section">
            <?php echo kanews_widget_title(esc_html__( 'Altın Fiyatları', 'kanews' ), 'h2'); ?>
              <table class="kanews-table table-currencies">
                <thead>
                  <tr>
                    <th><span class="nobr"><?php esc_html_e( 'Altın', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Alış', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Satış', 'kanews' ); ?></span></th>
                    <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                    <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Saat', 'kanews' ); ?></span></th>
                  </tr>
                </thead>
                <tbody>
                  <?php
              
                  if(!empty($data)) {
                    $counter = 0;
                    foreach($data as $key=>$value) {
                      if(isset($value['Selling']) && isset($value['Buying'])) {
                        echo '<tr onclick="window.location=\''.kanews_get_page_link('emtia', strtolower($key), 'emtia').'\';">';
                        $name = ucwords(str_replace("-", " ", $key));
                        $search  = array('ONS', 'GRA', 'CEY', 'YAR', 'TAM', 'CUM', 'ATA', 'RES', 'HAM', 'IKI', 'GRE', 'BES', 'ODA', 'OSA', 'YIA', 'GUM' );
                        $replace = array('ONS Altın ', 'Gram Altın', 'Çeyrek Altın', 'Yarım Altın', 'Tam Altın', 'Cumhuriyet Altın', 'Ata Altın', 'Reşat Altın', 'Hamit Altın', 'İkibuçuk Altın', 'Gremse Altın', 'Beşli Altın', '14 Ayar Altın', '18 Ayar Altın', '22 Ayar Altın', 'Gümüş Gram');
        
                          echo '<td><a href="'.kanews_get_page_link('emtia', strtolower($key), 'emtia').'">'.str_replace($search, $replace, $name).'</a></td>';
                        echo '<td>'.$value['Buying'].'</td>';
                        echo '<td>'.$value['Selling'].'</td>';
                        if(isset($value['Change'])) {
                          if (substr($value['Change'], 1) < 0) {
                            $class = 'color-danger';
                            $icon = '<i class="icon-caret icon-180deg icon-2x"></i>';
                          } else {
                            $class = 'color-success';
                            $icon = '<i class="icon-caret icon-2x"></i>';
                          }
                          echo '<td class="'.$class.'">'.$icon.$value['Change'].'%</td>';
                        }
                        if(isset($data['Update_Date']))
                        echo '<td class="hidden-mobile">'.$data['Update_Date'].'</td>';
                      echo '</tr>';
                      }
                    }
                  } else {
                    echo '<tr><td>'.esc_html__( ('Veri alınamadı'), 'kanews' ).'</td></tr>';
                  }
                  ?>
                </tbody>
              </table>
            </div>
          </div>
          <?php endif; ?>

          <div id="sidebar" class="col-12 col-lg-4">
              <?php get_sidebar('xpage'); ?>
          </div>
          
          <?php get_template_part('template-parts/content/components/related', 'page'); ?>
          
          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-box kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
            <?php if ( comments_open() || get_comments_number() ) : ?>
              
              <div class="col-12">
                <?php comments_template(); ?>
              </div>
            <?php endif;?> 
          <?php endwhile; ?>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();
