<?php
/**
 * Template Name: Nöbetçi Eczaneler Yedek
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Nöbetçi Eczaneler Yedek', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly

$region = (isset($_GET['sehir']) &&  $_GET['sehir'] != 'null' && !empty($_GET['sehir'])) ? ucwords($_GET['sehir']) : kanews_get_option('eczane-page-city', 'Ankara');
$city = (isset($_GET['ilce']) && $_GET['ilce'] != 'null' && !empty($_GET['ilce'])) ? ucwords($_GET['ilce']) : kanews_get_option('eczane-page-city2');
if( !isset($_GET['ilce']) && isset($_GET['sehir']) && !empty(kanews_get_option('eczane-page-city2')) )
$city = '';

$new_region = $region;
if( empty($city) )
$city = $region;

$date = date('Y-m-d');

$response = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/turkiye.json");
$data2 = json_decode($response, true);
if( isset($data2['status']) && $data2['status'] == 'OK' ) { 
  foreach(  $data2['data'] as $key => $value ) {
    if( kanews_seflink($value['name']) == kanews_seflink($region)  ) {
      $new_region = esc_html($value['name']);
      break;
    }
  }
}

$plaka = kanews_get_plaka($new_region)-1;


if( $city != '' && $region != $city ) {
$title = wp_sprintf( esc_html__('%1$s Nöbetçi Eczaneler - %2$s', 'kanews'), $city, $new_region );
$new_title = $title.' - '.get_bloginfo( 'name' );
} else {
$title = wp_sprintf( esc_html__('%1$s Nöbetçi Eczaneler', 'kanews'), $new_region );
$new_title = $title.' - '.get_bloginfo( 'name' );
}
function generate_custom_title($title) {
global $new_title;
if($new_title)
$title = $new_title;
return $title;  
}
add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );

get_header(); ?>

  <?php while ( have_posts() ) : the_post(); ?>
    <div class="kanews-page-header">
      <div class="container">
        <div class="row align-items-center justify-space-between mb-1">
        <?php if( kanews_get_option('breadcrumb') ) : ?>
					<div class="col-12 kanews-flat-breadcrumb mb-1">
            <?php kanews_breadcrumb(get_the_ID()); ?>
					</div>
        <?php endif; ?>
          <div class="col">
            <h1 class="kanews-page-title"><img style="vertical-align: -4px;" src="<?php echo get_template_directory_uri(  ); ?>/assets/img/static/eczane.jpg" loading="lazy" width="32" height="32" alt="e"> <?php echo esc_html($title); ?></h1>
            <p><?php echo wp_sprintf( __('%1$s nöbetçi eczanelerini hızlıca bulun! Güncel adres, telefon ve konum bilgileriyle ihtiyaçlarınıza anında ulaşın.', 'kanews'), ucfirst($title) ); ?></p>
          </div>
          <div class="col-auto">
            <?php 
            if( isset($data2['status']) && $data2['status'] == 'OK' ) {
              $out = '';
            echo '<div class="kanews-btn kanews-btn-light m-0" data-toggle="kanews-city-search">'.esc_html($new_region).' <i class="icon-caret icon-180deg"></i></div>';
              $out .= '<div id="kanews-city-search" class="kanews-search-cities kanews-scroll">';
              $out .= '<input placeholder="'.esc_html__( 'Şehir ara', 'kanews' ).'" id="kanews-search-input" />';
            
                foreach( $data2['data'] as $key => $value ) {
                  $out .= '<a href="'.esc_url( add_query_arg( array('sehir' => kanews_seflink($value['name']) ), get_the_permalink()) ).'" class="kanews-search-city" data-city="'.esc_attr($value['name']).'">'.esc_html($value['name']).'</a>';
                }
                $out .= '</div>';
                echo $out;
              }
              ?>
          </div>
		  
        </div>
		<div class="row">
          <div class="col-12">
            <div id="ilceler" class="kanews-label-group">
              <?php 
            
        
              if( isset($data2['status']) && $data2['status'] == 'OK' ) {
                echo '<a class="kanews-label is-active" href="'.esc_url( add_query_arg( array('sehir' => kanews_seflink($data2['data'][$plaka]['name'])), get_permalink() ) ).'">'.esc_html__( 'Tümü', 'kanews' ).'</a>';

                foreach($data2['data'][$plaka]['districts'] as $key => $value) {
                  echo '<a class="kanews-label kanews-label-light border-white color-white" href="'.esc_url( add_query_arg( array('sehir' => kanews_seflink($data2['data'][$plaka]['name']), 'ilce' => kanews_seflink($value['name'])), get_permalink() ) ).'">'.$value['name'].'</a>';
                }
              }
              ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endwhile; ?>

  <?php do_action('kanews_header_ad'); ?>

  <main id="main" class="site-main">

    <div class="container">
      <div class="row">
        <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): 
		
		$plaka = kanews_get_plaka($region);?>

          <div class="col-12">
          <div class="kanews-section">
			<div class="pharmacy-container"></div> <script> const pharmacyiFrame = { "color1":"00d2d3", "color2":"17a2b8", "city":"<?php echo urlencode(strtolower($region)); ?>", "county":"<?php echo ($region == $city) ? '' : urlencode(strtolower($city)); ?>", "type":"default-iframe", "width":"100%", "height":768 }; </script> 
			<script>
			function setCookie(e,t,a){var r=new Date;r.setTime(r.getTime()+36e5*a);var i="expires="+r.toUTCString();document.cookie=e+"="+t+";"+i+";domain=."+window.location.hostname+";path=/"}function getCookie(e){for(var t=e+"=",a=decodeURIComponent(document.cookie).split(";"),r=0;r<a.length;r++){for(var i=a[r];" "===i.charAt(0);)i=i.substring(1);if(0===i.indexOf(t))return i.substring(t.length,i.length)}return!1}const baseUrl="https://eczaneleri.net/api/new-iframe";let color1,color2,city,county,type,width,height;city=""!=pharmacyiFrame.city?pharmacyiFrame.city:"",county=""!=pharmacyiFrame.county&&"null"!=pharmacyiFrame.county?pharmacyiFrame.county:"",color1=pharmacyiFrame.color1??"00d2d3",color2=pharmacyiFrame.color2??"17a2b8",type=pharmacyiFrame.type??"default-iframe",width=pharmacyiFrame.width>=295&&pharmacyiFrame.width<=350?`${pharmacyiFrame.width}px`:"100%",height=pharmacyiFrame.height??"500";let countyUrl=""!=county?county+"-nobetci-eczaneleri":"";const followDomain=""!=city?`https://${city}.eczaneleri.net/${countyUrl}`:"https://eczaneleri.net/",customHeader=`<a href="#" class="pharmacy-text-a" title="Nöbetçi Eczane"><div class="pharmacy-text"><span>E</span><span>Nöbetçi Eczane</span></div></a>`,customHeaderCss=`a.pharmacy-text-a{display:inline;text-decoration:none;color:transparent}.pharmacy-text{width:100%;height:50px;background-color:red;display:flex;align-items:center;justify-content:center;padding:0 5px}.pharmacy-text span:first-child{flex:0.3;font-size:3rem;font-weight:bolder;color:red;background-color:#fff;line-height:45px;padding:0 3px;margin-right:3px;border-radius:2px}.pharmacy-text span:last-child{text-align:center;flex:16;font-size:2.1vh;font-weight:bolder;color:#fff;line-height:45px;padding:0 3px}border:2px solid #${color1};`,head=document.head||document.getElementsByTagName("head")[0],headerStyleElement=document.createElement("style");if(headerStyleElement.innerHTML=customHeaderCss,head.appendChild(headerStyleElement),"default-iframe"==type){let e=customHeader;e+='<iframe id="default-iframe" src="'+(baseUrl+`?type=${type}&city=${city}&county=${county}&color1=${color1}&color2=${color2}`)+'" frameborder="0" style="width:100%;height:100%;"></iframe>';const t=document.querySelector(".pharmacy-container");t.style.width=width,t.style.height=`${height}px`,t.style.padding="0 0 15px 0",t.style.overflow="hidden",t.style.fontFamily="sans-serif",t.innerHTML=e}if("map-iframe"==type){let e=customHeader;e+='<iframe id="map-iframe" src="'+(baseUrl+`?type=${type}&city=${city}&county=${county}&color1=${color1}`)+'" frameborder="0" style="width:100%;height:100%;"></iframe>';const t=document.querySelector(".pharmacy-container");t.style.width=width,t.style.height=`${height}px`,t.style.padding="0 0 15px 0",t.style.overflow="hidden",t.style.fontFamily="sans-serif",t.innerHTML=e}let refDomain=window.location.href;if(!getCookie("refDomain")){let e=new FormData;e.append("widgetRefDomain","1"),e.append("ref",refDomain),fetch("https://eczaneleri.net/api/ajax",{method:"POST",headers:{},body:e}).then((e=>{setCookie("refDomain","refDomain",720)}))}
			</script> 

          </div>
          </div>

          <?php get_template_part('template-parts/content/components/related', 'page'); ?>
          
          <?php while ( have_posts() ) : the_post(); 
            if ($post->post_content): ?>
              <div class="col-12">
                <div class="kanews-article kanews-section-box kanews-article-1">
                  <div class="kanews-article-content entry-content">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
            <?php endif; ?>
            <?php if ( comments_open() || get_comments_number() ) : ?>
              <div class="col-12">
                <?php comments_template(); ?>
              </div>
            <?php endif;?> 
          <?php endwhile; ?>
        <?php else: ?>
          <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
        <?php endif; ?>

      </div>
    </div>
  </main>
<?php get_footer();
