<?php 
global $current_user, $wp_roles;
wp_get_current_user();
?>

<h2 class="kanews-custom-page-title"><?php esc_html_e( 'Profilimi Düzenle', 'kanews' ); ?></h2>
<p class="mb-3"><?php esc_html_e( 'Bu sayfada görünür adınızı belirleyebilir, kullanıcı fotoğrafı yükleyebilir ve şifrenizi güncelleyebilirsiniz.', 'kanews' ); ?></p>

<form id="kanews-profile-form" autocomplete="off">

  <div class="row">

    <div class="col-12 col-md-6 mb-1">
      <div class="kanews-form">      
        <input type="text" id="first-name" name="first-name" value="<?php echo esc_attr(get_the_author_meta( 'first_name', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Adın', 'kanews'); ?></label>
      </div>
    </div>

    <div class="col-12 col-md-6 mb-1">
      <div class="kanews-form">      
        <input type="text" id="last-name" name="last-name" value="<?php echo esc_attr(get_the_author_meta( 'last_name', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Soyadın', 'kanews'); ?></label>
      </div>
    </div>

    <div class="col-12 col-md-6 mb-1">
      <div class="kanews-form">      
        <input type="text" id="username_disable" name="username_disable" value="<?php echo esc_attr(get_the_author_meta( 'user_nicename', $current_user->ID )); ?>" disabled>
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Kullanıcı Adın', 'kanews'); ?></label>
      </div>
    </div>

    <div class="col-12 col-md-6 mb-1">
      <div class="kanews-form">      
        <input type="text" id="nickname" name="nickname" value="<?php echo esc_attr(get_the_author_meta( 'nickname', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Takma Adın', 'kanews'); ?></label>
      </div>
    </div>

    <div class="col-12 mb-1">
      <div class="kanews-form">      
        <select name="display_name" id="display_name"><br/>
          <?php
            $public_display = array();
            $public_display['display_nickname']  = $current_user->nickname;
            $public_display['display_username']  = $current_user->user_login;

            if ( !empty($current_user->first_name) )
              $public_display['display_firstname'] = $current_user->first_name;

            if ( !empty($current_user->last_name) )
              $public_display['display_lastname'] = $current_user->last_name;

            if ( !empty($current_user->first_name) && !empty($current_user->last_name) ) {
              $public_display['display_firstlast'] = $current_user->first_name . ' ' . $current_user->last_name;
              $public_display['display_lastfirst'] = $current_user->last_name . ' ' . $current_user->first_name;
            }

            if ( ! in_array( $current_user->display_name, $public_display ) ) // Only add this if it isn't duplicated elsewhere
              $public_display = array( 'display_displayname' => $current_user->display_name ) + $public_display;

            $public_display = array_map( 'trim', $public_display );
            $public_display = array_unique( $public_display );

            foreach ( $public_display as $id => $item ) {
          ?>
            <option <?php selected( $current_user->display_name, $item ); ?>><?php echo $item; ?></option>
          <?php
            }
          ?>
        </select>
        <span class="bar"></span>
        <label><?php _e('Görünecek Adın', 'kanews'); ?></label>
      </div>
    </div>

    <div class="col-12 b-1">
      <div class="kanews-form">      
        <textarea rows="3" id="description" name="description"><?php echo esc_attr(get_the_author_meta( 'description', $current_user->ID )); ?></textarea>
        <label><?php _e('Biyografik bilgi', 'kanews'); ?></label>
      </div>
    </div>

    <div class="col-12 b-1">
      <div class="kanews-form">      
        <input type="text" id="my_city" name="my_city" value="<?php echo esc_attr(get_the_author_meta( 'my_city', $current_user->ID )); ?>">
        <label><?php _e('Şehriniz', 'kanews'); ?></label>
      </div>
    </div>
    
    <div class="col-12"><h3 class="kanews-custom-page-subtitle mb-2 mt-1"><?php esc_html_e( 'Hesap Bilgileriniz', 'kanews' ); ?></h3></div>

    <div class="col-12 mb-1">
      <div class="kanews-form">      
        <input type="email" id="email" name="email" value="<?php echo esc_attr(get_the_author_meta( 'user_email', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('E-Posta Adresiniz', 'kanews'); ?></label>
      </div>
    </div>

    <div class="col-12 col-md-6">
      <div class="kanews-form">      
        <input type="password" id="pass1" name="pass1" value>
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Şifreniz', 'kanews'); ?></label>
      </div>
    </div>
    <div class="col-12 col-md-6">
      <div class="kanews-form">      
        <input type="password" id="pass2" name="pass2" value>
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Şifrenizi Tekrarlayın', 'kanews'); ?></label>
      </div>
    </div>

    <div class="col-12"><h3 class="kanews-custom-page-subtitle mb-2 mt-1"><?php esc_html_e( 'Sosyal Medya', 'kanews' ); ?></h3></div>

    <div class="col-12 col-md-6 mb-1 ">
      <div class="kanews-form">      
        <input type="text" id="facebook_profile" name="facebook_profile" value="<?php echo esc_attr(get_the_author_meta( 'facebook_profile', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Facebook Kullanıcı Adınız', 'kanews'); ?></label>
      </div>
    </div>
    <div class="col-12 col-md-6 mb-1 ">
      <div class="kanews-form">      
        <input type="text" id="twitter_profile" name="twitter_profile" value="<?php echo esc_attr(get_the_author_meta( 'twitter_profile', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Twitter Kullanıcı Adınız', 'kanews'); ?></label>
      </div>
    </div>
    <div class="col-12 col-md-6 mb-1 ">
      <div class="kanews-form">      
        <input type="text" id="instagram_profile" name="instagram_profile" value="<?php echo esc_attr(get_the_author_meta( 'instagram_profile', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Instagram Kullanıcı Adınız', 'kanews'); ?></label>
      </div>
    </div>
    <div class="col-12 col-md-6 mb-1 ">
      <div class="kanews-form">      
        <input type="text" id="linkedin_profile" name="linkedin_profile" value="<?php echo esc_attr(get_the_author_meta( 'linkedin_profile', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Linkedin Kullanıcı Adınız', 'kanews'); ?></label>
      </div>
    </div>
    <div class="col-12 col-md-6 mb-1 ">
      <div class="kanews-form">      
        <input type="text" id="youtube_profile" name="youtube_profile" value="<?php echo esc_attr(get_the_author_meta( 'youtube_profile', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Youtube Kanal idsi', 'kanews'); ?></label>
      </div>
    </div>
    <div class="col-12 col-md-6 mb-1 ">
      <div class="kanews-form">      
        <input type="text" id="telegram_profile" name="telegram_profile" value="<?php echo esc_attr(get_the_author_meta( 'telegram_profile', $current_user->ID )); ?>">
        <span class="highlight"></span>
        <span class="bar"></span>
        <label><?php _e('Telegram Kullanıcı Adınız', 'kanews'); ?></label>
      </div>
    </div>

    <?php echo kanews_get_recaptcha('registration_form'); ?>

    <div class="col-12">
      <button class="kanews-btn" type="submit"><?php esc_html_e( 'Profilimi Güncelle', 'kanews' ); ?> <div id="kanews-loader"></div></button>
      <?php wp_nonce_field( 'profile_action', 'profile_field' ); ?>
    </div>

  </div>
</form>