<?php
/**
 * Dashboard Follow Template
 * 
 * Displays user's category follow settings in the dashboard
 */

// Add custom styles for the toggle switch
?>
<style>
input[type=checkbox]{
	height: 0;
	width: 0;
	visibility: hidden;
}

input[type=checkbox]+label {
	cursor: pointer;
	text-indent: -9999px;
	width: 60px;
	height: 30px;
	background: grey;
	display: block;
	border-radius: 100px;
  overflow: hidden;
	position: relative;
}

input[type=checkbox]+label:after {
	content: '';
	position: absolute;
	top: 5px;
	left: 5px;
	width: 20px;
	height:20px;
	background: #fff;
	border-radius: 90px;
	transition: 0.3s;
}

input:checked + label {
	background: #bada55;
}

input[type=checkbox]:checked + label:after {
	left: calc(100% - 5px);
	transform: translateX(-100%);
}

</style>

<?php 
// Get notification settings
$notification_enabled = get_user_option('kanews_mail_notification', get_current_user_id());
?>

<h2 class="kanews-custom-page-title mb-1"><?php echo kanews_translate('feed-title', esc_html__('Takip Et', 'kanews')); ?></h2>
<p class="mb-3"><?php echo sprintf(esc_html__('%1$s üzerinde çeşiti kategorileri takip edebilirsiniz. Böylelikle takip ettiğiniz kategorilerde yeni bir içerik paylaşıldığında anında haberdar olabilirsiniz. Aşağıdaki kısımlardan takip ettiğiniz kategorileri yönetebilirsiniz.', 'kanews'), get_bloginfo('name')); ?></p>

<h3 class="kanews-custom-page-title mb-1"><?php esc_html_e('Bildirim Ayarları', 'kanews'); ?></h3>
<label for="switch"><?php esc_html_e('E-Posta Bildirimleri', 'kanews'); ?></label>
<form style="margin-top: -15px" class="mb-2" action="<?php the_permalink(); ?>?islem=takip" method="post" enctype="multipart/form-data">
  <input <?php if ($notification_enabled != 'false') { echo 'checked'; } ?> type="checkbox" id="switch" name="switch" onChange="this.form.submit()" /><label class="mb-0" for="switch"></label>
</form>

<?php 
// Get user's subscribed categories
$user_cats = get_user_option('kanews_subscribe_category', get_current_user_id()) ? get_user_option('kanews_subscribe_category', get_current_user_id()) : array('');
$categories = get_categories(array(
  'orderby' => 'count',
  'order'   => 'ASC'
));

// Display subscribed categories
echo '<h3 class="kanews-custom-page-title mb-1">' . esc_html__('Takip Ettiklerim', 'kanews') . '</h3>';
$subscribed_count = 0;
echo '<div class="kanews-subs-section m-0">';
echo '<div class="kanews-category-subscribe-wrapper">';
foreach ($categories as $category) {
  if (in_array($category->term_id, $user_cats)) {
    echo '<a class="kanews-category-subscribe-button hf1s category-subscribed" data-cat-id="' . esc_attr($category->term_id) . '" onclick="doSomething()">' . esc_html($category->name) . ' <div class="check"></div> <div id="kanews-loader"></div></a>';
    $subscribed_count++;
  }
}
echo '</div>';
echo '</div>';

if ($subscribed_count < 1) {
  echo '<p>' . esc_html__('Henüz bir kategori takip etmiyorsunuz.', 'kanews') . '</p>';
}

// Display available categories to subscribe
echo '<h3 class="kanews-custom-page-title mb-1 mt-1">' . esc_html__('Takip Edebilecekleriniz', 'kanews') . '</h3>';
echo '<div class="kanews-subs-section m-0">';
echo '<div class="kanews-category-subscribe-wrapper">';
foreach ($categories as $category) {
  if (!in_array($category->term_id, $user_cats)) {
    echo '<a class="kanews-category-subscribe-button hf1s" data-cat-id="' . esc_attr($category->term_id) . '" onclick="doSomething()">' . esc_html($category->name) . ' <div class="check"></div> <div id="kanews-loader"></div></a>';
  }
}
echo '</div>';
echo '</div>';
?>

