<?php 
/**
 * Dashboard Comments Template
 * 
 * Displays user's comments in the dashboard
 */

// Get current user information
global $current_user, $wp_roles;
wp_get_current_user();
?>
<h2 class="kanews-custom-page-title mb-1"><?php esc_html_e( 'Yorumlarım', 'kanews' ); ?></h2>
<?php 
// Pagination settings
$comments_per_page = 10;
$all_comments_approved = kanews_get_comments_count_by_user($current_user->ID);
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$offset = (($paged-1) * $comments_per_page);
$max_num_pages = ceil($all_comments_approved / $comments_per_page);

// Query arguments for user comments
$args = array(
  'user_id'      => $current_user->ID,
  'status'       => 'approve',
  'post_status'  => 'publish',
  'number'       => $comments_per_page,
  'offset'       => $offset,
  'post_type'    => 'post'
);

// Get user comments
$comments_query = new WP_Comment_Query;
$comments = $comments_query->query($args);

if ($comments) : ?>
  <?php foreach ($comments as $comment) : ?>
    <div class="kanews-post-item">
      <div class="kanews-post-content flex-wrap">
        <div class="kanews-comment-item">
          <?php 
          // Create comment link with proper escaping
          $post_permalink = get_the_permalink($comment->comment_post_ID);
          $post_title = get_the_title($comment->comment_post_ID);
          $comment_link = $post_permalink . '#comment' . $comment->comment_ID;
          
          printf(
            esc_html__('%1$s adlı yazıya %2$syorum%3$s yaptınız.', 'kanews'),
            '<a href="' . esc_url($post_permalink) . '">' . esc_html($post_title) . '</a>',
            '<a href="' . esc_url($comment_link) . '">',
            '</a>'
          ); 
          ?>
        </div>
        <p><?php echo wp_html_excerpt($comment->comment_content, 125); ?>..</p>
        <span style="font-size: 12px;">
          <?php 
          echo esc_html(human_time_diff(strtotime($comment->comment_date), current_time('timestamp', 1)));
          esc_html_e('&nbsp;önce', 'kanews'); 
          ?>
        </span>
      </div>
    </div>
  <?php endforeach; ?>
<?php else: ?>
  <p><?php esc_html_e('Henüz yorum yapmamışsınız ancak yapmalısınız.', 'kanews'); ?></p>
<?php endif; ?>

<?php if ($max_num_pages > 1) : ?>
  <div class="navigation pagination">
    <div class="nav-links">
      <?php 
      $current_page = max(1, get_query_var('paged'));
      echo paginate_links(array(
        'base'      => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
        'current'   => $current_page,
        'total'     => $max_num_pages,
        'prev_text' => '<i class="icon-arrow icon-90degg"></i>',
        'next_text' => '<i class="icon-arrow icon-90deg"></i>',
        'end_size'  => 2,
        'mid_size'  => 3
      ));
      ?>
    </div>
  </div>
<?php endif; ?>