<?php
/**
 * Template Name: Kripto Para Kurları
 * @theme kanews
 * @developer kanthemes.com
 */
__( 'Kripto Para Kurları', 'kanews' );
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
wp_enqueue_script('kanews-calculator');

global $wp;
date_default_timezone_set('Europe/Istanbul');
$indexes = [
  'try' => esc_html__( 'Türk Lirası', 'kanews' ),
  'usdt' => esc_html__( 'Amerikan Doları', 'kanews' ),
  'eur' => esc_html__( 'Euro', 'kanews' ),
  'btc' => esc_html__( 'Bitcoin', 'kanews' ),
  'eth' => esc_html__( 'Ethereum', 'kanews' ),
];
$index = isset($_GET['index']) ? esc_html($_GET['index']) : kanews_get_option('crypto-page-index', 'try');
$currency = isset($_GET['coin']) ? esc_html($_GET['coin']) : NULL;
$interval = isset($_GET['interval']) ? esc_html($_GET['interval']) : 'daily';
$chart = isset($_GET['chart']) ? esc_html($_GET['chart']) : 'tradingview';
$days = 'max';

$error = false;

$data = json_decode(kanews_crypto_data($index)); 

if($currency != NULL) {

    if(!empty($data)) {
      foreach($data as $currency_data) {
        if($currency_data->id === $currency) {
          $currency_data = json_decode(json_encode($currency_data), true);
          break;
        }
      }
    } else {
      wp_redirect( get_the_permalink(), 301);
      die;
    }
    if(!is_array($currency_data)) {
      wp_redirect( get_the_permalink(), 301);
      die;
    }
    $new_title = wp_sprintf( esc_html__('%1$s Grafiği ve Piyasa Değeri', 'kanews'), strtoupper($currency_data['symbol'].'/'.$index).' — '. $currency_data['name'] ).' - '.get_bloginfo( 'name' );
  
}

if( ($index != NULL && !isset($indexes[$index])) || $error ) {
  wp_redirect( get_the_permalink(), 301);
  die;
}

function generate_custom_title($title) {
  global $new_title;
  if($new_title)
  $title = $new_title;
  return $title;  
}
add_filter( 'pre_get_document_title', 'generate_custom_title', 10 );
add_filter( 'wpseo_title', 'generate_custom_title', 15 );

get_header();?>
  <?php while ( have_posts() ) : the_post(); ?>
  <div class="kanews-page-header">
    <div class="container">
      <div class="row align-items-center justify-space-between">
        
        <?php if(!empty($new_title2)): ?>
        <div class="col"><h1 class="kanews-page-title"><?php echo $new_title2; ?></h1></div>
        <?php else: ?>
        <div class="col"><h1 class="kanews-page-title"><?php the_title(); ?></h1></div>
        <?php endif; ?>

        <div class="col-auto">
          <div data-toggle="kanews-modal-categories" class="kanews-btn kanews-btn-light m-0">
            <?php echo $indexes[$index]; ?>
            <i class="icon-caret icon-180deg"></i>
          </div>
          <div id="kanews-modal-categories" class="kanews-modal">
            <div data-toggle="kanews-modal-categories" class="kanews-modal-close"></div>
            <div class="kanews-modal-content">
              <div class="kanews-modal-title"><?php esc_html_e( 'Endeks Fiyatı', 'kanews' ); ?></div>
              <div data-toggle="kanews-modal-categories" class="kanews-modal-close-btn"><i class="icon-close"></i></div>
              <div class="kanews-modal-content-inner">
                <div class="kanews-category-subscribe-wrapper">
                  <?php foreach($indexes as $key => $value) {
                    if($key == $index)
                    echo '<a href="'. esc_url( add_query_arg( array('index' => $key), $_SERVER['REQUEST_URI'] ) ).'" class="kanews-category-subscribe-button category-subscribed">'.$value.'</a>';
                    else
                    echo '<a href="'. esc_url( add_query_arg( array('index' => $key), $_SERVER['REQUEST_URI']) ).'" class="kanews-category-subscribe-button">'.$value.'</a>';
                  } ?>
                </div>
              </div>
            </div>
            
          </div>
        </div>

        

      </div>
    </div>
  </div>
  <?php endwhile; ?>

  <?php do_action('kanews_header_ad'); ?>

  <main id="main" class="site-main">
    <div class="container">
      <div class="row">

        <?php if( kanews_get_option('breadcrumb') ) : ?>
					<div class="col-12 kanews-flat-breadcrumb mb-1">
            <?php kanews_breadcrumb(get_the_ID()); ?>
					</div>
        <?php endif; ?>


        <?php if( $currency != NULL ): ?>

          <?php if(is_array($currency_data)):  $change =  $currency_data['price_change_percentage_24h'];?>
          
            <div class="col-12">

              <div class="single-layout-flat">
                <div class="kanews-section-box">

                  <div class="kanews-article-header p-0 mb-1">

                    <div class="d-flex align-items-center g-10 mb-1">
                    
                    <?php echo kanews_get_local_image($currency_data['image'], array('width' => 48, 'height' => 48, 'alt' => $currency_data['symbol'])); ?>
                    <h2 class="kanews-article-title mb-0"><?php echo $currency_data['name']; ?></h2><span><?php echo strtoupper($currency_data['symbol']); ?></span>
                    </div>
                    <p><?php $page_desc = sprintf(esc_html__('%1$s anlık olarak %2$s fiyatından işlem görmektedir. Fiyatı son 24 saatte %3$s%% değişim göstermiştir..', 'kanews'), $currency_data['name'], currency_format_number($currency_data['current_price']).' '.strtoupper($index), currency_format_number($change) ); echo $page_desc; ?></p>
                    
                    <div class="d-flex flex-wrap align-items-center g-10 mt-1">
                    <?php 
                    echo '<div style="font-size: 2rem">';
                    echo '<strong>'.currency_format_number($currency_data['current_price']).'</strong>';
                    echo ' '.strtoupper($index);
                    echo '</div>';
                    
                    if ($change < 0) {
                      $green = false;
                      // echo '<span class="border-danger color-danger percentage">'.$currency_data['price_change_24h'].'</span>';
                      echo '<span class="border-danger color-danger percentage kanews-label kanews-label-sm">'.currency_format_number($change).'%</span>';
                      
                    } else {
                      $green = true;
                      // echo '<span class="border-success color-success percentage">+'.$currency_data['price_change_24h'].'</span>';
                      echo '<span class="border-success color-success percentage kanews-label kanews-label-sm">+'.currency_format_number($change).'%</span>';
                      
                    }
                    ?>
                    </div>
                  </div>
                  <div class="mt-0">
                    <ul class="row">
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Popülerlik', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141">#<?php echo $currency_data['market_cap_rank']; ?></div>
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Piyasa Değeri', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo number_format_short($currency_data['market_cap']); ?> <span class="currency"><?php echo strtoupper($index); ?></span></div>
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Hacim (24 Saat)', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo number_format_short($currency_data['total_volume']); ?> <span class="currency"><?php echo strtoupper($index); ?></span></div>
                        
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Dolaşımdaki Miktar', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo number_format_short($currency_data['circulating_supply']); ?> <span class="currency"><?php echo strtoupper($currency_data['symbol']); ?></span></div>
                        <?php if( is_numeric($currency_data['max_supply']) && is_numeric($currency_data['circulating_supply']) ): ?>
                        <div class="kanews-mgfsa142"><?php echo wp_sprintf( esc_html__( 'Toplam arzda %%%s', 'kanews' ), currency_format_number(($currency_data['circulating_supply']*100)/$currency_data['max_supply'])); ?></div>
                        <?php endif; ?>
                      </li>
                      
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'En Yüksek Değer', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo $currency_data['ath']; ?></div>
                        <div class="kanews-mgfsa142"><?php echo wp_sprintf( esc_html__( 'Mesafe %%%s', 'kanews' ), round($currency_data['ath_change_percentage'], 1) ); ?></div>
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Günün En Yüksek Değeri', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo $currency_data['high_24h']; ?> <span class="currency"><?php echo strtoupper($index); ?></span></div>
                      </li>
                      <li class="col-auto mb-1">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Günün En Düşük Değeri', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo $currency_data['low_24h']; ?> <span class="currency"><?php echo strtoupper($index); ?></span></div>
                      </li>

                      <li class="col-auto">
                        <div class="kanews-mgfsa14"><?php esc_html_e( 'Son Güncelleme', 'kanews' ); ?></div>
                        <div class="kanews-mgfsa141"><?php echo date('d.m.Y H:i:s', strtotime($currency_data['last_updated']) ); ?></div>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
        

              <div class="row justify-content-between no-gutters">
                <div class="kanews-tab-3">
                  <ul class="nav nav-tabs d-flex flex-wrap p-0 mb-0">
                    <li class="nav-item"><a href="<?php echo esc_url( add_query_arg( 'chart', 'tradingview', $_SERVER['REQUEST_URI'] ) ); ?>" class="nav-link <?php echo $chart == 'tradingview' ? 'active' : ''; ?>"><?php _e('Tradingview', 'kanews'); ?></a></li>
                    <li class="nav-item"><a href="<?php the_permalink(); ?>" class="nav-link"><?php _e('Diğer Kripto Paralara Göz At', 'kanews'); ?></a></li>
    
                  </ul>
                </div>

              </div>
            
              <div class="kanews-section" style="overflow:hidden">

                <?php if($chart !== 'tradingview'): ?>
                  <div id="kanews-chart"><div id="kanews-loader"><div class="kanews-loader-2 kanews-loader-lg">Loading...</div></div></div>
                <?php else: ?>
                  <!-- TradingView Widget BEGIN -->
                  <div class="tradingview-widget-container">
                    <div id="tradingview_12510"></div>
                    <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/symbols/<?php echo strtoupper($currency_data['symbol'].$index); ?>?exchange=BINANCE" rel="noopener" target="_blank"><span class="blue-text"><?php echo strtoupper($currency_data['symbol'].$index); ?> Chart</span></a> by TradingView</div>
                    <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
                    <script type="text/javascript">
                    new TradingView.widget(
                    {
                      "width": 1170,
                      "height": 610,
                      "symbol": "BINANCE:<?php echo strtoupper($currency_data['symbol'].$index); ?>",
                      "timezone": "Europe/Istanbul",
                      "interval": "240",
                      "theme": "light",
                      "style": "1",
                      "locale": "tr",
                      "toolbar_bg": "#ccc",
                      "enable_publishing": false,
                      "hide_top_toolbar": false,
                      "withdateranges": false,
                      "details": true,
                      "hide_side_toolbar": false,
                      "allow_symbol_change": true,
                      "show_popup_button": true,
                      "studies": [
                        // "MACD@tv-basicstudies",
                        "RSI@tv-basicstudies"
                      ],
                      "hotlist": true,
                      "watchlist": [
                        "BINANCE:BTC<?php echo strtoupper($index);?>",
                        "BINANCE:ETH<?php echo strtoupper($index);?>",
                        "BINANCE:BCH<?php echo strtoupper($index);?>",
                        "BINANCE:BNB<?php echo strtoupper($index);?>",
                        "BINANCE:SOL<?php echo strtoupper($index);?>",
                        "BINANCE:MANA<?php echo strtoupper($index);?>",
                        "BINANCE:SAND<?php echo strtoupper($index);?>",
                      ],
                      "popup_width": "1000",
                      "popup_height": "650",
                      "container_id": "tradingview_e8ead",
                      "isTransparent": false,
                    }
                    );
                    </script>
                  </div>
                  <!-- TradingView Widget END -->
                <?php endif; ?>
                
              
                
              </div>
            </div>
          <?php endif; ?>

          <div class="col-12">
            <div class="row">

              <div class="col-12">
                <div class="kanews-section kanews-section-flat">
                  <div class="kanews-section-box">
                    <div class="kanews-article-content entry-content">
                      <div class="entry-content-wrapper">
                        <div class="entry-content-inner">
                          <?php if ($change < 0): ?>
                          <h3><?php echo sprintf(esc_html__('%s (%s) fiyatı bugün yükseldi.', 'kanews'), $currency_data['name'], strtoupper($currency_data['symbol'])); ?></h3>
                          <?php else: ?>
                          <h3><?php echo sprintf(esc_html__('%s (%s) fiyatı bugün düştü.', 'kanews'), $currency_data['name'], strtoupper($currency_data['symbol'])); ?></h3>
                          <?php endif; ?>
                          <p><?php echo sprintf(esc_html__('%1$s anlık olarak %2$s fiyatından işlem görmektedir ve 24 saatlik yaklaşık işlem hacmi %3$s. Fiyatı son 24 saatte %4$s değişim göstermiştir..', 'kanews'), $currency_data['name'], currency_format_number($currency_data['current_price']).strtoupper($index), number_format_short($currency_data['total_volume']), currency_format_number($change) ); ?></p>

                          <h3><?php echo sprintf(esc_html__('%s için 24 saatlik işlem hacmi nedir?', 'kanews'), $currency_data['name']); ?></h3>
                          <p><?php echo sprintf(esc_html__('%1$s için 24 saatlik işlem hacmi %2$s idi.', 'kanews'), $currency_data['name'], number_format_short($currency_data['total_volume']).strtoupper($index)); ?></p>

                          <h3><?php echo sprintf(esc_html__('%s için en yüksek fiyat nedir?', 'kanews'), $currency_data['name']); ?></h3>
                          <p><?php echo sprintf(esc_html__('%1$s için tüm zamanların en yüksek fiyatı %2$s tarihinde %3$s idi.', 'kanews'), $currency_data['name'], date('F j, Y', strtotime($currency_data['ath_date'])), $currency_data['ath'].strtoupper($index) ); ?></p>

                          <h3><?php echo sprintf(esc_html__('%s için en düşük fiyat nedir?', 'kanews'), $currency_data['name']); ?></h3>
                          <p><?php echo sprintf(esc_html__('%1$s için tüm zamanların en düşük fiyatı %2$s tarihinde %3$s idi.', 'kanews'), $currency_data['name'], date('F j, Y', strtotime($currency_data['atl_date'])), $currency_data['atl'].strtoupper($index) ); ?></p>

                          <h3><?php echo sprintf(esc_html__('%s Dönüştürücüsü', 'kanews'), $currency_data['name']); ?></h3>
                          <form id="doviz_calc">
                            <div class="row">
                              <?php 
                            
                              echo '<div class="col-12 col-md-6"><div class="kanews-form2">';
                                echo '<select class="currency_switcher_x txyh2">';
                                foreach($data as $coin) {
                                  $selected = $coin->id == $currency ? 'selected="selected"' : '';
                                  echo '<option '.$selected.' value="'.$coin->current_price.'">'.strtoupper($coin->symbol).'</option>';
                                }
                                echo '<option value="1">'.$index.'</option>';  
                                echo '</select>';
                              echo '</div></div>';

                              echo '<div class="col-12 col-md-6"><div class="kanews-form2">';
                                echo '<select class="currency_switcher_2 txyh2">';
                                
                                echo '<option value="1">'.$index.'</option>';
                                foreach($data as $coin) {
                                  $selected = $coin->symbol == $index ? 'selected="selected"' : '';
                                  if($index == 'usd' &&  $coin->symbol == 'usdt')
                                  $selected = 'selected="selected"';
                                  echo '<option '.$selected.' value="'.$coin->current_price.'">'.strtoupper($coin->symbol).'</option>';
                                }
                                echo '</select>';
                              echo '</div></div>';
                              ?>
                              <div class="col-12">
                                <div class="kanews-form kanews-form-fsm bgw">
                                  <input type="text" class="currency3value" value="1">
                                  <label><?php _e('Miktar', 'kanews'); ?></label>
                                </div>
                              </div>
                              <div class="col-12">
                                <div class="kanews-form kanews-form-fsm bgw mb-0">
                                  <input type="text" class="currency4value" value="?">
                                  <span class="highlight"></span>
                                    <span class="bar"></span>
                                    <label><?php _e('Sonuç', 'kanews'); ?></label>
                                </div>
                              </div>
                            </div>
                          </form>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                
              </div>

              <div class="col-12">
                <div class="row">
                  
                  <div class="col-12 col-md-6">
                    <div class="kanews-section">
                      <?php echo kanews_widget_title(esc_html__( '24s En Çok Yükselenler', 'kanews' ));?>
                      <table class="kanews-table table-search table-currencies table-auto">
                        <thead>
                          <tr>
                            <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Ad', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'Sembol', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'Değer', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          
                          if(!empty($data)) {
                            $kfd2 = $data;
                            usort($kfd2, function($a, $b) {
                              return strnatcmp($b->price_change_percentage_24h, $a->price_change_percentage_24h);
                            });
                            $counter = 0;  
                            foreach($kfd2 as $coin) {$counter++;
                              $change =  $coin->price_change_percentage_24h;
                              if ($change < 0) {
                                $class = 'currencies-down-item';
                              } else {
                                $class = 'currencies-up-item';
                              }
                              echo '<tr onclick="window.location=\''.kanews_get_page_link('coin', $coin->id, 'crypto').'\';" data-code="'. strtoupper($coin->symbol).'">';
                                echo '<td class="hidden-mobile"><a href="'.kanews_get_page_link('coin', $coin->id, 'crypto').'">'. $coin->name.'</a></td>';
                                echo '<td>'. strtoupper($coin->symbol).'</td>';
                                echo '<td>'.currency_format_number($coin->current_price).'</td>';
                                echo '<td class="'.$class.'"><span>'.currency_format_number($change).'%</span></td>';
                              echo '</tr>';
                              
                              if($counter==10)
                              break;
                            }
                          } else {
                            echo '<tr><td>'.esc_html__( 'Veri alınamadı', 'kanews' ).'</td></tr>';
                          }
                          ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  <div class="col-12 col-md-6">
                    <div class="kanews-section">
                      <?php echo kanews_widget_title(esc_html__( '24s En Çok Düşenler', 'kanews' ));?>
                      <table class="kanews-table table-search table-currencies table-auto">
                        <thead>
                          <tr>
                            <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Ad', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'Sembol', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'Değer', 'kanews' ); ?></span></th>
                            <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          
                          if(!empty($data)) {
                            $kfd2 = $data;
                            usort($kfd2, function ($item1, $item2) {
                              if ($item2->price_change_percentage_24h == $item1->price_change_percentage_24h) {
                                return 0;
                              }
                              return ($item2->price_change_percentage_24h > $item1->price_change_percentage_24h) ? -1 : 1;
                            });
                            $counter = 0; 
                            foreach($kfd2 as $coin) {$counter++;
                              $change =  $coin->price_change_percentage_24h;
                                if ($change < 0) {
                                  $class = 'currencies-down-item';
                                } else {
                                  $class = 'currencies-up-item';
                                }
                                echo '<tr onclick="window.location=\''.kanews_get_page_link('coin', $coin->id, 'crypto').'\';" data--code="'. strtoupper($coin->symbol).'">';
                                  echo '<td class="hidden-mobile"><a href="'.kanews_get_page_link('coin', $coin->id, 'crypto').'">'. $coin->name.'</a></td>';
                                  echo '<td>'. strtoupper($coin->symbol).'</td>';
                                  echo '<td>'.currency_format_number($coin->current_price).'</td>';
                                  echo '<td class="'.$class.'"><span>'.currency_format_number($change).'%</span></td>';
                                echo '</tr>';
                        
                              if($counter==10)
                              break;
                            }
                          } else {
                            echo '<tr><td>'.esc_html__( 'Veri alınamadı', 'kanews' ).'</td></tr>';
                          }
                          ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>

    

              <div class="col-12">
                <?php 
                // print_r($_SERVER);
                get_template_part('template-parts/content/components/related', 'page2', array( 
                  'posts_per_page' => 10,
                  's' => $currency_data['name']
                ) ); ?>
              </div>

            </div>
          </div>
        </div>

        <script>
          document.getElementsByTagName('title')[0].innerHTML = "<?php echo $new_title; ?>";
          document.getElementsByTagName('meta')["description"].content = "<?php echo $page_desc; ?>";
        </script>

        <?php else: ?>

          <?php $insights = get_post_meta( get_the_ID(), 'post_insight', true ) == 1 ? 1 : 0; if(kanews_insights_control() == true || $insights == 0 ): ?>

          <div class="col-12 mb-1">
            <div class="kanews-section kanews-section-shortcode">
              <?php echo kanews_widget_title(esc_html__( 'Kripto Para Hesaplayıcısı', 'kanews'), 'h2'); ?>
              <?php echo do_shortcode( '[kanews-calculator tur="coin" index="'.$index.'" show_tabs="true" exclude_types="burc,vki"]' ); ?>
            </div>
          </div>

          <div class="col-12 mb-1">
            <div class="kanews-section">
                <?php echo kanews_widget_title(esc_html__( 'Kripto Para Piyasası', 'kanews' ), 'h2'); ?>
                <input placeholder="<?php _e('Görmek İstediğin Para Birimini Yaz', 'kanews'); ?>" id="kanews-currencies-search">
                <div class="kanews-scroll" style="max-height: 840px">
                  <table class="kanews-table table-search table-currencies table-auto">
                    <thead>
                      <tr>
                        <th><span class="nobr"><?php esc_html_e( 'Adı', 'kanews' ); ?></span></th>
                        <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Sembol', 'kanews' ); ?></span></th>
                        <th><span class="nobr"><?php esc_html_e( 'Değer', 'kanews' ); ?></span></th>
                        <th><span class="nobr"><?php esc_html_e( 'En Düşük', 'kanews' ); ?></span></th>
                        <th><span class="nobr"><?php esc_html_e( 'En Yüksek', 'kanews' ); ?></span></th>
                        <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      
                      if(!empty($data)) {
                        foreach($data as $coin) {
        
                            $change =  $coin->price_change_percentage_24h;
                            $icon = '';
                            if ($change < 0) {
                              $class = 'currencies-down-item';
							  // $icon = '<svg class="icon-trending icon-180deg" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
                            } else {
                              $class = 'currencies-up-item';
							  // $icon = '<svg class="icon-trending" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
                            }
                            echo '<tr onclick="window.location=\''.kanews_get_page_link('coin', $coin->id, 'crypto').'\';" data--code="'. strtoupper($coin->symbol).'">';
                              echo '<td><a href="'.kanews_get_page_link('coin', $coin->id, 'crypto').'">'.kanews_get_local_image($coin->image, array('width' => 18, 'height' => 18, 'alt' => $coin->symbol)). $coin->name.'</a></td>';
                              echo '<td class="hidden-mobile">'. strtoupper($coin->symbol).'</td>';
                              echo '<td>'.currency_format_number($coin->current_price).'</td>';
                              echo '<td>'. currency_format_number($coin->low_24h).'</td>';
                              echo '<td>'. currency_format_number($coin->high_24h).'</td>';
                              echo '<td class="'.$class.'"><span>'.round($change, 2).'% '.$icon.'</span></td>';
                            echo '</tr>';
                          
                        }
                      } else {
                        echo '<tr><td>'.esc_html__( 'Veri alınamadı', 'kanews' ).'</td></tr>';
                      }
                      ?>
                    </tbody>
                  </table>
                </div>
              </div>
            
            </div>


            <div class="col-12">
              <div class="row">

              <div class="col-12 col-md-4">
                  <div class="kanews-section">
                    <?php echo kanews_widget_title(esc_html__( '24s Piyasa Değeri Artışı', 'kanews' ));?>
                    <table class="kanews-table table-search table-currencies table-auto">
                      <thead>
                        <tr>
                          <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Ad', 'kanews' ); ?></span></th>
                          <th class="hidden-desktop"><span class="nobr"><?php esc_html_e( 'Sembol', 'kanews' ); ?></span></th>
                          <th><span class="nobr"><?php esc_html_e( 'Değer', 'kanews' ); ?></span></th>
                          <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        
                        if(!empty($data)) {
                          // print_r($data);
                          $kfd2 = $data;
                          usort($kfd2, function($a, $b) {
                            return strnatcmp($b->market_cap_change_percentage_24h, $a->market_cap_change_percentage_24h);
                          });
                          $counter = 0; 
                          foreach($kfd2 as $coin) {$counter++;
                            $change =  $coin->market_cap_change_percentage_24h;
                              if ($change < 0) {
                                $class = 'currencies-down-item';
                              } else {
                                $class = 'currencies-up-item';
                              }
                              echo '<tr onclick="window.location=\''.kanews_get_page_link('coin', $coin->id, 'crypto').'\';" data-code="'. strtoupper($coin->symbol).'">';
                                echo '<td class="hidden-mobile">'. $coin->name.'</td>';
                                echo '<td class="hidden-desktop">'. strtoupper($coin->symbol).'</td>';
                                echo '<td>'.currency_format_number($coin->current_price).'</td>';
                                echo '<td class="'.$class.'"><span>'.currency_format_number($change).'%</span></td>';
                              echo '</tr>';
                      
                            if($counter==10)
                            break;
                          }
                        } else {
                          echo '<tr><td>'.esc_html__( 'Veri alınamadı', 'kanews' ).'</td></tr>';
                        }
                        ?>
                      </tbody>
                    </table>
                  </div>
                </div>
                
                <div class="col-12 col-md-4">
                  <div class="kanews-section">
                    <?php echo kanews_widget_title(esc_html__( '24s En Çok Yükselenler', 'kanews' ));?>
                    <table class="kanews-table table-search table-currencies table-auto">
                      <thead>
                        <tr>
                          <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Ad', 'kanews' ); ?></span></th>
                          <th class="hidden-desktop"><span class="nobr"><?php esc_html_e( 'Sembol', 'kanews' ); ?></span></th>
                          <th><span class="nobr"><?php esc_html_e( 'Değer', 'kanews' ); ?></span></th>
                          <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        
                        if(!empty($data)) {
                          $kfd2 = $data;
                          usort($kfd2, function($a, $b) {
                            return strnatcmp($b->price_change_percentage_24h, $a->price_change_percentage_24h);
                          });
                          $counter = 0;  
                          foreach($kfd2 as $coin) {$counter++;
                            $change =  $coin->price_change_percentage_24h;
                            if ($change < 0) {
                              $class = 'currencies-down-item';
                            } else {
                              $class = 'currencies-up-item';
                            }
                            echo '<tr onclick="window.location=\''.kanews_get_page_link('coin', $coin->id, 'crypto').'\';" data-code="'. strtoupper($coin->symbol).'">';
                              echo '<td class="hidden-mobile">'. $coin->name.'</td>';
                              echo '<td class="hidden-desktop">'. strtoupper($coin->symbol).'</td>';
                              echo '<td>'.currency_format_number($coin->current_price).'</td>';
                              echo '<td class="'.$class.'"><span>'.currency_format_number($change).'%</span></td>';
                            echo '</tr>';
                            
                            if($counter==10)
                            break;
                          }
                        } else {
                          echo '<tr><td>'.esc_html__( 'Veri alınamadı', 'kanews' ).'</td></tr>';
                        }
                        ?>
                      </tbody>
                    </table>
                  </div>
                </div>

                <div class="col-12 col-md-4">
                  <div class="kanews-section">
                    <?php echo kanews_widget_title(esc_html__( '24s En Çok Düşenler', 'kanews' ));?>
                    <table class="kanews-table table-search table-currencies table-auto">
                      <thead>
                        <tr>
                          <th class="hidden-mobile"><span class="nobr"><?php esc_html_e( 'Ad', 'kanews' ); ?></span></th>
                          <th class="hidden-desktop"><span class="nobr"><?php esc_html_e( 'Sembol', 'kanews' ); ?></span></th>
                          <th><span class="nobr"><?php esc_html_e( 'Değer', 'kanews' ); ?></span></th>
                          <th><span class="nobr"><?php esc_html_e( 'Değişim', 'kanews' ); ?></span></th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        
                        if(!empty($data)) {
                          $kfd2 = $data;
                          usort($kfd2, function ($item1, $item2) {
                            if ($item2->price_change_percentage_24h == $item1->price_change_percentage_24h) {
                                return 0;
                            }
                            return ($item2->price_change_percentage_24h > $item1->price_change_percentage_24h) ? -1 : 1;
                        });
                        
                          $counter = 0; 
                          foreach($kfd2 as $coin) {$counter++;
                            $change =  $coin->price_change_percentage_24h;
                              if ($change < 0) {
                                $class = 'currencies-down-item';
                              } else {
                                $class = 'currencies-up-item';
                              }
                              echo '<tr onclick="window.location=\''.kanews_get_page_link('coin', $coin->id, 'crypto').'\';" data-code="'. strtoupper($coin->symbol).'">';
                                echo '<td class="hidden-mobile">'. $coin->name.'</td>';
                                echo '<td class="hidden-desktop">'. strtoupper($coin->symbol).'</td>';
                                echo '<td>'.currency_format_number($coin->current_price).'</td>';
                                echo '<td class="'.$class.'"><span>'.currency_format_number($change).'%</span></td>';
                              echo '</tr>';
                      
                            if($counter==10)
                            break;
                          }
                        } else {
                          echo '<tr><td>'.esc_html__( 'Veri alınamadı', 'kanews' ).'</td></tr>';
                        }
                        ?>
                      </tbody>
                    </table>
                  </div>
                </div>

              </div>
            </div>

            <div class="col-12">
                <div class="kanews-section">
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                  <div class="tradingview-widget-container__widget"></div>
                  <div class="tradingview-widget-copyright"><a href="https://tr.tradingview.com/markets/cryptocurrencies/prices-all/" rel="noopener" target="_blank"><span class="blue-text">Kripto piyasaları</span></a> TradingView tarafından</div>
                  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-screener.js" async>
                  {
                  "width": "100%",
                  "height": "600",
                  "defaultColumn": "moving_averages",
                  "screener_type": "crypto_mkt",
                  "displayCurrency": "<?php echo strtoupper($index); ?>",
                  "colorTheme": "light",
                  "locale": "tr",
                  "isTransparent": true
                }
                  </script>
                </div>
                <!-- TradingView Widget END -->
                </div>
              </div>
            
            <?php while ( have_posts() ) : the_post(); 
              if ($post->post_content): ?>
                <div class="col-12">
                  <div class="kanews-article kanews-section-box kanews-article-1">
                    <div class="kanews-article-content entry-content">
                      <?php the_content(); ?>
                    </div>
                  </div>
                </div>
              <?php endif; ?>

              <?php if ( comments_open() || get_comments_number() ) : ?>
                <div class="col-12">
                  <?php comments_template(); ?>
                </div>
              <?php endif;?> 
            <?php endwhile; ?>

            <?php get_template_part('template-parts/content/components/related', 'page'); ?>

          <?php else: ?>
            <div class="col-12"><?php echo kanews_private_content('a'); ?></div>
          <?php endif; ?>
        <?php endif; ?>


      </div>
    </div>
  </main>

<?php get_footer();
