<?php
/**
 * Gutenberg sınıfı
 * 
 * @package Kanews
 * @developer Kan Themes
 * @version 7.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
  exit;
}

class Kanews_Gutenberg {
  /**
   * Sınıf örneği
   * 
   * @var Kanews_Gutenberg
   */
  private static $instance = null;

  /**
   * Dynamic CSS instance
   * 
   * @var Kanews_Dynamic_CSS
   */
  private $dynamic_css;

  /**
   * Sınıf örneğini döndür
   * 
   * @return Kanews_Gutenberg
   */
  public static function get_instance() {
      if (null === self::$instance) {
          self::$instance = new self();
      }
      return self::$instance;
  }

  /**
   * Constructor
   */
  private function __construct() {
      add_action('init', [$this, 'register_blocks']);
      require_once get_template_directory() . '/gutenberg/utils.php';
      require_once get_template_directory() . '/gutenberg/renders.php';

  }

  /**
   * Blokları kaydet
   */
  public function register_blocks() {
      // Register Kanews block category
      if (function_exists('register_block_type')) {
          add_filter('block_categories_all', function($categories) {
              return array_merge(
                  $categories,
                  [
                      [
                          'slug' => 'kanews',
                          'title' => __('Kanews Blokları', 'kanews'),
                          // 'icon' => 'star-filled',
                      ],
                  ]
              );
          });

          // Register block script
          wp_register_script(
              'kanews-blocks',
              get_template_directory_uri() . '/gutenberg/build/blocks.js',
              ['wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n'],
              filemtime(get_template_directory() . '/gutenberg/build/blocks.js')
          );

          // Register frontend styles
          wp_register_style(
              'kanews-blocks',
              get_template_directory_uri() . '/gutenberg/build/style-blocks.css',
              [],
              filemtime(get_template_directory() . '/gutenberg/build/style-blocks.css')
          );

          // Register editor styles
          wp_register_style(
              'kanews-blocks-editor',
              get_template_directory_uri() . '/gutenberg/build/editor-blocks.css',
              [],
              filemtime(get_template_directory() . '/gutenberg/build/editor-blocks.css')
          );

          // Register each block
          register_block_type('kanews/featured-news', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks',
          ]);

          register_block_type('kanews/gallery', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks',
          ]);
   
          register_block_type('kanews/related-posts', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks',
              'render_callback' => 'kanews_render_related_posts',
              'attributes' => [
                  'title' => [
                      'type' => 'string',
                      'default' => __('İlginizi Çekebilir', 'kanews')
                  ],
                  'postCount' => [
                      'type' => 'number',
                      'default' => 3
                  ],
                  'selectedPosts' => [
                      'type' => 'array',
                      'default' => []
                  ],
                  'headingTag' => [
                      'type' => 'string',
                      'default' => 'div'
                  ],
                  'detailText' => [
                      'type' => 'string',
                      'default' => __('Haberi görüntüle', 'kanews')
                  ],
                  'showDetailText' => [
                      'type' => 'boolean',
                      'default' => true
                  ],
                  'showTitle' => [
                      'type' => 'boolean',
                      'default' => true
                  ],
                  'backgroundColor' => [
                      'type' => 'string',
                      'default' => ''
                  ],
                  'visibility' => [
                      'type' => 'object',
                      'default' => [
                          'desktop' => false,
                          'tablet' => false,
                          'mobile' => false
                      ]
                  ],
                  'titleTypography' => [
                      'type' => 'object',
                      'default' => []
                  ]
              ]
          ]);

          register_block_type('kanews/calculator', [
              'editor_script' => ['kanews-blocks'],
              'editor_style' => ['kanews-blocks-editor'],
              'style' => ['kanews-blocks'],
              'render_callback' => 'kanews_render_calculator',
              'attributes' => [
                  'type' => [
                      'type' => 'string',
                      'default' => 'doviz'
                  ],
                  'showTabs' => [
                      'type' => 'boolean',
                      'default' => false
                  ],
                  'excludedTypes' => [
                      'type' => 'array',
                      'default' => []
                  ],
                  'index' => [
                      'type' => 'string',
                      'default' => ''
                  ],
                  'visibility' => [
                      'type' => 'object',
                      'default' => [
                          'desktop' => false,
                          'tablet' => false,
                          'mobile' => false
                      ]
                  ]
              ]
          ]);

          // Register button block
          register_block_type('kanews/button', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks'
          ]);
          
          // Register alert block
          register_block_type('kanews/alert', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks'
          ]);
          
          // Register FAQ block
          register_block_type('kanews/faq', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks',
              'render_callback' => 'kanews_render_faq'
          ]);
          
          // Register Table of Contents block
          register_block_type('kanews/table-of-contents', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks',
              'render_callback' => 'kanews_render_table_of_contents',
              'attributes' => [
                  'title' => [
                      'type' => 'string',
                      'default' => __('İçindekiler', 'kanews')
                  ],
                  'margin' => [
                      'type' => 'object',
                      'default' => []
                  ],
                  'padding' => [
                      'type' => 'object',
                      'default' => []
                  ],
                  'border' => [
                      'type' => 'object',
                      'default' => []
                  ],
                  'showTitle' => [
                      'type' => 'boolean',
                      'default' => true
                  ],
                  'showNumbers' => [
                      'type' => 'boolean',
                      'default' => true
                  ],
                  'isAccordion' => [
                      'type' => 'boolean',
                      'default' => false
                  ],
                  'headingLevels' => [
                      'type' => 'array',
                      'default' => ['h1', 'h2', 'h3']
                  ],
                  'maxDepth' => [
                      'type' => 'number',
                      'default' => 3
                  ],
                  'titleTypography' => [
                      'type' => 'object',
                      'default' => []
                  ],
                  'linkTypography' => [
                      'type' => 'object',
                      'default' => []
                  ],
                  'titleColor' => [
                      'type' => 'string',
                      'default' => ''
                  ],
                  'linkColor' => [
                      'type' => 'string',
                      'default' => ''
                  ],
                  'linkHoverColor' => [
                      'type' => 'string',
                      'default' => ''
                  ],
                  'backgroundColor' => [
                      'type' => 'string',
                      'default' => ''
                  ],
                  'visibility' => [
                      'type' => 'object',
                      'default' => [
                          'desktop' => false,
                          'tablet' => false,
                          'mobile' => false
                      ]
                  ]
              ]
          ]);
          
          // Register Timeline block
          register_block_type('kanews/timeline', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks'
          ]);
          
          // Register Bibliography block
          register_block_type('kanews/bibliography', [
              'editor_script' => 'kanews-blocks',
              'editor_style' => 'kanews-blocks-editor',
              'style' => 'kanews-blocks'
          ]);
       
      }
  }

}

// Sınıfı başlat
Kanews_Gutenberg::get_instance();
