<?php 

if (!defined('ABSPATH')) {
    die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

class kanews_widget_class_taxonomies extends WP_Widget {
    public function __construct() {
        $widget_ops = array('classname' => 'kanews_widget_class_taxonomies widget_accordion_menu');
        $control_ops = array('id_base' => 'kanews_widget_taxonomies');
        parent::__construct('kanews_widget_taxonomies', KAN_THEME_NAME .' - '.__("Taksonomi", 'kanews'), $widget_ops, $control_ops);
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

    }

    public function widget($args, $instance) {
        $defaults = array( 
            'grid' => 'col-12',
            'tax' => 'category',
            'show_count' => true,
            'show_parent_count' => false,
            'hide_empty' => false,
            'show_description' => false,
            'orderby' => 'name',
            'order' => 'ASC',
            'accordion_style' => 'default',
            'show_subcategories' => true
        ); 
        $instance = wp_parse_args($instance, $defaults);
        
        $accordion_class = 'widget_accordion_menu';
        
        echo '<div class="'.esc_attr($instance['grid']).'"><div class="kanews-section ' . $accordion_class . '">';
        
        if (!empty($instance['title'])) {
            echo ($args['before_title'] . $instance['title'] . $args['after_title']);
        }

        $taxonomies = get_terms(array(
            'taxonomy' => $instance['tax'],
            'hide_empty' => $instance['hide_empty'],
            'parent' => 0,
            'orderby' => $instance['orderby'],
            'order' => $instance['order']
        ));

        if (!is_wp_error($taxonomies) && !empty($taxonomies)) {
            $output = '<div><ul class="widget-accordion-menu">';
            


            foreach($taxonomies as $category) {
                // Alt kategorileri kontrol et
                $children = get_terms(array(
                    'taxonomy' => $instance['tax'],
                    'hide_empty' => $instance['hide_empty'],
                    'parent' => $category->term_id,
                    'orderby' => $instance['orderby'],
                    'order' => $instance['order']
                ));

                $has_children = !is_wp_error($children) && !empty($children);
                $menu_class = $has_children ? 'page_item menu-item-has-children' : 'page_item';

                $output .= '<li class="' . esc_attr($menu_class) . '">';
                $output .= '<a class="d-flex justify-content-between" href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, $instance['tax'])).'">';
                $output .= $category->name;
                
                if($instance['show_parent_count']) {
                    $output .= ' <span class="count">('.$category->count.')</span>';
                }
                
                if($has_children && $instance['show_subcategories']) {
                    $output .= ' <i class="icon-arrow"></i>';
                }
                
                $output .= '</a>';
                
                if($instance['show_description'] && !empty($category->description)) {
                    $output .= '<div class="term-description">' . do_shortcode($category->description) . '</div>';
                }

                if($has_children && $instance['show_subcategories']) {
                    $output .= '<ul class="sub-menu">';
                    $output .= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($category, $instance['tax'])).'">'.esc_html__('Hepsi', 'kanews').'</a></li>';
                    
                    foreach($children as $child) {
                        $output .= '<li class="page_item"><a href="'.esc_url(Kanews\Helper_Wp::get_term_link($child, $instance['tax'])).'">';
                        $output .= $child->name;
                        if($instance['show_count']) {
                            $output .= ' <span class="count">('.$child->count.')</span>';
                        }
                        $output .= '</a></li>';
                    }
                    
                    $output .= '</ul>';
                }
                
                $output .= '</li>';
            }
            $output .= '</ul></div>';
            
            
            echo $output;
        }

        echo '</div></div>';
    }

    public function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['grid'] = $new_instance['grid'];
        $instance['tax'] = $new_instance['tax'];
        $instance['show_count'] = $new_instance['show_count'];
        $instance['show_parent_count'] = $new_instance['show_parent_count'];
        $instance['hide_empty'] = $new_instance['hide_empty'];
        $instance['show_description'] = $new_instance['show_description'];
        $instance['orderby'] = $new_instance['orderby'];
        $instance['order'] = $new_instance['order'];
        $instance['accordion_style'] = $new_instance['accordion_style'];
        $instance['show_subcategories'] = $new_instance['show_subcategories'];
        return $instance;
    }

    public function form($instance) {
        $defaults = array(
            'title' => '',
            'grid' => 'col-12',
            'tax' => 'category',
            'show_count' => 'on',
            'hide_empty' => 'off',
            'orderby' => 'name',
            'order' => 'ASC',
            'show_description' => 'off',
            'show_parent_count' => 'off',
            'accordion_style' => 'default',
            'show_subcategories' => 'on'
        );
        $instance = wp_parse_args((array) $instance, $defaults);

        // Genel Ayarlar
        Kanews_Form_Elements::render_accordion_field([
            'title' => __('Genel Ayarlar', 'kanews'),
            'content' => [
                [
                    'type' => Kanews_Form_Elements::TYPE_TEXT,
                    'id' => $this->get_field_id('title'),
                    'name' => $this->get_field_name('title'),
                    'label' => __('Başlık', 'kanews'),
                    'value' => $instance['title']
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_SELECT,
                    'id' => $this->get_field_id('grid'),
                    'name' => $this->get_field_name('grid'),
                    'label' => __('Genişlik', 'kanews'),
                    'value' => $instance['grid'],
                    'options' => [
                        'col-12' => '12/12',
                        'col-12 col-lg-8' => '12/8',
                        'col-12 col-lg-6' => '12/6',
                        'col-12 col-lg-4' => '12/4',
                        'col-12 col-lg' => __('Sığdır', 'kanews')
                    ]
                ]
            ]
        ]);

        // İçerik Ayarları
        Kanews_Form_Elements::render_accordion_field([
            'title' => __('İçerik Ayarları', 'kanews'),
            'content' => [
                [
                    'type' => Kanews_Form_Elements::TYPE_SELECT,
                    'id' => $this->get_field_id('tax'),
                    'name' => $this->get_field_name('tax'),
                    'label' => __('Listelenecek Taksonomi', 'kanews'),
                    'value' => $instance['tax'],
                    'options' => [
                        'category' => __('Kategori', 'kanews'),
                        'tags' => __('Etiket', 'kanews'),
                        'ilan-kategori' => __('İlan Kategori', 'kanews'),
                        'ilan-etiket' => __('İlan Etiket', 'kanews'),
                        'kategori' => __('Firma Kategori', 'kanews')
                    ]
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_SELECT,
                    'id' => $this->get_field_id('orderby'),
                    'name' => $this->get_field_name('orderby'),
                    'label' => __('Sıralama Kriteri', 'kanews'),
                    'value' => $instance['orderby'],
                    'options' => [
                        'name' => __('İsim', 'kanews'),
                        'count' => __('Yazı Sayısı', 'kanews'),
                        'id' => __('ID', 'kanews')
                    ]
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_SELECT,
                    'id' => $this->get_field_id('order'),
                    'name' => $this->get_field_name('order'),
                    'label' => __('Sıralama Yönü', 'kanews'),
                    'value' => $instance['order'],
                    'options' => [
                        'ASC' => __('Artan', 'kanews'),
                        'DESC' => __('Azalan', 'kanews')
                    ]
                ]
            ]
        ]);

        // Görünüm Ayarları
        Kanews_Form_Elements::render_accordion_field([
            'title' => __('Görünüm Ayarları', 'kanews'),
            'content' => [
                [
                    'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                    'id' => $this->get_field_id('show_subcategories'),
                    'name' => $this->get_field_name('show_subcategories'),
                    'label' => __('Alt Kategorileri Göster', 'kanews'),
                    'value' => $instance['show_subcategories']
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                    'id' => $this->get_field_id('show_count'),
                    'name' => $this->get_field_name('show_count'),
                    'label' => __('Alt Kategorilerde Yazı Sayısını Göster', 'kanews'),
                    'value' => $instance['show_count']
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                    'id' => $this->get_field_id('show_parent_count'),
                    'name' => $this->get_field_name('show_parent_count'),
                    'label' => __('Ana Kategorilerde Yazı Sayısını Göster', 'kanews'),
                    'value' => $instance['show_parent_count']
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                    'id' => $this->get_field_id('hide_empty'),
                    'name' => $this->get_field_name('hide_empty'),
                    'label' => __('Boş Kategorileri Gizle', 'kanews'),
                    'value' => $instance['hide_empty']
                ],
                [
                    'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                    'id' => $this->get_field_id('show_description'),
                    'name' => $this->get_field_name('show_description'),
                    'label' => __('Kategori Açıklamalarını Göster', 'kanews'),
                    'value' => $instance['show_description']
                ]
            ]
        ]);
    }
}