<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_posts_10 extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_posts_10 column_x_gutter');
		$control_ops = array('id_base' => 'kanews_widget_posts_10');
		parent::__construct('kanews_widget_posts_10', ''.KAN_THEME_NAME .' - '.__( "Yazılar" , 'kanews' ).' #10' , $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on') {
			if(kan_is_mobile())
			return;
		}

		if($hide_desktop == 'on') {
			if(!kan_is_mobile())
			return;
		}
		
		$grid = (!empty($instance['grid'])) ? $instance['grid'] : 'col-12';
		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '' );
		$html = !empty($instance['html']) ? $instance['html'] : 'h2';

		$post_type = !isset($instance['include_columist']) ? 'post' : array('post', 'columist');
		$categories = (isset($instance['categories'])) ? $instance['categories'] : '';
		$tags = (isset($instance['tags'])) ? $instance['tags'] : '';
    $posts = (isset($instance['posts'])) ? $instance['posts'] : '5';
    $offset = (isset($instance['offset'])) ? $instance['offset'] : '';
    $date_range = (isset($instance['date_range']) && $instance['date_range'] != '0') ? $instance['date_range'] : null;
    $sortby = (isset($instance['sortby'])) ? $instance['sortby'] : 'recent';
		$is_do_not_dublicate = $instance['postnotin'] == 'on' ? true : false;

		$format = !empty($instance['format']) ? $instance['format'] : '';

		$show_post_cat = isset($instance['show_post_cat']) ? 'on' : 'off';
		$show_post_date = isset($instance['show_post_date']) ? 'on' : 'off';

		$bg_color = !empty($instance['bg-color']) ? $instance['bg-color'] : '';
		$bg_color2 = !empty($instance['bg-color2']) ? $instance['bg-color2'] : '';
		$accent_color = !empty($instance['accent-color']) ? $instance['accent-color'] : '';
		$cat_list = !isset($instance['cat_list']) ? false : true;
		

		$query_args = array(
			'post_type'			=> $post_type,
			'number'				=> $posts,
			'id'    				=> $categories,
			'sortby' 				=> $sortby,
			'tags_ids' 			=> $tags,
			'offset' 				=> $offset,
			'range'				  => $date_range,
			'format'				=> $format
		);
		$kanews_query = kan_query( $query_args );
		
		$col = 'col-12';
		$col_big = 'col-12';
		if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
		
		if(isset($sidebar[2]) && $sidebar[2] == 'full') {
			$col = 'col-6 col-md-4 col-lg-3';
			$col_big = 'col-12 col-lg-6';
		} elseif($sidebar[1] == 'content') {
			$col = 'col-6 col-md-4';
			$col_big = 'col-12 col-lg-8';
		}

		?>

		<?php if ($kanews_query->have_posts()) :
			$widget_id = '#'. $args['widget_id'];
			$output_css = '';

			if ( ! empty( $bg_color ) ){
				$output_css .= "
				.light-mode $widget_id .kanews-widget-header:after {
						background-color: $bg_color !important;
					}
				";
			}

			if( $bg_color2 != '') {
				$output_css .= "
				$widget_id .kanews-post-item {
				background: transparent !important
				}

				.light-mode $widget_id.kanews-section {
					background: $bg_color2 !important;
				}
				";
			}

			if( $accent_color != '') {
				$output_css .= "
				$widget_id {
					--kan-theme-color: $accent_color
				}
				";
			}

			if( !empty($output_css) ) {
				echo "<style id='kanews-theme-inline-$widget_id' scoped type=\"text/css\">".( kan_minify_css($output_css) ) ."</style>";
			}
			?>
			<div class="<?php echo $grid; ?>"> 
				<div id="<?php echo $this->id; ?>" class="kanews-section <?php echo $this->widget_options['classname']; ?>">
					<?php if ( ! empty($instance['title']) ) : ?>
						<div class="kanews-widget-header">
							<?php 
								echo ( $args['before_title'] . $title . $args['after_title'] );
							?>
						</div>
					<?php endif; ?>

					<?php if ( $cat_list && isset($categories[1]) ) : ?>

						<div class="kanews_widget_posts_6">
							<div class="kanews-tab">
								<ul class="nav nav-tabs d-flex flex-wrap">

									<?php $number= 0; if($categories): foreach( $categories as $category ) {  $number++;?>
										<li class="nav-item">
											<a href="<?php echo get_category_link($category); ?>" class="nav-link">	<?php echo get_cat_name($category); ?></a>
										</li>
									<?php } endif; ?>
								</ul>
							</div>
						</div>

					<?php endif; ?>

					<div class="row equal-height">
						<?php $counter = 0; while($kanews_query->have_posts()): $kanews_query->the_post(); global $post; $counter++; ?>

								<?php if($counter == 1): ?>
									<div class="<?php echo $col_big; ?>">
										<div class="kanews-post-overlay kanews-post-big mb-0">
											<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>		
											<?php kanews_post_thumbnail('kanews-post-2', 'kanews-post-thumb'); ?>
											<?php do_action('kanews_post_hook'); ?>
											<div class="kanews-post-content">
												<?php if($show_post_cat != 'off'): ?>
													<?php echo kanews_primary_category($post->ID); ?>
												<?php endif; ?>
												<?php the_title( sprintf( '<'.$html.' class="kanews-post-headline truncate truncate-3"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></'.$html.'>' ); ?>
												<?php if($show_post_date != 'off'): ?>
													<?php echo kanews_post_date(); ?>
												<?php endif; ?>
											</div>
										</div>
									</div>
								<?php else: ?>
									<div class="<?php echo $col; ?>">
										<div class="kanews-post-item kanews-post-grid-item">
											<a href="<?php the_permalink(); ?>" class="kanews-post-href" aria-label="<?php the_title(); ?>"></a>	
											<?php do_action('kanews_post_hook'); ?>
											<?php kanews_post_thumbnail('kanews-post-1', 'kanews-post-thumb'); ?>
											<div class="kanews-post-content">
												<?php if($show_post_cat != 'off'): ?>
													<?php echo kanews_primary_category($post->ID, 'style-2'); ?>
												<?php endif; ?>
												<?php the_title( sprintf( '<'.$html.' class="kanews-post-headline truncate truncate-2"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></'.$html.'>' ); ?>
												<?php if($show_post_date != 'off'): ?>
													<?php echo kanews_post_date(); ?>
												<?php endif; ?>
											</div>
										</div>
									</div>
								<?php endif; ?>
							<?php 
							if( $is_do_not_dublicate ){
								Kanews\Helper::do_not_dublicate( $post->ID );
							}
							?>
						<?php endwhile; wp_reset_postdata(); ?>

						<?php if ( ! empty($instance['show_more_link']) ): ?>
							<div class="col-12">
								<div class="col-12 col-md-8 mt-0 m-auto"><a href="<?php echo esc_url($instance['show_more_link']); ?>" class="kanews-btn kanews-btn-block kanews-btn-sm kanews-btn-o"><?php esc_html_e( 'Daha Fazla', 'kanews' ); ?></a></div>
							</div>
						<?php endif; ?>

					</div>
				</div>
			</div>
		<?php endif;


	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['grid'] = $new_instance['grid'];
		$instance['html'] = $new_instance['html'];

		$instance['categories'] = $new_instance['categories'];
		$instance['tags'] = $new_instance['tags'];
		$instance['posts'] = $new_instance['posts'];
		$instance['offset'] = $new_instance['offset'];
		$instance['sortby'] = $new_instance['sortby'];
    $instance['postnotin'] = $new_instance['postnotin'];
		$instance['date_range'] = $new_instance['date_range'];
		$instance['format'] = $new_instance['format'];

		$instance['show_more_link'] = $new_instance['show_more_link'];
		$instance['show_post_cat'] = $new_instance['show_post_cat'];
		$instance['show_post_date'] = $new_instance['show_post_date'];
		$instance['include_columist'] = $new_instance['include_columist'];

		$instance['cat_list'] = $new_instance['cat_list'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
		$instance['bg-color'] = $new_instance['bg-color'];
		$instance['bg-color2'] = $new_instance['bg-color2'];
		$instance['accent-color'] = $new_instance['accent-color'];
		
		return $instance;
	}

	
  // Back-end
	public function form($instance) {
		$defaults = array( 
			// Genel Ayarlar
			'title' => esc_html__('Modül', 'kanews'),
			'show_more_link' => '',
			'grid' => 'col-12',
			'html' => 'h3',

			// Sıralama Ayarları
			'postnotin' => '',
			'tags' => '',
			'categories' => array(), 
			'posts' => 8,
			'sortby' => 'recent',
			'date_range' => '0', 
			'format' => '0',
			'offset' => '0',
			'include_columist' => 'off',

			// İçerik Ayarları
			'show_post_cat' => 'on',
			'show_post_date' => 'off',
			'cat_list' => 'off',

			// Görünüm Ayarları
			'accent-color' => '',
			'bg-color' => '',
			'bg-color2' => '',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off',
		);

		$instance = wp_parse_args((array) $instance, $defaults); 


		// Genel Ayarlar Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('show_more_link'),
					'name' => $this->get_field_name('show_more_link'),
					'label' => __('Daha Fazla Linki', 'kanews'),
					'value' => $instance['show_more_link']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('html'),
					'name' => $this->get_field_name('html'),
					'label' => __('Yazı Başlığı HTML Tag', 'kanews'),
					'value' => $instance['html'],
					'options' => array(
						'div' => 'Div',
						'h1' => 'H1',
						'h2' => 'H2',
						'h3' => 'H3',
						'h4' => 'H4',
						'h5' => 'H5',
						'h6' => 'H6'
					)
				)
			)
		));

		// Sıralama Ayarları - Global metod kullanımı
		Kanews_Form_Elements::render_posts_sorting_settings($this, $instance);

		// İçerik Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('İçerik Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_date'),
					'name' => $this->get_field_name('show_post_date'),
					'label' => __('Yazı Tarihini Göster', 'kanews'),
					'value' => $instance['show_post_date']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('show_post_cat'),
					'name' => $this->get_field_name('show_post_cat'),
					'label' => __('Yazı Kategorisini Göster', 'kanews'),
					'value' => $instance['show_post_cat']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('cat_list'),
					'name' => $this->get_field_name('cat_list'),
					'label' => __('Kategorileri Listele', 'kanews'),
					'value' => $instance['cat_list']
				)
			)
		));

		// Görünüm Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Görünüm Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('accent-color'),
					'name' => $this->get_field_name('accent-color'),
					'label' => __('Birincil Renk', 'kanews'),
					'value' => $instance['accent-color']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color'),
					'name' => $this->get_field_name('bg-color'),
					'label' => __('Arkaplan Rengi', 'kanews'),
					'value' => $instance['bg-color']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_COLOR,
					'id' => $this->get_field_id('bg-color2'),
					'name' => $this->get_field_name('bg-color2'),
					'label' => __('Arkaplan Rengi 2', 'kanews'),
					'value' => $instance['bg-color2']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				)
			)
		));
	}
}
?>