<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_currencies extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_currencies');
		$control_ops = array('id_base' => 'kanews_widget_currencies');
		parent::__construct('kanews_widget_currencies', ''.KAN_THEME_NAME .' - '.__( "Piyasalar" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

	}
  
  // Front-end
	public function widget($args, $instance)
	{
    // Görünürlük kontrolü
    $hide_mobile = isset($instance['hide_mobile']) && $instance['hide_mobile'] === 'on';
    $hide_desktop = isset($instance['hide_desktop']) && $instance['hide_desktop'] === 'on';

    if (($hide_mobile && kan_is_mobile()) || ($hide_desktop && !kan_is_mobile())) {
    return;
    }

    // Instance değerlerini al
    $title = apply_filters('widget_title', $instance['title'] ?? '');
    $grid = $instance['grid'] ?? 'col-12';
    $type = $instance['type'] ?? 'box';
    $currencies = $instance['currencies'] ?? [];
    $show_change = isset($instance['show_change']) && $instance['show_change'] === 'on';
    $ticker = isset($instance['ticker']) && $instance['ticker'] === 'on';
    $pages = $instance['pages'] ?? '';
    $show_images = isset($instance['show_images']) && $instance['show_images'] === 'on';
    $hide_desktop = isset($instance['hide_desktop']) && $instance['hide_desktop'] === 'on';
    $hide_mobile = isset($instance['hide_mobile']) && $instance['hide_mobile'] === 'on';

    // Altın verilerini al
    $gold_data = get_local_file_contents(KAN_TEMPLATE_PATH."/inc/api/gold/gold.json");
    if ($gold_data === false) {
        error_log('Altın verileri yüklenemedi: ' . KAN_TEMPLATE_PATH."/inc/api/gold/gold.json");
        $gold_data = [];
    } else {
        $gold_data = json_decode($gold_data, true);
        if( isset($gold_data['data']) ) {
            $gold_data = $gold_data['data'];
        } else {
            error_log('Altın verileri geçersiz format: ' . print_r($gold_data, true));
            $gold_data = [];
        }
    }

    // Altın kodlarını eşleştir
    $gold_code_mapping = [
        'IKI' => 'IKIBUCUKALTIN',
        'OSA' => '18AYARALTIN',
        'GRA' => 'GRA',
        'CEY' => 'CEYREKALTIN',
        'YAR' => 'YARIMALTIN',
        'TAM' => 'TAMALTIN',
        'CUM' => 'CUMHURIYETALTINI',
        'ATA' => 'ATAALTIN',
        'ODA' => '14AYARALTIN',
        'YIA' => 'YIA',
        'BES' => 'BESLIALTIN',
        'GRE' => 'GREMSEALTIN',
        'RES' => 'RESATALTIN',
        'HAM' => 'HAMITALTIN',
        'GUM' => 'GUMUS',
        'ONS' => 'ONS'
    ];

    // Döviz verilerini al
    $currency_data = Kanews\Currencies::update();

    if (empty($currencies) || (!$currency_data && !$gold_data)) {
			return;
		}

    // Render metodlarına geçirilecek veriyi hazırla
    $combined_data = new stdClass();
    foreach ($currencies as $currency) {
        if (isset($gold_code_mapping[$currency]) && isset($gold_data[$gold_code_mapping[$currency]])) {
            // Altın verisi
            $gold_item = $gold_data[$gold_code_mapping[$currency]];
            $combined_data->$currency = (object)[
                'name' => $gold_item['Name'],
                'value' => $gold_item['Selling'],
                'buying' => $gold_item['Buying'] ?? 0,
                'change_percent' => floatval(str_replace('%', '', $gold_item['Change'])),
                'is_gold' => true
            ];
        } elseif (isset($currency_data->$currency)) {
            // Döviz verisi
            $combined_data->$currency = $currency_data->$currency;
            $combined_data->$currency->is_gold = false;
        }
    }

    // Grid ve gösterim sayısını ayarla
    $show = $this->get_show_count($args['id'] ?? '');
    if ($show === 2) {
      $grid = 'col-12';
    }

    // Widget içeriğini oluştur
    ?>
    <div class="<?php echo esc_attr($grid); ?>">
      <div class="kanews-section">
          <?php 
            echo kanews_widget_title($title);
            
            if ($type === 'table') {
                $this->render_table_view($currencies, $combined_data, $show_change, $pages, $show_images);
            } else {
                $this->render_box_view($currencies, $combined_data, $show_change, $show, $ticker, $pages, $show_images);
            }
            ?>
      </div>
    </div>
  <?php
	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['pages'] = $new_instance['pages'];
		$instance['grid'] = $new_instance['grid'];
		$instance['type'] = $new_instance['type'];
		$instance['currencies'] = (array)$new_instance['currencies'];
		$instance['show_change'] = $new_instance['show_change'];
		$instance['ticker'] = $new_instance['ticker'];
        $instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];
        $instance['show_images'] = $new_instance['show_images'];
		
		return $instance;
	}

  // Back-end
	public function form($instance)
	{
		$defaults = array( 
      'title' => esc_html__('Piyasalar', 'kanews'), 
			'type' => 'box', 
			'grid' => 'col-12', 
      'pages' => 'all', 
			'show_change' => 'on', 
			'show_images' => 'on',
			'currencies' => array('usd', 'eur', 'gau', 'ise-100', 'btc', 'gbp'), 
      'ticker' => 'off',
      'hide_desktop' => 'off',
			'hide_mobile' => 'off'
    );
		$instance = wp_parse_args((array) $instance, $defaults);

    // Genel Ayarlar
    Kanews_Form_Elements::render_accordion_field([
        'title' => __('Genel Ayarlar', 'kanews'),
        'content' => [
            [
                'type' => Kanews_Form_Elements::TYPE_TEXT,
                'id' => $this->get_field_id('title'),
                'name' => $this->get_field_name('title'),
                'label' => __('Başlık', 'kanews'),
                'value' => $instance['title']
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_SELECT,
                'id' => $this->get_field_id('grid'),
                'name' => $this->get_field_name('grid'),
                'label' => __('Genişlik', 'kanews'),
                'value' => $instance['grid'],
                'options' => [
                    'col' => __('Sığdır', 'kanews'),
                    'col-12' => '12/12',
                    'col-12 col-lg-8' => '12/8',
                    'col-12 col-lg-6' => '12/6',
                    'col-12 col-lg-4' => '12/4'
                ]
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_SELECT,
                'id' => $this->get_field_id('type'),
                'name' => $this->get_field_name('type'),
                'label' => __('Tür', 'kanews'),
                'value' => $instance['type'],
                'options' => [
                    'table' => __('Tablo', 'kanews'),
                    'box' => __('Modern', 'kanews')
                ]
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                'id' => $this->get_field_id('ticker'),
                'name' => $this->get_field_name('ticker'),
                'label' => __('Kayan Hale Çevir (Ticker)', 'kanews'),
                'description' => __('Tür Modern ise kayan hale çevirir.', 'kanews'),
                'value' => $instance['ticker']
            ]
        ]
    ]);

    // Sayfa Ayarları
    Kanews_Form_Elements::render_accordion_field([
        'title' => __('Sayfa Ayarları', 'kanews'),
        'content' => [
            [
                'type' => Kanews_Form_Elements::TYPE_SELECT,
                'id' => $this->get_field_id('pages'),
                'name' => $this->get_field_name('pages'),
                'label' => __('Sayfa', 'kanews'),
                'value' => $instance['pages'],
                'options' => Kanews_Form_Elements::get_pages_options()
            ]
        ]
    ]);

    // Para Birimleri
    Kanews_Form_Elements::render_accordion_field([
        'title' => __('Para Birimleri', 'kanews'),
        'content' => [
            [
                'type' => Kanews_Form_Elements::TYPE_SELECT2,
                'id' => $this->get_field_id('currencies'),
                'name' => $this->get_field_name('currencies'),
                'label' => __('Gösterilecek Kurlar', 'kanews'),
                'value' => (array)$instance['currencies'],
                'multiple' => true,
                'placeholder' => __('Para birimlerini seçin...', 'kanews'),
                'options' => [
                    'usd' => __('Dolar', 'kanews'),
                    'euro' => __('Euro', 'kanews'),
                    'gbp' => __('İngiliz Sterlini', 'kanews'),
                    'chf' => __('İsviçre Frangı', 'kanews'),
                    'cny' => __('Çin Yuanı', 'kanews'),
                    'jpy' => __('Japon Yeni', 'kanews'),
                    'rub' => __('Rus Rublesi', 'kanews'),
                    'eur-usd' => __('EUR/USD', 'kanews'),
                    'ise-100' => __('Bist 100', 'kanews'),
                    'gau' => __('Gram Altın', 'kanews'),
                    'btc' => __('Bitcoin', 'kanews'),
                    'ltc' => __('Litecoin', 'kanews'),
                    'bch' => __('Bitcoin Cash', 'kanews'),
                    'eth' => __('Ethereum', 'kanews'),
                    'xrp' => __('XRP', 'kanews'),
                    'bnb' => __('BNB', 'kanews'),
                    'avax' => __('AVAX', 'kanews'),
                    'sol' => __('SOL', 'kanews'),
                    'ada' => __('ADA', 'kanews'),
                    'dot' => __('DOT', 'kanews'),
                    'doge' => __('DOGE', 'kanews'),
                    'shib' => __('SHIB', 'kanews'),
                    'ONS' => __('ONS Altın', 'kanews'),
                    'GUM' => __('Gümüş', 'kanews'),
                    'GRA' => __('Gram Altın', 'kanews'),
                    'CEY' => __('Çeyrek Altın', 'kanews'),
                    'YAR' => __('Yarım Altın', 'kanews'),
                    'TAM' => __('Tam Altın', 'kanews'),
                    'ATA' => __('Ata Altın', 'kanews'),
                    'RES' => __('Reşat Altın', 'kanews'),
                    'HAM' => __('Hamit Altın', 'kanews'),
                    'IKI' => __('İkibuçuk Altın', 'kanews'),
                    'GRE' => __('Gremse Altın', 'kanews'),
                    'BES' => __('Beşli Altın', 'kanews'),
                    'ODA' => __('14 Ayar Altın', 'kanews'),
                    'OSA' => __('18 Ayar Altın', 'kanews'),
                    'YIA' => __('22 Ayar Bilezik', 'kanews'),
                    'CUM' => __('Cumhuriyet Altını', 'kanews')
                ]
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                'id' => $this->get_field_id('show_change'),
                'name' => $this->get_field_name('show_change'),
                'label' => __('Değişimi Göster', 'kanews'),
                'value' => $instance['show_change']
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                'id' => $this->get_field_id('show_images'),
                'name' => $this->get_field_name('show_images'),
                'label' => __('Görselleri Göster', 'kanews'),
                'value' => $instance['show_images']
            ]
        ]
    ]);

    // Görünürlük Ayarları
    Kanews_Form_Elements::render_accordion_field([
        'title' => __('Görünürlük Ayarları', 'kanews'),
        'content' => [
            [
                'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                'id' => $this->get_field_id('hide_desktop'),
                'name' => $this->get_field_name('hide_desktop'),
                'label' => __('Masaüstünde Gizle', 'kanews'),
                'value' => $instance['hide_desktop']
            ],
            [
                'type' => Kanews_Form_Elements::TYPE_TOGGLE,
                'id' => $this->get_field_id('hide_mobile'),
                'name' => $this->get_field_name('hide_mobile'),
                'label' => __('Mobilde Gizle', 'kanews'),
                'value' => $instance['hide_mobile']
            ]
        ]
    ]);

   }

/**
 * Gösterim sayısını belirle
 */
private function get_show_count($widget_id) {
    if (empty($widget_id)) {
        return 5;
    }

    $sidebar = explode('-', $widget_id);
    $location = $sidebar[1] ?? 'content';

    switch ($location) {
        case 'sidebar':
            return 2;
        case 'content':
            return 3;
        default:
            return 5;
    }
}

/**
 * Tablo görünümünü oluştur
 */
private function render_table_view($currencies, $data, $show_change, $pages, $show_images = true) {
    ?>
    
    <table class="kanews-table table-currencies">
        <thead>
            <tr>
                <th><span class="nobr"><?php esc_html_e('Adı', 'kanews'); ?></span></th>
                <th style="text-align:right"><span class="nobr"><?php esc_html_e('Değer', 'kanews'); ?></span></th>
                <?php if ($show_change): ?>
                    <th style="text-align:right"><span class="nobr"><?php esc_html_e('Değişim', 'kanews'); ?></span></th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($currencies as $currency): 
                $this->render_table_row($currency, $data, $show_change, $show_images);
            endforeach; ?>
        </tbody>
    </table>
    <?php
    $this->render_show_more_link($pages);
}

/**
 * Tablo satırını oluştur
 */
private function render_table_row($currency, $data, $show_change, $show_images = true) {
    $item = $data->$currency;
    $is_gold = $item->is_gold ?? false;
    
    if ($is_gold) {
        // Altın için özel görünüm
        list($_, $img) = $show_images ? $this->get_currency_images($currency) : ['', ''];
        ?>
        <tr>
            <td>
                <div class="d-flex align-items-center">
                    <?php if ($show_images && $img): ?>
                    <span class="hbfdg12 me-2">
                        <?php echo $img; ?>
                    </span>
                    <?php endif; ?>
                    <span><?php echo esc_html($item->name); ?></span>
                </div>
            </td>
            <td style="text-align:right">
                <?php echo number_format((float)$item->value, 2, ",", "."); ?> TL
            </td>
            <?php if ($show_change): ?>
                <td style="text-align:right" class="<?php echo $item->change_percent < 0 ? 'color-danger' : 'color-success'; ?>">
                    <?php 
                    $icon = $item->change_percent < 0 
                        ? '<svg class="icon-trending color-danger icon-180deg" style="margin-right: 5px;" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>'
                        : '<svg class="icon-trending color-success" style="margin-right: 5px;" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
                    echo $icon . '%' . round($item->change_percent, 2);
                    ?>
                </td>
            <?php endif; ?>
        </tr>
        <?php
    } else {
        // Mevcut döviz görünümü
        $value = $item->value ?: $item->shutdown;
        $change_percent = $item->change_percent;
        $class = $change_percent < 0 ? 'color-danger' : 'color-success';
        $icon = $change_percent < 0 
            ? '<svg class="icon-trending color-danger icon-180deg" style="margin-right: 5px;" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>'
            : '<svg class="icon-trending color-success" style="margin-right: 5px;" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
        
        list($_, $img) = $show_images ? $this->get_currency_images($currency) : ['', ''];
        ?>
        <tr>
            <td>
                <div class="d-flex align-items-center">
                    <?php if ($show_images && $img): ?>
                    <span class="hbfdg12 me-2">
                        <?php echo $img; ?>
                    </span>
                    <?php endif; ?>
                    <span><?php echo $item->full ?: $item->name; ?></span>
                </div>
            </td>
            <td style="text-align:right">
                <?php echo number_format((float)$value, 3, ",", "."); ?>
            </td>
            <?php if ($show_change): ?>
                <td style="text-align:right" class="<?php echo $class; ?>">
                    <?php echo $icon; ?>
                    %<?php echo round($change_percent, 2); ?>
                </td>
            <?php endif; ?>
        </tr>
        <?php
    }
}

/**
 * Box görünümünü oluştur
 */
private function render_box_view($currencies, $data, $show_change, $show, $ticker, $pages, $show_images = true) {
    $slick_options = $ticker ? [
        'slidesToShow' => $show,
        'responsive' => [
            ['breakpoint' => 992, 'settings' => ['slidesToShow' => 3]],
            ['breakpoint' => 525, 'settings' => ['slidesToShow' => 2]]
        ]
    ] : null;

    $classes = $ticker ? 'kanews-inline-card kanews-ticker-x' : 'kanews-inline-card';
    ?>
    <div class="<?php echo esc_attr($classes); ?>" <?php echo $slick_options ? 'data-slick=\'' . wp_json_encode($slick_options) . '\'' : ''; ?>>
        <?php foreach ($currencies as $currency):
            $this->render_box_item($currency, $data, $show_change, $show_images);
        endforeach; ?>
    </div>
    <?php
    $this->render_show_more_link($pages, true);
}

/**
 * "Daha fazla göster" linkini oluştur
 */
private function render_show_more_link($pages, $is_box = false) {
    if ($pages && $pages !== 'all') {
        if ($is_box) {
            echo '<hr class="hr-widget">';
        }
        ?>
        <div class="col-12  text-center">
            <a href="<?php echo esc_url(get_page_link($pages)); ?>" class="kanews-label kanews-label-widget">
                <?php esc_html_e('Daha Fazla Göster', 'kanews'); ?>
            </a>
        </div>
        <div class="empty-space" style="height: 15px;"></div>
        <?php
    }
}

/**
 * Box öğesini oluştur
 */
private function render_box_item($currency, $data, $show_change, $show_images = true) {
    if (!isset($data->$currency)) {
        error_log('Para birimi verisi bulunamadı: ' . $currency);
        return;
    }

    $item = $data->$currency;
    $is_gold = $item->is_gold ?? false;
    
    if ($is_gold) {
        // Altın için özel box görünümü
        $class = isset($item->change_percent) && $item->change_percent < 0 ? 'border-danger color-danger' : 'border-success color-success';
        $icon = isset($item->change_percent) && $item->change_percent < 0 
            ? '<svg class="icon-trending icon-180deg" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>'
            : '<svg class="icon-trending" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
        
        list($_, $img) = $show_images ? $this->get_currency_images($currency) : ['', ''];
        ?>
        <div class="kanews-inline-card-item no-gutters">
            <?php if ($show_images && $img): ?>
            <div class="kanews-inline-card-icon col-auto">
                <span class="hbfdg12">
                    <?php echo $img; ?>
                </span>
            </div>
            <?php endif; ?>
            <div class="kanews-inline-card-summary col">
                <div class="kanews-inline-card-title d-flex justify-content-between">
                    <div><?php echo esc_html($this->get_gold_name($currency)); ?></div>
                    <?php if ($show_change && isset($item->change_percent)): ?>
                        <div><?php echo esc_html($item->change_percent . '%'); ?></div>
                    <?php endif; ?>
                </div>
                <div class="kanews-inline-card-content <?php echo esc_attr($class); ?>">
                    <?php 
                    echo esc_html($item->value ?? '0.00');
                    echo ' TL ', $icon;
                    ?>
                </div>
            </div>
        </div>
        <?php
    } else {
        // Mevcut döviz box görünümü
        $value = $item->value ?? $item->shutdown ?? '0.00';
        $change_percent = $item->change_percent ?? 0;
        $class = $change_percent < 0 ? 'color-danger' : 'color-success';
        $icon = $change_percent < 0 
            ? '<svg class="icon-trending color-danger icon-180deg" style="margin-right: 5px;" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>'
            : '<svg class="icon-trending color-success" style="margin-right: 5px;" xmlns="http://www.w3.org/2000/svg" height="16" width="18" fill="currentColor"><path d="M3.062 15 2 13.938l5.854-5.855 3.167 3.167 4.417-4.396H13v-1.5h5v5h-1.5V7.917l-5.479 5.458-3.167-3.167Z"/></svg>';
        
        list($_, $img) = $show_images ? $this->get_currency_images($currency) : ['', ''];
        ?>
        <div class="kanews-inline-card-item no-gutters">
            <?php if ($show_images && $img): ?>
            <div class="kanews-inline-card-icon col-auto">
                <span class="hbfdg12">
                    <?php echo $img; ?>
                </span>
            </div>
            <?php endif; ?>
            <div class="kanews-inline-card-summary col">
                <div class="kanews-inline-card-title d-flex justify-content-between">
                    <div><?php echo esc_html($item->full ?? $item->name ?? $currency); ?></div>
                    <?php if ($show_change && $change_percent): ?>
                        <div><?php echo esc_html($change_percent . '%'); ?></div>
                    <?php endif; ?>
                </div>
                <div class="kanews-inline-card-content <?php echo esc_attr($class); ?>">
                    <?php 
                    echo number_format((float)$value, 2, ",", ".");
                    echo ' TL ', $icon;
                    ?>
                </div>
            </div>
        </div>
        <?php
    }
}

/**
 * Para birimi için indeks değerini döndür
 */
private function get_currency_index($currency) {
    $crypto_currencies = ['btc', 'eth', 'xrp', 'bch', 'ltc', 'bnb', 'sol', 'avax', 'ada', 'dot', 'doge', 'shib'];
    
    if (in_array($currency, $crypto_currencies)) {
        return kanews_get_option('crypto-page-index', 'try');
    }
    
    switch ($currency) {
        case 'ukoil':
            return 'usd';
        default:
            return 'try';
    }
}

/**
 * Para birimi için bayrak/ikon görsellerini döndür
 */
private function get_currency_images($currency) {
    $images = [
        'usd' => ['US', 'country'],
        'euro' => ['EU', 'country'],
        'gbp' => ['GB', 'country'],
        'chf' => ['CH', 'country'],
        'cny' => ['CN', 'country'],
        'jpy' => ['JP', 'country'],
        'rub' => ['RU', 'country'],
        'eur-usd' => ['EU', 'country'],
        'ukoil' => ['crude-oil--big', ''],
        'ise-100' => ['TR', 'country'],
        'gau' => ['metal/gold', ''],
        'btc' => ['crypto/XTVCBTC', 'crypto'],
        'eth' => ['crypto/XTVCETH', 'crypto'],
        'xrp' => ['crypto/XTVCXRP', 'crypto'],
        'bch' => ['crypto/XTVCBCH', 'crypto'],
        'ltc' => ['crypto/XTVCLTC', 'crypto'],
        'bnb' => ['crypto/XTVCBNB', 'crypto'],
        'sol' => ['crypto/XTVCSOL', 'crypto'],
        'avax' => ['crypto/XTVCAVAX', 'crypto'],
        'ada' => ['crypto/XTVCADA', 'crypto'],
        'dot' => ['crypto/XTVCDOT', 'crypto'],
        'doge' => ['crypto/XTVCDOGE', 'crypto'],
        'shib' => ['crypto/XTVCSHIB', 'crypto'],
        'ONS' => ['metal/gold', ''],
        'GUM' => ['metal/silver', ''],
        'GRA' => ['metal/gold', ''],
        'CEY' => ['metal/gold', ''],
        'YAR' => ['metal/gold', ''],
        'TAM' => ['metal/gold', ''],
        'ATA' => ['metal/gold', ''],
        'RES' => ['metal/gold', ''],
        'HAM' => ['metal/gold', ''],
        'IKI' => ['metal/gold', ''],
        'GRE' => ['metal/gold', ''],
        'BES' => ['metal/gold', ''],
        'ODA' => ['metal/gold', ''],
        'OSA' => ['metal/gold', ''],
        'YIA' => ['metal/gold', ''],
        'CUM' => ['metal/gold', '']
    ];

    if (!isset($images[$currency])) {
        return ['', ''];
    }

    list($path, $type) = $images[$currency];
    
    $img = $type === 'country' 
        ? kanews_get_local_image(
            "https://s3-symbol-logo.tradingview.com/country/{$path}.svg",
            ['alt' => $currency, 'width' => 18, 'height' => 18],
            '1e1'
        )
        : kanews_get_local_image(
            "https://s3-symbol-logo.tradingview.com/{$path}.svg",
            ['alt' => $currency, 'width' => 18, 'height' => 18],
            '1e1'
        );

    return ['', $img];
}

/**
 * Altın adını formatla
 */
private function get_gold_name($code) {
    $names = [
        'GRA' => 'Gram Altın',
        'CEY' => 'Çeyrek Altın',
        'YAR' => 'Yarım Altın',
        'TAM' => 'Tam Altın',
        'CUM' => 'Cumhuriyet Altını',
        'ATA' => 'Ata Altın',
        'ODA' => '14 Ayar Altın',
        'OSA' => '18 Ayar Altın',
        'YIA' => '22 Ayar Bilezik',
        'IKI' => 'İkibuçuk Altın',
        'BES' => 'Beşli Altın',
        'GRE' => 'Gremse Altın',
        'RES' => 'Reşat Altın',
        'HAM' => 'Hamit Altın',
        'GUM' => 'Gümüş',
        'ONS' => 'Ons Altın'
    ];
    
    return $names[$code] ?? $code;
}
}
?>