<?php

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

if(is_admin() || is_customize_preview(  )) {
	require_once dirname(__FILE__) . '/widget-framework.php';
}

// Widget Class
class kanews_widget_class_ads extends WP_Widget {

  // Create
	public function __construct(){
		$widget_ops = array('classname' => 'kanews_widget_ads kanews-section-flat kanews-section-gutter');
		$control_ops = array('id_base' => 'kanews_widget_ads');
		parent::__construct('kanews_widget_ads', ''.KAN_THEME_NAME .' - '.__( "Reklam" , 'kanews' ), $widget_ops, $control_ops );
		add_action('admin_enqueue_scripts', array('Kanews_Form_Elements', 'enqueue_scripts'));

	}
  
  // Front-end
	public function widget($args, $instance)
	{
		$hide_mobile = isset($instance['hide_mobile']) ? 'on' : 'off';
		$hide_desktop = isset($instance['hide_desktop']) ? 'on' : 'off';

		if($hide_mobile == 'on' && kan_is_mobile()) return;
		if($hide_desktop == 'on' && !kan_is_mobile()) return;

		$title = apply_filters('widget_title', isset($instance['title']) ? $instance['title'] : '');
		$adtitle = $instance['adtitle'] ? $instance['adtitle'] : '';
		$grid = $instance['grid'] ? $instance['grid'] : 'col-12';
		$ad_type = isset($instance['ad_type']) ? $instance['ad_type'] : 'code';
    
		if(isset($args['id']))
		$sidebar = explode('-', $args['id']);
		else
		$sidebar = array('0' => 'home', '1' => 'content');
		
		if($sidebar[1] == 'sidebar')
		$grid = 'col-12';
    
		if(!kanews_insights_control(get_current_user_id())) {
		  echo '<div class="'.$grid.'">';
			echo '<div id="'.$this->id.'" class="kanews-section '.$this->widget_options['classname'].'">';
						if ( ! empty($instance['title']) ){
							echo ( $args['before_title'] . $title . $args['after_title'] );
						}
			  echo '<div class="kanews-banner kanews-banner-widget">';
				echo $adtitle ? '<div class="kanews-banner-title"><span>'.$adtitle.'</span></div>' : '';
				
				if($ad_type === 'code' && !empty($instance['code'])) {
					echo $instance['code'];
				} elseif($ad_type === 'image' && !empty($instance['image_url'])) {
					$img_attr = '';
					if(!empty($instance['image_width'])) $img_attr .= ' width="'.$instance['image_width'].'"';
					if(!empty($instance['image_height'])) $img_attr .= ' height="'.$instance['image_height'].'"';
					if(!empty($instance['image_link'])) {
						echo '<a href="'.esc_url($instance['image_link']).'" target="_blank" rel="nofollow">';
					}
					echo '<img src="'.esc_url($instance['image_url']).'" alt="'.esc_attr($instance['image_alt']).'"'.$img_attr.' />';
					if(!empty($instance['image_link'])) {
						echo '</a>';
					}
				}
			  echo '</div>';
			echo '</div>';
		  echo '</div>';
		}

	}
  
  // Update Form
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['adtitle'] = $new_instance['adtitle'];
		$instance['grid'] = $new_instance['grid'];
		$instance['ad_type'] = $new_instance['ad_type'];
		$instance['code'] = $new_instance['code'];
		$instance['image_url'] = $new_instance['image_url'];
		$instance['image_link'] = $new_instance['image_link'];
		$instance['image_width'] = $new_instance['image_width'];
		$instance['image_height'] = $new_instance['image_height'];
		$instance['image_alt'] = $new_instance['image_alt'];
		$instance['hide_desktop'] = $new_instance['hide_desktop'];
		$instance['hide_mobile'] = $new_instance['hide_mobile'];

		return $instance;
	}

  // Back-end
	public function form($instance) {
		$defaults = array( 
			'title' => '', 
			'adtitle' => esc_html__('Reklam', 'kanews'),
			'grid' => 'col-12', 
			'ad_type' => 'code',
			'code' => '', 
			'image_url' => '',
			'image_link' => '',
			'image_width' => '',
			'image_height' => '',
			'image_alt' => '',
			'hide_desktop' => 'off',
			'hide_mobile' => 'off',
		);
		
		$instance = wp_parse_args((array) $instance, $defaults);

		// Genel Ayarlar Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Genel Ayarlar', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('title'),
					'name' => $this->get_field_name('title'),
					'label' => __('Başlık', 'kanews'),
					'value' => $instance['title']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TEXT,
					'id' => $this->get_field_id('adtitle'),
					'name' => $this->get_field_name('adtitle'),
					'label' => __('Reklam Başlığı', 'kanews'),
					'value' => $instance['adtitle'],
					'description' => __('İçeriğin reklam olduğunu belirtmek için bir yazı.', 'kanews')
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('grid'),
					'name' => $this->get_field_name('grid'),
					'label' => __('Genişlik', 'kanews'),
					'value' => $instance['grid'],
					'options' => array(
						'col-12' => '12/12',
						'col-12 col-lg-8' => '12/8',
						'col-12 col-lg-6' => '12/6',
						'col-12 col-lg-4' => '12/4',
						'col-12 col-md' => 'Sığdır'
					)
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_SELECT,
					'id' => $this->get_field_id('ad_type'),
					'name' => $this->get_field_name('ad_type'),
					'label' => __('Reklam Türü', 'kanews'),
					'value' => $instance['ad_type'],
					'options' => array(
						'code' => __('HTML Kod', 'kanews'),
						'image' => __('Görsel', 'kanews')
					)
				)
			)
		));


			Kanews_Form_Elements::render_accordion_field(array(
				'title' => __('HTML Kod Ayarları', 'kanews'),
				'class' => 'html-code-settings',
				'content' => array(
					array(
						'type' => Kanews_Form_Elements::TYPE_TEXTAREA,
						'id' => $this->get_field_id('code'),
						'name' => $this->get_field_name('code'),
						'label' => __('Reklam Kodu', 'kanews'),
						'value' => $instance['code'],
						'allow_html' => true
					)
				)
			));
		

		// Görsel Ayarları

			Kanews_Form_Elements::render_accordion_field(array(
				'title' => __('Görsel Ayarları', 'kanews'),
				'class' => 'image-settings',
				'content' => array(
					array(
						'type' => Kanews_Form_Elements::TYPE_MEDIA,
						'id' => $this->get_field_id('image_url'),
						'name' => $this->get_field_name('image_url'),
						'label' => __('Reklam Görseli', 'kanews'),
						'value' => $instance['image_url'],
						'preview' => true,
						'description' => __('Reklam görseli seçin veya yükleyin', 'kanews')
					),
					array(
						'type' => Kanews_Form_Elements::TYPE_URL,
						'id' => $this->get_field_id('image_link'),
						'name' => $this->get_field_name('image_link'),
						'label' => __('Reklam Linki', 'kanews'),
						'value' => $instance['image_link'],
						'placeholder' => 'https://'
					),
					array(
						'type' => Kanews_Form_Elements::TYPE_TEXT,
						'id' => $this->get_field_id('image_alt'),
						'name' => $this->get_field_name('image_alt'),
						'label' => __('Görsel Alt Metni', 'kanews'),
						'value' => $instance['image_alt']
					),
					array(
						'type' => Kanews_Form_Elements::TYPE_NUMBER,
						'id' => $this->get_field_id('image_width'),
						'name' => $this->get_field_name('image_width'),
						'label' => __('Görsel Genişliği (px)', 'kanews'),
						'value' => $instance['image_width']
					),
					array(
						'type' => Kanews_Form_Elements::TYPE_NUMBER,
						'id' => $this->get_field_id('image_height'),
						'name' => $this->get_field_name('image_height'),
						'label' => __('Görsel Yüksekliği (px)', 'kanews'),
						'value' => $instance['image_height']
					)
				)
			));
		

		// Görünüm Ayarları Accordion
		Kanews_Form_Elements::render_accordion_field(array(
			'title' => __('Görünüm Ayarları', 'kanews'),
			'content' => array(
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_desktop'),
					'name' => $this->get_field_name('hide_desktop'),
					'label' => __('Masaüstünde Gizle', 'kanews'),
					'value' => $instance['hide_desktop']
				),
				array(
					'type' => Kanews_Form_Elements::TYPE_TOGGLE,
					'id' => $this->get_field_id('hide_mobile'),
					'name' => $this->get_field_name('hide_mobile'),
					'label' => __('Mobilde Gizle', 'kanews'),
					'value' => $instance['hide_mobile']
				)
			)
		));
	}
}
?>