<?php
defined( 'ABSPATH' ) || exit; // Exit if accessed directly


// Check core class for avoid errors
if( class_exists( 'CSF' ) ) {


  $prefix = 'kanews_options';
  
  add_action('after_setup_theme', function() use ($prefix) {

  CSF::createOptions( $prefix, array(
    'menu_title' => esc_html__('kanews', 'Admin Menu Title',  'kanews'),
    'menu_slug'  => 'kanews-options',
    'menu_type'           => 'submenu',
    'menu_parent'         => 'kanews',
    'framework_title'     => 'Kanews <span class="kan-theme-ver">'.KAN_THEME_VER.'</span>',
    'show_bar_menu' => false,
    'admin_bar_menu_icon' => 'dashicons-admin-generic',
    'footer_credit'         => esc_html__('Kan Themes Gururla Sunar.', 'kanews'),
    'footer_text'         => '',
    'theme'               => 'dark',
    'database'               => 'option'
	) );

  /**
	 * General Settings
	 */
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Genel Ayarlar', 'kanews'),
    'icon'  => 'fas fa-cog',
    'fields' => array(
      
      // Logo
      array(
        'type'    => 'heading',
        'content' => esc_html__('Logo Ayaları', 'kanews'),
      ),
      array(
        'id'     => 'logo',
        'type'   => 'fieldset',
        'title'   => esc_html__('Site Logosu', 'kanews' ),
        'fields' => array(
          array(
            'id'      => 'type',
            'type'    => 'radio',
            'inline'  => false,
            'options' => array(
              'text'    => esc_html__('Yazı', 'kanews'),
              'img'    => esc_html__('Görsel', 'kanews'),
            ),
          ),
          array(
            'id'    => 'logo-text',
            'type'  => 'text',
            'title' => __('Site İsmi', 'kanews'),
            'dependency' => array( 'type', '==', 'text' ),
          ),
          array(
            'type'       => 'media',
            'id'          => 'logo-img',
            'button_title' => esc_html__('Görsel Yükle', 'kanews'),
            'dependency' => array( 'type', '==', 'img' ),
          ),
        ),
        'default' => array(
          'type' => 'text',
          'logo-text' => KAN_THEME_NAME,
        ),
      ),
      // Retina Logo
      array(
        'id'    => 'logo-mobile',
        'title'  => esc_html__('Retina Logo', 'kanews'),
        'desc'  => esc_html__('Ana logodan 2 kat daha büyük olmalıdır.', 'kanews'),
        'type'  => 'media'
      ),
      // Dark Logo
      array(
        'id'    => 'logo-dark',
        
        'title'  => esc_html__('Koyu Mod Logo', 'kanews'),
        'desc'  => esc_html__('Koyu mod aktif edildiğinde gözükecek olan logo.', 'kanews'),
        'type'  => 'media'
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Genel Ayarlar', 'kanews'),
      ),
      
      
      // Dark Mode
      array(
        'id'    => 'default-mode',
        'title'  => esc_html__('Varsayılan Mod', 'kanews'),
        'desc'  => esc_html__('Siteye ilk girişte hangi mod görünecek.', 'kanews'),
        'type'  => 'select',
        'options' => array(
          'light' => esc_html__('Açık', 'kanews'),

          'dark' => esc_html__('Koyu', 'kanews'),
        ),
        'default' => 'light'
      ),
      array(
        'id'    => 'mode',
        'title'  => esc_html__('Gece/Gündüz Modu', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),
      array(
        'id'    => 'mode_system',
        'title'  => esc_html__('Gece/Gündüz Modu', 'kanews').'-'.esc_html__( 'Sistem', 'kanews' ),
        'type'  => 'switcher',
        'dependency' => array( 'mode', '==', 'true' ),
        'default' => false
      ),

      array(
        'id'      => 'ajax-search',
        'title'   => esc_html__('Ajax Search', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Views
      array(
        'id'    => 'post-views',
        'title'  => esc_html__('Okunma Sayısı', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'post-views-source',
        'type'    => 'select',
        'title'   => esc_html__('Okunma Sayısı Kaynağı', 'kanews'),
        'dependency' => array( 'post-views', '==', 'true' ),
        'options' => array(
          'theme' => esc_html__('Tema', 'kanews'),
          'post-views-counter' => esc_html__('Post Views Counter', 'kanews'),
        ),
        'default' => 'theme'
      ),
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'dependency' => array( 'post-views-source', '==', 'post-views-counter' ),
        'content' => '<a target="_blank" href="'.admin_url('plugin-install.php?tab=plugin-information&amp;plugin=post-views-counter&amp;TB_iframe=true&amp;width=640&amp;height=500').'">Post Views Counter</a> eklentisinin kurulu olması gerekiyor.',
      ),
      
      // Sticky Sidebar
      array(
        'id'    => 'sticky-sidebar',
        'title'  => esc_html__('Yapışkan Sidebar', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ), 

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Seo Ayarları', 'kanews'),
      ),
      // Article Json LD
      array(
        'id'    => 'json-ld',
        'title'  => esc_html__('Yapısal Veri İşaretlemesi', 'kanews'),
        'help'  => esc_html__('Her wordpress yazısına json ld formatında yazının verilerini işaretler ve arama motorları bu verileri işler.', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ), 

      array(
        'id'      => 'article-json-ld-format',
        'type'    => 'select',
        'title'   => esc_html__('Yazılar için Yapısal Veri Tipi', 'kanews'),
        
        'dependency'  => array( 'json-ld', '==|==', 'true|true' ),
        'options' => array(
          'article' => esc_html__('Makale', 'kanews'),
          'NewsArticle' => esc_html__('Haber', 'kanews'),
          'BlogPosting' => esc_html__('Blog Yazısı', 'kanews'),
        ),
        'default' => 'NewsArticle'
      ),
      // Breadcrumb Json LD
      array(
        'id'    => 'breadcrumb',
        'title'  => esc_html__('Breadcrumb için Yapısal Veri', 'kanews'),
        'help'  => esc_html__('Her wordpress sayfasına json ld formatında breadcrumb verilerini ekler ve arama motorları bu verilerini işler.', 'kanews'),
        'type'  => 'switcher',
        'dependency' => array( 'json-ld', '==', 'true','', 'visible'  ),
        'default' => true
      ), 
      // OpenGraph
      array(
        'id'    => 'open-graph',
        'title'  => esc_html__('Open Graph Etiketleri', 'kanews'),
        'help'  => esc_html__('Sosyal medya siteleri için meta etiketi olarak yazı ve ana sayfalara site/yazı verilerini ekler ve sosyal medya siteleri bu verileri işler.', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ), 
      // Auto Refresh
      array(
        'id'    => 'auto-refresh',
        
        'title'  => esc_html__('Otomatik Sayfa Yenileme', 'kanews'),
        'help'  => esc_html__('Ziyaretçi belirlediğiniz süre boyunca aynı sayfada kalırsa otomatik olarak sayfa yenileme işlemi yapar.', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ), 
      array(
        'id'       => 'auto-refresh-time',
        'type'     => 'slider',
        'title'    => esc_html__('Otomatik Sayfa Yenileme Süresi', 'kanews'),
        'help'    => esc_html__('Saniye cinsinden belirlemeniz gerekir.', 'kanews'),
        'dependency' => array( 'auto-refresh', '==', 'true' ),
        'min'      => 60,
        'max'      => 1000,
        'step'     => 1,
        'default'  => 300,
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Hız Ayarları', 'kanews'),
      ),
      // Cache 
      array(
        'id'    => 'kanews-cache',
        'title'  => esc_html__('Dahili Önbellekler', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ), 
      // Speed Opt. 
      array(
        'id'    => 'kanews-speed',
        'title'  => esc_html__('Hız Optimizasyonları', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ), 
      // Preload sources
      array(
        'id'    => 'kanews-preload',
        'class'  => 'no-border',
        'title'  => esc_html__('Preload', 'kanews'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'default' => true
      ), 
      // Dns Prefetch
      array(
        'id'    => 'kanews-dns-prefetch',
        'class'  => 'no-border',
        'title'  => esc_html__('DNS Prefetch', 'kanews'),
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'default' => true
      ), 
      // JS Defer
      array(
        'id'    => 'kanews-js-defer',
        'title'  => esc_html__('JS Defer', 'kanews'),
        'class'  => 'no-border',
        'dependency' => array( 'kanews-speed', '==', 'true', '', 'visible'  ),
        'type'  => 'switcher',
        'default' => true
      ), 

      // LazyLoad
      array(
        'id'    => 'lazy',
        'title'  => esc_html__('Lazy Load', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ), 
      // Retina Logo
      array(
        'id'    => 'lazy-logo',
        'class'  => 'no-border',
        'title'  => esc_html__('Lazy Load Placeholder', 'kanews'),
        'dependency' => array( 'lazy', '!=', '' ),
        'type'  => 'media'
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar', 'kanews'),
      ),
      
       // Adblock
       array(
        'id'    => 'adblock-detected',
        'title'  => esc_html__('Reklam Engelleyicilerini Tespit Et', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ), 
       // Back to top
       array(
        'id'    => 'back-to-top',
        'title'  => esc_html__('Başa Dön Tuşu', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ), 
       // Right Click
       array(
        'id'    => 'right-click',
        'title'  => esc_html__('Sağ Tıkları Yasakla', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ), 
       // Copy
       array(
        'id'    => 'copy-event',
        'title'  => esc_html__('Kopyalama İşlemlerini Yasakla', 'kanews'),
        'type'  => 'switcher',
        
        'default' => false
      ), 
      // RSS Feed
      array(
        'id'       => 'featured-to-rss',
        'type'     => 'switcher',
        'default' => false,
        'title'    => esc_html__( 'RSS Feed\'ine Öne Çıkarılan Görseli Dahil Et', 'kanews' ),
      ),

       // Privacy Policy Box
       array(
        'id'    => 'privacy-policy',
        'title'  => esc_html__('Gizlilik Politikası Uyarısı', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ), 
      // Privacy Policy Page
      array(
        'id'          => 'privacy-policy-page',
        'type'        => 'select',
        'class'  => 'no-border',
        'title'       => esc_html__('Gizlilik Politikası Sayfası', 'kanews'),
        'dependency'  => array( 'privacy-policy', '==', 'true' ),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews')
      ),
      // Default Thumbnail
      array(
        'id'    => 'default-thumbnail',
        
        'title'  => esc_html__('Varsayılan Öne Çıkarılan Görsel', 'kanews'),
        'type'  => 'media'
      ),
      // WP Head
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Head Kodları', 'kanews'),
      ),
      array(
        'id'    => 'wp-head',
        'type'  => 'code_editor',
        'sanitize' => false,
        'desc'  => esc_html__('Head etiketi içerisine kod eklemenizi sağlar, örneğin meta kodları.', 'kanews'),
      ),

      // WP Footer
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Footer Kodları', 'kanews'),
      ),
      array(
        'id'    => 'wp-footer',
        'type'  => 'code_editor',
        'sanitize' => false,
        'desc'  => esc_html__('Body etiketinin sonuna kod eklemenizi sağlar, örneğin google analiz kodları, adsense kodları.', 'kanews'),
      ),
		)
	));
	
	/**
	 * Header
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Header Ayarları', 'kanews'),
    'icon'  => 'fas fa-heading',
    'fields' => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Header Ayarları', 'kanews'),
      ),
      
      // Layout
      array(
        'id'      => 'header-layout',
        'type'    => 'image_select',
        'title'   => esc_html__('Görünüm', 'kanews'),
        'options' => array(
          'style-1' => KAN_TEMPLATE_URL .'/framework/admin/assets/images/header/1.png',
          'style-2' => KAN_TEMPLATE_URL .'/framework/admin/assets/images/header/2.png',
          'style-3' => KAN_TEMPLATE_URL .'/framework/admin/assets/images/header/3.png',
          'style-4' => KAN_TEMPLATE_URL .'/framework/admin/assets/images/header/4.png',
        ),
        'default' => 'style-1',
      ),
      
      array(
        'id'      => 'header-skin',
        'type'    => 'select',
        'dependency' => array( 'header-layout', '==', 'style-1' ),
        'title'   => esc_html__('Renk Modu', 'kanews'),
        'options' => array(
          'dark' => esc_html__('Koyu', 'kanews'),
          'light' => esc_html__('Açık', 'kanews'),
        ),
        'default' => 'dark'
      ),

      array(
        'id'     => 'header-buttons',
        'type'   => 'group',
        'title'  => esc_html__('Butonlar', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
          array(
            'id'      => 'color',
            'type'    => 'color',
            'title'   => esc_html__('Arkaplan', 'kanews')
          ),
        ),
      ),

      array(
        'id'    => 'header-prayer',
        'title'  => esc_html__('Ramazan Sahur/İftar Geri Sayım', 'kanews'),
        'type'  => 'switcher',
        'class' => 'yeni',
        'default' => false
      ),

      array(
        'id'          => 'header-prayer-page',
        'type'        => 'select',
        'title'       => esc_html__('Detay Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'dependency' => array( 'header-prayer', '==', 'true' ),
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),

      array(
        'id'         => 'header-prayer-page-city',
        'type'       => 'text',
        'title'      => esc_html__('Şehir', 'kanews'),
        'desc'      => esc_html__('Sadece iller', 'kanews'),
        'default'    => 'İstanbul',
        'dependency' => array( 'header-prayer', '==', 'true' ),
      ),
      array(
        'id'         => 'header-prayer-page-city2',
        'type'       => 'text',
        'title'      => esc_html__('İlçe', 'kanews'),
        'desc'      => esc_html__('Sadece ilçeler', 'kanews'),
        'dependency' => array( 'header-prayer', '==', 'true' ),
      ),

      // Sub Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sub Header', 'kanews'),
      ),
      array(
        'id'    => 'subheader-switch',
        'title'  => esc_html__('Sub Header', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),

      array(
        'id'      => 'subheader-position',
        'type'    => 'select',
        'class'  => 'no-border',
        'title'   => esc_html__('Konumu', 'kanews'),
        'options' => array(
          'top' => esc_html__('Üst', 'kanews'),
          'bottom' => esc_html__('Alt', 'kanews'),
        ),
        'default' => 'top'
      ),

      // Sub Header: Left
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sub Header Sol Kısım Ayarları', 'kanews'),
      ),
      array(
        'id'      => 'subheader-left',
        'type'    => 'button_set',
        
        'multiple'    => true,
        'title'   => esc_html__('Modül', 'kanews'),
        'options' => array(
          'weather' => esc_html__('Hava Durumu', 'kanews'),
          'currencies' => esc_html__('Öne Çıkan Kurlar', 'kanews'),
          'breaking-news' => esc_html__('Son Dakika', 'kanews'),
          'menu' => esc_html__('Menü', 'kanews'),
          'date' => esc_html__('Tarih', 'kanews'),
          'html' => esc_html__('HTML', 'kanews'),
          // 'secim'       => esc_html__('Seçim Sayacı', 'kanews'),
          'disable' => esc_html__('Hiçbir şey', 'kanews'),
        ),
        'default' => 'currencies'
      ),

      array(
        'id'         => 'subheader-left-editor',
        'title'      => esc_html__('Editör', 'kanews'),
        'class'  => 'no-border',
        'type'  => 'code_editor',
        'sanitize' => false,
        'dependency' => array( 'subheader-left', 'any', 'html' ),
      ),
      array(
        'id'         => 'subheader-left-date-format',
        'type'       => 'text',
        'class'  => 'no-border',
        'default'       => 'j F Y, D',
        'desc'      =>  '<a href="https://wordpress.org/support/article/formatting-date-and-time/#format-string-examples">Tarih formatı örnekleri</a>',
        'title'      => esc_html__('Tarih Formatı', 'kanews'),
        'dependency' => array( 'subheader-left', 'any', 'date' ),
      ),


      // Sub Header Left: Weather Deault City
      array(
        'id'         => 'subheader-weather-city',
        'type'       => 'text',
        'class'  => 'no-border',
        'title'      => esc_html__('Şehir', 'kanews'),
        'default'      => 'İstanbul',
        'dependency' => array( 'subheader-left', 'any', 'weather' ),
      ),
      array(
        'type'    => 'submessage',
        'style'   => 'info',
        'class'  => 'no-border',
        'content' => esc_html__( 'Api anahtarı girdiğinizden emin olun.', 'kanews' ).' <a href="'.admin_url('admin.php?page=kanews-options#tab=veri-guncelleme').'">'.esc_html__( 'Tıkla ve Ekle', 'kanews' ).'</a>',
        'dependency' => array( 'subheader-left', 'any', 'weather' ),
      ),

      // Sub Header Left: Select Currencies
      array(
        'id'      => 'subheader-left-currencies',
        'type'    => 'button_set',
        'class'  => 'no-border',
        'title'   => esc_html__('Gözükecek Para Birimleri', 'kanews'),
        'dependency' => array( 'subheader-left', 'any', 'currencies' ),
        'multiple' => true,
        'options' => get_currencies_arrays(),
        'default' => array('usd', 'euro', 'gbp', 'btc', 'ise-100', 'gau')
      ),

      // Sub Header Left: Set Query for Breaking News Ticker
      array(
        'id'          => 'subheader-left-bn-cats',
        'type'        => 'select',
        'class'  => 'no-border',
        'title'       => esc_html__('Kategoriler', 'kanews'),
        'dependency'  => array( 'subheader-left', 'any', 'breaking-news' ),
        'chosen'      => true,
        'multiple'    => true,
        'sortable'    => true,
        'options'     => 'category',
        'placeholder' => esc_html__('Tüm Kategoriler', 'kanews')
      ),

      array(
        'id'      => 'subheader-left-bn-sortby',
        'type'    => 'select',
        'class'  => 'no-border',
        'title'   => esc_html__('Göre Sırala', 'kanews'),
        'dependency' => array( 'subheader-left', 'any', 'breaking-news' ),
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre', 'kanews'),
          'modified' => esc_html__('Düzenlenme Tarihine Göre', 'kanews'),
        ),
        'default' => 'modified'
      ),

      array(
        'id'       => 'subheader-left-bn-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Yazı Sayısı', 'kanews'),
        'dependency' => array( 'subheader-left', 'any', 'breaking-news' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 5,
      ),


      // Sub Header: Right
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sub Header Sağ Kısım Ayarları', 'kanews'),
      ),

      array(
        'id'      => 'subheader-right',
        'type'    => 'button_set',
        'multiple'    => true,
        'title'   => esc_html__('Modül', 'kanews'),
        'options' => array(
          'weather' => esc_html__('Hava Durumu', 'kanews'),
          'currencies' => esc_html__('Öne Çıkan Kurlar', 'kanews'),
          'menu' => esc_html__('Menü', 'kanews'),
          'date' => esc_html__('Tarih', 'kanews'),
          'html' => esc_html__('HTML', 'kanews'),
          // 'secim'       => esc_html__('Seçim Sayacı', 'kanews'),
          'disable' => esc_html__('Hiçbir şey', 'kanews'),
        ),
        'default' => 'menu'
      ),

      array(
        'id'         => 'subheader-right-editor',
        'title'      => esc_html__('Editör', 'kanews'),
        'type'  => 'code_editor',
        'class'  => 'no-border',
        'sanitize' => false,
        'dependency' => array( 'subheader-right', 'any', 'html' ),
      ),
      array(
        'id'         => 'subheader-right-date-format',
        'type'       => 'text',
        'default'       => 'j F Y, D',
        'class'  => 'no-border',
        'desc'      =>  '<a href="https://wordpress.org/support/article/formatting-date-and-time/#format-string-examples">Tarih formatı örnekleri</a>',
        'title'      => esc_html__('Tarih Formatı', 'kanews'),
        'dependency' => array( 'subheader-right', 'any', 'date' ),
      ),


       // Sub Header Right: Weather Deault City
      array(
        'id'         => 'subheader-weather-city2',
        'type'       => 'text',
        'class'  => 'no-border',
        'title'      => esc_html__('Hava Durumu Varsayılan Şehir', 'kanews'),
        'default'    => 'İstanbul',
        'dependency' => array( 'subheader-right', 'any', 'weather' ),
        'desc'       => esc_html__('Hava durumunda varsayılan olarak gösterilecek şehir.', 'kanews'),
      ),
      array(
        'type'    => 'submessage',
        'style'   => 'info',
        'class'  => 'no-border',
        'content' => esc_html__( 'Api anahtarı girdiğinizden emin olun.', 'kanews' ).' <a href="'.admin_url('admin.php?page=kanews-options#tab=veri-guncelleme').'">'.esc_html__( 'Tıkla ve Ekle', 'kanews' ).'</a>',
        'dependency' => array( 'subheader-right', 'any', 'weather' ),
      ),

      // Sub Header Right: Select Currencies
      array(
        'id'         => 'subheader-right-currencies',
        'type'       => 'button_set',
        'class'  => 'no-border',
        'title'      => esc_html__('Gözükecek Para Birimleri', 'kanews'),
        'dependency' => array( 'subheader-right', 'any', 'currencies' ),
        'multiple'   => true,
        'options' => get_currencies_arrays(),
        'default' => array('ise-100', 'gau', 'eur-usd')
      ),

      // Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header Sol Kısım Ayarları', 'kanews'),
      ),
      // Big Menu
      array(
        'id'      => 'big-menu',
        'title'   => esc_html__('Büyük Menü', 'kanews'),
        'help'    => esc_html__('Logo yanında bulunan menü butonuna tıklandığında büyük bir menü açar.', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'big-menu-style',
        'class'    => 'yeni',
        'type'    => 'select',
        'default' => 'style1',
        'class'   => 'no-border',
        'title'   => esc_html__('Büyük Menü Görünümü', 'kanews'),
        'options' => array(
          'style1' => esc_html__('Görünüm', 'kanews').' #1',
          'style2' => esc_html__('Görünüm', 'kanews').' #2',
        ),
      ),
      
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header Sağ Kısım Ayarları', 'kanews'),
      ),
      // User/Login Button
      array(
        'id'      => 'login-user-button',
        'title'   => esc_html__('Üyelik Butonu', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Search Button
      array(
        'id'      => 'search-button',
        'title'   => esc_html__('Arama Butonu', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // action Button
      array(
        'id'      => 'action-button',
        'title'   => esc_html__('Araçlar Butonu', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'action-buttons-style',
        'type'    => 'select',
        'default'    => 'style2',
        'class'  => 'no-border',
        'title'   => esc_html__('Araçlar Butonu Görünümü', 'kanews'),
        'options' => array(
          'style1' => esc_html__('Görünüm', 'kanews').' #1',
          'style2' => esc_html__('Görünüm', 'kanews').' #2',
          'style3' => esc_html__('Görünüm', 'kanews').' #3',
        ),
      ),
      array(
        'id'     => 'action-buttons',
        'type'   => 'group',
        'class'  => 'no-border',
        'title'  => esc_html__('Araçlar', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),
          array(
            'id'      => 'popular',
            'title'   => esc_html__('Popülerlere Ekle', 'kanews'),
            'type'    => 'switcher',
            'default' => false
          ),
          array(
            'id'      => 'use-title',
            'title'   => esc_html__('Başlık Olarak Kullan', 'kanews'),
            'type'    => 'switcher',
            'default' => false
          ),
          array(
            'id'    => 'desc',
            'dependency' => array( 'use-title', '!=', 'true' ),
            'type'  => 'text',
            'title' => __('Açıklama', 'kanews'),
          ),
          array(
            'id'         => 'icon_type',
            'default'    => 'icon',
            'type'       => 'button_set',
            'title'      => esc_html__('İkon Tipi', 'kanews'),
            'dependency' => array( 'use-title', '!=', 'true' ),
            'multiple'   => false,
            'options'    => array(
              'icon'     => esc_html__('İkon', 'kanews'),
              'image'    => esc_html__('Görsel', 'kanews'),
            ),
          ),
          array(
            'id'    => 'icon',
            'type'  => 'icon',
            'dependency' => array( 'icon_type|use-title', '==|==', 'icon|false' ),
            'title' => esc_html__('İkon', 'kanews'),
          ),
          array(
            'id'       => 'img',
            'dependency' => array( 'icon_type', '==', 'image' ),
            'type'     => 'upload',
            'title'    => 'Görsel',
          ),
          array(
            'id'         => 'link_type',
            'type'       => 'button_set',
            'default'    => 'page',
            'dependency' => array( 'use-title', '!=', 'true' ),
            'title'      => esc_html__('Link Tipi', 'kanews'),
            'multiple'   => false,
            'options'    => array(
              'page'     => esc_html__('Sayfa', 'kanews'),
              'custom'    => esc_html__('Özel Link', 'kanews'),
            ),
          ),
          array(
            'id'          => 'page',
            'type'        => 'select',
            'dependency' => array( 'link_type', '==', 'page' ),
            'title'       => esc_html__('Sayfa', 'kanews'),
            'chosen'      => true,
            'sortable'    => true,
            'ajax'        => true,
            'options'     => 'pages',
            'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'Link',
            'dependency' => array( 'link_type|use-title', '==|==', 'custom|false' ),
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
          array(
            'id'      => 'blank',
            'title'   => esc_html__('Yeni Sekmede Aç', 'kanews'),
            'type'    => 'switcher',
            'default' => false
          ),
          array(
            'id'      => 'color',
            'type'    => 'color',
            'dependency' => array( 'use-title', '!=', 'true' ),
            'title'   => esc_html__('Renk', 'kanews')
          ),
          
        ),
      ),


      // Header Middle
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header Orta Kısım Ayarları', 'kanews'),
        'dependency'  => array( 'header-layout', '!=', 'style-3||style-4' ),
        'help' => esc_html__('Header Orta Kısım Ayarları', 'kanews'),
      ),
      array(
        'id'         => 'header-center',
        'type'       => 'button_set',
        'dependency'  => array( 'header-layout', '!=', 'style-3||style-4' ),
        'desc'      => esc_html__('Gözükmesini istediğiniz modülü seçin.', 'kanews'),
        'options'    => array(
          'disable'      => esc_html__('Boş Kalsın', 'kanews'),
          'custom'      => esc_html__('Özel Alan', 'kanews'),
          'search'      => esc_html__('Arama Kutusu', 'kanews'),
          // 'secim'       => esc_html__('Seçim Sayacı', 'kanews'),
          'currencies'  => esc_html__('Döviz Kurları', 'kanews')
        ),
        'default' => 'search'
      ),
      // Header Middle: Select Currencies
      array(
        'id'         => 'header-center-currencies',
        'type'       => 'button_set',
        'class'  => 'no-border',
        'title'      => esc_html__('Gözükecek Para Birimleri', 'kanews'),
        'dependency' => array( 'header-center', '==', 'currencies' ),
        'multiple'   => true,
        'options' => get_currencies_arrays(),
        'default' => array('usd', 'euro', 'gbp', 'btc', 'ise-100', 'gau')
      ), 
      // Header Middle: Custom
      array(
        'id'         => 'header-center-custom',
        'type'       => 'wp_editor',
        'class'  => 'no-border',
        'dependency' => array( 'header-center', '==', 'custom' ),
      ),
    

      // Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Navbar Ayarları', 'kanews'),
      ),
      array(
        'id'      => 'navbar-skin',
        'type'    => 'select',
        'dependency' => array( 'header-layout', '==', 'style-1' ),
        'title'   => esc_html__('Renk Modu', 'kanews'),
        'options' => array(
					'light' => esc_html__('Açık', 'kanews'),
          'dark' => esc_html__('Koyu', 'kanews'),
        ),
        'default' => 'light'
      ),
      array(
        'id'      => 'sticky-navbar',
        'title'   => esc_html__('Yapışkan Navbar', 'kanews'),
        
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'home-button',
        'title'   => esc_html__('Ana sayfa Butonu', 'kanews'),
        'dependency' => array( 'header-layout', '!=', 'style-3' ),
        'type'    => 'switcher',
        'default' => true
      ),

      array(
        'id'    => 'colorfull-line',
        'title'  => esc_html__('Renkli Şerit', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),

      // Breaking News
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Son Dakika Barı', 'kanews'),
      ),

      array(
        'id'      => 'subnavbar-left-bn',
        'title'   => esc_html__('Son Dakika Barı', 'kanews'),
        'type'    => 'switcher',
        'class'  => 'no-border',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'subnavbar-left-bn-custom',
        'title'   => esc_html__('Özel Listeleme', 'kanews'),
        'type'    => 'switcher',
        'class'    => 'yeni no-border',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'     => 'subnavbar-left-bn-customx',
        'type'   => 'group',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'true' ),
        'title'  => esc_html__('Liste', 'kanews'),
        'class'  => 'no-border',
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
        ),
        'default' => array(
          array(
            'title' => 'Euro 2024',
            'url' => '#',
          ),
          array(
            'title' => 'Kabine Toplantısı',
            'url' => '#',
          ),
          array(
            'title' => 'Enflasyon',
            'url' => '#',
          ),
          array(
            'title' => 'Asgari Ücret',
            'url' => '#',
          ),
          array(
            'title' => 'Son Depremler',
            'url' => '#',
          ),
          array(
            'title' => 'Cumhurbaşkanı Erdoğan',
            'url' => '#',
          ),
          array(
            'title' => 'Altın',
            'url' => '#',
          ),
          array(
            'title' => 'Dolar',
            'url' => '#',
          ),
          array(
            'title' => 'Borsa',
            'url' => '#',
          ),
        ),
      ),

      // Sub Header Left: Set Query for Breaking News Ticker
      array(
        'id'          => 'subnavbar-left-bn-cats',
        'type'        => 'select',
        'title'       => esc_html__('Kategoriler', 'kanews'),
        'chosen'      => true,
        'multiple'    => true,
        'class'  => 'no-border',
        'sortable'    => true,
        'options'     => 'category',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'false' ),
        'placeholder' => esc_html__('Tüm Kategoriler', 'kanews')
      ),

      array(
        'id'      => 'subnavbar-left-bn-sortby',
        'type'    => 'select',
        'class'  => 'no-border',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'false' ),
        'title'   => esc_html__('Göre Sırala', 'kanews'),
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre', 'kanews'),
          'modified' => esc_html__('Düzenlenme Tarihine Göre', 'kanews'),
        ),
        'default' => 'modified'
      ),

      array(
        'id'       => 'subnavbar-left-bn-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'false' ),
        'title'    => esc_html__('Yazı Sayısı', 'kanews'),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 5,
      ),

      array(
        'id'          => 'subnavbar-left-bn-post-not-in',
        'type'        => 'select',
        'class'  => 'no-border',
        'dependency' => array( 'subnavbar-left-bn-custom', '==', 'false' ),
        'title'       => esc_html__('Hariç Tutulan Yazılar', 'kanews'),
        'chosen'      => true,
        'multiple'    => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'posts',
        'placeholder' => esc_html__( 'Yazı Seçin', 'kanews' ),
      ),

      // Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Modüler Alan', 'kanews'),
      ),

      array(
        'id'      => 'header-top-modules',
        'title'   => esc_html__('Modüler Alan', 'kanews'),
        'class'  => 'no-border',
        'desc'    => esc_html__('Sitenin en üstünde gösterilir.', 'kanews'),
        'type'    => 'switcher',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'header-top-modules-mobile',
        'title'   => esc_html__('Mobilde Göster', 'kanews'),
        'class'  => 'no-border',
        'type'    => 'switcher',
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'       => 'header-top-module',
        'type'     => 'button_set',
        'class'  => 'no-border',
        'title'    => esc_html__('Gözükecek Modül', 'kanews'),
        'multiple' => false,
        'options'  => array(
          'currencies'  => esc_html__('Öne Çıkan Kurlar', 'kanews'),
          'scores'      => esc_html__('Canlı Skor', 'kanews'),
        ),
      ),

      array(
        'id'      => 'header-top-module-currencies',
        'type'    => 'button_set',
        'class'  => 'no-border',
        'title'   => esc_html__('Gözükecek Para Birimleri', 'kanews'),
        'dependency' => array( 'header-top-module', '==', 'currencies' ),
        'multiple' => true,
        'options' => get_currencies_arrays(),
      ),

      array(
        'id'          => 'header-top-module-page',
        'type'        => 'select',
        'class'  => 'no-border',
        'title'       => esc_html__('Detay Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),


    )
  ));

  /**
	 * Footer
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Footer Ayarları', 'kanews'),
    'icon'  => 'fas fa-campground',
    'fields' => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Footer Ayarları', 'kanews'),
      ),
       // Layout
      array(
        'id'      => 'footer-layout',
        'type'    => 'select',
        'title'   => esc_html__('Görünüm', 'kanews'),
        'options' => array(
          'style-1' => esc_html__('Görünüm', 'kanews').' #1',
          'style-2' => esc_html__('Görünüm', 'kanews').' #2',
        ),
        'default' => 'style-1',
      ),
      array(
        'id'      => 'footer-skin',
        'type'    => 'select',
        
        'title'   => esc_html__('Renk Modu', 'kanews'),
        'options' => array(
          'dark' => esc_html__('Koyu', 'kanews'),
          'light' => esc_html__('Açık', 'kanews'),
        ),
        'default' => 'light'
      ),

      // Widgets
      array(
        'id'    => 'footer-widgets',
        'title'  => esc_html__('Bileşenler', 'kanews'),
        'type'  => 'switcher',
        'dependency' => array( 'footer-layout', '!=', 'style-2' ),
        'default' => false
      ),

      // Sosyal
      array(
        'id'     => 'social-links',
        'type'   => 'group',
        'title'  => esc_html__('Sosyal Medya Hesaplarınız', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),
          array(
            'id'    => 'icon',
            'type'  => 'icon',
            'title' => esc_html__('İkon', 'kanews'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
        ),
        'default' => array(
          array(
            'title' => esc_html__('Facebook', 'kanews'),
            'icon' => 'icon-facebook',
            'url' => '#',
          ),
          array(
            'title' => esc_html__('Twitter', 'kanews'),
            'icon' => 'icon-twitter',
            'url' => '#',
          ),
        ),
      ),

      // Copyright
      array(
        'id'    => 'footer-bottom-text',
        'type'  => 'textarea',
        'title'  => esc_html__('Telif Hakkı Yazısı', 'kanews'),
        'desc'  => __('Sitenin altında bulunan alanın ortasında gözükecek olan yazıyı girin, öneri olaak telif hakkı yazısı olabilir. Aşağıdaki kısa kodları destekler.<br>
        <code>%year%</code> : Geçerli yıl<br>
        <code>%site%</code> : Sitenin adı<br>
        <code>%url%</code> : Site Linki
        ', 'kanews'),
        'default' => __( '&copy; Telif Hakkı %year%, Tüm Hakları Saklıdır.', 'kanews' ),
      ),

    )
  ));
  

  /**
	 * Mobil 
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Mobil Ayarları', 'kanews'),
    'icon'  => 'fas fa-mobile-alt',
    'fields' => array(
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Mobil Header', 'kanews'),
      ),

      array(
        'id'      => 'search-button-mobile',
        'title'   => esc_html__('Arama Butonu', 'kanews'),
        'desc'   => esc_html__('Header Ayarları>Arama butonu ayarı aktif olmalı.', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'action-button-mobile',
        'title'   => esc_html__('Araçlar Butonu', 'kanews'),
        'desc'   => esc_html__('Header Ayarları>Araçlar ayarı aktif olmalı.', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'login-user-button-mobile',
        'title'   => esc_html__('Üyelik Butonu', 'kanews'),
        'desc'   => esc_html__('Header Ayarları>Üyelik Butonu ayarı aktif olmalı.', 'kanews'),
        'type'    => 'switcher',

        'default' => true
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Mobil Tab Menü', 'kanews'),
      ),

      array(
        'id'      => 'tab-bar-desktop',
        'title'   => esc_html__('Masaüstü Tab Menü', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'tab-bar',

        'title'   => esc_html__('Mobil Tab Menü', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'tab-bar-icon',

        'title'   => esc_html__('Sadece ikon', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'      => 'tab-bar-bg',
        'type'    => 'color',
        'title'   => esc_html__('Arkaplan', 'kanews')
      ),

      array(
        'id'      => 'tab-bar-color',
        'type'    => 'color',
        'title'   => esc_html__('İkon Rengi', 'kanews')
      ),
    

      array(
        'id'         => 'tab-bar-defaults',
        'type'       => 'button_set',
        'title'      => esc_html__('Varsayılanlar', 'kanews'),
        'multiple'   => true,
        'options'    => array(
          'home'     => esc_html__('Anasayfa', 'kanews'),
          'feed'    => esc_html__('Akış', 'kanews'),
          'account'    => esc_html__('Hesabım', 'kanews'),
          'notifications'    => esc_html__('Bildirimler', 'kanews'),
        ),
        'default' => array('home','feed','account','notifications')
      ),

      array(
        'id'     => 'tab-bar-items',
        'type'   => 'group',
        'title'  => esc_html__('Elemanlar', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),

          array(
            'id'         => 'icon_type',
            'default'    => 'icon',
            'type'       => 'button_set',
            'title'      => esc_html__('İkon Tipi', 'kanews'),
            'multiple'   => false,
            'options'    => array(
              'icon'     => esc_html__('İkon', 'kanews'),
              'image'    => esc_html__('Görsel', 'kanews'),
            ),
          ),
          array(
            'id'    => 'icon',
            'type'  => 'icon',
            'dependency' => array( 'icon_type', '==', 'icon' ),
            'title' => esc_html__('İkon', 'kanews'),
          ),
          array(
            'id'       => 'img',
            'dependency' => array( 'icon_type', '==', 'image' ),
            'type'     => 'upload',
            'title'    => 'Görsel',
          ),
          array(
            'id'         => 'link_type',
            'type'       => 'button_set',
            'default'    => 'page',
            'title'      => esc_html__('Link Tipi', 'kanews'),
            'multiple'   => false,
            'options'    => array(
              'page'     => esc_html__('Sayfa', 'kanews'),
              'custom'    => esc_html__('Özel Link', 'kanews'),
            ),
          ),
          array(
            'id'          => 'page',
            'type'        => 'select',
            'dependency' => array( 'link_type', '==', 'page' ),
            'title'       => esc_html__('Sayfa', 'kanews'),
            'chosen'      => true,
            'sortable'    => true,
            'ajax'        => true,
            'options'     => 'pages',
            'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'dependency' => array( 'link_type', '==', 'custom' ),
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
          
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Mobil Açılır Menü Ayarları', 'kanews'),
      ),
      // Layout
      array(
        'id'      => 'mobile-menu-style',
        'type'    => 'radio',
        
        'title'   => esc_html__('Menü Düzeni', 'kanews'),
        'options' => array(
          '1' => 'Varsayılan',
          '2' => 'Tam Ekran',
        ),
        'default' => '1',
      ),
      array(
        'id'      => 'mobile-menu-search',
        'title'   => esc_html__('Arama Kutusu', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      array(
        'id'    => 'mobile-menu-footer-text',
        'type'  => 'textarea',
        'title'  => esc_html__('Telif Hakkı Yazısı', 'kanews'),
        'desc'  => __('Sitenin altında bulunan alanın ortasında gözükecek olan yazıyı girin, öneri olaak telif hakkı yazısı olabilir. Aşağıdaki kısa kodları destekler.<br>
        <code>%year%</code> : Geçerli yıl<br>
        <code>%site%</code> : Sitenin adı<br>
        <code>%url%</code> : Site Linki
        ', 'kanews'),
        'default' => __( '&copy; Telif Hakkı %year%, Tüm Hakları Saklıdır.', 'kanews' ),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sidebar Ayarları', 'kanews'),
      ),
      array(
        'id'      => 'single-sidebar',
        'title'   => esc_html__('Yazı Sayfasında Sidebarı Göster', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'page-sidebar',
        'title'   => esc_html__('Sayfalarda Sidebarı Göster', 'kanews'),
        'type'    => 'switcher',
        
        'default' => false
      ),
      array(
        'id'      => 'home-sidebar',
        'title'   => esc_html__('Ana Sayfada Sidebarı Göster', 'kanews'),
        'type'    => 'switcher',
        
        'default' => false
      ),
      array(
        'id'      => 'cat-sidebar',
        'title'   => esc_html__('Kategori Sayfalarında Sidebarı Göster', 'kanews'),
        'type'    => 'switcher',
        
        'default' => false
      ),
      array(
        'id'      => 'archive-sidebar',
        'title'   => esc_html__('Arşiv Sayfalarında Sidebarı Göster', 'kanews'),
        'type'    => 'switcher',
        
        'default' => false
      ),
    )
  ));


  /**
	 * Single page
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Yazı Sayfası', 'kanews'),
    'icon'  => 'far fa-newspaper',
    'fields' => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Yazı Sayfası', 'kanews'),
      ),
       // Layout
      array(
        'id'      => 'single-layout',
        'type'    => 'image_select',
        
        'title'   => esc_html__('Görünüm', 'kanews'),
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/single-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/single-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/single-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/single-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/single-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/single-6.jpg',
        ),
        'default' => '1',
      ),
      // Post Header
      array(
        'id'         => 'single-layout-block',
        'type'       => 'radio',
        'title'      => esc_html__('Görünüm Detay', 'kanews'),
        'options'    => array(
          'flat'     => esc_html__('Düz', 'kanews'),
          'box'      => esc_html__('Kutu', 'kanews'),
        ),
        'default' => 'box'
      ),
      // Infinite Post Scroll
      array(
        'id'      => 'infinite-post-scroll',
        'title'   => esc_html__('Sonsuz Yazı Kaydırma', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Pagination
      array(
        'id'         => 'single-pagination',
        'type'       => 'radio',
        'title'      => esc_html__('Yazı içi Sayfalama', 'kanews'),
        'options'    => array(
          'number'   => esc_html__('Numaralı Sayfalama', 'kanews'),
          'infinite' => esc_html__('Aşağı İndikçe Yükle', 'kanews'),
          'button'   => esc_html__('Daha Fazla Yükle', 'kanews'),
        ),
        'default' => 'number'
      ),


      array(
        'type'    => 'subheading',
        'content' => esc_html__('Haber Servisleri', 'kanews'),
      ),
      // Google News
      array(
        'id'       => 'google-news-link',
        'type'     => 'text',
        'title'    => esc_html__( 'Google News', 'kanews' ),
        'placeholder'  => 'https://www.'
      ),
      array(
        'id'     => 'news-services',
        'type'   => 'group',
        'class'  => 'no-border',
        'title'  => esc_html__('Servis Oluştur', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'default'  => 'https://www.',
            'validate' => 'csf_validate_url',
          ),
          array(
            'id'       => 'img',
            'type'     => 'upload',
            'title'    => 'Logo',
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar', 'kanews'),
      ),
      // Breadcrumb
      array(
        'id'      => 'show-post-reading',
        'title'   => esc_html__('Yazı Okuma Barı', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Breadcrumb
      array(
        'id'      => 'show-post-comments',
        'title'   => esc_html__('Tüm Yazıları Yoruma Kapat', 'kanews'),
        'type'    => 'switcher',
        
        'default' => false
      ),
      // Breadcrumb
      array(
        'id'      => 'show-post-breadcrumb',
        'title'   => esc_html__('Breadcrumb', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Share Switch
      array(
        'id'      => 'show-post-share',
        'title'   => esc_html__('Yazıyı Paylaş', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Share
      array(
        'id'      => 'post-share',
        'type'    => 'button_set',
        'class'  => 'no-border',
        'title'   => esc_html__('Paylaş Butonları', 'kanews'),
        'dependency' => array( 'show-post-share', '==', 'true' ),
        'multiple' => true,
        'options' => array(
          'facebook' => 'Facebook',
          'twitter' => 'Twitter',
          'whatsapp' => 'Whatsapp',
          'telegram' => 'Telegram',
          'pinterest' => 'Pinterest',
          'email' => 'E-Posta',
        ),
        'default' => array('facebook', 'twitter', 'whatsapp', 'email')
      ),
      array(
        'id'         => 'post-share-style',
        'type'       => 'radio',
        'class'  => 'no-border',
        'title'      => esc_html__('Paylaş Butonları Görünümü', 'kanews'),
        'options'    => array(
          // '1'     => esc_html__('Görünüm', 'kanews').' #1',
          '2'     => esc_html__('Görünüm', 'kanews').' #2',
          '3'     => esc_html__('Görünüm', 'kanews').' #3',
          '4'     => esc_html__('Görünüm', 'kanews').' #4',
          '5'     => esc_html__('Görünüm', 'kanews').' #5',
        ),
        'default' => '5'
      ),
      array(
        'id'      => 'post-text-share',
        'title'   => esc_html__('Seçili Yazıyı Paylaş', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Thumbnail
      array(
        'id'      => 'show-post-thumbnail',
        'title'   => esc_html__('Öne Çıkarılan Görsel', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Excerpt
      array(
        'id'      => 'show-post-excerpt',
        'title'   => esc_html__('Yazı Açıklaması', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Cat
      array(
        'id'      => 'show-post-cat',
        'title'   => esc_html__('Kategori', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Author
      array(
        'id'      => 'show-post-author',
        'title'   => esc_html__('Yazar', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Post Date
      array(
        'id'      => 'show-post-date',
        'title'   => esc_html__('Yayınlanma Tarihi', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Post Update Date
      array(
        'id'      => 'show-post-update-date',
        'title'   => esc_html__('Güncelleme Tarihi', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Post Views
      array(
        'id'      => 'show-post-views',
        'title'   => esc_html__('Okunma Sayısı', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Reading Time
      array(
        'id'      => 'show-post-reading-time',
        'title'   => esc_html__('Okuma Süresi', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Assets
      array(
        'id'      => 'show-post-assets',
        'title'   => esc_html__('Yazı Araçları', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Post Tags
      array(
        'id'      => 'show-post-tags',
        'title'   => esc_html__('Etiketler', 'kanews'),
        'type'    => 'switcher',
        'default' => true
      ),
      // Popular Comments
      array(
        'id'      => 'show-popular-comments',
        'title'   => esc_html__('Popüler Yorumlar', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      // Excerpt Lenght
      array(
        'id'       => 'popular-comments-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'dependency' => array( 'show-popular-comments', '==', 'true' ),
        'title'    => esc_html__('Popüler Yorum Sayısı', 'kanews'),
        'min'      => 1,
        'max'      => 30,
        'step'     => 1,
        'default'  => 10,
      ),

      // Reaction
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Reaksiyon', 'kanews'),
      ),
      array(
        'id'      => 'reaction-system',
        'title'   => esc_html__('Reaksiyon Sistemi', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'reaction-system-style',
        'type'    => 'select',
        'class'  => 'no-border',
        'default'    => '1',
        'title'   => esc_html__('Tasarım', 'kanews'),
        'options' => array(
          '1' => '#1',
          '2' => '#2',
        )
      ),
      array(
        'id'     => 'reaction-buttons',
        'type'   => 'group',
        'class'  => 'no-border',
        'dependency' => array( 'reaction-system', '==', 'true' ),
        'title'  => esc_html__('Emoji Oluştur', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),
          array(
            'id'    => 'emoji',
            'type'  => 'upload',
            'title' => esc_html__('Emoji', 'kanews'),
            'desc' => '<a href="https://www.flaticon.com/packs/emoji-17?word=emoji" target="_blank">Emoji paketi</a>',
          ),
        ),
        'default' => array(
          array(
            'title' => esc_html__( 'Mutlu', 'kanews' ),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/happy.svg',
          ),
          array(
            'title' => esc_html__( 'Üzgün', 'kanews' ),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/sad.svg',
          ),
          array(
            'title' => esc_html__( 'Sinirli', 'kanews' ),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/angry.svg',
          ),
          array(
            'title' => esc_html__( 'Şaşırmış', 'kanews' ),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/shocked.svg',
          ),
          array(
            'title' => esc_html__( 'Virüslü', 'kanews' ),
            'emoji' => KAN_TEMPLATE_URL .'/assets/img/static/emoji/sick.svg',
          ),
        ),
      ),

      // Related Posts
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Göz Atın Yazıları', 'kanews'),
      ),
      array(
        'id'      => 'related-posts2-style',
        'type'    => 'radio',
        
        'title'   => esc_html__('Görünüm', 'kanews'),
        'options' => array(
          '1' => esc_html__('Görünüm', 'kanews').' #1',
          '2' => esc_html__('Görünüm', 'kanews').' #2',
          '3' => esc_html__('Görünüm', 'kanews').' #3',
          'disable' => 'Gösterme'
        ),
        
        'default' => 'disable',
      ),
      array(
        'id'       => 'related-posts2-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Yazı Sayısı', 'kanews'),
        'dependency' => array( 'related-posts2-style', '!=', 'disable' ),
        'min'      => 1,
        'max'      => 20,
        'step'     => 1,
        'default'  => 4,
        
      ),
      array(
        'id'       => 'related-posts2-plimit',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Paragraf Seçimi', 'kanews'),
        'dependency' => array( 'related-posts2-style', '!=', 'disable' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 4,
        
      ),
      array(
        'id'      => 'related-posts2-sortby',
        'type'    => 'radio',
        'class'  => 'no-border',
        'title'   => esc_html__('Göre Sırala', 'kanews'),
        'dependency' => array( 'related-posts2-style', '!=', 'disable' ),
        'options' => array(
          'cat' => esc_html__('Kategoriye Göre', 'kanews'),
          'tag' => esc_html__('Etikete Göre', 'kanews'),
        ),
        'default' => 'tag',
        
      ),

      // Related Posts
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Benzer Yazılar', 'kanews'),
      ),
      
      array(
        'id'      => 'related-posts-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Görünüm', 'kanews'),
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),
      array(
        'id'      => 'related-posts-sortby',
        'type'    => 'radio',
        'class'  => 'no-border',
        'title'   => esc_html__('Göre Sırala', 'kanews'),
        'dependency' => array( 'related-posts-style', '!=', 'disable' ),
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre', 'kanews'),
          'post-modified' => esc_html__('Düzenlenme Tarihine Göre', 'kanews'),
          'post-viewed' => esc_html__('En Çok Okunan Yazı', 'kanews'),
          'commented' => esc_html__('En Çok Yorum Yapılan', 'kanews'),
          'random' => esc_html__('Rastgele', 'kanews'),
          'tag' => esc_html__('Etikete Göre', 'kanews'),
        ),
        'default' => 'random'
      ),
      array(
        'id'       => 'related-posts-count',
        'type'     => 'slider',
        'class'  => 'no-border',
        'dependency' => array( 'related-posts-style', '!=', 'disable' ),
        'title'    => esc_html__('Yazı Sayısı', 'kanews'),
        'min'      => 1,
        'max'      => 20,
        'step'     => 1,
        'default'  => 6,
      ),

      // Newsletter
      array(
        'type'    => 'subheading',
        
        'content' => esc_html__('Haber Bülteni', 'kanews'),
      ),
      array(
        'id'    => 'newsletter',
        'type'  => 'switcher',
        'default' => false,
        'title' => __('Haber Bülteni Formu', 'kanews'),
      ),
      array(
        'id'    => 'newsletter-content',
        'type'  => 'wp_editor',
        'class'  => 'no-border',
        'title' => __('Açıklama', 'kanews'),
        'dependency' => array( 'newsletter', '==', 'true' ),
      ),
      array(
        'id'    => 'newsletter-mailchimp',
        'type'  => 'text',
        'class'  => 'no-border',
        'title' => __('Mailchimp Form Action URL', 'kanews'),
        'desc' => '<a href="https://docs.kanthemes.com/kanews/#/sss?id=mailchimp-b%c3%bclten-formu-i%c3%a7in-action-eylem-linki-nas%c4%b1l-al%c4%b1n%c4%b1r">Nasıl Öğrenirim?</a>',
        'dependency' => array( 'newsletter', '==', 'true' ),
      ),

      
    )
  ));

  /**
	 * Archives 
   */	
   CSF::createSection( $prefix, array(
    'title'  => esc_html__('Arşiv Sayfaları', 'kanews'),
    'icon'  => 'fas fa-archive',
    'fields' => array(

      array(
        'type'    => 'heading',
        'content' => esc_html__('Arşiv Sayfaları', 'kanews'),
      ),
      
      // Pagination
      array(
        'id'         => 'archives-pagination',
        'type'       => 'radio',
        'title'      => esc_html__('Sayfalama Şekli', 'kanews'),
        'options'    => array(
          'classic'     => esc_html__('Klasik Sayfalama', 'kanews'),
          'number'     => esc_html__('Numaralı Sayfalama', 'kanews'),
          'button'     => esc_html__('Daha Fazla Yükle', 'kanews'),
          'infinite'     => esc_html__('Aşağı İndikçe Yükle', 'kanews'),
        ),
        'default' => 'classic'
      ),

      // Excerpt Lenght
      array(
        'id'       => 'excerpt-length',
        'type'     => 'slider',
        'title'    => esc_html__('Arşiv Yazı Açıklama Uzunluğu', 'kanews'),
        'min'      => 0,
        'max'      => 35,
        'step'     => 1,
        'default'  => 7,
      ),

      array(
        'id'    => 'open-link-new-tab',
        'title'  => esc_html__('Linkleri Yeni Sekmede Aç', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ), 

      // Jpeg Quality
      array(
        'id'       => 'jpeg-quality',
        'type'     => 'slider',
        'title'    => esc_html__('Görsel Kalitesi', 'kanews'),
        'desc'    => esc_html__('Yeni yüklenenlerde geçerli olacaktır veya görsellerinizi yeniden boyutlandırmanız gerekir.', 'kanews'),
        'min'      => 1,
        'max'      => 100,
        'step'     => 1,
        'default'  => 100,
      ),

      array(
        'id'    => 'cat-links',
        'title'  => esc_html__('Arşivlerden Kategori Butonlarını Gizle', 'kanews'),
        'type'  => 'switcher',
        
        'default' => false
      ),

      array(
        'id'          => 'excluded-categories',
        'type'        => 'checkbox',
        'title'       => esc_html__('Liste Dışı Kategoriler', 'kanews'),
        'desc'        => esc_html__('Seçili kategoriler bileşen gibi alanlarda liste dışı bırakılır.', 'kanews'),
        'multiple'    => true,
        'options'     => 'categories',
        'placeholder' => 'Kategori Seç',
      ),

      array(
        'id'      => 'home-recent-post-title',
        'type'    => 'text',
        'title'   => esc_html__('Son Yazılar Başlığı', 'kanews'),
      ),

      // Home Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Anasayfa', 'kanews'),
      ),
      
      array(
        'id'      => 'home-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm', 'kanews'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '1',
      ),

    

      // Category Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kategori Sayfaları', 'kanews'),
      ),
      
      // Cat Archives: Category Recent Post Style
      array(
        'id'      => 'cat-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm', 'kanews'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          // 'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),

      array(
        'id'          => 'category-sidebar2',
        'type'        => 'checkbox',
        'title'       => esc_html__('Özel Kategori Şablonu', 'kanews'),
        'multiple'    => true,
        'options'     => 'kanews_get_categories',
        'placeholder' => 'Kategori Seç',
      ),

      array(
        'id'    => 'category-right-sidebar',
        'title'  => esc_html__('Sağ Sidebar', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'navbar-sub-category',
        'title'  => esc_html__('Alt Kategori Barı', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),

      // Tag Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Etiket Sayfaları', 'kanews'),
      ),
      
      // Tag Archives: Recent Post Style
      array(
        'id'      => 'tag-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm', 'kanews'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          // 'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '4',
      ),

      // Author Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Yazar Sayfaları', 'kanews'),
      ),
      
      // Author Archives: Recent Post Style
      array(
        'id'      => 'author-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm', 'kanews'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          // 'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),


      // Other
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Sayfalar', 'kanews'),
      ),
      
      // Other Archives: Pages Recent Post Style
      array(
        'id'      => 'other-recent-post-style',
        'type'    => 'image_select',
        'title'   => esc_html__('Son Yazılar Görünüm', 'kanews'),
        
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-1.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          '4' => KAN_TEMPLATE_URL .'/assets/img/options/archive-4.jpg',
          '5' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '6' => KAN_TEMPLATE_URL .'/assets/img/options/archive-6.jpg',
          // 'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '1',
      ),

    )
  ));

  /**
	 * Advertisment
   */	
  CSF::createSection( $prefix, array(
    'title'  => esc_html__('Reklam Yönetimi', 'kanews'),
    'icon'  => 'fas fa-hand-holding-usd',
    'fields' => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Reklam Yönetimi', 'kanews'),
      ),

      array(
        'id'    => 'ad-auto-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        'title'  => esc_html__('Otomatik Reklam', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-auto',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-auto-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-cover-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        'title'  => esc_html__('Kaplama Reklam', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-cover',
        'type'  => 'media',
        'class'  => 'no-border',
        'class'  => 'no-border',
        'title'  => esc_html__('Görsel', 'kanews'),
        'dependency' => array( 'ad-cover-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-cover-color',
        'type'  => 'color',
        'class'  => 'no-border',
        'class'  => 'no-border',
        'title'  => esc_html__('Arkaplan Rengi', 'kanews'),
        'dependency' => array( 'ad-cover-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-cover-link',
        'type'  => 'text',
        'class'  => 'no-border',
        'class'  => 'no-border',
        'title'  => esc_html__('Link', 'kanews'),
        'dependency' => array( 'ad-cover-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-header-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Header Reklamları', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-header',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-header-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-header-below-switch',
        'type'  => 'switcher',
        
        'title'  => esc_html__('Header Üst Reklamları', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-header-below',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-header-below-switch', '==', 'true' ),
      ),

      // Footer
      array(
        'type'    => 'subheading',
        'content' => __('Footer Reklamları', 'kanews'),
      ),
      array(
        'id'    => 'ad-footer-switch',
        'type'  => 'switcher',
        'sanitize' => false,
        'title'  => esc_html__('Footer Üstü', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-footer',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-footer-switch', '==', 'true' ),
      ),

      // Left Side
      array(
        'type'    => 'subheading',
        'content' => __('Sabit Reklamlar', 'kanews'),
      ),
      array(
        'id'    => 'ad-screen-bottom-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Sabit Alt Reklam', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-screen-bottom',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-screen-bottom-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-left-side-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Sabit Sol Reklam', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-left-side',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'desc'  => esc_html__('Minumum 1500px genişliğie sahip ekranlarda gözükür.', 'kanews'),
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-left-side-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-right-side-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Sabit Sağ Reklam', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-right-side',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'desc'  => esc_html__('Minumum 1500px genişliğie sahip ekranlarda gözükür.', 'kanews'),
        'dependency' => array( 'ad-right-side-switch', '==', 'true' ),
      ),

      // Yazı
      array(
        'type'    => 'subheading',
        'content' => __('Yazı Reklamları', 'kanews'),
      ),
      
      array(
        'id'    => 'ad-single-above-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Başlangıç', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-above',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-above-switch', '==', 'true' ),
      ),
      array(
        'id'    => 'ad-single-below-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Sonu', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-below',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-below-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-single-amid-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Ortası', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-amid',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-amid-switch', '==', 'true' ),
      ),

      array(
        'id'       => 'ad-single-amid-limit',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Paragraf Seçimi', 'kanews'),
        'dependency' => array( 'ad-single-amid-switch', '==', 'true' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 4,
      ),

      array(
        'id'    => 'ad-single-amid-switch2',
        'type'  => 'switcher',
        
        'title'  => esc_html__('Yazı Ortası', 'kanews').' #2',
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-amid2',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-amid-switch2', '==', 'true' ),
      ),

      array(
        'id'       => 'ad-single-amid-limit2',
        'type'     => 'slider',
        'class'  => 'no-border',
        'title'    => esc_html__('Paragraf Seçimi', 'kanews'),
        'dependency' => array( 'ad-single-amid-switch2', '==', 'true' ),
        'min'      => 1,
        'max'      => 15,
        'step'     => 1,
        'default'  => 4,
      ),

      array(
        'id'    => 'ad-single-meta-above-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Meta Üstü', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-meta-above',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-meta-above-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-single-meta-below-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yazı Meta Altı', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-meta-below',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-meta-below-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-single-comment-above-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Yorum Bloğu Üstü', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-comment-above',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-comment-above-switch', '==', 'true' ),
      ),

      array(
        'id'    => 'ad-single-shortcode-switch',
        'type'  => 'switcher',
        'title'  => esc_html__('Kısakod İle Reklam', 'kanews'),
        'default' => false,
      ),
      array(
        'id'    => 'ad-single-shortcode',
        'type'  => 'code_editor',
        'sanitize' => false,
        'class'  => 'no-border',
        'subtitle'  => esc_html__('Kısakodu eklediğiniz alanlarda gözükür. Kullanılması gereken kısakod: [kanews-ad]', 'kanews'),
        'title'  => esc_html__('Reklam Kodu', 'kanews'),
        'dependency' => array( 'ad-single-shortcode-switch', '==', 'true' ),
      ),

       // Yazı
      array(
        'type'    => 'subheading',
        'content' => __('Arşiv Reklamları', 'kanews'),
      ),

      array(
        'id'     => 'ad-archieve-per-post',
        'type'   => 'group',
        'title'  => esc_html__('Reklam Oluştur', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          
          

          
          array(
            'id'       => 'count',
            'type'     => 'slider',
            'title'    => esc_html__('Kaçıncı Yazıdan Sonra Gözükecek', 'kanews'),
            'min'      => 1,
            'max'      => 100,
            'step'     => 1,
            'default'  => 2,
          ),  
          array(
            'id'    => 'code',
            'type'  => 'code_editor',
            'sanitize' => false,
            'title'  => esc_html__('Reklam Kodu', 'kanews'),
          ),
        ),
      ),
    )
  ));

  /**
	 * Kanews Pages 
   */	
   CSF::createSection( $prefix, array(
    'title'  => esc_html__('Kanews Sayfaları', 'kanews'),
    'icon'  => 'fas fa-dice',
    'fields' => array(

      array(
        'type'    => 'heading',
        'content' => esc_html__('Sayfa Oluşturucu', 'kanews'),
      ),
      array(
        'id'          => 'page-builder',
        'type'        => 'checkbox',
        'title'       => esc_html__('Sayfa Oluşturucu', 'kanews'),
        'desc'        => 'Anasayfa benzeri sayfalar oluşturmak içindir. Seçili sayfalar için görünüm>bileşenler sayfasında bileşen alanları oluşturur.',
        'multiple'    => true,
        'options'     => 'kanews_get_pages',
        'placeholder' => 'Kategori Seç',
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kanews Sayfaları', 'kanews'),
        'desc'       => esc_html__('Detay sayfalarında 404 hatası alıyorsanız sayfa seçktikten sonra ayarları iki kez kaydedin veya kalıcı bağlantılarınızı güncelleyin.', 'kanews'),
      ),
      
      // Account Page
      array(
        'id'          => 'account-page',
        'type'        => 'select',
        'title'       => esc_html__('Hesabım Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews')
      ),

      // Kullanım Page
      array(
        'id'          => 'ks-page',
        'type'        => 'select',
        'title'       => esc_html__('Kullanım Sözleşmesi Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews')
      ),


      array(
        'id'          => 'feed-page',
        'type'        => 'select',
        'title'       => esc_html__('Akış Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),


      array(
        'id'          => 'exchange-page',
        'type'        => 'select',
        'title'       => esc_html__('Borsa Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),

      array(
        'id'          => 'doviz-page',
        'type'        => 'select',
        'title'       => esc_html__('Döviz Kurları Sayfası', 'kanews'),
        
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),
      array(
        'id'          => 'emtia-page',
        'type'        => 'select',
        'title'       => esc_html__('Emtia Sayfası', 'kanews'),
        
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Canlı Tv', 'kanews'),
      ),
      
      // Kanallar
      array(
        'id'     => 'live-tv',
        'type'   => 'group',
        'title' => esc_html__('Kanallar', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__('Kanal Adı', 'kanews'),
          ),
          array(
            'id'    => 'logo',
            'type'  => 'upload',
            'title' => esc_html__('Kanal Logosu', 'kanews'),
          ),
          array(
            'id'    => 'channel-title',
            'type'  => 'text',
            'title' => esc_html__('Kanal  Başlığı', 'kanews'),
          ),
          array(
            'id'    => 'content',
            'type'  => 'wp_editor',
            'title' => esc_html__('Kanal Açıklaması', 'kanews'),
          ),
          array(
            'id'    => 'iframe-src',
            'type'  => 'text',
            'rows'  => '1',
            'title' => esc_html__('Embed Linki', 'kanews'),
            'desc' => 'Örnek: https://www.youtube.com/embed/xxxx',
          ),
          array(
            'id'    => 'custom-embed',
            'type'  => 'text',
            'rows'  => '3',
            'sanitize' => 'csf_sanitize_replace_a_to_b',
            'title' => esc_html__('Veya İptv Linki', 'kanews'),
            'desc' => 'Örnek: https://tv-trt1.live.trt.com.tr/master_720.m3u8',
          )
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Gazetete Manşetleri', 'kanews'),
      ),
      
      // Kanallar
      array(
        'id'     => 'newspapers',
        'type'   => 'group',
        'title' => esc_html__('Gazeteler', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__('Gazete Adı', 'kanews'),
          ),
          array(
            'id'    => 'media',
            'type'  => 'text',
            'title' => esc_html__('Görsel', 'kanews'),
          ),
        ),
      ),



      // Puan
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Puan Durumları Sayfası', 'kanews'),
      ),
      
      array(
        'id'      => 'league-standings',
        'type'    => 'button_set',
        'multiple'    => true,
        'title'   => esc_html__('Gösterilecek Ligler', 'kanews'),
        'options' => array(
          'super-lig' => esc_html__('Süper Lig', 'kanews'),
          'almanya-bundesliga' => esc_html__('Bundesliga', 'kanews'),
          'ingiltere-premier-ligi' => esc_html__('Premier Lig', 'kanews'),
          'italya-serie-a' => esc_html__('Serie A', 'kanews'),
          'fransa-ligue-1' => esc_html__('Ligue 1', 'kanews'),
          'ispanya-la-liga' => esc_html__('La Liga', 'kanews'),
          'tff-1-lig' => esc_html__('TFF 1. Lig', 'kanews'),
          'euroleague' => esc_html__('Euroleague', 'kanews'),
          'erkek-basketbol' => esc_html__('Erkek Basket', 'kanews'),
          'kadin-basketbol' => esc_html__('Kadın Basket', 'kanews'),
          'efeler-ligi' => esc_html__('Efeler Ligi', 'kanews'),
          'sultanlar-ligi' => esc_html__('Sultanlar Ligi', 'kanews'),
          'sampiyonlar-ligi' => esc_html__('Şampiyonlar Ligi', 'kanews'),
          'avrupa-ligi' => esc_html__('Avrupa Ligi', 'kanews'),
          'konferans-ligi' => esc_html__('Konferans Ligi', 'kanews'),
        ),
        'default' => [
          'super-lig',
          'almanya-bundesliga',
          'ingiltere-premier-ligi',
          'italya-serie-a',
          'fransa-ligue-1',
          'ispanya-la-liga',
          'tff-1-lig',
          'euroleague',
          'erkek-basketbol',
          'kadin-basketbol',
          'efeler-ligi',
          'sultanlar-ligi'
        ]
      ),
      
      array(
        'id'      => 'league-default',
        'type'    => 'select',
        'class'  => 'no-border',
        'title'   => esc_html__('Varsayılan Lig', 'kanews'),
        'options' => array(
          'super-lig' => esc_html__('Süper Lig', 'kanews'),
          'almanya-bundesliga' => esc_html__('Bundesliga', 'kanews'),
          'ingiltere-premier-ligi' => esc_html__('Premier Lig', 'kanews'),
          'italya-serie-a' => esc_html__('Serie A', 'kanews'),
          'fransa-ligue-1' => esc_html__('Ligue 1', 'kanews'),
          'ispanya-la-liga' => esc_html__('La Liga', 'kanews'),
          'tff-1-lig' => esc_html__('TFF 1. Lig', 'kanews'),
          'euroleague' => esc_html__('Euroleague', 'kanews'),
          'erkek-basketbol' => esc_html__('Erkek Basket', 'kanews'),
          'kadin-basketbol' => esc_html__('Kadın Basket', 'kanews'),
          'efeler-ligi' => esc_html__('Efeler Ligi', 'kanews'),
          'sultanlar-ligi' => esc_html__('Sultanlar Ligi', 'kanews'),
        ),
        'default' => [
          'super-lig'
        ]
      ),


      array(
        'type'    => 'subheading',
        'content' => esc_html__('Yol Durumu Sayfası', 'kanews'),
      ),

      array(
        'id'          => 'traffic-city',
        'type'        => 'text',
        'title'   => esc_html__('Varsayılan Şehir', 'kanews'),
        'desc'        => esc_html__('Sadece il', 'kanews'),
        'default'     => 'İstanbul',
        'placeholder' => esc_html__('Şehir Seçin', 'kanews'),
      ),


      array(
        'type'    => 'subheading',
        'content' => esc_html__('Namaz Vakitleri Sayfası', 'kanews'),
      ),
      array(
        'id'          => 'prayer-page',
        'type'        => 'select',
        'title'       => esc_html__('Namaz Vakitleri Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),

      array(
        'id'      => 'prayer-page-city',
        'type'    => 'text',
        'class'  => 'no-border',
        'default'    => 'Ankara',
        'title'   => esc_html__('Varsayılan Şehir', 'kanews'),
      ),
      
      array(
        'id'      => 'prayer-page-city2',
        'type'    => 'text',
        'class'  => 'no-border',
        'title'   => esc_html__('Varsayılan İlçe', 'kanews'),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Nöbetçi Eczaneler Sayfası', 'kanews'),
      ),
      array(
        'id'          => 'eczane-page',
        'type'        => 'select',
        'title'       => esc_html__('Nöbetçi Eczaneler Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),

      array(
        'id'      => 'eczane-page-city',
        'type'    => 'text',
        'class'  => 'no-border',
        'default'    => 'Ankara',
        'title'   => esc_html__('Varsayılan Şehir', 'kanews'),
      ),
      
      array(
        'id'      => 'eczane-page-city2',
        'type'    => 'text',
        'class'  => 'no-border',
        'title'   => esc_html__('Varsayılan İlçe', 'kanews'),
      ),
      

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kripto Paralar Sayfası', 'kanews'),
      ),
      array(
        'id'          => 'crypto-page',
        'type'        => 'select',
        'title'       => esc_html__('Kripto Paralar Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),

      array(
        'id'      => 'crypto-page-index',
        'type'    => 'select',
        'default'    => 'try',
        'title'   => esc_html__('Varsayılan Para Birimi', 'kanews'),
        'options' => array(
          'try' => esc_html__('Türk Lirası', 'kanews'),
          'usdt'=> esc_html__('Amerikan Doları', 'kanews'),
          'eur' => esc_html__('Euro', 'kanews'),
          'btc' => esc_html__('Bitcoin', 'kanews'),
          'eth' => esc_html__('Ethereum', 'kanews'),
        )
      ),


      // Hava Durumu
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Hava Durumu Sayfası', 'kanews'),
      ),
      array(
        'id'          => 'weather-page',
        'type'        => 'select',
        'title'       => esc_html__('Hava Durumu Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews'),
      ),
      array(
        'id'          => 'weather-cities',
        'type'        => 'select',
        'title'       => esc_html__('Varsayılan Şehir', 'kanews'),
        'default'     => '745042',
        'class'  => 'no-border',
        'options'     => 'kanews_get_turkey_cities3',
        'placeholder' => esc_html__('Şehir Seçin', 'kanews'),
      ),
      array(
        'id'      => 'weather-cities2',
        'type'    => 'select',
        'class'  => 'no-border',
        'title'   => esc_html__('Gösterilecek Şehirler', 'kanews'),
        'options' => array(
          'turkey' => esc_html__('Türk Şehirleri', 'kanews'),
          'global' => esc_html__('Dünyanın Popüler Şehirleri', 'kanews'),
          'karma' => esc_html__('Karma', 'kanews'),
        )
      ),

      // İletişim
      array(
        'type'    => 'subheading',
        'content' => esc_html__('İletişim Sayfası', 'kanews'),
      ),
      array(
        'id'          => 'contact-page-description',
        'type'        => 'textarea',
'class'  => 'no-border',
        'default'        => 'Bizimle her konuda iletişime geçebilirsiniz, ekibimiz gün içinde mesai saatleri kapsamında cevap vermek için hazır bekliyor.',
        'title'       => esc_html__('Açıklama', 'kanews'),
      ),
      array(
        'id'          => 'contact-page-email',
        'type'        => 'text',
        'class'  => 'no-border',
        'default'     => 'admin@siteadresi.com',
        'title'       => esc_html__('E-Posta', 'kanews'),
      ),
      array(
        'id'          => 'contact-page-phone',
        'type'        => 'textarea',
        'class'  => 'no-border',
        'default'     => '850 8888 88',
        'title'       => esc_html__('Telefon', 'kanews'),
      ),
      array(
        'id'          => 'contact-page-address',
        'type'        => 'textarea',
        'class'  => 'no-border',
        'default'     => 'İstanbul/Mecidiyeköy',
        'title'       => esc_html__('Adres', 'kanews'),
      ),
      array(
        'id'          => 'contact-page-form',
        'type'        => 'select',
        'class'  => 'no-border',
        'title'       => esc_html__('İletişim Formu', 'kanews'),
        'options'     => 'kanews_get_contact_forms',
        'placeholder' => esc_html__('İletişim Formu Seçin', 'kanews'),
      ),
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'content' => '<a target="_blank" href="'.admin_url('plugin-install.php?tab=plugin-information&amp;plugin=contact-form-7&amp;TB_iframe=true&amp;width=640&amp;height=500').'">Contact Form 7</a> eklentisinin kurun ve form oluşturun. Eğer form seçilmediyse temaya dahil iletişim formu çalışır.',
      ),

    )
  ));

	/**
	 * Members System
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Üyelik Sistemi', 'kanews' ),
		'icon'        => 'far fa-user',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Üyelik Sistemi', 'kanews'),
      ),
      // Membership System
      array(
        'id'    => 'login-system',
        'title'  => esc_html__('Üyelik Sistemi', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'email-activation',
        'title' => esc_html__('Üyeler için E-Posta Onayı', 'kanews'),
        'type'  => 'switcher',
        'dependency' => array( 'notifications', '!=', false ),
        'default' => false
      ),
      
      
      // Disable Admin Bar
      array(
        'id'    => 'wp-admin-bar-disable',
        'title'  => esc_html__('Admin Panel Çubuğunu Gizle', 'kanews'),
        'type'  => 'switcher',
        
        'default' => false
      ),
      // Admin Redirect
      array(
        'id'    => 'wp-admin-redirect',
        'title'  => esc_html__('Wp-admin Sayfalarına Erişimi Engelle', 'kanews'),
        'type'  => 'switcher',
        
        'default' => false
      ),
      // Like System
      array(
        'id'    => 'post-like',
        'title'  => esc_html__('Beğen Sistemi', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),
      // Bookmark System
      array(
        'id'    => 'post-bookmark',
        'title'  => esc_html__('Favori Sistemi', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kullanıcı Rozetleri', 'kanews'),
      ),
      array(
        'id'     => 'user-badge',
        'type'   => 'group',
        
        'title'  => esc_html__('Kullanıcı Rozetleri', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Rozet Tanımı', 'kanews'),
          ),
          array(
            'id'      => 'role',
            'type'    => 'select',
            'title'   => esc_html__('Eşleştirilen Wordpress Rolü', 'kanews'),
            'options' => array(
              'subscriber' => esc_html__('Abone', 'kanews'),
              'contributor' => esc_html__('İçerik Sağlayıcı', 'kanews'),
              'columist' => esc_html__('Köşe Yazarı', 'kanews'),
              'author' => esc_html__('Yazar', 'kanews'),
              'editor' => esc_html__('Editör', 'kanews'),
              'administrator' => esc_html__('Yönetici', 'kanews'),
            )
          ),
          array(
            'id'      => 'color',
            'type'    => 'color',
            'title'   => esc_html__('Rozet Arkaplanı', 'kanews')
          ),
        ),
        'default' => array(
          array(
            'title' => esc_html__('Yönetici', 'kanews'),
            'role' => 'administrator',
            'color' => '#e74c3c',
          ),
          array(
            'title' => esc_html__('Editör', 'kanews'),
            'role' => 'editor',
            'color' => '#9b59b6',
          ),
          array(
            'title' => esc_html__('Yazar', 'kanews'),
            'role' => 'author',
            'color' => '#34495e',
          ),
          array(
            'title' => esc_html__('Köşe Yazarı', 'kanews'),
            'role' => 'contributor',
            'color' => '#16a085',
          ),
          array(
            'title' => esc_html__('Üye', 'kanews'),
            'role' => 'subscriber',
            'color' => '#2ecc71',
          ),
        ),
      ),
      array(
        'id'     => 'user-badge-2',
        'type'   => 'group',
        'title'  => esc_html__('Puana Göre Rozetler', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Rozet Tanımı', 'kanews'),
          ),
          array(
            'id'       => 'min',
            'type'     => 'slider',
            'title'    => esc_html__('Minimum Puan', 'kanews'),
            'min'      => 1,
            'max'      => 100000,
            'step'     => 1,
            'default'  => 1,
          ), 
          array(
            'id'       => 'max',
            'type'     => 'slider',
            'title'    => esc_html__('Maksimum Puan', 'kanews'),
            'min'      => 1,
            'max'      => 100000,
            'step'     => 1,
            'default'  => 50,
          ),  

          array(
            'id'      => 'color',
            'type'    => 'color',
            'title'   => esc_html__('Rozet Arkaplanı', 'kanews')
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Puanlama Sistemi', 'kanews'),
      ),
      array(
        'id'    => 'scoring_system',
        'title'  => esc_html__('Puanlama Sistemi', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'       => 'entry_score',
        'type'     => 'slider',
        'title'    => esc_html__('Yazı Puanı', 'kanews'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 50,
      ),  
      array(
        'id'       => 'comment_score',
        'type'     => 'slider',
        'title'    => esc_html__('Yorum Puanı', 'kanews'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 25,
      ),  
      array(
        'id'       => 'avatar_score',
        'type'     => 'slider',
        'title'    => esc_html__('Avatar Puanı', 'kanews'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 15,
      ), 
      array(
        'id'       => 'cover_score',
        'type'     => 'slider',
        'title'    => esc_html__('Profil Arkaplanı Puanı', 'kanews'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 15,
      ), 
      array(
        'id'       => 'social_score',
        'type'     => 'slider',
        'title'    => esc_html__('Sosyal Medya Puanı', 'kanews'),
        'min'      => 1,
        'max'      => 1000,
        'step'     => 10,
        'default'  => 5,
      ),  

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Bildirim Sistemi', 'kanews'),
      ),

      // Notifications
      array(
        'id'    => 'notifications',
        'title'  => esc_html__('Bildirim Sistemi', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'follow-categories',
        'title' => esc_html__('Kategoriler için Takip Sistemi', 'kanews'),
        'type'  => 'switcher',
        'dependency' => array( 'notifications', '!=', false ),
        'default' => false
      ),

      array(
        'id'    => 'follow-authors',
        'title' => esc_html__('Yazarlar için Takip Sistemi', 'kanews'),
        'type'  => 'switcher',
        'dependency' => array( 'notifications', '!=', false ),
        'default' => false
      ),

      array(
        'id'     => 'fake_notifications',
        'type'   => 'group',
        'title'  => esc_html__('Sahte Bildirimler', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Başlık', 'kanews'),
          ),
          array(
            'id'    => 'date',
            'type'  => 'date',
            'title' => __('Tarih', 'kanews'),
            'settings' => array(
              'dateFormat'      => 'mm/dd/yy',
            )
          ),
          array(
            'id'    => 'link',
            'type'  => 'text',
            'title' => __('Bağlantı', 'kanews'),
          ),
          array(
            'id'      => 'image',
            'type'    => 'upload',
            'title'   => esc_html__('Görsel', 'kanews'),
          ),
          array(
            'id'      => 'show',
            'default' => 'all',
            'type'    => 'select',
            'title'   => esc_html__('Kimler Görecek', 'kanews'),
            'options' => array(
              'members' => esc_html__('Üye', 'kanews'),
              'visitors' => esc_html__('Ziyaretçi', 'kanews'),
              'all' => esc_html__('Herkes', 'kanews'),
            )
          ),
        ),
      ),

      


      array(
        'title'  => esc_html__('Hesabım', 'kanews'),
        'type'  => 'subheading'
      ),
      array(
        'id'    => 'account-logs',
        'title'  => esc_html__('Yöneticiye E-Posta Bildirimi', 'kanews'),
        'desc'  => esc_html__('İçerik eklendiğinde/düzenlendiğinde yöneticiye e-posta gönderilir.', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'columnist-submit',
        'title'  => esc_html__('Köşe Yazısı Gönder', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'columnist-submit-only',
        'title'  => esc_html__('Köşe Yazısı Gönder', 'kanews'),
        'desc'  => esc_html__('Aktif edildiğinde köşe Yazısını sadece köşe yazarları gönderebilir.', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),

      // Posting System
      array(
        'id'    => 'post-edit',
        'title'  => esc_html__('İçerik Düzenle', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'post-submit',
        'title'  => esc_html__('İçerik Gönder', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),
      array(
        'id'      => 'post-submit-status-editor',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu', 'kanews').' - '.esc_html__('Editör', 'kanews'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'post-submit-status-author',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu', 'kanews').' - '.esc_html__('Yazar', 'kanews'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'post-submit-status-contributor',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu', 'kanews').' - '.esc_html__('İçerik Sağlayıcı', 'kanews'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'post-submit-status',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu', 'kanews').' - '.esc_html__('Üye', 'kanews'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'post-submit-status-columist',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu', 'kanews').' - '.esc_html__('Köşe Yazarı', 'kanews'),
        'dependency' => array( 'post-submit', '==', 'true' ),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      

      
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Kanews Insights', 'kanews'),
      ),
      // Subscription System
      array(
        'id'    => 'kanews-insights',
        'title'  => esc_html__('Ücretli Abonelik Sistemi', 'kanews'),
        'desc'  => esc_html__('Woocommerce eklentisi gerektirir.', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'remove-ad',
        'title'  => esc_html__('Reklamı Kaldır Linki', 'kanews'),
        'desc'  => esc_html__('Reklamların sağ üst köşesine reklamı kaldır linki ekler.', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      // Subscription Page
      array(
        'id'          => 'kanews-insights-page',
        'type'        => 'select',
        'title'       => esc_html__('Abonelik Sayfası', 'kanews'),
        'chosen'      => true,
        'sortable'    => true,
        'ajax'        => true,
        'options'     => 'pages',
        'placeholder' => esc_html__('Sayfa Seçin', 'kanews')
      ),
      // Header Subscription Button
      array( 
        'id'      => 'kanews-insights-button',
        'dependency' => array( 'kanews-insights', '==', 'true' ),
        'title'   => esc_html__('Abonelik Butonu', 'kanews'),
        'desc'    => esc_html__('Headera kullanıcıları abonelik sayfasına yönlendirecek bir buton ekler.', 'kanews'),
        'type'    => 'switcher',
        'default' => false
      ),

      array(
        'id'     => 'subscription-faq',
        'type'   => 'group',
        'title' => esc_html__('Sıkça Sorulan Sorular', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => esc_html__('Başlık', 'kanews'),
          ),
          array(
            'id'    => 'content',
            'type'  => 'textarea',
            'title' => esc_html__('Açıklama', 'kanews'),
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar', 'kanews'),
      ),
      
      
      array(
        'id'                    => 'login-left-background',
        'type'                  => 'background',
        'title'                 => esc_html__( 'Giriş/Kayıt Sol Alan Tasarımı', 'kanews' ),
        'background_color'      => true,
        'background_image'      => true,
        'background-position'   => true,
        'background_repeat'     => true,
        'background_attachment' => true,
        'background_size'       => true,
        'background_origin'     => false,
        'background_clip'       => false,
        'background_blend_mode' => false,
        'background_gradient'   => false,
        'default'               => array(
          'background-color'              => '#1d1f26',
          'background-position'           => 'center center',
          'background-repeat'             => 'no-repeat',
          'background-size'               => 'cover',
        )
      ),

    
		)
  ) );
  
  /**
	 * Customizer
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Özelleştirmeler', 'kanews' ),
		'icon'        => 'fas fa-fill-drip',
		'fields'      => array(
      // General
      array(
        'type'    => 'heading',
        'content' => esc_html__('Genel Özelleştirmeler', 'kanews'),
      ),
      array(
        'id'       => 'site-container',
        'type'     => 'dimensions',
        'height'   => false,
        'title'    => esc_html__('Site Genişliği', 'kanews'),
        'desc'    => esc_html__('Görsel kalite düşecektir, ayarlayacağınız boyuta göre sitede bozulmalar olabilir. Varsayılan: 1200px', 'kanews'),
        'default'  => array(
          'width'  => '1200',
          'unit'   => 'px',
        ),
      ),
      array(
        'id'                    => 'site-background',
        'type'                  => 'background',
        'title'                 => esc_html__('Site Arkaplanı', 'kanews'),
        'background_color'      => true,
        'background_image'      => true,
        'background-position'   => true,
        'background_repeat'     => true,
        'background_attachment' => true,
        'background_size'       => true,
        'background_origin'     => true,
        'background_clip'       => false,
        'background_blend_mode' => false,
        'background_gradient'   => true,
      ),
      array(
        'id'      => 'switch-primary-color',
        'type'    => 'switcher',
        'default'    => true,
        'desc'   => esc_html__('Kategori renklerini o kategoride ve kategoriye ait yazılarda birincil renk olarak siteye uyarla.', 'kanews'),
        'title'   => esc_html__('Kategori Rengini Uygula', 'kanews')
      ),
      array(
        'id'      => 'primary-color',
        'type'    => 'color',
        'title'   => esc_html__('Birincil Renk', 'kanews')
      ),
      array(
        'id'      => 'primary-amp-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Birincil Renk (AMP)', 'kanews')
      ),
      array(
        'id'          => 'site-font',
        'type'        => 'select',
        'title'       => esc_html__('Site Fontu', 'kanews'),
        'chosen'      => true,
        'options'     => 'kanews_google_fonts',
        'attributes' => array(
          'style'    => 'width: 100%;'
        ),
        'placeholder' => 'Varsayılan',
      ),

      // Block
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Blok', 'kanews'),
      ),
      array(
        'id'      => 'block-border',
        'type'    => 'button_set',
        'title'  => esc_html__('Blok Kenarlık Stili', 'kanews'),
        'options' => array(
          'border' => esc_html__('Border', 'kanews'),
          'box_shadow' => esc_html__('Box Shadow', 'kanews'),
          'none' => esc_html__('Düz', 'kanews'),
        ),
        'default' => 'box_shadow'
      ),
      array(
        'id'      => 'block-border-color',
        'type'    => 'color',
        'title'   => esc_html__('Blok Border Rengi', 'kanews')
      ),
      array(
        'id'       => 'block-border-radius',
        'type'     => 'slider',
        'title'    => esc_html__('Blok Kenarlık Çapı', 'kanews'),
        'min'      => 0,
        'max'      => 25,
        'step'     => 1,
      ),  

      // Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Header', 'kanews'),
      ),

      array(
        'id'            => 'height-height-tab',
        'type'          => 'tabbed',
        'title'         => esc_html__('Header Yüksekliği', 'kanews'),
        'desc'          => esc_html__('Logonun bulunduğu bölümün yüksekliği.', 'kanews'),
        'tabs'          => array(
          array(
            'title'     => esc_html__('Masaüstü', 'kanews'),
            'icon'      => 'fa fa-desktop',
            'fields'    => array(
              array(
                'id'       => 'desktop',
                'type'     => 'dimensions',
                'width'   => false,
                'title'    => esc_html__('Yükseklik', 'kanews'),
                'default'  => array(
                  'height'  => '',
                  'unit'   => 'px',
                ),
              )
            )
          ),
          array(
            'title'     => esc_html__('Mobil', 'kanews'),
            'icon'      => 'fa fa-mobile',
            'fields'    => array(
              array(
                'id'       => 'mobile',
                'type'     => 'dimensions',
                'width'   => false,
                
                'title'    => esc_html__('Yükseklik', 'kanews'),
                'default'  => array(
                  'height'  => '',
                  'unit'   => 'px',
                ),
              ),
            ),
          )
        ),
      ),

      array(
        'id'      => 'header-color',
        'type'    => 'color',
        'title'   => esc_html__('Arka Plan Rengi', 'kanews')
      ),
      array(
        'id'      => 'header-color-2',
        'type'    => 'color',
        'dependency' => array( 'header-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)', 'kanews')
      ),

      array(
        'id'      => 'subscribe-btn-color',
        'type'    => 'color',
        'dependency' => array( 'kanews-insights-button', '!=', 'false' ),
        'title'   => esc_html__('Abone Ol Buton Rengi', 'kanews')
      ),
      array(
        'id'      => 'header-border-color',
        'type'    => 'color',
        'title'   => esc_html__('Border Rengi', 'kanews')
      ),
      array(
        'id'      => 'header-btn-bgcolor',
        'type'    => 'color',
        'title'   => esc_html__('Buton Arkaplan Rengi', 'kanews')
      ),
      array(
        'id'      => 'header-btn-color',
        'type'    => 'color',
        'title'   => esc_html__('Buton Rengi', 'kanews')
      ),

      // Sub Header
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sub Header', 'kanews'),
      ),
      array(
        'id'      => 'subheader-color',
        'type'    => 'color',
        'title'   => esc_html__('Arka Plan Rengi', 'kanews')
      ),
      array(
        'id'      => 'subheader-link-color',
        'type'    => 'color',
        'title'   => esc_html__('Linklerin Rengi', 'kanews')
      ),

      // Footer
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Footer', 'kanews'),
      ),
      array(
        'id'      => 'footer-color',
        'type'    => 'color',
        'class'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi', 'kanews')
      ),
      array(
        'id'      => 'footer-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'footer-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)', 'kanews')
      ),

      // Navbar
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Navbar', 'kanews'),
      ),
      array(
        'id'      => 'navbar-color',
        'type'    => 'color',
        'title'   => esc_html__('Arka Plan Rengi', 'kanews')
      ),
      array(
        'id'      => 'navbar-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'navbar-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)', 'kanews')
      ),
      array(
        'id'      => 'navbarlink-color',
        'type'    => 'color',
        'title'   => esc_html__('Linklerin Rengi', 'kanews')
      ),
      array(
        'id'      => 'navbarlinkhover-color',
        'type'    => 'color',
        'title'   => esc_html__('Linklerin Üzerindeykenki Rengi', 'kanews')
      ),
      array(
        'id'                 => 'navbar-typography',
        'type'               => 'typography',
        'title'              => esc_html__('Tipografi', 'kanews'),
        'font_family'        => true,
        'font_weight_2'      => true,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => false,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => false,
        'text_decoration'    => false,
      ),

    
      // Big Menu
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Büyük Menü', 'kanews'),
      ),
      array(
        'id'      => 'bigmenu-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi', 'kanews')
      ),
      array(
        'id'      => 'bigmenu-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'bigmenu-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)', 'kanews')
      ),
      array(
        'id'      => 'bigmenulink-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Linklerin Rengi', 'kanews')
      ),

      // Mobile Menu
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Mobil Açılır Menü', 'kanews'),
      ),
      array(
        'id'      => 'mobilmenu-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi', 'kanews')
      ),
      array(
        'id'      => 'mobilmenu-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'bigmenu-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)', 'kanews')
      ),
      array(
        'id'      => 'mobilmenu-text-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazıların Rengi', 'kanews')
      ),
      array(
        'id'      => 'mobilmenulink-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Linklerin Rengi', 'kanews')
      ),

      // Mobile Menu
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Sayfa Barı (Page Header)', 'kanews'),
      ),
      array(
        'id'      => 'pageheader-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Arka Plan Rengi', 'kanews')
      ),
      array(
        'id'      => 'pageheader-color-2',
        'type'    => 'color',
        
        'dependency' => array( 'bigmenu-color', '!=', '' ),
        'title'   => esc_html__('Arka Plan Rengi 2 (Gradient)', 'kanews')
      ),
      array(
        'id'      => 'pageheadertext-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazıların Rengi', 'kanews')
      ),

      // Single Post
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Yazı Sayfası', 'kanews'),
      ),
      array(
        'id'      => 'single-postitle-color',
        'type'    => 'color',
        'title'   => esc_html__('Yazı Başlığının Rengi', 'kanews')
      ),
      array(
        'id'                 => 'single-postitle-typography',
        'type'               => 'typography',
        
        'title'              => esc_html__('Yazı Başlığının Tipografisi', 'kanews'),
        'font_family'        => false,
        'font_weight'        => false,
        'font_weight_2'      => true,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => true,
      ),
      array(
        'id'      => 'single-postsubtitle-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı Açıklamasının Rengi', 'kanews')
      ),
      array(
        'id'                 => 'single-postsubtitle-typography',
        'type'               => 'typography',
        
        'title'              => esc_html__('Yazı Açıklamasının Tipografisi', 'kanews'),
        'font_family'        => false,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'font_weight_2'      => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => true,
      ),
      array(
        'id'      => 'single-postmeta-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı Metalarının Rengi', 'kanews')
      ),
      array(
        'id'                 => 'single-postmeta-typography',
        'type'               => 'typography',
        
        'title'              => esc_html__('Yazı Metalarının Tipografisi', 'kanews'),
        'font_family'        => false,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => true,
      ),

      
      array(
        'id'      => 'single-postcontent-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı İçeriğinin Rengi', 'kanews')
      ),
      array(
        'id'      => 'single-postcontentlink-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı İçerik Linklerinin Rengi', 'kanews')
      ),
      array(
        'id'      => 'single-postcontentlinkhover-color',
        'type'    => 'color',
        
        'title'   => esc_html__('Yazı İçerik Linklerinin Üzerindeykenki Rengi', 'kanews')
      ),
      array(
        'id'          => 'single-font',
        'type'        => 'select',
        'title'       => esc_html__('Yazı İçeriğinin Fontu', 'kanews'),
        'chosen'      => true,
        
        'options'     => 'kanews_google_fonts',
        'attributes' => array(
          'style'    => 'width: 100%'
        ),
        'placeholder' => 'Varsayılan',
      ),
      array(
        'id'                 => 'single-postcontent-typography',
        'type'               => 'typography',
        'title'              => esc_html__('Yazı İçeriğinin Tipografisi', 'kanews'),
        'font_family'        => false,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => false,
      ),

      // Archives
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Arşivler', 'kanews'),
      ),
      array(
        'id'                 => 'postitle-typography',
        'type'               => 'typography',
        
        'title'              => esc_html__('Yazı Başlığı Tipografisi', 'kanews'),
        'font_family'        => false,
        'font_weight_2'      => true,
        'font_weight'        => false,
        'font_style'         => false,
        'font_size'          => true,
        'line_height'        => true,
        'letter_spacing'     => true,
        'text_align'         => false,
        'text-transform'     => true,
        'color'              => false,
        'subset'             => false,
        'backup_font_family' => false,
        'font_variant'       => false,
        'word_spacing'       => true,
        'text_decoration'    => false,
      ),

      // Back To Top
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Başa Dön Tuşu', 'kanews'),
      ),
      array(
        'id'      => 'backtotop-background',
        'type'    => 'color',
        
        'title'   => esc_html__('Vurgulanan Renk', 'kanews')
      ),
      array(
        'id'      => 'backtotop-color',
        'type'    => 'color',
        
        'title'   => esc_html__('İkon Rengi', 'kanews')
      ),

      // Back To Top
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Son Dakika Barı', 'kanews'),
      ),
      array(
        'id'      => 'bn-left-background',
        'type'    => 'color',
        
        'title'   => esc_html__('Sol Arka Plan Rengi', 'kanews')
      ),
      array(
        'id'      => 'bn-left-color',
        
        'type'    => 'color',
        'title'   => esc_html__('Sol İçerik Rengi', 'kanews')
      ),

    )
  ));


  /**
	 * Authors
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Yazar Listesi', 'kanews' ),
		'icon'        => 'fas fa-flag',
		'fields'      => array(
      array(
        'content'  => '<a href="'.home_url(get_option('kanews_author_base', 'yazarlar')).'">Yazarların Gösterileceği Sayfa</a>',
        'type'    => 'notice',
        'style'   => 'info',
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Yazar Listesi Oluştur', 'kanews'),
      ),
      array(
        'id'     => 'author-lists',
        'type'   => 'group',
        'title'  => esc_html__('Liste', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title'  => esc_html__('Başlık', 'kanews'),
          ),
          array(
            'id'          => 'authors',
            'type'        => 'select',
            'title'       => 'Gösterilecek Üyeler',
            'chosen'      => true,
            'multiple'    => true,
            'ajax'        => true,
            'placeholder' => 'Kullanıcı Seçin',
            'options' => 'users',
          ),
        ),
      ),
    )
  ) );

	/**
	 * Popup
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Popup', 'kanews' ),
		'icon'        => 'fas fa-flag',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Popup Ayarları', 'kanews'),
      ),
      array(
        'id'    => 'popup',
        'title'  => esc_html__('Popup', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'popup-title',
        'type'  => 'text',
        'title'  => esc_html__('Popup Başlığı', 'kanews'),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Popup Modülleri', 'kanews'),
      ),
      
      array(
        'id'      => 'popup-module',
        'type'    => 'button_set',
        'desc'  => esc_html__('Bileşen seçiliyse görünüm>bileşenler sayfasında Popup bileşen alanına ekli bileşenler gösterilir.', 'kanews'),
        'options' => array(
          'custom' => esc_html__('Özel Alan', 'kanews'),
          'widget' => esc_html__('Bileşen', 'kanews'),
        ),
        'default' => 'custom'
      ),
      array(
        'id'    => 'popup-module-custom',
        'type'  => 'wp_editor',
        'title'  => esc_html__('İçerik', 'kanews'),
        
        'dependency' => array( 'popup-module', '==', 'custom' ),
      ),
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Diğer Ayarlar', 'kanews'),
      ),
      array(
        'id'       => 'popup-delay',
        'type'     => 'slider',
        'title'    => esc_html__('Gecikme Süresi (sn)', 'kanews'),
        'min'      => 1,
        'max'      => 100,
        'step'     => 1,
        'default'  => 5,
      ),  
      array(
        'id'       => 'popup-expired',
        'type'     => 'slider',
        'title'    => esc_html__('Cookie Geçerlilik Süresi (gün)', 'kanews'),
        'desc'    => esc_html__('Çarpı butonuna basıldıktan kaç gün sonra tekrar gözükeceğini belirleyin.', 'kanews'),
        'min'      => 1,
        'max'      => 365,
        'step'     => 1,
        'default'  => 7,
      ),  
      array(
        'id'       => 'popup-width',
        'type'     => 'slider',
        'title'    => esc_html__('İçerik Genişliği', 'kanews'),
        'min'      => 325,
        'max'      => 992,
        'step'     => 1,
      ),  
    )
  ));

	/**
	 * İlan
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'İlan Sistemi', 'kanews' ),
		'icon'        => 'fas fa-thermometer-full',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('İlan Sistemi', 'kanews'),
      ),
      array(
        'id'    => 'ilan-sistemi',
        'title'  => esc_html__('İlan Sistemi', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'ilan-submit',
        'title'  => esc_html__('İlan Gönder', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'ilan-edit',
        'title'  => esc_html__('İlan Düzenle', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'ilan-update',
        'title'  => esc_html__('İlanı Yukarı Taşı', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'dependency' => array( 'ilan-update', '==', 'true' ),
        'content' => '<a target="_blank" href="'.admin_url('plugin-install.php?tab=plugin-information&amp;plugin=simple-custom-post-order&amp;TB_iframe=true&amp;width=640&amp;height=500').'">Simple Custom Post Order</a> eklentisinin kurun ve Ayarlar>SCPOrder sayfasındaki Check to Sort Post Types kısmından İlanları aktif edin.',
      ),
      array(
        'id'    => 'ilan-insights',
        'title'  => esc_html__('Abonelik Sistemiyle Entegre Et', 'kanews'),
        'desc'  => esc_html__('Kanews/Üyelik Sistemi sayfasındaki Ücretli Abonelik Sistemi ayarının aktif olması gerekir. Abone kullanıcılara ilanlarını yukarı taşımaya olanak sağlar. ', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'ilan-submit-status-editor',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Editör)', 'kanews'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'ilan-submit-status-author',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Yazar)', 'kanews'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'ilan-submit-status-contributor',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (İçerik Sağlayıcı)', 'kanews'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'ilan-submit-status',
        'type'    => 'select',
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Üye)', 'kanews'),

        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
    )
  ));

	/**
	 * Firma Rehberi
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Firma Rehberi', 'kanews' ),
		'icon'        => 'fas fa-thermometer-full',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('Firma Rehberi', 'kanews'),
      ),
      array(
        'id'    => 'firma-rehberi',
        'title'  => esc_html__('Firma Rehberi Sistemi', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'firma-edit',
        'title'  => esc_html__('Firma Düzenle', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'    => 'firma-widgets',
        'title'  => esc_html__('Varsayılan Bileşenler', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),

      array(
        'id'    => 'comp-insights',
        'title'  => esc_html__('Abonelik Sistemiyle Entegre Et', 'kanews'),
        'desc'  => esc_html__('Kanews/Üyelik Sistemi sayfasındaki Ücretli Abonelik Sistemi ayarının aktif olması gerekir. Firmayı ekleyen üye abone ise bilgileri gözükür değilse gözükmez.', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),
      array(
        'id'    => 'comp-logged',
        'title'  => esc_html__('Firma Bilgilerini Ziyaretçiler için Gizle', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'      => 'comp-submit-status-editor',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Editör)', 'kanews'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'comp-submit-status-author',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Yazar)', 'kanews'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'comp-submit-status-contributor',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (İçerik Sağlayıcı)', 'kanews'),
        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),
      array(
        'id'      => 'comp-submit-status',
        'type'    => 'select',
        
        'title'   => esc_html__('Paylaşılan İçeriğin Durumu (Üye)', 'kanews'),

        'options' => array(
          'pending' => esc_html__('Onay Sürecinde', 'kanews'),
          'publish' => esc_html__('Yayınla', 'kanews'),
          'draft' => esc_html__('Taslak', 'kanews'),
          'private' => esc_html__('Özel', 'kanews'),
        ),
        'default' => 'pending'
      ),

      array(
        'id'      => 'firma-style',
        'type'    => 'image_select',
        
        'title'   => esc_html__('Arşiv Görünüm', 'kanews'),
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),

      // Related Posts
      array(
        'type'    => 'subheading',
        'content' => esc_html__('Benzer Firmalar', 'kanews'),
      ),
      
      array(
        'id'      => 'related-firma-style',
        'type'    => 'image_select',
        
        'title'   => esc_html__('Görünüm', 'kanews'),
        'options' => array(
          '1' => KAN_TEMPLATE_URL .'/assets/img/options/archive-5.jpg',
          '2' => KAN_TEMPLATE_URL .'/assets/img/options/archive-2.jpg',
          '3' => KAN_TEMPLATE_URL .'/assets/img/options/archive-3.jpg',
          'disable' => KAN_TEMPLATE_URL .'/assets/img/options/off.jpg',
        ),
        'default' => '3',
      ),
      array(
        'id'      => 'related-firma-sortby',
        'type'    => 'radio',
        
        'title'   => esc_html__('Göre Sırala', 'kanews'),
        'dependency' => array( 'related-firma-style', '!=', 'disable' ),
        'desc'   => 'Benzer firmaların sıralanışını belirler, tüm seçenekler ilk olarak ana firmanın kategorisi baz alır',
        'options' => array(
          'recent' => esc_html__('Yayınlanma Tarihine Göre', 'kanews'),
          'commented' => esc_html__('En Çok Yorum Yapılan', 'kanews'),
          'random' => esc_html__('Rastgele', 'kanews'),
        ),
        'default' => 'commented'
      ),
      array(
        'id'       => 'related-firma-count',
        'type'     => 'slider',
        
        'dependency' => array( 'related-firma-style', '!=', 'disable' ),
        'title'    => esc_html__('Firma Sayısı', 'kanews'),
        'min'      => 1,
        'max'      => 20,
        'step'     => 1,
        'default'  => 6,
      ),

		)
  ) );
  
	/**
	 * Cron Job
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Veri Güncelleme', 'kanews' ),
		'icon'        => 'fas fa-wifi',
		'fields'      => array(

      array(
        'id'         => 'openweathermap-api',
        'type'       => 'text',
        'title'      => esc_html__('Openweathermap API Anahtarı', 'kanews'),
        'desc'      =>  '<a href="https://openweathermap.org/price" target="_blank">'.esc_html__( 'Api oluşturmak için tıklayın.', 'kanews' ).'</a>'
      ),

      array(
        'type'    => 'heading',
        'content' => esc_html__('Bilgilendirme', 'kanews'),
      ),
      array(
        'type'    => 'notice',
        'style'   => 'info',
        'content' => 'Dosya konumunu değil ancak dosya isimlerini değiştirebilirsiniz.',
      ),
      array(
        'type'    => 'notice',
        'style'   => 'danger',
        'content' => 'Borsa İstanbul verilerinin dağıtımı için bir veri yayın kuruluşu üzerinden lisans satın almanız gerekmektedir dolayısıyla borsa istanbul verilerini sitenizde kullanmak telif hakkı ihlaline sebebiyet verebilir. Kanews Borsa İstanbul veya farklı bir kuruluş üzerinden veri dağıtım lisansı sağlamaz.',
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Cron Job Oluştur', 'kanews'),
      ),
      array(
        'type'    => 'content',
        'content' => '
          <h3>1- Sitenizin cpanel veya türevi olan sunucu yönetim paneline girin </h3>
          <h3>2- Gelişmiş > Cron İşleri sayfasına girin. <a target="_blank" href="https://www.kanthemes.com/files/kanews/yardim/cron1.png">Görsel</a> </h3>
          <h3>3- Aşağıdaki kodların her birini tek tek görselde belirtildiği şekilde cron işi olarak ekleyin. Mevcut ayarlardan sadece Ortak Ayarlar kısmında ilgili verinin ne kadar sürede güncellenmesini istiyorsanız o seçeneği seçin.  <a target="_blank" href="https://www.kanthemes.com/files/kanews/yardim/cron2.png">Görsel</a> </h3>
          <ul>
            <li><code>wget -O /dev/null -o /dev/null '.KAN_TEMPLATE_URL.'/inc/api/currencies/doviz71352.php</code> </li>
            <li><code>wget -O /dev/null -o /dev/null '.KAN_TEMPLATE_URL.'/inc/api/standings/standings5kds1.php</code> </li>
            <li><code>wget -O /dev/null -o /dev/null '.KAN_TEMPLATE_URL.'/inc/api/exchange/borsa_2321lsa1.php</code></li>
            <li><code>wget -O /dev/null -o /dev/null '.KAN_TEMPLATE_URL.'/inc/api/gold/gold_k2ns1.php</code></li>
          </ul>

          <p>
          1. için <i>Saatte İki Kez</i>,<br>
          2. için <i>Saatte İki Kez</i>,<br>
          3. için <i>Günde İki Kez</i>,<br>
          4. için <i>Günde İki Kez</i>,<br>
          5. için <i>Saatte Bir Kez</i>,<br>
          6. için <i>Saatte Bir Kez</i>,<br>
          ayarları önerilir.
          </p>
          ',
      ),



      array(
        'type'    => 'subheading',
        'content' => esc_html__('Verileri Manuel Güncelle', 'kanews'),
      ),
      array(
        'type'    => 'content',
        'content' => '
          <p>
          <a target="_blank" href="'.KAN_TEMPLATE_URL.'/inc/api/currencies/doviz71352.php" class="button">Döviz Kurlarını Güncelle</a>
          <a target="_blank" href="'.KAN_TEMPLATE_URL.'/inc/api/standings/standings5kds1.php" class="button">Puan Durumlarını Güncelle</a>
          <a target="_blank" href="'.KAN_TEMPLATE_URL.'/inc/api/exchange/borsa_2321lsa1.php" class="button">Borsa Verilerini Güncelle</a>
          <a target="_blank" href="'.KAN_TEMPLATE_URL.'/inc/api/gold/gold_k2ns1.php" class="button">Emtia Verilerini Güncelle</a>
          </p>
          ',
      ),

		)
	) );
  
	/**
	 * Cron Job
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'Kanews AI', 'kanews' ),
		'icon'        => 'fas fa-wifi',
		'fields'      => array(

      array(
        'id'         => 'openai-api',
        'type'       => 'text',
        'title'      => esc_html__('OpenAI API Anahtarı', 'kanews'),
        'desc'      =>  '<a href="https://platform.openai.com/settings/profile?tab=api-keys" target="_blank">'.esc_html__( 'Api oluşturmak için tıklayın.', 'kanews' ).'</a>'
      ),
      array(
        'id'         => 'pexels-api',
        'type'       => 'text',
        'title'      => esc_html__('Pexels API Anahtarı', 'kanews'),
        'desc'      =>  '<a href="https://www.pexels.com/api/key/" target="_blank">'.esc_html__( 'Api oluşturmak için tıklayın.', 'kanews' ).'</a>'
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('KAI Sohbet Ayarları', 'kanews'),
      ),

      array(
        'id'    => 'kai-chat-active',
        'title'  => esc_html__('KAI Sohbet Sistemi', 'kanews'),
        'desc'  => esc_html__('Makale sayfalarında KAI sohbet sistemini aktif eder.', 'kanews'),
        'type'  => 'switcher',
        'default' => true
      ),

      array(
        'id'    => 'kai-chat-title',
        'title'  => esc_html__('Sohbet Başlığı', 'kanews'),
        'desc'  => esc_html__('Sohbet penceresinin başlığı.', 'kanews'),
        'type'  => 'text',
        'default' => 'KAI ile Haber Hakkında Sohbet'
      ),

      array(
        'id'    => 'kai-chat-placeholder',
        'title'  => esc_html__('Input Placeholder', 'kanews'),
        'desc'  => esc_html__('Soru yazma alanındaki placeholder metni.', 'kanews'),
        'type'  => 'text',
        'default' => 'Sorunuzu yazın...'
      ),

      array(
        'id'    => 'kai-chat-free-limit',
        'title'  => esc_html__('Ücretsiz Kullanıcı Limiti', 'kanews'),
        'desc'  => esc_html__('Ücretsiz kullanıcıların makale başına sorabileceği soru sayısı.', 'kanews'),
        'type'  => 'number',
        'default' => 5
      ),

      array(
        'id'    => 'kai-chat-premium-limit',
        'title'  => esc_html__('Premium Kullanıcı Limiti', 'kanews'),
        'desc'  => esc_html__('Premium kullanıcıların makale başına sorabileceği soru sayısı.', 'kanews'),
        'type'  => 'number',
        'default' => 20
      ),


		)
	) );
  
	/**
	 * PWA
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'PWA', 'kanews' ),
		'icon'        => 'fas fa-shield-alt',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'desc'    => '',
        'content' => esc_html__('Progressive Web Apps', 'kanews'),
      ),
      array(
        'id'    => 'pwa-status',
        'title'  => esc_html__('Progressive Web Apps Oluştur', 'kanews'),
        'desc'  => esc_html__('PWA, web sitelerinin mobil cihazlarda native olarak uygulama gibi kullanılmasını sağlayan bir teknolojidir.', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),

      array(
        'id'    => 'pwa-name',
        'type'  => 'text',
        'default' => KAN_THEME_NAME,
        'title' => __('Uygulama Adı', 'kanews'),
      ),
      
      array(
        'id'    => 'pwa-short-name',
        'type'  => 'text',
        'default'  => KAN_THEME_NAME,
        'title' => __('Uygulama Kısa Adı', 'kanews'),
      ),
      array(
        'id'    => 'pwa-description',
        'type'  => 'text',
        'title' => __('Uygulama Açıklaması', 'kanews'),
      ),
      array(
        'id'    => 'pwa-starturl',
        'title'  => esc_html__('Uygulama Başlangıç Sayfası', 'kanews'),
        'default'    => home_url( '/?utm_source=homescreen&utm_medium=shortcut'),
        'type'    => 'text',
      ),

      array(
        'id'      => 'pwa-display',
        'type'    => 'select',
        'title'   => esc_html__('Kullanıcı Arayüzü', 'kanews'),
        'options' => array(
          'fullscreen' => esc_html__('Tam Ekran', 'kanews'),
          'standalone' => esc_html__('Standalone', 'kanews'),
          'minimal-ui' => esc_html__('Minimal UI', 'kanews')
        ),
        'default' => 'fullscreen'
      ),

      array(
        'id'      => 'pwa-theme-color',
        'type'    => 'color',
        'title'   => esc_html__('Tema Rengi', 'kanews')
      ),

      array(
        'id'      => 'pwa-bg-color',
        'type'    => 'color',
        'title'   => esc_html__('Arka Plan Rengi', 'kanews')
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Hızlı Linkler', 'kanews'),
      ),
      array(
        'id'    => 'pwa-shortcut',
        'title'  => esc_html__('Hızlı Linkleri Göster', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'     => 'pwa-shortcuts',
        'type'   => 'group',
        'dependency' => array( 'pwa-shortcut', '==', 'true' ),
        'title'  => esc_html__('Hızlı Link Oluştur', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'    => 'title',
            'type'  => 'text',
            'title' => __('Adı', 'kanews'),
          ),
          array(
            'id'     => 'icon',
            'type'   => 'upload',
            'title'  => esc_html__('İkon', 'kanews').' (192x192px)',
            'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
          ),
          array(
            'id'       => 'url',
            'type'     => 'text',
            'title'    => 'URL',
            'validate' => 'csf_validate_url',
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Ekran Görüntüleri', 'kanews'),
      ),

      array(
        'id'    => 'pwa-screenshot',
        'title'  => esc_html__('Ekran Görüntüleri', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      array(
        'id'     => 'pwa-screenshots',
        'desc'   => esc_html__( 'Uygulama mağazalarında ekran görüntüsü olarak gösterilir.', 'kanews' ),
        'type'   => 'group',
        'dependency' => array( 'pwa-screenshot', '==', 'true' ),
        'title'  => esc_html__('Ekran Görüntüleri', 'kanews'),
        'button_title'  => esc_html__('Yeni Ekle', 'kanews'),
        'fields' => array(
          array(
            'id'     => 'image',
            'type'   => 'upload',
            'title'  => esc_html__('Görsel', 'kanews').' (192x192px)',
            'desc'   => 'Önerilen Boyutlar: 540x720px - 586x1041px - 1280x720px (Png formatında olması gerekir)',
          ),
          array(
            'id'      => 'size',
            'type'    => 'select',
            'title'   => esc_html__('Boyut', 'kanews'),
            'options' => array(
              '540x720' => '540x720px',
              '586x1041' => '586x1041px',
              '1280x720' => '1280x720px',
            ),
            'default' => '540x720'
          ),
        ),
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Uygulama İkonu', 'kanews'),
      ),

      array(
        'id'     => 'pwa-icon-48',
        'type'   => 'upload',
        'title'  => esc_html__('İkon', 'kanews').' (48x48px)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-72',
        'type'   => 'upload',
        'title'  => esc_html__('İkon', 'kanews').' (72x72px)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-96',
        'type'   => 'upload',
        'title'  => esc_html__('İkon', 'kanews').' (96x96px)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-128',
        'type'   => 'upload',
        'title'  => esc_html__('İkon', 'kanews').' (128x128px)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-192',
        'type'   => 'upload',
        'title'  => esc_html__('İkon', 'kanews').' (192x192px) (Gerekli)',
        'desc'   => 'Png formatında olmalı, oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),
      array(
        'id'     => 'pwa-icon-512',
        'type'   => 'upload',
        'title'  => esc_html__('İkon', 'kanews').' (512x512px)',
        'desc'   => 'Png formatında olmalı, açılış ekranında gösterilir. Oluşturmak için <a target="_blank" href="https://maskable.app/editor">tıklayın.</a>',
      ),

      array(
        'type'    => 'subheading',
        'content' => esc_html__('Popup', 'kanews'),
      ),

      array(
        'id'    => 'pwa-btn',
        'title'  => esc_html__('Durum', 'kanews'),
        'desc'  => esc_html__('Siteye girenlere uygulama yükle popup\'ı gösterir.', 'kanews'),
        'type'  => 'switcher',
        'default' => false
      ),
      
      array(
        'id'    => 'pwa-install-app-text',
        'dependency' => array( 'pwa-btn', '==', 'true' ),
        'title'  => esc_html__('Açıklama', 'kanews'),
        'type'    => 'text',
      ),
      array(
        'id'       => 'pwa-popup-delay',
        
        'type'     => 'slider',
        'dependency' => array( 'pwa-btn', '==', 'true' ),
        'title'    => esc_html__('Gecikme Süresi (sn)', 'kanews'),
        'min'      => 1,
        'max'      => 100,
        'step'     => 1,
        'default'  => 5,
      ),  
      array(
        'id'       => 'pwa-popup-expired',
        'type'     => 'slider',
        'dependency' => array( 'pwa-btn', '==', 'true' ),
        'title'    => esc_html__('Cookie Geçerlilik Süresi (gün)', 'kanews'),
        'desc'    => esc_html__('Çarpı butonuna basıldıktan kaç gün sonra tekrar gözükeceğini belirleyin.', 'kanews'),
        'min'      => 1,
        'max'      => 365,
        'step'     => 1,
        'default'  => 7,
      ),  
		)
	) );

	/**
	 * Backup
	 */
	CSF::createSection( $prefix, array(
		'title'       => esc_html__( 'İçe Aktar / Dışa Aktar', 'kanews' ),
		'icon'        => 'fas fa-shield-alt',
		'fields'      => array(
      array(
        'type'    => 'heading',
        'content' => esc_html__('İçe Aktar / Dışa Aktar', 'kanews'),
      ),
      array(
        'type'    => 'content',
        'title' => esc_html__('Hazır Tema Ayarları', 'kanews'),
        'content' => '
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/genel/options.txt" class="button button-hero button-secondary">Genel Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/spor/options.txt" class="button button-hero button-secondary">Spor Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/kripto/options.txt" class="button button-hero button-secondary">Kripto Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/blog/options.txt" class="button button-hero button-secondary">Blog Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/firma/options.txt" class="button button-hero button-secondary">Firma Rehberi Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/finans/options.txt" class="button button-hero button-secondary">Finans Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/world/options.txt" class="button button-hero button-secondary">Global News Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/yerel/options.txt" class="button button-hero button-secondary">Yerel Demo</a>
        <a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/startups/options.txt" class="button button-hero button-secondary">Startups Demo</a>
        ',
      ),
			array(
				'type' => 'backup',
			),

		)
	) );


});
}

add_filter( 'csf_fa5', '__return_false' );


function kanews_get_terms_ilan_kategori() {
  $taxonomies = get_terms( array(
    'taxonomy' => 'ilan-kategori',
    'hide_empty' => true,
  ) );
  $return = array();
  if( !is_wp_error($taxonomies) ) {
    foreach($taxonomies as $taxonomy) {
      $return[$taxonomy->term_id] = $taxonomy->name;
    }
  }
  return $return;
}
function kanews_get_terms_ilan_tag() {
  $taxonomies = get_terms( array(
    'taxonomy' => 'ilan-etiket',
    'hide_empty' => true,
  ) );
  $return = array();
  if( !is_wp_error($taxonomies) ) {
    foreach($taxonomies as $taxonomy) {
      $return[$taxonomy->term_id] = $taxonomy->name;
    }
  }
  return $return;
}
function kanews_get_terms_firma_kategori() {
  $taxonomies = get_terms( array(
    'taxonomy' => 'kategori',
    'hide_empty' => true,
  ) );
  $return = array();
  if( !is_wp_error($taxonomies) ) {
    foreach($taxonomies as $taxonomy) {
      $return[$taxonomy->term_id] = $taxonomy->name;
    }
  }
  return $return;
}

function get_currencies_arrays() {
  return array(
    'usd' => esc_html__('Dolar', 'kanews'),
    'euro' => esc_html__('Euro', 'kanews'),
    'chf' => esc_html__('İsviçre Frangı', 'kanews'),
    'jpy' => esc_html__('Japon Yeni', 'kanews'),
    'rub' => esc_html__('Rus Rublesi', 'kanews'),
    'rub' => esc_html__('Rus Rublesi', 'kanews'),
    'cny' => esc_html__('Çin Yuanı', 'kanews'),
    'gbp' => esc_html__('İngiliz Sterlini', 'kanews'),
    'eur-usd' => esc_html__('Euro/Dolar', 'kanews'),
    'ise-100' => esc_html__('Bist 100', 'kanews'),
    'ukoil' => esc_html__('Petrol', 'kanews'),
    'gau' => esc_html__('Gram Altın', 'kanews'),
    'btc' => esc_html__('Bitcoin', 'kanews'),
    'eth' => esc_html__('Ethereum', 'kanews'),
    'bch' => esc_html__('Bitcoin Cash', 'kanews'),
    'xrp' => esc_html__('XRP', 'kanews'),
    'ltc' => esc_html__('Litecoin', 'kanews'),
    'bnb' => esc_html__('Binance Coin', 'kanews'),
    'sol' => esc_html__('Solana', 'kanews'),
    'avax' => esc_html__('Avalanche', 'kanews'),
    'ada' => esc_html__('Cardano', 'kanews'),
    'dot' => esc_html__('Polkadot', 'kanews'),
    'doge' => esc_html__('Doge Coin', 'kanews'),
    'shib' => esc_html__('Shiba Inu', 'kanews')
  );
}
