<?php 

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

/*-----------------------------------------------------------------------------------*/
# Review Notice
/*-----------------------------------------------------------------------------------*/
add_action( 'admin_notices', 'kanews_review_admin_notice' );
function kanews_review_admin_notice() {
	if( ! get_option( 'kanews-admin-notice-5' ) ) :
		?>
		<div id="kanews_review_notice" data-security="9ef059d3fc" class="notice notice-info is-dismissible">
			<h3 style="font-size: 2em;color: #fff">Kanews WordPress Haber Temasını Değerlendirmek İster Misin?
			</h3>

			<p>
				<a href="https://www.kanthemes.com/urun/kanews-wordpress-haber-temasi/?utm_source=wp-admin&utm_medium=banner&utm_campaign=reviews#reviews" class="button" target="_blank" rel="noopener noreferrer"><strong>Değerlendirme Yap</strong></a>
				<a href="<?php echo add_query_arg( 'kanews_disable_review_notice', true, admin_url() ); ?>" class="kanews-dismiss-pro-notice kanews-already-upgraded-action">Bir daha gösterme.</a>

			</p><br>
			<small>Her müşteri 1 kez yararlanabilir, değerlendirme onaya tabidir. Kazanımlar için iletişime geçiniz. Kampanya ve kupon geçerlilik tarihi 15.05.2024 - 31.08.2024</small>
		</div>
		<?php 
	endif;
}

add_action( 'admin_init', 'kanews_review_admin_notice_disable' );
function kanews_review_admin_notice_disable() {
	$clear = isset( $_GET['kanews_disable_review_notice'] ) ? $_GET['kanews_disable_review_notice'] : false;
	if ( $clear && current_user_can( 'manage_options' ) ) {
		update_option('kanews-admin-notice-5', true);
	}
}

/*-----------------------------------------------------------------------------------*/
# Review Notice
/*-----------------------------------------------------------------------------------*/

function kanews_update_check2() {
	$updates = get_option('puc_external_updates_theme-kanews') ? get_option('puc_external_updates_theme-kanews') : null;
	
	if($updates != null) {
		if (isset( $updates->update->version ) && version_compare( $updates->update->version, KAN_THEME_VER, '>' ))
		return true;
	}
	
	return false;
}

/*-----------------------------------------------------------------------------------*/
# Create Admin Menu
/*-----------------------------------------------------------------------------------*/
add_action( 'admin_menu', 'kanews_admin_menu' );
if ( ! function_exists( 'kanews_admin_menu' ) ) {
	function kanews_admin_menu() {
		
		if(kanews_update_check2()) {
			$title = 'Kanews <span class="update-plugins count-1"><span class="plugin-count">1</span></span>';
			$title2 = __('Güncellemeler', 'kanews').' <span class="update-plugins count-1"><span class="plugin-count">1</span></span>';
		}
		else {
			$title = 'Kanews';
			$title2 = __('Güncellemeler', 'kanews');
		}

		$options = '';
		// $options = '<span class="update-plugins count-1"><span class="plugin-count">2</span></span>';
		$plugins = '';
		add_menu_page( __('Tema Ayarları', 'kanews'), $title, 'manage_options', 'kanews-options', 'kanews_theme_options_page', ''.get_template_directory_uri().'/assets/img/kanthemes_favicon.png', 60  );
		add_submenu_page('kanews-options', __('Tema Ayarları', 'kanews'), __('Tema Ayarları', 'kanews').$options, 'manage_options', 'kanews-options', 'kanews_theme_options_page' );
		add_submenu_page('kanews-options', __('Kanews Temasına Hoşgeldiniz', 'kanews'), __('Başlangıç', 'kanews'), 'manage_options', 'kanews-welcome', 'kanews_welcome_page' );
		add_submenu_page('kanews-options', __('Güncellemeler', 'kanews'), $title2, 'manage_options', 'kanews-update', 'kanews_updates_page' );
		add_submenu_page('kanews-options', __('Demo Aktarıcı', 'kanews'), __('Demo Aktarıcı', 'kanews'), 'manage_options', 'kanews-import', 'kanews_demo_importer_page' );
		add_submenu_page('kanews-options', __('Uyumlu Eklentiler', 'kanews'), __('Uyumlu Eklentiler', 'kanews').$plugins, 'manage_options', 'kanews-plugins', 'kanews_compaitable_plugins' );
		add_submenu_page('kanews-options', __('Güncelleme Hakkında', 'kanews'), __('Güncelleme Hakkında', 'kanews'), 'manage_options', 'kanews-about-update', 'kanews_about_update_page' );
	}
}

// Add Item For Admin Bar
function kanews_admin_bar_add_item($admin_bar)  {
	$args = array(
		'id'        => 'kanews-theme-admin-bar', // Must be a unique name
		'title'     => '<img src="'.get_template_directory_uri().'/assets/img/kanthemes_favicon.png" width="12" height="12" style="width:18px!important;height:18px!important;vertical-align:-4px;margin-right:8px;"/>'.__('Kanews Ayarları', 'kanews'), // Label for this item
		'href'      => get_admin_url() . 'admin.php?page=kanews-options',
	);
	$admin_bar->add_menu( $args);
	
	if(kanews_update_check2() == true) {
		$adminURL = get_admin_url() . 'themes.php';
		$admin_bar->add_menu( array(
			'id'    => 'update_notifier',
			'title' => sprintf( __( '%s Güncellemesi Hazır', 'kanews' ), KAN_THEME_NAME ) . ' <span id="ab-updates">1</span>',
			'href'  => $adminURL
		) );
	}
}
add_action('admin_bar_menu', 'kanews_admin_bar_add_item', 900);

/*-----------------------------------------------------------------------------------*/
# Page Tabs 2
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_admin_tab_2' ) ) {
	function kanews_admin_tab_2($aktif1, $aktif2, $aktif3, $aktif4, $aktif5, $aktif6 = null	) { ?>
		<nav class="kan__header-navigation nav-tab-wrapper wp-clearfix" aria-label="İkincil menü">
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-welcome" class="nav-tab <?php echo $aktif1; ?>"><?php _e('Başlangıç', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-options" class="nav-tab <?php echo $aktif2; ?>"><?php _e('Tema Ayarları', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-license" class="nav-tab <?php echo $aktif3; ?>"><?php _e('Lisans Doğrulama', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-update" class="nav-tab <?php echo $aktif4; ?>"><?php _e('Güncellemeler', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-import" class="nav-tab <?php echo $aktif5; ?>"><?php _e('Demo Aktarıcı', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-plugins" class="nav-tab <?php echo $aktif6; ?>"><?php _e('Uyumlu Eklentiler', 'kanews'); ?></a>
		</nav>
		<?php if(kanews_update_check2() == true) : ?>
			<br>
			<div class="kan-update-alert">

				<?php
				$updates = get_option('puc_external_updates_theme-kanews') ? get_option('puc_external_updates_theme-kanews') : null;
				printf( __('<strong>%1$s</strong> temasının %2$s sürümü kurulu. <strong>%3$s</strong> sürümüne yükseltebilirsiniz. <a class="button" href="%4$s">Güncellemek için tıklayın.</a>', 'kanews'),
					KAN_THEME_NAME,
					KAN_THEME_VER,
					$updates->update->version,
					admin_url().'themes.php'
				);
				?>

			</div>
		<?php endif; ?>
	<?php }
}
/*-----------------------------------------------------------------------------------*/
# Page Tabs
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_admin_tab' ) ) {
	function kanews_admin_tab($aktif1, $aktif2, $aktif3, $aktif4, $aktif5) { ?>
		<h2 class="nav-tab-wrapper kanews-nav-tab-wrapper wp-clearfix">
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-welcome" class="nav-tab <?php echo $aktif1; ?>"><?php _e('Başlangıç', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-options" class="nav-tab <?php echo $aktif2; ?>"><?php _e('Tema Ayarları', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-license" class="nav-tab <?php echo $aktif3; ?>"><?php _e('Lisans Doğrulama', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-update" class="nav-tab <?php echo $aktif4; ?>"><?php _e('Güncellemeler', 'kanews'); ?></a>
			<a href="<?php echo admin_url(); ?>admin.php?page=kanews-import" class="nav-tab <?php echo $aktif5; ?>"><?php _e('Demo Aktarıcı', 'kanews'); ?></a>
			<a target="_blank" href="https://www.kanthemes.com/tema/kanews/" class="nav-tab"><?php _e('Destek Masası', 'kanews'); ?></a>
		</h2>
		<?php if(kanews_update_check2() == true) : ?>
			<br>
			<div class="update-nag notice notice-success inline">

				<?php
				$updates = get_option('puc_external_updates_theme-kanews') ? get_option('puc_external_updates_theme-kanews') : null;
				printf( __('<strong>%1$s</strong> temasının %2$s sürümü kurulu. <strong>%3$s</strong> sürümüne yükseltebilirsiniz.<br><br> <a class="button" href="%4$s">Güncellemek için tıklayın.</a>', 'kanews'),
					KAN_THEME_NAME,
					KAN_THEME_VER,
					$updates->update->version,
					admin_url().'themes.php'
				);
				?>

			</div>
		<?php endif; ?>
	<?php }
}

/*-----------------------------------------------------------------------------------*/
# Page: Theme Options
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_theme_options_page' ) ) {
	function kanews_theme_options_page(){ 
		?>
		<div class="wrap kan__container kanews-wrap">

			<div class="kan__header">

				<div class="kan__header-container">
					<div class="kan__header-title">
						<p>
						<?php 
						printf( 'Kanews %1$s',
						KAN_THEME_VER
						);
						?>
						</p>
					</div>

					<div class="kan__header-text"><?php _e('Kanews temasını kendi zevkinize göre şekilendirmeye hemen başlayabilirsiniz.', 'kanews'); ?></div>
				</div>
				<?php kanews_admin_tab_2(null, 'nav-tab-active', null, null, null); ?>

			</div>
		</div>
	<?php 
	}
}

/*-----------------------------------------------------------------------------------*/
# Page: Theme Translate
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_theme_translate_page' ) ) {
	function kanews_theme_translate_page(){ 
		?>
		<div class="wrap kan__container kanews-wrap">

			<div class="kan__header">

				<div class="kan__header-container">
					<div class="kan__header-title">
						<p>
						<?php 
						printf( 'Kanews %1$s',
						KAN_THEME_VER
						);
						?>
						</p>
					</div>

					<div class="kan__header-text"><?php _e('Kanews temasını kendi zevkinize göre şekilendirmeye hemen başlayabilirsiniz.', 'kanews'); ?></div>
				</div>
				<?php kanews_admin_tab_2(null, 'nav-tab-active', null, null, null); ?>
			</div>
		</div>
	<?php 
	}
}

/*-----------------------------------------------------------------------------------*/
# Page: Welcome
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_welcome_page' ) ) {
	function kanews_welcome_page(){
		?>
		<div class="wrap kan__container kanews-wrap">

			<div class="kan__header">

			<div class="kan__header-container">
				<div class="kan__header-title">
					<p>
					<?php 
					printf( 'Kanews %1$s',
					KAN_THEME_VER
					);
					?>
					</p>
				</div>

				<div class="kan__header-text"><?php _e('Kanews Wordpress temasını tercih ettiğiniz için teşekkür ederiz.', 'kanews'); ?></div>
			</div>
			<?php kanews_admin_tab_2('nav-tab-active', null, null, null, null); ?>
			
		</div>

		<div class="kan__section is-feature">
			<h1 class="aligncenter">
				<?php 
				printf( __('Kanews %1$s sürümüne hoşgeldiniz.', 'kanews'),
				KAN_THEME_VER
				);
				?>
			</h1>
			<p><?php esc_html_e('Kanews Wordpress temasını tercih ettiğiniz için teşekkür ederiz, Kanews wordpress teması başarıyla kuruldu ve kullanımınıza hazır durumda!', 'kanews'); ?></p>
		</div>

		<div class="kanews_admin_content">
			<div class="kan__section has-3-columns has-gutters" style="background:transparent">
				<div class="column has-border" style="background-color:#eeeadd;background-color:var(--global--color-yellow)">
					<h3><?php esc_html_e( 'Kurulum & Yapılandırma', 'kanews' ); ?></h3>
					<ul>
						<li><a href="<?php echo admin_url('admin.php?page=kanews-import'); ?>" class="welcome-icon welcome-edit-page"><?php _e('Demo İçeriği İçe Aktar', 'kanews'); ?></a></li>
						<li><a href="<?php echo admin_url('nav-menus.php'); ?>" class="welcome-icon welcome-edit-page"><?php _e('Menü Ayarlarını yap', 'kanews'); ?></a></li>
						<li><a href="<?php echo admin_url('admin.php?page=kanews-options');?>" class="welcome-icon welcome-edit-page"><?php _e('Tema Ayarlarını Yap', 'kanews'); ?></a></li>
						<li><a href="<?php echo admin_url('widgets.php');?>" class="welcome-icon welcome-edit-page"><?php _e('Bileşenleri Ayarla', 'kanews'); ?></a></li>
						<li><a href="<?php echo admin_url('admin.php?page=kanews-options#tab=cron-job');?>" class="welcome-icon welcome-edit-page"><?php _e('Cron Job Ayarla', 'kanews'); ?></a></li>
						<li><a href="<?php echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin=regenerate-thumbnails&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="welcome-icon welcome-edit-page"><?php _e('Öne Çıkan Görselleri Boyutlandır', 'kanews'); ?></a></li>
					</ul>
				</div>
				<div class="column has-border" style="background-color:#e4d1d1;background-color:var(--global--color-red)">
					<h3><?php esc_html_e( 'Hızlı Erişim', 'kanews' ); ?></h3>
					<ul>
						<li><a target="_blank" href="https://www.kanthemes.com/tema/kanews/guncellemeler/" class="welcome-icon welcome-add-page"><?php _e('Güncelleme Notları', 'kanews'); ?></a></li>
						<li><a target="_blank" href="https://www.kanthemes.com/tema/kanews/" class="welcome-icon welcome-add-page"><?php _e('Destek Masası', 'kanews'); ?></a></li>																				
						<li><a target="_blank" href="https://www.kanthemes.com/tema/kanews/dokumantasyon/" class="welcome-icon welcome-add-page"><?php _e('Çevrimiçi Dökümantasyon', 'kanews'); ?></a></li>																				
						<li><a target="_blank" href="https://www.kanthemes.com/iletisim/" class="welcome-icon welcome-add-page"><?php _e('İletişim', 'kanews'); ?></a></li>
						<li><a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/kanews-child.zip" class="welcome-icon welcome-add-page"><?php _e('Child Temayı İndir', 'kanews'); ?></a></li>
					</ul>
				</div>
				<div class="column has-border" style="background-color:#d1d1e4;background-color:var(--global--color-purple)">
					<h3><?php esc_html_e( 'Destek', 'kanews' ); ?></h3>
					<br>
					<a class="button button-primary" href="https://www.kanthemes.com/destek/"><?php _e('Destek Talebi Oluştur', 'kanews'); ?></a>
					<a class="button button-secondary" href="https://www.kanthemes.com/tema/kanews/dokumantasyon/"><?php _e('Çevrimiçi Dökümantasyon', 'kanews'); ?></a>
							
				</div>
			</div>
		</div>
		<br>
		<br>
		<hr class="is-large">
		<br>
		<br>
		<div class="kan__section has-2-columns" style="background:transparent;">
			<!-- <h2 class="is-section-header">Geliştiriciler için</h2> -->
			<div class="column">
				<h3>Bizden Haberler</h3>
			<iframe class="item-demo-iframe" frameborder="0" noresize="noresize" src="//kanthemes.com.tr/files/kanews/duyuru.html"></iframe>	</div>
			<div class="column">
				<h3>Yararlı Blog Yazıları</h3>
				<iframe class="item-demo-iframe" frameborder="0" noresize="noresize" src="//kanthemes.com.tr/files/blog.html"></iframe>
					
				</div>
		</div>
		<br>
		<a style="margin-bottom:20px" href="https://bit.ly/34PKAWt" class="button">Tüm Yazılarımız</a>
		<a href="https://twitter.com/share?ref_src=twsrc%5Etfw" class="twitter-share-button" data-size="large" data-text="Kanews Wordpress temasını siteme kurdum, sizede tavsiye ederim." data-url="https://www.kanthemes.com/tanitim/kanews/" data-via="kanthemes" data-hashtags="kanewswptheme" data-show-count="false">Tweet</a><script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
			

	</div>

		<?php
	}
}

/*-----------------------------------------------------------------------------------*/
# Page: Updates
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_updates_page' ) ) {
	function kanews_updates_page(){
		?>
		<div class="wrap kan__container kanews-wrap">

			<div class="kan__header">
				<div class="kan__header-container">
					<div class="kan__header-title">
						<p>
						<?php 
						printf( 'Kanews %1$s',
						KAN_THEME_VER
						);
						?>
						</p>
					</div>

					<div class="kan__header-text"><?php _e('Kanews\'in en son yayınlanan güncellemesini buradan indirip yükleyebilirsiniz.', 'kanews'); ?></div>
				</div>
				<?php kanews_admin_tab_2(null, null, null, 'nav-tab-active', null); ?>
			</div>

			<div class="kan__section is-feature">
				<h1 class="aligncenter">
					<?php esc_html_e( 'Kanews Güncellemeleri', 'kanews' ); ?>
				</h1>
				<p><?php esc_html_e( 'Kanews temasını güncellemenin iki farklı yolu mevcuttur birincisi wordpress admin paneli üzerinden otomatik güncelllemek ikincisi ise manuel olarak güncellemek.', 'kanews' ); ?></p>
				<br>
				
				<h1 class="">
				<?php echo sprintf(esc_html__( 'Yöntem %s', 'kanews' ), '1'); ?>
				</h1>
				<div class="kan__section has-2-columns">
					<div class="column">
						<div class="kan-circle">1</div>
						<h2 class="is-smaller-heading"><?php esc_html_e( 'Günncelleme Anahtarını Gir', 'kanews' ); ?></h2>
						<p style="font-weight:400;font-size:18px;">
						<?php echo sprintf( esc_html__('%1$sHesabım/Siparişler%2$s sayfasından güncelleme anahtarınızı alın ve aşağıdaki alana ekleyin.', 'kanews'),
							'<a href="https://www.kanthemes.com/hesabim/siparisler/" target="_blank">',
							'</a>'
						); ?>
						</p>
						<br><?php 
							
							if(isset($_POST['theme_update_auth'])){
								update_option('kanews_order_auth', $_POST['order_auth']);
							} 
							$auth = get_option('kanews_order_auth') ? get_option('kanews_order_auth') : '';
						?>
						<form method="post" action="<?php echo admin_url('admin.php?page=kanews-update'); ?>">
							<input class="widefat" type="text" name="order_auth" value="<?php echo $auth; ?>"  required />
							<input type="hidden" name="theme_update_auth" value="update" />
							<?php submit_button('Anahtarı Kaydet', 'kanews'); ?>
						</form>
					</div>
					<div class="column">
						<div class="kan-circle">2</div>
						<h2 class="is-smaller-heading"><?php esc_html__( 'Temayı Otomatik Güncelle', 'kanews' ); ?></h2>
						
						<p style="font-weight:400;font-size:18px;">
						<?php echo sprintf( __('%1$sGörünüm>Temalar%2$s sayfasına gidin ve Kanews temasının üstünde yer alan <strong>Hemen Güncelle</strong> linkine tıklayarak güncellemeyi gerçekleştirin hepsi bu kadar.', 'kanews'),
							'<a class="color-primary" href="'.admin_url('themes.php').'" target="_blank">',
							'</a>'
						); ?>
						</p>
						<br><a class="button button-primary" href="<?php echo admin_url('themes.php'); ?>" target="_blank"><?php esc_html_e( 'Güncellemeyi Yap', 'kanews' ); ?></a>
						<a class="button" href="<?php echo admin_url('update-core.php?force-check=1'); ?>" target="_blank"><?php esc_html_e( 'Güncellemeleri Kontrol Et', 'kanews' ); ?></a>
					</div>
				</div>
				<hr class="is-large">
				<h1 class="">
					<?php echo sprintf(esc_html__( 'Yöntem %s', 'kanews' ), '2'); ?>
				</h1>
				<div class="kan__section has-4-columns">
					<div class="column">
						<div class="kan-circle">1</div>
						<h2 class="is-smaller-heading">kanthemes.com</h2>
						<p style="font-weight:400;font-size:18px;">
						<?php echo sprintf( __('Kan Themes üzerinden %1$sHesabım/İndirmeler%2$s sayfasına gidin.', 'kanews'),
							'<a href="https://www.kanthemes.com/hesabim/indirmeler/" target="_blank">',
							'</a>'
						); ?>
					</p>
					</div>
					<div class="column">
					<div class="kan-circle">2</div>
						<h2 class="is-smaller-heading"><?php esc_html_e( 'Dosyayı İndir', 'kanews' ); ?></h2>
						<p style="font-weight:400;font-size:18px;"><?php esc_html_e( 'İndirme sütununda bulunan indirme linkine tıklayarak tema dosyalarını indirin.', 'kanews' ); ?></p>
					</div>
					<div class="column">
					<div class="kan-circle">3</div>
						<h2 class="is-smaller-heading"><?php esc_html_e( 'Güncellemeyi Yükle', 'kanews' ); ?></h2>
						<p style="font-weight:400;font-size:18px;">
						<?php echo sprintf( __('%1$sTemalar%2$s sayfasına giderek <strong>Tema Yükle</strong> butonuna tıklayın, ardından <strong>Dosya Seç</strong> butonuna tıklayın. Açılan ekranda indirdiğiniz <strong>kanews.zip</strong> dosyasını bulun, seçin ve <strong>Şimdi Kur</strong> butonuna tıklayarak kurun.', 'kanews'),
							'<a href="'.admin_url('theme-install.php?browse=featured').'" target="_blank">',
							'</a>'
						); ?>
						</p>
					</div>
					<div class="column">
					<div class="kan-circle">4</div>
						<h2 class="is-smaller-heading"><?php esc_html_e( 'Güncellemeyi Kur', 'kanews' ); ?></h2>
						<p style="font-weight:400;font-size:18px;"><?php _e('Güncellemenin yüklenmesi için bir müddet bekledikten sonra ekranda beliren <strong>Mevcut olanı yüklenen ile değiştir</strong> butonuna tıklayın ve güncelleme işlemini tamamlayın.', 'kanews'); ?></p>
					</div>
				</div>
				<hr class="is-large">
				<div class="kan__section has-1-column">
					<div class="column">
						<a href="https://www.kanthemes.com/tema/kanews/guncellemeler/" target="_blank" class="button"><?php esc_html_e( 'Güncelleme Notları', 'kanews' ); ?></a>
						<a href="https://youtu.be/aFQyg40gihM" target="_blank" class="button button-primary"><?php esc_html_e( 'Güncelleme Nasıl Yapılır?', 'kanews' ); ?></a>
					</div>
				</div>
				<hr class="is-large">
				<div class="kan__section has-1-column">
					<div class="column">
						<a href="https://www.kanthemes.com/destek/" target="_blank" class="button button-hero button-primary"><?php esc_html_e( 'Güncelleme Önerisinde Bulun', 'kanews' ); ?></a>
					</div>
				</div>

			</div>
			<div class="kan__section changelog">
			<div class="column has-border has-subtle-background-color">
				<h2 class="is-smaller-heading"><?php esc_html_e( 'Güncelleme Notları', 'kanews' ); ?></h2>
				<p><strong>3.6 sürümü</strong> yayınlandı.
				Daha fazla bilgi için <a href="https://www.kanthemes.com/tema/kanews/guncellemeler/#v3_6">dağıtım notlarına</a> bakın.</p>
				<p><strong>3.5 sürümü</strong> yayınlandı.
				Daha fazla bilgi için <a href="https://www.kanthemes.com/tema/kanews/guncellemeler/#v3_5">dağıtım notlarına</a> bakın.</p>
				<p><strong>3.4 sürümü</strong> yayınlandı.
				Daha fazla bilgi için <a href="https://www.kanthemes.com/tema/kanews/guncellemeler/#v3_4">dağıtım notlarına</a> bakın.</p>
				<p><strong>3.3 sürümü</strong> yayınlandı.
				Daha fazla bilgi için <a href="https://www.kanthemes.com/tema/kanews/guncellemeler/#v3_3">dağıtım notlarına</a> bakın.</p>
				<p><strong>3.2 sürümü</strong> yayınlandı.
				Daha fazla bilgi için <a href="https://www.kanthemes.com/tema/kanews/guncellemeler/#v3_2">dağıtım notlarına</a> bakın.</p>
				<p><strong>3.1 sürümü</strong> yayınlandı.
				Daha fazla bilgi için <a href="https://www.kanthemes.com/tema/kanews/guncellemeler/#v3_1">dağıtım notlarına</a> bakın.</p>
				<p><strong>3.0 sürümü</strong> yayınlandı.
				Daha fazla bilgi için <a href="https://www.kanthemes.com/tema/kanews/guncellemeler/#v3">dağıtım notlarına</a> bakın.</p>
			</div>
		</div>
		</div>
		<?php
	}
}

/*-----------------------------------------------------------------------------------*/
# Page: Demo Importer
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_compaitable_plugins' ) ) {
	function kanews_compaitable_plugins(){ ?>
	<div class="wrap s-wrap">
		<h2><?php _e('Uyumlu Eklentiler', 'kanews'); ?></h2>
	<p><?php esc_html_e( 'Bu eklentilerin kurulması zorunlu değildir, ihtiyacınıza göre tam uyumluluk gösteren bu eklentileri kullanabilirsiniz.', 'kanews' ); ?></p><br>
				<table class="wp-list-table widefat fixed">
					<thead>
						<tr>
							<th scope="col" id="plugin" class="manage-column column-plugin column-primary"><?php _e('Plugin'); ?></th>
							<th scope="col" id="tur" class="manage-column column-tur"><?php _e('Type'); ?></th>
							<th scope="col" id="status" class="manage-column column-status"><?php _e('Status'); ?></th>
						</tr>
					</thead>
					<tbody id="one-list">
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php echo admin_url('themes.php?page=tgmpa-install-plugins'); ?>" class="thickbox">
								Kanews Hikayeler</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php echo admin_url('themes.php?page=tgmpa-install-plugins'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'amp'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								AMP</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Seo', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'amp'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'litespeed-cache'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Litespeed Cache</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Hız', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'litespeed-cache'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'seo-by-rank-math'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Rank Math – SEO Plugin for WordPress</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Seo', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'seo-by-rank-math'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'wordpress-seo'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Wordpress Seo by Yoast</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Seo', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'wordpress-seo'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'contact-form-7'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Contact Form 7</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('İletişim', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'contact-form-7'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'wp-smushit'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="thickbox">
								Smush</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Optimizasyon', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'wp-smushit'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'table-of-contents-plus'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Table of Contents Plus</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'table-of-contents-plus'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'nextend-facebook-connect'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Nextend Social Login</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'nextend-facebook-connect'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'google-captcha'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Google Captcha (reCAPTCHA)</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Güvenlik', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'google-captcha'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'simple-cloudflare-turnstile'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Simple Cloudflare Turnstile</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Güvenlik', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'simple-cloudflare-turnstile'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'post-views-counter'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Post Views Counter</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'post-views-counter'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
						<tr>
							<td class="plugin column-plugin has-row-actions column-primary" data-colname="Plugin">
								<strong><a target="_blank" href="<?php $plugin = 'co-authors-plus'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&TB_iframe=true&width=600&height=550'); ?>" class="thickbox">
								Co-Authors Plus</a></strong>
							</td>
							<td class="source column-tur" data-colname="Tur"><?php _e('Özelleştirme', 'kanews'); ?></td>
							<td class="source column-status" data-colname="status">
								<a target="_blank" class="install-now button" href="<?php $plugin = 'co-authors-plus'; echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin='.$plugin.'&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>"><?php _e('Hemen yükle', 'kanews'); ?></a>
							</td>
						</tr>
					</tbody>
				</table>
				</div>
	<?php }
}

/*-----------------------------------------------------------------------------------*/
# Page: Demo Importer
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'kanews_demo_importer_page' ) ) {
	function kanews_demo_importer_page(){ ?>
		<div class="wrap kan__container kanews-wrap">

			<div class="kan__header">
				<div class="kan__header-container">
					<div class="kan__header-title">
						<p>
						<?php 
						printf( 'Kanews %1$s',
						KAN_THEME_VER
						);
						?>
						</p>
					</div>

					<div class="kan__header-text"><?php _e('Önceden hazırlanmış demo ayarlarından birini sitenize hızlı bir şekilde uygulayabilirsiniz.', 'kanews'); ?></div>
				</div>
				<?php kanews_admin_tab_2(null, null, null, null, 'nav-tab-active'); ?>
			</div>
			<div class="kan__section is-feature">
				<h1 class="aligncenter"><?php esc_html_e( 'Kanews Demo Kurulum Sihirbazı', 'kanews' ); ?></h1>
			</div>
			<hr class="is-large">


			<div class="kan__section has-2-columns has-gutters">
				<div class="column aligncenter">
				<div class="kan-circle">1</div>
					<h2><?php esc_html_e( 'Woocommerce Kur (İsteğe Bağlı)', 'kanews' ); ?></h2>
					<p><?php _e('Ücretli abonelikler için Woocommerce eklentisini kur ve etkinleştir eğer ücretli abonelikleri aktifleştirmeyi düşünmüyorsanız bu adımı atlayabilirsiniz.', 'kanews'); ?></p>
					<br>
					<a target="_blank" href="<?php echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin=woocommerce&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="button button-hero"><?php _e('Woocommerce Kur', 'kanews'); ?></a>
				</div>
				<div class="column aligncenter">
					<div class="kan-circle">2</div>
					<h2><?php esc_html_e( 'Demo İçeriği İçe Aktar', 'kanews' ); ?></h2>
					<p><?php _e('İlk olarak <strong>One Click Demo Import</strong> eklentisini kurup etkinleştirin ardından <strong>Demo İçeriğini İçe Aktar</strong> butonuna tıklayarak kurmak istediğiniz demoyu seçip <strong>İmport</strong> butonuna tıklayın.', 'kanews'); ?></p>
					<br>
					<a target="_blank" href="<?php echo admin_url('plugin-install.php?tab=plugin-information&amp;plugin=one-click-demo-import&amp;TB_iframe=true&amp;width=640&amp;height=500'); ?>" class="button button-hero"><?php _e('Eklentiyi Kur ve Etkinleştir', 'kanews'); ?></a>
					<a target="_blank" href="<?php admin_url(); ?>themes.php?page=pt-one-click-demo-import" class="button button-primary button-hero"><?php _e('Demo İçeriği İçe Aktar', 'kanews'); ?></a>
				</div>
			</div>

			<hr class="is-large">
				<div class="kan__section has-1-column">
					<div class="column aligncenter">
						<p style="font-weight: 400"><?php _e('Eğer yapamadıysanız aşağıdaki <strong>"Öğretici Video"</strong> butonuna tıklayarak öğretici videoyu izleyin. Yine yapamadıysanız veya bir şeyler yanlış gidiyorsa <strong>"Destek Talebi"</strong> butonuna tıklayarak destek talebi oluşturun.', 'kanews'); ?></p>
						<br>
						<a href="https://docs.kanthemes.com/kanews/#/kurulum?id=demo-kurulumu-nas%c4%b1l-yap%c4%b1l%c4%b1r" target="_blank" class="button button-primary"><?php esc_html_e( 'Öğretici Video', 'kanews' ); ?></a>
						<a href="https://www.kanthemes.com/destek/" target="_blank" class="button"><?php esc_html_e( 'Destek Talebi Oluştur', 'kanews' ); ?></a>
					</div>
				</div>
		</div>
		
	<?php }
}

/*-----------------------------------------------------------------------------------*/
# Redirect after theme active
/*-----------------------------------------------------------------------------------*/
function kanews_theme_active_redirect_page() {
	global $pagenow;
	if ( 'themes.php' == $pagenow && isset( $_GET['activated'] ) ) {
		if ( function_exists('kanews__get__status') && kanews__get__status() ) {
			wp_redirect(admin_url("admin.php?page=kanews-welcome"));
		} else {
			wp_redirect(admin_url("admin.php?page=kanews-license"));
		}
	}
}
add_action('admin_init', 'kanews_theme_active_redirect_page');

/*-----------------------------------------------------------------------------------*/
# One Click Demo Import
/*-----------------------------------------------------------------------------------*/
add_filter( 'pt-ocdi/import_files', 'kanews_import_files' );
add_action( 'pt-ocdi/after_import', 'kdi_after_import_setup' );
add_action( 'pt-ocdi/before_widgets_import', 'kdi_reset_widgets' );

if ( ! function_exists( 'kanews_import_files' ) ) :
	function kanews_import_files() {
		
		if ( ! class_exists( 'wp_Knskea36' ) )
		return array();

		return array(
			array(
				'import_file_name'           => __('Haber', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/genel/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/genel/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo1.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/genel/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),
			array(
				'import_file_name'           => __('Yerel', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/yerel/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/yerel/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo2.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/yerel/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/yerel/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),

			array(
				'import_file_name'           => __('Startup', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/startups/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/startups/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo3.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/startups/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/startups/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),

			array(
				'import_file_name'           => __('Global News', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/world/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/world/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo4.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/world/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/world/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),

			array(
				'import_file_name'           => __('Spor', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/spor/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/spor/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo5.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/spor/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/spor/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),

			array(
				'import_file_name'           => __('Blog', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/blog/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/blog/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo6.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/blog/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/blog/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),

			array(
				'import_file_name'           => __('Kripto', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/kripto/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/kripto/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo7.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/kripto/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/kripto/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),
			
			array(
				'import_file_name'           => __('Firma Rehberi', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/firma/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/firma/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo9.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/firma-rehberi/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/firma/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),			
			array(
				'import_file_name'           => __('Finans', 'kanews'),
				'import_file_url'            => 'https://www.kanthemes.com.tr/files/kanews/demo/finans/wordpress.xml',
				'import_widget_file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/finans/widgets.wie',
				'import_preview_image_url'   => 'https://www.kanthemes.com/wp-content/themes/kanthemes/dist/img/land/kanews/demo8.jpg',
				'preview_url'                => 'https://demo.kanthemes.com.tr/kanews/finans/',
				'import_json'      => array(
					array(
						'file_url'     => 'https://www.kanthemes.com.tr/files/kanews/demo/finans/options.txt',
						'option_name'  => 'kanews_options',
					),
				)
			),
			
			
			
		);
	}
endif;

// Set Navigation Menus
function kdi_after_import_setup($selected_import) {
	$navbar   = get_term_by( 'name', 'Navbar', 'nav_menu' );
	$footer   = get_term_by( 'name', 'Footer', 'nav_menu' );
	$big_menu = get_term_by( 'name', 'Büyük Menü', 'nav_menu' );

	set_theme_mod( 'nav_menu_locations', array(
			'menu-1'   => $navbar->term_id,
			'menu-2'   => $navbar->term_id,
			'menu-3'   => $footer->term_id,
			'big-menu' => $big_menu->term_id,
		)
	);

	update_option( 'show_on_front', 'posts' );
}

// Reset Widgets
function kdi_reset_widgets(){
	update_option( 'sidebars_widgets', '' );
}

function ocdi_register_plugins( $plugins ) {
	
  $theme_plugins = [
    [ // A WordPress.org plugin repository example.
      'name'     => 'Woocommerce', // Name of the plugin.
      'slug'     => 'woocommerce', // Plugin slug - the same as on WordPress.org plugin repository.
      'required' => false,                     // If the plugin is required or not.
    ],
    [ // A WordPress.org plugin repository example.
      'name'     => 'Litespeed Cache', // Name of the plugin.
      'slug'     => 'litespeed-cache', // Plugin slug - the same as on WordPress.org plugin repository.
      'required' => false,  // If the plugin is required or not.
		],
		[
			'name'     => esc_html__( 'Kanews Hikayeler', 'kanews' ),
			'slug'     => 'kanews-stories',
			'source'   => get_template_directory_uri() . '/inc/plugins/kanews-stories.zip',
      'required' => false,
    ]
  ];

	
  return array_merge( $plugins, $theme_plugins );
}
add_filter( 'ocdi/register_plugins', 'ocdi_register_plugins' );

/*-----------------------------------------------------------------------------------*/
# Admin Notices
/*-----------------------------------------------------------------------------------*/
function kanews_check_plugin_state(){
	global $pagenow;
	if($pagenow == 'plugins.php')
	return false;
	
	if (is_plugin_active('easy-theme-and-plugin-upgrades/init.php')){
		wp_die('<p>Easy Theme and Plugin Updates eklentisini kaldırın veya etkisiz hale getirin!</p> <a class="button" href="'.admin_url('plugins.php').'">Eklentileri Görüntüle</a>');
	} else
	return false;
}
add_action('admin_init', 'kanews_check_plugin_state');

// Update Key
function kanews_update_key_notice(){
	if ( get_option('kanews_order_auth') != '' )
	return false;

	$message = sprintf( esc_html__( 'Güncellemeleri paneliniz üzerinden yapmak için lütfen %s ekleyin.', 'kanews' ), '<a href="'.admin_url('admin.php?page=kanews-update').'">güncelleme anahtarınızı</a>' );
	printf( '<div class="error"><p>%s</p></div>', $message );
}
add_action('admin_notices', 'kanews_update_key_notice');

// Disable wp cron
function kanews_update_key_notice2(){
	if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) {
		$message =  esc_html__( 'Kanews\'i tam verimlilik ile kullanmak için WP Cron sistemini etkinleştirin.', 'kanews' );
		printf( '<div class="notice notice-info"><p>%s</p></div>', $message );
	} else {
		return false;
	}
}
add_action('admin_notices', 'kanews_update_key_notice2');

// Curl Extension
function kanews_curl_requires_notice() {
	if( in_array('curl', get_loaded_extensions()) ) 
	return false;

	$message = sprintf( esc_html__( '%s çalışması için cURL kütüphanenizin aktif olması gerekiyor.', 'kanews' ), KAN_THEME_NAME );
	printf( '<div class="error"><p>%s</p></div>', $message );
}
add_action( 'admin_notices', 'kanews_curl_requires_notice' );

/*-----------------------------------------------------------------------------------*/
# Post Format Base
/*-----------------------------------------------------------------------------------*/
add_filter( 'post_format_rewrite_base', 'kanews_post_format_rewrite_base' );
function kanews_post_format_rewrite_base( $slug ) {
	if(get_option('kanews_post_format_base') != '')
	return trim( strip_tags(get_option('kanews_post_format_base')));
	else
	return $slug;
}

add_action( 'load-options-permalink.php', 'kanews_post_format_load_permalinks' );
function kanews_post_format_load_permalinks() {
	if( isset( $_POST['kanews_post_format_base'] ) ) {
		update_option( 'kanews_post_format_base', sanitize_title_with_dashes( $_POST['kanews_post_format_base'] ) );
	}
	add_settings_field( 'kanews_post_format_base', __( 'Yazı türü temeli' ), 'kanews_post_format_field_callback', 'permalink', 'optional' );
}

function kanews_post_format_field_callback(){
	$value = get_option( 'kanews_post_format_base' );	
	echo '<input type="text" value="' . esc_attr( $value ) . '" name="kanews_post_format_base" id="kanews_post_format_base" class="regular-text" />';
}


/**
* Render textinput for Author base
* Callback for the add_settings_function()
*
* @return void
*/
function kanews_2610_author_base_render_field() {
	global $wp_rewrite;
	printf(
			'<code>'.home_url('/').'</code><input name="kanews_author_base" id="kanews_author_base" type="text" value="%s" class="regular-text code">',
			esc_attr( $wp_rewrite->author_base )
	);
}

/**
* Add a setting field for Author Base to the "Optional" Section
* of the Permalinks Page
*
* @return void
*/
function kanews_2610_author_base_add_settings_field() {
	add_settings_field(
			'kanews_author_base',
			esc_html__( 'Yazar temeli' ),
			'kanews_2610_author_base_render_field',
			'permalink',
			'optional',
			array( 'label_for' => 'kanews_author_base' )
	);
}

add_action( 'admin_init', 'kanews_2610_author_base_add_settings_field' );

/**
* Sanitize and save the given Author Base value to the database
*
* @return void
*/
function kanews_2610_author_base_update() {
	$author_base_db = get_option( 'kanews_author_base' );

	if ( isset( $_POST['kanews_author_base'] ) &&
			isset( $_POST['permalink_structure'] ) &&
			check_admin_referer( 'update-permalink' )
	) {
		$author_base = sanitize_title( $_POST['kanews_author_base'] );

		if ( empty( $author_base ) ) {
			add_settings_error(
				'kanews_author_base',
				'kanews_author_base',
				esc_html__( 'Invalid Author Base.' ),
				'error'
			);
		} elseif ( $author_base_db != $author_base ) {
				update_option( 'kanews_author_base', $author_base );
		}
	}
}

add_action( 'admin_init', 'kanews_2610_author_base_update' );

/*-----------------------------------------------------------------------------------*/
# Author Archive Slug
/*-----------------------------------------------------------------------------------*/

/**
* Render textinput for Author slug
* Callback for the add_settings_function()
*
* @return void
*/
function kanews_2610_author_slug_render_field() {
	global $wp_rewrite;
	printf(
			'<code>'.home_url('/'.esc_attr( $wp_rewrite->author_base )).'/</code><input name="kanews_author_slug" id="kanews_author_slug" type="text" value="%s" class="regular-text code">',
			esc_attr( get_option( 'kanews_author_slug', 'konu' ) )
	);
}

/**
* Add a setting field for Author Base to the "Optional" Section
* of the Permalinks Page
*
* @return void
*/
function kanews_2610_author_slug_add_settings_field() {
	add_settings_field(
			'kanews_author_slug',
			esc_html__( 'Köşe yazısı temeli' ),
			'kanews_2610_author_slug_render_field',
			'permalink',
			'optional',
			array( 'label_for' => 'kanews_author_slug' )
	);
}

add_action( 'admin_init', 'kanews_2610_author_slug_add_settings_field' );

/**
* Sanitize and save the given Author slug value to the dataslug
*
* @return void
*/
function kanews_2610_author_slug_update() {
	$author_slug_db = get_option( 'kanews_author_slug' );

	if ( isset( $_POST['kanews_author_slug'] ) &&
			isset( $_POST['permalink_structure'] ) &&
			check_admin_referer( 'update-permalink' )
	) {
		$author_slug = sanitize_title( $_POST['kanews_author_slug'] );

		if ( empty( $author_slug ) ) {
			add_settings_error(
				'kanews_author_slug',
				'kanews_author_slug',
				esc_html__( 'Invalid Author slug.' ),
				'error'
			);
		} elseif ( $author_slug_db != $author_slug ) {
				update_option( 'kanews_author_slug', $author_slug );
		}
	}
}

add_action( 'admin_init', 'kanews_2610_author_slug_update' );

/*-----------------------------------------------------------------------------------*/
# İlan Slug
/*-----------------------------------------------------------------------------------*/

/**
* Render textinput for Author slug
* Callback for the add_settings_function()
*
* @return void
*/
function kanews_2610_ilan_slug_render_field() {
	global $wp_rewrite;
	printf(
			'<code>'.home_url().'/</code><input name="kanews_ilan_slug" id="kanews_ilan_slug" type="text" value="%s" class="regular-text code">',
			esc_attr( get_option( 'kanews_ilan_slug', 'ilan' ) )
	);
}

/**
* Add a setting field for ilan Base to the "Optional" Section
* of the Permalinks Page
*
* @return void
*/
function kanews_2610_ilan_slug_add_settings_field() {
	add_settings_field(
			'kanews_ilan_slug',
			esc_html__( 'İlanlar temeli' ),
			'kanews_2610_ilan_slug_render_field',
			'permalink',
			'optional',
			array( 'label_for' => 'kanews_ilan_slug' )
	);
}

add_action( 'admin_init', 'kanews_2610_ilan_slug_add_settings_field' );

/**
* Sanitize and save the given ilan slug value to the dataslug
*
* @return void
*/
function kanews_2610_ilan_slug_update() {
	$ilan_slug_db = get_option( 'kanews_ilan_slug' );

	if ( isset( $_POST['kanews_ilan_slug'] ) &&
			isset( $_POST['permalink_structure'] ) &&
			check_admin_referer( 'update-permalink' )
	) {
		$ilan_slug = sanitize_title( $_POST['kanews_ilan_slug'] );

		if ( empty( $ilan_slug ) ) {
			add_settings_error(
				'kanews_ilan_slug',
				'kanews_ilan_slug',
				esc_html__( 'Invalid ilan slug.' ),
				'error'
			);
		} elseif ( $ilan_slug_db != $ilan_slug ) {
				update_option( 'kanews_ilan_slug', $ilan_slug );
		}
	}
}

add_action( 'admin_init', 'kanews_2610_ilan_slug_update' );

/*-----------------------------------------------------------------------------------*/
# Firma Slug
/*-----------------------------------------------------------------------------------*/

/**
* Render textinput for Author slug
* Callback for the add_settings_function()
*
* @return void
*/
function kanews_2610_firma_slug_render_field() {
	global $wp_rewrite;
	printf(
			'<code>'.home_url().'/</code><input name="kanews_firma_slug" id="kanews_firma_slug" type="text" value="%s" class="regular-text code">',
			esc_attr( get_option( 'kanews_firma_slug', 'firma-rehberi' ) )
	);
}

/**
* Add a setting field for firma Base to the "Optional" Section
* of the Permalinks Page
*
* @return void
*/
function kanews_2610_firma_slug_add_settings_field() {
	add_settings_field(
			'kanews_firma_slug',
			esc_html__( 'Firma temeli' ),
			'kanews_2610_firma_slug_render_field',
			'permalink',
			'optional',
			array( 'label_for' => 'kanews_firma_slug' )
	);
}

add_action( 'admin_init', 'kanews_2610_firma_slug_add_settings_field' );

/**
* Sanitize and save the given firma slug value to the dataslug
*
* @return void
*/
function kanews_2610_firma_slug_update() {
	$firma_slug_db = get_option( 'kanews_firma_slug' );

	if ( isset( $_POST['kanews_firma_slug'] ) &&
			isset( $_POST['permalink_structure'] ) &&
			check_admin_referer( 'update-permalink' )
	) {
		$firma_slug = sanitize_title( $_POST['kanews_firma_slug'] );

		if ( empty( $firma_slug ) ) {
			add_settings_error(
				'kanews_firma_slug',
				'kanews_firma_slug',
				esc_html__( 'Invalid firma slug.' ),
				'error'
			);
		} elseif ( $firma_slug_db != $firma_slug ) {
				update_option( 'kanews_firma_slug', $firma_slug );
		}
	}
}

add_action( 'admin_init', 'kanews_2610_firma_slug_update' );


/*-----------------------------------------------------------------------------------*/
# Google Fonts
/*-----------------------------------------------------------------------------------*/
function kanews_google_fonts() {
  // Check if cached fonts exist and are less than 30 days old
  $cached_fonts = get_transient('kanews_google_fonts_cache');
  if ($cached_fonts !== false) {
    return $cached_fonts;
  }

  // Try to fetch latest fonts from Google Fonts API
  $response = wp_remote_get('https://www.googleapis.com/webfonts/v1/webfonts?key=AIzaSyBNWzU2R3gbTv_d_nBKbbg1cP5yynMbETk');
  
  if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
    $fonts = json_decode(wp_remote_retrieve_body($response), true);
    $list = array("system" => "Sistem Fontu"); // Add system font as first option
    
    if (!empty($fonts['items'])) {
      foreach ($fonts['items'] as $font) {
        $key = strtolower(str_replace(' ', '_', $font['family']));
        $list[$key] = $font['family'];
      }
      
      // Cache the fonts list for 30 days
      set_transient('kanews_google_fonts_cache', $list, 30 * DAY_IN_SECONDS);
      
      return $list;
    }
  }
  
  // Fallback to existing static list if API call fails
  $list = array( "system" => "Sistem Fontu", /* ... existing fonts ... */ );
  
  return $list;
}

/**
 * Adding local_import_json and import_json param supports.
 */
if ( ! function_exists( 'kan_after_content_import_execution' ) ) {
  function kan_after_content_import_execution( $selected_import_files, $import_files, $selected_index ) {

    $downloader = new OCDI\Downloader();

    if( ! empty( $import_files[$selected_index]['import_json'] ) ) {

      foreach( $import_files[$selected_index]['import_json'] as $index => $import ) {
        $file_path = $downloader->download_file( $import['file_url'], 'demo-import-file-'. $index .'-'. date( 'Y-m-d__H-i-s' ) .'.json' );
        $file_raw  = OCDI\Helpers::data_from_file( $file_path );
        update_option( $import['option_name'], json_decode( $file_raw, true ) );
      }

    } else if( ! empty( $import_files[$selected_index]['local_import_json'] ) ) {

      foreach( $import_files[$selected_index]['local_import_json'] as $index => $import ) {
        $file_path = $import['file_path'];
        $file_raw  = OCDI\Helpers::data_from_file( $file_path );
        update_option( $import['option_name'], json_decode( $file_raw, true ) );
      }

    }

  }
  add_action('ocdi/before_content_import_execution', 'kan_after_content_import_execution', 3, 10 );
}


function kanews_get_turkey_cities3() {
	$sehirler = array(
		'325361' =>'Adana',
		'325329' =>'Adıyaman',
		'325302' =>'Afyonkarahisar',
		'325163' =>'Ağrı',
		'752014' =>'Amasya',
		'323786' =>'Ankara',
		'323776' =>'Antalya',
		'751816' =>'Artvin',
		'322819' =>'Aydın',
		'322164' =>'Balıkesir',
		'750598' =>'Bilecik',
		'321079' =>'Bingöl',
		'321022' =>'Bitlis',
		'745175' =>'Bolu',
		'320390' =>'Burdur',
		'750268' =>'Bursa',
		'749778' =>'Çanakkale',
		'749747' =>'Çankırı',
		'748877' =>'Çorum',
		'317109' =>'Denizli',
		'316540' =>'Diyarbakır',
		'747712' =>'Edirne',
		'315807' =>'Elâzığ',
		'315372' =>'Erzincan',
		'315368' =>'Erzurum',
		'315201' =>'Eskişehir',
		'314829' =>'Gaziantep',
		'746878' =>'Giresun',
		'746423' =>'Gümüşhane',
		'312888' =>'Hakkari',
		'312394' =>'Hatay',
		'311071' =>'Isparta',
		'304531' =>'Mersin',
		'745042' =>'İstanbul',
		'311044' =>'İzmir',
		'743942' =>'Kars',
		'743881' =>'Kastamonu',
		'308464' =>'Kayseri',
		'743165' =>'Kırklareli',
		'307513' =>'Kırşehir',
		'742865' =>'Kocaeli',
		'306569' =>'Konya',
		'305267' =>'Kütahya',
		'304919' =>'Malatya',
		'304825' =>'Manisa',
		'310858' =>'Kahramanmaraş',
		'304794' =>'Mardin',
		'304183' =>'Muğla',
		'304041' =>'Muş',
		'303830' =>'Nevşehir',
		'303826' =>'Niğde',
		'741099' =>'Ordu',
		'740483' =>'Rize',
		'740352' =>'Sakarya',
		'740264' =>'Samsun',
		'300821' =>'Siirt',
		'739598' =>'Sinop',
		'300619' =>'Sivas',
		'738926' =>'Tekirdağ',
		'738742' =>'Tokat',
		'738647' =>'Trabzon',
		'298845' =>'Tunceli',
		'298332' =>'Şanlıurfa',
		'298298' =>'Uşak',
		'298113' =>'Van',
		'296560' =>'Yozgat',
		'737022' =>'Zonguldak',
		'443185' =>'Aksaray',
		'862471' =>'Bayburt',
		'309527' =>'Karaman',
		'443188' =>'Kırıkkale',
		'443186' =>'Batman',
		'443189' =>'Şırnak',
		'862467' =>'Bartın',
		'751952' =>'Ardahan',
		'443184' =>'Iğdır',
		'862469' =>'Yalova',
		'862468' =>'Karabük',
		'443213' =>'Kilis',
		'443183' =>'Osmaniye',
		'865521' =>'Düzce',
		'146268' =>'Lefkoşa',
		'146617' =>'Gazimağusa',
		'146412' =>'Girne',
		'146286' =>'Güzelyurt',
		'146027' =>'İskele',
	);
  return apply_filters('kanews/weather_page_cities', $sehirler);
}

/*-----------------------------------------------------------------------------------*/
# Get Categories
/*-----------------------------------------------------------------------------------*/
function kanews_get_categories() {
  $output_categories = array();
  $categories = get_categories();
	
  foreach($categories as $category) {
    $output_categories[$category->slug] = $category->name;
  }

  return $output_categories;
}

/*-----------------------------------------------------------------------------------*/
# Get Pages
/*-----------------------------------------------------------------------------------*/
function kanews_get_pages() {
  $output_pages = array();
  $pages = get_pages('hide_empty=0&depth=1&type=post');
	
  foreach($pages as $page) {
    $output_pages[$page->ID] = $page->post_title;
  }

  return $output_pages;
}


/*-----------------------------------------------------------------------------------*/
# Contact Forms
/*-----------------------------------------------------------------------------------*/
function kanews_get_contact_forms() {
  $posts = get_posts(array(
    'post_type'     => 'wpcf7_contact_form',
    'numberposts'   => -1
  ));

	$output = array();

  foreach ( $posts as $p ) {
    $output[$p->ID] = $p->post_title;
  }
  
  return $output;
}


function kanews_about_update_page() {
	?>
	<style>

.feature-box {
    border-radius: 16px;
    background-color: #eff1ff;
    display: flex;
    flex-wrap: wrap!important;
    align-items: normal!important;
    box-sizing: border-box;
    margin-bottom: 2rem;
    height: 100%
}

.feature-box img {
    max-width: 100%
}

.feature-box .pt-0 {
    padding-top: 0!important
}

.feature-box .pb-0 {
    padding-bottom: 0!important
}

.feature-box-col {
    align-self: center;
    padding: clamp(30px,5vw,50px)
}

.feature-box .align-bottom {
    padding: 0;
    align-self: flex-end
}

.feature-box .align-bottom img {
    box-sizing: border-box;
    height: auto;
    max-width: 100%;
    vertical-align: bottom
}

.feature-box-title {
    font-size: 42px;
    line-height: 1.2;
    font-weight: 400
}

.feature-box-text {
    line-height: 1.875;
    font-size: 16px
}
.col-12, .products>h2 {
    -ms-flex: 0 0 100%;
    flex: 0 0 100%;
    max-width: 100%;
		max-width: 100%;
		position: relative;
    width: 100%;
    padding-right: 15px;
    padding-left: 15px;
}
.mb-2 {
    margin-bottom: 2em;
}
.row {
    display: flex;
    flex-wrap: wrap;
    margin-right: -15px;
    margin-left: -15px;
}
.container {
	width: 100%;
	max-width: 1200px;
    padding-right: 15px;
    padding-left: 15px;
    margin-right: auto;
    margin-left: auto;
}

.section {
    padding: 70px 0;
    width: 100%;
    position: relative;
    overflow: hidden;
}
.col {
    -ms-flex-preferred-size: 0;
    flex-basis: 0;
    -ms-flex-positive: 1;
    flex-grow: 1;
    max-width: 100%;
		position: relative;
    width: 100%;
    padding-right: 15px;
    padding-left: 15px;
}
@media (min-width: 992px) {
	
    .col-lg-6 {
			position: relative;
    width: 100%;
    padding-right: 15px;
    padding-left: 15px;
			-ms-flex: 0 0 50%;
        flex: 0 0 50%;
        max-width: 50%;
    }
}
.text-right {
    text-align: right;
}

.col-auto {
	position: relative;
    width: 100%;
    padding-right: 15px;
    padding-left: 15px;
	-ms-flex: 0 0 auto;
    flex: 0 0 auto;
    width: auto;
    max-width: 100%;

}
	</style>
	<section id="features" class="section">
			<div class="container">
				<div class="row">

					<div class="col-12 mb-2">
						<div class="feature-box">
							<div class="feature-box-col col">
								<h2 class="feature-box-title">Gutenberg ile daha iyi bir haber yazma deneyimi</h2>
								<p class="feature-box-text">
								Kanews’e özel geliştirilen Gutenberg blokları sayesinde içerik üretimi artık çok daha kolay ve görsel açıdan etkileyici. İçindekiler, hesaplayıcılar, zaman çizelgeleri, kaynakça ve daha fazlasıyla tanışın.


								</p>
							</div>
							<div class="feature-box-col col-auto text-right hidden-mobile">
								<img src="http://localhost/kanthemes/wp-content/themes/kanthemes/dist/img/land/kanews/update/1.png" alt="kanews">
							</div>
						</div>
					</div>

					<div class="col-12 mb-2">
						<div class="feature-box" style="    background-color: #f2fff0;">
						<div class="feature-box-col col-auto text-left hidden-mobile">
								<img src="http://localhost/kanthemes/wp-content/themes/kanthemes/dist/img/land/kanews/update/2.png" alt="kanews">
							</div>
							<div class="feature-box-col col">
								<h2 class="feature-box-title">KAI ile İçerik Üretiminde Akıllı Dönüşüm</h2>
								<p class="feature-box-text">
								Yapay zekâ destekli Kanews Assistant Intelligence (KAI) artık daha akıllı. Makale Özgünleştirici görevi ve makale hazırlarken “bunları nutma” kutusu gibi yeni araçlarla daha isabetli, özgün ve tutarlı makaleler hazırlayabilirsiniz.

								</p>
							</div>
							
						</div>
					</div>
					<div class="col-12 col-lg-6 mb-2">
						<div class="feature-box" style="background-color: #f5f5f5;">
							<div class="feature-box-col col">
								<h2 class="feature-box-title">Bileşenlerde Kapsamlı Yenilik ve Gruplandırma</h2>
								<p class="feature-box-text">
								Yönetimi kolaylaştırmak için bileşenler yeniden düzenlendi ve gruplandırıldı. Video Galeri, Hava Durumu, Taksonomi, Reklam ve Nöbetçi Eczane bileşenleri tamamen yenilendi.



								</p>
							</div>
							<div class="feature-box-col col-auto text-right hidden-mobile pt-0">
								<img src="http://localhost/kanthemes/wp-content/themes/kanthemes/dist/img/land/kanews/update/3.png" alt="kanews">
							</div>
						</div>
					</div>

					<div class="col-12 col-lg-6 mb-2">
						<div class="feature-box" style="    background-color: #e4fffd;">
						<div class="feature-box-col col-auto text-left hidden-mobile pb-0">
								<img src="http://localhost/kanthemes/wp-content/themes/kanthemes/dist/img/land/kanews/update/4.png" alt="kanews">
							</div>
							<div class="feature-box-col col">
								<h2 class="feature-box-title">Veri ve Hesaplama Araçlarında Gelişmeler</h2>
								<p class="feature-box-text">
								Yapay zekâ destekli Kanews Assistant Intelligence (KAI) artık daha akıllı. Makale Özgünleştirici görevi ve makale hazırlarken “bunları nutma” kutusu gibi yeni araçlarla daha isabetli, özgün ve tutarlı makaleler hazırlayabilirsiniz.

								</p>
							</div>
							
						</div>
					</div>

					<div class="col-12 mb-2">
						<div class="feature-box" style="    background-color:rgb(255, 245, 252);">
						<div class="feature-box-col col-auto text-left hidden-mobile">
								<img src="http://localhost/kanthemes/wp-content/themes/kanthemes/dist/img/land/kanews/update/5.png" alt="kanews">
							</div>
							<div class="feature-box-col col">
								<h2 class="feature-box-title">Güncel İçerik ve Veriyle Güçlenen Okuyucu Deneyimi</h2>
								<p class="feature-box-text">
								Kanews artık çok daha dinamik! REST API üzerinden alınan veriler sayesinde nöbetçi eczaneler, hava durumu, maç merkezi ve gazete manşetleri gibi alanlarda daha doğru, hızlı ve kesintisiz bilgi sunuluyor. Köşe yazıları bileşenine kategori filtresi, manşet bileşenlerine reklam desteği ve daha fazlası ile kullanıcılarınıza güncel, kişiselleştirilmiş ve etkileşimli bir deneyim sağlayabilirsiniz.


								</p>
							</div>
							
						</div>
					</div>

					<div class="col-12 col-lg-6 mb-2">
						<div class="feature-box" style="background-color: #ffffe6;">
							<div class="feature-box-col col">
								<h2 class="feature-box-title">Hesabım Sayfasına Rozet ve Rütbe Desteği</h2>
								<p class="feature-box-text">
								Topluluk deneyimini artırmak için “Hesabım” sayfasına kullanıcı ilerleme durumu, rozetler ve rütbe takibi özellikleri eklendi. Sadakat ve katılım artık daha görünür.




								</p>
							</div>
							<div class="feature-box-col col-auto text-right hidden-mobile pt-0">
								<img src="http://localhost/kanthemes/wp-content/themes/kanthemes/dist/img/land/kanews/update/6.png" alt="kanews">
							</div>
						</div>
					</div>

					<div class="col-12 col-lg-6 mb-2">
						<div class="feature-box" style="    background-color: #e4fffd;">
						<div class="feature-box-col col-auto text-left hidden-mobile pb-0">
								<img src="http://localhost/kanthemes/wp-content/themes/kanthemes/dist/img/land/kanews/update/4.png" alt="kanews">
							</div>
							<div class="feature-box-col col">
								<h2 class="feature-box-title">Giderilen Hatalar ve Teknik Düzeltmeler</h2>
								<p class="feature-box-text">
								Emtia ve döviz sayfalarındaki hatalar giderildi, text domain problemleri çözüldü. Daha kararlı ve sorunsuz bir kullanıcı deneyimi için birçok küçük hata temizlendi.


								</p>
							</div>
							
						</div>
					</div>

					<div class="col-12 mb-2">
						<div class="feature-box" style="    background-color:#ffedee;">
						<div class="feature-box-col col-auto text-left hidden-mobile">
								<img src="http://localhost/kanthemes/wp-content/themes/kanthemes/dist/img/land/kanews/update/7.png" alt="kanews">
							</div>
							<div class="feature-box-col col">
								<h2 class="feature-box-title">Performans ve Tasarım İyileştirmeleri</h2>
								<p class="feature-box-text">
								Yaklaşık 30 KB’lık JavaScript optimizasyonlarıyla site hızı iyileştirildi. Gece modu, puan durumları, sosyal medya ve namaz vakitleri gibi pek çok alanda tasarımsal güncellemeler yapıldı.



								</p>
							</div>
							
						</div>
					</div>

				</div>
			</div>
		</section>
	<?php 
}