<?php
namespace Kanews;
use \stdClass;

class Category {

  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

	public function __construct() {

		if( class_exists( 'WPSEO_Primary_Term' ) || class_exists('rank_math') )
		return;

		add_action( 'add_meta_boxes', array( $this, 'kanews_add_metabox' ) );
		add_action( 'save_post', 			array( $this, 'kanews_save_metabox' ) );
	}

	public function kanews_add_metabox() {
		$items = $this->kanews_build_lists();
		add_meta_box (
			'kanews_primary_category', // metabox id
			esc_html__( 'Birincil Kategori', 'kanews' ), // metabox title
			array( $this, 'kanews_metabox_callback' ), // metabox render callback function
			'post', // screen to display metabox e.g post type
			'side', // context
			'high' // priority
		);
	}

	function kanews_metabox_callback( $post ) {
		wp_nonce_field( 'kanews_category_nonce', 'kanews_category_nonce_field' );
		$items = $this->kanews_build_lists();
		$primary_category = '';

		$primary_selected_category = get_post_meta( $post->ID, 'kanews_primary_category', true );
	
		if ( $primary_selected_category != '' ) {
			$primary_category = $primary_selected_category;
		}

    $post_categories = $items->categories_list;
    
    $html = '';
    $html .= '<select name="kanews_primary_category" id="kanews_primary_category">';
    $html .= '<option value="0" >'.esc_html__( 'Kategori Seç', 'kanews' ).'</option>';

    if ( ! empty( $post_categories ) ) {
        foreach( $post_categories as $category ) {
					$html .= '<option value="' . $category->term_id . '" ' . selected( $primary_category, $category->term_id, false ) . '>' . ucwords($category->name) . '</option>';
        }
    }
    $html .= '</select>';

		echo $html;
	}

	function kanews_save_metabox( $post_id ) {
		if( ! isset( $_POST['kanews_category_nonce_field'] ) || ! wp_verify_nonce( $_POST['kanews_category_nonce_field'],'kanews_category_nonce' ) ) 
			return;

			if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
			}

			if ( isset( $_POST[ 'kanews_primary_category' ] ) ) {
			$primary_category = sanitize_text_field( $_POST[ 'kanews_primary_category' ] );
			update_post_meta( $post_id, 'kanews_primary_category', $primary_category );
		}
	}


  function kanews_build_lists() {
    $item = new stdClass();
    $args = array(
      'public' => true, // only get publically accessable post types
      '_builtin' => false // remove builtin post types
    );
    $item->post_type_list = get_post_types( $args, 'names' );
    $item->post_type_list['post'] = 'post';
    $item->categories_list = get_the_category();

    return $item;
  }
}
