<?php
namespace Kanews\Builder;
use CSF;

class Terms {

  private static $instance;

  public static function getInstance() {
    if ( null === static::$instance ) {
      static::$instance = new static();
    }
    return static::$instance;
  }

  function __construct() {

    add_action( 'category_add_form_fields', array ( $this, 'create_category_fields' ), 10, 2 );
    add_action( 'created_category', array ( $this, 'save_category_fields' ), 10, 2 );
    add_action( 'category_edit_form_fields', array ( $this, 'edit_category_fields' ), 10, 2 );
    add_action( 'edited_category', array ( $this, 'updated_category_fields' ), 10, 2 );

    add_action('post_tag_edit_form_fields',array ( $this, 'edit_tag_fields' ), 10, 2 );
    add_action('edited_post_tag', array ( $this, 'updated_tag_fields' ), 10, 2 );
    add_action('post_tag_add_form_fields', array ( $this, 'create_tag_fields' ), 10, 2 );
    add_action('created_post_tag',array ( $this, 'save_tag_fields' ), 10, 2 );

    add_action( 'admin_enqueue_scripts', array( $this, 'admin_add_scripts' ) );
    add_action( 'admin_footer', array( $this, 'admin_print_scripts' ) );

    $this->category_options();
    $this->nav_options();
  }

  /**
   * Nav Options
   */
  function nav_options() {
    // Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

  //
  // Set a unique slug-like ID
  $prefix = '_kan_menu_options';

  //
  // Create profile options
  CSF::createNavMenuOptions( $prefix, array(
    'data_type' => 'serialize', // The type of the database save options. `serialize` or `unserialize`
  ) );

  //
  // Create a section
  CSF::createSection( $prefix, array(
    'fields' => array(

      array(
        'id'    => 'icon',
        'type'  => 'icon',
        'title' => esc_html__( 'İkon', 'kanews' ),
      ),
      array(
        'id'    => 'image',
        'type'  => 'media',
        'title' => esc_html__( 'Görsel İkon', 'kanews' ),
        'desc' => 'svg formatında ikon',
      ),

      array(
        'id'    => 'badge',
        'type'  => 'text',
        'title' => esc_html__( 'Etiket', 'kanews' ),
      ),

      array(
        'id'    => 'badge_color',
        'type'  => 'color',
        'title' => esc_html__( 'Etiket', 'kanews' ).' '.esc_html__('Renk'),
      ),

    )
  ) );

}

  }

  /**
  * Category Options
  *
  * @since 1.0.0
  */
  function category_options() {
    // Control core classes for avoid errors
    if( class_exists( 'CSF' ) ) {

      // Set a unique slug-like ID
      $prefix = 'kanews_taxonomy_options';

      // Create taxonomy options
      CSF::createTaxonomyOptions( $prefix, array(
        'taxonomy'  => 'category',
        'data_type' => 'unserialize',
      ) );

      // Create a section
      CSF::createSection( $prefix, array(
        'title'  => esc_html__( 'Kanews Ayarları', 'kanews' ),
        'fields' => array(

          array(
            'id'     => 'kanews_logo',
            'type'   => 'fieldset',
            'title'   => esc_html__('Kategori Logosu', 'kanews' ),
            'fields' => array(
              array(
                'id'      => 'type',
                'type'    => 'radio',
                'inline'  => false,
                'options' => array(
                  'default'    => esc_html__('Varsayılan', 'kanews'),
                  'img'    => esc_html__('Görsel', 'kanews'),
                ),
              ),
              array(
                'type'       => 'media',
                'id'          => 'logo-img',
                'button_title' => esc_html__('Görsel Yükle', 'kanews'),
                'dependency' => array( 'type', '==', 'img' ),
              ),
            ),
            'default' => array(
              'type' => 'default',
            ),
          ),
          // Retina Logo
          array(
            'id'    => 'kanews_logo_mobile',
            'title'  => esc_html__('Retina Logo', 'kanews'),
            'desc'  => esc_html__('Ana logodan 2 kat daha büyük olmalıdır.', 'kanews'),
            'type'  => 'media'
          ),
          // Dark Logo
          array(
            'id'    => 'kanews_logo_dark',
            'title'  => esc_html__('Koyu Mod Logo', 'kanews'),
            'desc'  => esc_html__('Koyu mod aktif edildiğinde gözükecek olan logo.', 'kanews'),
            'type'  => 'media'
          ),

          array(
            'id'    => 'kanews_menu',
            'type'  => 'select',
            'options'  => 'menus',
            'chosen'      => true,
            'ajax'        => true,
            'placeholder' => esc_html__( 'Varsayılan', 'kanews' ),
            'title' => esc_html__( 'Özel Menü', 'kanews' ),
          ),

          array(
            'id'    => 'recent-post-section-title',
            'type'  => 'text',
            'title' => esc_html__( 'Son Yazılar Başlığı', 'kanews' ),
          ),

          array(
            'id'    => 'category-recent-posts-style',
            'type'  => 'select',
            'default'    => 'style1',
            'options' => array(
              '' => esc_html__('Varsayılan', 'kanews'),
              'disable' => esc_html__('Gösterme', 'kanews'),
              '1' => esc_html__('Görünüm', 'kanews').' #1',
              '2' => esc_html__('Görünüm', 'kanews').' #2',
              '3' => esc_html__('Görünüm', 'kanews').' #3',
              '4' => esc_html__('Görünüm', 'kanews').' #4',
              '5' => esc_html__('Görünüm', 'kanews').' #5',
              '6' => esc_html__('Görünüm', 'kanews').' #6',
            ),
            'title' => esc_html__( 'Son Yazıların Görünümü	', 'kanews' ),
          ),

          array(
            'id'    => 'category-posts-per-page',
            'type'  => 'number',
            'min'  => 0,
            'title' => esc_html__( 'Son Yazı Sayısı', 'kanews' ),
          ),

          array(
            'id'    => 'private-category',
            'type'  => 'switcher',
            'text_on'  => __('Yes'),
            'text_off' => __('No'),
            'title' => esc_html__( 'Ücretli İçerik Kategorisi	', 'kanews' ),
          ),

          array(
            'id'    => 'hidden-category-desc',
            'type'  => 'switcher',
            'text_on'  => __('Yes'),
            'text_off' => __('No'),
            'title' => esc_html__( 'Açıklamayı Gizle', 'kanews' ),
          ),

          array(
            'id'    => 'category-desc-on-footer',
            'type'  => 'switcher',
            'text_on'  => __('Yes'),
            'text_off' => __('No'),
            'title' => esc_html__( 'Açıklamayı Sayfanın Altına Taşı', 'kanews' ),
          ),

          array(
            'id'    => 'ilan-category',
            'type'  => 'switcher',
            'text_on'  => __('Yes'),
            'text_off' => __('No'),
            'title' => esc_html__( 'Resmi İlan Kategorisidir', 'kanews' ),
          ),

        )
      ) );

    }
  }

  /**
  * Enqueue Scripts
  *
  * @since 1.0.0
  */
  function admin_add_scripts() {
    wp_enqueue_media();
    wp_enqueue_script( 'wp-color-picker' );
    wp_enqueue_style( 'wp-color-picker' );
  }

  /**
  * Print Script
  *
  * @since 1.0.0
  */
  function admin_print_scripts() { ?>
    <script>
      jQuery( document ).ready( function( $ ) {
        $( '.colorpicker' ).wpColorPicker();
      } );
    </script>
    <?php if( isset($_GET['taxonomy']) && $_GET['taxonomy'] == 'category') : ?>
    <script>
      jQuery(document).ready( function($) {
        function ct_media_upload(button_class) {
          var _custom_media = true,
          _orig_send_attachment = wp.media.editor.send.attachment;
          $('body').on('click', button_class, function(e) {
            var button_id = '#'+$(this).attr('id');
            var send_attachment_bkp = wp.media.editor.send.attachment;
            var button = $(button_id);
            _custom_media = true;
            wp.media.editor.send.attachment = function(props, attachment){
              if ( _custom_media ) {
                $('#category-image-id').val(attachment.id);
                $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
                $('#category-image-wrapper .custom_media_image').attr('src',attachment.url).css('display','block');
              } else {
                return _orig_send_attachment.apply( button_id, [props, attachment] );
              }
            }
            wp.media.editor.open(button);
            return false;
          });
        }
        ct_media_upload('.ct_tax_media_button.button'); 
        $('body').on('click','.ct_tax_media_remove',function(){
          $('#category-image-id').val('');
          $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
        });
        $(document).ajaxComplete(function(event, xhr, settings) {
          var queryStringArr = settings.data.split('&');
          if( $.inArray('action=add-tag', queryStringArr) !== -1 ){
            var xml = xhr.responseXML;
            $response = $(xml).find('term_id').text();
            if($response!=""){
              $('#category-image-wrapper').html('');
            }
          }
        });
      });
    </script>
    <?php elseif( isset($_GET['taxonomy']) &&  $_GET['taxonomy'] == 'post_tag') : ?>
    <script>
      jQuery(document).ready( function($) {
        function ct_media_upload(button_class) {
          var _custom_media = true,
          _orig_send_attachment = wp.media.editor.send.attachment;
          $('body').on('click', button_class, function(e) {
            var button_id = '#'+$(this).attr('id');
            var send_attachment_bkp = wp.media.editor.send.attachment;
            var button = $(button_id);
            _custom_media = true;
            wp.media.editor.send.attachment = function(props, attachment){
              if ( _custom_media ) {
                $('#tag-image-id').val(attachment.id);
                $('#tag-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
                $('#tag-image-wrapper .custom_media_image').attr('src',attachment.url).css('display','block');
              } else {
                return _orig_send_attachment.apply( button_id, [props, attachment] );
              }
            }
            wp.media.editor.open(button);
            return false;
          });
        }
        ct_media_upload('.ct_tax_media_button.button'); 
        $('body').on('click','.ct_tax_media_remove',function(){
          $('#tag-image-id').val('');
          $('#tag-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
        });
        $(document).ajaxComplete(function(event, xhr, settings) {
          var queryStringArr = settings.data.split('&');
          if( $.inArray('action=add-tag', queryStringArr) !== -1 ){
            var xml = xhr.responseXML;
            $response = $(xml).find('term_id').text();
            if($response!=""){
              $('#tag-image-wrapper').html('');
            }
          }
        });
      });
    </script>
    <?php endif; ?>
  <?php }

  /**
  * Add a form field in the new category page
  *
  * @since 1.0.0
  */
  function create_category_fields($taxonomy) { ?>
    <div class="form-field term-group">
      <label for="category-image-id"><?php _e('Görsel', 'kanews'); ?></label>
      <input type="hidden" id="category-image-id" name="category-image-id" class="custom_media_url" value="">
      <div id="category-image-wrapper"></div>
      <p>
        <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="<?php _e( 'Görsel Ekle', 'kanews' ); ?>" />
        <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="<?php _e( 'Görseli Kaldır', 'kanews' ); ?>" />
      </p>
    </div>
    <div class="form-field term-group">
      <label for="term-colorpicker"><?php _e('Kategori Rengi', 'kanews'); ?></label>
      <input name="_category_color" class="colorpicker" id="term-colorpicker" />
    </div>
    
  <?php }

  /**
  * Add a form field in the new category edit page
  *
  * @since 1.0.0
  */
  function edit_category_fields($term, $taxonomy ) { 
    $hidden_cat_desc = get_term_meta( $term->term_id, 'hidden-category-desc', true );
    $private_category = get_term_meta( $term->term_id, 'private-category', true );
    $title = get_term_meta( $term->term_id, 'recent-post-section-title', true );
    $posts = get_term_meta( $term->term_id, 'category-posts-per-page', true );
    $offset = get_term_meta( $term->term_id, 'category-posts-offset', true );
    $recent_style = get_term_meta( $term->term_id, 'category-recent-posts-style', true );
    $color = get_term_meta( $term->term_id, '_category_color', true );
    $color = ( ! empty( $color ) ) ? "#{$color}" : '';
    ?>
    <tr class="form-field term-group-wrap">
      <th scope="row">
        <label for="category-image-id"><?php _e( 'Görsel', 'kanews' ); ?></label>
      </th>
      <td>
        <?php $image_id = get_term_meta ( $term -> term_id, 'category-image-id', true ); ?>
        <input type="hidden" id="category-image-id" name="category-image-id" value="<?php echo $image_id; ?>">
        <div id="category-image-wrapper">
          <?php if ( $image_id ) { ?>
            <?php echo wp_get_attachment_image ( $image_id, 'kanews-post-6' ); ?>
          <?php } ?>
        </div>
        <p>
          <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="<?php _e( 'Görsel Ekle', 'kanews' ); ?>" />
          <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="<?php _e( 'Görseli Kaldır', 'kanews' ); ?>" />
        </p>
      </td>
    </tr>
    <tr class="form-field term-colorpicker-wrap">
      <th scope="row"><label for="term-colorpicker"><?php _e('Renk', 'kanews'); ?></label></th>
      <td>
        <input name="_category_color" value="<?php echo $color; ?>" class="colorpicker" id="term-colorpicker" />
      </td>
    </tr>
  <?php }

  /**
  * Save the form field
  *
  * @since 1.0.0
  */
  function save_category_fields ( $term_id, $tt_id ) {

    if( isset( $_POST['category-image-id'] ) && '' !== $_POST['category-image-id'] ){
      $image = $_POST['category-image-id'];
      add_term_meta( $term_id, 'category-image-id', $image, true );
    }
    if( isset( $_POST['_category_color'] ) && ! empty( $_POST['_category_color'] ) ) {
      update_term_meta( $term_id, '_category_color', sanitize_hex_color_no_hash( $_POST['_category_color'] ) );
    } else {
      delete_term_meta( $term_id, '_category_color' );
    }

  }

  /**
  * Update the form field value
  *
  * @since 1.0.0
  */
  function updated_category_fields ( $term_id, $tt_id ) {
    if( isset( $_POST['category-image-id'] ) && '' !== $_POST['category-image-id'] ){
      $image = $_POST['category-image-id'];
      update_term_meta ( $term_id, 'category-image-id', $image );
    } else {
      update_term_meta ( $term_id, 'category-image-id', '' );
    }
    if( isset( $_POST['_category_color'] ) && ! empty( $_POST['_category_color'] ) ) {
      update_term_meta( $term_id, '_category_color', sanitize_hex_color_no_hash( $_POST['_category_color'] ) );
    } else {
      delete_term_meta( $term_id, '_category_color' );
    }
  }
  /**
  * Add a form field in the new tag page
  *
  * @since 1.0.0
  */
  function create_tag_fields($taxonomy) { ?>
    <div class="form-field term-group">
      <label for="tag-image-id"><?php _e('Görsel', 'kanews'); ?></label>
      <input type="hidden" id="tag-image-id" name="tag-image-id" class="custom_media_url" value="">
      <div id="tag-image-wrapper"></div>
      <p>
        <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="<?php _e( 'Görsel Ekle', 'kanews' ); ?>" />
        <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="<?php _e( 'Görseli Kaldır', 'kanews' ); ?>" />
      </p>
    </div>
    <div class="form-field term-group">
      <label for="category-posts-per-page"><?php _e('Renk', 'kanews'); ?></label>
      <input name="_category_color" class="colorpicker" id="term-colorpicker" />
    </div>
    
  <?php }

  /**
  * Add a form field in the new tag edit page
  *
  * @since 1.0.0
  */
  function edit_tag_fields($term, $taxonomy ) { 
    $posts = get_term_meta( $term->term_id, 'tag-posts-per-page', true );
    $color = get_term_meta( $term->term_id, '_tag_color', true );
    $color = ( ! empty( $color ) ) ? "#{$color}" : '';
    ?>
    <tr class="form-field term-colorpicker-wrap">
      <th scope="row"><label for="term-colorpicker"><?php _e('Renk', 'kanewsit-admin'); ?></label></th>
      <td>
        <input name="_tag_color" value="<?php echo $color; ?>" class="colorpicker" id="term-colorpicker" />
      </td>
    </tr>
    <tr class="form-field term-group-wrap">
      <th scope="row">
        <label for="tag-image-id"><?php _e( 'Görsel', 'kanews' ); ?></label>
      </th>
      <td>
        <?php $image_id = get_term_meta ( $term -> term_id, 'tag-image-id', true ); ?>
        <input type="hidden" id="tag-image-id" name="tag-image-id" value="<?php echo $image_id; ?>">
        <div id="tag-image-wrapper">
          <?php if ( $image_id ) { ?>
            <?php echo wp_get_attachment_image ( $image_id, 'kanews-post-6' ); ?>
          <?php } ?>
        </div>
        <p>
          <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="<?php _e( 'Görsel Ekle', 'kanews' ); ?>" />
          <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="<?php _e( 'Görseli Kaldır', 'kanews' ); ?>" />
        </p>
      </td>
    </tr>
  <?php }

  /**
  * Save the form field
  *
  * @since 1.0.0
  */
  function save_tag_fields ( $term_id, $tt_id ) {
    if( isset( $_POST['tag-image-id'] ) && '' !== $_POST['tag-image-id'] ){
      $image = $_POST['tag-image-id'];
      add_term_meta( $term_id, 'tag-image-id', $image, true );
    }
    if( isset( $_POST['_tag_color'] ) && ! empty( $_POST['_tag_color'] ) ) {
      update_term_meta( $term_id, '_tag_color', sanitize_hex_color_no_hash( $_POST['_tag_color'] ) );
    } else {
      delete_term_meta( $term_id, '_tag_color' );
    }
  }

  /**
  * Update the form field value
  *
  * @since 1.0.0
  */
  function updated_tag_fields ( $term_id, $tt_id ) {
    if( isset( $_POST['tag-image-id'] ) && '' !== $_POST['tag-image-id'] ){
      $image = $_POST['tag-image-id'];
      update_term_meta ( $term_id, 'tag-image-id', $image );
    } else {
      update_term_meta ( $term_id, 'tag-image-id', '' );
    }
    if( isset( $_POST['_tag_color'] ) && ! empty( $_POST['_tag_color'] ) ) {
      update_term_meta( $term_id, '_tag_color', sanitize_hex_color_no_hash( $_POST['_tag_color'] ) );
    } else {
      delete_term_meta( $term_id, '_tag_color' );
    }
  }


}


function kanews_get_menus() {
  $menus = get_terms('nav_menu', array('hide_empty' => true));

  $menu_array = array();
  
  foreach($menus as $menu) {
      $menu_array[$menu->slug] = $menu->name;
  }
  
  $menu_array_string = var_export($menu_array, true);
  
  return $menu_array_string;
}

