<?php
/**
 * The template for displaying author archive pages
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Kanews
 * @since 1.0.0
 */
defined( 'ABSPATH' ) || exit; // Exit if accessed directly
$curauth = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));
get_header();

$add_style = $add_style2 = '';
$pic_data = get_user_meta( $curauth->ID, 'cover_bg', true );
if( empty($pic_data['url']) ) {
	// $pic_url = esc_url( get_avatar_url( get_the_author_meta('ID', $curauth->ID),'90' ) );
	$pic_url = '';
	$add_style = 'style="display: none"';
	
} else {
	$pic_url = $pic_data['url'];
	$add_style2 = 'style="margin-top:-75px"';
}

?>

<?php do_action('kanews_header_ad'); ?>

<main id="main" class="site-main">
	<div class="container">
		<div class="row">
			<div class="kanews-widget-area kanews-widgets-content">

        <div class="col-12 col-lg-8 m-auto">
					<div class="kanews-profile-wrapper kanews-section">
						<div class="kanews-profile-cover kanews-lazy" <?php echo $add_style; ?> data-bg="<?php echo esc_url($pic_url); ?>"></div>
						<div class="kanews-profile-avatar" <?php echo $add_style2; ?>><?php echo kanews_user_avatar(get_the_author_meta('ID', $curauth->ID),'90'); ?></div>
						<div class="kanews-profile-content">
							<div class="kanews-profile-name"><?php echo esc_html(get_the_author_meta('display_name', $curauth->ID)); ?> <?php echo kanews_user_subscribe_badge($curauth->ID); ?></div>
							<div class="kanews-profile-about"><?php echo esc_html(get_the_author_meta('description', $curauth->ID)); ?></div>
							<ul class="kanews-profile-info d-flex flex-wrap">
								<?php if( kanews_get_option('scoring_system') ) : ?>
								<li><?php echo sprintf(esc_html__('%s Puan', 'kanews'), get_user_meta( $curauth->ID, 'kan_user_score', true ) ? get_user_meta( $curauth->ID, 'kan_user_score', true ) : '0'); ?></li>
								<?php endif; ?>
								<li><?php echo sprintf(esc_html__('%s Yazı', 'kanews'), count_user_posts( $curauth->ID, array('post', 'columist') )); ?></li>
								<li><?php echo sprintf(esc_html__('%s Yorum', 'kanews'), kanews_get_comments_count_by_user($curauth->ID)); ?></li>
							</ul>
							<div class="kanews-profile-links d-flex flex-wrap">
								<?php if( kanews_get_option('follow-authors', false) && get_current_user_id() != $curauth->ID ) :
									$user_cats 	  = get_user_option( 'kanews_subscribe_authors', get_current_user_id() ) ? get_user_option( 'kanews_subscribe_authors', get_current_user_id() ) : array('');
									$follow_class = in_array($curauth->ID, $user_cats) ? 'category-subscribed' : '';
									$follow_text  = ($follow_class == 'category-subscribed') ? esc_html__( 'Takip Ediliyor', 'kanews' ) : esc_html__( 'Takip Et', 'kanews' );
									?>
									<button data-author="true" data-user-id="<?php echo $curauth->ID; ?>" class="kanews-category-subscribe-button hf1s <?php echo $follow_class; ?>"><?php echo $follow_text; ?> <div id="kanews-loader"></div></button>
								<?php endif; ?>
								<?php echo user_badge($curauth->ID); ?>
								<?php echo kanews_get_user_social_links($curauth->ID, true, 'kanews-profile-link'); ?>
							</div>
						</div>
					</div>
					<?php $title = sprintf(esc_html__('%s - Tüm Yazıları', 'kanews'), get_the_author_meta('display_name', $curauth->ID)) ?>
					<div class="row">
						<?php 
							kanews_recent_posts('author', $title, 'h1'); 
						?>
					</div>
				</div>

				
				<div class="col-12 col-lg-4 kanews-sticky">
					<?php
					$slick_options = [
						'slidesToShow'  => 1,
						'dots'  => true,
						'adaptiveHeight'  => false,
						'arrows'			  => 1,
						'autoplay'			=> 1,
					];
					$query_args = array(
						'number'				=> 5,
						'author'				=> $curauth->ID,
						'sortby' 				=> 'post-viewed',
						'range'				  => 'month',
					);
					$kanews_query = kan_query( $query_args );
					if ( ! $kanews_query->have_posts()) {
						$query_args = array(
							'number'				=> 5,
							'post_type'				=> array('post', 'columist'),
							'author'				=> $curauth->ID,
							'sortby' 				=> 'post-viewed'
						);
						$kanews_query = kan_query( $query_args );
					}
					
					if ($kanews_query->have_posts()): ?>
						<div class="kanews-section widget_recent_entries widget">
							<?php echo kanews_widget_title(esc_html__( 'Popüler Yazıları', 'kanews' )); ?>
							<ul>
								<?php while($kanews_query->have_posts()): $kanews_query->the_post(); global $post;  ?>
								<li>
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>	
									<span class="post-date"><?php the_date(); ?></span>
								</li>
								<?php endwhile;  wp_reset_postdata(); ?>
							</ul>
						</div>
					<?php endif; ?>

					<?php $qargs = array (
						'role__in' => array('contributor', 'author', 'editor', 'columist' ),
						'number'   => 10,
						'orderby' => 'rand',
						'exclude'  =>  $curauth->ID,
					);
					
					$wp_user_query = new WP_User_Query( $qargs );
					$authors = $wp_user_query->get_results(); 
					if($authors): ?>
					
						<div class="kanews-section">
							<?php echo kanews_widget_title(esc_html__( 'Diğer Yazarlar', 'kanews' ));?>
							<a class="kanews-headline-link" href="<?php echo esc_url( get_post_type_archive_link( 'columist' ) ); ?>"><?php esc_html_e( 'Tüm Yazarlar', 'kanews' ); ?></a>
					
							<div class="kanews-profile-authors">
								<?php foreach ( $authors as $author ) { 	?>
									
									<a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID', $author->ID ) )); ?>" class="kanews-profile-author">
										<div class="kanews-profile-author-45141 d-flex align-items-center">
											<div class="kanews-profile-author-avatar">
												<?php echo kanews_user_avatar(get_the_author_meta('ID', $author->ID),'48'); ?>
												</div>
												<div class="kanews-profile-author-515123">
													<div class="kanews-profile-author-name truncate truncate-2">
														<?php if(get_the_author_meta('first_name', $author->ID) && get_the_author_meta('last_name', $author->ID)): ?>
															<?php echo esc_html(get_the_author_meta('first_name', $author->ID)); ?> <?php echo esc_html(get_the_author_meta('last_name', $author->ID)); ?>
														<?php else: ?>
															<?php echo esc_html(get_the_author_meta('display_name', $author->ID)); ?>
														<?php endif; ?>
													</div>
												</div>
										</div>
										<div class="kanews-profile-author-5141241"></div>
									</a>
	
								<?php } ?>
							</div>
						</div>
					<?php endif; ?>

				</div>
			</div>
		</div>
	</main>

<?php get_footer(); ?>