const installButton = document.getElementById('install-app');
let beforeInstallPromptEvent
window.addEventListener('beforeinstallprompt', function(e) {
    e.preventDefault();
    beforeInstallPromptEvent = e
    installButton.style.display = 'block'
    installButton.addEventListener('click', function() {
        e.prompt();
    });
    installButton.hidden = false;

    (function($) {
        "use strict";
                var data    = $('#kanews-install-app'),
                        delay   = data.data('delay'),
                        expired = data.data('expired'),
                        cookie  = 'kan_install_app'
        
                if( ! Cookies.get(cookie) ) {
                    Cookies.set(cookie, 'active')
                }
        
                if( Cookies.get(cookie) == 'active' ) {
                    data.delay(delay).fadeIn(300,function(){
                        data.addClass('is-active')
                    })
                    data.find('.kanews-modal-close-btn').click(function(){
                        Cookies.set(cookie, 'disable', {expires:expired})
                    })
                }
            })(jQuery);
});
installButton.addEventListener('click', function() {
    beforeInstallPromptEvent.prompt();
});