<?php

if(kanews_get_amp_option('amp-related') != true)
return false;

$category_ids = wp_get_post_categories( get_the_ID() );
$sortby = kanews_get_amp_option('amp-related-sortby') ? kanews_get_amp_option('amp-related-sortby') : 'random';
$related_count = kanews_get_amp_option('amp-related-count') ? kanews_get_amp_option('amp-related-count') : 3;

$query_args = array(
	'number'				=> $related_count,
	'sortby' 				=> $sortby,
	'cats' 				  => $category_ids,
);
$kanews_query = kan_query( $query_args );

if( $kanews_query->have_posts() ) {
	?>
    <div class="amp-wp-section">
			<?php echo kanews_widget_title(kanews_translate('related-posts-text', esc_html__('Benzer Haberler', 'kanews'), 'h3')); ?>
			<div class="amp-wp-related-posts row">
				<?php
				while ( $kanews_query->have_posts() ) {
					$kanews_query->the_post(); global $post; ?>
					<div class="col-6 col-md-4">
						<article class="kanews-post-item">
							<?php kanews_amp_post_thumbnail(); ?>
							<div class="kanews-post-content">
								<a href="<?php echo amp_get_permalink(get_the_ID()); ?>" title="<?php the_title(); ?>" class="amp-wp-related-post-title kanews-post-headline">
								<?php the_title(); ?>
								</a>
							</div>
						</article>
					</div>
				<?php } ?>
      </div>
    </div>
	<?php
}

wp_reset_postdata();
?>