<?php
/**
 * HTML start template part.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */
$font = get_theme_mod('kanews_theme_font');
$first_big = ucwords(strtolower($font));
$first_word2 = ucwords(strtolower($first_big), '_');
$bul = '_';
$degistir = '+';
$font_final = str_replace($bul, $degistir, $first_word2);
if ($font_final == '') {
$font_final = 'Inter';
}
?>
<!doctype html>
<html amp <?php echo AMP_HTML_Utils::build_attributes_string( $this->get( 'html_tag_attributes' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1">
	<?php
	do_action( 'amp_post_template_head', $this );
	?>
	<style class="style-template-part">
		<?php $this->load_parts( [ 'style' ] ); ?>
	</style>
	<style class="amp-post-template-css-action">
		<?php
		do_action( 'amp_post_template_css', $this );
		?>
	</style>
	<script async custom-element="amp-form" src="https://cdn.ampproject.org/v0/amp-form-0.1.js"></script>
	<script async custom-element="amp-social-share" src="https://cdn.ampproject.org/v0/amp-social-share-0.1.js"></script>
	<?php if ( kanews_get_amp_option( 'amp-ad-single-below-switch' ) == true || kanews_get_amp_option( 'amp-ad-single-above-switch' ) == true || kanews_get_amp_option( 'amp-ad-header-switch' ) == true || kanews_get_amp_option( 'amp-ad-footer-switch' ) == true ): ?>
		<script async custom-element="amp-ad" src="https://cdn.ampproject.org/v0/amp-ad-0.1.js"></script>
	<?php endif; ?>
	<?php if ( kanews_get_amp_option( 'amp-auto-ads-switch' ) == true ): ?>
    <script async custom-element="amp-auto-ads" src="https://cdn.ampproject.org/v0/amp-auto-ads-0.1.js"></script>
	<?php endif; ?>

</head>

<?php
$dark_mode = '';
if(isset($_COOKIE["kanews_dark_mode"]))
$dark_mode = $_COOKIE["kanews_dark_mode"] == 'on' ? 'checked' : '';
?>

<body class="<?php echo esc_attr( $this->get( 'body_class' ) ); ?>">

	<?php if(kanews_get_option('mode') != false || kanews_get_option('mode') == NULL): ?>
		<input type="checkbox" <?php echo $dark_mode; ?> hidden="hidden" id="dark-mode-checkbox">
	<?php endif; ?>

	<div class="amp-wrapper">
		<?php do_action( 'amp_post_template_body_open', $this );