<?php
defined( 'ABSPATH' ) or die( 'Not Authorized!' );

class Kanews_Stories_Admin {

    public function __construct() {
			// Check if the theme is enabled
			if( ! class_exists( 'KANEWS_WEATHER' ) ){
				return;
			}	
			self::plugin_options();
    }
		
		function plugin_options() {
			//
			// Set a unique slug-like ID
			$prefix = 'kanews_stories';

			//
			// Create options
			CSF::createOptions( $prefix, array(
				'menu_title' => 'Kanews Hikayeler',
				'menu_slug'  => 'kanews-stories',
				    'menu_type'           => 'submenu',
    'menu_parent'         => 'kanews-options',
			) );

			//
			// Create a section
			CSF::createSection( $prefix, array(
				'title'  => 'Tab Title 1',
				'fields' => array(

					array(
						'id'			=> 'kanews_stories',
						'title'			=> __('Hikayeleri Göster', WPS_TEXT_DOMAIN),
						'type'     => 'switcher',
						'default'  => false,
					),
					array(
						'id'      => 'kanews_stories_style',
						'type'    => 'select',
						'default'    => '1',
						'title'   => esc_html__('Görünüm', WPS_TEXT_DOMAIN),
						'options' => array(
							'1' => esc_html__('Görünüm', WPS_TEXT_DOMAIN).' #1',
							'2' => esc_html__('Görünüm', WPS_TEXT_DOMAIN).' #2',
						)
					),
					array(
						'id'			=> 'kanews_stories_hide_title',
						'title'			=> __('Hikaye Kategori Başlıklarını Gizle', WPS_TEXT_DOMAIN),
						'type'     => 'switcher',
						'default'  => false,
					),
					array(
						'id'			=> 'kanews_stories_post',
						'title'			=> __('Gösterilecek Hikaye Sayısı', WPS_TEXT_DOMAIN),
						'description'			=> __('Kategori başına gösterilecek hikaye sayısı.', WPS_TEXT_DOMAIN),
						'type'     => 'slider',
						'min'      => 0,
						'max'      => 20,
						'step'     => 1,
						'default'  => 5,
					),
					array(
						'id'		=> 'kanews_stories_time',
						'title'		=>  __( 'Son 24 Saati Baz Alsın' , WPS_TEXT_DOMAIN ),
						'description'		=>  __( 'On durumunda oluşturduğunuz kategorilerde son 24 saatte paylaşılan yazılar eklenir, off durumunda oluşturduğunuz kategorilerde yazıların yayınlanma tarihine bakılmaksızın son yazılar hikaye olarak eklenir.' , WPS_TEXT_DOMAIN ),
						'type'  => 'switcher',
						'default' => false,
					),
					array(
						'id'			=> 'kanews_stories_dr',
						'title'			=> __('Geçiş Süresi', WPS_TEXT_DOMAIN),
						'description'			=> __('Hikayeler arası geçiş süresini ayarlayın (saniye)', WPS_TEXT_DOMAIN),
						'type'     => 'slider',
						'min'      => 0,
						'max'      => 60,
						'step'     => 1,
						'default'  => 5,
					),
					array(
						'id'			=> 'kanews_stories_dr',
						'title'			=> __('Kategorilerde Yazıların Sıralanışı', WPS_TEXT_DOMAIN),
						'type'     => 'slider',
						'min'      => 0,
						'max'      => 60,
						'step'     => 1,
						'default'  => 5,
					),
					
					array(
						'id'      => 'kanews_stories_order',
						'type'    => 'select',
						'title'			=> __('Kategori Yazılarının Sıralanışı', WPS_TEXT_DOMAIN),
						'options' => array(
							'' => esc_html__('Yayınlanma Tarihine Göre', 'kanews'),
							'modified' => esc_html__('Düzenlenme Tarihine Göre', 'kanews'),
						),
						'default' => 'modified'
					),

					
					array(
						'id'		=> 'kanews_story_cats',
						'title'		=> __( 'Hikaye Kategorisi Oluşturun', WPS_TEXT_DOMAIN ),
						'type'		=> 'group',
						'fields' => array(
							array(
								'id'          => 'title',
								'title'       => __( 'Başlık', WPS_TEXT_DOMAIN ),
								'type'        => 'text',
							),
							array(
								'id'          => 'id',
								'title'       => __( 'Kategori Seç', WPS_TEXT_DOMAIN ),
								'default'         => '',
								  'placeholder' => 'Select a category',

								'type'        => 'select',
								'options'        => 'category',
							),							
							array(
								'id'          => 'uid',
								'title'       => __( 'Yazar Seç', WPS_TEXT_DOMAIN ),
								'default'     => '',
								  'placeholder' => 'Select a author',

								'type'        => 'select',
								'options'     => 'users',
							),
							array(
								'id'      => 'color',
								'type'    => 'color',
								'title'   => esc_html__('Kategori Rengi', WPS_TEXT_DOMAIN)
							),
							array(
								'id'          => 'image',
								'title'       => __( 'Kategori Görseli', WPS_TEXT_DOMAIN ),
								'description'			=> __('Görsel boyutunun <code>90x90</code> ebatlarında olması tavsiye edilir.', WPS_TEXT_DOMAIN),
								'default'         => '',
								'type'        => 'upload',
								'operator'    => 'and'
							),
						)
					),
					
					
					array(
						'id'		=> 'kanews_story_site',
						'title'		=> __( 'Özel Hikayeler', WPS_TEXT_DOMAIN ),
						'description'		=> __( 'Bu kısımda blog kategorilerinin dışında özel hikayeler oluşturabilirsiniz.', WPS_TEXT_DOMAIN ),
						'type'		=> 'group',
						'fields' => array(
						array(
							'id'          => 'title',
							'title'       => __( 'Hikaye Kategori Adı', WPS_TEXT_DOMAIN ),
							'default'     => '',
							'type'        => 'text',
						),
						array(
								'id'      => 'color',
								'type'    => 'color',
								'title'   => esc_html__('Hikaye Kategori Rengi', WPS_TEXT_DOMAIN)
							),
						array(
							'id'          => 'image',
							'title'       => __( 'Hikaye Kategori Görseli', WPS_TEXT_DOMAIN ),
							'description'			=> __('Görsel boyutunun <code>90x90</code> ebatlarında olması tavsiye edilir.', WPS_TEXT_DOMAIN),
							'default'         => '',
							'type'        => 'upload',
							'operator'    => 'and'
						),
						array(
							'id'		=> 'stories',
							'title'		=> __( 'Hikaye Ekle', WPS_TEXT_DOMAIN ),
							'type'		=> 'group',
							'fields' => array(
								array(
									'id'          => 'title',
									'title'       => __( 'Başlık', WPS_TEXT_DOMAIN ),
									'type'        => 'text',
								),
								array(
									'id'		=> 'link',
									'title'		=> __( 'Link', WPS_TEXT_DOMAIN ),
									'type'		=> 'text',
								),
								array(
									'id'          => 'image',
									'title'       => __( 'Hikaye Görseli', WPS_TEXT_DOMAIN ),
									'default'         => '',
									'type'        => 'upload',
								),
								array(
									'id'          => 'date',
									'title'       => __( 'Hikaye Tarihi', WPS_TEXT_DOMAIN ),
									'default'         => '',
									'type'        => 'date',
								),
							)
						),
						
						)
					),
					
						
						array(
							'type'    => 'subheading',
							'content' => esc_html__('Hazır Ayarlar', 'kanews'),
						),
						array(
							'type'    => 'content',
							'content' => '
								<p>
								<a target="_blank" href="https://www.kanthemes.com.tr/files/kanews/demo/spor/options2.txt" class="button">Spor Demo</a>
								</p>
								',
						),
						
						array(
							'type' => 'backup',
						),
						
								
					

				)
			) );

		}

}

add_filter( 'init', 'Kanews_Stories_Admin_init' );
function Kanews_Stories_Admin_init(){
	if( ! class_exists( 'CSF' ) )
		return;
	new Kanews_Stories_Admin();
}
