<?php
/**
 * Main dashboard template
 */
?>
<div class="wrap">
	<h1 class="cs-vui-title"><?php _e( 'JetEngine dashboard', 'jet-engine' ); ?></h1>
	<div id="jet_engine_dashboard">
		<div class="cx-vui-panel">
			<cx-vui-tabs
				:in-panel="false"
				value="modules"
				layout="vertical"
			>
				<cx-vui-tabs-panel
					name="modules"
					label="<?php _e( 'Modules', 'jet-engine' ); ?>"
					key="modules"
				>
					<cx-vui-checkbox
						name="modules"
						label="<?php _e( 'Available Modules', 'jet-engine' ); ?>"
						description="<?php _e( 'Enable/disable additional JetEngine features', 'jet-engine' ); ?>"
						return-type="array"
						:wrapper-css="[ 'vertical-fullwidth' ]"
						:options-list="availableModules"
						v-model="activeModules"
					></cx-vui-checkbox>
					<cx-vui-component-wrapper
						:wrapper-css="[ 'vertical-fullwidth' ]"
					>
						<cx-vui-button
							button-style="accent"
							:loading="saving"
							@click="saveModules"
						>
							<span
								slot="label"
								v-html="'<?php _e( 'Save', 'jet-engine' ); ?>'"
							></span>
						</cx-vui-button>
						&nbsp;&nbsp;&nbsp;&nbsp;
						<span
							class="cx-vui-inline-notice cx-vui-inline-notice--success"
							v-if="'success' === result"
							v-html="successMessage"
						></span>
						<span
							class="cx-vui-inline-notice cx-vui-inline-notice--error"
							v-if="'error' === result"
							v-html="errorMessage"
						></span>
					</cx-vui-component-wrapper>
				</cx-vui-tabs-panel>
				<cx-vui-tabs-panel
					name="skins"
					label="<?php _e( 'Skins Manager', 'jet-engine' ); ?>"
					key="skins"
				>
					<br>
					<div
						class="cx-vui-subtitle"
						v-html="'<?php _e( 'Skins manager', 'jet-engine' ); ?>'"
					></div>
					<div class="jet-engine-skins-wrap">
						<jet-engine-skin-import></jet-engine-skin-import>
						<jet-engine-skin-export></jet-engine-skin-export>
					</div>
				</cx-vui-tabs-panel>
				<?php do_action( 'jet-engine/dashboard/tabs' ); ?>
			</cx-vui-tabs>
		</div>
	</div>
</div>