<?php
namespace Elementor;

use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Jet_Engine_Booking_Form_Widget extends Widget_Base {

	private $source = false;

	public function get_name() {
		return 'jet-engine-booking-form';
	}

	public function get_title() {
		return __( 'Form', 'jet-engine' );
	}

	public function get_icon() {
		return 'jet-engine-icon-forms';
	}

	public function get_categories() {
		return array( 'jet-listing-elements' );
	}

	public function get_help_url() {
		return 'https://crocoblock.com/knowledge-base/articles/how-to-enable-booking-forms-functionality-in-jetengine/?utm_source=jetengine&utm_medium=booking-form&utm_campaign=need-help';
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_general',
			array(
				'label' => __( 'Content', 'jet-engine' ),
			)
		);

		$this->add_control(
			'_form_id',
			array(
				'label'   => __( 'Select form', 'jet-engine' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => jet_engine()->forms->get_forms_for_options(),
			)
		);

		$this->add_control(
			'fields_layout',
			array(
				'label'   => __( 'Fields layout', 'jet-engine' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'column',
				'options' => array(
					'column' => __( 'Column', 'jet-engine' ),
					'row'    => __( 'Row', 'jet-engine' ),
				),
			)
		);

		$this->add_control(
			'submit_type',
			array(
				'label'   => __( 'Submit type', 'jet-engine' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'reload',
				'options' => array(
					'reload' => __( 'Reload', 'jet-engine' ),
					'ajax'   => __( 'AJAX', 'jet-engine' ),
				),
			)
		);

		$this->add_control(
			'cache_form',
			array(
				'label'        => esc_html__( 'Cache form output', 'jet-engine' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => '',
				'label_on'     => esc_html__( 'Yes', 'jet-engine' ),
				'label_off'    => esc_html__( 'No', 'jet-engine' ),
				'return_value' => 'yes',
				'default'      => '',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_rows_style',
			array(
				'label'      => __( 'Rows', 'jet-engine' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			)
		);

		$this->add_control(
			'rows_divider',
			array(
				'label'        => esc_html__( 'Divider between rows', 'jet-engine' ),
				'type'         => Controls_Manager::SWITCHER,
				'description'  => '',
				'label_on'     => esc_html__( 'Yes', 'jet-engine' ),
				'label_off'    => esc_html__( 'No', 'jet-engine' ),
				'return_value' => 'yes',
				'default'      => '',
			)
		);

		$this->add_responsive_control(
			'rows_divider_height',
			array(
				'label'      => __( 'Height', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 20,
					),
				),
				'selectors'  => array(
					$this->css_selector( '__divider' ) => 'height: {{SIZE}}{{UNIT}};',
				),
				'condition' => array(
					'rows_divider' => 'yes',
				),
			)
		);

		$this->add_control(
			'rows_divider_color',
			array(
				'label' => __( 'Color', 'jet-engine' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__divider' ) => 'background-color: {{VALUE}}',
				),
				'condition' => array(
					'rows_divider' => 'yes',
				),
			)
		);

		$this->add_responsive_control(
			'rows_gap',
			array(
				'label'      => __( 'Rows Gap', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					$this->css_selector( '-row' ) => 'padding-top: calc( {{SIZE}}{{UNIT}}/2 ); padding-bottom: calc( {{SIZE}}{{UNIT}}/2 )',
				),
			)
		);

		$this->add_responsive_control(
			'cols_gap',
			array(
				'label'      => __( 'Columns Gap', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'selectors'  => array(
					$this->css_selector( '-row' ) => 'margin-left: calc( -{{SIZE}}{{UNIT}}/2 ); margin-right: calc( -{{SIZE}}{{UNIT}}/2 )',
					$this->css_selector( '-col' ) => 'padding-left: calc( {{SIZE}}{{UNIT}}/2 ); padding-right: calc( {{SIZE}}{{UNIT}}/2 )',
				),
			)
		);

		$this->add_control(
			'label_styles',
			array(
				'label'     => esc_html__( 'Labels', 'jet-engine' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'labels_typography',
				'selector' => $this->css_selector( '__label' ),
			)
		);

		$this->add_control(
			'labels_color',
			array(
				'label' => __( 'Color', 'jet-engine' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__label' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'labels_gap',
			array(
				'label'      => __( 'Gap', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					$this->css_selector( '__label' ) => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'labels_width',
			array(
				'label'      => __( 'Width', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( '%' ),
				'range'      => array(
					'%' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'default' => array(
					'size'  => 30,
				),
				'selectors'  => array(
					$this->css_selector( '.layout-row .jet-form-col__start' ) => 'max-width: {{SIZE}}%; -ms-flex: 0 0 {{SIZE}}%; flex: 0 0 {{SIZE}}%;',
				),
				'condition' => array(
					'fields_layout' => 'row',
				),
			)
		);

		$this->add_control(
			'desc_styles',
			array(
				'label'     => esc_html__( 'Descriptions', 'jet-engine' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'desc_typography',
				'selector' => $this->css_selector( '__desc' ),
			)
		);

		$this->add_control(
			'desc_color',
			array(
				'label' => __( 'Color', 'jet-engine' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__desc' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'desc_gap',
			array(
				'label'      => __( 'Gap', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					$this->css_selector( '__desc' ) => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'labels_h_alignment',
			array(
				'label'       => __( 'Horizontal Alignment', 'jet-engine' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'default'     => 'left',
				'separator'   => 'before',
				'options'     => array(
					'left' => array(
						'title' => __( 'Left', 'jet-engine' ),
						'icon' => 'eicon-h-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'jet-engine' ),
						'icon' => 'eicon-h-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'jet-engine' ),
						'icon' => 'eicon-h-align-right',
					),
				),
				'selectors'  => array(
					$this->css_selector( '__label' ) => 'text-align: {{VALUE}};',
					$this->css_selector( '__desc' ) => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'labels_v_alignment',
			array(
				'label'       => __( 'Vertical Alignment', 'jet-engine' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'default'     => 'flex-start',
				'options'     => array(
					'flex-start' => array(
						'title' => __( 'Top', 'jet-engine' ),
						'icon' => 'eicon-v-align-top',
					),
					'center' => array(
						'title' => __( 'Middle', 'jet-engine' ),
						'icon' => 'eicon-v-align-middle',
					),
					'flex-end' => array(
						'title' => __( 'Bottom', 'jet-engine' ),
						'icon' => 'eicon-v-align-bottom',
					),
				),
				'selectors'  => array(
					$this->css_selector( '-col' ) => 'align-items: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_fields_style',
			array(
				'label'      => __( 'Fields', 'jet-engine' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'fields_typography',
				'selector' => $this->css_selector( ' .jet-form__field:not(.checkradio-field)' ),
			)
		);

		$this->add_control(
			'fields_color',
			array(
				'label'     => __( 'Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' .jet-form__field:not(.checkradio-field)' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'fields_placeholder_color',
			array(
				'label'     => __( 'Placeholder Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' ::-webkit-input-placeholder' ) => 'color: {{VALUE}}',
					$this->css_selector( ' ::-moz-placeholder' ) => 'color: {{VALUE}}',
					$this->css_selector( ' :-ms-input-placeholder' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'fields_background_color',
			array(
				'label'     => __( 'Background Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' .jet-form__field:not(.checkradio-field)' ) => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'fields_padding',
			array(
				'label'      => __( 'Padding', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__field:not(.checkradio-field)' ) => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'fields_margin',
			array(
				'label'      => __( 'Margin', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__field:not(.checkradio-field)' ) => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'           => 'fields_border',
				'label'          => __( 'Border', 'jet-engine' ),
				'placeholder'    => '1px',
				'selector'       => $this->css_selector( ' .jet-form__field:not(.checkradio-field)' ),
			)
		);

		$this->add_responsive_control(
			'fields_border_radius',
			array(
				'label'      => __( 'Border Radius', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__field:not(.checkradio-field)' ) => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'fields_box_shadow',
				'selector' => $this->css_selector( ' .jet-form__field:not(.checkradio-field)' ),
			)
		);

		$this->add_responsive_control(
			'fields_textarea_height',
			array(
				'label'      => __( 'Textarea Height', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 500,
					),
				),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__field.textarea-field' ) => 'height: {{SIZE}}px;',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_checkradio_fields_style',
			array(
				'label'      => __( 'Checkbox & Radio Fields', 'jet-engine' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			)
		);

		$this->add_responsive_control(
			'checkradio_fields_layout',
			array(
				'label'       => esc_html__( 'Layout', 'jet-engine' ),
				'type'        => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options'     => array(
					'0 1 auto'    => array(
						'title' => esc_html__( 'Horizontal', 'jet-engine' ),
						'icon'  => 'fa fa-ellipsis-h',
					),
					'0 1 100%' => array(
						'title' => esc_html__( 'Vertical', 'jet-engine' ),
						'icon'  => 'fa fa-bars',
					),
				),
				'selectors'   => array(
					$this->css_selector( ' .checkradio-wrap' ) => 'flex: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'checkradio_fields_typography',
				'selector' => $this->css_selector( ' .checkradio-wrap' ),
			)
		);

		$this->add_control(
			'checkradio_fields_color',
			array(
				'label'     => __( 'Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' .checkradio-wrap' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'checkradio_fields_gap',
			array(
				'label'      => __( 'Gap between control and label', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 0,
						'max' => 50,
					),
				),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__field.checkradio-field' ) => 'margin-right: {{SIZE}}px;',
				),
			)
		);

		$this->add_control(
			'checkradio_fields_background_color',
			array(
				'label'     => __( 'Background Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' .checkradio-wrap label' ) => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'checkradio_fields_padding',
			array(
				'label'      => __( 'Padding', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					$this->css_selector( ' .checkradio-wrap label' ) => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'checkradio_fields_margin',
			array(
				'label'      => __( 'Margin', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					$this->css_selector( ' .checkradio-wrap label' ) => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'           => 'checkradio_fields_border',
				'label'          => __( 'Border', 'jet-engine' ),
				'placeholder'    => '1px',
				'selector'       => $this->css_selector( ' .checkradio-wrap label' ),
			)
		);

		$this->add_responsive_control(
			'checkradio_fields_border_radius',
			array(
				'label'      => __( 'Border Radius', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					$this->css_selector( ' .checkradio-wrap label' ) => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_calc_fields_style',
			array(
				'label'      => __( 'Calculated Fields', 'jet-engine' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'calc_fields_typography',
				'selector' => $this->css_selector( '__calculated-field' ),
			)
		);

		$this->add_control(
			'calc_fields_color',
			array(
				'label'     => __( 'Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__calculated-field' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'calc_fields_prefix_color',
			array(
				'label'     => __( 'Prefix Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__calculated-field-prefix' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'calc_fields_prefix_size',
			array(
				'label'      => __( 'Prefix size', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 50,
					),
				),
				'selectors'  => array(
					$this->css_selector( '__calculated-field-prefix' ) => 'font-size: {{SIZE}}px;',
				),
			)
		);

		$this->add_control(
			'calc_fields_suffix_color',
			array(
				'label'     => __( 'Suffix Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__calculated-field-suffix' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'calc_fields_suffix_size',
			array(
				'label'      => __( 'Suffix size', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 50,
					),
				),
				'selectors'  => array(
					$this->css_selector( '__calculated-field-suffix' ) => 'font-size: {{SIZE}}px;',
				),
			)
		);

		$this->add_control(
			'calc_fields_background_color',
			array(
				'label'     => __( 'Background Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__calculated-field' ) => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'calc_fields_padding',
			array(
				'label'      => __( 'Padding', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					$this->css_selector( '__calculated-field' ) => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'calc_fields_margin',
			array(
				'label'      => __( 'Margin', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px' ),
				'selectors'  => array(
					$this->css_selector( '__calculated-field' ) => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'           => 'calc_fields_border',
				'label'          => __( 'Border', 'jet-engine' ),
				'placeholder'    => '1px',
				'selector'       => $this->css_selector( '__calculated-field' ),
			)
		);

		$this->add_responsive_control(
			'calc_fields_border_radius',
			array(
				'label'      => __( 'Border Radius', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					$this->css_selector( '__calculated-field' ) => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_required_style',
			array(
				'label'      => __( 'Required mark', 'jet-engine' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			)
		);

		$this->add_control(
			'required_mark',
			array(
				'label'       => __( 'Required mark', 'jet-engine' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '*',
				'render_type' => 'template',
			)
		);

		$this->add_control(
			'required_mark_color',
			array(
				'label'     => __( 'Color', 'jet-engine' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__required' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_responsive_control(
			'required_size',
			array(
				'label'      => __( 'Size', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 10,
						'max' => 50,
					),
				),
				'selectors'  => array(
					$this->css_selector( '__required' ) => 'font-size: {{SIZE}}px;',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form_submit_style',
			array(
				'label'      => esc_html__( 'Submit', 'jet-engine' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			)
		);

		$this->start_controls_tabs( 'tabs_booking_form_submit_style' );

		$this->start_controls_tab(
			'booking_form_submit_normal',
			array(
				'label' => esc_html__( 'Normal', 'jet-engine' ),
			)
		);

		$this->add_control(
			'booking_form_submit_bg_color',
			array(
				'label'  => esc_html__( 'Background Color', 'jet-engine' ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' .jet-form__submit' ) => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'booking_form_submit_color',
			array(
				'label'  => esc_html__( 'Text Color', 'jet-engine' ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' .jet-form__submit' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'booking_form_submit_hover',
			array(
				'label' => esc_html__( 'Hover', 'jet-engine' ),
			)
		);

		$this->add_control(
			'booking_form_submit_bg_color_hover',
			array(
				'label'  => esc_html__( 'Background Color', 'jet-engine' ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' .jet-form__submit:hover' ) => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'booking_form_submit_color_hover',
			array(
				'label'  => esc_html__( 'Text Color', 'jet-engine' ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( ' .jet-form__submit:hover' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'booking_form_submit_hover_border_color',
			array(
				'label' => esc_html__( 'Border Color', 'jet-engine' ),
				'type' => Controls_Manager::COLOR,
				'condition' => array(
					'booking_form_submit_border_border!' => '',
				),
				'selectors' => array(
					$this->css_selector( ' .jet-form__submit:hover' ) => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'booking_form_submit_typography',
				'selector' => $this->css_selector( ' .jet-form__submit' ),
			)
		);

		$this->add_responsive_control(
			'booking_form_submit_padding',
			array(
				'label'      => esc_html__( 'Padding', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__submit' ) => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'booking_form_submit_margin',
			array(
				'label'      => esc_html__( 'Margin', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__submit' ) => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'           => 'booking_form_submit_border',
				'label'          => esc_html__( 'Border', 'jet-engine' ),
				'placeholder'    => '1px',
				'selector'       => $this->css_selector( ' .jet-form__submit' ),
			)
		);

		$this->add_responsive_control(
			'booking_form_submit_border_radius',
			array(
				'label'      => esc_html__( 'Border Radius', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__submit' ) => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'booking_form_submit_box_shadow',
				'selector' => $this->css_selector( ' .jet-form__submit' ),
			)
		);

		$this->add_responsive_control(
			'booking_form_submit_alignment',
			array(
				'label'   => esc_html__( 'Alignment', 'jet-engine' ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'flex-start',
				'options' => array(
					'flex-start'    => array(
						'title' => esc_html__( 'Left', 'jet-engine' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'jet-engine' ),
						'icon'  => 'fa fa-align-center',
					),
					'flex-end' => array(
						'title' => esc_html__( 'Right', 'jet-engine' ),
						'icon'  => 'fa fa-align-right',
					),
					'stretch' => array(
						'title' => esc_html__( 'Fullwidth', 'jet-engine' ),
						'icon'  => 'fa fa-align-justify',
					),
				),
				'selectors'  => array(
					$this->css_selector( ' .jet-form__submit-wrap' ) => 'align-items: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form_messages_style',
			array(
				'label'      => esc_html__( 'Messages', 'jet-engine' ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'show_label' => false,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'booking_messages_typography',
				'selector' => $this->css_selector( '-message' ),
			)
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			array(
				'name'           => 'booking_messages_border',
				'label'          => esc_html__( 'Border', 'jet-engine' ),
				'placeholder'    => '1px',
				'selector'       => $this->css_selector( '-message' ),
			)
		);

		$this->add_responsive_control(
			'booking_messages_border_radius',
			array(
				'label'      => esc_html__( 'Border Radius', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					$this->css_selector( '-message' ) => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->start_controls_tabs( 'tabs_booking_messages_style' );

		$this->start_controls_tab(
			'booking_messages_success',
			array(
				'label' => esc_html__( 'Success', 'jet-engine' ),
			)
		);

		$this->add_control(
			'booking_messages_success_bg',
			array(
				'label'  => esc_html__( 'Background Color', 'jet-engine' ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '-message.jet-form-message--success' ) => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'booking_messages_success_color',
			array(
				'label'  => esc_html__( 'Text Color', 'jet-engine' ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '-message.jet-form-message--success' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'booking_messages_success_border_color',
			array(
				'label' => esc_html__( 'Border Color', 'jet-engine' ),
				'type' => Controls_Manager::COLOR,
				'condition' => array(
					'booking_messages_border_border!' => '',
				),
				'selectors' => array(
					$this->css_selector( '-message.jet-form-message--success' ) => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'booking_messages_box_shadow_success',
				'selector' => $this->css_selector( '-message.jet-form-message--success' ),
			)
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'booking_messages_error',
			array(
				'label' => esc_html__( 'Error', 'jet-engine' ),
			)
		);

		$this->add_control(
			'booking_messages_error_bg',
			array(
				'label'  => esc_html__( 'Background Color', 'jet-engine' ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '-message.jet-form-message--error' ) => 'background-color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'booking_messages_error_color',
			array(
				'label'  => esc_html__( 'Text Color', 'jet-engine' ),
				'type'   => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '-message.jet-form-message--error' ) => 'color: {{VALUE}}',
				),
			)
		);

		$this->add_control(
			'booking_messages_error_border_color',
			array(
				'label' => esc_html__( 'Border Color', 'jet-engine' ),
				'type' => Controls_Manager::COLOR,
				'condition' => array(
					'booking_messages_border_border!' => '',
				),
				'selectors' => array(
					$this->css_selector( '-message.jet-form-message--error' ) => 'border-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'booking_messages_box_shadow_error',
				'selector' => $this->css_selector( '-message.jet-form-message--error' ),
			)
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'booking_messages_padding',
			array(
				'label'      => esc_html__( 'Padding', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					$this->css_selector( '-message' ) => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'booking_messages_margin',
			array(
				'label'      => esc_html__( 'Margin', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					$this->css_selector( '-message' ) => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'booking_messages_alignment',
			array(
				'label'   => esc_html__( 'Alignment', 'jet-engine' ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => array(
					'left'    => array(
						'title' => esc_html__( 'Left', 'jet-engine' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'jet-engine' ),
						'icon'  => 'fa fa-align-center',
					),
					'right' => array(
						'title' => esc_html__( 'Right', 'jet-engine' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'selectors'  => array(
					$this->css_selector( '-message' ) => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'field_messages',
			array(
				'label'     => esc_html__( 'Field Messages', 'jet-engine' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$this->add_responsive_control(
			'field_messages_font_size',
			array(
				'label'      => __( 'Font Size', 'jet-engine' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array(
					'px' => array(
						'min' => 9,
						'max' => 50,
					),
				),
				'selectors'  => array(
					$this->css_selector( '__field-error' ) => 'font-size: {{SIZE}}px;',
				),
			)
		);

		$this->add_control(
			'field_messages_color',
			array(
				'label' => esc_html__( 'Color', 'jet-engine' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => array(
					$this->css_selector( '__field-error' ) => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'field_messages_margin',
			array(
				'label'      => esc_html__( 'Margin', 'jet-engine' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					$this->css_selector( '__field-error' ) => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'field_messages_alignment',
			array(
				'label'   => esc_html__( 'Alignment', 'jet-engine' ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'left',
				'options' => array(
					'left'    => array(
						'title' => esc_html__( 'Left', 'jet-engine' ),
						'icon'  => 'fa fa-align-left',
					),
					'center' => array(
						'title' => esc_html__( 'Center', 'jet-engine' ),
						'icon'  => 'fa fa-align-center',
					),
					'right' => array(
						'title' => esc_html__( 'Right', 'jet-engine' ),
						'icon'  => 'fa fa-align-right',
					),
				),
				'selectors'  => array(
					$this->css_selector( '__field-error' ) => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

	}

	/**
	 * Returns CSS selector for nested element
	 *
	 * @param  [type] $el [description]
	 * @return [type]     [description]
	 */
	public function css_selector( $el = null ) {
		return sprintf( '{{WRAPPER}} .jet-form%s', $el );
	}

	protected function render() {

		$settings = $this->get_settings();
		$form_id  = isset( $settings['_form_id'] ) ? absint( $settings['_form_id'] ) : false;

		if ( ! $form_id ) {
			_e( 'Please, select form to show', 'jet-engine' );
			return;
		}

		$fields_layout = isset( $settings['fields_layout'] ) ? esc_attr( $settings['fields_layout'] ) : 'column';
		$required_mark = isset( $settings['required_mark'] ) ? esc_attr( $settings['required_mark'] ) : '';
		$submit_type   = isset( $settings['submit_type'] ) ? esc_attr( $settings['submit_type'] ) : 'reload';
		$rows_divider  = isset( $settings['rows_divider'] ) ? $settings['rows_divider'] : '';
		$cache         = isset( $settings['cache_form'] ) ? $settings['cache_form'] : '';
		$cache         = filter_var( $cache, FILTER_VALIDATE_BOOLEAN );
		$force_update  = ! $cache;
		$rows_divider  = filter_var( $rows_divider, FILTER_VALIDATE_BOOLEAN );
		$messages      = jet_engine()->forms->get_messages_builder( $form_id );
		$builder       = jet_engine()->forms->get_form_builder( $form_id, false, array(
			'fields_layout' => $fields_layout,
			'rows_divider'  => $rows_divider,
			'required_mark' => $required_mark,
			'submit_type'   => $submit_type,
			'messages'      => $messages,
		) );

		$builder->render_form( $force_update );

		if ( 'ajax' === $submit_type ) {
			$messages->set_is_ajaxified( true );
		}
		$messages->render_messages();

		if ( \Elementor\Plugin::instance()->editor->is_edit_mode() ) {
			$messages->render_messages_samples();
		}

	}

}
