<?php
/**
 * Class description
 *
 * @package   package_name
 * @author    Cherry Team
 * @license   GPL-2.0+
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'Jet_Engine_Frontend' ) ) {

	/**
	 * Define Jet_Engine_Frontend class
	 */
	class Jet_Engine_Frontend {

		private $listing_id = null;
		private $processed_listing_id = null;

		/**
		 * Constructor for the class
		 */
		public function __construct() {
			add_action( 'elementor/frontend/after_enqueue_scripts', array( $this, 'frontend_scripts' ) );
			add_action( 'elementor/frontend/after_enqueue_styles', array( $this, 'frontend_styles' ) );
			add_action( 'elementor/preview/enqueue_scripts', array( $this, 'preview_scripts' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'maybe_enqueue_listing_css' ) );
			add_action( 'jet-engine/locations/enqueue-location-css', array( $this, 'loc_enqueue_listing_css' ) );
		}

		/**
		 * Preview scripts
		 *
		 * @return [type] [description]
		 */
		public function preview_scripts() {

			wp_enqueue_script( 'jquery-slick' );
			wp_enqueue_script( 'imagesloaded' );
			wp_enqueue_script( 'jet-engine-frontend' );
		}

		/**
		 * Enqueues masonry assets
		 *
		 * @return [type] [description]
		 */
		public function enqueue_masonry_assets() {
			wp_enqueue_script( 'imagesloaded' );
		}

		/**
		 * Enqueue front-end styles
		 *
		 * @return [type] [description]
		 */
		public function frontend_styles() {
			wp_enqueue_style( 'jet-engine-frontend' );
		}

		/**
		 * Register front-end assets
		 *
		 * @return [type] [description]
		 */
		public function frontend_scripts() {

			wp_enqueue_script(
				'jet-engine-frontend',
				jet_engine()->plugin_url( 'assets/js/frontend.js' ),
				array( 'jquery', 'elementor-frontend' ),
				jet_engine()->get_version(),
				true
			);

			wp_localize_script( 'jet-engine-frontend', 'JetEngineSettings', array(
				'ajaxurl' => esc_url( admin_url( 'admin-ajax.php' ) ),
			) );

		}

		/**
		 * Set currently processing listing ID
		 * @param [type] $listing_id [description]
		 */
		public function set_listing( $listing_id = null ) {
			$this->listing_id = $listing_id;
		}

		/**
		 * Unset information about current listing
		 *
		 * @return [type] [description]
		 */
		public function reset_listing() {
			$this->reset_data();
			$this->listing_id = null;
		}

		/**
		 * Get listing item content
		 *
		 * @param  [type] $post [description]
		 * @return [type]       [description]
		 */
		public function get_listing_item( $post ) {

			$this->setup_data( $post );

			$listing_id = apply_filters( 'jet-engine/listings/frontend/rendered-listing-id', $this->listing_id );

			if ( jet_engine()->blocks_views && jet_engine()->blocks_views->is_blocks_listing( $listing_id ) ) {
				return jet_engine()->blocks_views->render->get_listing_content( $listing_id );
			} else {

				$this->processed_listing_id = $listing_id;
				add_filter( 'elementor/frontend/the_content', array( $this, 'add_link_to_content' ) );
				$content = Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $listing_id );
				remove_filter( 'elementor/frontend/the_content', array( $this, 'add_link_to_content' ) );
				$this->processed_listing_id = null;

				return $content;
			}

		}

		/**
		 * Add listing link to content
		 *
		 * @param [type] $content [description]
		 */
		public function add_link_to_content( $content ) {

			if ( ! $this->processed_listing_id ) {
				return $content;
			}

			$document = Elementor\Plugin::$instance->documents->get_doc_for_frontend( $this->processed_listing_id );

			if ( ! $document ) {
				return $content;
			}

			$settings = $document->get_settings();

			if ( empty( $settings ) || empty( $settings['listing_link'] ) ) {
				return $content;
			}

			$source = ! empty( $settings['listing_link_source'] ) ? $settings['listing_link_source'] : '_permalink';

			if ( '_permalink' === $source ) {
				$url = jet_engine()->listings->data->get_current_object_permalink();
			} elseif ( 'options_page' === $source ) {
				$option = ! empty( $settings['dynamic_link_option'] ) ? $settings['dynamic_link_option'] : false;
				$url    = jet_engine()->listings->data->get_option( $option );
			} elseif ( $source ) {
				$url = jet_engine()->listings->data->get_meta( $source );
			}

			$link = sprintf( '<a href="%s" class="jet-engine-listing-overlay-link"></a>', $url );

			return sprintf(
				'<div class="jet-engine-listing-overlay-wrap" data-url="%3$s">%1$s%2$s</div>',
				$content,
				$link,
				$url
			);
		}

		/**
		 * Setup data
		 *
		 * @param  [type] $post [description]
		 * @return [type]       [description]
		 */
		public function setup_data( $post_obj = null ) {

			if ( 'posts' === jet_engine()->listings->data->get_listing_source() ) {
				global $post;
				$post = $post_obj;
				setup_postdata( $post );
			}

			jet_engine()->listings->data->set_current_object( $post_obj );

		}

		/**
		 * Reset data
		 * @return [type] [description]
		 */
		public function reset_data() {

			if ( 'posts' === jet_engine()->listings->data->get_listing_source() ) {
				wp_reset_postdata();
			}

			jet_engine()->listings->data->reset_current_object();

		}

		/**
		 * Check if current page build with elementor and contain listing - enqueue listing CSS in header
		 * Do this to avoid unstyled content flashing on page load
		 *
		 * @param [type] $post_id    [description]
		 */
		public function maybe_enqueue_listing_css( $post_id = null ) {

			if ( ! $post_id ) {
				$post_id = get_the_ID();
			}

			if ( ! $post_id ) {
				return;
			}

			$elementor_data = get_post_meta( $post_id, '_elementor_data', true );

			if ( ! $elementor_data ) {
				return;
			}

			if ( is_array( $elementor_data ) ) {
				$elementor_data = json_encode( $elementor_data );
			}

			preg_match_all( '/[\'\"]lisitng_id[\'\"]\:[\'\"](\d+)[\'\"]/', $elementor_data, $matches );

			if ( empty( $matches[1] ) ) {
				return;
			}

			foreach ( $matches[1] as $listing_id ) {

				if ( class_exists( 'Elementor\Core\Files\CSS\Post' ) ) {
					$css_file = new Elementor\Core\Files\CSS\Post( $listing_id );
				} else {
					$css_file = new Elementor\Post_CSS_File( $listing_id );
				}

				$css_file->enqueue();
			}

		}

		/**
		 * [loc_enqueue_listing_css description]
		 * @return [type] [description]
		 */
		public function loc_enqueue_listing_css( $template_id ) {
			$this->maybe_enqueue_listing_css( $template_id );
		}

	}

}
