<?php
/**
 * Tools class
 */

class Jet_Engine_Tools {

	/**
	 * Returns all post types list to use in JS components
	 *
	 * @return [type] [description]
	 */
	public static function get_post_types_for_js() {

		$result     = array();
		$post_types = get_post_types( array(), 'objects' );

		foreach ( $post_types as $post_type ) {
			$result[] = array(
				'value' => $post_type->name,
				'label' => $post_type->label,
			);
		}

		return $result;

	}

	/**
	 * Return all taxonomies list to use in JS components
	 *
	 * @return [type] [description]
	 */
	public static function get_taxonomies_for_js() {

		$result     = array();
		$taxonomies = get_taxonomies( array(), 'objects' );

		foreach ( $taxonomies as $tax ) {
			$result[] = array(
				'value' => $tax->name,
				'label' => $tax->label,
			);
		}

		return $result;

	}

	/**
	 * Render new elementor icons
	 *
	 * @return [type] [description]
	 */
	public static function render_icon( $icon, $icon_class ) {

		if ( ! is_array( $icon ) && is_numeric( $icon ) ) {
			ob_start();

			echo '<div class="' . $icon_class . ' is-svg-icon">';
			echo wp_get_attachment_image( $icon, 'full' );
			echo '</div>';

			return ob_get_clean();
		}

		if ( empty( $icon['value'] ) ) {
			return false;
		}

		$is_new = class_exists( 'Elementor\Icons_Manager' ) && Elementor\Icons_Manager::is_migration_allowed();

		if ( $is_new ) {
			ob_start();

			if ( 'svg' === $icon['library'] ) {
				echo '<div class="' . $icon_class . ' is-svg-icon">';
			}

			Elementor\Icons_Manager::render_icon( $icon, array(
				'class'       => $icon_class,
				'aria-hidden' => 'true',
			) );

			if ( 'svg' === $icon['library'] ) {
				echo '</div>';
			}

			return ob_get_clean();

		} else {
			return false;
		}

	}

}