(function( $, exportConfig ) {

	'use strict';

	Vue.component( 'jet-engine-skin-export', {
		template: '#jet_engine_skin_export',
		data: function() {
			return {
				isActive: false,
				postTypes: exportConfig.post_types,
				taxonomies: exportConfig.taxonomies,
				metaBoxes: exportConfig.meta_boxes,
				relations: exportConfig.relations,
				listingItems: exportConfig.listing_items,
				skin: {
					post_types: [],
					taxonomies: [],
					meta_boxes: [],
					relations: [],
					listing_items: [],
					sample_content: false,
				}
			};
		},
		methods: {
			serialize: function( object, prefix ) {

				var str = [],
					prop;

				for ( prop in object ) {

					if ( object.hasOwnProperty( prop ) ) {
						var key = prefix ? prefix + "[" + prop + "]" : prop,
							val = object[ prop ];

						if ( val && typeof val === "object" ) {
							val = this.serialize( val, key );
						} else {
							val = encodeURIComponent( key ) + "=" + encodeURIComponent( val );
						}

						str.push( val );
					}
				}

				return str.join( "&" );
			},
			goToExport: function() {
				window.location = exportConfig.base_url + "&" + this.serialize( this.skin );
			}
		}
	} );

	Vue.component( 'jet-engine-skin-import', {
		template: '#jet_engine_skin_import',
		data: function() {
			return {
				isActive: false,
				isLoading: false,
				readyToImport: false,
				file: null,
				error: null,
				log: false,
			};
		},
		methods: {
			prepareToImport: function( e ) {

				var file;

				if ( ! e.target.files ) {
					this.readyToImport = false;
					return;
				}

				file = e.target.files[0];

				if ( 'application/json' !== file.type ) {
					this.readyToImport = false;
					return;
				}

				this.file          = file;
				this.readyToImport = true;

			},
			logItems: function( items ) {
				return items.join( ", " );
			},
			processImport: function() {

				var self = this,
					formData,
					xhr;

				self.isLoading = true;

				formData = new FormData();
				formData.append( '_skin', self.file );
				formData.append( 'action', 'jet_engine_import_skin' );

				xhr = new XMLHttpRequest();

				xhr.open( 'POST', ajaxurl, true );

				xhr.onload = function( e, r ) {

					if ( xhr.status == 200 ) {
						var response = e.currentTarget.response;
						response = JSON.parse( response );

						if ( ! response.success ) {
							self.error = response.data.message;
							return;
						} else {
							self.log = response.data;
						}

					} else {
						self.error = xhr.status;
					}

				};

				xhr.send( formData );
			}
		}
	} );

})( jQuery, window.JetEngineExportConfig );
