(function( $, dashboardConfig ) {

	'use strict';

	window.JetEngineDashboard = new Vue( {
		el: '#jet_engine_dashboard',
		data: {
			availableModules: dashboardConfig.available_modules,
			activeModules: dashboardConfig.active_modules,
			saving: false,
			result: false,
			errorMessage: '',
			successMessage: '',
		},
		mounted: function() {
			this.$el.className = 'is-mounted';
		},
		methods: {
			saveModules: function() {

				var self = this;

				self.saving = true;

				jQuery.ajax({
					url: window.ajaxurl,
					type: 'POST',
					dataType: 'json',
					data: {
						action: 'jet_engine_save_modules',
						modules: self.activeModules,
					},
				}).done( function( response ) {

					self.saving = false;

					if ( response.success ) {
						self.result = 'success';

						if ( ! response.data.reload ) {
							self.successMessage = dashboardConfig.messages.saved;
						} else {

							self.successMessage = dashboardConfig.messages.saved_and_reload;

							setTimeout( function() {
								window.location.reload();
							}, 4000 );

						}

					} else {
						self.result = 'error';
						self.errorMessage = 'Error!';
					}

					self.hideNotice();

				} ).fail( function( e, textStatus ) {
					self.result       = 'error';
					self.saving       = false;
					self.errorMessage = e.statusText;
					self.hideNotice();
				} );

			},
			hideNotice: function() {
				var self = this;
				setTimeout( function() {
					self.result       = false;
					self.errorMessage = '';
				}, 8000 );
			},
		}
	} );

})( jQuery, window.JetEngineDashboardConfig );
