<?php
	vc_map(
		array(
			'name' => __( 'Mailchimp Subscribe Form', 'jupiter-donut' ),
			'base' => 'mk_subscribe',
			'html_template' => dirname( __FILE__ ) . '/mk_subscribe.php',
			'icon' => 'icon-mk-news-tab vc_mk_element-icon',
			'description' => __( '', 'jupiter-donut' ),
			'category' => __( 'General', 'jupiter-donut' ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => __( 'Placeholder Text', 'jupiter-donut' ),
					'param_name' => 'placeholder_text',
					'value' => 'Your e-mail',
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'textfield',
					'heading' => __( 'Button Text', 'jupiter-donut' ),
					'param_name' => 'button_text',
					'value' => 'SEND',
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'textfield',
					'heading' => __( 'List ID', 'jupiter-donut' ),
					'param_name' => 'list_id',
					'value' => '',
					'description' => __( "i.e: '6edd80a499'", 'jupiter-donut' ),
				),
				array(
					'type' => 'checkbox',
					'heading' => __( 'Send Opt-in Mails', 'jupiter-donut' ),
					'param_name' => 'optin',
					'value' => '',
					'description' => __( "Sends a 'click to subscribe' mail", 'jupiter-donut' ),
				),
                array(
                 'type' => 'toggle',
                 'heading' => __( 'GDPR Consent Check?', 'jupiter-donut' ),
                 'param_name' => 'gdpr_consent',
                 'value' => 'true',
                 'description' => __( '', 'jupiter-donut' ),

             ),

             array(
                 'type' => 'textarea',
                 'heading' => __( 'GDPR Consent Checkbox Text', 'jupiter-donut' ),
                 'param_name' => 'gdpr_consent_text',
                 'value' => sprintf( __( 'I consent to %s collecting my details through this form.', 'jupiter-donut' ), get_bloginfo( 'name' ) ),
                 'description' => __( '', 'jupiter-donut' ),
                 'dependency' => array(
                     'element' => 'gdpr_consent',
                     'value' => array(
                         'true',
                     ),
                 ),
             ),
				$add_css_animations,
				$add_device_visibility,
				array(
					'type' => 'textfield',
					'heading' => __( 'Extra class name', 'jupiter-donut' ),
					'param_name' => 'el_class',
					'value' => '',
					'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in Custom CSS Shortcode or Masterkey Custom CSS option.', 'jupiter-donut' ),
				),

				// Styles & Color Settings
				array(
					'type' => 'range',
					'heading' => __( 'Corner Radius', 'jupiter-donut' ),
					'param_name' => 'corner_radius',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'value' => '0',
					'min' => '0',
					'max' => '100',
					'step' => '1',
					'unit' => 'px',
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'range',
					'heading' => __( 'Space between button and input', 'jupiter-donut' ),
					'param_name' => 'space_between',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'value' => '0',
					'min' => '0',
					'max' => '20',
					'step' => '1',
					'unit' => 'px',
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Size', 'jupiter-donut' ),
					'param_name' => 'subscribe_size',
					'value' => array(
						__( 'Large', 'jupiter-donut' ) => 'large',
						__( 'Medium', 'jupiter-donut' ) => 'medium',
					),
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( 'Choose the icon size by pixel.', 'jupiter-donut' ),
				),
				array(
					'type' => 'group_heading',
					'title' => __( 'Button Settings?', 'jupiter-donut' ),
					'param_name' => 'color_button_title',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'style' => 'border: 0; font-size: 16px; font-weight:bold; padding:15px 0 0; border-top: 1px solid #cccccc;',
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Button background color', 'jupiter-donut' ),
					'param_name' => 'btn_bg_color',
					'value' => '',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Button text color', 'jupiter-donut' ),
					'param_name' => 'btn_text_color',
					'value' => '#eee',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Button border style', 'jupiter-donut' ),
					'param_name' => 'btn_border_style',
					'value' => array(
						__( 'Solid', 'jupiter-donut' ) => 'solid',
						__( 'Dashed', 'jupiter-donut' ) => 'dashed',
						__( 'Dotted', 'jupiter-donut' ) => 'dotted',
						__( 'None', 'jupiter-donut' ) => 'none',
					),
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( 'Choose the icon size by pixel.', 'jupiter-donut' ),
				),
				array(
					'type' => 'range',
					'heading' => __( 'Button border width', 'jupiter-donut' ),
					'param_name' => 'btn_border_width',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'value' => '1',
					'min' => '1',
					'max' => '10',
					'step' => '1',
					'unit' => 'px',
					'description' => __( '', 'jupiter-donut' ),
					'dependency' => array(
						'element' => 'btn_border_style',
						'value' => array(
							'solid',
							'dashed',
							'dotted',
						),
					),
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Button border color', 'jupiter-donut' ),
					'param_name' => 'btn_border_color',
					'value' => '#eee',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),

				array(
					'type' => 'group_heading',
					'title' => __( 'Text Input settings?', 'jupiter-donut' ),
					'param_name' => 'color_input_title',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'style' => 'border: 0; font-size: 16px; font-weight:bold; padding:15px 0 0; border-top: 1px solid #cccccc;',
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Text input background color', 'jupiter-donut' ),
					'param_name' => 'input_bg_color',
					'value' => '#ffffff',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Placeholder color', 'jupiter-donut' ),
					'param_name' => 'input_placeholder_color',
					'value' => '#eee',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Text input border style', 'jupiter-donut' ),
					'param_name' => 'input_border_style',
					'value' => array(
						__( 'Solid', 'jupiter-donut' ) => 'solid',
						__( 'Dashed', 'jupiter-donut' ) => 'dashed',
						__( 'Dotted', 'jupiter-donut' ) => 'dotted',
						__( 'None', 'jupiter-donut' ) => 'none',
					),
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( 'Choose the icon size by pixel.', 'jupiter-donut' ),
				),
				array(
					'type' => 'range',
					'heading' => __( 'Text input border width', 'jupiter-donut' ),
					'param_name' => 'input_border_width',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'value' => '1',
					'min' => '1',
					'max' => '10',
					'step' => '1',
					'unit' => 'px',
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Text input border color', 'jupiter-donut' ),
					'param_name' => 'input_border_color',
					'value' => '#eee',
					'group' => __( 'Styles & Colors', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),

				// Hover Styles Settings
				array(
					'type' => 'group_heading',
					'title' => __( 'Button Settings?', 'jupiter-donut' ),
					'param_name' => 'hover_button_title',
					'group' => __( 'Hover Options', 'jupiter-donut' ),
					'style' => 'border: 0; font-size: 16px; font-weight:bold; padding:15px 0 0;',
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Button background color', 'jupiter-donut' ),
					'param_name' => 'btn_hover_bg_color',
					'value' => '',
					'group' => __( 'Hover Options', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Button text color', 'jupiter-donut' ),
					'param_name' => 'btn_hover_text_color',
					'value' => '',
					'group' => __( 'Hover Options', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Button border color', 'jupiter-donut' ),
					'param_name' => 'btn_hover_border_color',
					'value' => '',
					'group' => __( 'Hover Options', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),

				// Focus Style Settings
				array(
					'type' => 'group_heading',
					'title' => __( 'Text input settings?', 'jupiter-donut' ),
					'param_name' => 'hover_button_title',
					'group' => __( 'Focus Options', 'jupiter-donut' ),
					'style' => 'border: 0; font-size: 16px; font-weight:bold; padding:15px 0 0;',
				),
				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Text input background color', 'jupiter-donut' ),
					'param_name' => 'input_focus_bg_color',
					'value' => '',
					'group' => __( 'Focus Options', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),

				array(
					'type' => 'alpha_colorpicker',
					'heading' => __( 'Placeholder color', 'jupiter-donut' ),
					'param_name' => 'input_focus_placeholder_color',
					'value' => '',
					'group' => __( 'Focus Options', 'jupiter-donut' ),
					'description' => __( '', 'jupiter-donut' ),
				),
			),
		)
	);
