<?php
$path = pathinfo(__FILE__) ['dirname'];

include ($path . '/config.php');

global $wp_query;

$id = Mk_Static_Files::shortcode_id();

$query_options = array(
    'post_type' => $post_type,
    'exclude_post_format' => $exclude_post_format,
    'offset' => $offset,
    'posts' => $posts,
    'orderby' => $orderby,
    'order' => $order,
);


if(is_archive()) {

    $queried_object = $wp_query->get_queried_object();

    if ( $queried_object instanceof WP_POST_TYPE ) {
        $query_options['post_type'] = get_post_type();
    }

    $query_options['taxonomy_name'] = !empty($queried_object->taxonomy) ? $queried_object->taxonomy : false;
    $query_options['term_slug'] = !empty($queried_object->slug) ? $queried_object->slug : false;

    $count = isset($wp_query->query_vars['posts_per_page']) ? $wp_query->query_vars['posts_per_page'] : $count;
    $query_options['author_name'] = isset($wp_query->query['author_name']) ? $wp_query->query['author_name'] : '';

    $query_options['year'] = isset($wp_query->query['year']) ? $wp_query->query['year'] : '';
    $query_options['monthnum'] = isset($wp_query->query['monthnum']) ? $wp_query->query['monthnum'] : '';
    $query_options['m'] = isset($wp_query->query['m']) ? $wp_query->query['m'] : '';
    $query_options['second'] = isset($wp_query->query['second']) ? $wp_query->query['second'] : '';
    $query_options['minute'] = isset($wp_query->query['minute']) ? $wp_query->query['minute'] : '';
    $query_options['hour'] = isset($wp_query->query['hour']) ? $wp_query->query['hour'] : '';
    $query_options['w'] = isset($wp_query->query['w']) ? $wp_query->query['w'] : '';
    $query_options['day'] = isset($wp_query->query['day']) ? $wp_query->query['day'] : '';
    $query_options['tag'] = isset($wp_query->query['tag']) ? $wp_query->query['tag'] : '';

} else {
    $query_options['author'] = $author;
}

$query_options['count'] = $count;
$query_options['cat'] = $cat;


$query = mk_wp_query($query_options);
$r = $query['wp_query'];



if (is_singular()) {
    global $post;
    $layout = get_post_meta($post->ID, '_layout', true);
    $layout = (!empty($layout)) ? $layout : 'full';
}
else if (is_search()) {
    $layout = jupiter_donut_get_option( 'search_page_layout' );
}
else if (is_archive()) {
    $layout = jupiter_donut_get_option( 'archive_page_layout' );
}
else {
    $layout = 'right';
}
$theme_images = JUPITER_DONUT_ASSETS_URL;
Mk_Static_Files::addCSS("
    #loop-{$id} .blog-twitter-content:before,
    #loop-{$id} .mk-blog-modern-item.twitter-post-type .blog-twitter-content footer:before {
        background-image: url('{$theme_images}/img/social-icons/twitter-blue.svg');
    }
    #loop-{$id} .mk-blog-meta-wrapper:before {
        background: url('{$theme_images}/img/social-icons/instagram.png') center center no-repeat;
    }
", $id);


$atts = array(
    'shortcode_name' => 'mk_blog',
    'style' => $style,
    'layout' => $layout,
    'column' => $column,
    'disable_meta' => $disable_meta,
    'grid_image_height' => $grid_image_height,
    'comments_share' => $comments_share,
    'full_content' => $full_content,
    'image_size' => $image_size,
    'excerpt_length' => $excerpt_length,
    'thumbnail_align' => $thumbnail_align,
    'lazyload' => $lazyload,
    'disable_lazyload' => $disable_lazyload,
    //'image_quality' => $image_quality,
    'i' => 0
);


/* Main wrapper classes */
$wrapper_class[] = 'mk-blog-container';
$wrapper_class[] = 'mk-'.$style.'-wrapper';
$wrapper_class[] = $el_class;
$wrapper_class[] = ($style == "grid" && $transparent_border == 'true') ? 'no-border' : '';
$wrapper_class[] = 'jupiter-donut-' . $visibility;

switch ($magazine_strcutre) {
    case 1:
        $wrapper_class[] = 'mag-one-column';
        break;

    case 2:
        $wrapper_class[] = 'mag-two-column-left';
        break;

    case 3:
        $wrapper_class[] = 'mag-two-column-right';
        break;

    default:
        $wrapper_class[] = 'mag-one-column';
        break;
}
/*********/


$data_config[] = 'data-query="'.base64_encode(json_encode($query_options)).'"';
$data_config[] = 'data-loop-atts="'.base64_encode(json_encode($atts)).'"';
$data_config[] = 'data-pagination-style="'.$pagination_style.'"';
$data_config[] = is_archive() ? 'data-max-pages="'.$r->max_num_pages.'"' : 'data-max-pages="'.$r->max_num_pages.'"';
$data_config[] = 'data-loop-iterator="'.$count.'"';
$data_config[] = 'data-loop-posts="'.$posts.'"';
//if(is_archive()) $data_config[] = 'data-archive-cat="'.$wp_query->query['category_name'].'"';

if($style == 'grid' || $style == 'newspaper' || $style == 'spotlight') {
    $data_config[] = 'data-mk-component="Grid"';
    $data_config[] = 'data-grid-config=\'{"container":"#loop-'.$id.'", "item":".mk-isotop-item"}\'';
}

// Initial loaded post
$initial_loaded_posts = array();
$global_lazyload = jupiter_donut_get_option( 'global_lazyload' );
if ( ($global_lazyload == 'true' && $disable_lazyload == 'false') || ($global_lazyload == 'false' && $lazyload == 'true') ) {
     $wrapper_class[] = 'mk-blog-container-lazyload';
}

?>


<section id="loop-<?php echo $id; ?>" <?php echo implode(' ', $data_config); ?> class="js-loop js-el jupiter-donut-clearfix <?php echo implode(' ', $wrapper_class); ?>" <?php echo get_schema_markup('blog'); ?>>
    <?php
        if ($r->have_posts()):
            while ($r->have_posts()):
                $r->the_post();
                $initial_loaded_posts[] = $r->post->ID;
                $atts['i']++;
                echo mk_get_shortcode_view('mk_blog', 'loop-styles/' . $style, true, $atts);
            endwhile;
        endif;
    ?>
</section>


<?php


if ($pagination != 'false') {
    echo mk_get_view('global', 'loop-pagination', true, ['pagination_style' => $pagination_style, 'r' => $r]);
}

wp_nonce_field('mk-load-more', 'safe_load_more');

// Convert the loaded post array to string
$initial_loaded_posts = implode( ", ", $initial_loaded_posts );

wp_reset_postdata();

?>

<span class="mk-ajax-loaded-posts" data-loop-loaded-posts="<?php echo $initial_loaded_posts; ?>"></span>
