<?php
/**
 * Juno Toys Framework: strings manipulations
 *
 * @package	junotoys
 * @since	junotoys 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Check multibyte functions
if ( ! defined( 'JUNOTOYS_MULTIBYTE' ) ) define( 'JUNOTOYS_MULTIBYTE', function_exists('mb_strpos') ? 'UTF-8' : false );

if (!function_exists('junotoys_strlen')) {
	function junotoys_strlen($text) {
		return JUNOTOYS_MULTIBYTE ? mb_strlen($text) : strlen($text);
	}
}

if (!function_exists('junotoys_strpos')) {
	function junotoys_strpos($text, $char, $from=0) {
		return JUNOTOYS_MULTIBYTE ? mb_strpos($text, $char, $from) : strpos($text, $char, $from);
	}
}

if (!function_exists('junotoys_strrpos')) {
	function junotoys_strrpos($text, $char, $from=0) {
		return JUNOTOYS_MULTIBYTE ? mb_strrpos($text, $char, $from) : strrpos($text, $char, $from);
	}
}

if (!function_exists('junotoys_substr')) {
	function junotoys_substr($text, $from, $len=-999999) {
		if ($len==-999999) { 
			if ($from < 0)
				$len = -$from; 
			else
				$len = junotoys_strlen($text)-$from;
		}
		return JUNOTOYS_MULTIBYTE ? mb_substr($text, $from, $len) : substr($text, $from, $len);
	}
}

if (!function_exists('junotoys_strtolower')) {
	function junotoys_strtolower($text) {
		return JUNOTOYS_MULTIBYTE ? mb_strtolower($text) : strtolower($text);
	}
}

if (!function_exists('junotoys_strtoupper')) {
	function junotoys_strtoupper($text) {
		return JUNOTOYS_MULTIBYTE ? mb_strtoupper($text) : strtoupper($text);
	}
}

if (!function_exists('junotoys_strtoproper')) {
	function junotoys_strtoproper($text) {
		$rez = ''; $last = ' ';
		for ($i=0; $i<junotoys_strlen($text); $i++) {
			$ch = junotoys_substr($text, $i, 1);
			$rez .= junotoys_strpos(' .,:;?!()[]{}+=', $last)!==false ? junotoys_strtoupper($ch) : junotoys_strtolower($ch);
			$last = $ch;
		}
		return $rez;
	}
}

if (!function_exists('junotoys_strrepeat')) {
	function junotoys_strrepeat($str, $n) {
		$rez = '';
		for ($i=0; $i<$n; $i++)
			$rez .= $str;
		return $rez;
	}
}

if (!function_exists('junotoys_strshort')) {
	function junotoys_strshort($str, $maxlength, $add='...') {
		if ($maxlength < 0) 
			return $str;
		if ($maxlength == 0) 
			return '';
		if ($maxlength >= junotoys_strlen($str)) 
			return strip_tags($str);
		$str = junotoys_substr(strip_tags($str), 0, $maxlength - junotoys_strlen($add));
		$ch = junotoys_substr($str, $maxlength - junotoys_strlen($add), 1);
		if ($ch != ' ') {
			for ($i = junotoys_strlen($str) - 1; $i > 0; $i--)
				if (junotoys_substr($str, $i, 1) == ' ') break;
			$str = trim(junotoys_substr($str, 0, $i));
		}
		if (!empty($str) && junotoys_strpos(',.:;-', junotoys_substr($str, -1))!==false) $str = junotoys_substr($str, 0, -1);
		return ($str) . ($add);
	}
}

// Clear string from spaces, line breaks and tags (only around text)
if (!function_exists('junotoys_strclear')) {
	function junotoys_strclear($text, $tags=array()) {
		if (empty($text)) return $text;
		if (!is_array($tags)) {
			if ($tags != '')
				$tags = explode($tags, ',');
			else
				$tags = array();
		}
		$text = trim(chop($text));
		if (is_array($tags) && count($tags) > 0) {
			foreach ($tags as $tag) {
				$open  = '<'.esc_attr($tag);
				$close = '</'.esc_attr($tag).'>';
				if (junotoys_substr($text, 0, junotoys_strlen($open))==$open) {
					$pos = junotoys_strpos($text, '>');
					if ($pos!==false) $text = junotoys_substr($text, $pos+1);
				}
				if (junotoys_substr($text, -junotoys_strlen($close))==$close) $text = junotoys_substr($text, 0, junotoys_strlen($text) - junotoys_strlen($close));
				$text = trim(chop($text));
			}
		}
		return $text;
	}
}

// Return slug for the any title string
if (!function_exists('junotoys_get_slug')) {
	function junotoys_get_slug($title) {
		return junotoys_strtolower(str_replace(array('\\','/','-',' ','.'), '_', $title));
	}
}

// Replace macros in the string
if (!function_exists('junotoys_strmacros')) {
	function junotoys_strmacros($str) {
		return str_replace(array("{{", "}}", "((", "))", "||"), array("<i>", "</i>", "<b>", "</b>", "<br>"), $str);
	}
}

// Unserialize string (try replace \n with \r\n)
if (!function_exists('junotoys_unserialize')) {
	function junotoys_unserialize($str) {
		if ( is_serialized($str) ) {
			try {
				$data = unserialize($str);
			} catch (Exception $e) {
				dcl($e->getMessage());
				$data = false;
			}
			if ($data===false) {
				try {
					$data = @unserialize(str_replace("\n", "\r\n", $str));
				} catch (Exception $e) {
					dcl($e->getMessage());
					$data = false;
				}
			}
			return $data;
		} else
			return $str;
	}
}
?>