<?php
/**
 * Juno Toys Framework: return lists
 *
 * @package junotoys
 * @since junotoys 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }



// Return styles list
if ( !function_exists( 'junotoys_get_list_styles' ) ) {
	function junotoys_get_list_styles($from=1, $to=2, $prepend_inherit=false) {
		$list = array();
		for ($i=$from; $i<=$to; $i++)
			$list[$i] = sprintf(esc_html__('Style %d', 'junotoys'), $i);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the shortcodes margins
if ( !function_exists( 'junotoys_get_list_margins' ) ) {
	function junotoys_get_list_margins($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_margins'))=='') {
			$list = array(
				'null'		=> esc_html__('0 (No margin)',	'junotoys'),
				'tiny'		=> esc_html__('Tiny',		'junotoys'),
				'small'		=> esc_html__('Small',		'junotoys'),
				'medium'	=> esc_html__('Medium',		'junotoys'),
				'large'		=> esc_html__('Large',		'junotoys'),
				'huge'		=> esc_html__('Huge',		'junotoys'),
				'tiny-'		=> esc_html__('Tiny (negative)',	'junotoys'),
				'small-'	=> esc_html__('Small (negative)',	'junotoys'),
				'medium-'	=> esc_html__('Medium (negative)',	'junotoys'),
				'large-'	=> esc_html__('Large (negative)',	'junotoys'),
				'huge-'		=> esc_html__('Huge (negative)',	'junotoys')
				);
			$list = apply_filters('junotoys_filter_list_margins', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_margins', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the line styles
if ( !function_exists( 'junotoys_get_list_line_styles' ) ) {
	function junotoys_get_list_line_styles($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_line_styles'))=='') {
			$list = array(
				'solid'	=> esc_html__('Solid', 'junotoys'),
				'dashed'=> esc_html__('Dashed', 'junotoys'),
				'dotted'=> esc_html__('Dotted', 'junotoys'),
				'double'=> esc_html__('Double', 'junotoys'),
				'image'	=> esc_html__('Image', 'junotoys')
				);
			$list = apply_filters('junotoys_filter_list_line_styles', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_line_styles', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the animations
if ( !function_exists( 'junotoys_get_list_animations' ) ) {
	function junotoys_get_list_animations($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_animations'))=='') {
			$list = array(
				'none'			=> esc_html__('- None -',	'junotoys'),
				'bounce'		=> esc_html__('Bounce',		'junotoys'),
				'elastic'		=> esc_html__('Elastic',	'junotoys'),
				'flash'			=> esc_html__('Flash',		'junotoys'),
				'flip'			=> esc_html__('Flip',		'junotoys'),
				'pulse'			=> esc_html__('Pulse',		'junotoys'),
				'rubberBand'	=> esc_html__('Rubber Band','junotoys'),
				'shake'			=> esc_html__('Shake',		'junotoys'),
				'swing'			=> esc_html__('Swing',		'junotoys'),
				'tada'			=> esc_html__('Tada',		'junotoys'),
				'wobble'		=> esc_html__('Wobble',		'junotoys')
				);
			$list = apply_filters('junotoys_filter_list_animations', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_animations', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the enter animations
if ( !function_exists( 'junotoys_get_list_animations_in' ) ) {
	function junotoys_get_list_animations_in($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_animations_in'))=='') {
			$list = array(
				'none'				=> esc_html__('- None -',			'junotoys'),
				'bounceIn'			=> esc_html__('Bounce In',			'junotoys'),
				'bounceInUp'		=> esc_html__('Bounce In Up',		'junotoys'),
				'bounceInDown'		=> esc_html__('Bounce In Down',		'junotoys'),
				'bounceInLeft'		=> esc_html__('Bounce In Left',		'junotoys'),
				'bounceInRight'		=> esc_html__('Bounce In Right',	'junotoys'),
				'elastic'			=> esc_html__('Elastic In',			'junotoys'),
				'fadeIn'			=> esc_html__('Fade In',			'junotoys'),
				'fadeInUp'			=> esc_html__('Fade In Up',			'junotoys'),
				'fadeInUpSmall'		=> esc_html__('Fade In Up Small',	'junotoys'),
				'fadeInUpBig'		=> esc_html__('Fade In Up Big',		'junotoys'),
				'fadeInDown'		=> esc_html__('Fade In Down',		'junotoys'),
				'fadeInDownBig'		=> esc_html__('Fade In Down Big',	'junotoys'),
				'fadeInLeft'		=> esc_html__('Fade In Left',		'junotoys'),
				'fadeInLeftBig'		=> esc_html__('Fade In Left Big',	'junotoys'),
				'fadeInRight'		=> esc_html__('Fade In Right',		'junotoys'),
				'fadeInRightBig'	=> esc_html__('Fade In Right Big',	'junotoys'),
				'flipInX'			=> esc_html__('Flip In X',			'junotoys'),
				'flipInY'			=> esc_html__('Flip In Y',			'junotoys'),
				'lightSpeedIn'		=> esc_html__('Light Speed In',		'junotoys'),
				'rotateIn'			=> esc_html__('Rotate In',			'junotoys'),
				'rotateInUpLeft'	=> esc_html__('Rotate In Down Left','junotoys'),
				'rotateInUpRight'	=> esc_html__('Rotate In Up Right',	'junotoys'),
				'rotateInDownLeft'	=> esc_html__('Rotate In Up Left',	'junotoys'),
				'rotateInDownRight'	=> esc_html__('Rotate In Down Right','junotoys'),
				'rollIn'			=> esc_html__('Roll In',			'junotoys'),
				'slideInUp'			=> esc_html__('Slide In Up',		'junotoys'),
				'slideInDown'		=> esc_html__('Slide In Down',		'junotoys'),
				'slideInLeft'		=> esc_html__('Slide In Left',		'junotoys'),
				'slideInRight'		=> esc_html__('Slide In Right',		'junotoys'),
				'wipeInLeftTop'		=> esc_html__('Wipe In Left Top',	'junotoys'),
				'zoomIn'			=> esc_html__('Zoom In',			'junotoys'),
				'zoomInUp'			=> esc_html__('Zoom In Up',			'junotoys'),
				'zoomInDown'		=> esc_html__('Zoom In Down',		'junotoys'),
				'zoomInLeft'		=> esc_html__('Zoom In Left',		'junotoys'),
				'zoomInRight'		=> esc_html__('Zoom In Right',		'junotoys')
				);
			$list = apply_filters('junotoys_filter_list_animations_in', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_animations_in', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the out animations
if ( !function_exists( 'junotoys_get_list_animations_out' ) ) {
	function junotoys_get_list_animations_out($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_animations_out'))=='') {
			$list = array(
				'none'				=> esc_html__('- None -',			'junotoys'),
				'bounceOut'			=> esc_html__('Bounce Out',			'junotoys'),
				'bounceOutUp'		=> esc_html__('Bounce Out Up',		'junotoys'),
				'bounceOutDown'		=> esc_html__('Bounce Out Down',	'junotoys'),
				'bounceOutLeft'		=> esc_html__('Bounce Out Left',	'junotoys'),
				'bounceOutRight'	=> esc_html__('Bounce Out Right',	'junotoys'),
				'fadeOut'			=> esc_html__('Fade Out',			'junotoys'),
				'fadeOutUp'			=> esc_html__('Fade Out Up',		'junotoys'),
				'fadeOutUpBig'		=> esc_html__('Fade Out Up Big',	'junotoys'),
				'fadeOutDown'		=> esc_html__('Fade Out Down',		'junotoys'),
				'fadeOutDownSmall'	=> esc_html__('Fade Out Down Small','junotoys'),
				'fadeOutDownBig'	=> esc_html__('Fade Out Down Big',	'junotoys'),
				'fadeOutLeft'		=> esc_html__('Fade Out Left',		'junotoys'),
				'fadeOutLeftBig'	=> esc_html__('Fade Out Left Big',	'junotoys'),
				'fadeOutRight'		=> esc_html__('Fade Out Right',		'junotoys'),
				'fadeOutRightBig'	=> esc_html__('Fade Out Right Big',	'junotoys'),
				'flipOutX'			=> esc_html__('Flip Out X',			'junotoys'),
				'flipOutY'			=> esc_html__('Flip Out Y',			'junotoys'),
				'hinge'				=> esc_html__('Hinge Out',			'junotoys'),
				'lightSpeedOut'		=> esc_html__('Light Speed Out',	'junotoys'),
				'rotateOut'			=> esc_html__('Rotate Out',			'junotoys'),
				'rotateOutUpLeft'	=> esc_html__('Rotate Out Down Left','junotoys'),
				'rotateOutUpRight'	=> esc_html__('Rotate Out Up Right','junotoys'),
				'rotateOutDownLeft'	=> esc_html__('Rotate Out Up Left',	'junotoys'),
				'rotateOutDownRight'=> esc_html__('Rotate Out Down Right','junotoys'),
				'rollOut'			=> esc_html__('Roll Out',			'junotoys'),
				'slideOutUp'		=> esc_html__('Slide Out Up',		'junotoys'),
				'slideOutDown'		=> esc_html__('Slide Out Down',		'junotoys'),
				'slideOutLeft'		=> esc_html__('Slide Out Left',		'junotoys'),
				'slideOutRight'		=> esc_html__('Slide Out Right',	'junotoys'),
				'zoomOut'			=> esc_html__('Zoom Out',			'junotoys'),
				'zoomOutUp'			=> esc_html__('Zoom Out Up',		'junotoys'),
				'zoomOutDown'		=> esc_html__('Zoom Out Down',		'junotoys'),
				'zoomOutLeft'		=> esc_html__('Zoom Out Left',		'junotoys'),
				'zoomOutRight'		=> esc_html__('Zoom Out Right',		'junotoys')
				);
			$list = apply_filters('junotoys_filter_list_animations_out', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_animations_out', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return classes list for the specified animation
if (!function_exists('junotoys_get_animation_classes')) {
	function junotoys_get_animation_classes($animation, $speed='normal', $loop='none') {
		// speed:	fast=0.5s | normal=1s | slow=2s
		// loop:	none | infinite
		return junotoys_param_is_off($animation) ? '' : 'animated '.esc_attr($animation).' '.esc_attr($speed).(!junotoys_param_is_off($loop) ? ' '.esc_attr($loop) : '');
	}
}


// Return list of the main menu hover effects
if ( !function_exists( 'junotoys_get_list_menu_hovers' ) ) {
	function junotoys_get_list_menu_hovers($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_menu_hovers'))=='') {
			$list = array(
				'fade'			=> esc_html__('Fade',		'junotoys'),
				'slide_line'	=> esc_html__('Slide Line',	'junotoys'),
				'slide_box'		=> esc_html__('Slide Box',	'junotoys'),
				'zoom_line'		=> esc_html__('Zoom Line',	'junotoys'),
				'path_line'		=> esc_html__('Path Line',	'junotoys'),
				'roll_down'		=> esc_html__('Roll Down',	'junotoys'),
				'color_line'	=> esc_html__('Color Line',	'junotoys'),
				);
			$list = apply_filters('junotoys_filter_list_menu_hovers', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_menu_hovers', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the button's hover effects
if ( !function_exists( 'junotoys_get_list_button_hovers' ) ) {
	function junotoys_get_list_button_hovers($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_button_hovers'))=='') {
			$list = array(
				'default'		=> esc_html__('Default',			'junotoys'),
				'fade'			=> esc_html__('Fade',				'junotoys'),
				'slide_left'	=> esc_html__('Slide from Left',	'junotoys'),
				'slide_top'		=> esc_html__('Slide from Top',		'junotoys'),
				'arrow'			=> esc_html__('Arrow',				'junotoys'),
				);
			$list = apply_filters('junotoys_filter_list_button_hovers', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_button_hovers', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the input field's hover effects
if ( !function_exists( 'junotoys_get_list_input_hovers' ) ) {
	function junotoys_get_list_input_hovers($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_input_hovers'))=='') {
			$list = array(
				'default'	=> esc_html__('Default',	'junotoys'),
				'accent'	=> esc_html__('Accented',	'junotoys'),
				'path'		=> esc_html__('Path',		'junotoys'),
				'jump'		=> esc_html__('Jump',		'junotoys'),
				'underline'	=> esc_html__('Underline',	'junotoys'),
				'iconed'	=> esc_html__('Iconed',		'junotoys'),
				);
			$list = apply_filters('junotoys_filter_list_input_hovers', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_input_hovers', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the search field's styles
if ( !function_exists( 'junotoys_get_list_search_styles' ) ) {
	function junotoys_get_list_search_styles($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_search_styles'))=='') {
			$list = array(
				'default'	=> esc_html__('Default',	'junotoys'),
				'fullscreen'=> esc_html__('Fullscreen',	'junotoys'),
				'slide'		=> esc_html__('Slide',		'junotoys'),
				'expand'	=> esc_html__('Expand',		'junotoys'),
				);
			$list = apply_filters('junotoys_filter_list_search_styles', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_search_styles', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of categories
if ( !function_exists( 'junotoys_get_list_categories' ) ) {
	function junotoys_get_list_categories($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_categories'))=='') {
			$list = array();
			$args = array(
				'type'                     => 'post',
				'child_of'                 => 0,
				'parent'                   => '',
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'               => 0,
				'hierarchical'             => 1,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => '',
				'taxonomy'                 => 'category',
				'pad_counts'               => false );
			$taxonomies = get_categories( $args );
			if (is_array($taxonomies) && count($taxonomies) > 0) {
				foreach ($taxonomies as $cat) {
					$list[$cat->term_id] = $cat->name;
				}
			}
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_categories', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of taxonomies
if ( !function_exists( 'junotoys_get_list_terms' ) ) {
	function junotoys_get_list_terms($prepend_inherit=false, $taxonomy='category') {
		if (($list = junotoys_storage_get('list_taxonomies_'.($taxonomy)))=='') {
			$list = array();
			if ( is_array($taxonomy) || taxonomy_exists($taxonomy) ) {
				$terms = get_terms( $taxonomy, array(
					'child_of'                 => 0,
					'parent'                   => '',
					'orderby'                  => 'name',
					'order'                    => 'ASC',
					'hide_empty'               => 0,
					'hierarchical'             => 1,
					'exclude'                  => '',
					'include'                  => '',
					'number'                   => '',
					'taxonomy'                 => $taxonomy,
					'pad_counts'               => false
					)
				);
			} else {
				$terms = junotoys_get_terms_by_taxonomy_from_db($taxonomy);
			}
			if (!is_wp_error( $terms ) && is_array($terms) && count($terms) > 0) {
				foreach ($terms as $cat) {
					$list[$cat->term_id] = $cat->name;	// . ($taxonomy!='category' ? ' /'.($cat->taxonomy).'/' : '');
				}
			}
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_taxonomies_'.($taxonomy), $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list of post's types
if ( !function_exists( 'junotoys_get_list_posts_types' ) ) {
	function junotoys_get_list_posts_types($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_posts_types'))=='') {
			// Return only theme inheritance supported post types
			$list = apply_filters('junotoys_filter_list_post_types', array());
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_posts_types', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list post items from any post type and taxonomy
if ( !function_exists( 'junotoys_get_list_posts' ) ) {
	function junotoys_get_list_posts($prepend_inherit=false, $opt=array()) {
		$opt = array_merge(array(
			'post_type'			=> 'post',
			'post_status'		=> 'publish',
			'taxonomy'			=> 'category',
			'taxonomy_value'	=> '',
			'posts_per_page'	=> -1,
			'orderby'			=> 'post_date',
			'order'				=> 'desc',
			'return'			=> 'id'
			), is_array($opt) ? $opt : array('post_type'=>$opt));

		$hash = 'list_posts_'.($opt['post_type']).'_'.($opt['taxonomy']).'_'.($opt['taxonomy_value']).'_'.($opt['orderby']).'_'.($opt['order']).'_'.($opt['return']).'_'.($opt['posts_per_page']);
		if (($list = junotoys_storage_get($hash))=='') {
			$list = array();
			$list['none'] = esc_html__("- Not selected -", 'junotoys');
			$args = array(
				'post_type' => $opt['post_type'],
				'post_status' => $opt['post_status'],
				'posts_per_page' => $opt['posts_per_page'],
				'ignore_sticky_posts' => true,
				'orderby'	=> $opt['orderby'],
				'order'		=> $opt['order']
			);
			if (!empty($opt['taxonomy_value'])) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => $opt['taxonomy'],
						'field' => (int) $opt['taxonomy_value'] > 0 ? 'id' : 'slug',
						'terms' => $opt['taxonomy_value']
					)
				);
			}
			$posts = get_posts( $args );
			if (is_array($posts) && count($posts) > 0) {
				foreach ($posts as $post) {
					$list[$opt['return']=='id' ? $post->ID : $post->post_title] = $post->post_title;
				}
			}
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set($hash, $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list pages
if ( !function_exists( 'junotoys_get_list_pages' ) ) {
	function junotoys_get_list_pages($prepend_inherit=false, $opt=array()) {
		$opt = array_merge(array(
			'post_type'			=> 'page',
			'post_status'		=> 'publish',
			'posts_per_page'	=> -1,
			'orderby'			=> 'title',
			'order'				=> 'asc',
			'return'			=> 'id'
			), is_array($opt) ? $opt : array('post_type'=>$opt));
		return junotoys_get_list_posts($prepend_inherit, $opt);
	}
}


// Return list of registered users
if ( !function_exists( 'junotoys_get_list_users' ) ) {
	function junotoys_get_list_users($prepend_inherit=false, $roles=array('administrator', 'editor', 'author', 'contributor', 'shop_manager')) {
		if (($list = junotoys_storage_get('list_users'))=='') {
			$list = array();
			$list['none'] = esc_html__("- Not selected -", 'junotoys');
			$args = array(
				'orderby'	=> 'display_name',
				'order'		=> 'ASC' );
			$users = get_users( $args );
			if (is_array($users) && count($users) > 0) {
				foreach ($users as $user) {
					$accept = true;
					if (is_array($user->roles)) {
						if (is_array($user->roles) && count($user->roles) > 0) {
							$accept = false;
							foreach ($user->roles as $role) {
								if (in_array($role, $roles)) {
									$accept = true;
									break;
								}
							}
						}
					}
					if ($accept) $list[$user->user_login] = $user->display_name;
				}
			}
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_users', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return slider engines list, prepended inherit (if need)
if ( !function_exists( 'junotoys_get_list_sliders' ) ) {
	function junotoys_get_list_sliders($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_sliders'))=='') {
			$list = array(
				'swiper' => esc_html__("Posts slider (Swiper)", 'junotoys')
			);
			$list = apply_filters('junotoys_filter_list_sliders', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_sliders', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return slider controls list, prepended inherit (if need)
if ( !function_exists( 'junotoys_get_list_slider_controls' ) ) {
	function junotoys_get_list_slider_controls($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_slider_controls'))=='') {
			$list = array(
				'no'		=> esc_html__('None', 'junotoys'),
				'side'		=> esc_html__('Side', 'junotoys'),
				'pagination'=> esc_html__('Pagination', 'junotoys')
				);
			$list = apply_filters('junotoys_filter_list_slider_controls', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_slider_controls', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return slider controls classes
if ( !function_exists( 'junotoys_get_slider_controls_classes' ) ) {
	function junotoys_get_slider_controls_classes($controls) {
		if (junotoys_param_is_off($controls))	$classes = 'sc_slider_nopagination sc_slider_nocontrols';
		else if ($controls=='bottom')			$classes = 'sc_slider_nopagination sc_slider_controls sc_slider_controls_bottom';
		else if ($controls=='pagination')		$classes = 'sc_slider_pagination sc_slider_pagination_bottom sc_slider_nocontrols';
		else									$classes = 'sc_slider_nopagination sc_slider_controls sc_slider_controls_side';
		return $classes;
	}
}

// Return list with popup engines
if ( !function_exists( 'junotoys_get_list_popup_engines' ) ) {
	function junotoys_get_list_popup_engines($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_popup_engines'))=='') {
			$list = array(
				"pretty"	=> esc_html__("Pretty photo", 'junotoys'),
				"magnific"	=> esc_html__("Magnific popup", 'junotoys')
				);
			$list = apply_filters('junotoys_filter_list_popup_engines', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_popup_engines', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return menus list, prepended inherit
if ( !function_exists( 'junotoys_get_list_menus' ) ) {
	function junotoys_get_list_menus($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_menus'))=='') {
			$list = array();
			$list['default'] = esc_html__("Default", 'junotoys');
			$menus = wp_get_nav_menus();
			if (is_array($menus) && count($menus) > 0) {
				foreach ($menus as $menu) {
					$list[$menu->slug] = $menu->name;
				}
			}
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_menus', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return custom sidebars list, prepended inherit and main sidebars item (if need)
if ( !function_exists( 'junotoys_get_list_sidebars' ) ) {
	function junotoys_get_list_sidebars($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_sidebars'))=='') {
			if (($list = junotoys_storage_get('registered_sidebars'))=='') $list = array();
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_sidebars', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return sidebars positions
if ( !function_exists( 'junotoys_get_list_sidebars_positions' ) ) {
	function junotoys_get_list_sidebars_positions($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_sidebars_positions'))=='') {
			$list = array(
				'none'  => esc_html__('Hide',  'junotoys'),
				'left'  => esc_html__('Left',  'junotoys'),
				'right' => esc_html__('Right', 'junotoys')
				);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_sidebars_positions', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return sidebars class
if ( !function_exists( 'junotoys_get_sidebar_class' ) ) {
	function junotoys_get_sidebar_class() {
		$sb_main = junotoys_get_custom_option('show_sidebar_main');
		$sb_outer = junotoys_get_custom_option('show_sidebar_outer');
		return (junotoys_param_is_off($sb_main) ? 'sidebar_hide' : 'sidebar_show sidebar_'.($sb_main))
				. ' ' . (junotoys_param_is_off($sb_outer) ? 'sidebar_outer_hide' : 'sidebar_outer_show sidebar_outer_'.($sb_outer));
	}
}

// Return body styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_body_styles' ) ) {
	function junotoys_get_list_body_styles($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_body_styles'))=='') {
			$list = array(
				'boxed'	=> esc_html__('Boxed',		'junotoys'),
				'wide'	=> esc_html__('Wide',		'junotoys')
				);
			if (junotoys_get_theme_setting('allow_fullscreen')) {
				$list['fullwide']	= esc_html__('Fullwide',	'junotoys');
				$list['fullscreen']	= esc_html__('Fullscreen',	'junotoys');
			}
			$list = apply_filters('junotoys_filter_list_body_styles', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_body_styles', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return css-themes list
if ( !function_exists( 'junotoys_get_list_themes' ) ) {
	function junotoys_get_list_themes($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_themes'))=='') {
			$list = junotoys_get_list_files("css/themes");
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_themes', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return templates list, prepended inherit
if ( !function_exists( 'junotoys_get_list_templates' ) ) {
	function junotoys_get_list_templates($mode='') {
		if (($list = junotoys_storage_get('list_templates_'.($mode)))=='') {
			$list = array();
			$tpl = junotoys_storage_get('registered_templates');
			if (is_array($tpl) && count($tpl) > 0) {
				foreach ($tpl as $k=>$v) {
					if ($mode=='' || in_array($mode, explode(',', $v['mode'])))
						$list[$k] = !empty($v['icon']) 
									? $v['icon'] 
									: (!empty($v['title']) 
										? $v['title'] 
										: junotoys_strtoproper($v['layout'])
										);
				}
			}
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_templates_'.($mode), $list);
		}
		return $list;
	}
}

// Return blog styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_templates_blog' ) ) {
	function junotoys_get_list_templates_blog($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_templates_blog'))=='') {
			$list = junotoys_get_list_templates('blog');
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_templates_blog', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return blogger styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_templates_blogger' ) ) {
	function junotoys_get_list_templates_blogger($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_templates_blogger'))=='') {
			$list = junotoys_array_merge(junotoys_get_list_templates('blogger'), junotoys_get_list_templates('blog'));
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_templates_blogger', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return single page styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_templates_single' ) ) {
	function junotoys_get_list_templates_single($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_templates_single'))=='') {
			$list = junotoys_get_list_templates('single');
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_templates_single', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return header styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_templates_header' ) ) {
	function junotoys_get_list_templates_header($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_templates_header'))=='') {
			$list = junotoys_get_list_templates('header');
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_templates_header', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return form styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_templates_forms' ) ) {
	function junotoys_get_list_templates_forms($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_templates_forms'))=='') {
			$list = junotoys_get_list_templates('forms');
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_templates_forms', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return article styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_article_styles' ) ) {
	function junotoys_get_list_article_styles($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_article_styles'))=='') {
			$list = array(
				"boxed"   => esc_html__('Boxed', 'junotoys'),
				"stretch" => esc_html__('Stretch', 'junotoys')
				);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_article_styles', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return post-formats filters list, prepended inherit
if ( !function_exists( 'junotoys_get_list_post_formats_filters' ) ) {
	function junotoys_get_list_post_formats_filters($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_post_formats_filters'))=='') {
			$list = array(
				"no"      => esc_html__('All posts', 'junotoys'),
				"thumbs"  => esc_html__('With thumbs', 'junotoys'),
				"reviews" => esc_html__('With reviews', 'junotoys'),
				"video"   => esc_html__('With videos', 'junotoys'),
				"audio"   => esc_html__('With audios', 'junotoys'),
				"gallery" => esc_html__('With galleries', 'junotoys')
				);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_post_formats_filters', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return portfolio filters list, prepended inherit
if ( !function_exists( 'junotoys_get_list_portfolio_filters' ) ) {
	function junotoys_get_list_portfolio_filters($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_portfolio_filters'))=='') {
			$list = array(
				"hide"		=> esc_html__('Hide', 'junotoys'),
				"tags"		=> esc_html__('Tags', 'junotoys'),
				"categories"=> esc_html__('Categories', 'junotoys')
				);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_portfolio_filters', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return hover styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_hovers' ) ) {
	function junotoys_get_list_hovers($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_hovers'))=='') {
			$list = array();
			$list['circle effect1']  = esc_html__('Circle Effect 1',  'junotoys');
			$list['circle effect2']  = esc_html__('Circle Effect 2',  'junotoys');
			$list['circle effect3']  = esc_html__('Circle Effect 3',  'junotoys');
			$list['circle effect4']  = esc_html__('Circle Effect 4',  'junotoys');
			$list['circle effect5']  = esc_html__('Circle Effect 5',  'junotoys');
			$list['circle effect6']  = esc_html__('Circle Effect 6',  'junotoys');
			$list['circle effect7']  = esc_html__('Circle Effect 7',  'junotoys');
			$list['circle effect8']  = esc_html__('Circle Effect 8',  'junotoys');
			$list['circle effect9']  = esc_html__('Circle Effect 9',  'junotoys');
			$list['circle effect10'] = esc_html__('Circle Effect 10',  'junotoys');
			$list['circle effect11'] = esc_html__('Circle Effect 11',  'junotoys');
			$list['circle effect12'] = esc_html__('Circle Effect 12',  'junotoys');
			$list['circle effect13'] = esc_html__('Circle Effect 13',  'junotoys');
			$list['circle effect14'] = esc_html__('Circle Effect 14',  'junotoys');
			$list['circle effect15'] = esc_html__('Circle Effect 15',  'junotoys');
			$list['circle effect16'] = esc_html__('Circle Effect 16',  'junotoys');
			$list['circle effect17'] = esc_html__('Circle Effect 17',  'junotoys');
			$list['circle effect18'] = esc_html__('Circle Effect 18',  'junotoys');
			$list['circle effect19'] = esc_html__('Circle Effect 19',  'junotoys');
			$list['circle effect20'] = esc_html__('Circle Effect 20',  'junotoys');
			$list['square effect1']  = esc_html__('Square Effect 1',  'junotoys');
			$list['square effect2']  = esc_html__('Square Effect 2',  'junotoys');
			$list['square effect3']  = esc_html__('Square Effect 3',  'junotoys');
			$list['square effect5']  = esc_html__('Square Effect 5',  'junotoys');
			$list['square effect6']  = esc_html__('Square Effect 6',  'junotoys');
			$list['square effect7']  = esc_html__('Square Effect 7',  'junotoys');
			$list['square effect8']  = esc_html__('Square Effect 8',  'junotoys');
			$list['square effect9']  = esc_html__('Square Effect 9',  'junotoys');
			$list['square effect10'] = esc_html__('Square Effect 10',  'junotoys');
			$list['square effect11'] = esc_html__('Square Effect 11',  'junotoys');
			$list['square effect12'] = esc_html__('Square Effect 12',  'junotoys');
			$list['square effect13'] = esc_html__('Square Effect 13',  'junotoys');
			$list['square effect14'] = esc_html__('Square Effect 14',  'junotoys');
			$list['square effect15'] = esc_html__('Square Effect 15',  'junotoys');
			$list['square effect_dir']   = esc_html__('Square Effect Dir',   'junotoys');
			$list['square effect_shift'] = esc_html__('Square Effect Shift', 'junotoys');
			$list['square effect_book']  = esc_html__('Square Effect Book',  'junotoys');
			$list['square effect_more']  = esc_html__('Square Effect More',  'junotoys');
			$list['square effect_fade']  = esc_html__('Square Effect Fade',  'junotoys');
			$list['square effect_pull']  = esc_html__('Square Effect Pull',  'junotoys');
			$list['square effect_slide'] = esc_html__('Square Effect Slide', 'junotoys');
			$list['square effect_border'] = esc_html__('Square Effect Border', 'junotoys');
			$list = apply_filters('junotoys_filter_portfolio_hovers', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_hovers', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the blog counters
if ( !function_exists( 'junotoys_get_list_blog_counters' ) ) {
	function junotoys_get_list_blog_counters($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_blog_counters'))=='') {
			$list = array(
				'views'		=> esc_html__('Views', 'junotoys'),
				'likes'		=> esc_html__('Likes', 'junotoys'),
				'rating'	=> esc_html__('Rating', 'junotoys'),
				'comments'	=> esc_html__('Comments', 'junotoys')
				);
			$list = apply_filters('junotoys_filter_list_blog_counters', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_blog_counters', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list of the item sizes for the portfolio alter style, prepended inherit
if ( !function_exists( 'junotoys_get_list_alter_sizes' ) ) {
	function junotoys_get_list_alter_sizes($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_alter_sizes'))=='') {
			$list = array(
					'1_1' => esc_html__('1x1', 'junotoys'),
					'1_2' => esc_html__('1x2', 'junotoys'),
					'2_1' => esc_html__('2x1', 'junotoys'),
					'2_2' => esc_html__('2x2', 'junotoys'),
					'1_3' => esc_html__('1x3', 'junotoys'),
					'2_3' => esc_html__('2x3', 'junotoys'),
					'3_1' => esc_html__('3x1', 'junotoys'),
					'3_2' => esc_html__('3x2', 'junotoys'),
					'3_3' => esc_html__('3x3', 'junotoys')
					);
			$list = apply_filters('junotoys_filter_portfolio_alter_sizes', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_alter_sizes', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return extended hover directions list, prepended inherit
if ( !function_exists( 'junotoys_get_list_hovers_directions' ) ) {
	function junotoys_get_list_hovers_directions($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_hovers_directions'))=='') {
			$list = array(
				'left_to_right' => esc_html__('Left to Right',  'junotoys'),
				'right_to_left' => esc_html__('Right to Left',  'junotoys'),
				'top_to_bottom' => esc_html__('Top to Bottom',  'junotoys'),
				'bottom_to_top' => esc_html__('Bottom to Top',  'junotoys'),
				'scale_up'      => esc_html__('Scale Up',  'junotoys'),
				'scale_down'    => esc_html__('Scale Down',  'junotoys'),
				'scale_down_up' => esc_html__('Scale Down-Up',  'junotoys'),
				'from_left_and_right' => esc_html__('From Left and Right',  'junotoys'),
				'from_top_and_bottom' => esc_html__('From Top and Bottom',  'junotoys')
			);
			$list = apply_filters('junotoys_filter_portfolio_hovers_directions', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_hovers_directions', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the label positions in the custom forms
if ( !function_exists( 'junotoys_get_list_label_positions' ) ) {
	function junotoys_get_list_label_positions($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_label_positions'))=='') {
			$list = array(
				'top'		=> esc_html__('Top',		'junotoys'),
				'bottom'	=> esc_html__('Bottom',		'junotoys'),
				'left'		=> esc_html__('Left',		'junotoys'),
				'over'		=> esc_html__('Over',		'junotoys')
			);
			$list = apply_filters('junotoys_filter_label_positions', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_label_positions', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the bg image positions
if ( !function_exists( 'junotoys_get_list_bg_image_positions' ) ) {
	function junotoys_get_list_bg_image_positions($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_bg_image_positions'))=='') {
			$list = array(
				'left top'	   => esc_html__('Left Top', 'junotoys'),
				'center top'   => esc_html__("Center Top", 'junotoys'),
				'right top'    => esc_html__("Right Top", 'junotoys'),
				'left center'  => esc_html__("Left Center", 'junotoys'),
				'center center'=> esc_html__("Center Center", 'junotoys'),
				'right center' => esc_html__("Right Center", 'junotoys'),
				'left bottom'  => esc_html__("Left Bottom", 'junotoys'),
				'center bottom'=> esc_html__("Center Bottom", 'junotoys'),
				'right bottom' => esc_html__("Right Bottom", 'junotoys')
			);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_bg_image_positions', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the bg image repeat
if ( !function_exists( 'junotoys_get_list_bg_image_repeats' ) ) {
	function junotoys_get_list_bg_image_repeats($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_bg_image_repeats'))=='') {
			$list = array(
				'repeat'	=> esc_html__('Repeat', 'junotoys'),
				'repeat-x'	=> esc_html__('Repeat X', 'junotoys'),
				'repeat-y'	=> esc_html__('Repeat Y', 'junotoys'),
				'no-repeat'	=> esc_html__('No Repeat', 'junotoys')
			);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_bg_image_repeats', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the bg image attachment
if ( !function_exists( 'junotoys_get_list_bg_image_attachments' ) ) {
	function junotoys_get_list_bg_image_attachments($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_bg_image_attachments'))=='') {
			$list = array(
				'scroll'	=> esc_html__('Scroll', 'junotoys'),
				'fixed'		=> esc_html__('Fixed', 'junotoys'),
				'local'		=> esc_html__('Local', 'junotoys')
			);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_bg_image_attachments', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}


// Return list of the bg tints
if ( !function_exists( 'junotoys_get_list_bg_tints' ) ) {
	function junotoys_get_list_bg_tints($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_bg_tints'))=='') {
			$list = array(
				'white'	=> esc_html__('White', 'junotoys'),
				'light'	=> esc_html__('Light', 'junotoys'),
				'dark'	=> esc_html__('Dark', 'junotoys')
			);
			$list = apply_filters('junotoys_filter_bg_tints', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_bg_tints', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return custom fields types list, prepended inherit
if ( !function_exists( 'junotoys_get_list_field_types' ) ) {
	function junotoys_get_list_field_types($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_field_types'))=='') {
			$list = array(
				'text'     => esc_html__('Text',  'junotoys'),
				'textarea' => esc_html__('Text Area','junotoys'),
				'password' => esc_html__('Password',  'junotoys'),
				'radio'    => esc_html__('Radio',  'junotoys'),
				'checkbox' => esc_html__('Checkbox',  'junotoys'),
				'select'   => esc_html__('Select',  'junotoys'),
				'date'     => esc_html__('Date','junotoys'),
				'time'     => esc_html__('Time','junotoys'),
				'button'   => esc_html__('Button','junotoys')
			);
			$list = apply_filters('junotoys_filter_field_types', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_field_types', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return Google map styles
if ( !function_exists( 'junotoys_get_list_googlemap_styles' ) ) {
	function junotoys_get_list_googlemap_styles($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_googlemap_styles'))=='') {
			$list = array(
				'default' => esc_html__('Default', 'junotoys')
			);
			$list = apply_filters('junotoys_filter_googlemap_styles', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_googlemap_styles', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return iconed classes list
if ( !function_exists( 'junotoys_get_list_icons' ) ) {
	function junotoys_get_list_icons($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_icons'))=='') {
			$list = junotoys_parse_icons_classes(junotoys_get_file_dir("css/fontello/css/fontello-codes.css"));
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_icons', $list);
		}
		return $prepend_inherit ? array_merge(array('inherit'), $list) : $list;
	}
}

// Return socials list
if ( !function_exists( 'junotoys_get_list_socials' ) ) {
	function junotoys_get_list_socials($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_socials'))=='') {
			$list = junotoys_get_list_files("images/socials", "png");
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_socials', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return flags list
if ( !function_exists( 'junotoys_get_list_flags' ) ) {
	function junotoys_get_list_flags($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_flags'))=='') {
			$list = junotoys_get_list_files("images/flags", "png");
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_flags', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with 'Yes' and 'No' items
if ( !function_exists( 'junotoys_get_list_yesno' ) ) {
	function junotoys_get_list_yesno($prepend_inherit=false) {
		$list = array(
			'yes' => esc_html__("Yes", 'junotoys'),
			'no'  => esc_html__("No", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with 'On' and 'Of' items
if ( !function_exists( 'junotoys_get_list_onoff' ) ) {
	function junotoys_get_list_onoff($prepend_inherit=false) {
		$list = array(
			"on" => esc_html__("On", 'junotoys'),
			"off" => esc_html__("Off", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with 'Show' and 'Hide' items
if ( !function_exists( 'junotoys_get_list_showhide' ) ) {
	function junotoys_get_list_showhide($prepend_inherit=false) {
		$list = array(
			"show" => esc_html__("Show", 'junotoys'),
			"hide" => esc_html__("Hide", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with 'Ascending' and 'Descending' items
if ( !function_exists( 'junotoys_get_list_orderings' ) ) {
	function junotoys_get_list_orderings($prepend_inherit=false) {
		$list = array(
			"asc" => esc_html__("Ascending", 'junotoys'),
			"desc" => esc_html__("Descending", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with 'Horizontal' and 'Vertical' items
if ( !function_exists( 'junotoys_get_list_directions' ) ) {
	function junotoys_get_list_directions($prepend_inherit=false) {
		$list = array(
			"horizontal" => esc_html__("Horizontal", 'junotoys'),
			"vertical" => esc_html__("Vertical", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with item's shapes
if ( !function_exists( 'junotoys_get_list_shapes' ) ) {
	function junotoys_get_list_shapes($prepend_inherit=false) {
		$list = array(
			"round"  => esc_html__("Round", 'junotoys'),
			"square" => esc_html__("Square", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with item's sizes
if ( !function_exists( 'junotoys_get_list_sizes' ) ) {
	function junotoys_get_list_sizes($prepend_inherit=false) {
		$list = array(
			"tiny"   => esc_html__("Tiny", 'junotoys'),
			"small"  => esc_html__("Small", 'junotoys'),
			"medium" => esc_html__("Medium", 'junotoys'),
			"large"  => esc_html__("Large", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with slider (scroll) controls positions
if ( !function_exists( 'junotoys_get_list_controls' ) ) {
	function junotoys_get_list_controls($prepend_inherit=false) {
		$list = array(
			"hide" => esc_html__("Hide", 'junotoys'),
			"side" => esc_html__("Side", 'junotoys'),
			"bottom" => esc_html__("Bottom", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with float items
if ( !function_exists( 'junotoys_get_list_floats' ) ) {
	function junotoys_get_list_floats($prepend_inherit=false) {
		$list = array(
			"none" => esc_html__("None", 'junotoys'),
			"left" => esc_html__("Float Left", 'junotoys'),
			"right" => esc_html__("Float Right", 'junotoys')
		);
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with alignment items
if ( !function_exists( 'junotoys_get_list_alignments' ) ) {
	function junotoys_get_list_alignments($justify=false, $prepend_inherit=false) {
		$list = array(
			"none" => esc_html__("None", 'junotoys'),
			"left" => esc_html__("Left", 'junotoys'),
			"center" => esc_html__("Center", 'junotoys'),
			"right" => esc_html__("Right", 'junotoys')
		);
		if ($justify) $list["justify"] = esc_html__("Justify", 'junotoys');
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with horizontal positions
if ( !function_exists( 'junotoys_get_list_hpos' ) ) {
	function junotoys_get_list_hpos($prepend_inherit=false, $center=false) {
		$list = array();
		$list['left'] = esc_html__("Left", 'junotoys');
		if ($center) $list['center'] = esc_html__("Center", 'junotoys');
		$list['right'] = esc_html__("Right", 'junotoys');
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with vertical positions
if ( !function_exists( 'junotoys_get_list_vpos' ) ) {
	function junotoys_get_list_vpos($prepend_inherit=false, $center=false) {
		$list = array();
		$list['top'] = esc_html__("Top", 'junotoys');
		if ($center) $list['center'] = esc_html__("Center", 'junotoys');
		$list['bottom'] = esc_html__("Bottom", 'junotoys');
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return sorting list items
if ( !function_exists( 'junotoys_get_list_sortings' ) ) {
	function junotoys_get_list_sortings($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_sortings'))=='') {
			$list = array(
				"date" => esc_html__("Date", 'junotoys'),
				"title" => esc_html__("Alphabetically", 'junotoys'),
				"views" => esc_html__("Popular (views count)", 'junotoys'),
				"comments" => esc_html__("Most commented (comments count)", 'junotoys'),
				"author_rating" => esc_html__("Author rating", 'junotoys'),
				"users_rating" => esc_html__("Visitors (users) rating", 'junotoys'),
				"random" => esc_html__("Random", 'junotoys')
			);
			$list = apply_filters('junotoys_filter_list_sortings', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_sortings', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list with columns widths
if ( !function_exists( 'junotoys_get_list_columns' ) ) {
	function junotoys_get_list_columns($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_columns'))=='') {
			$list = array(
				"none" => esc_html__("None", 'junotoys'),
				"1_1" => esc_html__("100%", 'junotoys'),
				"1_2" => esc_html__("1/2", 'junotoys'),
				"1_3" => esc_html__("1/3", 'junotoys'),
				"2_3" => esc_html__("2/3", 'junotoys'),
				"1_4" => esc_html__("1/4", 'junotoys'),
				"3_4" => esc_html__("3/4", 'junotoys'),
				"1_5" => esc_html__("1/5", 'junotoys'),
				"2_5" => esc_html__("2/5", 'junotoys'),
				"3_5" => esc_html__("3/5", 'junotoys'),
				"4_5" => esc_html__("4/5", 'junotoys'),
				"1_6" => esc_html__("1/6", 'junotoys'),
				"5_6" => esc_html__("5/6", 'junotoys'),
				"1_7" => esc_html__("1/7", 'junotoys'),
				"2_7" => esc_html__("2/7", 'junotoys'),
				"3_7" => esc_html__("3/7", 'junotoys'),
				"4_7" => esc_html__("4/7", 'junotoys'),
				"5_7" => esc_html__("5/7", 'junotoys'),
				"6_7" => esc_html__("6/7", 'junotoys'),
				"1_8" => esc_html__("1/8", 'junotoys'),
				"3_8" => esc_html__("3/8", 'junotoys'),
				"5_8" => esc_html__("5/8", 'junotoys'),
				"7_8" => esc_html__("7/8", 'junotoys'),
				"1_9" => esc_html__("1/9", 'junotoys'),
				"2_9" => esc_html__("2/9", 'junotoys'),
				"4_9" => esc_html__("4/9", 'junotoys'),
				"5_9" => esc_html__("5/9", 'junotoys'),
				"7_9" => esc_html__("7/9", 'junotoys'),
				"8_9" => esc_html__("8/9", 'junotoys'),
				"1_10"=> esc_html__("1/10", 'junotoys'),
				"3_10"=> esc_html__("3/10", 'junotoys'),
				"7_10"=> esc_html__("7/10", 'junotoys'),
				"9_10"=> esc_html__("9/10", 'junotoys'),
				"1_11"=> esc_html__("1/11", 'junotoys'),
				"2_11"=> esc_html__("2/11", 'junotoys'),
				"3_11"=> esc_html__("3/11", 'junotoys'),
				"4_11"=> esc_html__("4/11", 'junotoys'),
				"5_11"=> esc_html__("5/11", 'junotoys'),
				"6_11"=> esc_html__("6/11", 'junotoys'),
				"7_11"=> esc_html__("7/11", 'junotoys'),
				"8_11"=> esc_html__("8/11", 'junotoys'),
				"9_11"=> esc_html__("9/11", 'junotoys'),
				"10_11"=> esc_html__("10/11", 'junotoys'),
				"1_12"=> esc_html__("1/12", 'junotoys'),
				"5_12"=> esc_html__("5/12", 'junotoys'),
				"7_12"=> esc_html__("7/12", 'junotoys'),
				"10_12"=> esc_html__("10/12", 'junotoys'),
				"11_12"=> esc_html__("11/12", 'junotoys')
			);
			$list = apply_filters('junotoys_filter_list_columns', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_columns', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return list of locations for the dedicated content
if ( !function_exists( 'junotoys_get_list_dedicated_locations' ) ) {
	function junotoys_get_list_dedicated_locations($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_dedicated_locations'))=='') {
			$list = array(
				"default" => esc_html__('As in the post defined', 'junotoys'),
				"center"  => esc_html__('Above the text of the post', 'junotoys'),
				"left"    => esc_html__('To the left the text of the post', 'junotoys'),
				"right"   => esc_html__('To the right the text of the post', 'junotoys'),
				"alter"   => esc_html__('Alternates for each post', 'junotoys')
			);
			$list = apply_filters('junotoys_filter_list_dedicated_locations', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_dedicated_locations', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return post-format name
if ( !function_exists( 'junotoys_get_post_format_name' ) ) {
	function junotoys_get_post_format_name($format, $single=true) {
		$name = '';
		if ($format=='gallery')		$name = $single ? esc_html__('gallery', 'junotoys') : esc_html__('galleries', 'junotoys');
		else if ($format=='video')	$name = $single ? esc_html__('video', 'junotoys') : esc_html__('videos', 'junotoys');
		else if ($format=='audio')	$name = $single ? esc_html__('audio', 'junotoys') : esc_html__('audios', 'junotoys');
		else if ($format=='image')	$name = $single ? esc_html__('image', 'junotoys') : esc_html__('images', 'junotoys');
		else if ($format=='quote')	$name = $single ? esc_html__('quote', 'junotoys') : esc_html__('quotes', 'junotoys');
		else if ($format=='link')	$name = $single ? esc_html__('link', 'junotoys') : esc_html__('links', 'junotoys');
		else if ($format=='status')	$name = $single ? esc_html__('status', 'junotoys') : esc_html__('statuses', 'junotoys');
		else if ($format=='aside')	$name = $single ? esc_html__('aside', 'junotoys') : esc_html__('asides', 'junotoys');
		else if ($format=='chat')	$name = $single ? esc_html__('chat', 'junotoys') : esc_html__('chats', 'junotoys');
		else						$name = $single ? esc_html__('standard', 'junotoys') : esc_html__('standards', 'junotoys');
		return apply_filters('junotoys_filter_list_post_format_name', $name, $format);
	}
}

// Return post-format icon name (from Fontello library)
if ( !function_exists( 'junotoys_get_post_format_icon' ) ) {
	function junotoys_get_post_format_icon($format) {
		$icon = 'icon-';
		if ($format=='gallery')		$icon .= 'pictures';
		else if ($format=='video')	$icon .= 'video';
		else if ($format=='audio')	$icon .= 'note';
		else if ($format=='image')	$icon .= 'picture';
		else if ($format=='quote')	$icon .= 'quote';
		else if ($format=='link')	$icon .= 'link';
		else if ($format=='status')	$icon .= 'comment';
		else if ($format=='aside')	$icon .= 'doc-text';
		else if ($format=='chat')	$icon .= 'chat';
		else						$icon .= 'book-open';
		return apply_filters('junotoys_filter_list_post_format_icon', $icon, $format);
	}
}

// Return fonts styles list, prepended inherit
if ( !function_exists( 'junotoys_get_list_fonts_styles' ) ) {
	function junotoys_get_list_fonts_styles($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_fonts_styles'))=='') {
			$list = array(
				'i' => esc_html__('I','junotoys'),
				'u' => esc_html__('U', 'junotoys')
			);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_fonts_styles', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return Google fonts list
if ( !function_exists( 'junotoys_get_list_fonts' ) ) {
	function junotoys_get_list_fonts($prepend_inherit=false) {
		if (($list = junotoys_storage_get('list_fonts'))=='') {
			$list = array();
			$list = junotoys_array_merge($list, junotoys_get_list_font_faces());
			// Google and custom fonts list:
			//$list['Advent Pro'] = array(
			//		'family'=>'sans-serif',																						// (required) font family
			//		'link'=>'Advent+Pro:100,100italic,300,300italic,400,400italic,500,500italic,700,700italic,900,900italic',	// (optional) if you use Google font repository
			//		'css'=>junotoys_get_file_url('/css/font-face/Advent-Pro/stylesheet.css')									// (optional) if you use custom font-face
			//		);
			$list = junotoys_array_merge($list, array(
				'Advent Pro' => array('family'=>'sans-serif'),
				'Alegreya Sans' => array('family'=>'sans-serif'),
				'Arimo' => array('family'=>'sans-serif'),
				'Asap' => array('family'=>'sans-serif'),
				'Averia Sans Libre' => array('family'=>'cursive'),
				'Averia Serif Libre' => array('family'=>'cursive'),
				'Bree Serif' => array('family'=>'serif',),
				'Cabin' => array('family'=>'sans-serif'),
				'Cabin Condensed' => array('family'=>'sans-serif'),
				'Caudex' => array('family'=>'serif'),
				'Comfortaa' => array('family'=>'cursive'),
				'Cousine' => array('family'=>'sans-serif'),
				'Crimson Text' => array('family'=>'serif'),
				'Cuprum' => array('family'=>'sans-serif'),
				'Dosis' => array('family'=>'sans-serif'),
				'Economica' => array('family'=>'sans-serif'),
				'Exo' => array('family'=>'sans-serif'),
				'Expletus Sans' => array('family'=>'cursive'),
				'Fredoka One' => array('family'=>'cursive'),
				'Karla' => array('family'=>'sans-serif'),
				'Lato' => array('family'=>'sans-serif'),
				'Lekton' => array('family'=>'sans-serif'),
				'Lobster Two' => array('family'=>'cursive'),
				'Maven Pro' => array('family'=>'sans-serif'),
				'Merriweather' => array('family'=>'serif'),
				'Montserrat' => array('family'=>'sans-serif'),
				'Neuton' => array('family'=>'serif'),
				'Noticia Text' => array('family'=>'serif'),
				'Old Standard TT' => array('family'=>'serif'),
				'Open Sans' => array('family'=>'sans-serif'),
				'Orbitron' => array('family'=>'sans-serif'),
				'Oswald' => array('family'=>'sans-serif'),
				'Overlock' => array('family'=>'cursive'),
				'Oxygen' => array('family'=>'sans-serif'),
				'Philosopher' => array('family'=>'serif'),
				'PT Serif' => array('family'=>'serif'),
				'Puritan' => array('family'=>'sans-serif'),
				'Raleway' => array('family'=>'sans-serif'),
				'Roboto' => array('family'=>'sans-serif'),
				'Roboto Slab' => array('family'=>'sans-serif'),
				'Roboto Condensed' => array('family'=>'sans-serif'),
				'Rosario' => array('family'=>'sans-serif'),
				'Share' => array('family'=>'cursive'),
				'Signika' => array('family'=>'sans-serif'),
				'Signika Negative' => array('family'=>'sans-serif'),
				'Source Sans Pro' => array('family'=>'sans-serif'),
				'Tinos' => array('family'=>'serif'),
				'Ubuntu' => array('family'=>'sans-serif'),
				'Vollkorn' => array('family'=>'serif')
				)
			);
			$list = apply_filters('junotoys_filter_list_fonts', $list);
			if (junotoys_get_theme_setting('use_list_cache')) junotoys_storage_set('list_fonts', $list);
		}
		return $prepend_inherit ? junotoys_array_merge(array('inherit' => esc_html__("Inherit", 'junotoys')), $list) : $list;
	}
}

// Return Custom font-face list
if ( !function_exists( 'junotoys_get_list_font_faces' ) ) {
	function junotoys_get_list_font_faces($prepend_inherit=false) {
		static $list = false;
		if (is_array($list)) return $list;
		$list = array();
		$dir = junotoys_get_folder_dir("css/font-face");
		if ( is_dir($dir) ) {
			$hdir = @ opendir( $dir );
			if ( $hdir ) {
				while (($file = readdir( $hdir ) ) !== false ) {
					$pi = pathinfo( ($dir) . '/' . ($file) );
					if ( substr($file, 0, 1) == '.' || ! is_dir( ($dir) . '/' . ($file) ) )
						continue;
					$css = file_exists( ($dir) . '/' . ($file) . '/' . ($file) . '.css' ) 
						? junotoys_get_folder_url("css/font-face/".($file).'/'.($file).'.css')
						: (file_exists( ($dir) . '/' . ($file) . '/stylesheet.css' ) 
							? junotoys_get_folder_url("css/font-face/".($file).'/stylesheet.css')
							: '');
					if ($css != '')
						$list[$file . ' (' . esc_html__('uploaded font', 'junotoys') . ')'] = array('css' => $css);
				}
				@closedir( $hdir );
			}
		}
		return $list;
	}
}
?>