<?php
/**
* @package com_splms
* @subpackage  mod_splmupcomingevents
*
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class ModSplmsupcomingeventsHelper {

	public static function getUpcomingEvents($params) {

		// Now time
		$nowDate = date('Y-m-d');

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from($db->quoteName('#__splms_events'));
		$query->where('language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		$query->where($db->quoteName('access')." IN (" . implode( ',', JFactory::getUser()->getAuthorisedViewLevels() ) . ")");
		$query->where($db->quoteName('published'). " = " .$db->quote('1'));
		$query->where($db->quoteName('event_start_date')." > ". $db->quote($nowDate));
		$query->order('event_start_date'. ' ASC');
		$query->setLimit($params->get('limit', 5));
		$db->setQuery($query);
		$items = $db->loadObjectList();

		foreach ($items as &$item) {
			$item->url  = JRoute::_('index.php?option=com_splms&view=event&id='.$item->id.':'.$item->alias . SplmsHelper::getItemid('events'));
		}

		// if (empty($items)) {
		// 	$items= JTEXT::_('COM_SPLMS_NO_ITEMS_FOUND');
		// }

		return $items;

	}

}
