<?php
/**
* @package com_splms
* @subpackage  mod_splmspersons
*
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');


class ModSplmspersonsHelper {

	// Get teachers
	public static function getTeachers($params) {

		$item_type = $params->get('person_type', 'teachers');
		$ordering = $params->get('ordering', 'DESC');

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select(array('*'));
		if ($item_type == 'spekaers') {
			$query->from($db->quoteName('#__splms_speakers'));
		} else {
			$query->from($db->quoteName('#__splms_teachers'));
		}

		$query->where('language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		$query->where($db->quoteName('access')." IN (" . implode( ',', JFactory::getUser()->getAuthorisedViewLevels() ) . ")");
		$query->where($db->quoteName('published')." = 1");
		$query->setLimit($params->get('limit', 4));
		$query->order('ordering ' . $ordering);
		$db->setQuery($query);
		$results = $db->loadObjectList();

		foreach ($results as $result) {
			if ($item_type == 'spekaers') {
				$result->url = JRoute::_('index.php?option=com_splms&view=speaker&id='.$result->id.':'.$result->alias . SplmsHelper::getItemid('speakers'));
			} else {
				$result->url = JRoute::_('index.php?option=com_splms&view=teacher&id='.$result->id.':'.$result->alias . SplmsHelper::getItemid('teachers'));
			}
		}

		return $results;
	}


}
