<?php
/**
* @package com_splms
* @subpackage  mod_splmscart
*
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2017 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

//Joomla Component Helper & Get LMS Params
jimport('joomla.application.component.helper');
$splmsparams = JComponentHelper::getParams('com_splms');

//Get Currency
$currency = explode(':', $splmsparams->get('currency', 'USD:$'));
$currency =  $currency[1];

// Get image thumb
$thumb_size = strtolower($splmsparams->get('course_thumbnail_small', '100X60'));
$cart_url = JRoute::_('index.php?option=com_splms&view=cart'. splmshelper::getItemid('cart'));

?>

<div class="mod-splms-courses splms-cart-list <?php echo $moduleclass_sfx; ?>">
	<div class="cart-icon">
		<i class="fa fa-shopping-bag"></i>
	</div>
	
	<div class="splms-courses-list-wrap">
	<?php if(count($items)){ ?>
		<ul class="splms-courses-list">
			<?php $total = 0; ?>
			<?php foreach ($items as $item) { ?>
			<?php $generate_price = SplmsHelper::generateCurrency($item->price, $item->sale_price); ?>
			<?php $cart_price = ($item->sale_price) ? $item->sale_price: $item->price; ?>
			<li class="mod-splms-course clearfix">
				<div>
					<a href="<?php echo $item->url; ?>">
						<?php
						$filename = basename($item->image);
						$path = JPATH_BASE .'/'. dirname($item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb_size . '.' . JFile::getExt($filename);
						$src = JURI::base(true) . '/' . dirname($item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb_size . '.' . JFile::getExt($filename);

						if(JFile::exists($path)) {
							$thumb = $src;
						} else {
							$thumb = $item->image;	
						} ?>
						<a href="<?php echo $item->url; ?>">
							<img src="<?php echo $thumb; ?>" class="splms-course-img splms-img-responsive" alt="<?php echo $item->title; ?>">
						</a>
					</a>
				</div>
				
				<div class="course-title-wrap">
					<h3 class="splms-course-title">
						<a href="<?php echo $item->url; ?>" class="splms-course-title"><?php echo $item->title; ?></a>
					</h3>
					<ul class="course-info">
						<?php if(count($item->teachers)) { ?>
							<li>
							<?php if(count($item->teachers) == 1) { ?>
								<?php foreach ($item->teachers as $teacher) { ?>
									<a href="<?php echo $teacher->url; ?>"><?php echo $teacher->title; ?></a>
								<?php } ?>
							<?php } else { ?>
								<?php echo JTEXT::_('MOD_SPLMS_CART_TEACHERS');?>
							<?php } ?>
							</li>
						<?php } if($item->total_durations) { ?>
						<li><i class="fa fa-clock"></i>
							<?php echo $item->total_durations[0] . 'm '; ?>
							<?php echo $item->total_durations[1] . 's'; ?>
						</li>
						<?php } if($item->total_enrolled){ ?>
						<li><i class="fa fa-user"></i> <?php echo $item->total_enrolled; ?></li>
						<?php } ?>
					</ul>
				</div>

				<div class="mod-splms-course-price">
					<?php echo $generate_price; ?>
				</div>
			</li>
				<?php $total = $total + $cart_price; ?>
			<?php } ?>
		</ul>
		

		<div class="splms-courses-footer">
			<div>
				<a href="<?php echo $cart_url; ?>" class="btn btn-primary"><?php echo JTEXT::_('MOD_SPLMS_CART_GOTO_CART');?></a>
			</div>
			<div class="total-cost">
				<p class="title"><?php echo JTEXT::_('MOD_SPLMS_CART_YOUR_TOTAL');?></p>
				<div class="cost"><?php echo SplmsHelper::generateCurrency($total); ?></div>
			</div>
		</div>
		<?php } else {?>
			<div class="cart-text-wrap">
				<span class="title"><?php echo JTEXT::_('MOD_SPLMS_CART_EMPTY');?></span>
			</div>
		<?php } ?>
	</div>
</div>

<script>
	
</script>
