<?php
/**
* @package com_splms
* @subpackage  mod_splmscourses
*
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2017 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

require_once JPATH_BASE . '/components/com_splms/helpers/helper.php';
require_once __DIR__ . '/helper.php';

JHtml::_('jquery.framework');
// Get input cookie object
$cookie  = JFactory::getApplication()->input->cookie;

$doc = JFactory::getDocument();
$doc->addStylesheet( JURI::root(true) . '/modules/mod_splmscart/assets/css/style.css' );
$doc->addStylesheet( JURI::root(true) . '/administrator/components/com_splms/assets/css/font-awesome.min.css' );
$doc->addScript( JURI::base(true) . '/modules/mod_splmscart/assets/js/main.js' );

$cookie_items = unserialize(base64_decode($cookie->get('splmsOrders')));
$cookie_items = (!is_array($cookie_items) && !$cookie_items) ? array() : $cookie_items;

// Load course model
jimport('joomla.application.component.model');
JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
$course_model = JModelLegacy::getInstance( 'courses', 'SplmsModel' );
$lessons_model = JModelLegacy::getInstance( 'Lessons', 'SplmsModel' );

$items = array();
foreach ($cookie_items as $cookie_item) {
	$items [] = ModSplmscartHelper::getCourseInfo($cookie_item['product_id']);
}

foreach ($items as $item) {
	$lessons      	= $lessons_model->getLessons( $item->id );
	$sum_durations = 0;
	foreach ($lessons as $lesson) {
		$exploded_times = explode(':', $lesson->video_duration);
		if (count($exploded_times) > 1) {
			$duration_seconds = ($exploded_times[0] * 60) + $exploded_times[1]; 
			$sum_durations += $duration_seconds;	
		}
	}
	$item->total_durations = explode(':', SplmsHelper::time_from_seconds($sum_durations));
	$item->teachers = $course_model->getCourseTeachers( $item->id );
	$item->total_enrolled = $course_model->getEnrolled($item->id);
}

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
require JModuleHelper::getLayoutPath('mod_splmscart', $params->get('layout', 'default'));