<?php
/**
 * @copyright (C) 2013 iJoomla, Inc. - All rights reserved.
 * @license GNU General Public License, version 2 (http://www.gnu.org/licenses/gpl-2.0.html)
 * @author iJoomla.com <webmaster@ijoomla.com>
 * @url https://www.jomsocial.com/license-agreement
 * The PHP code portions are distributed under the GPL license. If not otherwise stated, all images, manuals, cascading style sheets, and included JavaScript *are NOT GPL, and are released under the IJOOMLA Proprietary Use License v1.0
 * More info at https://www.jomsocial.com/license-agreement
 */
defined('_JEXEC') or die('Restricted access');
?>

<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="498" height="144" viewBox="0 0 498 144" class="joms-hide">
<defs>
<g id="joms-icon-bubbles">
    <path class="path1" d="M17 14.081c0 0.711 0.407 1.327 1 1.628v0.249c-0.166 0.023-0.335 0.035-0.508 0.035-1.063 0-2.021-0.446-2.699-1.16-0.41 0.109-0.844 0.168-1.293 0.168-2.485 0-4.5-1.791-4.5-4 0-2.209 2.015-4 4.5-4 2.485 0 4.5 1.791 4.5 4 0 0.865-0.309 1.665-0.834 2.32-0.107 0.232-0.166 0.489-0.166 0.761zM8 0c4.351 0 7.89 2.822 7.997 6.336-0.768-0.343-1.619-0.524-2.497-0.524-1.493 0-2.903 0.523-3.971 1.472-1.107 0.984-1.717 2.304-1.717 3.716 0 0.698 0.149 1.373 0.433 1.997-0.082 0.002-0.164 0.003-0.246 0.003-0.424 0-0.841-0.027-1.247-0.079-1.718 1.718-3.77 2.027-5.753 2.072v-0.421c1.071-0.525 2-1.48 2-2.572 0-0.152-0.012-0.302-0.034-0.448-1.809-1.192-2.966-3.012-2.966-5.052 0-3.59 3.582-6.5 8-6.5z"></path>
</g>
<g id="joms-icon-images">
    <path class="path1" d="M2 4v10h14v-10h-14zM15 12.333l-2-3.333-2.267 1.889-1.733-2.889-6 5v-8h12v7.333zM4 7.5c0-0.828 0.672-1.5 1.5-1.5s1.5 0.672 1.5 1.5c0 0.828-0.672 1.5-1.5 1.5-0.828 0-1.5-0.672-1.5-1.5zM14 2h-14v10h1v-9h13z"></path>
</g>
<g id="joms-icon-film">
    <path class="path1" d="M0 2v12h16v-12h-16zM3 13h-2v-2h2v2zM3 9h-2v-2h2v2zM3 5h-2v-2h2v2zM12 13h-8v-10h8v10zM15 13h-2v-2h2v2zM15 9h-2v-2h2v2zM15 5h-2v-2h2v2zM6 5v6l4-3z"></path>
</g>
<g id="joms-icon-switch">
    <path class="path1" d="M10 2.29v2.124c0.566 0.247 1.086 0.6 1.536 1.050 0.944 0.944 1.464 2.2 1.464 3.536s-0.52 2.591-1.464 3.536c-0.944 0.944-2.2 1.464-3.536 1.464s-2.591-0.52-3.536-1.464c-0.944-0.944-1.464-2.2-1.464-3.536s0.52-2.591 1.464-3.536c0.45-0.45 0.97-0.803 1.536-1.050v-2.124c-2.891 0.861-5 3.539-5 6.71 0 3.866 3.134 7 7 7 3.866 0 7-3.134 7-7 0-3.171-2.109-5.849-5-6.71zM7 0h2v8h-2z"></path>
</g>
<g id="joms-icon-calendar">
    <path class="path1" d="M5 6h2v2h-2zM8 6h2v2h-2zM11 6h2v2h-2zM2 12h2v2h-2zM5 12h2v2h-2zM8 12h2v2h-2zM5 9h2v2h-2zM8 9h2v2h-2zM11 9h2v2h-2zM2 9h2v2h-2zM13 0v1h-2v-1h-7v1h-2v-1h-2v16h15v-16h-2zM14 15h-13v-11h13v11z"></path>
</g>
<g id="joms-icon-bullhorn">
    <path class="path1" d="M16 6.707c0-3.139-0.919-5.687-2.054-5.707 0.005-0 0.009-0 0.014-0h-1.296c0 0-3.044 2.287-7.425 3.184-0.134 0.708-0.219 1.551-0.219 2.523 0 0.972 0.085 1.816 0.219 2.523 4.382 0.897 7.425 3.184 7.425 3.184h1.296c-0.005 0-0.009-0-0.014-0.001 1.136-0.020 2.054-2.567 2.054-5.707zM13.513 11.551c-0.147 0-0.305-0.152-0.387-0.243-0.197-0.22-0.387-0.562-0.55-0.989-0.363-0.957-0.564-2.239-0.564-3.611 0-1.372 0.2-2.655 0.564-3.611 0.162-0.428 0.353-0.77 0.55-0.99 0.081-0.091 0.24-0.243 0.387-0.243 0.147 0 0.305 0.152 0.387 0.243 0.197 0.22 0.387 0.562 0.55 0.99 0.363 0.957 0.564 2.239 0.564 3.611 0 1.372-0.2 2.655-0.564 3.611-0.162 0.428-0.353 0.77-0.55 0.989-0.081 0.091-0.24 0.243-0.387 0.243zM3.935 6.707c0-0.812 0.060-1.6 0.173-2.33-0.74 0.102-1.39 0.161-2.193 0.161-1.048 0-1.048 0-1.048 0l-0.867 1.479v1.378l0.867 1.479c0 0 0 0 1.048 0 0.803 0 1.453 0.059 2.193 0.161-0.113-0.729-0.173-1.518-0.173-2.33zM5.752 10.034l-2-0.383 1.279 5.024c0.066 0.26 0.324 0.391 0.573 0.291l1.852-0.741c0.249-0.1 0.349-0.374 0.222-0.611l-1.926-3.581zM13.513 8.574c-0.057 0-0.118-0.059-0.149-0.094-0.076-0.085-0.149-0.217-0.212-0.381-0.14-0.369-0.217-0.863-0.217-1.392 0-0.529 0.077-1.023 0.217-1.392 0.063-0.165 0.136-0.297 0.212-0.381 0.031-0.035 0.092-0.094 0.149-0.094 0.056 0 0.118 0.059 0.149 0.094 0.076 0.085 0.149 0.217 0.212 0.381 0.14 0.369 0.217 0.863 0.217 1.392 0 0.529-0.077 1.023-0.217 1.392-0.063 0.165-0.136 0.297-0.212 0.381-0.031 0.035-0.092 0.094-0.149 0.094z"></path>
</g>
<g id="joms-icon-users">
    <path class="path1" d="M11.484 12.584c-0.296-0.047-0.303-0.854-0.303-0.854s0.87-0.854 1.060-2.002c0.51 0 0.825-1.221 0.315-1.65 0.021-0.452 0.656-3.55-2.556-3.55-3.212 0-2.577 3.097-2.556 3.55-0.51 0.43-0.195 1.65 0.315 1.65 0.19 1.148 1.060 2.002 1.060 2.002s-0.007 0.807-0.303 0.854c-0.954 0.15-4.516 1.708-4.516 3.416h12c0-1.708-3.562-3.266-4.516-3.416zM5.376 12.856c0.689-0.424 1.525-0.817 2.212-1.053-0.246-0.351-0.52-0.827-0.693-1.392-0.241-0.196-0.437-0.477-0.562-0.822-0.126-0.345-0.174-0.732-0.135-1.089 0.028-0.256 0.101-0.495 0.213-0.705-0.068-0.728-0.116-2.157 0.819-3.199 0.363-0.404 0.821-0.695 1.37-0.87-0.098-1.012-0.612-2.2-2.601-2.2-3.212 0-2.577 3.097-2.556 3.55-0.51 0.43-0.195 1.65 0.315 1.65 0.19 1.148 1.060 2.002 1.060 2.002s-0.007 0.807-0.303 0.854c-0.954 0.151-4.516 1.708-4.516 3.416h5.15c0.074-0.048 0.149-0.096 0.226-0.144z"></path>
</g>
<g id="joms-icon-envelope">
    <path class="path1" d="M14.5 2h-13c-0.825 0-1.5 0.675-1.5 1.5v10c0 0.825 0.675 1.5 1.5 1.5h13c0.825 0 1.5-0.675 1.5-1.5v-10c0-0.825-0.675-1.5-1.5-1.5zM6.23 8.6l-4.23 3.295v-7.838l4.23 4.543zM2.756 4h10.488l-5.244 3.938-5.244-3.938zM6.395 8.777l1.605 1.723 1.605-1.723 3.29 4.223h-9.79l3.29-4.223zM9.77 8.6l4.23-4.543v7.838l-4.23-3.295z"></path>
</g>
</defs>
</svg>

<div id="cModule-HelloMe" class="joms-centered <?php echo $params->get('moduleclass_sfx'); ?>">

    <?php
    if ($my->isOnline() && $my->id != 0) {
        $inboxModel  = CFactory::getModel('inbox');
        $notifModel  = CFactory::getModel('notification');
        $friendModel = CFactory::getModel('friends');
        $profileid   = JRequest::getVar('userid', 0, 'GET');
        $filter      = array('user_id' => $my->id);

        $toolbar              = CToolbarLibrary::getInstance();
        $newMessageCount      = $toolbar->getTotalNotifications('inbox');
        $newEventInviteCount  = $toolbar->getTotalNotifications('events');
        $newFriendInviteCount = $toolbar->getTotalNotifications('friends');
        $newGroupInviteCount  = $toolbar->getTotalNotifications('groups');

        $myParams             = $my->getParams();
        $newNotificationCount = $notifModel->getNotificationCount($my->id, '0', $myParams->get('lastnotificationlist', ''));
        $newEventInviteCount  = $newEventInviteCount + $newNotificationCount;

        $params->def('unreadCount', $inboxModel->countUnRead($filter));
        $params->def('pending', $friendModel->countPending($my->id));
        $params->def('myLink', CRoute::_('index.php?option=com_community&view=profile&userid=' . $my->id));
        $params->def('myName', $my->getDisplayName());
        $params->def('myAvatar', $my->getAvatar());
        $params->def('myId', $my->id);
        $CUserPoints = new CUserPoints();
        $params->def('myKarma', $CUserPoints->getPointsImage($my));
        $params->def('enablephotos', $config->get('enablephotos'));
        $params->def('enablevideos', $config->get('enablevideos'));
        $params->def('enablegroups', $config->get('enablegroups'));
        $params->def('enableevents', $config->get('enableevents'));

        $enablekarma = $config->get('enablekarma') ? $params->get('show_karma', 1) : $config->get('enablekarma');
        $params->def('enablekarma', $enablekarma);

        $modHelloMeHelper = new modHelloMeHelper();
        $COwnerHelper     = new COwnerHelper();
        $js               = $modHelloMeHelper->getHelloMeScript($my->getStatus(), $COwnerHelper->isMine($my->id, $profileid));
        $document         = JFactory::getDocument();
        $document->addScriptDeclaration($js);

        if ($params->get('enable_facebookconnect', '1')) {
            $params->def('facebookuser', $modHelloMeHelper->isFacebookUser());
        } else {
            $params->def('facebookuser', false);
        }

        $unreadCount  = $params->get('unreadCount', 1);
        $pending      = $params->get('pending', 1);
        $myLink       = $params->get('myLink', 1);
        $myName       = $params->get('myName', 1);
        $myAvatar     = $params->get('myAvatar', 1);
        $myId         = $params->get('myId', 1);
        $myKarma      = $params->get('myKarma', 1);
        $enablephotos = $params->get('enablephotos', 1);
        $enablevideos = $params->get('enablevideos', 1);
        $enablegroups = $params->get('enablegroups', 1);
        $enableevents = $params->get('enableevents', 1);
        $show_avatar  = $params->get('show_avatar', 1);
        $show_karma   = $params->get('enablekarma', 1);

        $facebookuser = $params->get('facebookuser', false);
        $config       = CFactory::getConfig();
        $uri          = CRoute::_('index.php?option=com_community', false);
        $uri          = base64_encode($uri);

        $badge = new CBadge($my);
        $badge = $badge->getBadge();

        // IDs.
        $mainframe = JFactory::getApplication();
        $jinput = $mainframe->input;
        $my = CFactory::getUser();
        $userid = $jinput->get('userid', '', 'INT');
        $user = CFactory::getUser($userid);

        $document->addScriptDeclaration('joms_my_id = ' . $my->id . ';');
        $document->addScriptDeclaration('joms_user_id = ' . $user->id . ';');

        ?>

        <?php if ($show_avatar) { ?>
        <div class="joms-gap"></div>
        <div class="joms-avatar single">
            <img src="<?php echo $myAvatar; ?>" alt="<?php echo CStringHelper::escape($myName); ?>" />
        </div>
        <?php } ?>


        <div class="cHello-Header">

            <h3><a href="<?php echo CRoute::_('index.php?option=com_community&view=profile') ?>"><?php echo CStringHelper::escape($myName); ?></a></h3>

            <div class="cHello-Karma">
                <?php if ($show_karma && isset($badge->current->image)) { ?>
                    <img src="<?php echo $badge->current->image; ?>" alt="<?php echo JText::_('MOD_HELLOME_KARMA'); ?>"   />
                <?php } ?>
            </div>
            <span class="joms-js--mod-hellome-loading" style="display: none;"><img src="<?php echo JURI::base() . '/components/com_community/assets/wait.gif' ?>" alt="Loading..."/></span>

        </div><!--.cHello-Header-->


        <?php if ( $params->get('enable_alert',1) == 1 ) { ?>

            <div class="joms-hellome__notify">
                <a title="<?php echo JText::_('COM_COMMUNITY_NOTIFICATIONS_GLOBAL'); ?>"
                        href="javascript:" onclick="joms.popup.notification.global();">
                    <svg viewBox="0 0 16 16" class="joms-icon">
                        <use xlink:href="#joms-icon-bullhorn"></use>
                    </svg>
                    <span class="joms-js--notiflabel-general"><?php echo ($newEventInviteCount) ? $newEventInviteCount : 0 ;?></span>
                </a>
                <a title="<?php echo JText::_('COM_COMMUNITY_NOTIFICATIONS_INVITE_FRIENDS'); ?>"
                        href="<?php echo CRoute::_('index.php?option=com_community&view=friends&task=pending'); ?>"
                        onclick="joms.popup.notification.friend(); return false;">
                    <svg viewBox="0 0 16 16" class="joms-icon">
                        <use xlink:href="#joms-icon-users"></use>
                    </svg>
                    <span class="joms-js--notiflabel-frequest"><?php echo ($newFriendInviteCount) ? $newFriendInviteCount : 0 ;?></span>
                </a>
                <a title="<?php echo JText::_('COM_COMMUNITY_NOTIFICATIONS_INBOX'); ?>"
                        href="<?php echo CRoute::_('index.php?option=com_community&view=inbox'); ?>"
                        onclick="joms.popup.notification.pm(); return false;">
                    <svg viewBox="0 0 16 16" class="joms-icon">
                        <use xlink:href="#joms-icon-envelope"></use>
                    </svg>
                    <span class="joms-js--notiflabel-inbox"><?php echo ($newMessageCount) ? $newMessageCount : 0 ;?></span>
                </a>
            </div>

        <?php } ?>


        <?php if ( $params->get('enable_menu',1) == 1 ) { ?>
            <ul class="joms-list joms-hellome__menu">
                <li>
                    <svg viewBox="0 0 16 20" class="joms-icon">
                        <use xlink:href="#joms-icon-users"></use>
                    </svg>
                    <a href="<?php echo CRoute::_('index.php?option=com_community&view=friends&userid=' . $myId); ?>"><?php echo JText::_('MOD_HELLOME_MY_FRIENDS'); ?></a>
                </li>
                <?php if ($enablegroups) { ?>
                    <li>
                        <svg viewBox="0 0 16 20" class="joms-icon">
                            <use xlink:href="#joms-icon-bubbles"></use>
                        </svg>
                        <a href="<?php echo CRoute::_('index.php?option=com_community&view=groups&task=mygroups&userid=' . $myId); ?>"><?php echo JText::_('MOD_HELLOME_MY_GROUPS'); ?></a>
                    </li>
                <?php } ?>
                <?php if ($enablephotos) { ?>
                    <li>
                        <svg viewBox="0 0 16 20" class="joms-icon">
                            <use xlink:href="#joms-icon-images"></use>
                        </svg>
                        <a href="<?php echo CRoute::_('index.php?option=com_community&view=photos&task=myphotos&userid=' . $myId); ?>"><?php echo JText::_('MOD_HELLOME_MY_PHOTOS'); ?></a>
                    </li>
                <?php } ?>
                <?php if ($enablevideos) { ?>
                    <li>
                        <svg viewBox="0 0 16 20" class="joms-icon">
                            <use xlink:href="#joms-icon-camera2"></use>
                        </svg>
                        <a href="<?php echo CRoute::_('index.php?option=com_community&view=videos&task=myvideos&userid=' . $myId); ?>"><?php echo JText::_('MOD_HELLOME_MY_VIDEOS'); ?></a>
                    </li>
                <?php } ?>
                <?php if ($enableevents) { ?>
                    <li>
                        <svg viewBox="0 0 16 20" class="joms-icon">
                            <use xlink:href="#joms-icon-calendar"></use>
                        </svg>
                        <a href="<?php echo CRoute::_('index.php?option=com_community&view=events&task=myevents&userid=' . $myId); ?>"><?php echo JText::_('MOD_HELLOME_MY_EVENTS'); ?></a>
                    </li>
                <?php } ?>

                <li>
                <svg viewBox="0 0 16 20" class="joms-icon">
                    <use xlink:href="#joms-icon-switch"></use>
                </svg>
                <a href="javascript:void(0);" onclick="joms_mod_hellome.logout();"><?php echo JText::_('MOD_HELLOME_MY_LOGOUT'); ?></a></li>

            </ul><!--.cHello-Menu-->
        <?php } ?>

        <form action="<?php echo JRoute::_('index.php'); ?>" method="post" name="hellomelogout" id="hellomelogout">
            <input type="hidden" name="option" value="<?php echo COM_USER_NAME; ?>" />
            <input type="hidden" name="task" value="<?php echo COM_USER_TAKS_LOGOUT; ?>" />
            <input type="hidden" name="return" value="<?php echo $uri; ?>" />
            <?php echo JHtml::_('form.token'); ?>
        </form>
<?php } else {
    $content = '';

    if ($params->get('enable_login', '1')) {
        $uri = CRoute::_('index.php?option=com_community&view=' . $config->get('redirect_login'), false);
        $uri = base64_encode($uri);
        $html = '';

        if (JPluginHelper::isEnabled('authentication', 'openid')) {
            JHTML::_('script', 'openid');
        }
        ?>
            <form action="<?php echo CRoute::_('index.php?option=' . COM_USER_NAME . '&task=' . COM_USER_TAKS_LOGIN); ?>" method="post" name="form-login" id="form-login" >
            <?php echo $params->get('pretext'); ?>
                <fieldset class="input bottom-gap">
                    <p id="form-login-username">
                        <label for="username">
            <?php echo JText::_('COM_COMMUNITY_USERNAME') ?><br />
                            <input name="username" id="username" type="text" class="input-block-level" alt="username" size="18" />
                        </label>
                    </p>
                    <p id="form-login-password">
                        <label for="passwd">
                <?php echo JText::_('COM_COMMUNITY_PASSWORD') ?><br />
                            <input type="password" name="<?php echo COM_USER_PASSWORD_INPUT; ?>" id="passwd" class="input-block-level" size="18" alt="password" />
                        </label>
                    </p>
                            <?php if (JPluginHelper::isEnabled('system', 'remember')) { ?>
                        <p id="form-login-remember">
                            <label for="remember">
                                <input type="checkbox" name="remember" id="remember" value="yes" alt="Remember Me" />
                                &nbsp;<?php echo JText::_('COM_COMMUNITY_REMEMBER_MY_DETAILS') ?>
                            </label>
                        </p>
        <?php } ?>
                    <input type="submit" name="Submit" class="btn btn-primary" value="<?php echo JText::_('LOGIN') ?>" />
                </fieldset>

                <ul class="unstyled top-gap">
                    <li><a href="<?php echo JRoute::_('index.php?option=' . COM_USER_NAME . '&view=reset'); ?>"><?php echo JText::_('MOD_HELLOME_FORGOT_YOUR_PASSWORD'); ?></a></li>
                    <li><a href="<?php echo JRoute::_('index.php?option=' . COM_USER_NAME . '&view=remind'); ?>"><?php echo JText::_('MOD_HELLOME_FORGOT_YOUR_USERNAME'); ?></a></li>
                    <li><a href="<?php echo CRoute::_('index.php?option=com_community&view=register&task=activation'); ?>" class="login-forgot-username"><span><?php echo JText::_('MOD_HELLOME_RESEND_ACTIVATION_CODE'); ?></span></a></li>
        <?php
        $usersConfig = JComponentHelper::getParams('com_users');
        if ($usersConfig->get('allowUserRegistration')) {
            ?>
                        <li><a href="<?php echo CRoute::_('index.php?option=com_community&view=register'); ?>"><?php echo JText::_('MOD_HELLOME_REGISTER'); ?></a></li>
        <?php } ?>
                </ul>

        <?php echo $params->get('posttext'); ?>

                <input type="hidden" name="option" value="<?php echo COM_USER_NAME; ?>" />
                <input type="hidden" name="task" value="<?php echo COM_USER_TAKS_LOGIN; ?>" />
                <input type="hidden" name="return" value="<?php echo $uri; ?>" />
                    <?php echo JHTML::_('form.token'); ?>
            </form>
        <?php
    }

    if ($params->get('enable_facebookconnect', '1')) {
        /** detect and display facebook language * */
        defined('FACEBOOK_LANG_AVAILABLE') or define('FACEBOOK_LANG_AVAILABLE', 1);

        $lang = JFactory::getLanguage();
        $currentLang = $lang->get('tag');
        $fbLang = explode(',', trim(FACEBOOK_LANGUAGE));
        $currentLang = str_replace('-', '_', $currentLang);
        $fbLangCode = '//connect.facebook.net/en_GB/all.js';

        if (in_array($currentLang, $fbLang) == FACEBOOK_LANG_AVAILABLE) {
            $fbLangCode = '//connect.facebook.net/' . $currentLang . '/all.js';
        }

        if ($my->id == 0) {
            if ($config->get('fbconnectkey') && $config->get('fbconnectsecret') && !$config->get('usejfbc')) { ?>
                    <div id="fb-root"></div>

                    <script type="text/javascript">
                                function cFbInit() {
                                    // keep looping until user status is not 'notConnected'
                                    if (typeof window.FB != 'undefined'
                                            && window.FB._apiKey != '<?php echo $config->get('fbconnectkey'); ?>'
                                            && typeof window.jomFbinit == 'function') {
                                        jomFbinit();
                                    }
                                    else
                                    {
                                        setTimeout("cFbInit();", 500);
                                    }
                                }

                                cFbInit();
                    </script>
                    <script type="text/javascript" src="<?php echo $fbLangCode; ?>" ></script>
                    <script type="text/javascript">
                        function jomFbButtonInit() {
                            FB.init({
                                appId: '<?php echo $config->get('fbconnectkey'); ?>',
                                status: true,
                                cookie: true,
                                oauth: true,
                                xfbml: true
                            });
                        }

                        if (typeof window.FB != 'undefined') {
                            jomFbButtonInit();
                        } else {
                            window.fbAsyncInit = jomFbButtonInit;
                        }
                    </script>
                    <fb:login-button onlogin="joms.api.fbcUpdate();" scope="read_stream,publish_stream,offline_access,email,user_birthday,status_update,user_status"><?php echo JText::_('COM_COMMUNITY_SIGN_IN_WITH_FACEBOOK'); ?></fb:login-button>
                <?php
            }

            if ($config->get('usejfbc')) {
                $fbHtml = '';
                if (class_exists('JFBCFactory')) {
                    $providers = JFBCFactory::getAllProviders();
                    foreach ($providers as $p) {
                        $fbHtml .= $p->loginButton();
                    }
                }

                echo $fbHtml;
            }
        }
    }
}
?>
</div>
