
--
-- Database: `pb3_varsita`
--

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_action`
--

DROP TABLE IF EXISTS `#__acymailing_action`;
CREATE TABLE `#__acymailing_action` (
  `action_id` int(10) UNSIGNED NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `frequency` int(10) UNSIGNED NOT NULL,
  `nextdate` int(10) UNSIGNED NOT NULL,
  `server` varchar(255) NOT NULL,
  `port` varchar(50) NOT NULL,
  `connection_method` varchar(10) NOT NULL DEFAULT '0',
  `secure_method` varchar(10) NOT NULL DEFAULT '0',
  `self_signed` tinyint(4) NOT NULL DEFAULT '0',
  `username` varchar(255) NOT NULL,
  `password` varchar(50) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `conditions` text,
  `actions` text,
  `report` text,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `delete_wrong_emails` tinyint(4) NOT NULL DEFAULT '0',
  `senderfrom` tinyint(4) NOT NULL DEFAULT '0',
  `senderto` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_config`
--

DROP TABLE IF EXISTS `#__acymailing_config`;
CREATE TABLE `#__acymailing_config` (
  `namekey` varchar(200) NOT NULL,
  `value` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_config`
--

INSERT INTO `#__acymailing_config` (`namekey`, `value`) VALUES
('acyrss_description', ''),
('acyrss_element', '20'),
('acyrss_format', ''),
('acyrss_name', ''),
('acyrss_order', 'senddate'),
('add_names', '1'),
('allowedfiles', 'zip,doc,docx,pdf,xls,txt,gzip,rar,jpg,gif,xlsx,pps,csv,bmp,ico,odg,odp,ods,odt,png,ppt,swf,xcf,mp3,wma'),
('allow_modif', 'data'),
('allow_visitor', '1'),
('autosub', 'None'),
('bootstrap_frontend', '0'),
('bounce_action_lists_maxtry', '1'),
('bounce_action_maxtry', 'noaction'),
('bounce_email', 'install@joomshaper.com'),
('Business', '2'),
('captcha_plugin', 'no'),
('charset', 'UTF-8'),
('comments_feature', ''),
('confirmation_message', '1'),
('confirm_message', '0'),
('confirm_redirect', ''),
('cron_frequency', '900'),
('cron_fromip', ''),
('cron_fullreport', '1'),
('cron_last', '0'),
('cron_next', '1251990901'),
('cron_report', ''),
('cron_savepath', 'media/com_acymailing/logs/report{year}_{month}.log'),
('cron_savereport', '2'),
('cron_sendreport', '2'),
('cron_sendto', 'install@joomshaper.com'),
('css_backend', ''),
('css_frontend', 'default'),
('css_module', 'default'),
('description_business', 'Joomla!® Marketing Campaign'),
('description_enterprise', 'Joomla!® Newsletter System'),
('description_essential', 'Joomla!® Marketing Campaign'),
('description_sidekick', 'Joomla!® Newsletter Extension'),
('description_starter', 'Joomla!® Marketing Campaign'),
('disqus_shortname', ''),
('editor', 'acyeditor'),
('elasticemail_password', ''),
('elasticemail_port', 'rest'),
('elasticemail_username', ''),
('email_botscout', '0'),
('email_botscout_key', ''),
('email_checkdomain', '0'),
('email_iptimecheck', '0'),
('email_stopforumspam', '0'),
('embed_files', '1'),
('embed_images', '0'),
('encoding_format', '8bit'),
('Enterprise', '3'),
('Essential', '1'),
('expirationdate', '0'),
('export_excelsecurity', '1'),
('forward', '0'),
('from_email', 'install@joomshaper.com'),
('from_name', 'Shaper Varsita'),
('frontend_print', '0'),
('frontend_subject', '1'),
('generate_name', '1'),
('hostname', ''),
('indexFollow', '1'),
('installcomplete', '1'),
('itemid', '0'),
('lastlicensecheck', '1522304591'),
('last_maxexec_check', '1522305085'),
('latestversion', '5.9.6'),
('level', 'Starter'),
('mailer_method', 'phpmail'),
('max_execution_time', '480'),
('mediafolder', 'media/com_acymailing/upload'),
('menu_position', 'above'),
('modif_redirect', ''),
('module_redirect', ''),
('multiple_part', '1'),
('notification_accept', ''),
('notification_confirm', ''),
('notification_contact', ''),
('notification_contact_menu', ''),
('notification_created', ''),
('notification_refuse', ''),
('notification_unsub', ''),
('notification_unsuball', ''),
('open_popup', '1'),
('pluginNeedUpdate', ''),
('popup_height', '550'),
('popup_width', '750'),
('priority_followup', '2'),
('priority_newsletter', '3'),
('queue_nbmail', '40'),
('queue_nbmail_auto', '70'),
('queue_pause', '120'),
('queue_try', '3'),
('queue_type', 'auto'),
('redirect_tags', '0'),
('reply_email', 'install@joomshaper.com'),
('reply_name', 'Shaper Varsita'),
('require_confirmation', '0'),
('security_key', 'fhIc0VXkPwaAubFdJRuwMl5wY3Is8v'),
('sendmail_path', '/usr/sbin/sendmail'),
('sendorder', 'subid, ASC'),
('show_description', '1'),
('show_filter', '1'),
('show_footer', '1'),
('show_order', '1'),
('show_senddate', '1'),
('Sidekick', '4'),
('smtp_auth', '0'),
('smtp_host', 'localhost'),
('smtp_keepalive', '1'),
('smtp_password', ''),
('smtp_port', '25'),
('smtp_secured', ''),
('smtp_username', ''),
('special_chars', '0'),
('ssl_links', '0'),
('Starter', '0'),
('subscription_message', '1'),
('sub_redirect', ''),
('unsubscription_message', '1'),
('unsub_dispoptions', '1'),
('unsub_dispothersubs', '0'),
('unsub_intro', 'UNSUB_INTRO'),
('unsub_message', '1'),
('unsub_reasons', 'a:2:{i:0;s:21:\"UNSUB_SURVEY_FREQUENT\";i:1;s:21:\"UNSUB_SURVEY_RELEVANT\";}'),
('unsub_redirect', ''),
('unsub_survey', '1'),
('uploadfolder', 'media/com_acymailing/upload'),
('use_sef', '0'),
('version', '5.9.6'),
('website', 'http://localhost/pb3-compatible/jumpped/varsita_quickstart_j3_v3.0/'),
('welcome_message', '1'),
('word_wrapping', '150');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_fields`
--

DROP TABLE IF EXISTS `#__acymailing_fields`;
CREATE TABLE `#__acymailing_fields` (
  `fieldid` smallint(5) UNSIGNED NOT NULL,
  `fieldname` varchar(250) NOT NULL,
  `namekey` varchar(50) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `value` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` smallint(5) UNSIGNED DEFAULT '99',
  `options` text,
  `core` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `required` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `backend` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `frontcomp` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `default` text,
  `listing` tinyint(3) UNSIGNED DEFAULT NULL,
  `frontlisting` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontjoomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `frontjoomlaregistration` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `joomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `fieldcat` int(11) NOT NULL DEFAULT '0',
  `listingfilter` tinyint(4) DEFAULT NULL,
  `frontlistingfilter` tinyint(4) DEFAULT NULL,
  `frontform` tinyint(4) DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_fields`
--

INSERT INTO `#__acymailing_fields` (`fieldid`, `fieldname`, `namekey`, `type`, `value`, `published`, `ordering`, `options`, `core`, `required`, `backend`, `frontcomp`, `default`, `listing`, `frontlisting`, `frontjoomlaprofile`, `frontjoomlaregistration`, `joomlaprofile`, `access`, `fieldcat`, `listingfilter`, `frontlistingfilter`, `frontform`) VALUES
(1, 'NAMECAPTION', 'name', 'text', '', 1, 1, '', 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1),
(2, 'EMAILCAPTION', 'email', 'text', '', 1, 2, '', 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1),
(3, 'RECEIVE', 'html', 'radio', '0::JOOMEXT_TEXT\n1::HTML', 1, 3, '', 1, 1, 1, 1, '1', 1, 0, 0, 0, 0, 'all', 0, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_filter`
--

DROP TABLE IF EXISTS `#__acymailing_filter`;
CREATE TABLE `#__acymailing_filter` (
  `filid` mediumint(8) UNSIGNED NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `lasttime` int(10) UNSIGNED DEFAULT NULL,
  `trigger` text,
  `report` text,
  `action` text,
  `filter` text,
  `daycron` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_forward`
--

DROP TABLE IF EXISTS `#__acymailing_forward`;
CREATE TABLE `#__acymailing_forward` (
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `nbforwarded` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_geolocation`
--

DROP TABLE IF EXISTS `#__acymailing_geolocation`;
CREATE TABLE `#__acymailing_geolocation` (
  `geolocation_id` int(10) UNSIGNED NOT NULL,
  `geolocation_subid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `geolocation_type` varchar(255) NOT NULL DEFAULT 'subscription',
  `geolocation_ip` varchar(255) NOT NULL DEFAULT '',
  `geolocation_created` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `geolocation_latitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_longitude` decimal(9,6) NOT NULL DEFAULT '0.000000',
  `geolocation_postal_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_city` varchar(255) NOT NULL DEFAULT '',
  `geolocation_continent` varchar(255) NOT NULL DEFAULT '',
  `geolocation_timezone` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_history`
--

DROP TABLE IF EXISTS `#__acymailing_history`;
CREATE TABLE `#__acymailing_history` (
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `action` varchar(50) NOT NULL COMMENT 'different actions: created,modified,confirmed',
  `data` text,
  `source` text,
  `mailid` mediumint(8) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_history`
--

INSERT INTO `#__acymailing_history` (`subid`, `date`, `ip`, `action`, `data`, `source`, `mailid`) VALUES
(2, 1424869272, '10.0.1.17', 'created', '', 'HTTP_REFERER::http://10.0.1.11/joomla/2015/varsita/demo/index.php/home/home-2\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.115 Safari/537.36\nHTTP_HOST::10.0.1.11\nSERVER_ADDR::10.0.1.11\nREMOTE_ADDR::10.0.1.17\nREQUEST_URI::/joomla/2015/varsita/demo/index.php/home/home-2', 0),
(3, 1427104577, '10.0.1.3', 'created', '', 'HTTP_REFERER::http://10.0.1.17/update/2015/varsita_quickstart_j3/index.php/en/jomsocial/register/registerProfile?profileType=0\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36\nHTTP_HOST::10.0.1.17\nSERVER_ADDR::10.0.1.17\nREMOTE_ADDR::10.0.1.3\nREQUEST_URI::/update/2015/varsita_quickstart_j3/index.php/en/jomsocial/register/registerProfile?profileType=0\nQUERY_STRING::profileType=0', 0),
(3, 1427104711, '10.0.1.3', 'confirmed', 'EXECUTED_BY::84 ( admin )', 'HTTP_REFERER::http://10.0.1.17/update/2015/varsita_quickstart_j3/administrator/index.php?option=com_users&view=users\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36\nHTTP_HOST::10.0.1.17\nSERVER_ADDR::10.0.1.17\nREMOTE_ADDR::10.0.1.3\nREQUEST_URI::/update/2015/varsita_quickstart_j3/administrator/index.php?option=com_users&view=users\nQUERY_STRING::option=com_users&view=users', 0),
(4, 1444377294, '10.0.1.138', 'created', '', 'HTTP_REFERER::http://10.0.1.3/work/projects/2015/varsita/v1.3/index.php/en/joomla/users-component/registration-form\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36\nHTTP_HOST::10.0.1.3\nSERVER_ADDR::10.0.1.3\nREMOTE_ADDR::10.0.1.138\nREQUEST_URI::/work/projects/2015/varsita/v1.3/index.php/en/joomla/users-component/registration-form?task=registration.register\nQUERY_STRING::task=registration.register', 0),
(4, 1444377509, '', 'confirmed', 'EXECUTED_BY::632 ( admin )', 'HTTP_REFERER::http://localhost/work/projects/2015/varsita/v1.3/administrator/index.php?option=com_users&view=users\nHTTP_USER_AGENT::Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36\nHTTP_HOST::localhost\nSERVER_ADDR::::1\nREMOTE_ADDR::::1\nREQUEST_URI::/work/projects/2015/varsita/v1.3/administrator/index.php?option=com_users&view=users\nQUERY_STRING::option=com_users&view=users', 0),
(4, 1444383680, '10.0.1.138', 'confirmed', 'EXECUTED_BY::632 ( admin )', 'HTTP_REFERER::http://10.0.1.3/work/projects/2015/varsita/v1.3/administrator/index.php?option=com_users&view=users\nHTTP_USER_AGENT::Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36\nHTTP_HOST::10.0.1.3\nSERVER_ADDR::10.0.1.3\nREMOTE_ADDR::10.0.1.138\nREQUEST_URI::/work/projects/2015/varsita/v1.3/administrator/index.php?option=com_users&view=users\nQUERY_STRING::option=com_users&view=users', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_list`
--

DROP TABLE IF EXISTS `#__acymailing_list`;
CREATE TABLE `#__acymailing_list` (
  `name` varchar(250) NOT NULL,
  `description` text,
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `listid` smallint(5) UNSIGNED NOT NULL,
  `published` tinyint(4) DEFAULT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `color` varchar(30) DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `welmailid` mediumint(9) DEFAULT NULL,
  `unsubmailid` mediumint(9) DEFAULT NULL,
  `type` enum('list','campaign') NOT NULL DEFAULT 'list',
  `access_sub` varchar(250) NOT NULL DEFAULT 'all',
  `access_manage` varchar(250) NOT NULL DEFAULT 'none',
  `languages` varchar(250) NOT NULL DEFAULT 'all',
  `startrule` varchar(50) NOT NULL DEFAULT '0',
  `category` varchar(250) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_list`
--

INSERT INTO `#__acymailing_list` (`name`, `description`, `ordering`, `listid`, `published`, `userid`, `alias`, `color`, `visible`, `welmailid`, `unsubmailid`, `type`, `access_sub`, `access_manage`, `languages`, `startrule`, `category`) VALUES
('Newsletters', 'Receive our latest news', 1, 1, 1, 152, 'mailing_list', '#3366ff', 1, NULL, NULL, 'list', 'all', 'none', 'all', '0', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listcampaign`
--

DROP TABLE IF EXISTS `#__acymailing_listcampaign`;
CREATE TABLE `#__acymailing_listcampaign` (
  `campaignid` smallint(5) UNSIGNED NOT NULL,
  `listid` smallint(5) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listmail`
--

DROP TABLE IF EXISTS `#__acymailing_listmail`;
CREATE TABLE `#__acymailing_listmail` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_listsub`
--

DROP TABLE IF EXISTS `#__acymailing_listsub`;
CREATE TABLE `#__acymailing_listsub` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `subdate` int(10) UNSIGNED DEFAULT NULL,
  `unsubdate` int(10) UNSIGNED DEFAULT NULL,
  `status` tinyint(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_listsub`
--

INSERT INTO `#__acymailing_listsub` (`listid`, `subid`, `subdate`, `unsubdate`, `status`) VALUES
(1, 1, 1423205074, NULL, 1),
(1, 2, 1424869272, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_mail`
--

DROP TABLE IF EXISTS `#__acymailing_mail`;
CREATE TABLE `#__acymailing_mail` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `subject` text,
  `body` longtext NOT NULL,
  `altbody` longtext NOT NULL,
  `published` tinyint(4) DEFAULT '1',
  `senddate` int(10) UNSIGNED DEFAULT NULL,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `type` enum('news','autonews','followup','unsub','welcome','notification','joomlanotification','action','article') NOT NULL DEFAULT 'news',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `attach` text,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `tempid` smallint(6) NOT NULL DEFAULT '0',
  `key` varchar(200) DEFAULT NULL,
  `frequency` varchar(50) DEFAULT NULL,
  `params` text,
  `sentby` int(10) UNSIGNED DEFAULT NULL,
  `metakey` text,
  `metadesc` text,
  `filter` text,
  `language` varchar(50) NOT NULL DEFAULT '',
  `abtesting` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `summary` text NOT NULL,
  `favicon` text,
  `bccaddresses` varchar(250) DEFAULT NULL,
  `lastupdate` int(10) UNSIGNED DEFAULT NULL,
  `userlastupdate` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_mail`
--

INSERT INTO `#__acymailing_mail` (`mailid`, `subject`, `body`, `altbody`, `published`, `senddate`, `created`, `fromname`, `fromemail`, `replyname`, `replyemail`, `type`, `visible`, `userid`, `alias`, `attach`, `html`, `tempid`, `key`, `frequency`, `params`, `sentby`, `metakey`, `metadesc`, `filter`, `language`, `abtesting`, `thumb`, `summary`, `favicon`, `bccaddresses`, `lastupdate`, `userlastupdate`) VALUES
(1, 'New Subscriber on your website : {user:email}', '<p>Hello {subtag:name},</p><p>A new user has been created in AcyMailing : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_created', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(2, 'A User unsubscribed from all your lists : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from all your lists</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsuball', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(3, 'A User unsubscribed : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from your list</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsub', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(4, 'A User refuses to receive e-mails from your website : {user:email}', '<p>The User {user:name} : {user:email} refuses to receive any e-mail anymore from your website.</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_refuse', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(5, 'New contact from your website : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(6, 'A user subscribed or modified his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact_menu', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(7, 'A user confirmed his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user confirmed his subscription : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_confirm', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(8, '{subtag:name|ucfirst}, {trans:PLEASE_CONFIRM_SUB}', '<div style=\"text-align: center; width: 100%; background-color: #ffffff;\">\r\n			<table style=\"text-align:justify; margin:auto; background-color:#ebebeb; border:1px solid #e7e7e7\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"600\" align=\"center\" bgcolor=\"#ebebeb\">\r\n			<tbody>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"38px\"><img src=\"media/com_acymailing/templates/newsletter-4/images/top.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			<tr>\r\n			<td style=\"text-align:center\" width=\"600\">\r\n			<table style=\"margin:auto;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"520\">\r\n			<tbody>\r\n			<tr>\r\n			<td style=\"background-color: #ffffff; border: 1px solid #dbdbdb; padding: 20px; width: 500px; margin: 15px auto; text-align: left;\">\r\n			<h1>Hello {subtag:name|ucfirst},</h1>\r\n			<p>{trans:CONFIRM_MSG}<br /><br />{trans:CONFIRM_MSG_ACTIVATE}</p>\r\n			<br />\r\n			<p style=\"text-align:center;\"><strong>{confirm}{trans:CONFIRM_SUBSCRIPTION}{/confirm}</strong></p>\r\n			</td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</td>\r\n			</tr>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"40px\"><img src=\"media/com_acymailing/templates/newsletter-4/images/bottom.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'confirmation', NULL, 1, 1, NULL, NULL, 'a:3:{s:6:\"action\";s:7:\"confirm\";s:13:\"actionbtntext\";s:28:\"{trans:CONFIRM_SUBSCRIPTION}\";s:9:\"actionurl\";s:19:\"{confirm}{/confirm}\";}', NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(9, 'AcyMailing Cron Report {mainreport}', '<p>{report}</p><p>{detailreport}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'report', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(10, 'Modify your subscription', '<p>Hello {subtag:name}, </p><p>You requested some changes on your subscription,</p><p>Please {modify}click here{/modify} to be identified as the owner of this account and then modify your subscription.</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'modif', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(11, '{joomlacontent:current| type:title}', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n		<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width: 600px;\">\r\n			<tbody>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_2\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\" id=\"zone_3\"><img id=\"zone_29\" alt=\" - - - \" border=\"0\" src=\"http://localhost/pb3-compatible/jumpped/varsita_quickstart_j3_v3.0//media/com_acymailing/templates/newsletter-4/images/top.png\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_4\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_5\"></td>\r\n					<td class=\"w520 acyeditor_text\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: #ebebeb;\" width=\"520\" id=\"zone_6\"><strong>​</strong>​​​​​​​​<img alt=\"-\" border=\"0\" src=\"http://localhost/pb3-compatible/jumpped/varsita_quickstart_j3_v3.0//media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float: left; margin-right: 10px;\">\r\n						<h3>{joomlacontent:current| type:title}<span style=\"display: none;\">&nbsp;</span></h3>\r\n					</td>\r\n					<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_7\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_8\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_9\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_10\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_11\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_12\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_13\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_14\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_15\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_16\"></td>\r\n					<td class=\"w480 pict acyeditor_text\" style=\"background-color: #fff; text-align: left;\" width=\"480\" id=\"zone_17\">{joomlacontent:current| type:intro| format:TOP_LEFT| pict:1| link}</td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_18\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_19\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_20\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_21\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_22\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_23\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_24\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_25\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_26\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #ebebeb;\" width=\"600\" id=\"zone_27\"><img id=\"zone_31\" alt=\" - - - \" border=\"0\" src=\"http://localhost/pb3-compatible/jumpped/varsita_quickstart_j3_v3.0//media/com_acymailing/templates/newsletter-4/images/bottom.png\"></td>\r\n				</tr>\r\n			</tbody>\r\n		</table>\r\n		</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'article', 0, NULL, 'send-in-article', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_queue`
--

DROP TABLE IF EXISTS `#__acymailing_queue`;
CREATE TABLE `#__acymailing_queue` (
  `senddate` int(10) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `priority` tinyint(3) UNSIGNED DEFAULT '3',
  `try` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `paramqueue` varchar(250) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_rules`
--

DROP TABLE IF EXISTS `#__acymailing_rules`;
CREATE TABLE `#__acymailing_rules` (
  `ruleid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `ordering` smallint(6) DEFAULT NULL,
  `regex` text NOT NULL,
  `executed_on` text NOT NULL,
  `action_message` text NOT NULL,
  `action_user` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_stats`
--

DROP TABLE IF EXISTS `#__acymailing_stats`;
CREATE TABLE `#__acymailing_stats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `senthtml` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `senttext` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `senddate` int(10) UNSIGNED NOT NULL,
  `openunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `opentotal` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `bounceunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `fail` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `clicktotal` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `clickunique` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `unsub` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `forward` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `bouncedetails` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_subscriber`
--

DROP TABLE IF EXISTS `#__acymailing_subscriber`;
CREATE TABLE `#__acymailing_subscriber` (
  `subid` int(10) UNSIGNED NOT NULL,
  `email` varchar(200) NOT NULL,
  `userid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(250) NOT NULL DEFAULT '',
  `created` int(10) UNSIGNED DEFAULT NULL,
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `accept` tinyint(4) NOT NULL DEFAULT '1',
  `ip` varchar(100) DEFAULT NULL,
  `html` tinyint(4) NOT NULL DEFAULT '1',
  `key` varchar(250) DEFAULT NULL,
  `confirmed_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `confirmed_ip` varchar(100) DEFAULT NULL,
  `lastopen_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastopen_ip` varchar(100) DEFAULT NULL,
  `lastclick_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastsent_date` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `source` varchar(50) NOT NULL DEFAULT '',
  `filterflags` varchar(50) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_subscriber`
--

INSERT INTO `#__acymailing_subscriber` (`subid`, `email`, `userid`, `name`, `created`, `confirmed`, `enabled`, `accept`, `ip`, `html`, `key`, `confirmed_date`, `confirmed_ip`, `lastopen_date`, `lastopen_ip`, `lastclick_date`, `lastsent_date`, `source`, `filterflags`) VALUES
(1, 'install@joomshaper.com', 632, 'Super User', 1423028527, 1, 1, 1, NULL, 1, NULL, 0, NULL, 0, NULL, 0, 0, '', ''),
(2, 'sohanzakaria@yahoo.com', 85, 'Sohan Zakaria', 1424869272, 1, 1, 1, '10.0.1.17', 1, 'bJaX6l9YfukkLP', 0, NULL, 0, NULL, 0, 0, '', ''),
(3, 'rifatwahid@yahoo.com', 86, 'Rifat Wahid Alif', 1427104577, 1, 1, 1, '10.0.1.3', 1, 'MNoJ2bk1pR4OZe', 1427104711, '10.0.1.3', 0, NULL, 0, 0, 'joomla', ''),
(4, 'mdamjadrana@gmail.com', 633, 'hello mia', 1444377294, 1, 1, 1, '10.0.1.138', 1, 'FIgrfjJJu5kBJQ', 1444383680, '10.0.1.138', 0, NULL, 0, 0, 'joomla', ''),
(5, 'techjoomshaper@gmail.com', 728, 'Super User', 1507174278, 1, 1, 1, NULL, 1, NULL, 0, NULL, 0, NULL, 0, 0, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_tag`
--

DROP TABLE IF EXISTS `#__acymailing_tag`;
CREATE TABLE `#__acymailing_tag` (
  `tagid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_tagmail`
--

DROP TABLE IF EXISTS `#__acymailing_tagmail`;
CREATE TABLE `#__acymailing_tagmail` (
  `tagid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_template`
--

DROP TABLE IF EXISTS `#__acymailing_template`;
CREATE TABLE `#__acymailing_template` (
  `tempid` smallint(5) UNSIGNED NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  `body` longtext,
  `altbody` longtext,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `premium` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` smallint(5) UNSIGNED DEFAULT '0',
  `namekey` varchar(50) NOT NULL,
  `styles` text,
  `subject` varchar(250) DEFAULT NULL,
  `stylesheet` text,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `readmore` varchar(250) DEFAULT NULL,
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `category` varchar(250) NOT NULL DEFAULT '',
  `header` longtext
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__acymailing_template`
--

INSERT INTO `#__acymailing_template` (`tempid`, `name`, `description`, `body`, `altbody`, `created`, `published`, `premium`, `ordering`, `namekey`, `styles`, `subject`, `stylesheet`, `fromname`, `fromemail`, `replyname`, `replyemail`, `thumb`, `readmore`, `access`, `category`, `header`) VALUES
(1, 'Notification template', '', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\" style=\"text-align:center\">{readonline}This email contains graphics, so if you don\'t see them, view it in your browser{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width:600px\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\"><img alt=\" - - - \" src=\"media/com_acymailing/templates/newsletter-4/images/top.png\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"acyeditor_text w520\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: rgb(235, 235, 235);\" width=\"520\"><img alt=\"-\" src=\"media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float:left; margin-right:10px;\" />\r\n				<h3>Topic of your message</h3>\r\n\r\n				<h4>Subtitle for your message</h4>\r\n			</td>\r\n			<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"acyeditor_text w480 pict\" style=\"background-color:#fff; text-align: left;\" width=\"480\">\r\n			<h1>Dear {subtag:name},</h1>\r\n			Your message here...<br />\r\n			</td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w480\" height=\"20\" style=\"background-color:#fff;\" width=\"480\"></td>\r\n			<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\"></td>\r\n			<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\"></td>\r\n		</tr>\r\n		<tr style=\"line-height: 0px;\" class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"5\" style=\"background-color:#ebebeb;\" width=\"600\"><img alt=\" - - - \" src=\"media/com_acymailing/templates/newsletter-4/images/bottom.png\" /></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acyeditor_delete acyeditor_text\" style=\"text-align:center\">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 1, 'newsletter-4', 'a:10:{s:6:\"tag_h1\";s:76:\"color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;\";s:6:\"tag_h2\";s:106:\"color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;\";s:6:\"tag_h3\";s:144:\"color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;\";s:6:\"tag_h4\";s:117:\"color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;\";s:5:\"tag_a\";s:71:\"color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;\";s:19:\"acymailing_readmore\";s:90:\"font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;\";s:17:\"acymailing_online\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:16:\"acymailing_unsub\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:8:\"color_bg\";s:7:\"#ffffff\";s:18:\"acymailing_content\";s:19:\"text-align:justify;\";}', NULL, 'div,table,p, td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}\r\n\r\n@media (min-width:10px){\r\n	table[class=w600], td[class=w600] { width: 320px !important;}\r\n	table[class=w520], td[class=w520] { width: 280px !important;}\r\n	table[class=w480], td[class=w480] { width: 260px !important;}\r\n	td[class=w40] { width: 20px !important;}\r\n	td[class=w20] { width: 10px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w480 img {max-width:260px; height:auto !important;}\r\n}\r\n\r\n@media (min-width:480px) {\r\n	table[class=w600], td[class=w600] { width: 480px !important;}\r\n	table[class=w520], td[class=w520] { width: 440px !important;}\r\n	table[class=w480], td[class=w480] { width: 420px !important;}\r\n	td[class=w40] { width: 20px !important;}\r\n	td[class=w20] { width: 10px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w480 img {max-width:420px;  height:auto !important;}\r\n}\r\n@media (min-width:600px){\r\n	table[class=w600], td[class=w600] { width: 600px !important;}\r\n	table[class=w520], td[class=w520] { width: 520px !important;}\r\n	table[class=w480], td[class=w480] { width: 480px !important;}\r\n	td[class=w40] { width40px !important;}\r\n	td[class=w20] { width: 20px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w480 img {max-width:480px;  height:auto !important;}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-4/newsletter-4.png', '', 'all', '', NULL),
(2, 'Newspaper', '', '<div align=\"center\" style=\"width:100%; background-color:#454545; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#454545;\" width=\"600\">\r\n		<tr>\r\n			<td class=\"w600\">\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n					<tr class=\"acyeditor_delete\" >\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n						<td class=\"acyeditor_text w540\" style=\"font-family:Times New Roman, Times, serif; background-color:#ffffff; text-align:left\" width=\"540\">&nbsp;\r\n						<h1><img alt=\"logo\" src=\"media/com_acymailing/templates/newsletter-5/images/logo.png\" style=\"float: right; width: 107px; height: 70px;\" /></h1>\r\n\r\n						<h1>Your title here</h1>\r\n\r\n						<h3>your subtitle</h3>\r\n						</td>\r\n						<td class=\"w30\" style=\"line-height:0px; background-color:#ffffff\" width=\"30\"></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#e4e4e4\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"media/com_acymailing/templates/newsletter-5/images/header.png\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#ffffff\" valign=\"top\" width=\"600\"><img alt=\"banner\" src=\"media/com_acymailing/templates/newsletter-5/images/banner.png\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"---\" src=\"media/com_acymailing/templates/newsletter-5/images/separator.png\" /></td>\r\n					</tr>\r\n					<tr>\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n						<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; font-family:Times New Roman, Times, serif; font-size:13px; background-color:#ffffff\" width=\"540\">\r\n							<div>This issue will present the 5 last articles.<br />\r\n							{tableofcontents}<br />\r\n							{autocontent:|max:5|order:id,DESC|type:intro|link|pict:1}</div>\r\n						</td>\r\n						<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n					</tr>\r\n					<tr style=\"line-height: 0px;\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"background-color:#ffffff\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/newsletter-5/images/footer1.png\" width=\"600\" /></td>\r\n					</tr>\r\n					<tr>\r\n						<td class=\"acyfooter acyeditor_text w600\" colspan=\"3\" height=\"25\" style=\"text-align:center; background-color:#ebebeb;  color:#454545; font-family:Times New Roman, Times, serif; font-size:13px\" width=\"600\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">contact</a> | <a href=\"#\">Facebook</a> | <a href=\"#\">Twitter</a></td>\r\n					</tr>\r\n					<tr style=\"line-height: 0px;\">\r\n						<td class=\"w600\" colspan=\"3\" style=\"background-color:#454545;\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/newsletter-5/images/footer2.png\" width=\"600\" /></td>\r\n					</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\">{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>\r\n', '', NULL, 1, 0, 2, 'newsletter-5', 'a:10:{s:6:\"tag_h1\";s:71:\"color:#454545 !important; font-size:24px; font-weight:bold; margin:0px;\";s:6:\"tag_h2\";s:145:\"color:#b20000 !important; font-size:18px; font-weight:bold; margin:0px; margin-bottom:10px; padding-bottom:4px; border-bottom: 1px solid #d6d6d6;\";s:6:\"tag_h3\";s:76:\"color:#b20101 !important; font-weight:bold; font-size:18px; margin:10px 0px;\";s:6:\"tag_h4\";s:67:\"color:#e52323 !important; font-weight:bold; margin:0px; padding:0px\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#9d0000; text-decoration:none; border:none;\";s:19:\"acymailing_readmore\";s:152:\"cursor:pointer; color:#ffffff; background-color:#9d0000; border-top:1px solid #9d0000; border-bottom:1px solid #9d0000; padding:3px 5px; font-size:13px;\";s:17:\"acymailing_online\";s:148:\"color:#dddddd; text-decoration:none; font-size:13px; margin:10px; text-align:center; font-family:Times New Roman, Times, serif; padding-bottom:10px;\";s:8:\"color_bg\";s:7:\"#454545\";s:18:\"acymailing_content\";s:0:\"\";s:16:\"acymailing_unsub\";s:131:\"color:#dddddd; text-decoration:none; font-size:13px; text-align:center; font-family:Times New Roman, Times, serif; padding-top:10px\";}', NULL, '.acyfooter a{\r\n	color:#454545;\r\n}\r\n.dark{\r\n	color:#454545;\r\n	font-weight:bold;\r\n}\r\ndiv,table,p, td{font-family:\"Times New Roman\", Times, serif;font-size:13px;color:#575757;}\r\n\r\n\r\n\r\n@media (min-width:10px){\r\n	table[class=w600], td[class=w600] { width:320px !important; }\r\n	table[class=w540], td[class=w540] { width:260px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img {max-width:320px; height:auto !important; }\r\n	.w540 img {max-width:260px; height:auto !important; }\r\n}\r\n\r\n@media (min-width: 480px){\r\n	table[class=w600], td[class=w600] { width:480px !important; }\r\n	table[class=w540], td[class=w540] { width:420px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img {max-width:480px; height:auto !important; }\r\n	.w540 img {max-width:420px; height:auto !important; }\r\n}\r\n\r\n@media (min-width:600px){\r\n	table[class=w600], td[class=w600] { width:600px !important; }\r\n	table[class=w540], td[class=w540] { width:540px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img     {max-width:600px; height:auto !important; }\r\n	.w540 img {max-width:540px; height:auto !important; }\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-5/newsletter-5.png', '', 'all', '', NULL),
(3, 'Build Bio', '', '<div align=\"center\" style=\"width:100%; background-color:#3c3c3c; padding-bottom:20px; color:#ffffff;\">\r\n<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>» view it online.</strong>{/readonline}</div>\r\n\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"margin:auto; background-color:#ffffff; color:#575757;\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr>\r\n			<td>\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#eeeeee\" valign=\"bottom\" width=\"600\"><img alt=\"mail\" height=\"41\" src=\"media/com_acymailing/templates/newsletter-6/images/header.png\" width=\"600\" /></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w30\" style=\"color:#ffffff;\" width=\"30\"></td>\r\n					<td class=\"acyeditor_picture w540\" style=\"line-height:0px; background-color:#ffffff; text-align:center\" width=\"540\"><img alt=\"\" src=\"media/com_acymailing/templates/newsletter-6/images/banner.png\" style=\"width: 540px; height: 122px;\" /></td>\r\n					<td class=\"w30\" height=\"122\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\">\r\n					<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n					<td class=\"acyeditor_text w540\" height=\"25\" style=\"text-align:right; background-color:#b9cf00; color:#ffffff;\" width=\"540\"><span class=\"hide\">Newsletter</span> {date:3}</td>\r\n					<td class=\"w30\" style=\"background-color:#b9cf00; color:#ffffff;\" width=\"30\"></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w600\" colspan=\"3\" height=\"25\" style=\"background-color:#ffffff\" width=\"600\"></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n					<td class=\"acyeditor_text w540\" style=\"text-align:justify; color:#575757; background-color:#ffffff\" width=\"540\"><span class=\"intro\">Hello {subtag:name},</span><br />\r\n					<br />\r\n					Your introduction text here\r\n					<br />\r\n					<h2>Your title</h2>\r\n					<strong>Your catchphrase</strong><br />\r\n					Your content here <a href=\"#\">with some link</a><br />\r\n					<br />\r\n					More content<br />\r\n					<br />\r\n					<span class=\"acymailing_readmore\">Read More</span>\r\n\r\n					<h2>Another title</h2>\r\n					<img alt=\"picture\" height=\"160\" src=\"media/com_acymailing/templates/newsletter-6/images/picture.png\" style=\"float:left;\" width=\"193\" /> <strong>Another catchphrase</strong> Some content and <a href=\"#\">another link</a><br />\r\n					<br />\r\n					More content<br />\r\n					<br />\r\n					<span class=\"acymailing_readmore\">Read More</span></td>\r\n					<td class=\"w30\" style=\"background-color:#ffffff\" width=\"30\"></td>\r\n				</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td>\r\n			<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" width=\"600\">\r\n				<tr style=\"line-height: 0px;\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"line-height:0px; background-color:#efefef;\" valign=\"top\" width=\"600\"><img alt=\"--\" height=\"18\" src=\"media/com_acymailing/templates/newsletter-6/images/footer1.png\" width=\"600\" /></td>\r\n				</tr>\r\n				<tr>\r\n					<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n					<td class=\"acyfooter acyeditor_text w540\" style=\"text-align:right; background-color:#efefef; color:#575757;\" width=\"540\"><a href=\"#\">www.mywebsite.com</a> | <a href=\"#\">Contact</a><a href=\"#\"><img alt=\"message\" class=\"hide\" src=\"media/com_acymailing/templates/newsletter-6/images/mail.png\" style=\"border: medium none; width: 35px; height: 20px;\" /></a></td>\r\n					<td class=\"w30\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\" width=\"30\"></td>\r\n				</tr>\r\n				<tr style=\"line-height: 0px;\">\r\n					<td class=\"w600\" colspan=\"3\" style=\"background-color:#efefef; line-height:0px;\" valign=\"top\" width=\"600\"><img alt=\"--\" height=\"24\" src=\"media/com_acymailing/templates/newsletter-6/images/footer2.png\" width=\"600\" /></td>\r\n				</tr>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\" >{unsubscribe}If you\'re not interested any more <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 3, 'newsletter-6', 'a:9:{s:6:\"tag_h1\";s:69:\"font-weight:bold; font-size:14px;color:#3c3c3c !important;margin:0px;\";s:6:\"tag_h2\";s:129:\"color:#b9cf00 !important; font-size:14px; font-weight:bold; margin-top:20px; border-bottom:1px solid #d6d6d6; padding-bottom:4px;\";s:6:\"tag_h3\";s:149:\"color:#7e7e7e !important; font-size:14px; font-weight:bold; margin:20px 0px 0px 0px; border-bottom:1px solid #d6d6d6; padding-bottom:0px 0px 4px 0px;\";s:6:\"tag_h4\";s:84:\"color:#879700 !important; font-size:12px; font-weight:bold; margin:0px; padding:0px;\";s:8:\"color_bg\";s:7:\"#3c3c3c\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#a2b500; text-decoration:none; border:none;\";s:17:\"acymailing_online\";s:91:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-bottom:10px\";s:16:\"acymailing_unsub\";s:88:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-top:10px\";s:19:\"acymailing_readmore\";s:73:\"cursor:pointer; color:#ffffff; background-color:#b9cf00; padding:3px 5px;\";}', NULL, 'table, div, p, td{\r\n	font-family: Verdana, Arial, Helvetica, sans-serif;\r\n	font-size:11px;\r\n	color:#575757;\r\n}\r\n.intro{\r\n	font-weight:bold;\r\n	font-size:12px;}\r\n\r\n.acyfooter a{\r\n	color:#575757;}\r\n\r\n@media (min-width: 10px){\r\n	table[class=w600], td[class=w600]  { width:320px !important; }\r\n	table[class=w540], td[class=w540]  { width:260px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img{max-width:320px; height:auto !important}\r\n	.w540 img{max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	table[class=w600], td[class=w600]  { width:480px !important; }\r\n	table[class=w540], td[class=w540]  { width:420px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img{max-width:480px; height:auto !important}\r\n	.w540 img{max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	table[class=w600], td[class=w600]  { width:600px !important; }\r\n	table[class=w540], td[class=w540]  { width:540px !important; }\r\n	td[class=w30] { width:30px !important; }\r\n	.w600 img{max-width:600px; height:auto !important}\r\n	.w540 img{max-width:540px; height:auto !important}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-6/newsletter-6.png', '', 'all', '', NULL),
(4, 'Technology', '', '<div align=\"center\" style=\"width:100%; background-color:#575757; padding-bottom:20px; color:#999999;\">\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"background-color:#fff; color:#999999; margin:auto\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_online\">{readonline}If you can\'t see this e-mail properly, <span style=\"text-decoration:underline\">view it online</span>{/readonline}</span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/shadowtop.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/top.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text links w540\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd; text-align:right; color:#ababab\" width=\"540\"><a href=\"#\"><img alt=\"mail\" src=\"media/com_acymailing/templates/technology_resp/images/mail.jpg\" style=\"float:right; border:none\" /></a> Newsletter {mailid} | {date:%B %Y} |&nbsp; <a href=\"#\">www.acyba.com</a> |</td>\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" width=\"540\"><img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic1.jpg\" style=\"float:right\" />\r\n			<h1>Your title !</h1>\r\n\r\n			<h3>Your catchphrase</h3>\r\n			Your introduction content here</td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" src=\"media/com_acymailing/templates/technology_resp/images/separator1.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"background-color:#fafafa; color:#999999\" width=\"540\">\r\n			<h2>Your subtitle</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic2.jpg\" style=\"float:left\" />\r\n			<h3>Your catchphrase</h3>\r\n			Your content here<br />\r\n			<a href=\"#\">Some link</a> and some content<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /><br />\r\n			<br />\r\n			<br />\r\n			<br />\r\n			&nbsp;\r\n			<h2>Another subtitle</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic3.jpg\" style=\"float:right\" />\r\n			<h3>Another catchphrase</h3>\r\n			Other content<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" src=\"media/com_acymailing/templates/technology_resp/images/separator2.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text special w540\" style=\"color:#999999\" width=\"540\">\r\n			<h2>Best product of the month</h2>\r\n\r\n			<h3>Lorem ipsum dolor sit amet.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum doLiget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent.<br />\r\n			<br />\r\n			<img alt=\"read more\" src=\"media/com_acymailing/templates/technology_resp/images/readmore.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd; text-align:right; color:#ababab\" valign=\"bottom\" width=\"540\">Follow us | <img alt=\"facebook\" src=\"media/com_acymailing/templates/technology_resp/images/facebook.jpg\" style=\"border:none\" /> <img alt=\"twitter\" src=\"media/com_acymailing/templates/technology_resp/images/twitter.jpg\" style=\"border:none\" /> <img alt=\"pinterest\" src=\"media/com_acymailing/templates/technology_resp/images/pinterest.jpg\" style=\"border:none\" /> <img alt=\"rss\" src=\"media/com_acymailing/templates/technology_resp/images/rss.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/bottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" src=\"media/com_acymailing/templates/technology_resp/images/shadowbottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_unsub\">{unsubscribe}If you don\'t want to receive our news anymore, <span style=\"text-decoration:underline\">unsubscribe</span>{/unsubscribe} </span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>', '', NULL, 1, 0, 4, 'technology_resp', 'a:9:{s:6:\"tag_h1\";s:104:\"font-size:20px; margin:0px; margin-bottom:15px; padding:0px; font-weight:bold; color:#01bbe5 !important;\";s:6:\"tag_h2\";s:165:\"font-size:12px; font-weight:bold; color:#565656 !important; text-transform:uppercase; margin:10px 0px; padding:0px; padding-bottom:5px; border-bottom:1px solid #ddd;\";s:6:\"tag_h3\";s:104:\"color:#565656 !important; font-weight:bold; font-size:12px; margin:0px; margin-bottom:10px; padding:0px;\";s:6:\"tag_h4\";s:0:\"\";s:8:\"color_bg\";s:7:\"#575757\";s:5:\"tag_a\";s:62:\"cursor:pointer;color:#01bbe5;text-decoration:none;border:none;\";s:17:\"acymailing_online\";s:30:\"color:#d2d1d1; cursor:pointer;\";s:16:\"acymailing_unsub\";s:30:\"color:#d2d1d1; cursor:pointer;\";s:19:\"acymailing_readmore\";s:88:\"cursor:pointer; font-weight:bold; color:#fff; background-color:#01bbe5; padding:2px 5px;\";}', NULL, 'table, div, p , td{\r\n	font-family:Arial, Helvetica, sans-serif;\r\n	font-size:12px;\r\n}\r\np{margin:0px; padding:0px}\r\n\r\n.special h2{font-size:18px;\r\n	margin:0px;\r\n	margin-bottom:15px;\r\n	padding:0px;\r\n	font-weight:bold;\r\n	color:#01bbe5 !important;\r\n	text-transform:none;\r\n	border:none}\r\n\r\n.links a{color:#ababab}\r\n\r\n@media (min-width:10px){\r\n	table[class=w600], td[class=w600] { width:320px !important;}\r\n	table[class=w540], td[class=w540] { width:260px !important;}\r\n	td[class=w30] { width:30px !important;}\r\n	.w600 img {max-width:320px; height:auto !important}\r\n	.w540 img {max-width:260px; height:auto !important}\r\n}\r\n\r\n@media (min-width: 480px){\r\n	table[class=w600], td[class=w600] { width:480px !important;}\r\n	table[class=w540], td[class=w540] { width:420px !important;}\r\n	td[class=w30] { width:30px !important;}\r\n	.w600 img {max-width:480px; height:auto !important}\r\n	.w540 img {max-width:420px; height:auto !important}\r\n}\r\n\r\n@media (min-width:600px){\r\n	table[class=w600], td[class=w600] { width:600px !important;}\r\n	table[class=w540], td[class=w540] { width:540px !important;}\r\n	td[class=w30] { width:30px !important;}\r\n	.w600 img {max-width:600px; height:auto !important}\r\n	.w540 img {max-width:540px; height:auto !important}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/technology_resp/thumb.jpg', '', 'all', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_url`
--

DROP TABLE IF EXISTS `#__acymailing_url`;
CREATE TABLE `#__acymailing_url` (
  `urlid` int(10) UNSIGNED NOT NULL,
  `name` varchar(250) NOT NULL,
  `url` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_urlclick`
--

DROP TABLE IF EXISTS `#__acymailing_urlclick`;
CREATE TABLE `#__acymailing_urlclick` (
  `urlid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `click` smallint(5) UNSIGNED NOT NULL DEFAULT '0',
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__acymailing_userstats`
--

DROP TABLE IF EXISTS `#__acymailing_userstats`;
CREATE TABLE `#__acymailing_userstats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `html` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `sent` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `senddate` int(10) UNSIGNED NOT NULL,
  `open` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `opendate` int(11) NOT NULL,
  `bounce` tinyint(4) NOT NULL DEFAULT '0',
  `fail` tinyint(4) NOT NULL DEFAULT '0',
  `ip` varchar(100) DEFAULT NULL,
  `browser` varchar(255) DEFAULT NULL,
  `browser_version` tinyint(3) UNSIGNED DEFAULT NULL,
  `is_mobile` tinyint(3) UNSIGNED DEFAULT NULL,
  `mobile_os` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `bouncerule` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__assets`
--

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int(10) UNSIGNED NOT NULL COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 504, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":[],\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 2, 3, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 4, 11, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(4, 1, 12, 13, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 14, 15, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 16, 17, 1, 'com_config', 'com_config', '{}'),
(7, 1, 18, 87, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(8, 1, 88, 177, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.options\":[],\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(9, 1, 178, 179, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 180, 181, 1, 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 182, 185, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(12, 1, 186, 187, 1, 'com_login', 'com_login', '{}'),
(13, 1, 188, 189, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 190, 191, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 192, 193, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 194, 195, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(17, 1, 37, 38, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 198, 313, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(19, 1, 314, 321, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(20, 1, 322, 323, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(21, 1, 324, 325, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'),
(22, 1, 326, 327, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 328, 329, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(24, 1, 330, 333, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(26, 1, 334, 335, 1, 'com_wrapper', 'com_wrapper', '{}'),
(33, 1, 396, 397, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 8, 105, 108, 2, 'com_content.category.9', 'Uncategorised', '{\"core.create\":{\"10\":0,\"12\":0},\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(35, 3, 7, 8, 2, 'com_banners.category.10', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(36, 7, 23, 24, 2, 'com_contact.category.11', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(37, 19, 317, 318, 2, 'com_newsfeeds.category.12', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(40, 3, 9, 10, 2, 'com_banners.category.15', 'Sample Data-Banners', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(41, 7, 25, 86, 2, 'com_contact.category.16', 'Sample Data-Contact', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(42, 19, 319, 320, 2, 'com_newsfeeds.category.17', 'Sample Data-Newsfeeds', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(44, 8, 111, 152, 2, 'com_content.category.19', 'Joomla!', '{\"core.create\":{\"10\":0,\"12\":0},\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(46, 44, 138, 151, 3, 'com_content.category.21', 'Components', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(59, 41, 26, 27, 3, 'com_contact.category.34', 'Park Site', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(60, 41, 28, 85, 3, 'com_contact.category.35', 'Shop Site', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(61, 60, 29, 30, 4, 'com_contact.category.36', 'Staff', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(62, 60, 31, 84, 4, 'com_contact.category.37', 'Fruit Encyclopedia', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(63, 62, 32, 33, 5, 'com_contact.category.38', 'A', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(64, 62, 34, 35, 5, 'com_contact.category.39', 'B', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(65, 62, 36, 37, 5, 'com_contact.category.40', 'C', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(66, 62, 38, 39, 5, 'com_contact.category.41', 'D', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(67, 62, 40, 41, 5, 'com_contact.category.42', 'E', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(68, 62, 42, 43, 5, 'com_contact.category.43', 'F', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(69, 62, 44, 45, 5, 'com_contact.category.44', 'G', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(70, 62, 46, 47, 5, 'com_contact.category.45', 'H', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(71, 62, 48, 49, 5, 'com_contact.category.46', 'I', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(72, 62, 50, 51, 5, 'com_contact.category.47', 'J', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(73, 62, 52, 53, 5, 'com_contact.category.48', 'K', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(74, 62, 54, 55, 5, 'com_contact.category.49', 'L', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(75, 62, 56, 57, 5, 'com_contact.category.50', 'M', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(76, 62, 58, 59, 5, 'com_contact.category.51', 'N', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(77, 62, 60, 61, 5, 'com_contact.category.52', 'O', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(78, 62, 62, 63, 5, 'com_contact.category.53', 'P', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(79, 62, 64, 65, 5, 'com_contact.category.54', 'Q', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(80, 62, 66, 67, 5, 'com_contact.category.55', 'R', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(81, 62, 68, 69, 5, 'com_contact.category.56', 'S', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(82, 62, 70, 71, 5, 'com_contact.category.57', 'T', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(83, 62, 72, 73, 5, 'com_contact.category.58', 'U', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(84, 62, 74, 75, 5, 'com_contact.category.59', 'V', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(85, 62, 76, 77, 5, 'com_contact.category.60', 'W', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(86, 62, 78, 79, 5, 'com_contact.category.61', 'X', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(87, 62, 80, 81, 5, 'com_contact.category.62', 'Y', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(88, 62, 82, 83, 5, 'com_contact.category.63', 'Z', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(89, 46, 139, 140, 4, 'com_content.article.1', 'Administrator Components', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(100, 44, 114, 115, 3, 'com_content.category.71', 'Milky Way', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(104, 44, 116, 117, 3, 'com_content.article.8', 'Beginners', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(105, 46, 141, 142, 4, 'com_content.article.9', 'Contact', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(106, 46, 143, 144, 4, 'com_content.article.10', 'Content', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(119, 44, 118, 119, 3, 'com_content.article.21', 'Getting Help', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(120, 44, 120, 121, 3, 'com_content.article.22', 'Getting Started', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(122, 44, 122, 123, 3, 'com_content.article.24', 'Joomla!', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(130, 44, 124, 125, 3, 'com_content.article.32', 'Parameters', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(133, 44, 126, 127, 3, 'com_content.article.35', 'Professionals', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(136, 44, 128, 129, 3, 'com_content.article.38', 'Sample Sites', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(137, 46, 145, 146, 4, 'com_content.article.39', 'Search', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(145, 44, 130, 131, 3, 'com_content.article.47', 'The Joomla! Community', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(146, 44, 132, 133, 3, 'com_content.article.48', 'The Joomla! Project', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(148, 44, 134, 135, 3, 'com_content.article.50', 'Upgraders', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(150, 46, 147, 148, 4, 'com_content.article.52', 'Users', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(151, 44, 136, 137, 3, 'com_content.article.53', 'Using Joomla!', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(158, 46, 149, 150, 4, 'com_content.article.60', 'News Feeds', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(168, 34, 106, 107, 3, 'com_content.article.67', 'What\'s New in 1.5?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(169, 24, 331, 332, 2, 'com_users.category.77', 'Uncategorised', ''),
(173, 1, 398, 399, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'),
(175, 1, 400, 401, 1, 'com_tags', 'com_tags', '{\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(176, 1, 402, 403, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(177, 1, 404, 405, 1, 'com_ajax', 'com_ajax', '{}'),
(178, 1, 406, 407, 1, 'com_postinstall', 'com_postinstall', '{}'),
(179, 8, 153, 176, 2, 'com_content.category.79', 'Blog', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(181, 18, 199, 200, 2, 'com_modules.module.91', 'SP Page Builder', ''),
(182, 18, 201, 202, 2, 'com_modules.module.92', 'SP Page Builder Admin Menu', ''),
(183, 1, 408, 409, 1, 'com_spsimpleportfolio', 'spsimpleportfolio', '{}'),
(185, 18, 203, 204, 2, 'com_modules.module.17', 'Breadcrumbs', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(186, 18, 205, 206, 2, 'com_modules.module.35', 'Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(188, 18, 207, 208, 2, 'com_modules.module.95', 'Recent Post', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(189, 18, 209, 210, 2, 'com_modules.module.96', 'Our Partners', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(190, 18, 211, 212, 2, 'com_modules.module.97', 'Quick Link', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(191, 179, 154, 155, 3, 'com_content.category.80', 'News', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(192, 179, 156, 157, 3, 'com_content.category.81', 'Tutorial', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(193, 179, 158, 159, 3, 'com_content.category.82', 'Review', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(194, 179, 160, 161, 3, 'com_content.category.83', 'Updates', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(195, 179, 162, 163, 3, 'com_content.article.71', 'Online Learning Initiatives', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(196, 179, 164, 165, 3, 'com_content.article.72', 'Top innovation means promising future', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(197, 179, 166, 167, 3, 'com_content.article.73', 'Oxford University Libraries', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(198, 179, 168, 169, 3, 'com_content.article.74', 'CMS have new LMS technology', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(199, 179, 170, 171, 3, 'com_content.article.75', 'Radical Ideas for Reinventing Education', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(200, 179, 172, 173, 3, 'com_content.article.76', 'Courses Website Redesign', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(201, 179, 174, 175, 3, 'com_content.article.77', 'J! Geek - an online course about Joomla', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(202, 18, 213, 214, 2, 'com_modules.module.98', 'Portfolio Module', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(203, 18, 215, 216, 2, 'com_modules.module.99', 'Popular News', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(204, 18, 217, 218, 2, 'com_modules.module.100', 'Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(205, 18, 219, 220, 2, 'com_modules.module.101', 'Information', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(206, 18, 221, 222, 2, 'com_modules.module.102', 'Search', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(207, 18, 223, 224, 2, 'com_modules.module.103', 'Latest News', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(208, 18, 225, 226, 2, 'com_modules.module.104', 'Information', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(209, 18, 227, 228, 2, 'com_modules.module.105', 'Off Canvas Menu', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(211, 18, 229, 230, 2, 'com_modules.module.107', 'Portfolio Module -  Portfolio Home', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(212, 18, 231, 232, 2, 'com_modules.module.108', 'Helix 3 Preset', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(213, 18, 233, 234, 2, 'com_modules.module.109', 'SP Date', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(214, 1, 410, 411, 1, 'com_acymailing', 'acymailing', '{}'),
(216, 18, 235, 236, 2, 'com_modules.module.110', 'AcyMailing Module', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(217, 18, 237, 238, 2, 'com_modules.module.112', 'Higher Education', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(218, 18, 239, 240, 2, 'com_modules.module.113', 'About University', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(219, 18, 241, 242, 2, 'com_modules.module.114', 'Varsita Album', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(220, 18, 243, 244, 2, 'com_modules.module.115', 'Admissions', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(221, 18, 245, 246, 2, 'com_modules.module.116', 'Contact Us', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(222, 18, 247, 248, 2, 'com_modules.module.117', 'Quick Link', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(223, 18, 249, 250, 2, 'com_modules.module.118', 'Bottom-8', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(225, 18, 251, 252, 2, 'com_modules.module.119', 'SP LMS Courses', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(226, 18, 253, 254, 2, 'com_modules.module.120', 'SP LMS Courses Banner', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(227, 1, 460, 461, 1, 'com_splms.eventcategory.1', 'com_splms.eventcategory.1', ''),
(228, 1, 464, 465, 1, 'com_splms.eventcategory.2', 'com_splms.eventcategory.2', ''),
(229, 18, 255, 256, 2, 'com_modules.module.121', 'SP LMS Free Courses', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(230, 18, 257, 258, 2, 'com_modules.module.122', 'LMS Course Search', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(231, 18, 259, 260, 2, 'com_modules.module.123', 'Flicker Gallery', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(232, 18, 261, 262, 2, 'com_modules.module.124', 'Flickr Gallery', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(233, 1, 492, 493, 1, 'com_splms.coursescategory.1', 'com_splms.coursescategory.1', '{}'),
(234, 1, 412, 425, 1, 'com_sppagebuilder', 'sppagebuilder', '{}'),
(235, 18, 263, 264, 2, 'com_modules.module.125', 'SP Page Builder', ''),
(236, 18, 265, 266, 2, 'com_modules.module.126', 'SP Page Builder Admin Menu', ''),
(237, 1, 494, 495, 1, 'com_splms.coursescategory.2', 'com_splms.coursescategory.2', '{}'),
(238, 1, 502, 503, 1, 'com_splms.coursescategory.3', 'com_splms.coursescategory.3', '{}'),
(239, 1, 472, 473, 1, 'com_splms.coursescategory.4', 'com_splms.coursescategory.4', ''),
(240, 1, 474, 475, 1, 'com_splms.coursescategory.5', 'com_splms.coursescategory.5', ''),
(241, 1, 476, 477, 1, 'com_splms.coursescategory.6', 'com_splms.coursescategory.6', ''),
(242, 1, 478, 479, 1, 'com_splms.coursescategory.7', 'com_splms.coursescategory.7', ''),
(243, 1, 480, 481, 1, 'com_splms.coursescategory.8', 'com_splms.coursescategory.8', ''),
(244, 1, 482, 483, 1, 'com_splms.coursescategory.9', 'com_splms.coursescategory.9', ''),
(245, 1, 484, 485, 1, 'com_splms.coursescategory.10', 'com_splms.coursescategory.10', ''),
(246, 1, 486, 487, 1, 'com_splms.coursescategory.11', 'com_splms.coursescategory.11', ''),
(247, 1, 488, 489, 1, 'com_splms.coursescategory.12', 'com_splms.coursescategory.12', ''),
(248, 18, 267, 268, 2, 'com_modules.module.127', 'LMS Courses Category', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(251, 18, 269, 270, 2, 'com_modules.module.130', 'Course Category', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(253, 18, 271, 272, 2, 'com_modules.module.132', 'SP Quick Contact', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(254, 18, 273, 274, 2, 'com_modules.module.133', 'Category', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(255, 18, 275, 276, 2, 'com_modules.module.134', 'Tag Cloud', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(256, 1, 426, 427, 1, '#__ucm_content.1', '#__ucm_content.1', '[]'),
(257, 1, 428, 429, 1, '#__ucm_content.2', '#__ucm_content.2', '[]'),
(258, 1, 430, 431, 1, '#__ucm_content.3', '#__ucm_content.3', '[]'),
(259, 1, 432, 433, 1, '#__ucm_content.4', '#__ucm_content.4', '[]'),
(260, 1, 434, 435, 1, '#__ucm_content.5', '#__ucm_content.5', '[]'),
(261, 1, 436, 437, 1, '#__ucm_content.6', '#__ucm_content.6', '[]'),
(262, 18, 277, 278, 2, 'com_modules.module.135', 'Category', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(263, 18, 279, 280, 2, 'com_modules.module.136', 'Tag Cloud', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(266, 18, 281, 282, 2, 'com_modules.module.139', 'Event Categories', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(268, 18, 283, 284, 2, 'com_modules.module.141', 'Popular Course', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(269, 18, 285, 286, 2, 'com_modules.module.142', 'Upcoming Event', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(270, 18, 287, 288, 2, 'com_modules.module.143', 'Right-ad', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(274, 1, 456, 457, 1, 'com_splms.eventcategory.3', 'com_splms.eventcategory.3', ''),
(275, 1, 470, 471, 1, 'com_splms.eventcategory.4', 'com_splms.eventcategory.4', ''),
(276, 1, 466, 467, 1, 'com_splms.eventcategory.5', 'com_splms.eventcategory.5', ''),
(277, 1, 462, 463, 1, 'com_splms.eventcategory.6', 'com_splms.eventcategory.6', ''),
(278, 1, 454, 455, 1, 'com_splms.eventcategory.7', 'com_splms.eventcategory.7', ''),
(279, 1, 468, 469, 1, 'com_splms.eventcategory.8', 'com_splms.eventcategory.8', ''),
(280, 1, 452, 453, 1, 'com_splms.eventcategory.9', 'com_splms.eventcategory.9', ''),
(281, 1, 450, 451, 1, 'com_splms.eventcategory.10', 'com_splms.eventcategory.10', ''),
(282, 1, 448, 449, 1, 'com_splms.eventcategory.11', 'com_splms.eventcategory.11', ''),
(283, 1, 446, 447, 1, 'com_splms.eventcategory.12', 'com_splms.eventcategory.12', ''),
(284, 1, 444, 445, 1, 'com_splms.eventcategory.13', 'com_splms.eventcategory.13', ''),
(285, 1, 442, 443, 1, 'com_splms.eventcategory.14', 'com_splms.eventcategory.14', ''),
(286, 1, 440, 441, 1, 'com_splms.eventcategory.15', 'com_splms.eventcategory.15', ''),
(287, 1, 438, 439, 1, 'com_splms.eventcategory.16', 'com_splms.eventcategory.16', ''),
(288, 1, 458, 459, 1, 'com_kunena', 'com_kunena', '{}'),
(291, 1, 490, 491, 1, 'com_splms', 'SP LMS', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(292, 18, 289, 290, 2, 'com_modules.module.149', 'My Account', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(296, 18, 291, 292, 2, 'com_modules.module.152', 'JS Events', ''),
(297, 18, 293, 294, 2, 'com_modules.module.153', 'JS Groups', ''),
(298, 18, 295, 296, 2, 'com_modules.module.154', 'JS Members', ''),
(299, 18, 297, 298, 2, 'com_modules.module.155', 'JS Photos Module', ''),
(300, 18, 299, 300, 2, 'com_modules.module.156', 'JS Quick Search', ''),
(302, 18, 301, 302, 2, 'com_modules.module.158', 'JS Videos', ''),
(303, 18, 303, 304, 2, 'com_modules.module.159', 'JS Whos Online', ''),
(304, 1, 496, 497, 1, 'com_splms.coursescategory.13', 'com_splms.coursescategory.13', '{}'),
(305, 18, 305, 306, 2, 'com_modules.module.160', 'SP Page Builder', '{}'),
(306, 1, 498, 499, 1, 'com_fields', 'com_fields', '{}'),
(307, 1, 500, 501, 1, 'com_associations', 'com_associations', '{}'),
(308, 18, 307, 308, 2, 'com_modules.module.161', 'SP LMS Persons', '{}'),
(309, 11, 183, 184, 2, 'com_languages.language.2', 'Arabic Unitag (العربية الموحدة)', '{}'),
(310, 234, 413, 414, 2, 'com_sppagebuilder.page.10', 'Home - University', '{}'),
(311, 234, 415, 416, 2, 'com_sppagebuilder.page.13', 'Home-3', '{}'),
(312, 234, 417, 418, 2, 'com_sppagebuilder.page.1', 'Home', '{}'),
(313, 18, 309, 310, 2, 'com_modules.module.162', 'SP LMS Cart', '{}'),
(314, 234, 419, 420, 2, 'com_sppagebuilder.page.12', 'About Us-2', '{}'),
(315, 234, 421, 422, 2, 'com_sppagebuilder.page.8', 'Contact-2', '{}'),
(316, 234, 423, 424, 2, 'com_sppagebuilder.page.9', 'Contact-3', '{}'),
(317, 18, 311, 312, 2, 'com_modules.module.163', 'SP LMS Event Calendar', '{}');

-- --------------------------------------------------------

--
-- Table structure for table `#__associations`
--

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__associations`
--

INSERT INTO `#__associations` (`id`, `context`, `key`) VALUES
(590, 'com_menus.item', '4e9be211508ffb8589506b3e1bccf015');

-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__banners`
--

INSERT INTO `#__banners` (`id`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `clickurl`, `state`, `catid`, `description`, `custombannercode`, `sticky`, `ordering`, `metakey`, `params`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `reset`, `created`, `language`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `version`) VALUES
(2, 3, 0, 'Shop 1', 'shop-1', 0, 0, 0, 'http://shop.joomla.org/amazoncom-bookstores.html', 1, 15, 'Get books about Joomla! at the Joomla! Book Shop.', '', 0, 1, '', '{\"imageurl\":\"images\\/banners\\/white.png\",\"width\":\"\",\"height\":\"\",\"alt\":\"Joomla! Books\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-02-20 05:55:40', 'en-GB', 776, 'Joomla', '0000-00-00 00:00:00', 0, 1),
(3, 2, 0, 'Shop 2', 'shop-2', 0, 0, 0, 'http://shop.joomla.org', 1, 15, 'T Shirts, caps and more from the Joomla! Shop.', '', 0, 2, '', '{\"imageurl\":\"images\\/banners\\/white.png\",\"width\":\"\",\"height\":\"\",\"alt\":\"Joomla! Shop\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-02-20 05:55:40', 'en-GB', 776, 'Joomla', '0000-00-00 00:00:00', 0, 1),
(4, 1, 0, 'Support Joomla!', 'support-joomla', 0, 0, 0, 'http://contribute.joomla.org', 1, 15, 'Your contributions of time, talent and money make Joomla possible.', '', 0, 3, '', '{\"imageurl\":\"images\\/banners\\/white.png\",\"width\":\"\",\"height\":\"\",\"alt\":\"\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-02-20 05:55:40', 'en-GB', 776, 'Joomla', '0000-00-00 00:00:00', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__banner_clients`
--

INSERT INTO `#__banner_clients` (`id`, `name`, `contact`, `email`, `extrainfo`, `state`, `checked_out`, `checked_out_time`, `metakey`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`) VALUES
(1, 'Joomla!', 'Administrator', 'email@email.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, -1, -1),
(2, 'Shop', 'Example', 'example@example.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, 0, 0),
(3, 'Bookstore', 'Bookstore Example', 'example@example.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 101, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(9, 34, 1, 13, 14, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(10, 35, 1, 87, 88, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(11, 36, 1, 83, 84, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(12, 37, 1, 19, 20, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(15, 40, 1, 85, 86, 1, 'sample-data-banners', 'com_banners', 'Sample Data-Banners', 'sample-data-banners', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(16, 41, 1, 21, 82, 1, 'sample-data-contact', 'com_contact', 'Sample Data-Contact', 'sample-data-contact', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(17, 42, 1, 17, 18, 1, 'sample-data-newsfeeds', 'com_newsfeeds', 'Sample Data-Newsfeeds', 'sample-data-newsfeeds', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(19, 44, 1, 1, 4, 1, 'joomla', 'com_content', 'Joomla!', 'joomla', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', 0, '*', 1),
(21, 46, 19, 2, 3, 2, 'joomla/components', 'com_content', 'Components', 'components', '', '<p>Components are larger extensions that produce the major content for your site. Each component has one or more \"views\" that control how content is displayed. In the Joomla administrator there are additional extensions such as Menus, Redirection, and the extension managers.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', 0, '*', 1),
(34, 59, 16, 22, 23, 2, 'sample-data-contact/park-site', 'com_contact', 'Park Site', 'park-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, 'en-GB', 1),
(35, 60, 16, 24, 81, 2, 'sample-data-contact/shop-site', 'com_contact', 'Shop Site', 'shop-site', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(36, 61, 35, 25, 26, 3, 'sample-data-contact/shop-site/staff', 'com_contact', 'Staff', 'staff', '', '<p>Please feel free to contact our staff at any time should you need assistance.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(37, 62, 35, 27, 80, 3, 'sample-data-contact/shop-site/fruit-encyclopedia', 'com_contact', 'Fruit Encyclopedia', 'fruit-encyclopedia', '', '<p> </p><p>Our directory of information about different kinds of fruit.</p><p>We love fruit and want the world to know more about all of its many varieties.</p><p>Although it is small now, we work on it whenever we have a chance.</p><p>All of the images can be found in <a href=\"http://commons.wikimedia.org/wiki/Main_Page\">Wikimedia Commons</a>.</p><p><img src=\"images/sampledata/fruitshop/apple.jpg\" border=\"0\" alt=\"Apples\" title=\"Apples\" /></p><p><em>This encyclopedia is implemented using the contact component, each fruit a separate contact and a category for each letter. A CSS style is used to create the horizontal layout of the alphabet headings. </em></p><p><em>If you wanted to, you could allow some users (such as your growers) to have access to just this category in the contact component and let them help you to create new content for the encyclopedia.</em></p><p> </p>', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(38, 63, 37, 28, 29, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/a', 'com_contact', 'A', 'a', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(39, 64, 37, 30, 31, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/b', 'com_contact', 'B', 'b', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(40, 65, 37, 32, 33, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/c', 'com_contact', 'C', 'c', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(41, 66, 37, 34, 35, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/d', 'com_contact', 'D', 'd', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(42, 67, 37, 36, 37, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/e', 'com_contact', 'E', 'e', '', '', 0, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(43, 68, 37, 38, 39, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/f', 'com_contact', 'F', 'f', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(44, 69, 37, 40, 41, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/g', 'com_contact', 'G', 'g', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(45, 70, 37, 42, 43, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/h', 'com_contact', 'H', 'h', '', '', 0, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(46, 71, 37, 44, 45, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/i', 'com_contact', 'I', 'i', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(47, 72, 37, 46, 47, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/j', 'com_contact', 'J', 'j', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(48, 73, 37, 48, 49, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/k', 'com_contact', 'K', 'k', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(49, 74, 37, 50, 51, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/l', 'com_contact', 'L', 'l', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(50, 75, 37, 52, 53, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/m', 'com_contact', 'M', 'm', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(51, 76, 37, 54, 55, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/n', 'com_contact', 'N', 'n', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(52, 77, 37, 56, 57, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/o', 'com_contact', 'O', 'o', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(53, 78, 37, 58, 59, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/p', 'com_contact', 'P', 'p', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(54, 79, 37, 60, 61, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/q', 'com_contact', 'Q', 'q', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(55, 80, 37, 62, 63, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/r', 'com_contact', 'R', 'r', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(56, 81, 37, 64, 65, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/s', 'com_contact', 'S', 's', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(57, 82, 37, 66, 67, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/t', 'com_contact', 'T', 't', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(58, 83, 37, 68, 69, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/u', 'com_contact', 'U', 'u', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(59, 84, 37, 70, 71, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/v', 'com_contact', 'V', 'v', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(60, 85, 37, 72, 73, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/w', 'com_contact', 'W', 'w', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(61, 86, 37, 74, 75, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/x', 'com_contact', 'X', 'x', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(62, 87, 37, 76, 77, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/y', 'com_contact', 'Y', 'y', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(63, 88, 37, 78, 79, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/z', 'com_contact', 'Z', 'z', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(77, 169, 1, 89, 90, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(79, 179, 1, 91, 100, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(80, 191, 79, 92, 93, 2, 'blog/news', 'com_content', 'News', 'news', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', 0, '*', 1),
(81, 192, 79, 94, 95, 2, 'blog/tutorial', 'com_content', 'Tutorial', 'tutorial', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(82, 193, 79, 96, 97, 2, 'blog/review', 'com_content', 'Review', 'review', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(83, 194, 79, 98, 99, 2, 'blog/updates', 'com_content', 'Updates', 'updates', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', 0, '0000-00-00 00:00:00', 0, '*', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Contact Name Here', 'name', 'Position', 'Street Address', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', '<p>Information about or by the contact.</p>', 'images/powered_by.png', 'email@example.com', 1, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Twitter\",\"linka\":\"http:\\/\\/twitter.com\\/joomla\",\"linkb_name\":\"YouTube\",\"linkb\":\"http:\\/\\/www.youtube.com\\/user\\/joomla\",\"linkc_name\":\"Facebook\",\"linkc\":\"http:\\/\\/www.facebook.com\\/joomla\",\"linkd_name\":\"FriendFeed\",\"linkd\":\"http:\\/\\/friendfeed.com\\/joomla\",\"linke_name\":\"Scribed\",\"linke\":\"http:\\/\\/www.scribd.com\\/people\\/view\\/504592-joomla\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 16, 1, '', '', 'last', 'first', 'middle', 'en-GB', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 19),
(2, 'Webmaster', 'webmaster', '', '', '', '', '', '', '', '', '', '', 'webmaster@example.com', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 34, 1, '', '', '', '', '', 'en-GB', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 2),
(3, 'Owner', 'owner', '', '', '', '', '', '', '', '', '<p>I\'m the owner of this store.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 2, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 36, 1, '', '', '', '', '', '*', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(4, 'Buyer', 'buyer', '', '', '', '', '', '', '', '', '<p>I am in charge of buying fruit. If you sell good fruit, contact me.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"0\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 36, 1, '', '', '', '', '', '*', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 2),
(5, 'Bananas', 'bananas', 'Scientific Name: Musa', 'Image Credit: Enzik\r\nRights: Creative Commons Share Alike Unported 3.0\r\nSource: http://commons.wikimedia.org/wiki/File:Bananas_-_Morocco.jpg', '', 'Type: Herbaceous', 'Large Producers: India, China, Brasil', '', '', '', '<p>Bananas are a great source of potassium.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/bananas_2.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"show_with_link\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"1\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"1\",\"show_postcode\":\"\",\"show_country\":\"1\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Banana English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Banana\",\"linkb_name\":\"Wikipedia:  \\u0939\\u093f\\u0928\\u094d\\u0926\\u0940 \\u0915\\u0947\\u0932\\u093e\",\"linkb\":\"http:\\/\\/hi.wikipedia.org\\/wiki\\/%E0%A4%95%E0%A5%87%E0%A4%B2%E0%A4%BE\",\"linkc_name\":\"Wikipedia:Banana Portugu\\u00eas\",\"linkc\":\"http:\\/\\/pt.wikipedia.org\\/wiki\\/Banana\",\"linkd_name\":\"Wikipedia: \\u0411\\u0430\\u043d\\u0430\\u043d  \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439\",\"linkd\":\"http:\\/\\/ru.wikipedia.org\\/\\u0411\\u0430\\u043d\\u0430\\u043d\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"beez5:encyclopedia\"}', 0, 39, 1, '', '', '', '', '', '*', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(6, 'Apples', 'apples', 'Scientific Name: Malus domestica', 'Image Credit: Fievet\r\nRights: Public Domain\r\nSource: http://commons.wikimedia.org/wiki/File:Pommes_vertes.JPG', '', 'Family: Rosaceae', 'Large: Producers: China, United States', '', '', '', '<p>Apples are a versatile fruit, used for eating, cooking, and preserving.</p>\r\n<p>There are more that 7500 different kinds of apples grown around the world.</p>', 'images/sampledata/fruitshop/apple.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Apples English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Apple\",\"linkb_name\":\"Wikipedia: Manzana Espa\\u00f1ol \",\"linkb\":\"http:\\/\\/es.wikipedia.org\\/wiki\\/Manzana\",\"linkc_name\":\"Wikipedia: \\u82f9\\u679c \\u4e2d\\u6587\",\"linkc\":\"http:\\/\\/zh.wikipedia.org\\/zh\\/\\u82f9\\u679c\",\"linkd_name\":\"Wikipedia: Tofaa Kiswahili\",\"linkd\":\"http:\\/\\/sw.wikipedia.org\\/wiki\\/Tofaa\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"beez5:encyclopedia\"}', 0, 38, 1, '', '', '', '', '', '*', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 1),
(7, 'Tamarind', 'tamarind', 'Scientific Name: Tamarindus indica', 'Image Credit: Franz Eugen Köhler, Köhler\'s Medizinal-Pflanzen \r\nRights: Public Domain\r\nSource:http://commons.wikimedia.org/wiki/File:Koeh-134.jpg', '', 'Family: Fabaceae', 'Large Producers: India, United States', '', '', '', '<p>Tamarinds are a versatile fruit used around the world. In its young form it is used in hot sauces; ripened it is the basis for many refreshing drinks.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/tamarind.jpg', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"1\",\"linka_name\":\"Wikipedia: Tamarind English\",\"linka\":\"http:\\/\\/en.wikipedia.org\\/wiki\\/Tamarind\",\"linkb_name\":\"Wikipedia: \\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2  \\u09ac\\u09be\\u0982\\u09b2\\u09be  \",\"linkb\":\"http:\\/\\/bn.wikipedia.org\\/wiki\\/\\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2 \",\"linkc_name\":\"Wikipedia: Tamarinier Fran\\u00e7ais\",\"linkc\":\"http:\\/\\/fr.wikipedia.org\\/wiki\\/Tamarinier\",\"linkd_name\":\"Wikipedia:Tamaline lea faka-Tonga\",\"linkd\":\"http:\\/\\/to.wikipedia.org\\/wiki\\/Tamaline\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"beez5:encyclopedia\"}', 0, 57, 1, '', '', '', '', '', '*', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 0),
(8, 'Shop Address', 'shop-address', '', '', 'Our City', 'Our Province', 'Our Country', '', '555-555-5555', '', '<p>Here are directions for how to get to our shop.</p>', '', '', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 35, 1, '', '', '', '', '', '*', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 2);

-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(1, 89, 'Administrator Components', 'administrator-components', '<p>All components are also used in the administrator area of your website. In addition to the ones listed here, there are components in the administrator that do not have direct front end displays, but do help shape your site. The most important ones for most users are</p>\r\n<ul>\r\n<li>Media Manager</li>\r\n<li>Extensions Manager</li>\r\n<li>Menu Manager</li>\r\n<li>Global Configuration</li>\r\n<li>Banners</li>\r\n<li>Redirect</li>\r\n</ul>\r\n<hr title=\"Media Manager\" alt=\"Media Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<p> </p>\r\n<h3>Media Manager</h3>\r\n<p>The media manager component lets you upload and insert images into content throughout your site. Optionally, you can enable the flash uploader which will allow you to to upload multiple images. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Content_Media_Manager\">Help</a></p>\r\n<hr title=\"Extensions Manager\" alt=\"Extensions Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<h3>Extensions Manager</h3>\r\n<p>The extensions manager lets you install, update, uninstall and manage all of your extensions. The extensions manager has been extensively redesigned, although the core install and uninstall functionality remains the same as in Joomla! 1.5. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Extensions_Extension_Manager_Install\">Help</a></p>\r\n<hr title=\"Menu Manager\" alt=\"Menu Manager\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<h3>Menu Manager</h3>\r\n<p>The menu manager lets you create the menus you see displayed on your site. It also allows you to assign modules and template styles to specific menu links. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Menus_Menu_Manager\">Help</a></p>\r\n<hr title=\"Global Configuration\" alt=\"Global Configuration\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<h3>Global Configuration</h3>\r\n<p>The global configuration is where the site administrator configures things such as whether search engine friendly urls are enabled, the site meta data (descriptive text used by search engines and indexers) and other functions. For many beginning users simply leaving the settings on default is a good way to begin, although when your site is ready for the public you will want to change the meta data to match its content. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Site_Global_Configuration\">Help</a></p>\r\n<hr title=\"Banners\" alt=\"Banners\" class=\"system-pagebreak\" style=\"color: gray; border: 1px dashed gray;\" />\r\n<h3>Banners</h3>\r\n<p>The banners component provides a simple way to display a rotating image in a module and, if you wish to have advertising, a way to track the number of times an image is viewed and clicked. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Banners_Banners_Edit\">Help</a></p>\r\n<hr title=\"Redirect\" class=\"system-pagebreak\" />\r\n<h3><br />Redirect</h3>\r\n<p>The redirect component is used to manage broken links that produce Page Not Found (404) errors. If enabled it will allow you to redirect broken links to specific pages. It can also be used to manage migration related URL changes. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Redirect_Manager\">Help</a></p>', '', 1, 21, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 7, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(8, 104, 'Beginners', 'beginners', '<p>If this is your first Joomla! site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.</p>\r\n<p>Start off using your site by logging in using the administrator account you created when you installed Joomla.</p>\r\n', '\r\n<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works. (When you\'re done reading, you can delete or archive all of this.) You will also probably want to visit the Beginners\' Areas of the <a href=\"http://docs.joomla.org/Beginners\">Joomla documentation</a> and <a href=\"http://forum.joomla.org\">support forums</a>.</p>\r\n<p>You\'ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the <a href=\"http://community.joomla.org/showcase/\">Joomla! Site Showcase</a> to see an amazing array of ways people use Joomla to tell their stories on the web.</p>\r\n<p>The basic Joomla installation will let you get a great site up and running, but when you are ready for more features the power of Joomla is in the creative ways that developers have extended it to do all kinds of things. Visit the <a href=\"http://extensions.joomla.org/\">Joomla! Extensions Directory</a> to see thousands of extensions that can do almost anything you could want on a website. Can\'t find what you need? You may want to find a Joomla professional in the <a href=\"http://resources.joomla.org/\">Joomla! Resource Directory</a>.</p>\r\n<p>Want to learn more? Consider attending a <a href=\"http://community.joomla.org/events.html\">Joomla! Day</a> or other event or joining a local <a href=\"http://community.joomla.org/user-groups.html\">Joomla! Users Group</a>. Can\'t find one near you? Start one yourself.</p>', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 4, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', ''),
(9, 105, 'Contacts', 'contact', '<p>The contact component provides a way to provide contact forms and information for your site or to create a complex directory that can be used for many different purposes. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Contacts_Contacts\">Help</a></p>', '', 1, 21, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', 1, 2, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(10, 106, 'Content', 'content', '<p>The content component (com_content) is what you use to write articles. It is extremely flexible and has the largest number of built in views. Articles can be created and edited from the front end, making content the easiest component to use to create your site content. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Content_Article_Manager\">Help</a></p>', '', 1, 21, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', 1, 1, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(21, 119, 'Getting Help', 'getting-help', '<p> There are lots of places you can get help with Joomla!. In many places in your site administrator you will see the help icon. Click on this for more information about the options and functions of items on your screen. Other places to get help are:</p>\r\n<ul>\r\n<li><a href=\"http://forum.joomla.org\">Support Forums</a></li>\r\n<li><a href=\"http://docs.joomla.org\">Documentation</a></li>\r\n<li><a href=\"http://resources.joomla.org\">Professionals</a></li>\r\n<li><a href=\"http://shop.joomla.org/amazoncom-bookstores.html\">Books</a></li>\r\n</ul>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 8, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(22, 120, 'Getting Started', 'getting-started', '<p>It\'s easy to get started creating your website. Knowing some of the basics will help.</p>\r\n<h3>What is a Content Management System?</h3>\r\n<p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.</p>\r\n<p>In this site, the content is stored in a <em>database</em>. The look and feel are created by a <em>template</em>. The Joomla! software brings together the template and the content to create web pages.</p>\r\n<h3>Site and Administrator</h3>\r\n<p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see. The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the \"Site Administrator\" link on the \"This Site\" menu or by adding /administrator to the end of you domain name.</p>\r\n<p>Log in to the administrator using the username and password created during the installation of Joomla.</p>\r\n<h3>Logging in</h3>\r\n<p>To login to the front end of your site use the login form or the login menu link on the \"This Site\" menu. Use the user name and password that were created as part of the installation process. Once logged-in you will be able to create and edit articles.</p>\r\n<p>In managing your site, you will be able to create content that only logged-in users are able to see.</p>\r\n<h3>Creating an article</h3>\r\n<p>Once you are logged-in, a new menu will be visible. To create a new article, click on the \"submit article\" link on that menu.</p>\r\n<p>The new article interface gives you a lot of options, but all you need to do is add a title and put something in the content area. To make it easy to find, set the state to published and put it in the Joomla category.</p>\r\n<div>You can edit an existing article by clicking on the edit icon (this only displays to users who have the right to edit).</div>\r\n<h3>Learn more</h3>\r\n<p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href=\"http://docs.joomla.org\">Joomla! documentation site</a> and on the<a href=\"http://forum.joomla.org\"> Joomla! forums</a>.</p>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 9, '', '', 1, 68, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(24, 122, 'Joomla!', 'joomla', '<p>Congratulations! You have a Joomla site! Joomla makes it easy to build a website just the way you want it and keep it simple to update and maintain.</p>\r\n<p>Joomla is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.</p>\r\n<p>The content in this installation of Joomla has been designed to give you an in depth tour of Joomla\'s features.</p>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 3, 2, '', '', 1, 10, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', ''),
(32, 130, 'Options', 'options', '<p>As you make your Joomla! site you will control the details of the display using <em>options</em> also referred to as <em>parameter</em><strong>s</strong>. Options control everything from whether the author\'s name is displayed to who can view what to the number of items shown on a list.</p>\r\n<p>Default options for each component are changed using the Options button on the component toolbar.</p>\r\n<p>Options can also be set on an individual item, such as an article or contact and in menu links.</p>\r\n<p>If you are happy with how your site looks, it is fine to leave all of the options set to the defaults that were created when your site was installed. As you become more experienced with Joomla you will use options more.</p>\r\n<p> </p>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 10, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(35, 133, 'Professionals', 'professionals', '<p>Joomla! 3 continues development of the Joomla Platform and CMS as a powerful and flexible way to bring your vision of the web to reality. With the new administrator interface and adoption of Twitter Bootstrap, the ability to control its look and the management of extensions is now complete.</p>\r\n', '\r\n<p>Working with multiple template styles and overrides for the same views, creating the design you want is easier than it has ever been. Limiting support to PHP 5.3.10 and above makes Joomla lighter and faster than ever. </p>\r\n<p>The separation of the Joomla! Platform project from the Joomla! CMS project makes continuous development of new, powerful APIs and continuous improvement of existing APIs possible while maintaining the stability of the CMS that millions of webmasters and professionals rely upon.</p>', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 2, 5, '', '', 1, 43, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', ''),
(38, 136, 'Sample Sites', 'sample-sites', '<p>Your installation includes sample data, designed to show you some of the options you have for building your website. In addition to information about Joomla! there are two sample \"sites within a site\" designed to help you get started with building your own site.</p>\r\n<p>The first site is a simple site about <a href=\"index.php?Itemid=243\">Australian Parks</a>. It shows how you can quickly and easily build a personal site with just the building blocks that are part of Joomla. It includes a personal blog, weblinks, and a very simple image gallery.</p>\r\n<p>The second site is slightly more complex and represents what you might do if you are building a site for a small business, in this case a <a href=\"index.php/welcome.html\"></a><a href=\"index.php?Itemid=429\">Fruit Shop</a>.</p>\r\n<p>In building either style site, or something completely different, you will probably want to add <a href=\"http://extensions.joomla.org\">extensions</a> and either create or purchase your own template. Many Joomla users start by modifying the <a href=\"http://docs.joomla.org/How_do_you_modify_a_template%3F\">templates</a> that come with the core distribution so that they include special images and other design elements that relate to their site\'s focus.</p>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 11, '', '', 1, 15, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(39, 137, 'Search', 'search-component', '<p>Joomla! 2.5 offers two search options.</p>\r\n<p>The Basic Search component provides basic search functionality for the information contained in your core components. Many extensions can also be searched by the search component. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Search\">Help</a></p>\r\n<p>The Smart Search component offers searching similar to that found in major search engines. Smart Search is disabled by default. If you choose to enable it you will need to take several steps. First, enable the Smart Search Plugin in the plugin manager. Then, if you are using the Basic Search Module replace it with the Smart Search Module. Finally, if you have already created content, go to the Smart Search component in your site administrator and click the Index icon. Once indexing of your content is complete, Smart Search will be ready to use. Help.</p>', '', 1, 21, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 3, '', '', 1, 17, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(47, 145, 'The Joomla! Community', 'the-joomla-community', '<p>Joomla means All Together, and it is a community of people all working and having fun together that makes Joomla possible. Thousands of people each year participate in the Joomla community, and we hope you will be one of them.</p>\r\n<p>People with all kinds of skills, of all skill levels and from around the world are welcome to join in. Participate in the <a href=\"http://joomla.org\">Joomla.org</a> family of websites (the<a href=\"http://forum.joomla.org\"> forum </a>is a great place to start). Come to a <a href=\"http://community.joomla.org/events.html\">Joomla! event</a>. Join or start a <a href=\"http://community.joomla.org/user-groups.html\">Joomla! Users Group</a>. Whether you are a developer, site administrator, designer, end user or fan, there are ways for you to participate and contribute.</p>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 3, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(48, 146, 'The Joomla! Project', 'the-joomla-project', '<p>The Joomla Project consists of all of the people who make and support the Joomla Web Platform and Content Management System.</p>\r\n<p>Our mission is to provide a flexible platform for digital publishing and collaboration.</p>\r\n<p>The core values are:</p>\r\n<ul>\r\n<li>Freedom</li>\r\n<li>Equality</li>\r\n<li>Trust</li>\r\n<li>Community</li>\r\n<li>Collaboration</li>\r\n<li>Usability</li>\r\n</ul>\r\n<p>In our vision, we see:</p>\r\n<ul>\r\n<li>People publishing and collaborating in their communities and around the world</li>\r\n<li>Software that is free, secure, and high-quality</li>\r\n<li>A community that is enjoyable and rewarding to participate in</li>\r\n<li>People around the world using their preferred languages</li>\r\n<li>A project that acts autonomously</li>\r\n<li>A project that is socially responsible</li>\r\n<li>A project dedicated to maintaining the trust of its users</li>\r\n</ul>\r\n<p>There are millions of users around the world and thousands of people who contribute to the Joomla Project. They work in three main groups: the Production Working Group, responsible for everything that goes into software and documentation; the Community Working Group, responsible for creating a nurturing the community; and Open Source Matters, the non profit organization responsible for managing legal, financial and organizational issues.</p>\r\n<p>Joomla is a free and open source project, which uses the GNU General Public License version 2 or later.</p>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 1, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(50, 148, 'Upgraders', 'upgraders', '<p>If you are an experienced Joomla! user, this Joomla site will seem very familiar but also very different. The biggest change is the new administrator interface and the adoption of responsive design. Hundreds of other improvements have been made.</p>\r\n<p> </p>\r\n<p> </p>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":null,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":null,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":null,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"0\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 3, 6, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 1, '*', ''),
(52, 150, 'Users', 'users-component', '<p>The users extension lets your site visitors register, login and logout, change their passwords and other information, and recover lost passwords. In the administrator it allows you to create, block and manage users and create user groups and access levels. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Users_User_Manager\">Help</a></p>\r\n<p>Please note that some of the user views will not display if you are not logged-in to the site.</p>', '', 1, 21, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', 1, 5, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(53, 151, 'Using Joomla!', 'using-joomla', '<p>With Joomla you can create anything from a simple personal website to a complex ecommerce or social site with millions of visitors.</p>\r\n<p>This section of the sample data provides you with a brief introduction to Joomla concepts and reference material to help you understand how Joomla works.</p>\r\n<p><em>When you no longer need the sample data, you can can simply unpublish the sample data category found within each extension in the site administrator or you may completely delete each item and all of the categories. </em></p>', '', 1, 19, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 7, '', '', 1, 9, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(60, 158, 'News Feeds', 'news-feeds', '<p>News Feeds (com_newsfeeds) provides a way to organize and present news feeds. News feeds are a way that you present information from another site on your site. For example, the joomla.org website has numerous feeds that you can incorporate on your site. You an use menus to present a single feed, a list of feeds in a category, or a list of all feed categories. <a href=\"http://help.joomla.org/proxy/index.php?option=com_help&amp;keyref=Help31:Components_Newsfeeds_Feeds\">Help</a></p>', '', 1, 21, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', 1, 4, '', '', 1, 8, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(67, 168, 'What\'s New in 1.5?', 'whats-new-in-15', '<p>This article deliberately archived as an example.</p><p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>\r\n<p style=\"margin-bottom: 0in;\">In Joomla! 1.5, you\'\'ll notice:</p>\r\n<ul>\r\n<li>Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</li>\r\n<li>Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</li>\r\n<li>Extended integration of external applications through Web services</li>\r\n<li>Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</li>\r\n<li>A more sustainable and flexible framework for Component and Extension developers</li>\r\n<li>Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</li>\r\n</ul>', '', 2, 9, '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_readmore\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"page_title\":\"\",\"alternative_readmore\":\"\",\"layout\":\"\"}', 1, 0, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(71, 195, 'Online Learning Initiatives', 'online-learning-initiatives', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros. Mauris ligula massa, dictum eget lorem in, condimentum facilisis magna. Joomla potenti.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-20 05:55:40', 776, '', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"status\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"<blockquote class=\\\"twitter-tweet\\\" lang=\\\"en\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\"http:\\/\\/t.co\\/2pQYdykKy8\\\">http:\\/\\/t.co\\/2pQYdykKy8<\\/a><\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\"https:\\/\\/twitter.com\\/joomshaper\\/status\\/562210375480139777\\\">February 2, 2015<\\/a><\\/blockquote>\\r\\n<script async src=\\\"\\/\\/platform.twitter.com\\/widgets.js\\\" charset=\\\"utf-8\\\"><\\/script>\"}', 6, 6, '', '', 1, 25, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(72, 196, 'Top innovation means promising future', 'top-innovation-means-promising-future', '<p>LMS Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n', '\r\n<p>We continually experiment to improve what we do through creative use of technology, and we share what we learn with the rest of the world. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-20 05:55:40', 776, '', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"video\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"http:\\/\\/vimeo.com\\/43426940\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 7, 5, '', '', 1, 74, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(73, 197, 'Oxford University Libraries', 'oxford-university-libraries', '<p><span class=\"field-item-single\">Varsita meets the needs of its students, academics and the international learing community. </span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-20 05:55:40', 776, '', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"images\\/blog\\/blog01.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog01.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 6, 4, '', '', 1, 118, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(74, 198, 'CMS have new LMS technology', 'cms-have-new-lms-technology', '<p>Joomla ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros.s. Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consectetur adipiscing elit. </p>\r\n', '\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros. Mauris ligula massa, dictum eget lorem in, condimentum facilisis magna. Suspendisse potenti. Maecenas aliquam justo eget erat convallis, vitae gravida ligula imperdiet. Donec tempor tortor elit, nec convallis nibh condimentum non. Pellentesque vel nulla feugiat, suscipit lorem ac, rhoncus ex. Duis ullamcorper odio quis massa sodales tristique. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros. Mauris ligula massa, dictum eget lorem in, condimentum facilisis magna. Suspendisse potenti. Maecenas aliquam justo eget erat convallis, vitae gravida ligula imperdiet. Donec tempor tortor elit, nec convallis nibh condimentum non. Pellentesque vel nulla feugiat, suscipit lorem ac, rhoncus ex. Duis ullamcorper odio quis massa sodales tristique.</p>', 1, 79, '2018-02-20 05:55:40', 776, '', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"gallery\",\"gallery\":\"{\\\"gallery_images\\\":[\\\"images\\/blog\\/blog06.jpg\\\",\\\"images\\/blog\\/blog05.jpg\\\",\\\"images\\/blog\\/blog04.jpg\\\"]}\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 8, 3, '', '', 1, 30, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(75, 199, 'Radical Ideas for Reinventing Education', 'radical-ideas-for-reinventing-education', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum consequat massa in mauris ornare congue. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est.  </p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-20 05:55:40', 776, '', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"audio\",\"gallery\":\"\",\"audio\":\"<iframe width=\\\"100%\\\" height=\\\"450\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\"><\\/iframe>\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 7, 2, '', '', 1, 27, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(76, 200, 'Courses Website Redesign', 'courses-website-redesign', '<p>Following are some updates of note from March. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-20 05:55:40', 776, '', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"link\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"Responive Joomla Templates\",\"link_url\":\"http:\\/\\/www.joomshaper.com\\/joomla-templates\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 8, 1, '', '', 1, 42, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(77, 201, 'J! Geek - an online course about Joomla', 'j-geek-an-online-course-about-joomla', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 79, '2018-02-20 05:55:40', 776, '', '2018-02-20 05:55:40', 776, 0, '0000-00-00 00:00:00', '2018-02-20 05:55:40', '0000-00-00 00:00:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"quote\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball. Tail salami pork loin ham. Drumstick flank porchetta, hamburger ham swine biltong chicken pancetta. Spare ribs prosciutto t-bone.\",\"quote_author\":\"- John Doe\",\"post_status\":\"\"}', 10, 0, '', '', 1, 30, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__contentitem_tag_map`
--

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

--
-- Dumping data for table `#__contentitem_tag_map`
--

INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES
('com_content.article', 6, 72, 12, '2018-02-19 23:55:40', 1),
('com_content.article', 5, 73, 10, '2018-02-19 23:55:40', 1),
('com_content.article', 5, 73, 11, '2018-02-19 23:55:40', 1),
('com_content.article', 4, 74, 8, '2018-02-19 23:55:40', 1),
('com_content.article', 4, 74, 9, '2018-02-19 23:55:40', 1),
('com_content.article', 3, 75, 6, '2018-02-19 23:55:40', 1),
('com_content.article', 3, 75, 7, '2018-02-19 23:55:40', 1),
('com_content.article', 2, 76, 4, '2018-02-19 23:55:40', 1),
('com_content.article', 2, 76, 5, '2018-02-19 23:55:40', 1),
('com_content.article', 1, 77, 2, '2018-02-19 23:55:40', 1),
('com_content.article', 1, 77, 4, '2018-02-19 23:55:40', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_frontpage`
--

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(8, 2),
(24, 1),
(35, 4),
(50, 3);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_rating`
--

INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES
(71, 5, 1, '::1'),
(72, 10, 2, '::1'),
(73, 10, 2, '10.0.1.2');

-- --------------------------------------------------------

--
-- Table structure for table `#__content_types`
--

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_types`
--

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{\"special\":{\"dbtable\":\"#__weblinks\",\"key\":\"id\",\"type\":\"Weblink\",\"prefix\":\"WeblinksTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{}}', 'WeblinksHelperRoute::getWeblinkRoute', '{\"formFile\":\"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"featured\",\"images\"], \"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(3, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(5, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'WeblinksHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(10, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(11, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(12, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(13, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(14, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(15, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

-- --------------------------------------------------------

--
-- Table structure for table `#__core_log_searches`
--

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"allow_vcard_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_category_crumb\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png,pdf\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip,application\\/pdf\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"1\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"1\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"0\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"0\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"0\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"5\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"0\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"13\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"0\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"show_tag_num_items\":\"0\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"Januar 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"64cbdfb08ea73fdb94845b9482db7593\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"Feb 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 0, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', '', 0, '2011-09-18 15:22:50', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.34.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2017\",\"author\":\"Ephox Corporation\",\"copyright\":\"Ephox Corporation\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"http:\\/\\/www.tinymce.com\",\"version\":\"4.5.8\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"mobile\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"1\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"hr\":\"1\",\"link\":\"1\",\"media\":\"1\",\"print\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"alignment\":\"1\",\"visualchars\":\"1\",\"visualblocks\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '{\"detect_browser\":\"0\",\"automatic_change\":\"1\",\"item_associations\":\"1\",\"remove_default_prefix\":\"1\",\"lang_cookie\":\"1\",\"alternate_meta\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"strong_passwords\":\"1\",\"autoregister\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1523527184}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"mode\":1,\"lastrun\":1523527200,\"unique_id\":\"5d7ee8aa0ce5b9e955839acf83008937e02f958f\",\"interval\":12}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(456, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(457, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 0, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', 'system', 0, 1, 1, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(506, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(507, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"March 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"March 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"March 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2018 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"March 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10001, 0, 'Helix3 - Ajax', 'plugin', 'helix3', 'ajax', 0, 1, 1, 0, '{\"name\":\"Helix3 - Ajax\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.5.2\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10002, 0, 'System - Helix3 Framework', 'plugin', 'helix3', 'system', 0, 1, 1, 0, '{\"name\":\"System - Helix3 Framework\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.5.2\",\"description\":\"Helix3 Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helix3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10007, 0, 'SP Simple Portfolio', 'component', 'com_spsimpleportfolio', '', 1, 1, 0, 0, '{\"name\":\"SP Simple Portfolio\",\"type\":\"component\",\"creationDate\":\"December 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010- 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"Simple Portfolio Component for Joomla 3.3+\",\"group\":\"\",\"filename\":\"spsimpleportfolio\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10008, 0, 'SP Simple Portfolio Module', 'module', 'mod_spsimpleportfolio', '', 0, 1, 0, 0, '{\"name\":\"SP Simple Portfolio Module\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"Module to display latest item from SP Simple Portfolio\",\"group\":\"\",\"filename\":\"mod_spsimpleportfolio\"}', '{\"show_filter\":\"1\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"limit\":\"12\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10011, 0, 'shaper_varsita', 'template', 'shaper_varsita', '', 0, 1, 1, 0, '{\"name\":\"shaper_varsita\",\"type\":\"template\",\"creationDate\":\"Mar 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.0\",\"description\":\"Shaper Varsita - Joomla Learning Management System Template\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"sticky_header\":\"1\",\"boxed_layout\":\"0\",\"logo_type\":\"image\",\"logo_position\":\"logo\",\"body_bg_repeat\":\"inherit\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"body_bg_position\":\"0 0\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright\":\"\\u00a9 2015 Your Company. All Rights Reserved. Designed By JoomShaper\",\"show_social_icons\":\"1\",\"social_position\":\"top1\",\"enable_contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_phone\":\"+228 872 4444\",\"contact_email\":\"contact@email.com\",\"comingsoon_mode\":\"0\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_date\":\"5-10-2018\",\"comingsoon_content\":\"Coming soon content\",\"preset\":\"preset1\",\"preset1_bg\":\"#ffffff\",\"preset1_text\":\"#000000\",\"preset1_major\":\"#26aae1\",\"preset2_bg\":\"#ffffff\",\"preset2_text\":\"#000000\",\"preset2_major\":\"#3d449a\",\"preset3_bg\":\"#ffffff\",\"preset3_text\":\"#000000\",\"preset3_major\":\"#2bb673\",\"preset4_bg\":\"#ffffff\",\"preset4_text\":\"#000000\",\"preset4_major\":\"#eb4947\",\"menu\":\"mainmenu\",\"menu_type\":\"mega_offcanvas\",\"menu_animation\":\"menu-fade\",\"enable_body_font\":\"1\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_h5_font\":\"1\",\"enable_h6_font\":\"1\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_navigation_font\":\"0\",\"enable_custom_font\":\"0\",\"compress_css\":\"0\",\"compress_js\":\"0\",\"lessoption\":\"0\",\"show_post_format\":\"1\",\"commenting_engine\":\"disabled\",\"disqus_devmode\":\"0\",\"intensedebate_acc\":\"\",\"fb_width\":\"500\",\"fb_cpp\":\"10\",\"comments_count\":\"0\",\"social_share\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10013, 0, 'AcyMailing', 'component', 'com_acymailing', '', 1, 1, 0, 0, '{\"name\":\"AcyMailing\",\"type\":\"component\",\"creationDate\":\"March 2018\",\"author\":\"Acyba\",\"copyright\":\"Copyright (C) 2009-2018 ACYBA SAS - All rights reserved.\",\"authorEmail\":\"dev@acyba.com\",\"authorUrl\":\"http:\\/\\/www.acyba.com\",\"version\":\"5.9.6\",\"description\":\"Manage your Mailing lists, Newsletters, e-mail marketing campaigns\",\"group\":\"\",\"filename\":\"acymailing_j3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10014, 0, 'AcyMailing : trigger Joomla Content plugins', 'plugin', 'contentplugin', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"November 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(10015, 0, 'AcyMailing Manage text', 'plugin', 'managetext', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"October 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10016, 0, 'AcyMailing Tag : Website links', 'plugin', 'online', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10017, 0, 'AcyMailing : share on social networks', 'plugin', 'share', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"August 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10018, 0, 'AcyMailing : Statistics Plugin', 'plugin', 'stats', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10019, 0, 'AcyMailing table of contents generator', 'plugin', 'tablecontents', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"January 2011\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10020, 0, 'AcyMailing Tag : CB User information', 'plugin', 'tagcbuser', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10021, 0, 'AcyMailing Tag : content insertion', 'plugin', 'tagcontent', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10022, 0, 'AcyMailing Tag : Subscriber information', 'plugin', 'tagsubscriber', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.9.6\",\"author\":\"Acyba\",\"creationDate\":\"March 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10023, 0, 'AcyMailing Tag : Manage the Subscription', 'plugin', 'tagsubscription', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.9.6\",\"author\":\"Acyba\",\"creationDate\":\"March 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10024, 0, 'AcyMailing Tag : Date / Time', 'plugin', 'tagtime', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.9.6\",\"author\":\"Acyba\",\"creationDate\":\"March 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10025, 0, 'AcyMailing Tag : Joomla User Information', 'plugin', 'taguser', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.9.6\",\"author\":\"Acyba\",\"creationDate\":\"March 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10026, 0, 'AcyMailing Template Class Replacer', 'plugin', 'template', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.9.6\",\"author\":\"Acyba\",\"creationDate\":\"March 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 52, 0),
(10027, 0, 'AcyMailing Editor', 'plugin', 'acyeditor', 'editors', 0, 1, 1, 0, '{\"version\":\"5.9.6\",\"author\":\"Acyba\",\"creationDate\":\"March 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10028, 0, 'AcyMailing : (auto)Subscribe during Joomla registration', 'plugin', 'regacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.9.6\",\"author\":\"Acyba\",\"creationDate\":\"March 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10029, 0, 'AcyMailing Module', 'module', 'mod_acymailing', '', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10036, 0, 'SP LMS Course Search', 'module', 'mod_splmscoursesearch', '', 0, 1, 1, 0, '{\"name\":\"SP LMS Course Search\",\"type\":\"module\",\"creationDate\":\"Mar 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"Module to search courses from SP LMS\",\"group\":\"\",\"filename\":\"mod_splmscoursesearch\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10040, 0, 'SP Flickr Gallery', 'module', 'mod_sp_flickrgallery', '', 0, 1, 1, 0, '{\"name\":\"SP Flickr Gallery\",\"type\":\"module\",\"creationDate\":\"Mar 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"This Module will take photos from flickr by your flickr ID\",\"group\":\"\",\"filename\":\"mod_sp_flickrgallery\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10042, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.1.3\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10043, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10044, 0, 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_admin_menu\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_admin_menu\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10058, 0, 'SP LMS Cources', 'module', 'mod_splmscourses', '', 0, 1, 0, 0, '{\"name\":\"SP LMS Cources\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.2\",\"description\":\"Module to display latest item from SP LMS\",\"group\":\"\",\"filename\":\"mod_splmscourses\"}', '{\"course_type\":\"default\",\"columns\":\"4\",\"limit\":\"12\",\"show_browse_all\":\"1\",\"layout\":\"default\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10066, 0, 'SP LMS Course Categories', 'module', 'mod_splmscoursescategegory', '', 0, 1, 1, 0, '{\"name\":\"SP LMS Course Categories\",\"type\":\"module\",\"creationDate\":\"Mar 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"Module to display courses categories from SP LMS\",\"group\":\"\",\"filename\":\"mod_splmscoursescategegory\"}', '{\"course_type\":\"default\",\"columns\":\"4\",\"limit\":\"12\",\"show_browse_all\":\"1\",\"layout\":\"default\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10068, 0, 'SP LMS Upcoming Events', 'module', 'mod_splmsupcomingevents', '', 0, 1, 1, 0, '{\"name\":\"SP LMS Upcoming Events\",\"type\":\"module\",\"creationDate\":\"Mar 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"Module to display upcoming events from SP LMS\",\"group\":\"\",\"filename\":\"mod_splmsupcomingevents\"}', '{\"category_type\":\"default\",\"columns\":\"4\",\"limit\":\"12\",\"show\":\"1\",\"show_browse_all\":\"1\",\"layout\":\"default\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10069, 0, 'SP LMS Event Categories', 'module', 'mod_splmseventcategories', '', 0, 1, 1, 0, '{\"name\":\"SP LMS Event Categories\",\"type\":\"module\",\"creationDate\":\"Mar 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"Module to display event categories from SP LMS\",\"group\":\"\",\"filename\":\"mod_splmseventcategories\"}', '{\"category_type\":\"default\",\"columns\":\"4\",\"limit\":\"12\",\"show\":\"1\",\"show_browse_all\":\"1\",\"layout\":\"default\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10070, 10146, 'plg_system_kunena', 'plugin', 'kunena', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_kunena\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_SYSTEM_KUNENA_DESC\",\"group\":\"\",\"filename\":\"kunena\"}', '{\"jcontentevents\":\"0\",\"jcontentevent_target\":\"body\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10071, 10146, 'plg_quickicon_kunena', 'plugin', 'kunena', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_kunena\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_QUICKICON_KUNENA_DESC\",\"group\":\"\",\"filename\":\"kunena\"}', '{\"context\":\"mod_quickicon\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10073, 0, 'Kunena Media Files', 'file', 'KunenaMediaFiles', '', 0, 1, 0, 0, '{\"name\":\"Kunena Media Files\",\"type\":\"file\",\"creationDate\":\"2015-06-29\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2015 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"http:\\/\\/www.kunena.org\",\"version\":\"4.0.3\",\"description\":\"Kunena media files.\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10074, 10146, 'com_kunena', 'component', 'com_kunena', '', 1, 1, 0, 0, '{\"name\":\"com_kunena\",\"type\":\"component\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"COM_KUNENA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"kunena\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10076, 0, 'plg_kunena_alphauserpoints', 'plugin', 'alphauserpoints', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_alphauserpoints\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_ALPHAUSERPOINTS_DESCRIPTION\",\"group\":\"\",\"filename\":\"alphauserpoints\"}', '{\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"activity_points_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10077, 0, 'plg_kunena_community', 'plugin', 'community', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_community\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_COMMUNITY_DESCRIPTION\",\"group\":\"\",\"filename\":\"community\"}', '{\"access\":\"1\",\"login\":\"1\",\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"private\":\"1\",\"activity_points_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10078, 0, 'plg_kunena_comprofiler', 'plugin', 'comprofiler', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_comprofiler\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_COMPROFILER_DESCRIPTION\",\"group\":\"\",\"filename\":\"comprofiler\"}', '{\"access\":\"1\",\"login\":\"1\",\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"private\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10079, 0, 'plg_kunena_gravatar', 'plugin', 'gravatar', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_gravatar\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_GRAVATAR_DESCRIPTION\",\"group\":\"\",\"filename\":\"gravatar\"}', '{\"avatar\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10080, 0, 'plg_kunena_uddeim', 'plugin', 'uddeim', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_uddeim\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_UDDEIM_DESCRIPTION\",\"group\":\"\",\"filename\":\"uddeim\"}', '{\"private\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10081, 0, 'plg_kunena_kunena', 'plugin', 'kunena', 'kunena', 0, 1, 1, 0, '{\"name\":\"plg_kunena_kunena\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_KUNENA_DESCRIPTION\",\"group\":\"\",\"filename\":\"kunena\"}', '{\"avatar\":\"1\",\"profile\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10082, 0, 'plg_kunena_joomla', 'plugin', 'joomla', 'kunena', 0, 1, 1, 0, '{\"name\":\"plg_kunena_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_JOOMLA_25_30_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"access\":\"1\",\"login\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10086, 0, 'SP LMS', 'component', 'com_splms', '', 1, 1, 0, 0, '{\"name\":\"SP LMS\",\"type\":\"component\",\"creationDate\":\"Mar 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010- 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.0\",\"description\":\"SP Learning Management System Component for Joomla 3.4+\",\"group\":\"\",\"filename\":\"splms\"}', '{\"gmap_api\":\"\",\"course_thumbnail\":\"480X300\",\"course_thumbnail_small\":\"100X60\",\"event_thumbnail\":\"480X300\",\"event_thumbnail_small\":\"100X60\",\"payment_method\":\"all\",\"shop_environment\":\"sandbox\",\"currency\":\"USD:$\",\"paypal_id\":\"example@example.com\",\"videologo\":\"\",\"video_logo_x_offset\":\"5\",\"video_logo_y_offset\":\"5\",\"video_logo_tooltip_text\":\"\",\"video_logo_url\":\"\",\"certificate_logo\":\"images\\/demo\\/certificate-logo.png\",\"certificate_prefix\":\"varsita\",\"organization\":\"JoomShaper\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10089, 0, 'PLG_EVENTS_TITLE', 'plugin', 'events', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_EVENTS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_EVENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"events\"}', '{\"coreapp\":\"0\",\"cache\":\"1\",\"sorting\":\"1\",\"position\":\"content|sidebar-top|sidebar-bottom\",\"hide_empty\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10090, 0, 'PLG_FEEDS_TITLE', 'plugin', 'feeds', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_FEEDS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_FEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"feeds\"}', '{\"cache\":\"0\",\"coreapp\":\"0\",\"position\":\"content\",\"defaultprivacy\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10091, 0, 'PLG_FRIENDSLOCATION_TITLE', 'plugin', 'friendslocation', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_FRIENDSLOCATION_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_FRIENDSLOCATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"friendslocation\"}', '{\"coreapp\":\"0\",\"cache\":\"1\",\"position\":\"content\",\"town_field_code\":\"FIELD_CITY\",\"state_field_code\":\"FIELD_STATE\",\"country_field_code\":\"FIELD_COUNTRY\",\"count\":\"0\",\"show_karma\":\"1\",\"width\":\"480\",\"height\":\"340\",\"hide_empty\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10092, 0, 'PLG_INPUT_TITLE', 'plugin', 'input', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_INPUT_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_INPUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"input\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10093, 0, 'PLG_INVITE_TITLE', 'plugin', 'invite', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_INVITE_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_INVITE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"invite\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10098, 0, 'PLG_KUNENA_TITLE', 'plugin', 'kunena', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_KUNENA_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_KUNENA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"kunena\"}', '{\"count\":\"5\",\"coreapp\":\"0\",\"position\":\"content\",\"cache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10099, 0, 'PLG_LATESTPHOTO_TITLE', 'plugin', 'latestphoto', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_LATESTPHOTO_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_LATESTPHOTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"latestphoto\"}', '{\"coreapp\":\"0\",\"position\":\"content\",\"cache\":\"1\",\"hide_empty\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10100, 0, 'PLG_MUTUALFRIENDS_TITLE', 'plugin', 'mutualfriends', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_MUTUALFRIENDS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"September 2014\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2014 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_MUTUALFRIENDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mutualfriends\"}', '{\"cache\":\"0\",\"coreapp\":\"0\",\"position\":\"content\",\"hide_empty\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10101, 0, 'PLG_MYARTICLES_TITLE', 'plugin', 'myarticles', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_MYARTICLES_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_MYARTICLES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"myarticles\"}', '{\"coreapp\":\"0\",\"position\":\"content\",\"section\":\"\",\"limit\":\"50\",\"count\":\"10\",\"introtext\":\"0\",\"cache\":\"1\",\"display_expired\":\"1\",\"hide_empty\":\"0\",\"title_override\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10102, 0, 'PLG_MYCONTACTS_TITLE', 'plugin', 'mycontacts', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_MYCONTACTS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_MYCONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mycontacts\"}', '{\"cache\":\"0\",\"coreapp\":\"0\",\"position\":\"content\",\"hide_empty\":\"0\",\"home_address\":\"1\",\"city\":\"1\",\"postal_code\":\"1\",\"country\":\"1\",\"phone_number\":\"1\",\"mobile_number\":\"1\",\"fax_number\":\"1\",\"website\":\"1\",\"my_company\":\"1\",\"work_address\":\"1\",\"comp_website\":\"1\",\"department\":\"1\",\"job_title\":\"1\",\"main_im_id\":\"1\",\"im_list\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10103, 0, 'PLG_MYFRIENDS_TITLE', 'plugin', 'myfriends', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_MYFRIENDS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"September 2014\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2014 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_MYFRIENDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"myfriends\"}', '{\"count\":\"10\",\"cache\":\"0\",\"coreapp\":\"0\",\"position\":\"content\",\"hide_empty\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10104, 0, 'PLG_MYGOOGLEADS_TITLE', 'plugin', 'mygoogleads', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_MYGOOGLEADS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_GOOGLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mygoogleads\"}', '{\"coreapp\":\"0\",\"position\":\"content\",\"cache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10105, 0, 'PLG_MYGROUPS_TITLE', 'plugin', 'mygroups', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_MYGROUPS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"September 2014\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2014 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_MYGROUPS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mygroups\"}', '{\"count\":\"10\",\"cache\":\"0\",\"coreapp\":\"0\",\"position\":\"content\",\"hide_empty\":\"1\",\"title_override\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10106, 0, 'PLG_MYTAGGEDVIDEOS_TITLE', 'plugin', 'mytaggedvideos', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_MYTAGGEDVIDEOS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"Febuary 2012\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_MYTAGGEDVIDEOS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mytaggedvideos\"}', '{\"coreapp\":\"0\",\"position\":\"content\",\"count\":\"10\",\"cache\":\"1\",\"hide_empty\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10107, 0, 'PLG_MYVIDEOS_TITLE', 'plugin', 'myvideos', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_MYVIDEOS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"Febuary 2012\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Display user\'s latest videos\",\"group\":\"\",\"filename\":\"myvideos\"}', '{\"coreapp\":\"0\",\"position\":\"content\",\"count\":\"10\",\"cache\":\"1\",\"hide_empty\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10108, 0, 'PLG_TWITTER_XML_TITLE', 'plugin', 'twitter', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_TWITTER_XML_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_TWITTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"twitter\"}', '{\"cache\":\"0\",\"position\":\"content\",\"coreapp\":\"0\",\"consumerKey\":\"\",\"consumerSecret\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10109, 0, 'PLG_WALLS_TITLE', 'plugin', 'walls', 'community', 0, 1, 1, 0, '{\"name\":\"PLG_WALLS_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_WALLS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"walls\"}', '{\"coreapp\":\"0\",\"cache\":\"1\",\"position\":\"content\",\"charlimit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10110, 0, 'PLG_WORDFILTER_TITLE', 'plugin', 'wordfilter', 'community', 0, 0, 1, 0, '{\"name\":\"PLG_WORDFILTER_TITLE\",\"type\":\"plugin\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright 2008 - 2013 by iJoomla, Inc. - All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"PLG_WORDFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wordfilter\"}', '{\"replacement\":\"*\",\"badwords\":\"fuck,shit\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10111, 0, 'JS Active Groups', 'module', 'mod_activegroups', '', 0, 1, 0, 0, '{\"name\":\"JS Active Groups\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Display most active groups from groups that is created within JomSocial\",\"group\":\"\",\"filename\":\"mod_activegroups\"}', '{\"cache\":\"1\",\"count\":\"5\",\"show_avatar\":\"1\",\"show_total\":\"1\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10112, 0, 'JS Activity Stream', 'module', 'mod_activitystream', '', 0, 1, 0, 0, '{\"name\":\"JS Activity Stream\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Activity Stream\",\"group\":\"\",\"filename\":\"mod_activitystream\"}', '{\"max_entry\":\"10\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10113, 0, 'JS Events', 'module', 'mod_community_events', '', 0, 1, 0, 0, '{\"name\":\"JS Events\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2013 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Events module for JomSocial. Display upcoming and current events.\",\"group\":\"\",\"filename\":\"mod_community_events\"}', '{\"moduleclass_sfx\":\"\",\"default\":\"5\",\"upcomingOnly\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10114, 0, 'JS Groups', 'module', 'mod_community_groups', '', 0, 1, 0, 0, '{\"name\":\"JS Groups\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2013 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Latest Groups\",\"group\":\"\",\"filename\":\"mod_community_groups\"}', '{\"moduleclass_sfx\":\"joms-module\",\"default\":\"5\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10115, 0, 'JS Members', 'module', 'mod_community_members', '', 0, 1, 0, 0, '{\"name\":\"JS Members\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2013 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Latest Members\",\"group\":\"\",\"filename\":\"mod_community_members\"}', '{\"moduleclass_sfx\":\"\",\"default\":\"5\",\"default_filter\":\"newest\",\"show_total_members\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10116, 0, 'JS Photos Module', 'module', 'mod_community_photos', '', 0, 1, 0, 0, '{\"name\":\"JS Photos Module\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2013 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Photos\",\"group\":\"\",\"filename\":\"mod_community_photos\"}', '{\"moduleclass_sfx\":\"\",\"default\":\"20\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10117, 0, 'JS Quick Search', 'module', 'mod_community_quicksearch', '', 0, 1, 0, 0, '{\"name\":\"JS Quick Search\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2013 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Community Quick Search\",\"group\":\"\",\"filename\":\"mod_community_quicksearch\"}', '{\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10118, 0, 'JS Nearby Events Search', 'module', 'mod_community_search_nearbyevents', '', 0, 1, 0, 0, '{\"name\":\"JS Nearby Events Search\",\"type\":\"module\",\"creationDate\":\"February 2015\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2015 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Nearby events search\",\"group\":\"\",\"filename\":\"mod_community_search_nearbyevents\"}', '{\"moduleclass_sfx\":\"\",\"event_nearby_radius\":\"10\",\"eventradiusmeasure\":\"miles\",\"auto_detect_location\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10119, 0, 'JS Videos', 'module', 'mod_community_videos', '', 0, 1, 0, 0, '{\"name\":\"JS Videos\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2013 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Lates Video\",\"group\":\"\",\"filename\":\"mod_community_videos\"}', '{\"moduleclass_sfx\":\"\",\"default\":\"5\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10120, 0, 'JS Whos Online', 'module', 'mod_community_whosonline', '', 0, 1, 0, 0, '{\"name\":\"JS Whos Online\",\"type\":\"module\",\"creationDate\":\"April 2013\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2013 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Whos online\",\"group\":\"\",\"filename\":\"mod_community_whosonline\"}', '{\"moduleclass_sfx\":\"\",\"default\":\"20\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10121, 0, 'JS Dating Search', 'module', 'mod_datingsearch', '', 0, 1, 0, 0, '{\"name\":\"JS Dating Search\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Dating Search\",\"group\":\"\",\"filename\":\"mod_datingsearch\"}', '{\"field_gender\":\"FIELD_GENDER\",\"field_birthdate\":\"FIELD_BIRTHDATE\",\"field_country\":\"FIELD_COUNTRY\",\"field_state\":\"FIELD_STATE\",\"field_city\":\"FIELD_CITY\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10122, 0, 'JS Hello Me', 'module', 'mod_hellome', '', 0, 1, 0, 0, '{\"name\":\"JS Hello Me\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Hello Me\",\"group\":\"\",\"filename\":\"mod_hellome\"}', '{\"cache\":\"0\",\"customCache\":\"1\",\"show_avatar\":\"1\",\"show_karma\":\"1\",\"enable_login\":\"1\",\"enable_facebookconnect\":\"1\",\"enable_alert\":\"1\",\"enable_menu\":\"1\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10124, 0, 'JS Latest Discussion', 'module', 'mod_latestdiscussion', '', 0, 1, 0, 0, '{\"name\":\"JS Latest Discussion\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Show the active discussion\",\"group\":\"\",\"filename\":\"mod_latestdiscussion\"}', '{\"cache\":\"1\",\"count\":\"5\",\"show_avatar\":\"1\",\"repeat_avatar\":\"1\",\"show_private_discussion\":\"1\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10125, 0, 'JS Latest group posts', 'module', 'mod_latestgrouppost', '', 0, 1, 0, 0, '{\"name\":\"JS Latest group posts\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Show recent wall posts from groups\",\"group\":\"\",\"filename\":\"mod_latestgrouppost\"}', '{\"cache\":\"0\",\"count\":\"5\",\"charcount\":\"100\",\"afterlogin_setting\":\"\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10127, 0, 'JS Photo Comments', 'module', 'mod_photocomments', '', 0, 1, 0, 0, '{\"name\":\"JS Photo Comments\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Displays recent photo walls\",\"group\":\"\",\"filename\":\"mod_photocomments\"}', '{\"moduleclass_sfx\":\"\",\"count\":\"5\",\"show_avatar\":\"1\",\"character_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10129, 0, 'JS Top Members', 'module', 'mod_topmembers', '', 0, 1, 0, 0, '{\"name\":\"JS Top Members\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Show the top members\",\"group\":\"\",\"filename\":\"mod_topmembers\"}', '{\"cache\":\"1\",\"count\":\"10\",\"show_avatar\":\"1\",\"show_karma\":\"1\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10130, 0, 'JS Video Comments', 'module', 'mod_videocomments', '', 0, 1, 0, 0, '{\"name\":\"JS Video Comments\",\"type\":\"module\",\"creationDate\":\"March 2011\",\"author\":\"JomSocial Team\",\"copyright\":\"Copyright (C) 2008 - 2010 JomSocial. All rights reserved.\",\"authorEmail\":\"support@jomsocial.com\",\"authorUrl\":\"http:\\/\\/www.jomsocial.com\",\"version\":\"4.0.1\",\"description\":\"Displays recent video walls\",\"group\":\"\",\"filename\":\"mod_videocomments\"}', '{\"moduleclass_sfx\":\"\",\"count\":\"5\",\"show_avatar\":\"1\",\"character_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10131, 0, 'PLG_USER_PROFILELMS', 'plugin', 'profilelms', 'user', 0, 1, 1, 0, '{\"name\":\"PLG_USER_PROFILELMS\",\"type\":\"plugin\",\"creationDate\":\"Sept 2015\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"info@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.2\",\"description\":\"User LMS Profile Plug-in For SP LMS\",\"group\":\"\",\"filename\":\"profilelms\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10132, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10133, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10135, 0, 'ArabicUnitag', 'language', 'ar-AA', '', 0, 1, 0, 0, '{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"12\\/21\\/2016\",\"author\":\"Dr. Ashraf Damra\\/Abu Nidal\",\"copyright\":\"Copyright (C) 2005 - 2016 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"http:\\/\\/www.jarabic.com\",\"version\":\"3.6.5\",\"description\":\"Arabic Unitag language files\\/Site 3.6 \\u0645\\u0644\\u0641\\u0627\\u062a \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0645\\u0648\\u0642\\u0639\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10136, 0, 'ArabicUnitag', 'language', 'ar-AA', '', 1, 1, 0, 0, '{\"name\":\"Arabic Unitag (\\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629)\",\"type\":\"language\",\"creationDate\":\"12\\/21\\/2016\",\"author\":\"Dr. Ashraf Damra\\/Abu Nidal\",\"copyright\":\"Copyright (C) 2005 - 2016 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"dr.d.ashraf@gmail.com\",\"authorUrl\":\"http:\\/\\/www.jarabic.com\",\"version\":\"3.6.5\",\"description\":\"Arabic Unitag language files\\/Administrator 3.6 \\u0645\\u0644\\u0641\\u0627\\u062a \\u0627\\u0644\\u0644\\u063a\\u0629 \\u0627\\u0644\\u0639\\u0631\\u0628\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062d\\u062f\\u0629\\/\\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10138, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10139, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.2\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10140, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"28 April 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2013-2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.1.1\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webinstaller\"}', '{\"tab_position\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10141, 0, 'SP LMS Persons', 'module', 'mod_splmspersons', '', 0, 1, 0, 0, '{\"name\":\"SP LMS Persons\",\"type\":\"module\",\"creationDate\":\"May 2017\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"SP LMS Persons: Module to display teachers or speakers from SP LMS\",\"group\":\"\",\"filename\":\"mod_splmspersons\"}', '{\"ordering\":\"desc\",\"columns\":\"4\",\"limit\":\"4\",\"layout\":\"default\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10142, 0, 'System - SP Property Updater', 'plugin', 'sppropertyupdater', 'system', 0, 0, 1, 0, '{\"name\":\"System - SP Property Updater\",\"type\":\"plugin\",\"creationDate\":\"Jan 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"SP Property Updater Plugin\",\"group\":\"\",\"filename\":\"sppropertyupdater\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10143, 0, 'AcyMailing JCE integration', 'plugin', 'jceacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.9.6\",\"author\":\"Acyba\",\"creationDate\":\"March 2018\"}', '', '', '', 0, '0000-00-00 00:00:00', 23, 0),
(10145, 10146, 'Kunena Media Files', 'file', 'kunena_media', '', 0, 1, 0, 0, '{\"name\":\"Kunena Media Files\",\"type\":\"file\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"Kunena media files.\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10146, 0, 'Kunena Forum Package', 'package', 'pkg_kunena', '', 0, 1, 1, 0, '{\"name\":\"Kunena Forum Package\",\"type\":\"package\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"Kunena Forum Package.\",\"group\":\"\",\"filename\":\"pkg_kunena\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10147, 0, 'plg_finder_kunena', 'plugin', 'kunena', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_kunena\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_FINDER_KUNENA_DESCRIPTION\",\"group\":\"\",\"filename\":\"kunena\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10148, 0, 'plg_kunena_altauserpoints', 'plugin', 'altauserpoints', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_altauserpoints\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"www.kunena.org\",\"authorEmail\":\"Kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_ALTAUSERPOINTS_DESCRIPTION\",\"group\":\"\",\"filename\":\"altauserpoints\"}', '{\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"activity_points_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10149, 0, 'PLG_KUNENA_EASYPROFILE', 'plugin', 'easyprofile', 'kunena', 0, 0, 1, 0, '{\"name\":\"PLG_KUNENA_EASYPROFILE\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Onlinecommunityhub\",\"copyright\":\"https:\\/\\/onlinecommunityhub.nl\",\"authorEmail\":\"info@onlinecommunityhub.nl\",\"authorUrl\":\"https:\\/\\/onlinecommunityhub.nl\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_EASYPROFILE_DESCRIPTION\",\"group\":\"\",\"filename\":\"easyprofile\"}', '{\"avatar\":\"1\",\"guestavatar\":\"easyprofile\",\"profile\":\"1\",\"userlist\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10150, 0, 'plg_kunena_easysocial', 'plugin', 'easysocial', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_easysocial\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"StackIdeas\",\"copyright\":\"https:\\/\\/stackideas.com\",\"authorEmail\":\"support@stackideas.com\",\"authorUrl\":\"https:\\/\\/stackideas.com\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_EASYSOCIAL_DESCRIPTION\",\"group\":\"\",\"filename\":\"easysocial\"}', '{\"login\":\"1\",\"activity\":\"1\",\"avatar\":\"1\",\"profile\":\"1\",\"private\":\"1\",\"activity_badge_limit\":\"0\",\"activity_points_limit\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10151, 0, 'plg_kunena_finder', 'plugin', 'finder', 'kunena', 0, 0, 1, 0, '{\"name\":\"plg_kunena_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"PLG_KUNENA_FINDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10152, 10146, 'Kunena Framework', 'library', 'kunena', '', 0, 1, 1, 0, '{\"name\":\"Kunena Framework\",\"type\":\"library\",\"creationDate\":\"2018-03-14\",\"author\":\"Kunena Team\",\"copyright\":\"(C) 2008 - 2018 Kunena Team. All rights reserved.\",\"authorEmail\":\"kunena@kunena.org\",\"authorUrl\":\"https:\\/\\/www.kunena.org\",\"version\":\"5.0.14\",\"description\":\"Kunena Framework.\",\"group\":\"\",\"filename\":\"kunena\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10153, 0, 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10154, 0, 'SP LMS Cart', 'module', 'mod_splmscart', '', 0, 1, 0, 0, '{\"name\":\"SP LMS Cart\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"Module to display latest item from SP LMS\",\"group\":\"\",\"filename\":\"mod_splmscart\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10155, 0, 'System - SP LMS Updater', 'plugin', 'splmsupdater', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP LMS Updater\",\"type\":\"plugin\",\"creationDate\":\"Jan 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"SP LMS Updater Plugin\",\"group\":\"\",\"filename\":\"splmsupdater\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10156, 0, 'SP LMS Event Calendar', 'module', 'mod_splmseventcalendar', '', 0, 1, 0, 0, '{\"name\":\"SP LMS Event Calendar\",\"type\":\"module\",\"creationDate\":\"Apr 2018\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2018 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0\",\"description\":\"Module to display upcoming events from SP LMS\",\"group\":\"\",\"filename\":\"mod_splmseventcalendar\"}', '{\"layout\":\"default\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__fields`
--

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE `#__fields` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_categories`
--

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_groups`
--

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_values`
--

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_aliases`
--

DROP TABLE IF EXISTS `#__kunena_aliases`;
CREATE TABLE `#__kunena_aliases` (
  `alias` varchar(255) NOT NULL,
  `type` varchar(10) NOT NULL,
  `item` varchar(32) NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_aliases`
--

INSERT INTO `#__kunena_aliases` (`alias`, `type`, `item`, `state`) VALUES
('announcement', 'view', 'announcement', 1),
('category', 'view', 'category', 1),
('category/create', 'layout', 'category.create', 1),
('category/default', 'layout', 'category.default', 1),
('category/edit', 'layout', 'category.edit', 1),
('category/manage', 'layout', 'category.manage', 1),
('category/moderate', 'layout', 'category.moderate', 1),
('category/user', 'layout', 'category.user', 1),
('common', 'view', 'common', 1),
('create', 'layout', 'category.create', 0),
('credits', 'view', 'credits', 1),
('default', 'layout', 'category.default', 0),
('edit', 'layout', 'category.edit', 0),
('home', 'view', 'home', 1),
('main-forum', 'catid', '1', 1),
('manage', 'layout', 'category.manage', 0),
('misc', 'view', 'misc', 1),
('moderate', 'layout', 'category.moderate', 0),
('search', 'view', 'search', 1),
('statistics', 'view', 'statistics', 1),
('suggestion-box', 'catid', '3', 1),
('topic', 'view', 'topic', 1),
('topics', 'view', 'topics', 1),
('user', 'view', 'user', 1),
('welcome-to-varsita', 'catid', '2', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_announcement`
--

DROP TABLE IF EXISTS `#__kunena_announcement`;
CREATE TABLE `#__kunena_announcement` (
  `id` int(3) NOT NULL,
  `title` tinytext NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `sdescription` text NOT NULL,
  `description` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  `showdate` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_attachments`
--

DROP TABLE IF EXISTS `#__kunena_attachments`;
CREATE TABLE `#__kunena_attachments` (
  `id` int(11) NOT NULL,
  `mesid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `protected` tinyint(4) NOT NULL DEFAULT '0',
  `hash` char(32) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `folder` varchar(255) NOT NULL,
  `filetype` varchar(20) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `filename_real` varchar(255) NOT NULL DEFAULT '',
  `caption` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_categories`
--

DROP TABLE IF EXISTS `#__kunena_categories`;
CREATE TABLE `#__kunena_categories` (
  `id` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT '0',
  `name` tinytext,
  `alias` varchar(255) NOT NULL,
  `icon` varchar(60) DEFAULT NULL,
  `icon_id` tinyint(4) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `accesstype` varchar(20) NOT NULL DEFAULT 'joomla.level',
  `access` int(11) NOT NULL DEFAULT '0',
  `pub_access` int(11) NOT NULL DEFAULT '1',
  `pub_recurse` tinyint(4) DEFAULT '1',
  `admin_access` int(11) NOT NULL DEFAULT '0',
  `admin_recurse` tinyint(4) DEFAULT '1',
  `ordering` smallint(6) NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `channels` text,
  `checked_out` tinyint(4) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review` tinyint(4) NOT NULL DEFAULT '0',
  `allow_anonymous` tinyint(4) NOT NULL DEFAULT '0',
  `post_anonymous` tinyint(4) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `headerdesc` text NOT NULL,
  `class_sfx` varchar(20) NOT NULL,
  `allow_polls` tinyint(4) NOT NULL DEFAULT '0',
  `topic_ordering` varchar(16) NOT NULL DEFAULT 'lastpost',
  `iconset` varchar(255) NOT NULL DEFAULT 'default',
  `numTopics` mediumint(8) NOT NULL DEFAULT '0',
  `numPosts` mediumint(8) NOT NULL DEFAULT '0',
  `last_topic_id` int(11) NOT NULL DEFAULT '0',
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `last_post_time` int(11) NOT NULL DEFAULT '0',
  `allow_ratings` tinyint(4) NOT NULL DEFAULT '0',
  `params` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_categories`
--

INSERT INTO `#__kunena_categories` (`id`, `parent_id`, `name`, `alias`, `icon`, `icon_id`, `locked`, `accesstype`, `access`, `pub_access`, `pub_recurse`, `admin_access`, `admin_recurse`, `ordering`, `published`, `channels`, `checked_out`, `checked_out_time`, `review`, `allow_anonymous`, `post_anonymous`, `hits`, `description`, `headerdesc`, `class_sfx`, `allow_polls`, `topic_ordering`, `iconset`, `numTopics`, `numPosts`, `last_topic_id`, `last_post_id`, `last_post_time`, `allow_ratings`, `params`) VALUES
(1, 0, 'Main Forum', 'main-forum', '', 0, 0, 'joomla.group', 0, 1, 1, 0, 1, 1, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'This is the main forum section. It serves as a container for categories for your topics.', 'The section header is used to display additional information about the categories of topics that it contains.', '', 0, 'lastpost', 'default', 0, 0, 0, 0, 0, 0, ''),
(2, 1, 'Welcome to Varsita', 'welcome-to-varsita', '', 0, 0, 'joomla.group', 1, 1, 1, 0, 1, 1, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', '[b]Welcome to Varsita forum![/b] \r\n\r\nSirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', '', 0, 'lastpost', 'default', 1, 1, 1, 1, 1425624155, 0, '{\"access_post\":[\"6\",\"2\",\"8\"],\"access_reply\":[\"6\",\"2\",\"8\"]}'),
(3, 1, 'Suggestion Box', 'suggestion-box', '', 0, 0, 'joomla.group', 0, 1, 1, 0, 1, 2, 1, NULL, 0, '0000-00-00 00:00:00', 0, 0, 0, 0, 'Have some feedback and input to share? \n Don\'t be shy and drop us a note. We want to hear from you and strive to make our site better and more user friendly for our guests and members a like.', 'This is the optional category header for the Suggestion Box.', '', 1, 'lastpost', 'default', 0, 0, 0, 0, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_configuration`
--

DROP TABLE IF EXISTS `#__kunena_configuration`;
CREATE TABLE `#__kunena_configuration` (
  `id` int(11) NOT NULL DEFAULT '0',
  `params` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_configuration`
--

INSERT INTO `#__kunena_configuration` (`id`, `params`) VALUES
(1, '{\"board_title\":\"Varsita Forum\",\"email\":\"install@joomshaper.com\",\"board_offline\":\"0\",\"offline_message\":\"<h2>The Forum is currently offline for maintenance.<\\/h2>\\r\\n<div>Check back soon!<\\/div>\",\"enablerss\":\"1\",\"threads_per_page\":\"10\",\"messages_per_page\":\"6\",\"messages_per_page_search\":\"10\",\"showhistory\":\"1\",\"historylimit\":\"6\",\"shownew\":\"1\",\"disemoticons\":\"0\",\"template\":\"crypsis\",\"showannouncement\":\"1\",\"avataroncat\":\"0\",\"catimagepath\":\"category_images\",\"showchildcaticon\":\"1\",\"rtewidth\":\"450\",\"rteheight\":\"300\",\"enableforumjump\":\"1\",\"reportmsg\":\"1\",\"username\":\"1\",\"askemail\":\"0\",\"showemail\":\"0\",\"showuserstats\":\"1\",\"showkarma\":\"1\",\"useredit\":\"1\",\"useredittime\":\"0\",\"useredittimegrace\":\"600\",\"editmarkup\":\"1\",\"allowsubscriptions\":\"1\",\"subscriptionschecked\":\"1\",\"allowfavorites\":\"1\",\"maxsubject\":\"50\",\"maxsig\":\"300\",\"regonly\":\"0\",\"pubwrite\":\"0\",\"floodprotection\":\"0\",\"mailmod\":\"0\",\"mailadmin\":\"0\",\"captcha\":\"0\",\"mailfull\":\"1\",\"allowavatarupload\":\"1\",\"allowavatargallery\":\"1\",\"avatarquality\":\"75\",\"avatarsize\":\"2048\",\"imageheight\":\"800\",\"imagewidth\":\"800\",\"imagesize\":\"150\",\"filetypes\":\"txt,rtf,pdf,zip,tar.gz,tgz,tar.bz2\",\"filesize\":\"120\",\"showranking\":\"1\",\"rankimages\":\"1\",\"userlist_rows\":\"30\",\"userlist_online\":\"1\",\"userlist_avatar\":\"1\",\"userlist_posts\":\"1\",\"userlist_karma\":\"1\",\"userlist_email\":\"0\",\"userlist_joindate\":\"1\",\"userlist_lastvisitdate\":\"1\",\"userlist_userhits\":\"1\",\"latestcategory\":\"\",\"showstats\":\"1\",\"showwhoisonline\":\"1\",\"showgenstats\":\"1\",\"showpopuserstats\":\"1\",\"popusercount\":\"5\",\"showpopsubjectstats\":\"1\",\"popsubjectcount\":\"5\",\"showspoilertag\":\"1\",\"showvideotag\":\"1\",\"showebaytag\":\"1\",\"trimlongurls\":\"1\",\"trimlongurlsfront\":\"40\",\"trimlongurlsback\":\"20\",\"autoembedyoutube\":\"1\",\"autoembedebay\":\"1\",\"ebaylanguagecode\":\"en-us\",\"sessiontimeout\":\"1800\",\"highlightcode\":\"0\",\"rss_type\":\"topic\",\"rss_timelimit\":\"month\",\"rss_limit\":\"100\",\"rss_included_categories\":\"\",\"rss_excluded_categories\":\"\",\"rss_specification\":\"rss2.0\",\"rss_allow_html\":\"1\",\"rss_author_format\":\"name\",\"rss_author_in_title\":\"1\",\"rss_word_count\":\"0\",\"rss_old_titles\":\"1\",\"rss_cache\":\"900\",\"defaultpage\":\"recent\",\"default_sort\":\"asc\",\"sef\":\"1\",\"showimgforguest\":\"1\",\"showfileforguest\":\"1\",\"pollnboptions\":\"4\",\"pollallowvoteone\":\"1\",\"pollenabled\":\"1\",\"poppollscount\":\"5\",\"showpoppollstats\":\"1\",\"polltimebtvotes\":\"00:15:00\",\"pollnbvotesbyuser\":\"100\",\"pollresultsuserslist\":\"1\",\"maxpersotext\":\"50\",\"ordering_system\":\"mesid\",\"post_dateformat\":\"ago\",\"post_dateformat_hover\":\"datetime\",\"hide_ip\":\"1\",\"imagetypes\":\"jpg,jpeg,gif,png\",\"checkmimetypes\":\"1\",\"imagemimetypes\":\"image\\/jpeg,image\\/jpg,image\\/gif,image\\/png\",\"imagequality\":\"50\",\"thumbheight\":\"32\",\"thumbwidth\":\"32\",\"hideuserprofileinfo\":\"put_empty\",\"boxghostmessage\":\"0\",\"userdeletetmessage\":\"1\",\"latestcategory_in\":\"1\",\"topicicons\":\"1\",\"debug\":\"0\",\"catsautosubscribed\":0,\"showbannedreason\":\"0\",\"showthankyou\":\"1\",\"showpopthankyoustats\":\"1\",\"popthankscount\":\"5\",\"mod_see_deleted\":\"0\",\"bbcode_img_secure\":\"text\",\"listcat_show_moderators\":\"1\",\"lightbox\":\"1\",\"show_list_time\":\"720\",\"show_session_type\":\"0\",\"show_session_starttime\":\"0\",\"userlist_allowed\":1,\"userlist_count_users\":\"1\",\"enable_threaded_layouts\":\"0\",\"category_subscriptions\":\"post\",\"topic_subscriptions\":\"every\",\"pubprofile\":\"1\",\"thankyou_max\":\"10\",\"email_recipient_count\":\"0\",\"email_recipient_privacy\":\"bcc\",\"email_visible_address\":\"\",\"captcha_post_limit\":\"0\",\"image_upload\":\"registered\",\"file_upload\":\"registered\",\"topic_layout\":\"flat\",\"time_to_create_page\":\"1\",\"show_imgfiles_manage_profile\":\"1\",\"hold_newusers_posts\":\"0\",\"hold_guest_posts\":\"0\",\"attachment_limit\":\"8\",\"pickup_category\":\"0\",\"article_display\":\"intro\",\"send_emails\":\"1\",\"fallback_english\":\"1\",\"cache\":\"1\",\"cache_time\":\"60\",\"ebay_affiliate_id\":\"5337089937\",\"iptracking\":\"1\",\"stopforumspam_key\":\"\",\"rss_feedburner_url\":\"\",\"autolink\":\"1\",\"access_component\":\"1\",\"statslink_allowed\":\"1\",\"superadmin_userlist\":\"0\",\"legacy_urls\":1,\"attachment_protection\":0,\"categoryicons\":1,\"avatarresizemethod\":1,\"avatarcrop\":0,\"user_report\":1,\"searchtime\":365,\"teaser\":0,\"ebay_language\":\"0\",\"ebay_api_key\":\"\",\"twitter_consumer_key\":\"\",\"twitter_consumer_secret\":\"\",\"allow_change_subject\":1,\"max_links\":6,\"read_only\":0,\"ratingenabled\":0,\"url_subject_topic\":0,\"log_moderation\":0,\"attach_start\":0,\"attach_end\":14,\"google_map_api_key\":\"\",\"attachment_utf8\":1,\"autoembedsoundcloud\":1,\"emailheader\":\"\\/media\\/kunena\\/email\\/hero-wide.png\",\"user_status\":1,\"plain_email\":0,\"moderator_permdelete\":0,\"recaptcha_publickey\":\"\",\"recaptcha_privatekey\":\"\",\"recaptcha_theme\":\"white\",\"keywords\":0,\"userkeywords\":0,\"userlist_name\":\"1\",\"usernamechange\":\"0\",\"version_check\":\"1\",\"plugins\":[]}');

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_logs`
--

DROP TABLE IF EXISTS `#__kunena_logs`;
CREATE TABLE `#__kunena_logs` (
  `id` int(11) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `topic_id` int(11) NOT NULL DEFAULT '0',
  `target_user` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(40) NOT NULL DEFAULT '',
  `time` int(11) NOT NULL DEFAULT '0',
  `operation` varchar(40) NOT NULL,
  `data` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_messages`
--

DROP TABLE IF EXISTS `#__kunena_messages`;
CREATE TABLE `#__kunena_messages` (
  `id` int(11) NOT NULL,
  `parent` int(11) DEFAULT '0',
  `thread` int(11) DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `name` tinytext,
  `userid` int(11) NOT NULL DEFAULT '0',
  `email` tinytext,
  `subject` tinytext,
  `time` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(128) DEFAULT NULL,
  `topic_emoticon` int(11) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `hold` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) DEFAULT '0',
  `hits` int(11) DEFAULT '0',
  `moved` tinyint(4) DEFAULT '0',
  `modified_by` int(7) DEFAULT NULL,
  `modified_time` int(11) DEFAULT NULL,
  `modified_reason` tinytext
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_messages`
--

INSERT INTO `#__kunena_messages` (`id`, `parent`, `thread`, `catid`, `name`, `userid`, `email`, `subject`, `time`, `ip`, `topic_emoticon`, `locked`, `hold`, `ordering`, `hits`, `moved`, `modified_by`, `modified_time`, `modified_reason`) VALUES
(1, 0, 1, 2, 'Kunena', 152, NULL, 'Welcome to Kunena!', 1425624155, '127.0.0.1', 0, 0, 0, 0, 0, 0, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_messages_text`
--

DROP TABLE IF EXISTS `#__kunena_messages_text`;
CREATE TABLE `#__kunena_messages_text` (
  `mesid` int(11) NOT NULL DEFAULT '0',
  `message` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_messages_text`
--

INSERT INTO `#__kunena_messages_text` (`mesid`, `message`) VALUES
(1, '[size=4][b]Welcome to Kunena![/b][/size] \n\n Thank you for choosing Kunena for your community forum needs in Joomla. \n\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \n\n\n [size=4][b]Additional Kunena Resources[/b][/size] \n\n [b]Kunena Documentation:[/b] [url]http://www.kunena.org/docs[/url] \n\n [b]Kunena Support Forum[/b]: [url]http://www.kunena.org/forum[/url] \n\n [b]Kunena Downloads:[/b] [url]http://www.kunena.org/download[/url] \n\n [b]Kunena Blog:[/b] [url]http://www.kunena.org/blog[/url] \n\n [b]Follow Kunena on Twitter:[/b] [url]http://www.kunena.org/twitter[/url]');

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_polls`
--

DROP TABLE IF EXISTS `#__kunena_polls`;
CREATE TABLE `#__kunena_polls` (
  `id` int(11) NOT NULL,
  `title` varchar(150) DEFAULT NULL,
  `threadid` int(11) NOT NULL,
  `polltimetolive` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_polls_options`
--

DROP TABLE IF EXISTS `#__kunena_polls_options`;
CREATE TABLE `#__kunena_polls_options` (
  `id` int(11) NOT NULL,
  `pollid` int(11) DEFAULT NULL,
  `text` varchar(100) DEFAULT NULL,
  `votes` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_polls_users`
--

DROP TABLE IF EXISTS `#__kunena_polls_users`;
CREATE TABLE `#__kunena_polls_users` (
  `pollid` int(11) DEFAULT NULL,
  `userid` int(11) DEFAULT NULL,
  `votes` int(11) DEFAULT NULL,
  `lasttime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvote` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_ranks`
--

DROP TABLE IF EXISTS `#__kunena_ranks`;
CREATE TABLE `#__kunena_ranks` (
  `rank_id` mediumint(8) UNSIGNED NOT NULL,
  `rank_title` varchar(255) NOT NULL DEFAULT '',
  `rank_min` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `rank_special` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `rank_image` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_ranks`
--

INSERT INTO `#__kunena_ranks` (`rank_id`, `rank_title`, `rank_min`, `rank_special`, `rank_image`) VALUES
(1, 'New Member', 0, 0, 'rank1.gif'),
(2, 'Junior Member', 20, 0, 'rank2.gif'),
(3, 'Senior Member', 40, 0, 'rank3.gif'),
(4, 'Premium Member', 80, 0, 'rank4.gif'),
(5, 'Elite Member', 160, 0, 'rank5.gif'),
(6, 'Platinum Member', 320, 0, 'rank6.gif'),
(7, 'Administrator', 0, 1, 'rankadmin.gif'),
(8, 'Moderator', 0, 1, 'rankmod.gif'),
(9, 'Spammer', 0, 1, 'rankspammer.gif'),
(10, 'Banned', 0, 1, 'rankbanned.gif');

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_rate`
--

DROP TABLE IF EXISTS `#__kunena_rate`;
CREATE TABLE `#__kunena_rate` (
  `id` int(11) NOT NULL,
  `topic_id` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `rate` mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  `time` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_sessions`
--

DROP TABLE IF EXISTS `#__kunena_sessions`;
CREATE TABLE `#__kunena_sessions` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `allowed` text,
  `lasttime` int(11) NOT NULL DEFAULT '0',
  `readtopics` text,
  `currvisit` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_sessions`
--

INSERT INTO `#__kunena_sessions` (`userid`, `allowed`, `lasttime`, `readtopics`, `currvisit`) VALUES
(152, 'na', 1426670437, '0', 1426672122),
(221, 'na', 1487161568, '0', 1488371309),
(490, 'na', 1451638298, '0', 1452848085),
(776, 'na', 1519108406, '0', 1519386681);

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_smileys`
--

DROP TABLE IF EXISTS `#__kunena_smileys`;
CREATE TABLE `#__kunena_smileys` (
  `id` int(4) NOT NULL,
  `code` varchar(12) NOT NULL DEFAULT '',
  `location` varchar(50) NOT NULL DEFAULT '',
  `greylocation` varchar(60) NOT NULL DEFAULT '',
  `emoticonbar` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_smileys`
--

INSERT INTO `#__kunena_smileys` (`id`, `code`, `location`, `greylocation`, `emoticonbar`) VALUES
(1, 'B)', 'cool.png', 'cool-grey.png', 1),
(2, '8)', 'cool.png', 'cool-grey.png', 0),
(3, '8-)', 'cool.png', 'cool-grey.png', 0),
(4, ':-(', 'sad.png', 'sad-grey.png', 0),
(5, ':(', 'sad.png', 'sad-grey.png', 1),
(6, ':sad:', 'sad.png', 'sad-grey.png', 0),
(7, ':cry:', 'sad.png', 'sad-grey.png', 0),
(8, ':)', 'smile.png', 'smile-grey.png', 1),
(9, ':-)', 'smile.png', 'smile-grey.png', 0),
(10, ':cheer:', 'cheerful.png', 'cheerful-grey.png', 1),
(11, ';)', 'wink.png', 'wink-grey.png', 1),
(12, ';-)', 'wink.png', 'wink-grey.png', 0),
(13, ':wink:', 'wink.png', 'wink-grey.png', 0),
(14, ';-)', 'wink.png', 'wink-grey.png', 0),
(15, ':P', 'tongue.png', 'tongue-grey.png', 1),
(16, ':p', 'tongue.png', 'tongue-grey.png', 0),
(17, ':-p', 'tongue.png', 'tongue-grey.png', 0),
(18, ':-P', 'tongue.png', 'tongue-grey.png', 0),
(19, ':razz:', 'tongue.png', 'tongue-grey.png', 0),
(20, ':angry:', 'angry.png', 'angry-grey.png', 1),
(21, ':mad:', 'angry.png', 'angry-grey.png', 0),
(22, ':unsure:', 'unsure.png', 'unsure-grey.png', 1),
(23, ':o', 'shocked.png', 'shocked-grey.png', 0),
(24, ':-o', 'shocked.png', 'shocked-grey.png', 0),
(25, ':O', 'shocked.png', 'shocked-grey.png', 0),
(26, ':-O', 'shocked.png', 'shocked-grey.png', 0),
(27, ':eek:', 'shocked.png', 'shocked-grey.png', 0),
(28, ':ohmy:', 'shocked.png', 'shocked-grey.png', 1),
(29, ':huh:', 'wassat.png', 'wassat-grey.png', 1),
(30, ':?', 'confused.png', 'confused-grey.png', 0),
(31, ':-?', 'confused.png', 'confused-grey.png', 0),
(32, ':???', 'confused.png', 'confused-grey.png', 0),
(33, ':dry:', 'ermm.png', 'ermm-grey.png', 1),
(34, ':ermm:', 'ermm.png', 'ermm-grey.png', 0),
(35, ':lol:', 'grin.png', 'grin-grey.png', 1),
(36, ':X', 'sick.png', 'sick-grey.png', 0),
(37, ':x', 'sick.png', 'sick-grey.png', 0),
(38, ':sick:', 'sick.png', 'sick-grey.png', 1),
(39, ':silly:', 'silly.png', 'silly-grey.png', 1),
(40, ':y32b4:', 'silly.png', 'silly-grey.png', 0),
(41, ':blink:', 'blink.png', 'blink-grey.png', 1),
(42, ':blush:', 'blush.png', 'blush-grey.png', 1),
(43, ':oops:', 'blush.png', 'blush-grey.png', 1),
(44, ':kiss:', 'kissing.png', 'kissing-grey.png', 1),
(45, ':rolleyes:', 'blink.png', 'blink-grey.png', 0),
(46, ':roll:', 'blink.png', 'blink-grey.png', 0),
(47, ':woohoo:', 'w00t.png', 'w00t-grey.png', 1),
(48, ':side:', 'sideways.png', 'sideways-grey.png', 1),
(49, ':S', 'dizzy.png', 'dizzy-grey.png', 1),
(50, ':s', 'dizzy.png', 'dizzy-grey.png', 0),
(51, ':evil:', 'devil.png', 'devil-grey.png', 1),
(52, ':twisted:', 'devil.png', 'devil-grey.png', 0),
(53, ':whistle:', 'whistling.png', 'whistling-grey.png', 1),
(54, ':pinch:', 'pinch.png', 'pinch-grey.png', 1),
(55, ':D', 'laughing.png', 'laughing-grey.png', 0),
(56, ':-D', 'laughing.png', 'laughing-grey.png', 0),
(57, ':grin:', 'laughing.png', 'laughing-grey.png', 0),
(58, ':laugh:', 'laughing.png', 'laughing-grey.png', 0),
(59, ':|', 'neutral.png', 'neutral-grey.png', 0),
(60, ':-|', 'neutral.png', 'neutral-grey.png', 0),
(61, ':neutral:', 'neutral.png', 'neutral-grey.png', 0),
(62, ':mrgreen:', 'mrgreen.png', 'mrgreen-grey.png', 0),
(63, ':?:', 'question.png', 'question-grey.png', 0),
(64, ':!:', 'exclamation.png', 'exclamation-grey.png', 0),
(65, ':arrow:', 'arrow.png', 'arrow-grey.png', 0),
(66, ':idea:', 'idea.png', 'idea-grey.png', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_thankyou`
--

DROP TABLE IF EXISTS `#__kunena_thankyou`;
CREATE TABLE `#__kunena_thankyou` (
  `postid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `targetuserid` int(11) NOT NULL,
  `time` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_topics`
--

DROP TABLE IF EXISTS `#__kunena_topics`;
CREATE TABLE `#__kunena_topics` (
  `id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `subject` tinytext,
  `icon_id` int(11) NOT NULL DEFAULT '0',
  `label_id` int(11) NOT NULL DEFAULT '0',
  `locked` tinyint(4) NOT NULL DEFAULT '0',
  `hold` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `posts` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `attachments` int(11) NOT NULL DEFAULT '0',
  `poll_id` int(11) NOT NULL DEFAULT '0',
  `moved_id` int(11) NOT NULL DEFAULT '0',
  `first_post_id` int(11) NOT NULL DEFAULT '0',
  `first_post_time` int(11) NOT NULL DEFAULT '0',
  `first_post_userid` int(11) NOT NULL DEFAULT '0',
  `first_post_message` text,
  `first_post_guest_name` tinytext,
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `last_post_time` int(11) NOT NULL DEFAULT '0',
  `last_post_userid` int(11) NOT NULL DEFAULT '0',
  `last_post_message` text,
  `last_post_guest_name` tinytext,
  `rating` tinyint(6) NOT NULL DEFAULT '0',
  `params` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_topics`
--

INSERT INTO `#__kunena_topics` (`id`, `category_id`, `subject`, `icon_id`, `label_id`, `locked`, `hold`, `ordering`, `posts`, `hits`, `attachments`, `poll_id`, `moved_id`, `first_post_id`, `first_post_time`, `first_post_userid`, `first_post_message`, `first_post_guest_name`, `last_post_id`, `last_post_time`, `last_post_userid`, `last_post_message`, `last_post_guest_name`, `rating`, `params`) VALUES
(1, 2, 'Welcome to Kunena!', 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 1, 1425624155, 152, '[size=4][b]Welcome to Kunena![/b][/size] \n\n Thank you for choosing Kunena for your community forum needs in Joomla. \n\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \n\n\n [size=4][b]Additional Kunena Resources[/b][/size] \n\n [b]Kunena Documentation:[/b] [url]http://www.kunena.org/docs[/url] \n\n [b]Kunena Support Forum[/b]: [url]http://www.kunena.org/forum[/url] \n\n [b]Kunena Downloads:[/b] [url]http://www.kunena.org/download[/url] \n\n [b]Kunena Blog:[/b] [url]http://www.kunena.org/blog[/url] \n\n [b]Follow Kunena on Twitter:[/b] [url]http://www.kunena.org/twitter[/url]', 'Kunena', 1, 1425624155, 152, '[size=4][b]Welcome to Kunena![/b][/size] \n\n Thank you for choosing Kunena for your community forum needs in Joomla. \n\n Kunena, translated from Swahili meaning “to speak”, is built by a team of open source professionals with the goal of providing a top quality, tightly unified forum solution for Joomla. \n\n\n [size=4][b]Additional Kunena Resources[/b][/size] \n\n [b]Kunena Documentation:[/b] [url]http://www.kunena.org/docs[/url] \n\n [b]Kunena Support Forum[/b]: [url]http://www.kunena.org/forum[/url] \n\n [b]Kunena Downloads:[/b] [url]http://www.kunena.org/download[/url] \n\n [b]Kunena Blog:[/b] [url]http://www.kunena.org/blog[/url] \n\n [b]Follow Kunena on Twitter:[/b] [url]http://www.kunena.org/twitter[/url]', 'Kunena', 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_users`
--

DROP TABLE IF EXISTS `#__kunena_users`;
CREATE TABLE `#__kunena_users` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `status_text` varchar(255) NOT NULL DEFAULT '',
  `view` varchar(8) NOT NULL DEFAULT '',
  `signature` text,
  `moderator` int(11) DEFAULT '0',
  `banned` datetime DEFAULT NULL,
  `ordering` int(11) DEFAULT '0',
  `posts` int(11) DEFAULT '0',
  `avatar` varchar(255) DEFAULT NULL,
  `karma` int(11) DEFAULT '0',
  `karma_time` int(11) DEFAULT '0',
  `group_id` int(4) DEFAULT '1',
  `uhits` int(11) DEFAULT '0',
  `personalText` tinytext,
  `gender` tinyint(4) NOT NULL DEFAULT '0',
  `birthdate` date NOT NULL DEFAULT '0001-01-01',
  `location` varchar(50) DEFAULT NULL,
  `icq` varchar(50) DEFAULT NULL,
  `aim` varchar(50) DEFAULT NULL,
  `yim` varchar(50) DEFAULT NULL,
  `microsoft` varchar(50) DEFAULT NULL,
  `telegram` varchar(50) DEFAULT NULL,
  `vk` varchar(50) DEFAULT NULL,
  `skype` varchar(50) DEFAULT NULL,
  `twitter` varchar(50) DEFAULT NULL,
  `facebook` varchar(50) DEFAULT NULL,
  `google` varchar(50) DEFAULT NULL,
  `myspace` varchar(50) DEFAULT NULL,
  `linkedin` varchar(50) DEFAULT NULL,
  `delicious` varchar(50) DEFAULT NULL,
  `friendfeed` varchar(50) DEFAULT NULL,
  `digg` varchar(50) DEFAULT NULL,
  `instagram` varchar(50) DEFAULT NULL,
  `qq` varchar(50) DEFAULT NULL,
  `qzone` varchar(50) DEFAULT NULL,
  `weibo` varchar(50) DEFAULT NULL,
  `wechat` varchar(50) DEFAULT NULL,
  `apple` varchar(50) DEFAULT NULL,
  `blogspot` varchar(50) DEFAULT NULL,
  `flickr` varchar(50) DEFAULT NULL,
  `bebo` varchar(50) DEFAULT NULL,
  `websitename` varchar(50) DEFAULT NULL,
  `websiteurl` varchar(50) DEFAULT NULL,
  `rank` tinyint(4) NOT NULL DEFAULT '0',
  `hideEmail` tinyint(1) NOT NULL DEFAULT '1',
  `showOnline` tinyint(1) NOT NULL DEFAULT '1',
  `canSubscribe` tinyint(1) NOT NULL DEFAULT '-1',
  `userListtime` int(11) NOT NULL DEFAULT '-2',
  `thankyou` int(11) DEFAULT '0',
  `ip` varchar(13) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_users`
--

INSERT INTO `#__kunena_users` (`userid`, `status`, `status_text`, `view`, `signature`, `moderator`, `banned`, `ordering`, `posts`, `avatar`, `karma`, `karma_time`, `group_id`, `uhits`, `personalText`, `gender`, `birthdate`, `location`, `icq`, `aim`, `yim`, `microsoft`, `telegram`, `vk`, `skype`, `twitter`, `facebook`, `google`, `myspace`, `linkedin`, `delicious`, `friendfeed`, `digg`, `instagram`, `qq`, `qzone`, `weibo`, `wechat`, `apple`, `blogspot`, `flickr`, `bebo`, `websitename`, `websiteurl`, `rank`, `hideEmail`, `showOnline`, `canSubscribe`, `userListtime`, `thankyou`, `ip`) VALUES
(85, 0, '', '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, ''),
(86, 0, '', '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, ''),
(152, 0, '', '', NULL, 0, NULL, 0, 1, NULL, 0, 0, 1, 1, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, ''),
(221, 0, '', '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, ''),
(322, 0, '', '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, ''),
(490, 0, '', '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, ''),
(633, 0, '', '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, ''),
(776, 0, '', '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, 1, -2, 0, ''),
(777, 0, '', '', NULL, 0, NULL, 0, 0, NULL, 0, 0, 1, 0, NULL, 0, '0001-01-01', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, 1, -1, -2, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_users_banned`
--

DROP TABLE IF EXISTS `#__kunena_users_banned`;
CREATE TABLE `#__kunena_users_banned` (
  `id` int(11) NOT NULL,
  `userid` int(11) DEFAULT NULL,
  `ip` varchar(128) DEFAULT NULL,
  `blocked` tinyint(4) NOT NULL DEFAULT '0',
  `expiration` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_time` datetime NOT NULL,
  `reason_private` text,
  `reason_public` text,
  `modified_by` int(11) DEFAULT NULL,
  `modified_time` datetime DEFAULT NULL,
  `comments` text,
  `params` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_user_categories`
--

DROP TABLE IF EXISTS `#__kunena_user_categories`;
CREATE TABLE `#__kunena_user_categories` (
  `user_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `role` tinyint(4) NOT NULL DEFAULT '0',
  `allreadtime` int(11) NOT NULL DEFAULT '0',
  `subscribed` tinyint(4) NOT NULL DEFAULT '0',
  `params` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_user_categories`
--

INSERT INTO `#__kunena_user_categories` (`user_id`, `category_id`, `role`, `allreadtime`, `subscribed`, `params`) VALUES
(221, 0, 0, 1487161568, 0, ''),
(776, 0, 0, 1517897750, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_user_read`
--

DROP TABLE IF EXISTS `#__kunena_user_read`;
CREATE TABLE `#__kunena_user_read` (
  `user_id` int(11) NOT NULL,
  `topic_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `message_id` int(11) NOT NULL,
  `time` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_user_read`
--

INSERT INTO `#__kunena_user_read` (`user_id`, `topic_id`, `category_id`, `message_id`, `time`) VALUES
(490, 1, 2, 1, 1452848074);

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_user_topics`
--

DROP TABLE IF EXISTS `#__kunena_user_topics`;
CREATE TABLE `#__kunena_user_topics` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `topic_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL,
  `posts` mediumint(8) NOT NULL DEFAULT '0',
  `last_post_id` int(11) NOT NULL DEFAULT '0',
  `owner` tinyint(4) NOT NULL DEFAULT '0',
  `favorite` tinyint(4) NOT NULL DEFAULT '0',
  `subscribed` tinyint(4) NOT NULL DEFAULT '0',
  `params` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_user_topics`
--

INSERT INTO `#__kunena_user_topics` (`user_id`, `topic_id`, `category_id`, `posts`, `last_post_id`, `owner`, `favorite`, `subscribed`, `params`) VALUES
(152, 1, 2, 1, 1, 1, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__kunena_version`
--

DROP TABLE IF EXISTS `#__kunena_version`;
CREATE TABLE `#__kunena_version` (
  `id` int(11) NOT NULL,
  `version` varchar(20) NOT NULL,
  `versiondate` date NOT NULL,
  `installdate` date NOT NULL,
  `build` varchar(20) NOT NULL,
  `versionname` varchar(40) DEFAULT NULL,
  `state` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__kunena_version`
--

INSERT INTO `#__kunena_version` (`id`, `version`, `versiondate`, `installdate`, `build`, `versionname`, `state`) VALUES
(1, '3.0.7', '2015-02-01', '2015-03-06', '', 'Galah', ''),
(2, '4.0.3', '2015-06-29', '2016-02-22', '', 'Possagno', ''),
(3, '5.0.13', '2017-12-31', '2018-02-20', '', 'Meerkat', ''),
(4, '5.0.14', '2018-03-14', '2018-03-29', '', 'Stephen Hawking', 'upgradeDatabase');

-- --------------------------------------------------------

--
-- Table structure for table `#__languages`
--

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE `#__languages` (
  `lang_id` int(11) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__languages`
--

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 1, 1),
(2, 309, 'ar-AA', 'Arabic Unitag (العربية الموحدة)', 'Arabic (اللغة العربية)', 'ar', 'ar_aa', '', '', '', '', 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu`
--

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__menu`
--

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 347, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 7, 16, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 8, 9, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 10, 11, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 12, 13, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 14, 15, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 147, 152, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 148, 149, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 150, 151, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 153, 156, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 154, 155, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 157, 162, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 158, 159, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 160, 161, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 169, 170, 0, '*', 1),
(17, 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 167, 168, 0, '*', 1),
(21, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 165, 166, 0, '*', 1),
(22, 'main', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 0, 'class:joomlaupdate', 0, '', 163, 164, 0, '*', 1),
(201, 'usermenu', 'Your Profile', 'your-profile', '', 'your-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 3, 4, 0, '*', 0),
(229, 'mainmenu', 'Single Contact', 'single-contact', '', 'joomla/contact-component/single-contact', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 270, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_tags\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 89, 90, 0, '*', 0),
(251, 'mainmenu', 'Contact Categories', 'contact-categories', '', 'joomla/contact-component/contact-categories', 'index.php?option=com_contact&view=categories&id=16', 'component', 1, 270, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 85, 86, 0, '*', 0),
(252, 'mainmenu', 'News Feed Categories', 'new-feed-categories', '', 'joomla/other-components/news-feeds-component/new-feed-categories', 'index.php?option=com_newsfeeds&view=categories&id=0', 'component', 1, 267, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_base_description\":\"\",\"categories_description\":\"\",\"maxLevelcat\":\"\",\"show_empty_categories_cat\":\"\",\"show_subcat_desc_cat\":\"\",\"show_cat_items_cat\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 106, 107, 0, '*', 0),
(253, 'mainmenu', 'News Feed Category', 'news-feed-category', '', 'joomla/other-components/news-feeds-component/news-feed-category', 'index.php?option=com_newsfeeds&view=category&id=17', 'component', 1, 267, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 110, 111, 0, '*', 0),
(254, 'mainmenu', 'Single News Feed', 'single-news-feed', '', 'joomla/other-components/news-feeds-component/single-news-feed', 'index.php?option=com_newsfeeds&view=newsfeed&id=4', 'component', 1, 267, 4, 17, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"show_tags\":\"\",\"feed_character_count\":\"0\",\"feed_display_order\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 108, 109, 0, '*', 0),
(255, 'mainmenu', 'Search', 'search', '', 'joomla/other-components/search', 'index.php?option=com_search&view=search', 'component', 1, 268, 3, 19, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"search_areas\":\"1\",\"show_date\":\"1\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 117, 118, 0, '*', 0),
(257, 'mainmenu', 'Single Article', 'single-article', '', 'joomla/content-component/single-article', 'index.php?option=com_content&view=article&id=73', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 73, 74, 0, '*', 0),
(259, 'mainmenu', 'Article Category Blog', 'article-category-blog', '', 'joomla/content-component/article-category-blog', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 75, 76, 0, '*', 0),
(260, 'mainmenu', 'Article Category List', 'article-category-list', '', 'joomla/content-component/article-category-list', 'index.php?option=com_content&view=category&id=19', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"alpha\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 77, 78, 0, '*', 0),
(262, 'mainmenu', 'Featured Articles', 'featured-articles', '', 'joomla/content-component/featured-articles', 'index.php?option=com_content&view=featured', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 79, 80, 0, '*', 0),
(263, 'mainmenu', 'Submit Article', 'submit-article', '', 'joomla/content-component/submit-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 266, 3, 22, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{\"enable_category\":\"0\",\"catid\":\"19\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 81, 82, 0, '*', 0),
(266, 'mainmenu', 'Content Component', 'content-component', '', 'joomla/content-component', '#', 'url', 1, 280, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 72, 83, 0, '*', 0),
(267, 'mainmenu', 'News Feeds Component', 'news-feeds-component', '', 'joomla/other-components/news-feeds-component', 'index.php?option=com_content&view=article&id=60', 'component', 1, 268, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Newsfeeds Categories View \",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 105, 112, 0, '*', 0),
(268, 'mainmenu', 'Other Components', 'other-components', '', 'joomla/other-components', '#', 'url', 1, 280, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 104, 119, 0, '*', 0),
(270, 'mainmenu', 'Contact Component', 'contact-component', '', 'joomla/contact-component', '#', 'url', 1, 280, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 84, 93, 0, '*', 0),
(271, 'mainmenu', 'Users Component', 'users-component', '', 'joomla/users-component', '#', 'url', 1, 280, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 94, 103, 0, '*', 0),
(275, 'mainmenu', 'Contact Single Category', 'contact-single-category', '', 'joomla/contact-component/contact-single-category', 'index.php?option=com_contact&view=category&catid=26&id=36', 'component', 1, 270, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"initial_sort\":\"\",\"presentation_style\":\"sliders\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 87, 88, 0, '*', 0),
(276, 'mainmenu', 'Search Components', 'search-component', '', 'joomla/other-components/search-component', 'index.php?option=com_content&view=article&id=39', 'component', 1, 268, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"left\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 113, 114, 0, '*', 0),
(278, 'mainmenu', 'Blog', 'blog', '', 'blog', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"278\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 123, 146, 0, '*', 0),
(279, 'mainmenu', 'Pages', 'pages', '', 'pages', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 49, 70, 0, '*', 0),
(280, 'mainmenu', 'Joomla!', 'joomla', '', 'joomla', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":800,\\\"menuItem\\\":4,\\\"menuAlign\\\":\\\"full\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"266\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"270\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"271\\\",\\\"moduleId\\\":\\\"\\\"},{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":3,\\\"menuParentId\\\":\\\"268\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"1\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 71, 120, 0, '*', 0),
(402, 'mainmenu', 'Login Form', 'login-form', '', 'joomla/users-component/login-form', 'index.php?option=com_users&view=login', 'component', 1, 271, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 95, 96, 0, '*', 0),
(403, 'mainmenu', 'User Profile', 'user-profile', '', 'joomla/users-component/user-profile', 'index.php?option=com_users&view=profile', 'component', 1, 271, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 97, 98, 0, '*', 0),
(404, 'mainmenu', 'Edit User Profile', 'edit-user-profile', '', 'joomla/users-component/edit-user-profile', 'index.php?option=com_users&view=profile&layout=edit', 'component', 1, 271, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 99, 100, 0, '*', 0),
(405, 'mainmenu', 'Registration Form', 'registration-form', '', 'joomla/users-component/registration-form', 'index.php?option=com_users&view=registration', 'component', 1, 271, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 101, 102, 0, '*', 0),
(437, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_sppagebuilder&view=page&id=1', 'component', 1, 1, 1, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":900,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"437\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 17, 24, 1, '*', 0),
(449, 'usermenu', 'Submit an Article', 'submit-an-article', '', 'submit-an-article', 'index.php?option=com_content&view=form&layout=edit', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 5, 6, 0, '*', 0),
(452, 'mainmenu', 'Featured Contacts', 'featured-contacts', '', 'joomla/contact-component/featured-contacts', 'index.php?option=com_contact&view=featured&id=16', 'component', 1, 270, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_position_headings\":\"\",\"show_email_headings\":\"\",\"show_telephone_headings\":\"\",\"show_mobile_headings\":\"\",\"show_fax_headings\":\"\",\"show_suburb_headings\":\"\",\"show_state_headings\":\"\",\"show_country_headings\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"presentation_style\":\"sliders\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"1\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 91, 92, 0, '*', 0),
(466, 'mainmenu', 'Smart Search', 'smart-search', '', 'joomla/other-components/smart-search', 'index.php?option=com_finder&view=search', 'component', 1, 268, 3, 27, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_date_filters\":\"\",\"show_advanced\":\"\",\"expand_advanced\":\"\",\"show_description\":\"\",\"description_length\":255,\"show_url\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"allow_empty_query\":\"0\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"sort_order\":\"\",\"sort_direction\":\"\",\"show_feed\":\"0\",\"show_feed_text\":\"0\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 115, 116, 0, '*', 0),
(471, 'main', 'com_tags', 'com-tags', '', 'com-tags', 'index.php?option=com_tags', 'component', 1, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 171, 172, 0, '', 1),
(472, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 1, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 173, 174, 0, '*', 1),
(487, 'mainmenu', 'Coming Soon', '2015-02-02-15-01-12', '', 'pages/2015-02-02-15-01-12', '?tmpl=comingsoon', 'url', 1, 279, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"487\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 66, 67, 0, '*', 0),
(488, 'mainmenu', '404 Page', '2015-02-02-15-05-34', '', 'pages/2015-02-02-15-05-34', 'index.php?option=com_404', 'url', 1, 279, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 68, 69, 0, '*', 0),
(489, 'mainmenu', 'Header Transparent', 'header-transparent', '', 'home/header-transparent', 'index.php?option=com_sppagebuilder&view=page&id=14', 'component', 1, 437, 2, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 12, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 22, 23, 0, '*', 0),
(492, 'mainmenu', 'Blog With Right Sidebar', 'blog-with-right-sidebar', '', 'blog/blog-with-right-sidebar', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', 1, 278, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 124, 125, 0, '*', 0),
(494, 'mainmenu', 'Standard Post Format', 'standard-post-format', '', 'blog/post-formats/standard-post-format', 'index.php?option=com_content&view=article&id=73', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 129, 130, 0, '*', 0),
(495, 'mainmenu', 'Video Post Format', 'video-post-format', '', 'blog/post-formats/video-post-format', 'index.php?option=com_content&view=article&id=72', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 131, 132, 0, '*', 0),
(496, 'mainmenu', 'Gallery Post Format', 'gallery-post-format', '', 'blog/post-formats/gallery-post-format', 'index.php?option=com_content&view=article&id=74', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 135, 136, 0, '*', 0),
(497, 'mainmenu', 'Audio Post Format', 'audio-post-format', '', 'blog/post-formats/audio-post-format', 'index.php?option=com_content&view=article&id=75', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 133, 134, 0, '*', 0),
(498, 'mainmenu', 'Image Post Format', 'image-post-format', '', 'blog/post-formats/image-post-format', 'index.php?option=com_content&view=article&id=73', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 143, 144, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(499, 'mainmenu', 'Link Post Format', 'link-post-format', '', 'blog/post-formats/link-post-format', 'index.php?option=com_content&view=article&id=76', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 137, 138, 0, '*', 0),
(500, 'mainmenu', 'Status Post Format', 'status-post-format', '', 'blog/post-formats/status-post-format', 'index.php?option=com_content&view=article&id=71', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 141, 142, 0, '*', 0),
(501, 'mainmenu', 'Quote Post Format', 'quote-post-format', '', 'blog/post-formats/quote-post-format', 'index.php?option=com_content&view=article&id=77', 'component', 1, 503, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 139, 140, 0, '*', 0),
(502, 'mainmenu', 'Portfolio', 'portfolio-2', '', 'pages/portfolio-2', 'index.php?option=com_spsimpleportfolio&view=items', 'component', 1, 279, 2, 10007, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"show_filter\":\"1\",\"layout_type\":\"default\",\"columns\":\"4\",\"thumbnail_type\":\"rectangular\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 64, 65, 0, '*', 0),
(503, 'mainmenu', 'Post Formats', 'post-formats', '', 'blog/post-formats', '#', 'url', 1, 278, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"503\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 128, 145, 0, '*', 0),
(504, 'mainmenu', 'Article Category Blog', 'article-category-blog-2', '', 'blog/article-category-blog-2', 'index.php?option=com_content&view=category&layout=blog&id=79', 'component', 1, 278, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"layout_type\":\"blog\",\"show_category_heading_title_text\":\"\",\"show_category_title\":\"\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_featured\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 126, 127, 0, '*', 0),
(518, 'higher-education', 'Master Of Taxation', '2015-02-06-09-32-09', '', '2015-02-06-09-32-09', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"518\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 175, 176, 0, '*', 0),
(519, 'higher-education', 'Student Life', '2015-02-06-09-32-28', '', '2015-02-06-09-32-28', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 177, 178, 0, '*', 0),
(520, 'higher-education', 'Campus Services', '2015-02-06-09-32-52', '', '2015-02-06-09-32-52', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 179, 180, 0, '*', 0),
(521, 'higher-education', 'By School', '2015-02-06-09-33-09', '', '2015-02-06-09-33-09', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 181, 182, 0, '*', 0),
(522, 'higher-education', 'Process', '2015-02-06-09-33-25', '', '2015-02-06-09-33-25', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 183, 184, 0, '*', 0),
(523, 'higher-education', 'Visitor Information', '2015-02-06-09-33-45', '', '2015-02-06-09-33-45', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 185, 186, 0, '*', 0),
(524, 'higher-education', 'For Prospective Parents', '2015-02-06-09-34-04', '', '2015-02-06-09-34-04', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 187, 188, 0, '*', 0),
(525, 'about-university', 'History & Mission', '2015-02-06-09-35-16', '', '2015-02-06-09-35-16', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"525\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 189, 190, 0, 'en-GB', 0),
(526, 'about-university', 'Community', '2015-02-06-09-35-33', '', '2015-02-06-09-35-33', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 191, 192, 0, '*', 0),
(527, 'about-university', 'Notable Facts & Statistics', '2015-02-06-09-35-51', '', '2015-02-06-09-35-51', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 193, 194, 0, '*', 0),
(528, 'about-university', 'Social Media', '2015-02-06-09-36-25', '', '2015-02-06-09-36-25', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 195, 196, 0, '*', 0),
(529, 'about-university', 'Our Campuses', '2015-02-06-09-36-52', '', '2015-02-06-09-36-52', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 197, 198, 0, '*', 0),
(530, 'about-university', 'Campus Directories', '2015-02-06-09-37-24', '', '2015-02-06-09-37-24', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 199, 200, 0, '*', 0),
(531, 'about-university', 'Employment', '2015-02-06-09-38-00', '', '2015-02-06-09-38-00', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 201, 202, 0, '*', 0),
(532, 'admissions', 'Undergraduate', '2015-02-06-09-40-31', '', '2015-02-06-09-40-31', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 203, 204, 0, '*', 0),
(533, 'admissions', 'Student Life', '2015-02-06-09-40-51', '', '2015-02-06-09-40-51', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 205, 206, 0, '*', 0),
(534, 'admissions', 'Campus Services', '2015-02-06-09-41-10', '', '2015-02-06-09-41-10', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 207, 208, 0, '*', 0),
(535, 'admissions', 'By School', '2015-02-06-09-41-25', '', '2015-02-06-09-41-25', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 209, 210, 0, '*', 0),
(536, 'admissions', 'Process', '2015-02-06-09-41-39', '', '2015-02-06-09-41-39', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 211, 212, 0, '*', 0),
(537, 'admissions', 'Visitor Information', '2015-02-06-09-42-00', '', '2015-02-06-09-42-00', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 213, 214, 0, '*', 0),
(538, 'admissions', 'For Prospective Parents', '2015-02-06-09-42-17', '', '2015-02-06-09-42-17', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 215, 216, 0, '*', 0),
(539, 'quick-link', 'Home', '2015-02-06-09-43-45', '', '2015-02-06-09-43-45', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 217, 218, 0, '*', 0),
(540, 'quick-link', 'Events', '2015-02-06-09-44-01', '', '2015-02-06-09-44-01', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 219, 220, 0, '*', 0),
(541, 'quick-link', 'Blog', '2015-02-06-09-44-16', '', '2015-02-06-09-44-16', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 221, 222, 0, '*', 0),
(542, 'quick-link', 'Courses', '2015-02-06-09-44-29', '', '2015-02-06-09-44-29', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 223, 224, 0, '*', 0),
(543, 'quick-link', 'FAQ', '2015-02-06-09-44-44', '', '2015-02-06-09-44-44', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 225, 226, 0, '*', 0),
(544, 'quick-link', 'Career ', '2015-02-06-09-44-59', '', '2015-02-06-09-44-59', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 227, 228, 0, '*', 0),
(545, 'quick-link', 'Research', '2015-02-06-09-45-13', '', '2015-02-06-09-45-13', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 229, 230, 0, '*', 0),
(546, 'mainmenu', 'Contact-1', 'contact-1', '', 'pages/2015-02-16-05-13-27/contact-1', 'index.php?option=com_sppagebuilder&view=page&id=7', 'component', 1, 556, 3, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 57, 58, 0, '*', 0),
(547, 'mainmenu', 'Contact-2', 'contact-2', '', 'pages/2015-02-16-05-13-27/contact-2', 'index.php?option=com_sppagebuilder&view=page&id=8', 'component', 1, 556, 3, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 59, 60, 0, '*', 0),
(548, 'mainmenu', 'Contact-3', 'contact-3', '', 'pages/2015-02-16-05-13-27/contact-3', 'index.php?option=com_sppagebuilder&view=page&id=9', 'component', 1, 556, 3, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 61, 62, 0, '*', 0),
(551, 'mainmenu', 'Courses', 'courses', '', 'lms/courses', 'index.php?option=com_splms&view=courses', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"readmore_text\":\"Course Details\",\"hide_pagination\":\"0\",\"columns\":\"2\",\"limit\":\"6\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 28, 29, 0, '*', 0),
(553, 'mainmenu', 'About Basic', 'about-us', '', 'pages/about/about-us', 'index.php?option=com_sppagebuilder&view=page&id=11', 'component', 1, 557, 3, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 51, 52, 0, '*', 0),
(554, 'mainmenu', 'About Extended', 'about-us-2', '', 'pages/about/about-us-2', 'index.php?option=com_sppagebuilder&view=page&id=12', 'component', 1, 557, 3, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 53, 54, 0, '*', 0),
(556, 'mainmenu', 'Contact', '2015-02-16-05-13-27', '', 'pages/2015-02-16-05-13-27', '#', 'url', 1, 279, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 56, 63, 0, '*', 0),
(557, 'mainmenu', 'About', 'about', '', 'pages/about', '#', 'url', 1, 279, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 50, 55, 0, '*', 0),
(559, 'mainmenu', 'Events', 'events', '', 'lms/events', 'index.php?option=com_splms&view=events', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"intro_limit\":\"120\",\"show_readmore\":\"0\",\"readmore_text\":\"Details\",\"limit\":\"6\",\"hide_pagination\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 34, 35, 0, '*', 0),
(560, 'mainmenu', 'LMS', 'lms', '', 'lms', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"560\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 25, 48, 0, '*', 0),
(561, 'mainmenu', 'Teachers', 'teachers', '', 'lms/teachers', 'index.php?option=com_splms&view=teachers', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"hide_pagination\":\"0\",\"columns\":\"3\",\"limit\":\"6\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 30, 31, 0, '*', 0),
(562, 'mainmenu', 'Event Categories', 'event-categories', '', 'lms/event-categories', 'index.php?option=com_splms&view=eventcategories', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"hide_pagination\":\"1\",\"columns\":\"2\",\"limit\":\"6\",\"intro_limit\":\"120\",\"show_readmore\":\"0\",\"readmore_text\":\"Details\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 32, 33, 0, '*', 0),
(563, 'mainmenu', 'Courses Categories', 'courses-category', '', 'lms/courses-category', 'index.php?option=com_splms&view=coursescategories', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"limit\":\"16\",\"columns\":\"4\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 26, 27, 0, '*', 0),
(564, 'mainmenu', 'University', 'university', '', 'home/university', 'index.php?option=com_sppagebuilder&view=page&id=10', 'component', 1, 437, 2, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.jpg\"}', 18, 19, 0, '*', 0),
(565, 'mainmenu', 'University & LMS', 'home-3', '', 'home/home-3', 'index.php?option=com_sppagebuilder&view=page&id=13', 'component', 1, 437, 2, 10042, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.jpg\"}', 20, 21, 0, '*', 0),
(566, 'mainmenu', 'Speakers', 'speakers', '', 'lms/speakers', 'index.php?option=com_splms&view=speakers', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"hide_pagination\":\"0\",\"columns\":\"2\",\"limit\":\"6\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 36, 37, 0, '*', 0),
(579, 'kunenamenu', 'Forum', 'forum', '', 'forum', 'index.php?option=com_kunena&view=home&defaultmenu=581', 'component', 1, 1, 1, 10074, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"catids\":0}', 231, 248, 0, '*', 0),
(580, 'kunenamenu', 'Index', 'index', '', 'forum/index', 'index.php?option=com_kunena&view=category&layout=list', 'component', 1, 579, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 232, 233, 0, '*', 0),
(581, 'kunenamenu', 'Recent Topics', 'recent', '', 'forum/recent', 'index.php?option=com_kunena&view=topics&mode=replies', 'component', 1, 579, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"topics_catselection\":\"\",\"topics_categories\":\"\",\"topics_time\":720}', 234, 235, 0, '*', 0),
(582, 'kunenamenu', 'New Topic', 'newtopic', '', 'forum/newtopic', 'index.php?option=com_kunena&view=topic&layout=create', 'component', 1, 579, 2, 10074, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 236, 237, 0, '*', 0),
(583, 'kunenamenu', 'No Replies', 'noreplies', '', 'forum/noreplies', 'index.php?option=com_kunena&view=topics&mode=noreplies', 'component', 1, 579, 2, 10074, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"topics_catselection\":\"\",\"topics_categories\":\"\",\"topics_time\":-1}', 238, 239, 0, '*', 0),
(584, 'kunenamenu', 'My Topics', 'mylatest', '', 'forum/mylatest', 'index.php?option=com_kunena&view=topics&layout=user&mode=default', 'component', 1, 579, 2, 10074, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"topics_catselection\":\"2\",\"topics_categories\":\"0\",\"topics_time\":-1}', 240, 241, 0, '*', 0),
(585, 'kunenamenu', 'Profile', 'profile', '', 'forum/profile', 'index.php?option=com_kunena&view=user', 'component', 1, 579, 2, 10074, 0, '0000-00-00 00:00:00', 0, 2, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"integration\":1}', 242, 243, 0, '*', 0),
(586, 'kunenamenu', 'Help', 'help', '', 'forum/help', 'index.php?option=com_kunena&view=misc', 'component', 1, 579, 2, 10074, 0, '0000-00-00 00:00:00', 0, 3, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"body\":\"This help page is a menu item inside [b]Kunena Menu[\\/b], which allows easy navigation in your forum. \\n\\n You can use Joomla Menu Manager to edit items in this menu. Please go to [b]Administration[\\/b] >> [b]Menus[\\/b] >> [b]Kunena Menu[\\/b] >> [b]Help[\\/b] to edit or remove this menu item. \\n\\n In this menu item you can use Plain Text, BBCode or HTML. If you want to bind article into this page, you may use article BBCode (with article id): [code][article=full]123[\\/article][\\/code] \\n\\n If you want to create your own menu for Kunena, please start by creating [b]Home Page[\\/b] first. In that page you can select default menu item, which is shown when you enter to Kunena.\",\"body_format\":\"bbcode\"}', 244, 245, 0, '*', 0),
(587, 'kunenamenu', 'Search', 'search', '', 'forum/search', 'index.php?option=com_kunena&view=search', 'component', 1, 579, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 246, 247, 0, '*', 0),
(589, 'mainmenu', 'Kunena', 'kunena', '', 'kunena', 'index.php?option=com_kunena&view=home&defaultmenu=589', 'component', 1, 1, 1, 10074, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"589\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 121, 122, 0, '*', 0),
(592, 'mainmenu', 'Cart', 'cart', '', 'lms/cart', 'index.php?option=com_splms&view=cart', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 38, 39, 0, '*', 0),
(593, 'mainmenu', 'Purchases, Results & Certificate', 'purchases', '', 'lms/purchases', 'index.php?option=com_splms&view=purchases', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 40, 41, 0, '*', 0),
(600, 'usermenu', 'Purchase List', 'purchase-list', '', 'purchase-list', 'index.php?option=com_splms&view=purchases', 'component', 1, 1, 1, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"600\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.jpg\"}', 1, 2, 0, '*', 0),
(604, 'jomsocial', 'Profile', 'profile', '', 'profile', 'index.php?option=com_community&view=profile', 'component', 1, 1, 1, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 249, 266, 0, '*', 0),
(605, 'jomsocial', 'Change Profile Picture', 'change-profile-picture', '', 'profile/change-profile-picture', 'index.php?option=com_community&view=profile&task=uploadAvatar', 'component', 1, 604, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 250, 251, 0, '*', 0),
(606, 'jomsocial', 'Change Profile Video', 'change-profile-video', '', 'profile/change-profile-video', 'index.php?option=com_community&view=profile&task=linkVideo', 'component', 1, 604, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 252, 253, 0, '*', 0),
(607, 'jomsocial', 'Edit Profile', 'edit-profile', '', 'profile/edit-profile', 'index.php?option=com_community&view=profile&task=edit', 'component', 1, 604, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 254, 255, 0, '*', 0),
(608, 'jomsocial', 'Edit Details', 'edit-details', '', 'profile/edit-details', 'index.php?option=com_community&view=profile&task=editDetails', 'component', 1, 604, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 256, 257, 0, '*', 0),
(609, 'jomsocial', 'Privacy', 'privacy', '', 'profile/privacy', 'index.php?option=com_community&view=profile&task=privacy', 'component', 1, 604, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 258, 259, 0, '*', 0),
(610, 'jomsocial', 'Preferences', 'preferences', '', 'profile/preferences', 'index.php?option=com_community&view=profile&task=preferences', 'component', 1, 604, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 260, 261, 0, '*', 0),
(611, 'jomsocial', 'Customize My Page', 'customize-my-page', '', 'profile/customize-my-page', 'index.php?option=com_community&view=profile&task=editPage', 'component', 1, 604, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 262, 263, 0, '*', 0),
(612, 'jomsocial', 'Notifications', 'notifications', '', 'profile/notifications', 'index.php?option=com_community&view=profile&task=notifications', 'component', 1, 604, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 264, 265, 0, '*', 0),
(613, 'jomsocial', 'Members', 'members', '', 'members', 'index.php?option=com_community&view=search&task=browse', 'component', 1, 1, 1, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 267, 274, 0, '*', 0),
(614, 'jomsocial', 'All Members', 'all-members', '', 'members/all-members', 'index.php?option=com_community&view=search&task=browse', 'component', 1, 613, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 268, 269, 0, '*', 0),
(615, 'jomsocial', 'Search', 'search', '', 'members/search', 'index.php?option=com_community&view=search', 'component', 1, 613, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 270, 271, 0, '*', 0),
(616, 'jomsocial', 'Advanced Search', 'advanced-search', '', 'members/advanced-search', 'index.php?option=com_community&view=search&task=advancesearch', 'component', 1, 613, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 272, 273, 0, '*', 0),
(617, 'jomsocial', 'Friends', 'friends', '', 'friends', 'index.php?option=com_community&view=friends', 'component', 1, 1, 1, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 275, 282, 0, '*', 0),
(618, 'jomsocial', 'All Friends', 'all-friends', '', 'friends/all-friends', 'index.php?option=com_community&view=friends', 'component', 1, 617, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 276, 277, 0, '*', 0),
(619, 'jomsocial', 'Request Sent', 'request-sent', '', 'friends/request-sent', 'index.php?option=com_community&view=friends&task=sent', 'component', 1, 617, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 278, 279, 0, '*', 0),
(620, 'jomsocial', 'Pending my approval', 'pending-my-approval', '', 'friends/pending-my-approval', 'index.php?option=com_community&view=friends&task=pending', 'component', 1, 617, 2, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 280, 281, 0, '*', 0),
(621, 'jomsocial', 'Groups', 'groups', '', 'groups', 'index.php?option=com_community&view=groups&task=display', 'component', 1, 1, 1, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 283, 284, 0, '*', 0),
(622, 'jomsocial', 'Photos', 'photos', '', 'photos', 'index.php?option=com_community&view=photos&task=display', 'component', 1, 1, 1, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 285, 286, 0, '*', 0),
(623, 'jomsocial', 'Videos', 'videos', '', 'videos', 'index.php?option=com_community&view=videos&task=display', 'component', 1, 1, 1, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 287, 288, 0, '*', 0),
(624, 'jomsocial', 'Events', 'events', '', 'events', 'index.php?option=com_community&view=events&task=display', 'component', 1, 1, 1, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 289, 290, 0, '*', 0),
(625, 'jomsocial', 'Inbox', 'inbox', '', 'inbox', 'index.php?option=com_community&view=inbox', 'component', 1, 1, 1, 10087, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '', 291, 292, 0, '*', 0),
(648, 'mainmenu', 'Quiz', 'quiz', '', 'lms/quiz', 'index.php?option=com_splms&view=quizquestions', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"hide_pagination\":\"0\",\"columns\":\"3\",\"limit\":\"12\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 42, 43, 0, '*', 0),
(649, 'mainmenu', 'Certificate', 'certificate', '', 'lms/certificate', 'index.php?option=com_splms&view=certificate&id=1', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 44, 45, 0, '*', 0),
(650, 'mainmenu', 'Single Course', 'single-course', '', 'lms/single-course', 'index.php?option=com_splms&view=course&id=2', 'component', 1, 560, 2, 10086, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"dropdown_position\":\"right\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"1\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"images\\/demo\\/about-subheader.png\"}', 46, 47, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(670, 'usermenu', 'Cart', 'cart', '', 'cart', 'index.php?option=com_splms&view=cart', 'component', 1, 1, 1, 10086, 0, '0000-00-00 00:00:00', 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"menulayout\":\"{\\\"width\\\":600,\\\"menuItem\\\":1,\\\"menuAlign\\\":\\\"right\\\",\\\"layout\\\":[{\\\"type\\\":\\\"row\\\",\\\"attr\\\":[{\\\"type\\\":\\\"column\\\",\\\"colGrid\\\":12,\\\"menuParentId\\\":\\\"670\\\",\\\"moduleId\\\":\\\"\\\"}]}]}\",\"megamenu\":\"0\",\"showmenutitle\":\"1\",\"icon\":\"\",\"class\":\"\",\"enable_page_title\":\"0\",\"page_title_alt\":\"\",\"page_subtitle\":\"\",\"page_title_bg_color\":\"\",\"page_title_bg_image\":\"\"}', 293, 294, 0, '*', 0),
(678, 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 1, 'class:associations', 0, '{}', 295, 296, 0, '*', 1),
(702, 'main', 'COM_SPSIMPLEPORTFOLIO', 'com-spsimpleportfolio', '', 'com-spsimpleportfolio', 'index.php?option=com_spsimpleportfolio', 'component', 1, 1, 1, 10007, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 297, 298, 0, '', 1),
(718, 'main', 'AcyMailing', 'acymailing', '', 'acymailing', 'index.php?option=com_acymailing', 'component', 1, 1, 1, 10013, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acymailing.png', 0, '{}', 299, 314, 0, '', 1),
(719, 'main', 'Users', 'users', '', 'acymailing/users', 'index.php?option=com_acymailing&ctrl=subscriber', 'component', 1, 718, 2, 10013, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-users.png', 0, '{}', 300, 301, 0, '', 1),
(720, 'main', 'Lists', 'lists', '', 'acymailing/lists', 'index.php?option=com_acymailing&ctrl=list', 'component', 1, 718, 2, 10013, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acylist.png', 0, '{}', 302, 303, 0, '', 1),
(721, 'main', 'Newsletters', 'newsletters', '', 'acymailing/newsletters', 'index.php?option=com_acymailing&ctrl=newsletter', 'component', 1, 718, 2, 10013, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-newsletter.png', 0, '{}', 304, 305, 0, '', 1),
(722, 'main', 'Templates', 'templates', '', 'acymailing/templates', 'index.php?option=com_acymailing&ctrl=template', 'component', 1, 718, 2, 10013, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acytemplate.png', 0, '{}', 306, 307, 0, '', 1),
(723, 'main', 'Queue', 'queue', '', 'acymailing/queue', 'index.php?option=com_acymailing&ctrl=queue', 'component', 1, 718, 2, 10013, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-process.png', 0, '{}', 308, 309, 0, '', 1),
(724, 'main', 'Statistics', 'statistics', '', 'acymailing/statistics', 'index.php?option=com_acymailing&ctrl=stats', 'component', 1, 718, 2, 10013, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-stats.png', 0, '{}', 310, 311, 0, '', 1),
(725, 'main', 'Configuration', 'configuration', '', 'acymailing/configuration', 'index.php?option=com_acymailing&ctrl=cpanel', 'component', 1, 718, 2, 10013, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acyconfig.png', 0, '{}', 312, 313, 0, '', 1),
(726, 'main', 'COM_KUNENA', 'com-kunena', '', 'com-kunena', 'index.php?option=com_kunena', 'component', 1, 1, 1, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_kunena/media/icons/favicons/kunena-logo-white.png', 0, '{}', 315, 342, 0, '', 1),
(727, 'main', 'COM_KUNENA_DASHBOARD', 'com-kunena-dashboard', '', 'com-kunena/com-kunena-dashboard', 'index.php?option=com_kunena&view=cpanel', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 316, 317, 0, '', 1),
(728, 'main', 'COM_KUNENA_CATEGORY_MANAGER', 'com-kunena-category-manager', '', 'com-kunena/com-kunena-category-manager', 'index.php?option=com_kunena&view=categories', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 318, 319, 0, '', 1),
(729, 'main', 'COM_KUNENA_USER_MANAGER', 'com-kunena-user-manager', '', 'com-kunena/com-kunena-user-manager', 'index.php?option=com_kunena&view=users', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 320, 321, 0, '', 1),
(730, 'main', 'COM_KUNENA_FILE_MANAGER', 'com-kunena-file-manager', '', 'com-kunena/com-kunena-file-manager', 'index.php?option=com_kunena&view=attachments', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 322, 323, 0, '', 1),
(731, 'main', 'COM_KUNENA_EMOTICON_MANAGER', 'com-kunena-emoticon-manager', '', 'com-kunena/com-kunena-emoticon-manager', 'index.php?option=com_kunena&view=smilies', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 324, 325, 0, '', 1),
(732, 'main', 'COM_KUNENA_RANK_MANAGER', 'com-kunena-rank-manager', '', 'com-kunena/com-kunena-rank-manager', 'index.php?option=com_kunena&view=ranks', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 326, 327, 0, '', 1),
(733, 'main', 'COM_KUNENA_TEMPLATE_MANAGER', 'com-kunena-template-manager', '', 'com-kunena/com-kunena-template-manager', 'index.php?option=com_kunena&view=templates', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 328, 329, 0, '', 1),
(734, 'main', 'COM_KUNENA_CONFIGURATION', 'com-kunena-configuration', '', 'com-kunena/com-kunena-configuration', 'index.php?option=com_kunena&view=config', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 330, 331, 0, '', 1),
(735, 'main', 'COM_KUNENA_PLUGIN_MANAGER', 'com-kunena-plugin-manager', '', 'com-kunena/com-kunena-plugin-manager', 'index.php?option=com_kunena&view=plugins', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 332, 333, 0, '', 1),
(736, 'main', 'COM_KUNENA_LOG_MANAGER', 'com-kunena-log-manager', '', 'com-kunena/com-kunena-log-manager', 'index.php?option=com_kunena&view=logs', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 334, 335, 0, '', 1),
(737, 'main', 'COM_KUNENA_MENU_STATISTICS', 'com-kunena-menu-statistics', '', 'com-kunena/com-kunena-menu-statistics', 'index.php?option=com_kunena&view=statistics', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 336, 337, 0, '', 1),
(738, 'main', 'COM_KUNENA_FORUM_TOOLS', 'com-kunena-forum-tools', '', 'com-kunena/com-kunena-forum-tools', 'index.php?option=com_kunena&view=tools', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 338, 339, 0, '', 1),
(739, 'main', 'COM_KUNENA_TRASH_MANAGER', 'com-kunena-trash-manager', '', 'com-kunena/com-kunena-trash-manager', 'index.php?option=com_kunena&view=trash', 'component', 1, 726, 2, 10074, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 340, 341, 0, '', 1),
(740, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder', 'component', 1, 1, 1, 10042, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 343, 344, 0, '', 1),
(743, 'main', 'COM_SPLMS', 'com-splms', '', 'com-splms', 'index.php?option=com_splms', 'component', 1, 1, 1, 10086, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 345, 346, 0, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__menu_types`
--

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
  `id` int(10) UNSIGNED NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(2, 0, 'usermenu', 'User Menu', 'A Menu for logged-in Users', 0),
(4, 0, 'mainmenu', 'Main Menu', 'Main Menu', 0),
(10, 0, 'higher-education', 'Higher Education', '', 0),
(11, 0, 'about-university', 'About University', '', 0),
(12, 0, 'admissions', 'Admissions', '', 0),
(14, 0, 'quick-link', 'Quick Link', '', 0),
(15, 0, 'kunenamenu', 'Kunena Menu', 'This is the default Kunena menu. It is used as the top navigation for Kunena. It can be publish in any module position. Simply unpublish items that are not required.', 0),
(16, 0, 'jomsocial', 'JomSocial toolbar', 'Toolbar items for JomSocial toolbar', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__messages`
--

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE `#__messages` (
  `message_id` int(10) UNSIGNED NOT NULL,
  `user_id_from` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `user_id_to` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__messages_cfg`
--

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__modules`
--

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__modules`
--

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(17, 185, 'Breadcrumbs', '', '', 1, 'breadcrumb', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{\"showHere\":\"1\",\"showHome\":\"1\",\"homeText\":\"\",\"showLast\":\"1\",\"separator\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(35, 186, 'Search', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(79, 0, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(95, 188, 'Recent Post', '', '', 1, 'bottom3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{\"catid\":[\"\"],\"count\":\"7\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" recent-post\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(98, 202, 'Portfolio Module', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 1, '{\"show_filter\":\"0\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"4\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(99, 203, 'Popular News', '', '', 2, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{\"catid\":[\"79\"],\"count\":\"6\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" popular-news\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(100, 204, 'Search', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 0, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" right-sidebar-search\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(102, 206, 'Search', '', '', 1, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{\"label\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"0\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"opensearch\":\"1\",\"opensearch_title\":\"\",\"set_itemid\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(103, 207, 'Latest News', '', '', 2, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_latest', 1, 1, '{\"catid\":[\"79\"],\"count\":\"6\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(105, 209, 'Off Canvas Menu', '', '', 1, 'offcanvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"mainmenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(107, 211, 'Portfolio Module -  Portfolio Home', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_spsimpleportfolio', 1, 1, '{\"show_filter\":\"1\",\"layout_type\":\"gallery_nospace\",\"columns\":\"4\",\"thumbnail_type\":\"square\",\"limit\":\"12\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(110, 216, 'AcyMailing Module', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 0, '{\"effect\":\"normal\",\"lists\":\"None\",\"hiddenlists\":\"All\",\"displaymode\":\"tableless\",\"listschecked\":\"All\",\"checkmode\":\"0\",\"dropdown\":\"0\",\"overlay\":\"0\",\"link\":\"0\",\"listposition\":\"before\",\"customfields\":\"email\",\"nametext\":\"\",\"emailtext\":\"\",\"fieldsize\":\"100%\",\"displayfields\":\"0\",\"introtext\":\"Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus.\",\"finaltext\":\"\",\"showsubscribe\":\"1\",\"subscribetext\":\"\",\"subscribetextreg\":\"\",\"showunsubscribe\":\"0\",\"unsubscribetext\":\"\",\"redirectmode\":\"0\",\"redirectlink\":\"\",\"redirectlinkunsub\":\"\",\"showterms\":\"0\",\"showtermspopup\":\"0\",\"termscontent\":\"0\",\"mootoolsintro\":\"\",\"mootoolsbutton\":\"\",\"boxwidth\":\"250\",\"boxheight\":\"200\",\"moduleclass_sfx\":\"\",\"textalign\":\"none\",\"loggedin\":\"1\",\"cache\":\"0\",\"includejs\":\"header\",\"itemid\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(112, 217, 'Higher Education', '', '', 1, 'bottom1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"higher-education\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\" higher-education\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(113, 218, 'About University', '', '', 1, 'bottom2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"about-university\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\" about-university\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(115, 220, 'Admissions', '', '', 1, 'bottom5', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"admissions\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\" admissions\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(116, 221, 'Contact Us', '', '<p>University 2</p>\r\n<p>1234 South Lipsum Avenue</p>\r\n<p>United States , 123456</p>\r\n<p><strong>Email</strong>: <a href=\"mailto:info@university2.com\">info@university2.com </a></p>\r\n<p><strong>Fax</strong>: +013 036 0259</p>\r\n<p><strong>Webiste</strong>: <a href=\"#\">www.website.com</a></p>', 1, 'bottom6', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(117, 222, 'Quick Link', '', '', 1, 'bottom7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"quick-link\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\" quick-link\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(118, 223, 'Bottom-8', '', '<p><img src=\"images/demo/logo.png\" alt=\"\" /></p>\r\n<p>SP LMS is <span class=\"st\"> the most popular <em>eLearning </em>platform for Joomla 3.4</span>. It allows the online delivery of training, optimizing time and reducing costs associated with traditional learning methods. Join CMS ecosystem of features and modules to extend your LMS.</p>\r\n<div class=\"bottom-social\">\r\n<ul>\r\n<li><a href=\"#\"><i class=\"fa fa-facebook\"><span class=\"dummy-text\">dummy-text</span></i></a></li>\r\n<li><a href=\"#\"><i class=\"fa fa-twitter\"><span class=\"dummy-text\">dummy-text</span></i></a></li>\r\n<li><a href=\"#\"><i class=\"fa fa-google-plus\"><span class=\"dummy-text\">dummy-text</span></i></a></li>\r\n<li><a href=\"#\"><i class=\"fa fa-linkedin\"><span class=\"dummy-text\">dummy-text</span></i></a></li>\r\n</ul>\r\n</div>', 1, 'bottom8', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" bottom-8\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(122, 230, 'LMS Course Search', '', '', 1, 'pagebuilder', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_splmscoursesearch', 1, 1, '{\"placeholder\":\"Search your courses\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(124, 232, 'Flickr Gallery', '', '', 1, 'bottom4', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sp_flickrgallery', 1, 1, '{\"flickr_id\":\"122684712@N04\",\"flickr_setid\":\"72157650430054357\",\"columns\":\"4\",\"limit\":\"12\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" flickr-gallery\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(125, 235, 'SP Page Builder', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_icons', 1, 1, '', 1, '*'),
(126, 236, 'SP Page Builder Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_admin_menu', 1, 1, '', 1, '*'),
(130, 251, 'Course Category', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_splmscoursescategegory', 1, 1, '{\"limit\":\"12\",\"category_type\":\"\",\"show_icon\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" course-category-list\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(133, 254, 'Category', '', '', 3, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{\"mode\":\"dynamic\",\"show_on_article_page\":\"1\",\"show_front\":\"show\",\"count\":\"5\",\"category_filtering_type\":\"1\",\"catid\":[\"\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"author_filtering_type\":\"1\",\"created_by\":[\"\"],\"author_alias_filtering_type\":\"1\",\"created_by_alias\":[\"\"],\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":\"30\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"article_grouping_direction\":\"ksort\",\"month_year_format\":\"F Y\",\"link_titles\":\"1\",\"show_date\":\"0\",\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":\"0\",\"show_hits\":\"0\",\"show_author\":\"0\",\"show_introtext\":\"0\",\"introtext_limit\":\"100\",\"show_readmore\":\"0\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"15\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" category\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(134, 255, 'Tag Cloud', '', '', 4, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tags_popular', 1, 1, '{\"maximum\":\"8\",\"timeframe\":\"alltime\",\"order_value\":\"count\",\"order_direction\":\"1\",\"display_count\":0,\"no_results_text\":\"0\",\"minsize\":1,\"maxsize\":2,\"layout\":\"_:default\",\"moduleclass_sfx\":\" popular-tag\",\"owncache\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(135, 262, 'Category', 'For blog with left sidebar', '', 3, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{\"mode\":\"dynamic\",\"show_on_article_page\":\"1\",\"show_front\":\"show\",\"count\":\"5\",\"category_filtering_type\":\"1\",\"catid\":[\"\"],\"show_child_category_articles\":\"0\",\"levels\":\"1\",\"author_filtering_type\":\"1\",\"created_by\":[\"\"],\"author_alias_filtering_type\":\"1\",\"created_by_alias\":[\"\"],\"excluded_articles\":\"\",\"date_filtering\":\"off\",\"date_field\":\"a.created\",\"start_date_range\":\"\",\"end_date_range\":\"\",\"relative_date\":\"30\",\"article_ordering\":\"a.title\",\"article_ordering_direction\":\"ASC\",\"article_grouping\":\"none\",\"article_grouping_direction\":\"ksort\",\"month_year_format\":\"F Y\",\"link_titles\":\"1\",\"show_date\":\"0\",\"show_date_field\":\"created\",\"show_date_format\":\"Y-m-d H:i:s\",\"show_category\":\"0\",\"show_hits\":\"0\",\"show_author\":\"0\",\"show_introtext\":\"0\",\"introtext_limit\":\"100\",\"show_readmore\":\"0\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"15\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(136, 263, 'Tag Cloud', 'For blog with left sidebar', '', 4, 'left', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_tags_popular', 1, 1, '{\"maximum\":\"8\",\"timeframe\":\"alltime\",\"order_value\":\"count\",\"order_direction\":\"1\",\"display_count\":0,\"no_results_text\":\"0\",\"minsize\":1,\"maxsize\":2,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"owncache\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\",\"icon\":\"\",\"background_color\":\"\",\"color\":\"\",\"padding\":\"\",\"margin\":\"\"}', 0, '*'),
(139, 266, 'Event Categories', '', '', 2, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_splmseventcategories', 1, 1, '{\"limit\":\"7\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"category\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(141, 268, 'Popular Course', '', '', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_splmscourses', 1, 1, '{\"course_type\":\"course_popular\",\"limit\":\"5\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(142, 269, 'Upcoming Event', '', '', 4, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_splmsupcomingevents', 1, 1, '{\"limit\":\"4\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(143, 270, 'Right-ad', '', '<div class=\"right-ad\">\r\n<div class=\"ad-img\"><img src=\"images/demo/right-ad.jpg\" alt=\"\" /></div>\r\n</div>', 1, 'right', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" right-side-ad\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(149, 292, 'My Account', '', '', 1, 'myaccount', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"usermenu\",\"base\":\"\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(152, 296, 'JS Events', '', '', 1, 'js_side_frontpage_bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_community_events', 1, 1, '{\"default\":5}', 0, '*'),
(153, 297, 'JS Groups', '', '', 1, 'js_side_frontpage_bottom', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_community_groups', 1, 1, '{\"default\":5}', 0, '*'),
(154, 298, 'JS Members', '', '', 1, 'js_side_frontpage_top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_community_members', 1, 1, '{\"default\":20}', 0, '*'),
(155, 299, 'JS Photos Module', '', '', 1, 'js_side_frontpage', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_community_photos', 1, 1, '{\"default\":20}', 0, '*'),
(156, 300, 'JS Quick Search', '', '', 1, 'js_side_frontpage', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_community_quicksearch', 1, 1, '{\"default\":\"\"}', 0, '*'),
(158, 302, 'JS Videos', '', '', 1, 'js_side_frontpage', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_community_videos', 1, 1, '{\"default\":3}', 0, '*'),
(159, 303, 'JS Whos Online', '', '', 1, 'js_side_frontpage_top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_community_whosonline', 1, 1, '{\"default\":20}', 0, '*'),
(160, 305, 'SP Page Builder', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_sppagebuilder', 1, 1, '', 0, '*'),
(161, 308, 'SP LMS Persons', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_splmspersons', 1, 1, '', 0, '*'),
(162, 313, 'SP LMS Cart', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_splmscart', 1, 1, '', 0, '*'),
(163, 317, 'SP LMS Event Calendar', '', '', 0, '', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_splmseventcalendar', 1, 1, '', 0, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__modules_menu`
--

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__modules_menu`
--

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(1, 101),
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(17, 0),
(20, 0),
(22, 234),
(22, 238),
(22, 242),
(22, 243),
(22, 244),
(22, 296),
(22, 399),
(22, 400),
(25, 294),
(26, -463),
(26, -462),
(26, -433),
(26, -432),
(26, -431),
(26, -430),
(26, -429),
(26, -427),
(26, -400),
(26, -399),
(26, -296),
(26, -244),
(26, -243),
(26, -242),
(26, -238),
(26, -234),
(32, 309),
(35, 0),
(45, 303),
(57, 238),
(57, 427),
(57, 429),
(57, 430),
(57, 431),
(57, 432),
(57, 433),
(57, 462),
(57, 463),
(79, 0),
(86, 0),
(87, 238),
(87, 427),
(87, 429),
(87, 430),
(87, 431),
(87, 432),
(87, 433),
(87, 462),
(87, 463),
(95, 0),
(96, 0),
(97, 0),
(98, 0),
(99, 492),
(100, 492),
(101, 492),
(102, 493),
(103, 493),
(104, 493),
(105, 0),
(107, 0),
(110, 0),
(112, 0),
(113, 0),
(115, 0),
(116, 0),
(117, 0),
(118, 0),
(122, 0),
(124, 0),
(125, 0),
(126, 0),
(130, 551),
(130, 650),
(133, 492),
(134, 492),
(135, 493),
(136, 493),
(139, 559),
(139, 562),
(139, 566),
(141, 551),
(141, 650),
(142, 559),
(142, 562),
(142, 566),
(143, 551),
(143, 650),
(149, 0),
(152, 0),
(153, 0),
(154, 0),
(155, 0),
(156, 0),
(158, 0),
(159, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__newsfeeds`
--

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) UNSIGNED NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `cache_time` int(10) UNSIGNED NOT NULL DEFAULT '3600',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__newsfeeds`
--

INSERT INTO `#__newsfeeds` (`catid`, `id`, `name`, `alias`, `link`, `published`, `numarticles`, `cache_time`, `checked_out`, `checked_out_time`, `ordering`, `rtl`, `access`, `language`, `params`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `xreference`, `publish_up`, `publish_down`, `description`, `version`, `hits`, `images`) VALUES
(17, 1, 'Joomla! Announcements', 'joomla-announcements', 'http://feeds.joomla.org/JoomlaAnnouncements', 1, 5, 3600, 0, '0000-00-00 00:00:00', 1, 1, 1, 'en-GB', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 1, ''),
(17, 2, 'New Joomla! Extensions', 'new-joomla-extensions', 'http://feeds.joomla.org/JoomlaExtensions', 1, 5, 3600, 0, '0000-00-00 00:00:00', 4, 1, 1, 'en-GB', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 3, 'Joomla! Security News', 'joomla-security-news', 'http://feeds.joomla.org/JoomlaSecurityNews', 1, 5, 3600, 0, '0000-00-00 00:00:00', 2, 1, 1, 'en-GB', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 0, ''),
(17, 4, 'Joomla! Connect', 'joomla-connect', 'http://feeds.joomla.org/JoomlaConnect', 1, 5, 3600, 0, '0000-00-00 00:00:00', 3, 1, 1, 'en-GB', '{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\",\"feed_display_order\":\"\"}', '2018-02-20 05:55:40', 776, 'Joomla', '0000-00-00 00:00:00', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 1, 3, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__overrider`
--

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__postinstall_messages`
--

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) UNSIGNED NOT NULL,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__postinstall_messages`
--

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(3, 700, 'COM_CPANEL_WELCOME_BEGINNERS_TITLE', 'COM_CPANEL_WELCOME_BEGINNERS_MESSAGE', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.2.0', 1),
(5, 700, 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', 1),
(6, 700, 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.3.0', 1),
(7, 700, 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', 1),
(8, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(9, 700, 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', 1, 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', 1),
(10, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(11, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1),
(12, 700, 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION', 'plg_captcha_recaptcha', 1, 'action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_condition', '3.8.6', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__schemas`
--

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__schemas`
--

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(700, '3.8.6-2018-02-14'),
(10007, '1.5-2017-14-09'),
(10042, '3.1-2018-01-01'),
(10086, '3.0-2018-03-12');

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_certificates`
--

DROP TABLE IF EXISTS `#__splms_certificates`;
CREATE TABLE `#__splms_certificates` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `userid` int(11) DEFAULT NULL,
  `coursescategory_id` int(11) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `student_image` varchar(255) DEFAULT '',
  `certificate_no` varchar(100) DEFAULT NULL,
  `instructor` varchar(100) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `issue_date` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_certificates`
--

INSERT INTO `#__splms_certificates` (`id`, `userid`, `coursescategory_id`, `course_id`, `student_image`, `certificate_no`, `instructor`, `published`, `ordering`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`, `issue_date`) VALUES
(1, 776, 2, 2, '', '3B5220151009', 'David Anderson', 1, 0, 632, '2015-10-09 00:00:00', 776, '2018-04-05 12:25:11', 0, '0000-00-00 00:00:00', '2016-02-22'),
(2, 776, 5, 2, '', '7DF620151009', 'Brandan White', 1, 0, 632, '2015-10-09 00:00:00', 776, '2018-04-05 12:25:03', 0, '0000-00-00 00:00:00', '0000-00-00');

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_courses`
--

DROP TABLE IF EXISTS `#__splms_courses`;
CREATE TABLE `#__splms_courses` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `course_sub_title` varchar(55) NOT NULL,
  `coursecategory_id` int(11) DEFAULT NULL,
  `description` text NOT NULL,
  `short_description` varchar(255) DEFAULT NULL,
  `level` varchar(55) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL,
  `video_url` varchar(255) NOT NULL,
  `ref_url` varchar(255) NOT NULL,
  `featured_course` tinyint(1) NOT NULL DEFAULT '0',
  `course_schedules` text NOT NULL,
  `course_infos` text NOT NULL,
  `course_time` varchar(255) NOT NULL DEFAULT '',
  `price` float(8,2) NOT NULL,
  `sale_price` float(8,2) DEFAULT NULL,
  `download` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `duration` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_courses`
--

INSERT INTO `#__splms_courses` (`id`, `title`, `alias`, `course_sub_title`, `coursecategory_id`, `description`, `short_description`, `level`, `image`, `video_url`, `ref_url`, `featured_course`, `course_schedules`, `course_infos`, `course_time`, `price`, `sale_price`, `download`, `published`, `access`, `language`, `ordering`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`, `duration`) VALUES
(1, 'Web Architectures', 'web-architectures', 'University of New Mexico', 9, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. In facilisis magna vitae rutrum consectetur.', '', 'images/demo/popular-course/course1.jpg', 'http://embed.wistia.com/deliveries/3baacd08e309b2b36871829110235769fc2b4f55/file.mp4', 'http://www.joomshaper.com', 0, '', '', '', 20.00, NULL, 10, 1, 1, '*', 0, 152, '2015-02-10 00:00:00', 84, '2015-03-23 11:24:11', 0, '0000-00-00 00:00:00', 30),
(2, 'Joomla Template Development', 'joomla-template-development', 'MIT Course', 11, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'This course is offered during IAP, which is a special 4-week term.', '', 'images/demo/popular-course/course2.jpg', 'http://embed.wistia.com/deliveries/3baacd08e309b2b36871829110235769fc2b4f55/file.mp4', 'http://joomshaper.com', 1, '', '', '', 25.00, NULL, 15, 1, 1, '*', 0, 152, '2015-02-10 00:00:00', 152, '2015-03-16 12:58:43', 0, '0000-00-00 00:00:00', 10),
(3, 'Web Development', 'web-development', 'For Beginners', 3, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', '', 'images/demo/popular-course/course3.jpg', 'http://embed.wistia.com/deliveries/3baacd08e309b2b36871829110235769fc2b4f55/file.mp4', 'http://joomshaper.com', 1, '', '', '', 0.00, NULL, 12, 1, 1, '*', 0, 152, '2015-02-11 00:00:00', 152, '2015-03-16 13:15:51', 0, '0000-00-00 00:00:00', 15),
(4, 'Programming Applications', 'programming-applications', 'University of Maryland', 9, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Course completers will be able to build their own Android applications .', '', 'images/demo/popular-course/course4.jpg', 'http://embed.wistia.com/deliveries/3baacd08e309b2b36871829110235769fc2b4f55/file.mp4', 'http://joomshaper.com', 1, '', '', '', 30.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-11 00:00:00', 84, '2015-03-23 11:24:00', 966, '2016-06-02 09:37:49', 10),
(5, 'Static vs Dynamic', 'static-vs-dynamic', 'website', 5, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. In facilisis magna vitae rutrum consectetur.', '', 'images/demo/popular-course/course5.jpg', 'http://embed.wistia.com/deliveries/3baacd08e309b2b36871829110235769fc2b4f55/file.mp4', 'http://joomshaper.com', 0, '', '', '', 30.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-11 00:00:00', 152, '2015-03-16 12:59:08', 0, '0000-00-00 00:00:00', 16),
(6, 'How Green Is Product?', 'how-green-is-product', 'Northwestern University', 6, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. In facilisis magna vitae rutrum consectetur.', '', 'images/demo/popular-course/course6.jpg', 'http://embed.wistia.com/deliveries/3baacd08e309b2b36871829110235769fc2b4f55/file.mp4', 'http://joomshaper.com', 1, '', '', '', 35.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-11 00:00:00', 84, '2015-03-23 11:23:49', 0, '0000-00-00 00:00:00', 25),
(7, 'Transforming images', 'transforming-and-sorting-images', 'Movies', 7, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Inventore, aliquam sequi nisi velit Visit magnam accusamus ....', '', 'images/demo/popular-course/course5.jpg', 'https://www.youtube.com/watch?v=Yzzmop7ae0I', 'joomshaper.com', 0, '', '', '', 0.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 12:59:21', 0, '0000-00-00 00:00:00', 30),
(8, 'The beauty of MIDI', 'the-beauty-of-midi', 'Audio and Music', 8, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Inventore, aliquam sequi nisi velit Visit magnam accusamus ....', '', 'images/demo/popular-course/course2.jpg', 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', 'joomshaper.com', 0, '', '', '', 0.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 12:59:42', 0, '0000-00-00 00:00:00', 45),
(9, 'Practical Machine Learning', 'pml', 'Johns Hopkins University', 9, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Learn the basic components of building functions with an emphasis on practical mobile apps.', '', 'images/demo/popular-course/course3.jpg', 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', 'joomshaper.com', 1, '', '', '', 0.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 12:59:48', 0, '0000-00-00 00:00:00', 60),
(10, 'Foundations of Teaching', 'fot', 'Commonwealth Education Trust', 7, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'inventore, aliquam sequi nisi velit visit magnam accusamus ....', '', 'images/demo/popular-course/course6.jpg', 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', 'joomshaper.com', 1, '', '', '', 48.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 12:59:54', 0, '0000-00-00 00:00:00', 60),
(11, 'Rethinking International', 'tax-law', 'Universiteit Leiden', 11, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. ', '', 'images/demo/popular-course/course4.jpg', 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', 'joomshaper.com', 1, '', '', '', 0.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 12:59:59', 0, '0000-00-00 00:00:00', 45),
(12, 'Advertising and Society', 'advertising-society', 'Duke University', 12, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. In facilisis magna vitae rutrum consectetur. ', '', 'images/demo/popular-course/course5.jpg', 'https://www.youtube.com/watch?v=Yzzmop7ae0I', 'joomshaper.com', 1, '', '', '', 0.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 13:00:05', 0, '0000-00-00 00:00:00', 60),
(13, 'Everyday Creativity', 'ignite-creativity', 'State University of New York', 1, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'The goal of this course is to help you recognize, develop and act upon the creativity that you already possess.', '', 'images/demo/popular-course/course1.jpg', 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', 'joomshaper.com', 1, '', '', '', 80.00, NULL, 8, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 84, '2015-03-23 11:24:14', 0, '0000-00-00 00:00:00', 30),
(14, 'Introduction to Electronics', 'electronic-basic', 'Georgia Institute of Technology', 2, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'This course introduces students to the basic components of electronics. ', '', 'images/demo/popular-course/course2.jpg', 'https://www.youtube.com/watch?v=Yzzmop7ae0I', 'joomshaper.com', 1, '', '', '', 100.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 13:00:16', 0, '0000-00-00 00:00:00', 60),
(15, 'Psychological First Aid', 'first-aid', 'Johns Hopkins University', 4, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Learn to provide psychological first aid to people in an emergency by employing the RAPID model.', '', 'images/demo/popular-course/course3.jpg', 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', 'joomshaper.com', 1, '', '', '', 75.00, NULL, 0, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 13:00:27', 0, '0000-00-00 00:00:00', 45),
(16, 'From Idea Market', 'from-idea', 'University of Maryland', 5, '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Develop insights on navigating the innovation process from idea generation to commercialization.', '', 'images/demo/popular-course/course4.jpg', 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', 'joomshaper.com', 1, '', '', '', 85.00, NULL, 5, 1, 1, '*', 0, 152, '2015-02-12 00:00:00', 152, '2015-03-16 13:00:37', 0, '0000-00-00 00:00:00', 60);

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_coursescategories`
--

DROP TABLE IF EXISTS `#__splms_coursescategories`;
CREATE TABLE `#__splms_coursescategories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `featured` tinyint(1) NOT NULL,
  `show` tinyint(1) NOT NULL,
  `icon` varchar(55) NOT NULL,
  `description` text,
  `image` varchar(255) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `asset_id` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_coursescategories`
--

INSERT INTO `#__splms_coursescategories` (`id`, `title`, `alias`, `featured`, `show`, `icon`, `description`, `image`, `published`, `access`, `language`, `ordering`, `asset_id`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`) VALUES
(1, 'Art & Illustration', 'art-illustration', 0, 2, 'paint-brush', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 0, 1, '*', 0, 233, 152, '2015-02-13 12:39:14', 490, '2016-01-15 10:07:51', 0, '0000-00-00 00:00:00'),
(2, 'Electric & Electronic', 'electric-electronic', 1, 2, 'cogs', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 237, 152, '2015-02-16 08:52:41', 648, '2016-04-06 11:07:09', 0, '0000-00-00 00:00:00'),
(3, 'Business', 'business', 1, 2, 'trophy', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 238, 152, '2015-02-16 08:53:16', 728, '2017-10-16 11:15:15', 0, '0000-00-00 00:00:00'),
(4, 'Medical & Care', 'medical-care', 1, 2, 'medkit', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 239, 152, '2015-02-16 08:55:08', 152, '2015-03-16 06:25:16', 0, '0000-00-00 00:00:00'),
(5, 'Web Development', 'web-development', 1, 2, 'arrows-alt', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 240, 152, '2015-02-16 08:58:56', 152, '2015-03-16 06:25:46', 0, '0000-00-00 00:00:00'),
(6, 'Agriculture', 'agriculture', 0, 2, 'leaf', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 241, 152, '2015-02-16 08:59:40', 152, '2015-03-16 06:25:56', 0, '0000-00-00 00:00:00'),
(7, 'Film & Media', 'film-media', 0, 2, 'video-camera', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 242, 152, '2015-02-16 09:01:14', 152, '2015-03-16 06:26:06', 0, '0000-00-00 00:00:00'),
(8, 'Music', 'music', 0, 2, 'music', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 243, 152, '2015-02-16 09:02:31', 152, '2015-03-16 06:26:15', 0, '0000-00-00 00:00:00'),
(9, 'Mobile Application', 'mobile-application', 0, 2, 'mobile', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 244, 152, '2015-02-16 09:04:13', 152, '2015-03-16 06:26:24', 0, '0000-00-00 00:00:00'),
(10, 'Sports', 'sports', 0, 2, 'futbol-o', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 245, 152, '2015-02-16 09:05:08', 152, '2015-03-16 06:26:33', 0, '0000-00-00 00:00:00'),
(11, 'Law & Regulation', 'law-regulation', 1, 2, 'rocket', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 246, 152, '2015-02-16 09:08:29', 152, '2015-03-16 06:26:41', 0, '0000-00-00 00:00:00'),
(12, 'Photography', 'photography', 1, 2, 'camera', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 247, 152, '2015-02-16 09:09:07', 152, '2015-03-16 06:26:49', 0, '0000-00-00 00:00:00'),
(13, 'Art & Illustration', 'art-a-illustration', 1, 2, 'paint-brush', '<p>Chuck turkey spare ribs, shankle brisket boudin leberkas sausage pork chop pastrami turducken pork belly. Doner flank sausage ball tip. Alcatra beef ribs corned beef filet mignon short ribs, kielbasa pancetta ribeye andouille. Sausage pig biltong fatback short ribs ball tip doner. Andouille beef ribs jowl drumstick picanha, doner beef meatloaf cow ground round. Jerky shank sirloin picanha. Prosciutto venison tongue brisket, sausage beef tail picanha kielbasa doner.</p>', '', 1, 1, '*', 0, 304, 648, '2016-04-06 11:06:59', 648, '2016-04-06 11:07:35', 0, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_eventcategories`
--

DROP TABLE IF EXISTS `#__splms_eventcategories`;
CREATE TABLE `#__splms_eventcategories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `asset_id` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_eventcategories`
--

INSERT INTO `#__splms_eventcategories` (`id`, `title`, `alias`, `description`, `image`, `published`, `access`, `language`, `ordering`, `asset_id`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`) VALUES
(1, 'Joomla', 'joomla-event', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event4.jpg', 1, 1, '*', 0, 227, 152, '2015-02-11 11:54:20', 152, '2015-03-06 12:48:47', 0, '0000-00-00 00:00:00'),
(2, 'Drupal', 'wordprss', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</span></p>', 'images/demo/event/event3.jpg', 1, 1, '*', 0, 228, 152, '2015-02-11 11:54:36', 152, '2015-03-06 12:49:58', 0, '0000-00-00 00:00:00'),
(3, 'CMS', 'bowels-and-whistles', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event2.jpg', 1, 1, '*', 0, 274, 152, '2015-03-03 07:45:30', 152, '2015-03-03 09:01:46', 0, '0000-00-00 00:00:00'),
(4, 'eCommerce', 'ecommerce', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event3.jpg', 1, 1, '*', 0, 275, 152, '2015-03-03 07:46:09', 152, '2015-03-10 17:38:10', 0, '0000-00-00 00:00:00'),
(5, 'Java', 'update-joomla', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event1.jpg', 1, 1, '*', 0, 276, 152, '2015-03-03 07:46:44', 152, '2015-03-06 12:53:18', 0, '0000-00-00 00:00:00'),
(6, 'Wordpress', 'advance-wordpress', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event5.jpg', 1, 1, '*', 0, 277, 152, '2015-03-03 07:47:13', 152, '2015-03-06 12:49:37', 0, '0000-00-00 00:00:00'),
(7, 'Mysql', 'mysql', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event1.jpg', 1, 1, '*', 0, 278, 152, '2015-03-03 07:47:33', 152, '2015-03-03 08:58:34', 0, '0000-00-00 00:00:00'),
(8, 'UX', 'ux', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event8.jpg', 1, 1, '*', 0, 279, 152, '2015-03-03 07:50:21', 152, '2015-03-10 17:21:51', 0, '0000-00-00 00:00:00'),
(9, 'JavaScript', 'javascript', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event4.jpg', 1, 1, '*', 0, 280, 152, '2015-03-03 08:43:42', 152, '2015-03-03 08:57:41', 0, '0000-00-00 00:00:00'),
(10, 'HTML5', 'html5', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event1.jpg', 1, 1, '*', 0, 281, 152, '2015-03-03 08:45:30', 152, '2015-03-03 08:57:19', 0, '0000-00-00 00:00:00'),
(11, 'Ajax', 'ajax', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event2.jpg', 1, 1, '*', 0, 282, 152, '2015-03-03 08:45:53', 152, '2015-03-03 08:57:06', 0, '0000-00-00 00:00:00'),
(12, 'Wordpress', 'wordpress', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event3.jpg', 1, 1, '*', 0, 283, 152, '2015-03-03 08:46:26', 152, '2015-03-03 08:56:55', 0, '0000-00-00 00:00:00'),
(13, 'jQuery', 'jquery', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event5.jpg', 1, 1, '*', 0, 284, 152, '2015-03-03 08:48:16', 152, '2015-03-03 08:56:37', 0, '0000-00-00 00:00:00'),
(14, 'CSS3', 'css3', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event6.jpg', 1, 1, '*', 0, 285, 152, '2015-03-03 08:48:40', 152, '2015-03-03 08:56:26', 0, '0000-00-00 00:00:00'),
(15, 'PHP', 'php', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event8.jpg', 1, 1, '*', 0, 286, 152, '2015-03-03 08:49:03', 152, '2015-03-03 08:56:11', 0, '0000-00-00 00:00:00'),
(16, 'HTML', 'html', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event1.jpg', 1, 1, '*', 0, 287, 152, '2015-03-03 08:49:32', 152, '2015-03-03 08:56:00', 0, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_events`
--

DROP TABLE IF EXISTS `#__splms_events`;
CREATE TABLE `#__splms_events` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) DEFAULT '',
  `price` int(11) DEFAULT NULL,
  `buy_url` varchar(255) DEFAULT NULL,
  `speaker_id` varchar(50) DEFAULT '',
  `eventcategory_id` bigint(20) NOT NULL,
  `event_start_date` date NOT NULL,
  `event_end_time` time NOT NULL,
  `event_time` time NOT NULL,
  `event_end_date` date NOT NULL,
  `event_address` text,
  `topics` text NOT NULL,
  `gallery` text NOT NULL,
  `pricing_tables` text NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_events`
--

INSERT INTO `#__splms_events` (`id`, `title`, `alias`, `description`, `image`, `price`, `buy_url`, `speaker_id`, `eventcategory_id`, `event_start_date`, `event_end_time`, `event_time`, `event_end_date`, `event_address`, `topics`, `gallery`, `pricing_tables`, `published`, `access`, `language`, `ordering`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`, `map`) VALUES
(1, 'Joomla Day USA', 'joomla-day-usa', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event1.jpg', 20, NULL, '[\"2\"]', 1, '2015-07-10', '10:30:00', '17:20:00', '2015-07-12', 'Los Angels, CA', '', '', '', 1, 1, '*', 0, 152, '2015-02-11 11:55:37', 152, '2015-03-12 07:43:57', 0, '0000-00-00 00:00:00', '23.757098, 90.37255200000004'),
(2, 'Business Change Workshop', 'business-change-workshop', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event2.jpg', 30, NULL, '[\"1\",\"2\",\"3\",\"4\"]', 1, '2015-06-12', '15:50:00', '13:30:00', '2015-06-15', 'NY 10451, USA', '', '', '', 1, 1, '*', 0, 152, '2015-02-12 05:34:50', 84, '2015-03-23 11:24:45', 0, '0000-00-00 00:00:00', '34.0522342, -118.2436849'),
(3, 'New Perspectives LMS', 'new-perspectives-in-lms-business', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event3.jpg', 25, NULL, '[\"1\",\"2\"]', 6, '2016-08-15', '00:00:00', '14:00:00', '2016-08-20', '5/4 Dhaka 1207', '', '', '', 1, 1, '*', 0, 152, '2015-02-12 05:57:46', 84, '2015-03-23 11:24:47', 0, '0000-00-00 00:00:00', '40.7324319, -73.82480799999996'),
(4, 'Joomla Innovation Awards', 'joomla-innovation-awards', '<p>The Joomla Innovation Awards is an annual competition honoring outstanding design and engineering in consumer technology products. Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event4.jpg', 35, NULL, '[\"1\",\"2\"]', 7, '2016-08-22', '00:00:00', '15:00:00', '2016-08-30', '5/4 Dhaka 1207', '', '', '', 1, 1, '*', 0, 152, '2015-02-12 05:58:59', 84, '2015-03-23 11:24:49', 0, '0000-00-00 00:00:00', '40.7324319, -73.82480799999996'),
(5, 'Usability Week 2015', 'usability-week-san-diego-2015', '<p>Usability Week, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event5.jpg', 20, NULL, '[\"1\",\"2\"]', 15, '2017-05-02', '00:00:00', '10:30:00', '2017-05-06', '5/4 Dhaka 1207', '', '', '', 1, 1, '*', 0, 152, '2015-02-12 06:14:42', 84, '2015-03-23 11:24:51', 0, '0000-00-00 00:00:00', '40.7324319, -73.82480799999996'),
(6, 'Enterprise Cloud Solutions', 'enterprise-cloud-solutions', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event6.jpg', 60, NULL, '[\"1\",\"2\"]', 9, '2017-05-03', '00:00:00', '19:30:00', '2017-05-08', '5/4 Dhaka 1207', '', '', '', 1, 1, '*', 0, 152, '2015-02-12 06:16:31', 84, '2015-03-23 11:24:54', 0, '0000-00-00 00:00:00', '40.7324319, -73.82480799999996'),
(7, 'Interaction Conference', 'interaction-intranet-conference-london-2015', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</span></p>', 'images/demo/event/event8.jpg', 10, NULL, '[\"1\",\"2\"]', 10, '2015-10-30', '00:00:00', '10:50:00', '2015-11-30', '5/4 Dhaka 1207', '', '', '', 1, 1, '*', 0, 152, '2015-02-18 07:32:09', 152, '2015-03-11 12:38:07', 0, '0000-00-00 00:00:00', '51.505805, -0.025376000000051135'),
(8, 'Cascadia IT Conference', 'cascadia-it-conference-seattle-2015', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event2.jpg', 50, NULL, '[\"1\"]', 16, '2015-10-05', '02:50:00', '12:00:00', '2015-11-10', 'Seattle, North America', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 09:26:16', 84, '2015-03-23 11:24:55', 0, '0000-00-00 00:00:00', '47.6062095, -122.3320708'),
(9, 'Learning Analytics', 'learning-analytics-and-knowledge-conference-new-yo', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event2.jpg', 80, NULL, '[\"2\"]', 14, '2015-10-05', '12:50:00', '08:00:00', '2015-11-10', 'Lahore, Pakistan', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 09:30:07', 152, '2015-03-12 08:59:45', 0, '0000-00-00 00:00:00', '41.7003713, -73.92097009999998'),
(10, 'Smashing Conference ', 'smashing-conference-oxford-2015', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event3.jpg', 55, NULL, '[\"1\"]', 13, '2015-10-05', '02:50:00', '08:00:00', '2015-11-10', 'Oxford, EMEA', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 09:31:37', 152, '2015-03-11 12:38:34', 0, '0000-00-00 00:00:00', '51.7520209, -1.2577263000000585'),
(11, 'Content Management', 'content-management-strategies-dita-north-america-c', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event3.jpg', 88, NULL, '[\"1\"]', 2, '2015-10-05', '12:50:00', '08:00:00', '2015-11-10', 'Chicago, USA', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 09:54:28', 84, '2015-03-23 11:24:58', 0, '0000-00-00 00:00:00', '41.877728, -87.630019'),
(12, 'Customer Experience 2015', 'customer-experience-conference-ny-2015', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event2.jpg', 55, NULL, '[\"2\"]', 3, '2015-10-05', '05:50:00', '12:00:00', '2015-11-10', 'NY 10024, USA', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 09:57:26', 84, '2015-03-23 11:24:59', 0, '0000-00-00 00:00:00', '40.781324, -73.97398800000002'),
(13, 'eCommerce Expo 2015', 'ecommerce-expo-london-2015', '<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</p>', 'images/demo/event/event3.jpg', 66, NULL, '[\"1\"]', 4, '2015-10-05', '01:50:00', '12:00:00', '2015-11-10', 'London, UK', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 10:00:25', 152, '2015-03-12 09:02:16', 0, '0000-00-00 00:00:00', '51.5095144494086, -0.13986042707529123'),
(14, 'Internet Summit 2015', 'internet-of-things-summit-london-2015', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</span></p>', 'images/demo/event/event8.jpg', 97, NULL, '[\"1\"]', 11, '2015-10-05', '05:00:00', '19:30:00', '2015-11-10', '5/4 Dhaka 1207', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 10:52:10', 84, '2015-03-23 11:25:01', 0, '0000-00-00 00:00:00', '40.7324319, -73.82480799999996'),
(15, 'Mobile Dev Conference', 'mobile-dev-test-conference-san-diego-2015', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</span></p>', 'images/demo/event/event4.jpg', 71, NULL, '[\"1\"]', 12, '2015-10-05', '12:50:00', '08:00:00', '2015-11-10', '5/4 Dhaka 1207', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 10:58:12', 152, '2015-03-11 12:38:56', 0, '0000-00-00 00:00:00', '32.715738, -117.16108380000003'),
(16, 'Wearables TechCon 2015', 'wearables-techcon-2015', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellatInventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat</span></p>', 'images/demo/event/event6.jpg', 108, NULL, '[\"1\"]', 8, '2015-10-05', '12:50:00', '10:30:00', '2015-11-10', '5/4 Dhaka 1207', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:01:26', 84, '2015-03-23 11:25:13', 0, '0000-00-00 00:00:00', '40.7324319, -73.82480799999996');

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_lessons`
--

DROP TABLE IF EXISTS `#__splms_lessons`;
CREATE TABLE `#__splms_lessons` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `short_description` varchar(255) DEFAULT '',
  `teacher_id` int(11) NOT NULL,
  `video_url` varchar(255) DEFAULT '',
  `vdo_thumb` text NOT NULL,
  `ordering` int(10) UNSIGNED NOT NULL,
  `course_id` bigint(20) NOT NULL,
  `video_duration` varchar(50) DEFAULT '',
  `attachment` varchar(255) DEFAULT '',
  `lesson_type` tinyint(1) NOT NULL DEFAULT '1',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_lessons`
--

INSERT INTO `#__splms_lessons` (`id`, `title`, `alias`, `description`, `short_description`, `teacher_id`, `video_url`, `vdo_thumb`, `ordering`, `course_id`, `video_duration`, `attachment`, `lesson_type`, `published`, `access`, `language`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`) VALUES
(1, ' Introduction and Symfony Overview', 'introduction-and-symfony-overview', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 1, 'https://www.youtube.com/watch?v=kPjYqMfzcdo', 'images/feature-bg1.jpg', 1, 8, '02:13', '', 0, 1, 1, '*', 152, '2015-02-11 00:00:00', 152, '2015-03-09 10:37:12', 0, '0000-00-00 00:00:00'),
(2, 'Application Core', 'application-core', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami', 2, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 15, 7, '02:13', '', 1, 1, 1, '*', 152, '2015-02-13 00:00:00', 84, '2015-03-23 11:25:41', 0, '0000-00-00 00:00:00'),
(3, 'Adding a Payment ', 'adding-a-payment', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 3, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 16, 6, '02:13', '', 1, 1, 1, '*', 152, '2015-02-16 00:00:00', 152, '2015-03-09 12:28:02', 0, '0000-00-00 00:00:00'),
(4, 'Improvements', 'improvements', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', '`', 4, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 17, 5, '02:13', '', 1, 1, 1, '*', 152, '2015-02-16 00:00:00', 152, '2015-03-09 12:27:55', 0, '0000-00-00 00:00:00'),
(5, 'Your first jQuery-enabled page', 'your-first-jquery-enabled-page', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 1, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 18, 4, '02:13', '', 1, 1, 1, '*', 152, '2015-02-17 00:00:00', 152, '2015-03-09 12:27:48', 0, '0000-00-00 00:00:00'),
(6, '1.2 Basic idea of HTML & CSS', '1-2-basic-idea-of-html-css', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 2, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/demo/contact-1.png', 20, 3, '02:13', '', 0, 1, 1, '*', 152, '2015-02-17 00:00:00', 152, '2015-03-16 13:13:25', 0, '0000-00-00 00:00:00'),
(7, 'Joomla Template Development Part 2', 'joomla-template-development-part-2', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 3, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/featured-bg2.jpg', 21, 2, '02:13', '', 0, 1, 1, '*', 152, '2015-02-17 00:00:00', 152, '2015-03-16 13:09:08', 0, '0000-00-00 00:00:00'),
(8, 'Web Architectures Part 2', 'web-architectures-part-2', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 4, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/demo/slideshow/slider-1.jpg', 31, 1, '02:13', '', 0, 1, 1, '*', 152, '2015-02-17 00:00:00', 152, '2015-03-16 13:05:47', 0, '0000-00-00 00:00:00'),
(9, 'Joomla Template Development Part 3', 'joomla-template-development-part-3', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 1, 'https://www.youtube.com/watch?v=kPjYqMfzcdo', '', 19, 2, '04:25', '', 1, 1, 1, '*', 152, '2015-02-17 00:00:00', 152, '2015-03-16 13:09:08', 0, '0000-00-00 00:00:00'),
(10, 'Joomla! 3.3 Essentials', 'joomla-3-3-essentials', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 1, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 23, 9, '02:13', '', 1, 1, 1, '*', 152, '2015-02-18 00:00:00', 152, '2015-03-09 12:27:12', 0, '0000-00-00 00:00:00'),
(11, 'Installation overview', 'installation-overview', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 3, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/demo/event/event7.jpg', 24, 4, '02:13', '', 0, 1, 1, '*', 152, '2015-03-03 00:00:00', 84, '2015-03-23 11:25:43', 0, '0000-00-00 00:00:00'),
(12, 'Working with Apache Web Server', 'working-with-apache-web-server', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 4, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 25, 5, '02:13', '', 0, 1, 1, '*', 152, '2015-03-03 00:00:00', 84, '2015-03-23 11:25:56', 0, '0000-00-00 00:00:00'),
(13, 'Building a content management system', 'building-a-content-management-system', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 5, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 26, 6, '02:13', '', 0, 1, 1, '*', 152, '2015-03-03 00:00:00', 152, '2015-03-09 12:26:23', 0, '0000-00-00 00:00:00'),
(14, 'Building dynamic webpages', 'building-dynamic-webpages', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 7, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 27, 9, '02:13', '', 1, 1, 1, '*', 152, '2015-03-03 00:00:00', 152, '2015-03-09 12:26:15', 0, '0000-00-00 00:00:00'),
(15, 'Sorting and searching arrays', 'sorting-and-searching-arrays', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 8, 'https://www.youtube.com/watch?v=tqfl51HVodI', '', 28, 10, '02:13', '', 1, 1, 1, '*', 152, '2015-03-03 00:00:00', 152, '2015-03-09 12:26:09', 0, '0000-00-00 00:00:00'),
(16, 'Web Architectures Part 1', 'web-architectures-part-1', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 2, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/feature-bg1.jpg', 32, 1, '04:25', '', 0, 1, 1, '*', 152, '2015-03-03 00:00:00', 152, '2015-03-16 13:05:47', 0, '0000-00-00 00:00:00'),
(17, 'Joomla Template Development Part 1', 'joomla-template-development-part-1', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 2, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/demo/popular-course/course5.jpg', 22, 2, '02:13', '', 0, 1, 1, '*', 152, '2015-03-10 00:00:00', 152, '2015-03-16 13:09:08', 0, '0000-00-00 00:00:00'),
(18, '1.1 Introduction and Overview of HTML', '1-1-introduction-and-overview-of-html', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 3, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/demo/about.jpg', 2, 3, '04:25', '', 1, 1, 1, '*', 152, '2015-03-10 00:00:00', 152, '2015-03-16 13:18:19', 0, '0000-00-00 00:00:00'),
(19, 'Using headings', 'using-headings', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 4, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 3, 4, '02:13', '', 1, 1, 1, '*', 152, '2015-03-10 10:16:08', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(20, 'Emphasizing text', 'emphasizing-text', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 5, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 4, 5, '04:25', '', 1, 1, 1, '*', 152, '2015-03-10 10:17:20', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(21, 'Controlling line breaks', 'controlling-line-breaks', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 6, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 5, 6, '04:25', '', 1, 1, 1, '*', 152, '2015-03-10 10:18:16', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(22, 'Displaying images', 'displaying-images', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 7, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 6, 7, '02:13', '', 1, 1, 1, '*', 152, '2015-03-10 10:21:59', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(23, 'The value of structure', 'the-value-of-structure', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 8, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 7, 8, '02:13', '', 0, 1, 1, '*', 152, '2015-03-10 10:22:46', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(24, 'The nav element', 'the-nav-element', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 9, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 8, 10, '02:13', '', 1, 1, 1, '*', 152, '2015-03-10 10:23:23', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(25, 'Other semantic elements', 'other-semantic-elements', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 10, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 9, 10, '02:13', '', 1, 1, 1, '*', 152, '2015-03-10 10:24:18', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(26, 'Using WAI-ARIA roles', 'using-wai-aria-roles', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 14, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 10, 12, '02:13', '', 1, 1, 1, '*', 152, '2015-03-10 10:26:01', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(27, 'Exploring the anchor element', 'exploring-the-anchor-element', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 15, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 11, 14, '02:13', '', 1, 1, 1, '*', 152, '2015-03-10 10:27:54', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(28, 'Linking to external pages', 'linking-to-external-pages', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 16, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 12, 15, '04:25', '', 1, 1, 1, '*', 152, '2015-03-10 10:28:33', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(29, 'Solution: Creating links', 'solution-creating-links', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 17, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 13, 15, '02:13', '', 0, 1, 1, '*', 152, '2015-03-10 10:29:18', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(30, 'Creating inline styles', 'creating-inline-styles', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</span></p>', 'Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.', 17, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 14, 16, '02:13', '', 0, 1, 1, '*', 152, '2015-03-10 10:34:56', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(31, 'Web Architectures Part 3', 'web-architectures-part-3', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs,', 1, 'https://www.youtube.com/watch?v=-a6Pe1ovKHg', '', 30, 1, '04:25', '', 1, 1, 1, '*', 152, '2015-03-16 00:00:00', 152, '2015-03-16 13:05:47', 0, '0000-00-00 00:00:00'),
(32, 'Web Architectures Part 4', 'web-architectures-part-4', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly.', 1, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/demo/slideshow/slider-4.jpg', 29, 1, '04:25', '', 1, 1, 1, '*', 152, '2015-03-16 00:00:00', 152, '2015-03-16 13:16:47', 0, '0000-00-00 00:00:00'),
(33, '2. Integrate CSS With HTML  ', '2-integrate-css-with-html', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. <br /><br /> Ground round porchetta strip steak chicken bresaola. Flank pork loin boudin fatback rump ham hock. Hamburger ham pig pork chop sausage short ribs rump spare ribs ground round picanha pancetta prosciutto tail shoulder frankfurter. Ribeye bacon sausage, alcatra pastrami pancetta boudin cupim. Turducken biltong short ribs leberkas meatball, chicken brisket landjaeger pork loin jowl. Brisket filet mignon ham hock andouille, rump tail ham bacon sirloin ribeye jerky swine beef ribs t-bone flank. Shankle ham leberkas, shoulder tail hamburger doner pancetta. <br /><br /> Meatball pork belly corned beef, cow biltong porchetta filet mignon. Shoulder turkey swine, sausage venison pork cupim landjaeger short ribs kielbasa. Beef ribs sirloin cupim, filet mignon bresaola tri-tip cow pork short loin ham turducken turkey shoulder. Pig prosciutto boudin, strip steak corned beef sausage ham meatloaf tail kevin pork loin alcatra kielbasa porchetta leberkas. Hamburger chuck spare ribs ball tip turducken turkey bresaola sausage pastrami frankfurter fatback rump corned beef. Alcatra pork pork chop short loin shankle.</p>', 'Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Be', 9, 'http://www.quirksmode.org/html5/videos/big_buck_bunny.mp4', 'images/demo/event/event8.jpg', 0, 3, '04:25', '', 0, 1, 1, '*', 152, '2015-03-16 13:15:18', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_orders`
--

DROP TABLE IF EXISTS `#__splms_orders`;
CREATE TABLE `#__splms_orders` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_user_id` bigint(20) NOT NULL,
  `course_id` bigint(20) NOT NULL,
  `order_price` float(17,2) NOT NULL,
  `order_payment_id` varchar(255) NOT NULL,
  `invoice_id` varchar(255) NOT NULL,
  `order_payment_method` varchar(255) NOT NULL DEFAULT '',
  `order_payment_price` float NOT NULL,
  `order_duration` varchar(55) NOT NULL DEFAULT '',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `payment_note` text,
  `created_by` bigint(20) DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order_discount_code` varchar(255) DEFAULT '',
  `order_discount_price` decimal(17,5) DEFAULT NULL,
  `order_discount_tax` decimal(17,5) DEFAULT NULL,
  `order_payment_currency` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_orders`
--

INSERT INTO `#__splms_orders` (`id`, `order_user_id`, `course_id`, `order_price`, `order_payment_id`, `invoice_id`, `order_payment_method`, `order_payment_price`, `order_duration`, `ordering`, `published`, `payment_note`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`, `order_discount_code`, `order_discount_price`, `order_discount_tax`, `order_payment_currency`) VALUES
(1, 322, 2, 25.00, 'asd5454s5d4', '1', 'Paypal', 36, '2015-10-05', 0, 1, NULL, 152, '2015-03-01 18:00:00', 322, '2016-02-22 12:01:11', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(3, 152, 2, 20.00, 'asd5454s5d4', '14260706148771', 'Paypal', 36, '2008-10-05', 0, 1, NULL, 152, '2015-03-05 00:00:00', 84, '2015-03-23 11:22:40', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(6, 152, 2, 20.00, 'asd5454s5d4', 'abc1234', 'Paypal', 36, '', 0, 1, NULL, 152, '2015-03-05 00:00:00', 84, '2015-03-23 11:22:52', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(7, 152, 2, 20.00, 'asd5454s5d4s', '14260703394371', 'Paypal', 36, '', 0, 1, NULL, 152, '2015-03-01 00:00:00', 84, '2015-03-23 11:22:57', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(8, 152, 2, 20.00, 'asd5454s5d4', '14260690439911', 'Paypal', 36, '', 0, 1, NULL, 152, '2015-02-28 00:00:00', 84, '2015-03-23 11:23:03', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(9, 152, 6, 20.00, 'asd5454s5d4', 'abc1234', 'Paypal', 36, '', 0, 1, NULL, 152, '2015-02-02 00:00:00', 84, '2015-03-23 11:23:08', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(10, 152, 5, 25.00, 'asd5454s5d4', '', 'Paypal', 36, '', 0, 1, NULL, 152, '2015-03-01 18:00:00', 152, '2015-03-05 07:13:26', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(11, 152, 7, 20.00, 'asd5454s5d4s', '14260703394371', 'Paypal', 124, '', 0, 1, NULL, 152, '2015-03-04 00:00:00', 84, '2015-03-23 11:23:14', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(12, 152, 8, 20.00, 'asd5454s5d4', '14260690439911', 'Paypal', 36, '2015-03-19', 0, 1, NULL, 152, '2015-03-05 00:00:00', 84, '2015-03-23 11:23:21', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(13, 152, 10, 25.00, 'asd5454s5d4', '', 'Paypal', 36, '2015-03-20', 0, 1, NULL, 152, '2015-03-03 18:00:00', 152, '2015-03-05 07:13:50', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(14, 152, 5, 20.00, 'asd5454s5d4', '', 'Paypal', 36, '2015-03-26', 0, 1, NULL, 152, '2015-03-04 18:00:00', 152, '2015-03-05 11:07:10', 0, '0000-00-00 00:00:00', '', '0.00000', '0.00000', NULL),
(38, 152, 1, 20.00, '05U667415V929021W', '14260748211961', 'paypal', 20, '', 0, 1, NULL, 0, '2015-03-11 11:54:19', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', '', NULL, NULL, 'USD'),
(39, 152, 4, 30.00, '05U667415V929021W', '14260748211961', 'paypal', 30, '', 0, 1, NULL, 0, '2015-03-11 11:54:19', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', '', NULL, NULL, 'USD'),
(40, 152, 15, 75.00, '05U667415V929021W', '14260748211961', 'paypal', 75, '', 0, 1, NULL, 0, '2015-03-11 11:54:19', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', '', NULL, NULL, 'USD'),
(41, 152, 13, 80.00, '05U667415V929021W', '14260748211961', 'paypal', 80, '', 0, 1, NULL, 0, '2015-03-11 11:54:19', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', '', NULL, NULL, 'USD'),
(42, 152, 14, 100.00, '05U667415V929021W', '14260748211961', 'paypal', 100, '', 0, 1, NULL, 0, '2015-03-11 11:54:19', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', '', NULL, NULL, 'USD'),
(43, 152, 13, 80.00, '1LM93152B5864234Y', '14260752123070', 'paypal', 80, '', 0, 0, NULL, 0, '2015-03-11 12:00:47', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', '', NULL, NULL, 'USD'),
(44, 0, 1, 20.00, '405AEF20160406', '405AEF20160406', 'direct', 20, '', 0, 0, NULL, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', '', NULL, NULL, NULL),
(45, 0, 1, 20.00, '0C118420180411', '0C118420180411', 'direct', 20, '', 0, 0, '', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', '', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_quizquestions`
--

DROP TABLE IF EXISTS `#__splms_quizquestions`;
CREATE TABLE `#__splms_quizquestions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `description` text NOT NULL,
  `course_id` bigint(20) NOT NULL,
  `list_answers` text,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `quiz_type` tinyint(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_quizquestions`
--

INSERT INTO `#__splms_quizquestions` (`id`, `title`, `alias`, `image`, `duration`, `description`, `course_id`, `list_answers`, `published`, `access`, `language`, `ordering`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`, `quiz_type`) VALUES
(1, 'Question Set 1', 'question-set-1', 'images/demo/question/Question-demo.jpg', 130, '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>\r\n<ul>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n</ul>', 2, '{\"qes_title\":[\"What is the national animal of Canada?\",\"What do dragonflies prefer to eat?\",\"What is the result will be 4+4 ?\"],\"ans_one\":[\"North American beaver\",\"Mosquitoes\",\"4\"],\"ans_two\":[\"Golden eagle\",\"Hinny\",\"8\"],\"ans_three\":[\"Pekingese\",\"Fleas\",\"6\"],\"ans_four\":[\"Hives\",\"no one\",\"2\"],\"right_ans\":[\"0\",\"1\",\"1\"]}', 1, 1, '*', 1, 632, '2015-10-09 07:11:33', 632, '2015-10-09 09:34:24', 0, '0000-00-00 00:00:00', 0),
(2, 'Question Set 2', 'question-set-2', 'images/demo/question/Question-demo.jpg', 60, '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>\r\n<ul>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n</ul>', 2, '{\"qes_title\":[\"What is the correct HTML for adding a background color?\",\"Choose the correct HTML element to define important text\",\"What does CSS stand for?\",\"Inside which HTML element do we put the JavaScript?\"],\"ans_one\":[\"<body style=\\\"background-color:yellow;\\\">\",\"<important>\",\"Cascading Style Sheets\",\"<javascript>\"],\"ans_two\":[\"<background>yellow</background>\",\"<strong>\",\"Computer Style Sheets\",\" <js>\"],\"ans_three\":[\"<body bg=\\\"yellow\\\">\",\"<b>\",\"Creative Style Sheets\",\"<script>\"],\"ans_four\":[\"no one\",\"<i>\",\"Colorful Style Sheets\",\"<scripting>\"],\"right_ans\":[\"1\",\"0\",\"0\",\"2\"]}', 1, 1, '*', 2, 632, '2015-10-09 07:12:46', 322, '2016-02-22 12:16:12', 0, '0000-00-00 00:00:00', 1),
(7, 'Question Set 3', 'question-set-3', 'images/demo/question/Question-demo.jpg', 120, '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>\r\n<ul>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n</ul>', 3, '{\"qes_title\":[\"Bootstrap 3 is mobile-first.\",\"Which class provides a responsive fixed width container?\"],\"ans_one\":[\"False\",\".container\"],\"ans_two\":[\"True\",\".container-fluid\"],\"ans_three\":[\"\",\".container-fixed\"],\"ans_four\":[\"\",\"\"],\"right_ans\":[\"1\",\"0\"]}', 1, 1, '*', 3, 632, '2015-10-09 09:05:42', 632, '2015-10-09 09:34:24', 0, '0000-00-00 00:00:00', 0),
(8, 'Question Set 4', 'question-set-4', 'images/demo/question/Question-demo.jpg', 200, '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>\r\n<ul>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n</ul>', 1, '{\"qes_title\":[\"What does PHP stand for?\",\"Which HTML attribute is used to define inline styles?\",\"How do you insert a comment in a CSS file?\"],\"ans_one\":[\"Private Home Page\",\"style\",\"\' this is a comment\"],\"ans_two\":[\"PHP: Hypertext Preprocessor\",\"styles\",\"/* this is a comment */\"],\"ans_three\":[\"Personal Hypertext Processor\",\"class\",\"// this is a comment\"],\"ans_four\":[\"\",\"\",\"\"],\"right_ans\":[\"0\",\"0\",\"2\"]}', 1, 1, '*', 4, 632, '2015-10-09 09:24:01', 632, '2015-10-09 09:50:33', 0, '0000-00-00 00:00:00', 0),
(9, 'Question Set 5', 'question-set-5', 'images/demo/question/Question-demo.jpg', 180, '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>\r\n<ul>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n</ul>', 16, '{\"qes_title\":[\"What is the national animal of Canada?\",\"What do dragonflies prefer to eat?\",\"What is the result will be 4+4 ?\"],\"ans_one\":[\"North American beaver\",\"Mosquitoes\",\"4\"],\"ans_two\":[\"Golden eagle\",\"Hinny\",\"8\"],\"ans_three\":[\"Pekingese\",\"Fleas\",\"6\"],\"ans_four\":[\"Hives\",\"no one\",\"2\"],\"right_ans\":[\"0\",\"1\",\"1\"]}', 1, 1, '*', 0, 322, '2016-02-22 11:56:21', 322, '2016-02-22 12:15:23', 0, '0000-00-00 00:00:00', 1),
(10, 'Question Set 6', 'question-set-6', 'images/demo/question/Question-demo.jpg', 120, '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry’s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>\r\n<ul>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n<li>versions of Lorem Ipsum.</li>\r\n</ul>', 15, '{\"qes_title\":[\"What is the national animal of Canada?\",\"What do dragonflies prefer to eat?\",\"What is the result will be 4+4 ?\"],\"ans_one\":[\"North American beaver\",\"Mosquitoes\",\"4\"],\"ans_two\":[\"Golden eagle\",\"Hinny\",\"8\"],\"ans_three\":[\"Pekingese\",\"Fleas\",\"6\"],\"ans_four\":[\"Hives\",\"no one\",\"2\"],\"right_ans\":[\"0\",\"1\",\"1\"]}', 1, 1, '*', 0, 322, '2016-02-22 12:34:08', 322, '2016-02-22 12:34:35', 0, '0000-00-00 00:00:00', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_quizresults`
--

DROP TABLE IF EXISTS `#__splms_quizresults`;
CREATE TABLE `#__splms_quizresults` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `point` int(11) DEFAULT NULL,
  `total_marks` int(11) DEFAULT NULL,
  `user_id` text NOT NULL,
  `quizquestion_id` bigint(20) NOT NULL,
  `course_id` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_reviews`
--

DROP TABLE IF EXISTS `#__splms_reviews`;
CREATE TABLE `#__splms_reviews` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `course_id` int(11) DEFAULT NULL,
  `rating` tinyint(2) DEFAULT '0',
  `review` text,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_speakers`
--

DROP TABLE IF EXISTS `#__splms_speakers`;
CREATE TABLE `#__splms_speakers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(50) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `designation` varchar(50) DEFAULT '',
  `description` text,
  `image` varchar(255) DEFAULT '',
  `website` varchar(50) DEFAULT '',
  `email` varchar(100) DEFAULT '',
  `social_facebook` varchar(50) DEFAULT '',
  `social_twitter` varchar(50) DEFAULT '',
  `social_gplus` varchar(50) DEFAULT '',
  `social_linkedin` varchar(50) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_speakers`
--

INSERT INTO `#__splms_speakers` (`id`, `title`, `alias`, `designation`, `description`, `image`, `website`, `email`, `social_facebook`, `social_twitter`, `social_gplus`, `social_linkedin`, `published`, `access`, `language`, `ordering`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`) VALUES
(1, 'Kowshar Ahmed', 'kowshar-ahmed', 'CEO, JoomShaper', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>', 'images/demo/teachers/teacher3.jpg', 'http://joomshaper.com', 'install@joomshaper.com', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 0, 152, '2015-02-11 11:56:54', 152, '2015-03-18 11:32:59', 0, '0000-00-00 00:00:00'),
(2, 'Bucky Roberts', 'bucky-roberts', 'CEO, Creative Design Lab', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitationLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitationLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation</p>', 'images/demo/teachers/teacher8.jpg', 'http://joomshaper.com', 'install@joomshaper.com', 'rifat.alif', '#', '#', '#', 1, 1, '*', 0, 152, '2015-02-11 12:19:55', 84, '2015-03-23 11:26:00', 0, '0000-00-00 00:00:00'),
(3, 'Dorset Fetherston', 'dorset-fetherston', 'CEO, Creative Design Lab', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher1.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:15:42', 84, '2015-03-23 11:26:05', 0, '0000-00-00 00:00:00'),
(4, 'Rohan Le Rouzic', 'rohan-le-rouzic', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher2.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:16:59', 84, '2015-03-23 11:26:09', 0, '0000-00-00 00:00:00'),
(5, 'Sydell Bertaux', 'sydell-bertaux', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher3.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:41:47', 84, '2015-03-23 11:26:13', 0, '0000-00-00 00:00:00'),
(6, 'Bradford Esteve', 'bradford-esteve', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher4.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:55:05', 84, '2015-03-23 11:26:16', 0, '0000-00-00 00:00:00'),
(7, 'Whitman Thebaud', 'whitman-thebaud', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher5.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:55:34', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(8, 'Burg Saulnier', 'burg-saulnier', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher6.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:56:04', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(9, 'Blake Bart', 'blake-bart', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher7.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:56:33', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(10, 'Presley Blaxton', 'presley-blaxton', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher8.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:57:42', 152, '2015-03-03 11:58:02', 0, '0000-00-00 00:00:00'),
(11, 'Townley Dimond', 'townley-dimond', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher1.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 11:58:50', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(12, 'Currier Ausley', 'currier-ausley', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher2.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 12:00:04', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(13, 'Wesley Babin', 'wesley-babin', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher3.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 12:00:41', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(14, 'Barnet Auge', 'barnet-auge', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher4.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 12:01:12', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(15, 'Donavan Laborde', 'donavan-laborde', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher5.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 12:01:51', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00'),
(16, 'Spenser Vivier', 'spenser-vivier', 'CEO, ExampleSolution', '<p><span style=\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris nisi ut aliquip ex ea commodo consequat.</span></p>', 'images/demo/teachers/teacher6.jpg', 'http://www.example.com', 'install@joomshaper.com', '', '', '', '', 1, 1, '*', 0, 152, '2015-03-03 12:02:25', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_teachers`
--

DROP TABLE IF EXISTS `#__splms_teachers`;
CREATE TABLE `#__splms_teachers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `designation` varchar(55) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `image` varchar(255) DEFAULT '',
  `website` varchar(50) DEFAULT '',
  `email` varchar(100) DEFAULT '',
  `experience` varchar(255) NOT NULL,
  `specialist_in` text NOT NULL,
  `social_facebook` varchar(100) DEFAULT '',
  `social_twitter` varchar(100) DEFAULT '',
  `social_gplus` varchar(100) DEFAULT '',
  `social_linkedin` varchar(100) DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__splms_teachers`
--

INSERT INTO `#__splms_teachers` (`id`, `title`, `alias`, `designation`, `description`, `image`, `website`, `email`, `experience`, `specialist_in`, `social_facebook`, `social_twitter`, `social_gplus`, `social_linkedin`, `published`, `access`, `language`, `ordering`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`) VALUES
(1, 'Delly Anderson', 'devid-anderson', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher1.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'PHP, .NET', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 19, 152, '2015-02-11 09:06:21', 152, '2015-03-16 13:41:04', 0, '0000-00-00 00:00:00'),
(2, 'John Addison', 'john-addison', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher2.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'JAVA, C++', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 18, 152, '2015-02-13 12:14:24', 84, '2015-03-23 11:26:30', 0, '0000-00-00 00:00:00'),
(3, 'Alexia Corfield', 'alexia-corfield', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher3.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'HTML, CSS', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 17, 152, '2015-02-13 12:16:58', 84, '2015-03-23 11:26:33', 0, '0000-00-00 00:00:00'),
(4, 'Fedrik Edword', 'fedrik-edword', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher4.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'jQuery, Ajax', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 16, 152, '2015-02-13 12:19:02', 84, '2015-03-23 11:26:36', 0, '0000-00-00 00:00:00'),
(5, 'Magyar Dora', 'magyar-dora', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher5.jpg', 'http://www.example.com', 'install@joomshaper.com', '2 Years', 'APL, DCl', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 15, 152, '2015-02-19 07:13:07', 84, '2015-03-23 11:26:39', 0, '0000-00-00 00:00:00'),
(6, 'Smitt Vivien', 'smitt-vivien', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher6.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'ActionScript', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 14, 152, '2015-02-19 07:15:12', 84, '2015-03-23 11:26:41', 0, '0000-00-00 00:00:00'),
(7, 'Carmelo Russo', 'carmelo-russo', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher7.jpg', 'http://www.example.com', 'install@joomshaper.com', '15 Years', 'Python, Ruby, ASP.NET', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 13, 152, '2015-02-19 07:16:47', 152, '2015-03-16 13:41:04', 0, '0000-00-00 00:00:00'),
(8, 'J. Castaneda', 'j-castaneda', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher8.jpg', 'http://www.example.com', 'install@joomshaper.com', '2 Years', 'C++, C Sharp', 'rifat.alif', '@rifat3280', 'rifart3280', 'jonhnin', 1, 1, '*', 12, 152, '2015-02-19 07:18:24', 152, '2015-03-16 13:41:04', 0, '0000-00-00 00:00:00'),
(9, 'Aadhira Lunette', 'aadhira-lunette', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher1.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'HTML, CSS', '', '', '', '', 1, 1, '*', 11, 152, '2015-03-03 06:54:00', 152, '2015-03-16 13:41:04', 0, '0000-00-00 00:00:00'),
(10, 'Wandie Maelee', 'wandie-maelee', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher2.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'JAVA, PHOTOSHOP', '', '', '', '', 1, 1, '*', 10, 152, '2015-03-03 06:54:47', 152, '2015-03-16 13:41:04', 0, '0000-00-00 00:00:00'),
(11, 'Agatha Felicity', 'agatha-felicity', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher3.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'PHP, .NET', '', '', '', '', 1, 1, '*', 9, 152, '2015-03-03 06:55:28', 152, '2015-03-16 13:41:04', 0, '0000-00-00 00:00:00'),
(13, 'Dietrich Marius', 'dietrich-marius', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher4.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'HTML, CSS', '', '', '', '', 1, 1, '*', 8, 152, '2015-03-03 07:23:15', 152, '2015-03-16 13:41:04', 0, '0000-00-00 00:00:00'),
(14, 'Kennedy Ibrahim', 'kennedy-ibrahim', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher9.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'HTML, CSS', '', '', '', '', 1, 1, '*', 7, 152, '2015-03-03 07:23:55', 49, '2015-03-20 08:01:23', 0, '0000-00-00 00:00:00'),
(15, 'Jacob Durwood', 'jacob-durwood', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher9.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'JAVA, PHOTOSHOP', '', '', '', '', 1, 1, '*', 6, 152, '2015-03-03 07:29:06', 49, '2015-03-20 08:01:36', 0, '0000-00-00 00:00:00'),
(16, 'Onfroi Adriel', 'onfroi-adriel', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher9.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'PHP, .NET', '', '', '', '', 1, 1, '*', 5, 152, '2015-03-03 07:30:07', 49, '2015-03-20 08:01:47', 0, '0000-00-00 00:00:00'),
(17, 'Windemuth Tancred', 'windemuth-tancred', '', '<p>Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami.</p>', 'images/demo/teachers/teacher9.jpg', 'http://www.example.com', 'install@joomshaper.com', '3 Years', 'JAVA, PHOTOSHOP', '', '', '', '', 1, 1, '*', 4, 152, '2015-03-03 07:30:58', 49, '2015-03-20 08:01:58', 0, '0000-00-00 00:00:00'),
(18, 'Steve Anderson', 'steve-anderson', '', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. </p>', 'images/demo/teachers/teacher9.jpg', 'http://www.example.com', 'geek@joomshaper.com', '2 Years', 'HTML, CSS', 'joomshaper', 'joomshaper', 'joomshaper', 'joomshaper', 1, 1, '*', 2, 152, '2015-03-16 13:32:46', 49, '2015-03-20 08:02:08', 0, '0000-00-00 00:00:00'),
(19, 'Scot Device', 'scot-device', '', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. </p>', 'images/demo/teachers/teacher9.jpg', 'http://www.example.com', 'geek@joomshaper.com', '3 Years', 'PHP, .NET, JAVA, PHOTOSHOP', 'joomshaper', 'joomshaper', 'joomshaper', 'joomshaper', 1, 1, '*', 1, 152, '2015-03-16 13:35:05', 49, '2015-03-20 08:02:19', 0, '0000-00-00 00:00:00'),
(20, ' Anthony Alien', 'anthony-alien', '', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip.</p>', 'images/demo/teachers/teacher9.jpg', 'http://www.example.com', 'geek@joomshaper.com', '3 Years', 'Joomla, Wordpress, PHP, HTML, JavaScript', 'joomshaper', 'joomshaper', 'joomshaper', 'joomshaper', 1, 1, '*', 3, 152, '2015-03-16 13:36:19', 49, '2015-03-20 08:02:30', 0, '0000-00-00 00:00:00'),
(21, 'Brandan White', 'brandan-white', '', '<p>Bacon ipsum dolor amet tongue hamburger shank jowl tenderloin, ham short loin swine pork belly. Kielbasa turducken short ribs, landjaeger pancetta venison corned beef tail. Chuck corned beef prosciutto pork loin jowl, frankfurter tongue shank bresaola. Beef ribs corned beef ground round ball tip. </p>', 'images/demo/teachers/teacher9.jpg', 'http://www.example.com', 'geek@joomshaper.com', '4 Years', 'Joomla, Wordpress, PHP, HTML, JavaScript', 'joomshaper', 'joomshaper', 'joomshaper', 'joomshaper', 1, 1, '*', 0, 152, '2015-03-16 13:43:30', 49, '2015-03-20 08:02:39', 0, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__splms_useritems`
--

DROP TABLE IF EXISTS `#__splms_useritems`;
CREATE TABLE `#__splms_useritems` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `item_id` int(11) DEFAULT '0',
  `user_id` int(11) DEFAULT NULL,
  `item_type` varchar(55) DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__spmedia`
--

DROP TABLE IF EXISTS `#__spmedia`;
CREATE TABLE `#__spmedia` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `alt` varchar(255) NOT NULL,
  `caption` varchar(2048) NOT NULL,
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `extension` varchar(100) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder`
--

DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `asset_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL,
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `og_title` varchar(255) NOT NULL,
  `og_image` varchar(255) NOT NULL,
  `og_description` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__sppagebuilder`
--

INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(1, 312, 'Home', '[{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":\"0 0 30px 0\",\"padding\":\"110px 0 0 0\",\"class\":\"main-header bg-color-overlay\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_image\":\"images/demo/slide-banner.jpg\",\"color\":\"#ffffff\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":16,\"subtitle\":\"Phasellus consectetur, nisi at congue mattis, enim libero tempor nisl, et posuere neque lit Nam placerat. \",\"title_margin_bottom\":0,\"title_margin_top\":0,\"title_text_color\":\"#ffffff\",\"title_fontweight\":700,\"title_fontsize\":60,\"heading_selector\":\"h1\",\"title\":\"Search Your Courses\"},\"id\":1487139218,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1487139219,\"addons\":[{\"type\":\"\",\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1487139220,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"module_type\":\"module\",\"id\":\"122\",\"position\":\"\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1487139221,\"settings\":{\"admin_label\":\"\",\"gap\":\"120\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"featured_courses\",\"title\":\"Featured Courses\",\"id\":1487139222,\"settings\":{\"title\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":\"100px 0 50px\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris <br />\\nnisi ut aliquip ex ea commodo consequat. \",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"#000000\",\"title_fontweight\":700,\"title_fontsize\":30,\"title\":\"POPULAR TOPICS & COURSES\",\"title_position\":\"sppb-text-center\",\"heading_selector\":\"h2\"},\"id\":1487139223,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"20px 0 0\",\"color\":\"\",\"background\":\"\"},\"id\":1487139224,\"addons\":[{\"type\":\"\",\"name\":\"course_categories\",\"title\":\"Course Categories\",\"id\":1487139225,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"25\",\"title_lineheight\":\"35px\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"rgba(230, 129, 129, 1)\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"30\",\"limit\":\"12\",\"category_type\":\"\",\"columns\":\"4\",\"show_icon\":\"1\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":0,\"no_gutter\":0,\"id\":\"\",\"class\":\"call-action-more bg-color-overlay\",\"padding\":{\"md\":\"60px 0px 60px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#ffffff\",\"background_color\":\"\",\"background_image\":\"images/demo/new-course-bg.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1487139226,\"columns_align_center\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1487139226,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1487139227,\"addons\":[{\"type\":\"\",\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1487139228,\"settings\":{\"admin_label\":\"\",\"title\":\"Our new Course Start, January 2015\",\"heading_selector\":\"h1\",\"title_fontsize\":\"36\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"700\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"5\",\"subtitle\":\"Etiam porta sem malesuada magna mollis euismod.\",\"subtitle_fontsize\":\"14\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"button_text\":\"Learn More\",\"button_fontstyle\":null,\"button_letterspace\":\"0\",\"button_url\":\"#\",\"button_target\":\"\",\"button_position\":\"right\",\"button_type\":\"primary\",\"button_appearance\":\"\",\"button_background_color\":\"#444444\",\"button_color\":\"#ffffff\",\"button_background_color_hover\":\"#222222\",\"button_color_hover\":\"#ffffff\",\"button_size\":\"lg\",\"button_shape\":\"rounded\",\"button_block\":\"\",\"button_icon\":\"\",\"icon_position\":\"left\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"0\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null,\"instFormId\":1487139228},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"POPULAR TOPICS & COURSES\",\"heading_selector\":\"h2\",\"title_fontsize\":30,\"title_fontweight\":700,\"title_text_color\":\"#000000\",\"title_margin_top\":0,\"title_margin_bottom\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor<br/> incididunt ut labore et dolore.\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":0,\"margin\":\"100px 0\",\"fullscreen\":0},\"id\":1487139229,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"20px 0 0\",\"color\":\"\",\"background\":\"\"},\"id\":1487139230,\"addons\":[{\"type\":\"\",\"name\":\"courses\",\"title\":\"Courses\",\"id\":1487139231,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"course_type\":\"\",\"columns\":\"3\",\"limit\":\"6\",\"layout\":\"default\",\"show_all\":\"1\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"fullscreen\":0,\"margin\":{\"md\":\"80px 0 80px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"80px 0 80px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"total-counter bg-color-overlay\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_attachment\":\"fixed\",\"background_image\":\"images/counter-bg.jpg\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"title_fontweight\":\"\",\"instFormId\":1487139232,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1487139232,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" counters\"},\"id\":1487139233,\"addons\":[{\"type\":\"\",\"name\":\"icon\",\"title\":\"Icon\",\"id\":1487139234,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-book\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1487139235,\"settings\":{\"admin_label\":\"\",\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1487139236,\"settings\":{\"admin_label\":\"\",\"number\":\"2546\",\"duration\":\"1000\",\"font_size\":\"45\",\"color\":\"#ffffff\",\"counter_title\":\"Total Course\",\"title_font_size\":\"16\",\"alignment\":\"sppb-text-center\",\"class\":\"animated-number\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" counters\"},\"id\":1487139237,\"addons\":[{\"type\":\"\",\"name\":\"icon\",\"title\":\"Icon\",\"id\":1487139238,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-group\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1487139239,\"settings\":{\"admin_label\":\"\",\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1487139240,\"settings\":{\"admin_label\":\"\",\"number\":\"8674\",\"duration\":\"1000\",\"font_size\":\"45\",\"color\":\"#ffffff\",\"counter_title\":\"Total Member\",\"title_font_size\":\"16\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" counters\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1487139241,\"addons\":[{\"type\":\"\",\"name\":\"icon\",\"title\":\"Icon\",\"id\":1487139242,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-graduation-cap\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1487139243,\"settings\":{\"admin_label\":\"\",\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1487139244,\"settings\":{\"admin_label\":\"\",\"number\":\"546\",\"duration\":\"1000\",\"font_size\":\"45\",\"color\":\"#ffffff\",\"counter_title\":\"Free Tutorials\",\"title_font_size\":\"16\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" counters\"},\"id\":1487139245,\"addons\":[{\"type\":\"\",\"name\":\"icon\",\"title\":\"Icon\",\"id\":1487139246,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-user\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1487139247,\"settings\":{\"admin_label\":\"\",\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"type\":\"\",\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1487139248,\"settings\":{\"admin_label\":\"\",\"number\":\"389\",\"duration\":\"1000\",\"font_size\":\"45\",\"color\":\"#ffffff\",\"counter_title\":\"Best Teacher\",\"title_font_size\":\"16\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"TRY OUR FREE COURSES\",\"heading_selector\":\"h3\",\"title_fontsize\":30,\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor<br/> incididunt ut labore et dolore.\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"100px 0 100px 0\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"title_fontweight\":700,\"instFormId\":1487139249,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1487139249,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"20px 0 0\",\"color\":\"\",\"background\":\"\"},\"id\":1487139250,\"addons\":[{\"type\":\"\",\"name\":\"courses\",\"title\":\"Courses\",\"id\":1487139251,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"course_type\":\"free\",\"columns\":\"3\",\"limit\":\"3\",\"layout\":\"default\",\"show_all\":\"1\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"call-action-signup bg-color-overlay\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_attachment\":\"fixed\",\"background_image\":\"images/demo/online-skill-bg.jpg\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"instFormId\":1487139252,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1487139252,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{\"instFormId\":1487139253,\"items_align_center\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0},\"id\":1487139253,\"addons\":[{\"type\":\"\",\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1487139254,\"settings\":{\"admin_label\":\"\",\"title\":\"your place to learn real world skills online\",\"heading_selector\":\"h3\",\"title_fontsize\":\"36\",\"title_fontweight\":\"700\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation. Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"subtitle_fontsize\":\"14\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"75\",\"button_text\":\"Sign Up\",\"button_url\":\"3\",\"button_size\":\"lg\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"class\":\"\",\"instFormId\":1487139254,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_text_color\":\"#ffffff\",\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 776, '2018-02-22 06:50:03', 776, 0, '0000-00-00 00:00:00', '', '', '', '*', 1232, ''),
(6, 0, 'Portfolio', '[{\"type\":\"sp_row\",\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":\"\",\"padding\":\"200px 0\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"50% 50%\",\"background_attachment\":\"inherit\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"images/featured-bg2.jpg\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h1\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInUp\",\"animationduration\":500,\"animationdelay\":300,\"class\":\"\"},\"attr\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"atts\":{\"title\":\"LEARNING MANAGEMENT SYSTEM\",\"heading_selector\":\"h2\",\"title_fontsize\":\"72\",\"title_fontweight\":\"700\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore <br/> Eiusmod tempor incididunt ut labore et dolore\",\"subtitle_fontsize\":\"18\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Download Now!\",\"button_url\":\"http://www.joomshaper.com/helix\",\"button_size\":\"lg\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"_blank\",\"button_position\":\"bottom\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"#f5f5f5\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"70px 0  5px\",\"margin\":\"0px\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":300,\"animationdelay\":100,\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Fully Responsive\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-laptop\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":500,\"animationdelay\":200,\"class\":\"\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Unique Design\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-dashboard\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":500,\"animationdelay\":300,\"class\":\"\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Easy to Customize\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-gear\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":500,\"animationdelay\":400,\"class\":\"\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Awesome Support\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-envelope\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"3333\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"#f5f5f5\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"50px 0  100px\",\"margin\":\"0px 0px 100px\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":300,\"animationdelay\":100,\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Page Builder\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-arrows\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":500,\"animationdelay\":200,\"class\":\"\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Mega Menu\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-list\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":500,\"animationdelay\":300,\"class\":\"\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Layout Builder\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-check-square-o\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"fadeInDown\",\"animationduration\":500,\"animationdelay\":400,\"class\":\"\"},\"attr\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"atts\":{\"title\":\"Google Font\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-google\",\"icon_size\":\"42\",\"icon_color\":\"\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"0\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Sirloin pork loine beefb andoe uillen capicola shank swine chuck flank tritip picola kevin filet mignon\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"settings\":{\"title\":\"Showcase\",\"heading_selector\":\"h2\",\"title_fontsize\":36,\"title_text_color\":\"#333333\",\"title_margin_top\":0,\"title_margin_bottom\":20,\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip\\n\\n\\n\\n\\n\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"100px 0px 0px\",\"fullscreen\":1},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"module\",\"title\":\"Joomla Module\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"id\":\"107\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":\"0px \",\"padding\":\"100px 0\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"#f5f5f5\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"zoomIn\",\"animationduration\":300,\"animationdelay\":300,\"class\":\"\"},\"attr\":[{\"name\":\"testimonialpro\",\"title\":\"Testimonial Pro\",\"atts\":{\"title\":\"\",\"class\":\"\"},\"scontent\":[{\"type\":\"repeatable\",\"name\":\"sp_testimonialpro_item\",\"atts\":{\"title\":\"Jony Daku\",\"avatar\":\"images/testimonial.png\",\"avatar_style\":\"sppb-img-circle\",\"message\":\"Helix is a Awesome Framework for Joomla. It’s able me to easily customize the Joomla Templates Thanks to Helix Team. Really Appreciate it.\",\"url\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_testimonialpro_item\",\"atts\":{\"title\":\"Michel Cattar\",\"avatar\":\"images/testimonial.png\",\"avatar_style\":\"sppb-img-circle\",\"message\":\"Helix is a Awesome Framework for Joomla. It’s able me to easily customize the Joomla Templates Thanks to Helix Team. Really Appreciate it.\",\"url\":\"\"}},{\"type\":\"repeatable\",\"name\":\"sp_testimonialpro_item\",\"atts\":{\"title\":\"Nanchel Culy\",\"avatar\":\"images/testimonial.png\",\"avatar_style\":\"sppb-img-circle\",\"message\":\"Helix is a Awesome Framework for Joomla. It’s able me to easily customize the Joomla Templates Thanks to Helix Team. Really Appreciate it.\",\"url\":\"\"}}]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"settings\":{\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"images/cta-bg.jpg\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"100px 0\",\"margin\":\"0px\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"zoomIn\",\"animationduration\":400,\"animationdelay\":300,\"class\":\"\"},\"attr\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"atts\":{\"title\":\"Ready to our latest creation Helix III\",\"heading_selector\":\"h2\",\"title_fontsize\":\"36\",\"title_fontweight\":\"\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Download Now!\",\"button_url\":\"http://www.joomshaper.com/helix\",\"button_size\":\"lg\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"_blank\",\"button_position\":\"bottom\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 391, '2015-03-05 11:10:47', 152, 0, '0000-00-00 00:00:00', '', '', '', '*', 0, ''),
(7, 0, 'Contact-1', '[{\"type\":\"sp_row\",\"layout\":\"66\",\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\",\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"atts\":{\"title\":\"Varsita\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#767676\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"\",\"html\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse ornare, ipsum quis aliquam lobortis, felis sapien rutrum risus, posuere ultrices quam nisi nec nulla.\\n<div class=\\\"pull-left info-part-left\\\">\\n        <br>\\n\\t<h4>Admission</h4>\\n\\t<p>Email: example@gmail.com</p>\\n\\t<p>Address: 123 Main Street, Chicago, USA</p>\\n\\t<p>Telephone: 0123 456 789</p>\\n       <br>\\n\\t<h4>Schollership Info</h4>\\n\\t<p>Email: example@gmail.com</p>\\n\\t<p>Address: 123 Main Street, Chicago, USA</p>\\n\\t<p>Telephone: 0123 456 789</p>\\n</div>\\n<div class=\\\"pull-right info-part-right\\\">\\n      <br>\\n\\t<h4>Library</h4>\\n\\t<p>Email: example@gmail.com</p>\\n\\t<p>Address: 123 Main Street, Chicago, USA</p>\\n\\t<p>Telephone: 0123 456 789</p>\\n\\t<p> </p><br>\\n\\t<h4>Internation Student</h4>\\n\\t<p>Email: example@gmail.com</p>\\n\\t<p>Address: 123 Main Street, Chicago, USA</p>\\n\\t<p>Telephone: 0123 456 789</p>\\n</div>\",\"class\":\"contact-info\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"gmap\",\"title\":\"Google Map\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"map\":\"40.7324319, -73.82480799999996\",\"height\":\"392\",\"type\":\"HYBRID\",\"zoom\":\"18\",\"mousescroll\":\"true\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":12,\"settings\":{},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{},\"attr\":[{\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"atts\":{\"title\":\"Leave your Message\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"500\",\"title_text_color\":\"#676767\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":\"1\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"class\":\" contact-from\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-02-10 05:08:14', 152, '2015-03-06 06:13:57', 152, 0, '0000-00-00 00:00:00', '', '', '', '*', 18, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(8, 315, 'Contact-2', '[{\"layout\":12,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"fullscreen\":0,\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1523010031,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"id\":1523010032,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010033,\"settings\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"gmap\",\"title\":\"Google Map\",\"id\":1523010034,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"map\":\"40.7324319, -73.82480799999996\",\"height\":\"465\",\"type\":\"ROADMAP\",\"zoom\":\"18\",\"mousescroll\":\"true\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title_fontweight\":\"\",\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"contact-info\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":0},\"id\":1523010035,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1523010036,\"addons\":[{\"name\":\"custom_text\",\"title\":\"Custom Text\",\"id\":1523010037,\"settings\":{\"title\":\"Varsita\",\"title_font_size\":\"24\",\"title_padding_bottom\":\"\",\"custom_layout\":\"ctlw\",\"custom_image\":\"images/demo/contact-1.png\",\"custom_image_padding\":\"\",\"custom_text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse ornare, ipsum quis aliquam lobortis, felis sapien rutrum risus, posuere ultrices quam nisi nec nulla. Vestibulum ipsum diam, congue in nunc et, placerat faucibus nunc. Proin consectetur mauris quis tincidunt faucibus. Suspendisse lobortis blandit aliquet.</p>\\n<br />\\n<h4>Help Desk</h4>\\n<p>Address: 123 Main Street, Chicago, USA</p>\\n<p>Email: example@gmail.com</p>\\n<p>Telephone: 0123 456 789</p>\",\"link_url\":\"\",\"button_text\":\"\",\"class\":\" contact-info-img\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010038,\"settings\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\" feature-contact2\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":0},\"id\":1523010039,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1523010040,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1523010041,\"settings\":{\"title\":\"Admission\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_text_color\":\"#767676\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-graduation-cap\",\"icon_size\":\"24\",\"icon_color\":\"#998675\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Email: <a href=\\\"mailto:example@gmail.com\\\">example@gmail.com<br /></a>Address: 123 Main Street, Chicago, USA<br />Telephone: 0123 456 789\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010042,\"settings\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1523010043,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1523010044,\"settings\":{\"title\":\"Library\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_text_color\":\"#767676\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-book\",\"icon_size\":\"24\",\"icon_color\":\"#998675\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Email: <a href=\\\"mailto:example@gmail.com\\\">example@gmail.com<br /></a>Address: 123 Main Street, Chicago, USA<br />Telephone: 0123 456 789\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010045,\"settings\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1523010046,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1523010047,\"settings\":{\"title\":\"Scolarship\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_text_color\":\"#767676\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-trophy\",\"icon_size\":\"24\",\"icon_color\":\"#998675\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Email: <a href=\\\"mailto:example@gmail.com\\\">example@gmail.com<br /></a>Address: 123 Main Street, Chicago, USA<br />Telephone: 0123 456 789\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010048,\"settings\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1523010049,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1523010050,\"settings\":{\"title\":\"Student\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_text_color\":\"#767676\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-globe\",\"icon_size\":\"24\",\"icon_color\":\"#998675\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Email: <a href=\\\"mailto:example@gmail.com\\\">example@gmail.com<br /></a>Address: 123 Main Street, Chicago, USA<br />Telephone: 0123 456 789\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010051,\"settings\":{\"gap\":\"70\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{},\"id\":1523010052,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1523010053,\"addons\":[{\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"id\":1523010054,\"settings\":{\"title\":\"Leave Your Message here\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"500\",\"title_text_color\":\"#676767\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":\"1\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"class\":\" contact-from\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010055,\"settings\":{\"gap\":\"35\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-02-10 05:22:49', 776, '2018-04-06 10:30:07', 776, 0, '0000-00-00 00:00:00', '', '', '', '*', 10, ''),
(9, 316, 'Contact-3', '[{\"layout\":12,\"settings\":{},\"id\":1523010611,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1523010612,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010613,\"settings\":{\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,8\",\"settings\":{\"fullscreen\":0,\"margin\":\"0px\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_position\":\"0 0\",\"background_attachment\":\"fixed\",\"background_size\":\"cover\",\"background_repeat\":\"no-repeat\",\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"heading_selector\":\"h3\",\"title\":\"\"},\"id\":1523010614,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"#998675\",\"color\":\"#ffffff\",\"padding\":{\"md\":\"30px 30px 30px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\" feature-contact3\",\"items_align_center\":0,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"use_border\":0},\"id\":1523010615,\"addons\":[{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1523010616,\"settings\":{\"title\":\"Admission\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_fontweight\":\"\",\"title_text_color\":\"#ffffff\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-graduation-cap\",\"icon_size\":\"24\",\"icon_color\":\"#ffffff\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text\":\"Email: <a href=\\\"mailto:example@gmail.com\\\">example@gmail.com<br /></a>Address: 123 Main Street, Chicago,<br />USA Telephone: 0123 456 789\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010617,\"settings\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1523010618,\"settings\":{\"title\":\"Admission\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_fontweight\":\"\",\"title_text_color\":\"#ffffff\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-book\",\"icon_size\":\"24\",\"icon_color\":\"#ffffff\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Email: <a href=\\\"mailto:example@gmail.com\\\">example@gmail.com<br /></a>Address: 123 Main Street, Chicago,<br />USA Telephone: 0123 456 789\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010619,\"settings\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1523010620,\"settings\":{\"title\":\"Admission\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_fontweight\":\"\",\"title_text_color\":\"#ffffff\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-trophy\",\"icon_size\":\"24\",\"icon_color\":\"#ffffff\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Email: <a href=\\\"mailto:example@gmail.com\\\">example@gmail.com<br /></a>Address: 123 Main Street, Chicago,<br />USA Telephone: 0123 456 789\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010621,\"settings\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"feature\",\"title\":\"Feature Box\",\"id\":1523010622,\"settings\":{\"title\":\"Admission\",\"heading_selector\":\"h4\",\"title_fontsize\":\"18\",\"title_fontweight\":\"\",\"title_text_color\":\"#ffffff\",\"title_position\":\"after\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-globe\",\"icon_size\":\"24\",\"icon_color\":\"#ffffff\",\"icon_background\":\"\",\"icon_border_color\":\"\",\"icon_border_width\":\"\",\"icon_border_radius\":\"\",\"icon_margin_top\":\"\",\"icon_margin_bottom\":\"\",\"icon_padding\":\"\",\"text\":\"Email: <a href=\\\"mailto:example@gmail.com\\\">example@gmail.com<br /></a>Address: 123 Main Street, Chicago,<br />USA Telephone: 0123 456 789\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-8 active-column-parent\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" map-contact3\"},\"id\":1523010623,\"addons\":[{\"name\":\"gmap\",\"title\":\"Google Map\",\"id\":1523010624,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"map\":\"40.7324319, -73.82480799999996\",\"height\":{\"md\":\"676\",\"sm\":\"\",\"xs\":\"\"},\"type\":\"SATELLITE\",\"zoom\":\"18\",\"mousescroll\":\"true\",\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"30px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1523010625,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1523010626,\"addons\":[{\"name\":\"ajax_contact\",\"title\":\"Contact Form\",\"id\":1523010627,\"settings\":{\"title\":\"Leave Your Message\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"500\",\"title_text_color\":\"#676767\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"recipient_email\":\"email@yourdomain.com\",\"formcaptcha\":\"1\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"class\":\" contact-from\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523010628,\"settings\":{\"gap\":\"40\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-02-10 06:00:26', 776, '2018-04-06 10:35:12', 776, 0, '0000-00-00 00:00:00', '', '', '', '*', 12, ''),
(10, 310, 'Home - University', '[{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"1\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\" shaper-varsita-slider\",\"padding\":\"\",\"margin\":\"0 0 10px 0\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"id\":1488272380,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1488272381,\"addons\":[{\"name\":\"slideshow\",\"title\":\"Slideshow\",\"id\":1488272382,\"settings\":{\"admin_label\":\"\",\"autoplay\":\"0\",\"controllers\":\"0\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"\",\"height\":\"500\",\"class\":\"versita-slideshow-main-wrapper\",\"sp_slideshow_item\":[{\"title\":\"Discover\",\"sub_title\":\"Your Intelligence\",\"content\":\"\\t\\t\\t\\t\\t\\tPhasellus consectetur, nisi at congue mattis, enim libero tempor nisl, et posuere neque lit Nam placerat.\",\"bg\":\"images/demo/slideshow/slider-1.jpg\",\"image\":\"\",\"video\":\"\",\"button_text\":\"Apply Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"fa-edit\",\"button_after_icon\":\"fa-long-arrow-right\"},{\"title\":\"Carouse\",\"sub_title\":\"Intelligence Your\",\"content\":\"\\t\\t\\t\\t\\t\\tPhasellus consectetur, nisi at congue mattis, enim libero tempor nisl, et posuere neque lit Nam placerat.\",\"bg\":\"images/demo/slideshow/slider-2.jpg\",\"image\":\"\",\"video\":\"\",\"button_text\":\"Apply Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"fa-edit\",\"button_after_icon\":\"fa-long-arrow-right\"},{\"title\":\"Learn As\",\"sub_title\":\" If you were to live forever\",\"content\":\"\\t\\t\\t\\t\\t\\tPhasellus consectetur, nisi at congue mattis, enim libero tempor nisl, et posuere neque lit Nam placerat.\",\"bg\":\"images/demo/slideshow/slider-3.jpg\",\"image\":\"\",\"video\":\"\",\"button_text\":\"Apply Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"fa-edit\",\"button_after_icon\":\"fa-long-arrow-right\"},{\"title\":\"You can\",\"sub_title\":\"Never be overdressed\",\"content\":\"\\t\\t\\t\\t\\t\\tPhasellus consectetur, nisi at congue mattis, enim libero tempor nisl, et posuere neque lit Nam placerat.\",\"bg\":\"images/demo/slideshow/slider-4.jpg\",\"image\":\"\",\"video\":\"\",\"button_text\":\"Apply Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"default\",\"button_before_icon\":\"fa-edit\",\"button_after_icon\":\"fa-long-arrow-right\"}],\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"fullscreen\":0,\"margin\":\"0 0 30px 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontsize\":\"\",\"title\":\"\"},\"id\":1488272383,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1488272384,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488272385,\"settings\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"upcoming_events\",\"title\":\"Upcoming Events\",\"id\":1488272386,\"settings\":{\"admin_label\":\"\",\"title\":\"Our\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Upcoming Events\",\"limit\":\"12\",\"layout\":\"carousel\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,8\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"admission-part\",\"padding\":\"\",\"margin\":\"0 0 30px 0\",\"fullscreen\":0,\"title_fontweight\":\"\"},\"id\":1488272387,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-8\",\"settings\":{\"class\":\" border-global left-part\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1488272388,\"addons\":[{\"name\":\"custom_text\",\"title\":\"Custom Text\",\"id\":1488272389,\"settings\":{\"title\":\" Welcome to Wieldstrem University\",\"title_font_size\":\"24\",\"title_padding_bottom\":\"25\",\"custom_layout\":\"ctlw\",\"custom_image\":\"images/demo/welcome-university.png\",\"custom_image_padding\":\"\",\"custom_text\":\"Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Nulla quidem illo suscipit nihil!Lorem ipsum dolor sit amet, consectetur adipisicing elit fugit repellat\",\"link_url\":\"#\",\"button_text\":\"More info\",\"class\":\"\",\"instFormId\":1488272389,\"heading_selector\":\"h3\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" border-global right-part\"},\"id\":1488272390,\"addons\":[{\"name\":\"quick_admission\",\"title\":\"Quick Admission\",\"id\":1488272391,\"settings\":{\"admin_label\":\"\",\"title\":\"Admission Now\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"20\",\"qa_image\":\"images/demo/admission-now.png\",\"qa_image_padding\":\"0 10px 10px 0\",\"degree\":\"Undergraduate\",\"cource\":\"BSc. in Computer Science\",\"duration\":\"4 year\",\"qa_description\":\"\\tLorem ipsum dolor sit amet, consectetur adipiscing elit. Proin ut odio tellus. Maecenas\",\"link_url\":\"#\",\"button_text\":\"Apply Online\",\"class\":\" admission-now\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"call-action-more bg-color-overlay\",\"padding\":\"30px 0 30px 0\",\"margin\":\"0 0 30px 0\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/demo/about-subheader.jpg\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"id\":1488272392,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{},\"id\":1488272393,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1488272394,\"settings\":{\"title\":\"Our new Course Start, January 2015\",\"heading_selector\":\"h1\",\"title_fontsize\":\"36\",\"title_fontweight\":\"\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"0\",\"title_margin_bottom\":\"5\",\"subtitle\":\"Etiam porta sem malesuada magna mollis euismod.\",\"subtitle_fontsize\":\"14\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"0\",\"button_text\":\"Learn More\",\"button_url\":\"#\",\"button_size\":\"lg\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"title_fontweight\":\"\",\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"some-information\",\"padding\":\"\",\"margin\":\"0 0 30px 0\",\"fullscreen\":0},\"id\":1488272395,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" border-global video-details\"},\"id\":1488272396,\"addons\":[{\"name\":\"video\",\"title\":\"Video\",\"id\":1488272397,\"settings\":{\"title\":\"University Spot Light\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#767676\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"url\":\"https://www.youtube.com/watch?v=U6FvJ6jMGHU\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488272398,\"settings\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488272399,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Incidunt.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" border-global testimonial\"},\"id\":1488272400,\"addons\":[{\"name\":\"testimonial\",\"title\":\"Testimonials\",\"id\":1488272401,\"settings\":{\"title\":\"Graduates Testimonial\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#767676\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"review\":\"Inventore, aliquam sequi magnam accusamus\",\"name\":\"John Doe\",\"company\":\"\",\"avatar\":\"images/demo/testimonial/testimonial-1.png\",\"avatar_width\":\"72\",\"avatar_position\":\"left\",\"link\":\"http://www.joomshaper.com\",\"link_target\":\"\",\"class\":\"\",\"instFormId\":1488272401,\"show_quote\":0,\"alignment\":\"sppb-text-left\",\"avatar_shape\":\"sppb-avatar-sqaure\"},\"visibility\":1},{\"name\":\"testimonial\",\"title\":\"Testimonials\",\"id\":1488272402,\"settings\":{\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"review\":\"Inventore, aliquam sequi magnam accusamus\",\"name\":\"John Doe\",\"company\":\"\",\"avatar\":\"images/demo/testimonial/testimonial-2.png\",\"avatar_width\":\"72\",\"avatar_position\":\"left\",\"link\":\"http://www.joomshaper.com\",\"link_target\":\"\",\"class\":\"\",\"instFormId\":1488272402,\"show_quote\":0,\"avatar_shape\":\"sppb-avatar-sqaure\",\"alignment\":\"sppb-text-left\"},\"visibility\":1},{\"name\":\"testimonial\",\"title\":\"Testimonials\",\"id\":1488272403,\"settings\":{\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"review\":\"Inventore, aliquam sequi magnam accusamus\",\"name\":\"John Doe\",\"company\":\"\",\"avatar\":\"images/demo/testimonial/testimonial-3.png\",\"avatar_width\":\"72\",\"avatar_position\":\"left\",\"link\":\"http://www.joomshaper.com\",\"link_target\":\"\",\"class\":\"\",\"instFormId\":1488272403,\"show_quote\":0,\"avatar_shape\":\"sppb-avatar-sqaure\",\"alignment\":\"sppb-text-left\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"class\":\" border-global\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1488272404,\"addons\":[{\"name\":\"custom_text\",\"title\":\"Custom Text\",\"id\":1488272405,\"settings\":{\"title\":\"Scholarship\",\"title_font_size\":\"\",\"title_padding_bottom\":\"25\",\"custom_layout\":\"ctlb\",\"custom_image\":\"images/demo/scholarship.png\",\"custom_image_padding\":\"0 10px 10px 0\",\"custom_text\":\"Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball.\",\"link_url\":\"#\",\"button_text\":\"More info\",\"class\":\" scholarship-info\",\"instFormId\":1488272405,\"heading_selector\":\"h3\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"6,6\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"newsletter-section\",\"padding\":\"\",\"margin\":\"0 0 30px 0\",\"fullscreen\":0,\"title_fontweight\":\"\"},\"id\":1488272406,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"#767676\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" border-global newsletter\"},\"id\":1488272407,\"addons\":[{\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1488272408,\"settings\":{\"title\":\"Newsletter\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#767676\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"id\":\"110\",\"class\":\" \"},\"visibility\":1}],\"visibility\":true},{\"class_name\":\"col-sm-6\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" border-global twitter-feed\"},\"id\":1488272409,\"addons\":[{\"name\":\"tweet\",\"title\":\"Twitter Feed\",\"id\":1488272410,\"settings\":{\"title\":\"Twitter Feed\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#767676\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"username\":\"joomshaper\",\"consumerkey\":\"\",\"consumersecret\":\"\",\"accesstoken\":\"\",\"accesstokensecret\":\"\",\"include_rts\":\"false\",\"ignore_replies\":\"false\",\"show_username\":\"0\",\"show_avatar\":\"1\",\"count\":\"3\",\"autoplay\":\"1\",\"class\":\"\",\"dynamicId\":1488272410},\"visibility\":1}],\"visibility\":true}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"heading_selector\":\"h3\",\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"0 0 0px 0\",\"fullscreen\":0,\"title_position\":\"sppb-text-left\",\"title_fontweight\":\"\"},\"id\":1488272411,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1488272412,\"addons\":[{\"name\":\"courses\",\"title\":\"Courses\",\"id\":1488272413,\"settings\":{\"title\":\"Latest Courses\",\"subtitle\":\"\",\"course_type\":\"\",\"columns\":\"3\",\"limit\":\"12\",\"layout\":\"carousel\",\"show_all\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488272414,\"settings\":{\"gap\":\"50\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 776, '2018-04-05 12:21:11', 776, 0, '0000-00-00 00:00:00', '', '', '', '*', 376, ''),
(11, 0, 'About Us', '[{\"type\":\"sp_row\",\"layout\":12,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"0 0 30px 0\",\"fullscreen\":0},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":300,\"animationdelay\":0,\"class\":\"\"},\"attr\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/demo/about.jpg\",\"position\":\"sppb-text-center\",\"link\":\"#\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"atts\":{\"title\":\"Introduction & History\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"25\",\"title_margin_bottom\":\"\",\"html\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.\\n\\nPellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>\",\"class\":\"\"},\"scontent\":[]}]}]},{\"type\":\"sp_row\",\"layout\":\"66\",\"settings\":{},\"attr\":[{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{\"sortableitem\":\"[object Object]\"},\"attr\":[{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/demo/about2.jpg\",\"position\":\"sppb-text-left\",\"link\":\"#\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"atts\":{\"title\":\"Mission\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"html\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci.</p>\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]},{\"type\":\"sp_col\",\"class_name\":\"column-parent col-sm-6\",\"settings\":{},\"attr\":[{\"name\":\"image\",\"title\":\"Image\",\"atts\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/demo/about3.jpg\",\"position\":\"sppb-text-left\",\"link\":\"#\",\"target\":\"\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"atts\":{\"title\":\"Vision\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"html\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci.</p>\",\"class\":\"\"},\"scontent\":[]},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"atts\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"scontent\":[]}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-02-13 07:19:23', 152, '2015-02-17 07:25:41', 152, 0, '0000-00-00 00:00:00', '', '', '', '*', 22, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(12, 314, 'About Us-2', '[{\"layout\":\"6,6\",\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":\"\"},\"id\":1523008623,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-6\",\"settings\":{\"class\":\"\",\"animationdelay\":0,\"animationduration\":300,\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1523008624,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008625,\"settings\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1523008626,\"settings\":{\"title\":\"About Us\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"text\":\"We don’t like making life more complicated than it already is, so we believe in keeping things simple. Chimp Studio works with simple efficiency.Our team knows how important it is to get the results needed to build your business. Chimp Studio offers an unequalled breadth of service in all advertising and design disciplines.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008627,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"image\",\"title\":\"Image\",\"id\":1523008628,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/demo/about4.png\",\"position\":\"sppb-text-center\",\"link\":\"http://\",\"target\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008629,\"settings\":{\"gap\":\"45\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-6\",\"settings\":{},\"id\":1523008630,\"addons\":[{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008631,\"settings\":{\"gap\":\"80\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1523008632,\"settings\":{\"title\":\"Why Choose Us\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"text\":\"We don’t like making life more complicated than it already is, so we believe in keeping things simple. Chimp Studio works with simple efficiency.Our team knows how important it is to get the results needed to build your business. Chimp Studio offers an unequalled breadth of service in all advertising and design disciplines.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008633,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1523008634,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"90\",\"text\":\"Development\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1523008635,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"80\",\"text\":\"Design\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1523008636,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"70\",\"text\":\"Marketing\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1523008637,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"80\",\"text\":\"Production\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1523008638,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"85\",\"text\":\"Html\",\"stripped\":\"\",\"active\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"progress_bar\",\"title\":\"Progress Bar\",\"id\":1523008639,\"settings\":{\"type\":\"sppb-progress-bar-primary\",\"progress\":\"85\",\"text\":\"HRM\",\"stripped\":\"\",\"active\":\"active\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008640,\"settings\":{\"gap\":\"45\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{},\"id\":1523008641,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{},\"id\":1523008642,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1523008643,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/demo/about5.png\",\"position\":\"sppb-text-left\",\"link\":\"#\",\"target\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008644,\"settings\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1523008645,\"settings\":{\"title\":\"History\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"text\":\"Advertising and design disciplines. We have been established as a web studio based in London for over 10 years and our bright ideas are still as fresh as ever!So if you think it’s time to reinvent yourself or you are just starting out, why not see what happens.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{},\"id\":1523008646,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1523008647,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/demo/about6.png\",\"position\":\"sppb-text-left\",\"link\":\"#\",\"target\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008648,\"settings\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1523008649,\"settings\":{\"title\":\"Mission\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"text\":\"Advertising and design disciplines. We have been established as a web studio based in London for over 10 years and our bright ideas are still as fresh as ever!So if you think it’s time to reinvent yourself or you are just starting out, why not see what happens.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{},\"id\":1523008650,\"addons\":[{\"name\":\"image\",\"title\":\"Image\",\"id\":1523008651,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"image\":\"images/demo/about7.png\",\"position\":\"sppb-text-left\",\"link\":\"#\",\"target\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1523008652,\"settings\":{\"gap\":\"30\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"text_block\",\"title\":\"Text Block\",\"id\":1523008653,\"settings\":{\"title\":\"Vision\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"text\":\"Advertising and design disciplines. We have been established as a web studio based in London for over 10 years and our bright ideas are still as fresh as ever!So if you think it’s time to reinvent yourself or you are just starting out, why not see what happens.\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"fullscreen\":0,\"margin\":{\"md\":\"30px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"all-arthurs\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"\",\"title_fontweight\":\"\",\"title_fontsize\":\"\",\"title\":\"\",\"columns_align_center\":0,\"no_gutter\":0,\"show_top_shape\":0,\"show_bottom_shape\":0},\"id\":1523008654,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1523008655,\"addons\":[{\"name\":\"person\",\"title\":\"Person\",\"id\":1523008656,\"settings\":{\"image\":\"images/demo/team/team1.png\",\"name\":\"Arthur Singer\",\"designation\":\"CEO & Founder\",\"introtext\":\"Chimp Studio offers an unequalled breadth of service\\n\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"http://twitter.com/joomshaper\",\"google_plus\":\"http://plus.google.com/+Joomshapers\",\"youtube\":\"#\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"social_position\":\"after\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1523008657,\"addons\":[{\"name\":\"person\",\"title\":\"Person\",\"id\":1523008658,\"settings\":{\"image\":\"images/demo/team/team2.png\",\"name\":\"Arthur Singer\",\"designation\":\"CEO & Founder\",\"introtext\":\"Chimp Studio offers an unequalled breadth of service\\n\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"http://twitter.com/joomshaper\",\"google_plus\":\"http://plus.google.com/+Joomshapers\",\"youtube\":\"#\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"social_position\":\"after\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1523008659,\"addons\":[{\"name\":\"person\",\"title\":\"Person\",\"id\":1523008660,\"settings\":{\"image\":\"images/demo/team/team3.png\",\"name\":\"Arthur Singer\",\"designation\":\"CEO & Founder\",\"introtext\":\"Chimp Studio offers an unequalled breadth of service\\n\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"http://twitter.com/joomshaper\",\"google_plus\":\"http://plus.google.com/+Joomshapers\",\"youtube\":\"#\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"social_position\":\"after\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{},\"id\":1523008661,\"addons\":[{\"name\":\"person\",\"title\":\"Person\",\"id\":1523008662,\"settings\":{\"image\":\"images/demo/team/team4.png\",\"name\":\"Arthur Singer\",\"designation\":\"CEO & Founder\",\"introtext\":\"Chimp Studio offers an unequalled breadth of service\\n\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"http://twitter.com/joomshaper\",\"google_plus\":\"http://plus.google.com/+Joomshapers\",\"youtube\":\"#\",\"linkedin\":\"\",\"pinterest\":\"\",\"flickr\":\"\",\"dribbble\":\"\",\"behance\":\"\",\"instagram\":\"\",\"social_position\":\"after\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-02-13 07:51:05', 776, '2018-04-06 10:17:21', 776, 0, '0000-00-00 00:00:00', '', '', '', '*', 53, ''),
(13, 311, 'Home-3', '[{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"0 0 30px 0\",\"fullscreen\":1},\"id\":1488351611,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1488351612,\"addons\":[{\"name\":\"slideshow_full\",\"title\":\"Slideshow (Full Width)\",\"id\":1488351613,\"settings\":{\"admin_label\":\"\",\"autoplay\":\"1\",\"controllers\":\"0\",\"arrows\":\"1\",\"background\":\"\",\"color\":\"\",\"class\":\"\",\"sp_slideshow_full_item\":[{\"title\":\"Discover\",\"sub_title\":\"Your Intelligence\",\"content\":\"\\tPhasellus consectetur, nisi at congue mattis, enim libero tempor nisl, et posuere neque lit Nam placerat.\",\"bg\":\"images/demo/slideshow/slider-2.jpg\",\"image\":\"\",\"video\":\"\",\"button_text\":\"Apply Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"link\",\"button_before_icon\":\"fa-edit\",\"button_after_icon\":\"fa-long-arrow-right\"},{\"title\":\"Carouse\",\"sub_title\":\"Intelligence Your\",\"content\":\"\\tPhasellus consectetur, nisi at congue mattis, enim libero tempor nisl, et posuere neque lit Nam placerat.\",\"bg\":\"images/demo/slideshow/slider-4.jpg\",\"image\":\"\",\"video\":\"\",\"button_text\":\"Apply Now\",\"button_url\":\"#\",\"button_size\":\"\",\"button_type\":\"link\",\"button_before_icon\":\"fa-edit\",\"button_after_icon\":\"fa-long-arrow-right\"}],\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title_position\":\"sppb-text-center\",\"heading_selector\":\"h2\",\"fullscreen\":0,\"margin\":\"100px 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"subtitle_fontsize\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur et dignissim\",\"title_margin_bottom\":10,\"title_margin_top\":0,\"title_text_color\":\"#000000\",\"title_fontweight\":700,\"title_fontsize\":30,\"title\":\"CHECK OUT LATEST EVENT\"},\"id\":1488351614,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"20px 0 0\",\"color\":\"\",\"background\":\"\"},\"id\":1488351615,\"addons\":[{\"name\":\"upcoming_events\",\"title\":\"Upcoming Events\",\"id\":1488351616,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"limit\":\"6\",\"layout\":\"honeycomb\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"#937f6e\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\" admission-features bg-color-overlay\",\"padding\":\"80px 0\",\"margin\":\"100px 0\",\"fullscreen\":0},\"id\":1488351617,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"#ffffff\",\"padding\":\"0 30px\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1488351618,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1488351619,\"settings\":{\"name\":\"fa-graduation-cap\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351620,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>Recent</p>\\n<h3>Admission Info</h3>\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351621,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"#ffffff\",\"padding\":\"0 30px\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1488351622,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1488351623,\"settings\":{\"name\":\"fa-bullhorn\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351624,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>Recent</p>\\n<h3>Admission Info</h3>\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351625,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"#ffffff\",\"padding\":\"0 30px\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1488351626,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1488351627,\"settings\":{\"name\":\"fa-group\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351628,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>Recent</p>\\n<h3>Admission Info</h3>\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351629,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"0 30px\",\"color\":\"#ffffff\",\"background\":\"\"},\"id\":1488351630,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1488351631,\"settings\":{\"name\":\"fa-flask\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351632,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>Recent</p>\\n<h3>Admission Info</h3>\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351633,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"4,4,4\",\"settings\":{\"title_fontweight\":\"\",\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"some-information\",\"padding\":\"\",\"margin\":\"100px 0\",\"fullscreen\":0},\"id\":1488351634,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" border-global video-details\"},\"id\":1488351635,\"addons\":[{\"name\":\"video\",\"title\":\"Video\",\"id\":1488351636,\"settings\":{\"title\":\"University Spot Light\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#767676\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"url\":\"https://www.youtube.com/watch?v=U6FvJ6jMGHU\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488351637,\"settings\":{\"gap\":\"20\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"raw_html\",\"title\":\"Raw HTML\",\"id\":1488351638,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"html\":\"<p>Inventore, aliquam sequi nisi velit magnam accusamus reprehenderit nemo necessitatibus doloribus molestiae fugit repellat repudiandae dolor. Incidunt.</p>\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" border-global testimonial\"},\"id\":1488351639,\"addons\":[{\"name\":\"testimonial\",\"title\":\"Testimonials\",\"id\":1488351640,\"settings\":{\"title\":\"Graduates Testimonial\",\"heading_selector\":\"h3\",\"title_fontsize\":\"24\",\"title_fontweight\":\"\",\"title_text_color\":\"#767676\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"25\",\"review\":\"Inventore, aliquam sequi magnam accusamus\",\"name\":\"John Doe\",\"company\":\"\",\"avatar\":\"images/demo/testimonial/testimonial-1.png\",\"avatar_width\":\"72\",\"avatar_position\":\"left\",\"link\":\"http://www.joomshaper.com\",\"link_target\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"testimonial\",\"title\":\"Testimonials\",\"id\":1488351641,\"settings\":{\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"review\":\"Inventore, aliquam sequi magnam accusamus\",\"name\":\"John Doe\",\"company\":\"\",\"avatar\":\"images/demo/testimonial/testimonial-2.png\",\"avatar_width\":\"72\",\"avatar_position\":\"left\",\"link\":\"http://www.joomshaper.com\",\"link_target\":\"\",\"class\":\"\"},\"visibility\":1},{\"name\":\"testimonial\",\"title\":\"Testimonials\",\"id\":1488351642,\"settings\":{\"title\":\"\",\"heading_selector\":\"h1\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"review\":\"Inventore, aliquam sequi magnam accusamus\",\"name\":\"John Doe\",\"company\":\"\",\"avatar\":\"images/demo/testimonial/testimonial-3.png\",\"avatar_width\":\"72\",\"avatar_position\":\"left\",\"link\":\"http://www.joomshaper.com\",\"link_target\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-4\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" border-global\"},\"id\":1488351643,\"addons\":[{\"name\":\"custom_text\",\"title\":\"Custom Text\",\"id\":1488351644,\"settings\":{\"title\":\"Scholarship\",\"title_font_size\":\"\",\"title_padding_bottom\":\"25\",\"custom_layout\":\"ctlb\",\"custom_image\":\"images/demo/scholarship.png\",\"custom_image_padding\":\"0 10px 10px 0\",\"custom_text\":\"Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball.\",\"link_url\":\"#\",\"button_text\":\"More info\",\"class\":\" scholarship-info\",\"instFormId\":1488351644,\"heading_selector\":\"h3\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_equal_height\":\"0\",\"fullscreen\":\"0\",\"no_gutter\":\"0\",\"id\":\"\",\"class\":\"call-action-more bg-color-overlay\",\"padding\":\"50px 0 30px 0\",\"margin\":\"100px 0\",\"color\":\"\",\"background_color\":\"\",\"background_image\":\"images/demo/about-subheader.png\",\"overlay\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animation\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"id\":1488351645,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{},\"id\":1488351646,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1488351647,\"settings\":{\"title\":\"Our new Course Start, January 2015\",\"heading_selector\":\"h1\",\"title_fontsize\":\"36\",\"title_fontweight\":\"\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Etiam porta sem malesuada magna mollis euismod.\",\"subtitle_fontsize\":\"14\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Learn More\",\"button_url\":\"#\",\"button_size\":\"lg\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"POPULAR TOPICS & COURSES\",\"heading_selector\":\"h3\",\"title_fontsize\":30,\"title_fontweight\":700,\"title_text_color\":\"#000000\",\"title_margin_top\":0,\"title_margin_bottom\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris <br/>nisi ut aliquip ex ea commodo consequat.\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"100px 0\",\"fullscreen\":0,\"title_position\":\"sppb-text-center\"},\"id\":1488351648,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"20px 0 0\",\"color\":\"\",\"background\":\"\"},\"id\":1488351649,\"addons\":[{\"name\":\"courses\",\"title\":\"Courses\",\"id\":1488351650,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"course_type\":\"free\",\"columns\":\"3\",\"limit\":\"3\",\"layout\":\"default\",\"show_all\":\"1\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 776, '2018-02-20 07:30:42', 776, 0, '0000-00-00 00:00:00', '', '', '', '*', 124, '');
INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(14, 0, 'Header Transparent', '[{\"layout\":12,\"settings\":{\"title\":\"Search Your Courses\",\"heading_selector\":\"h1\",\"title_fontsize\":72,\"title_fontweight\":700,\"title_text_color\":\"#ffffff\",\"title_margin_top\":0,\"title_margin_bottom\":0,\"subtitle\":\"Phasellus consectetur, nisi at congue mattis, enim libero tempor nisl, et <br> posuere neque lit Nam placerat. \",\"subtitle_fontsize\":16,\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"#ffffff\",\"background_image\":\"images/demo/slideshow/slider-2.jpg\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"main-header bg-color-overlay\",\"padding\":\"210px 0 0 0\",\"margin\":\"0 0 30px 0\",\"fullscreen\":0},\"id\":1488368638,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1488368639,\"addons\":[{\"name\":\"module\",\"title\":\"Joomla Module\",\"id\":1488368640,\"settings\":{\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"id\":\"122\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488368641,\"settings\":{\"gap\":\"120\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"featured_courses\",\"title\":\"Featured Courses\",\"id\":1488368642,\"settings\":{\"title\":\"\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"heading_selector\":\"h2\",\"title_position\":\"sppb-text-center\",\"title\":\"POPULAR TOPICS & COURSES\",\"title_fontsize\":30,\"title_fontweight\":700,\"title_text_color\":\"#000000\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor ullamco laboris <br />\\nnisi ut aliquip ex ea commodo consequat. \",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":\"\",\"margin\":\"100px 0 50px\",\"fullscreen\":0},\"id\":1488368643,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"20px 0 0\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1488368644,\"addons\":[{\"name\":\"course_categories\",\"title\":\"Course Categories\",\"id\":1488368645,\"settings\":{\"title\":\"\",\"limit\":\"\",\"category_type\":\"\",\"columns\":\"4\",\"show_icon\":\"1\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"images/demo/new-course-bg.jpg\",\"background_attachment\":\"fixed\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"call-action-more bg-color-overlay\",\"padding\":\"60px 0px\",\"margin\":\"0 0 30px 0\",\"fullscreen\":0},\"id\":1488368646,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{},\"id\":1488368647,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1488368648,\"settings\":{\"title\":\"Our new Course Start, January 2015\",\"heading_selector\":\"h1\",\"title_fontsize\":\"36\",\"title_fontweight\":\"700\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"5\",\"subtitle\":\"Etiam porta sem malesuada magna mollis euismod.\",\"subtitle_fontsize\":\"14\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"button_text\":\"Learn More\",\"button_url\":\"#\",\"button_size\":\"lg\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"right\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"POPULAR TOPICS & COURSES\",\"heading_selector\":\"h2\",\"title_fontsize\":30,\"title_fontweight\":700,\"title_text_color\":\"#000000\",\"title_margin_top\":0,\"title_margin_bottom\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor<br/> incididunt ut labore et dolore.\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"\",\"padding\":0,\"margin\":\"100px 0\",\"fullscreen\":0},\"id\":1488368639450,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"class\":\"\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"20px 0 0\",\"color\":\"\",\"background\":\"\"},\"id\":1487139230,\"addons\":[{\"type\":\"\",\"name\":\"courses\",\"title\":\"Courses\",\"id\":1487139231,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"course_type\":\"\",\"columns\":\"3\",\"limit\":\"6\",\"layout\":\"default\",\"show_all\":\"1\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":\"3,3,3,3\",\"settings\":{\"title_fontweight\":\"\",\"title\":\"\",\"title_fontsize\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"images/counter-bg.jpg\",\"background_attachment\":\"fixed\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"total-counter bg-color-overlay\",\"padding\":\"80px 0\",\"margin\":\"80px 0 80px 0\",\"fullscreen\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\"},\"id\":1488368652,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" counters\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1488368653,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1488368654,\"settings\":{\"name\":\"fa-book\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488368655,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1488368656,\"settings\":{\"admin_label\":\"\",\"number\":\"2546\",\"duration\":\"1000\",\"font_size\":\"45\",\"color\":\"#ffffff\",\"counter_title\":\"Total Course\",\"title_font_size\":\"16\",\"alignment\":\"sppb-text-center\",\"class\":\"animated-number\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" counters\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1488368657,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1488368658,\"settings\":{\"name\":\"fa-group\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488368659,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1488368660,\"settings\":{\"admin_label\":\"\",\"number\":\"8674\",\"duration\":\"1000\",\"font_size\":\"45\",\"color\":\"#ffffff\",\"counter_title\":\"Total Member\",\"title_font_size\":\"16\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\" counters\"},\"id\":1488368661,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1488368662,\"settings\":{\"name\":\"fa-graduation-cap\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488368663,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1488368664,\"settings\":{\"admin_label\":\"\",\"number\":\"546\",\"duration\":\"1000\",\"font_size\":\"45\",\"color\":\"#ffffff\",\"counter_title\":\"Free Tutorials\",\"title_font_size\":\"16\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1},{\"class_name\":\"col-sm-3\",\"settings\":{\"class\":\" counters\",\"animationdelay\":\"\",\"animationduration\":\"\",\"animation\":\"\",\"padding\":\"\",\"color\":\"\",\"background\":\"\"},\"id\":1488368665,\"addons\":[{\"name\":\"icon\",\"title\":\"Icon\",\"id\":1488368666,\"settings\":{\"name\":\"fa-user\",\"size\":\"36\",\"color\":\"#ffffff\",\"background\":\"\",\"border_color\":\"\",\"border_width\":\"\",\"border_radius\":\"\",\"margin_top\":\"\",\"margin_bottom\":\"\",\"padding\":\"\",\"alignment\":\"sppb-text-center\",\"class\":\"\"},\"visibility\":1},{\"name\":\"empty_space\",\"title\":\"Empty Space\",\"id\":1488368667,\"settings\":{\"gap\":\"25\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"class\":\"\"},\"visibility\":1},{\"name\":\"animated_number\",\"title\":\"Animated Number\",\"id\":1488368668,\"settings\":{\"admin_label\":\"\",\"number\":\"389\",\"duration\":\"1000\",\"font_size\":\"45\",\"color\":\"#ffffff\",\"counter_title\":\"Best Teacher\",\"title_font_size\":\"16\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_text_color\":\"rgba(255, 255, 255, 1)\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title_fontweight\":700,\"fullscreen\":0,\"margin\":\"100px 0\",\"padding\":\"\",\"class\":\"\",\"id\":\"\",\"background_video_ogv\":\"\",\"background_video_mp4\":\"\",\"background_video\":0,\"background_image\":\"\",\"color\":\"\",\"background_color\":\"\",\"title_position\":\"sppb-text-center\",\"subtitle_fontsize\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor<br/> incididunt ut labore et dolore.\",\"title_margin_bottom\":\"\",\"title_margin_top\":\"\",\"title_text_color\":\"#000000\",\"title_fontsize\":30,\"heading_selector\":\"h3\",\"title\":\"TRY OUR FREE COURSES\"},\"id\":1488368669,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12\",\"settings\":{\"background\":\"\",\"color\":\"\",\"padding\":\"20px 0 0\",\"animation\":\"\",\"animationduration\":\"\",\"animationdelay\":\"\",\"class\":\"\"},\"id\":1488368670,\"addons\":[{\"name\":\"courses\",\"title\":\"Courses\",\"id\":1488368671,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_fontstyle\":null,\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"course_type\":\"free\",\"columns\":\"3\",\"limit\":\"3\",\"layout\":\"default\",\"show_all\":\"1\",\"class\":\"\",\"global_text_color\":\"\",\"global_link_color\":\"\",\"global_link_hover_color\":\"\",\"global_use_background\":\"0\",\"global_background_color\":\"\",\"global_background_image\":\"\",\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":\"0\",\"global_border_width\":\"\",\"global_border_color\":\"\",\"global_boder_style\":\"none\",\"global_border_radius\":\"\",\"global_margin\":\"\",\"global_padding\":\"\",\"global_use_animation\":\"0\",\"global_animation\":\"\",\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":null},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"},{\"layout\":12,\"settings\":{\"title\":\"\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_text_color\":\"\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"\",\"subtitle_fontsize\":\"\",\"background_color\":\"\",\"color\":\"\",\"background_image\":\"images/demo/online-skill-bg.jpg\",\"background_attachment\":\"fixed\",\"background_video\":0,\"background_video_mp4\":\"\",\"background_video_ogv\":\"\",\"id\":\"\",\"class\":\"call-action-signup bg-color-overlay\",\"padding\":\"\",\"margin\":\"\",\"fullscreen\":0},\"id\":1488368672,\"visibility\":1,\"columns\":[{\"class_name\":\"col-sm-12 active-column-parent\",\"settings\":{},\"id\":1488368673,\"addons\":[{\"name\":\"call_to_action\",\"title\":\"Call to Action\",\"id\":1488368674,\"settings\":{\"title\":\"your place to learn real world skills online\",\"heading_selector\":\"h3\",\"title_fontsize\":\"36\",\"title_fontweight\":\"700\",\"title_text_color\":\"#ffffff\",\"title_margin_top\":\"\",\"title_margin_bottom\":\"\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation. Lorem ipsum dolor sit amet, consectetur adipisicing elit\",\"subtitle_fontsize\":\"14\",\"subtitle_text_color\":\"#ffffff\",\"text\":\"\",\"background\":\"\",\"color\":\"\",\"padding\":\"75\",\"button_text\":\"Sign Up\",\"button_url\":\"3\",\"button_size\":\"lg\",\"button_type\":\"primary\",\"button_icon\":\"\",\"button_block\":\"\",\"button_target\":\"\",\"button_position\":\"bottom\",\"class\":\"\"},\"visibility\":1}],\"visibility\":1}],\"collapse\":\"\",\"title\":\"Row\"}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2015-01-22 07:12:35', 221, '2017-03-01 11:50:00', 221, 0, '0000-00-00 00:00:00', '', '', '', '*', 44, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder_addons`
--

DROP TABLE IF EXISTS `#__sppagebuilder_addons`;
CREATE TABLE `#__sppagebuilder_addons` (
  `id` int(5) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `code` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder_integrations`
--

DROP TABLE IF EXISTS `#__sppagebuilder_integrations`;
CREATE TABLE `#__sppagebuilder_integrations` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `component` varchar(255) NOT NULL,
  `plugin` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder_languages`
--

DROP TABLE IF EXISTS `#__sppagebuilder_languages`;
CREATE TABLE `#__sppagebuilder_languages` (
  `id` int(5) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `lang_tag` varchar(255) NOT NULL DEFAULT '',
  `lang_key` varchar(100) DEFAULT NULL,
  `version` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder_sections`
--

DROP TABLE IF EXISTS `#__sppagebuilder_sections`;
CREATE TABLE `#__sppagebuilder_sections` (
  `id` int(5) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `section` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__spsimpleportfolio_items`
--

DROP TABLE IF EXISTS `#__spsimpleportfolio_items`;
CREATE TABLE `#__spsimpleportfolio_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(55) NOT NULL,
  `catid` int(11) NOT NULL,
  `image` text NOT NULL,
  `video` text NOT NULL,
  `description` mediumtext,
  `client` varchar(100) NOT NULL,
  `tagids` text NOT NULL,
  `url` text NOT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `language` varchar(255) NOT NULL DEFAULT '*',
  `access` int(5) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__spsimpleportfolio_items`
--

INSERT INTO `#__spsimpleportfolio_items` (`id`, `title`, `alias`, `catid`, `image`, `video`, `description`, `client`, `tagids`, `url`, `published`, `language`, `access`, `ordering`, `created_by`, `created`, `modified_by`, `modified`, `checked_out`, `checked_out_time`) VALUES
(1, 'Responsive news Template', 'responsive-news-template', 0, 'images/showcase/showcase01.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"4\"]', '', 1, '*', 1, 0, 391, '2015-01-22 12:04:57', 49, '2015-03-20 08:55:03', 966, '2016-06-02 09:29:03'),
(2, 'Free Joomla Template', 'free-joomla-template', 0, 'images/showcase/showcase02.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"1\"]', '', 1, '*', 1, 0, 391, '2015-01-22 12:05:55', 49, '2015-03-20 08:55:16', 49, '2015-03-20 08:55:17'),
(3, 'Helix Free Template', 'helix-free-template', 0, 'images/showcase/showcase03.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"1\"]', '', 1, '*', 1, 0, 391, '2015-01-22 12:06:32', 49, '2015-03-20 08:55:18', 49, '2015-03-20 08:55:18'),
(4, 'Corporate Template', 'corporate-template', 0, 'images/showcase/showcase04.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"3\"]', '', 1, '*', 1, 0, 391, '2015-01-22 12:07:01', 49, '2015-03-20 08:55:20', 49, '2015-03-20 08:55:20'),
(5, 'SP Page Builder', 'sp-page-builder', 0, 'images/showcase/showcase05.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"2\"]', '', 1, '*', 1, 0, 391, '2015-01-22 12:07:30', 49, '2015-03-20 08:55:22', 49, '2015-03-20 08:55:22'),
(6, 'Organic Life Template', 'organic-life-template', 0, 'images/showcase/showcase06.jpg', '', '<p>Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p>Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami. Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball.</p>\r\n<p>Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"1\"]', '', 1, '*', 1, 0, 391, '2015-01-23 10:06:10', 49, '2015-03-20 08:55:23', 49, '2015-03-20 08:55:24'),
(7, 'Helix V3 Free Template', 'helix-v3-free-template', 0, 'images/showcase/showcase07.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"2\"]', '', 1, '*', 1, 0, 391, '2015-01-23 10:07:16', 49, '2015-03-20 08:55:25', 49, '2015-03-20 08:55:26'),
(8, 'Optima Premium Template', 'optima-premium-template', 0, 'images/showcase/showcase08.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"2\"]', '', 1, '*', 1, 0, 391, '2015-01-23 10:08:10', 49, '2015-03-20 08:55:28', 49, '2015-03-20 08:55:28'),
(9, 'Vocal Music Theme', 'vocal-music-theme', 0, 'images/showcase/showcase09.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"4\"]', '', 1, '*', 1, 0, 391, '2015-01-23 10:08:46', 49, '2015-03-20 08:55:59', 0, '0000-00-00 00:00:00'),
(10, 'Travel Premium Theme', 'travel-premium-theme', 0, 'images/showcase/showcase10.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"1\"]', '', 1, '*', 1, 0, 391, '2015-01-23 10:09:23', 49, '2015-03-20 08:56:01', 0, '0000-00-00 00:00:00'),
(11, 'Free Magazine Theme', 'free-magazine-theme', 0, 'images/showcase/showcase11.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"4\"]', '', 1, '*', 1, 0, 391, '2015-01-23 10:09:59', 49, '2015-03-20 08:56:21', 49, '2015-03-20 08:56:21'),
(12, 'Minima Joomla Template', 'minima-joomla-template', 0, 'images/showcase/showcase12.jpg', '', '<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Bacon ipsum dolor amet pork belly turducken strip steak meatloaf short ribs corned beef. Sausage landjaeger frankfurter leberkas chicken. Ball tip short loin picanha cow sausage. Short loin swine sausage, shank tail ham ball tip jerky boudin.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Sirloin pork loin beef andouille capicola shank swine chuck flank tri-tip. Capicola kevin filet mignon porchetta doner short ribs flank. Capicola pork chop turducken, ground round shoulder ribeye cupim doner jowl. Turkey shank pork belly jerky salami.</p>\r\n<p style=\"border: 0px; margin: 0px 0px 24px; padding: 0px; vertical-align: baseline; font-family: Georgia, \'Bitstream Charter\', serif; font-size: 16px; line-height: 24px; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: 0px 0px; background-repeat: initial;\">Chicken kevin pastrami tenderloin, tail corned beef prosciutto sirloin ribeye beef ribs pork chop tri-tip swine meatball. Pork chop swine porchetta fatback, strip steak filet mignon ham beef chicken meatloaf. Drumstick spare ribs corned beef, cow andouille cupim shankle pork beef ribs bacon flank salami leberkas. Shank turducken t-bone corned beef ground round shoulder cow beef ribs leberkas ribeye pork venison kevin meatloaf landjaeger. Ball tip jowl tongue venison. Ground round cow pork loin, sirloin venison cupim ham hock hamburger.</p>', '', '[\"1\"]', '', 1, '*', 1, 0, 391, '2015-01-23 10:10:38', 49, '2015-03-20 08:56:02', 0, '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__spsimpleportfolio_tags`
--

DROP TABLE IF EXISTS `#__spsimpleportfolio_tags`;
CREATE TABLE `#__spsimpleportfolio_tags` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(55) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__spsimpleportfolio_tags`
--

INSERT INTO `#__spsimpleportfolio_tags` (`id`, `title`, `alias`) VALUES
(1, 'Joomla', 'joomla'),
(2, 'Responsive', 'responsive'),
(3, 'Corporate', 'corporate'),
(4, 'Magazine', 'magazine');

-- --------------------------------------------------------

--
-- Table structure for table `#__tags`
--

DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE `#__tags` (
  `id` int(10) UNSIGNED NOT NULL,
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__tags`
--

INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES
(1, 0, 0, 23, 0, '', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 776, '2018-02-20 05:55:40', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, 1, 1, 2, 1, 'joomla34', 'Joomla 3.4', 'joomla34', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 776, '2018-02-20 05:55:40', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"0\":\"{\\\"urla\\\":\\\"\\\"}\"}', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(3, 1, 3, 4, 1, 'helix3', 'Helix3', 'helix3', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 776, '2018-02-20 05:55:40', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"0\":\"{\\\"urla\\\":\\\"\\\"}\"}', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(4, 1, 5, 6, 1, 'varsita', 'Varsita', 'varsita', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\",\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(5, 1, 7, 8, 1, 'helix-ii', 'Helix-ii', 'helix-ii', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\",\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(6, 1, 9, 10, 1, 'joomshaper', 'Joomshaper', 'joomshaper', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\",\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(7, 1, 11, 12, 1, 'themeum', 'Themeum', 'themeum', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\",\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(8, 1, 13, 14, 1, 'shapebootstrap', 'ShapeBootstrap', 'shapebootstrap', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\",\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(9, 1, 15, 16, 1, 'wordpress', 'Wordpress', 'wordpress', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\",\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(10, 1, 17, 18, 1, 'university', 'University', 'university', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\",\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(11, 1, 19, 20, 1, 'school', 'school', 'school', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 776, '2018-02-20 05:55:40', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"0\":\"{\\\"urla\\\":\\\"\\\"}\"}', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(12, 1, 21, 22, 1, 'lms', 'LMS', 'lms', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"label label-info\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 776, '2018-02-20 05:55:40', '', 776, '2018-02-20 05:55:40', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"0\":\"{\\\"urla\\\":\\\"\\\"}\"}', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__template_styles`
--

DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE `#__template_styles` (
  `id` int(10) UNSIGNED NOT NULL,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__template_styles`
--

INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`) VALUES
(4, 'beez3', 0, '0', 'Beez3 - Fruit Shop', '{\"wrapperSmall\":53,\"wrapperLarge\":72,\"logo\":\"\",\"sitetitle\":\"Fruit Shop\",\"sitedescription\":\"The freshest fruit for you\",\"navposition\":\"left\",\"bootstrap\":\"\",\"templatecolor\":\"red\",\"headerImage\":\"\",\"backgroundcolor\":\"#eee\"}'),
(5, 'hathor', 1, '0', 'Hathor - Default', '{\"showSiteName\":\"0\",\"colourChoice\":\"\",\"boldText\":\"0\"}'),
(7, 'protostar', 0, '0', 'protostar - Default', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}'),
(8, 'isis', 1, '1', 'isis - Default', '{\"templateColor\":\"\",\"logoFile\":\"\"}'),
(9, 'beez3', 0, '0', 'Beez3 - Default', '{\"wrapperSmall\":53,\"wrapperLarge\":72,\"logo\":\"\",\"sitetitle\":\"Joomla!\",\"sitedescription\":\"Open Source Content Management\",\"navposition\":\"left\",\"bootstrap\":\"\",\"templatecolor\":\"personal\",\"headerImage\":\"\",\"backgroundcolor\":\"#eee\"}'),
(11, 'shaper_varsita', 0, '1', 'shaper_varsita - Default', '{\"sticky_header\":\"1\",\"favicon\":\"\",\"boxed_layout\":\"0\",\"logo_type\":\"image\",\"logo_position\":\"logo\",\"logo_image\":\"\",\"logo_image_2x\":\"\",\"mobile_logo\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"body_bg_position\":\"0 0\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright\":\"Copyright \\u00a9 2015 - Demo. Designed By <span><a href=\\\"http:\\/\\/www.joomshaper.com\\\" target=\\\"_blank\\\">JoomShaper<\\/a><\\/span>\",\"show_social_icons\":\"0\",\"social_position\":\"bottom4\",\"facebook\":\"#\",\"twitter\":\"#\",\"googleplus\":\"#\",\"pinterest\":\"\",\"linkedin\":\"#\",\"dribbble\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"vk\":\"\",\"enable_contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_phone\":\"+228 872 4444\",\"contact_email\":\"contact@email.com\",\"comingsoon_mode\":\"0\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_date\":\"05-10-2018\",\"comingsoon_content\":\"Coming soon content\",\"preset\":\"preset1\",\"preset1_bg\":\"#ffffff\",\"preset1_text\":\"#303030\",\"preset1_major\":\"#0072bc\",\"preset2_bg\":\"#ffffff\",\"preset2_text\":\"#303030\",\"preset2_major\":\"#998675\",\"preset3_bg\":\"#ffffff\",\"preset3_text\":\"#303030\",\"preset3_major\":\"#37b878\",\"preset4_bg\":\"#ffffff\",\"preset4_text\":\"#303030\",\"preset4_major\":\"#f26522\",\"layoutlist\":\"default.json\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"39\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Header\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"xs_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"md_hidden\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"logo\\\",\\\"column_type\\\":0,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"col-sm-2\\\",\\\"xs_col\\\":\\\"col-xs-6\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-9 column-active\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"menu\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"col-sm-10\\\",\\\"xs_col\\\":\\\"col-xs-6\\\",\\\"custom_class\\\":\\\"\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"name\\\":\\\"Page Title\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-12\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"48\\\",\\\"settings\\\":{\\\"name\\\":\\\"Main Body\\\",\\\"bg_color\\\":\\\"\\\",\\\"bg_image\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"xs_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"md_hidden\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-8\\\",\\\"settings\\\":{\\\"column_type\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"md_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"xs_hidden\\\":0,\\\"name\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-4\\\",\\\"settings\\\":{\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"xs_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"md_hidden\\\":0,\\\"custom_class\\\":\\\"custom-class\\\",\\\"sortableitem\\\":\\\"[object Object]\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3333\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"60px 0px\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"#fafafa\\\",\\\"name\\\":\\\"Bottom\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom1\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom2\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom3\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom4\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3333\\\",\\\"settings\\\":{\\\"name\\\":\\\"Bottom-2nd-row\\\",\\\"background_color\\\":\\\"#fafafa\\\",\\\"color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"0 0 60px 0\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"bottom5\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom6\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom7\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom8\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"bg_color\\\":\\\"\\\",\\\"bg_image\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"xs_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"md_hidden\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"name\\\":\\\"Footer\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-12\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"custom_class\\\":\\\"\\\",\\\"md_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"xs_hidden\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"column_type\\\":0,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-fade\",\"enable_body_font\":\"1\",\"body_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"14\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"48\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"36\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"24\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"18\\\"}\",\"enable_h5_font\":\"1\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"ABeeZee\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"14\\\"}\",\"enable_h6_font\":\"1\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_navigation_font\":\"0\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"ABeeZee\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_custom_font\":\"0\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"ABeeZee\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"before_head\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"compress_css\":\"0\",\"compress_js\":\"0\",\"exclude_js\":\"\",\"lessoption\":\"1\",\"show_post_format\":\"1\",\"commenting_engine\":\"disabled\",\"disqus_subdomain\":\"\",\"disqus_devmode\":\"0\",\"intensedebate_acc\":\"\",\"fb_appID\":\"\",\"fb_width\":\"500\",\"fb_cpp\":\"10\",\"comments_count\":\"0\",\"social_share\":\"1\"}'),
(12, 'shaper_varsita', 0, '0', 'shaper_varsita - Transparent Header', '{\"sticky_header\":\"1\",\"favicon\":\"\",\"boxed_layout\":\"0\",\"logo_type\":\"image\",\"logo_position\":\"logo\",\"logo_image\":\"\",\"logo_image_2x\":\"\",\"mobile_logo\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"body_bg_position\":\"0 0\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright\":\"Copyright © 2015 - Demo. Designed By <span><a href=\\\"http:\\/\\/www.joomshaper.com\\\" target=\\\"_blank\\\">JoomShaper<\\/a><\\/span>\",\"show_social_icons\":\"0\",\"social_position\":\"bottom4\",\"facebook\":\"#\",\"twitter\":\"#\",\"googleplus\":\"#\",\"pinterest\":\"\",\"linkedin\":\"#\",\"dribbble\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"vk\":\"\",\"enable_contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_phone\":\"+228 872 4444\",\"contact_email\":\"contact@email.com\",\"comingsoon_mode\":\"0\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_date\":\"05-10-2018\",\"comingsoon_content\":\"Coming soon content\",\"preset\":\"preset1\",\"preset1_bg\":\"#ffffff\",\"preset1_text\":\"#767676\",\"preset1_major\":\"#0673ba\",\"preset2_bg\":\"#ffffff\",\"preset2_text\":\"#767676\",\"preset2_major\":\"#998675\",\"preset3_bg\":\"#ffffff\",\"preset3_text\":\"#000000\",\"preset3_major\":\"#37b878\",\"preset4_bg\":\"#ffffff\",\"preset4_text\":\"#000000\",\"preset4_major\":\"#f16625\",\"layoutlist\":\"default.json\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"39\\\",\\\"settings\\\":{\\\"name\\\":\\\"Header\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"header-transparent\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"logo\\\",\\\"xs_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"md_hidden\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"col-sm-2\\\",\\\"xs_col\\\":\\\"col-xs-6\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-9 column-active\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"xs_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"md_hidden\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"menu\\\",\\\"column_type\\\":0,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"col-sm-10\\\",\\\"xs_col\\\":\\\"col-xs-6\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Page Title\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-12\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"title\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"48\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"md_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"xs_hidden\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"bg_image\\\":\\\"\\\",\\\"bg_color\\\":\\\"\\\",\\\"name\\\":\\\"Main Body\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-8\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"name\\\":\\\"\\\",\\\"xs_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"md_hidden\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"column_type\\\":1}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-4\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"custom_class\\\":\\\"custom-class\\\",\\\"md_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"xs_hidden\\\":0,\\\"name\\\":\\\"right\\\",\\\"column_type\\\":0,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3333\\\",\\\"settings\\\":{\\\"name\\\":\\\"Bottom\\\",\\\"background_color\\\":\\\"#fafafa\\\",\\\"color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"60px 0px\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom2\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom3\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom4\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3333\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"0 0 60px 0\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"#fafafa\\\",\\\"name\\\":\\\"Bottom-2nd-row\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom5\\\",\\\"column_type\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom6\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom7\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-3\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"bottom8\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"name\\\":\\\"Footer\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"md_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"xs_hidden\\\":0,\\\"text_color\\\":\\\"\\\",\\\"bg_image\\\":\\\"\\\",\\\"bg_color\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"className\\\":\\\"layout-column col-sm-12\\\",\\\"settings\\\":{\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"column_type\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"xs_hidden\\\":0,\\\"ms_hidden\\\":0,\\\"md_hidden\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-fade\",\"enable_body_font\":\"1\",\"body_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"14\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"48\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"36\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"24\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"PT Sans\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"18\\\"}\",\"enable_h5_font\":\"1\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"ABeeZee\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"14\\\"}\",\"enable_h6_font\":\"1\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_navigation_font\":\"0\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"ABeeZee\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"enable_custom_font\":\"0\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"ABeeZee\\\",\\\"fontWeight\\\":\\\"regular\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontSize\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"before_head\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"compress_css\":\"0\",\"compress_js\":\"0\",\"exclude_js\":\"\",\"lessoption\":\"1\",\"show_post_format\":\"1\",\"commenting_engine\":\"disabled\",\"disqus_subdomain\":\"\",\"disqus_devmode\":\"0\",\"intensedebate_acc\":\"\",\"fb_appID\":\"\",\"fb_width\":\"500\",\"fb_cpp\":\"10\",\"comments_count\":\"0\",\"social_share\":\"1\"}');

-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_base`
--

DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) UNSIGNED NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__ucm_base`
--

INSERT INTO `#__ucm_base` (`ucm_id`, `ucm_item_id`, `ucm_type_id`, `ucm_language_id`) VALUES
(1, 77, 1, 0),
(2, 76, 1, 0),
(3, 75, 1, 0),
(4, 74, 1, 0),
(5, 73, 1, 0),
(6, 72, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_content`
--

DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) UNSIGNED NOT NULL,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_checked_out_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `core_access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `core_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_featured` tinyint(4) UNSIGNED NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_content_item_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `core_version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';

--
-- Dumping data for table `#__ucm_content`
--

INSERT INTO `#__ucm_content` (`core_content_id`, `core_type_alias`, `core_title`, `core_alias`, `core_body`, `core_state`, `core_checked_out_time`, `core_checked_out_user_id`, `core_access`, `core_params`, `core_featured`, `core_metadata`, `core_created_user_id`, `core_created_by_alias`, `core_created_time`, `core_modified_user_id`, `core_modified_time`, `core_language`, `core_publish_up`, `core_publish_down`, `core_content_item_id`, `asset_id`, `core_images`, `core_urls`, `core_hits`, `core_version`, `core_ordering`, `core_metakey`, `core_metadesc`, `core_catid`, `core_xreference`, `core_type_id`) VALUES
(1, 'com_content.article', 'J! Geek - an online course about Joomla', 'j-geek-an-online-course-about-joomla', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', 1, '', 0, 1, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"quote\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"Pork meatball ground round prosciutto. Sirloin bresaola ball tip shank tail porchetta pork boudin filet mignon flank jowl salami. Filet mignon bresaola pork boudin capicola prosciutto. Frankfurter chicken leberkas drumstick ball tip turducken rump spare ribs meatball. Tail salami pork loin ham. Drumstick flank porchetta, hamburger ham swine biltong chicken pancetta. Spare ribs prosciutto t-bone.\",\"quote_author\":\"- John Doe\",\"post_status\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 776, '', '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', '*', '2018-02-20 05:55:40', '0000-00-00 00:00:00', 77, 256, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', 30, 10, 0, '', '', 79, '', 1),
(2, 'com_content.article', 'Courses Website Redesign', 'courses-website-redesign', '<p>Following are some updates of note from March. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', 1, '', 0, 1, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"link\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"Responive Joomla Templates\",\"link_url\":\"http:\\/\\/www.joomshaper.com\\/joomla-templates\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 776, '', '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', '*', '2018-02-20 05:55:40', '0000-00-00 00:00:00', 76, 257, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', 40, 8, 1, '', '', 79, '', 1),
(3, 'com_content.article', 'Radical Ideas for Reinventing Education', 'radical-ideas-for-reinventing-education', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum consequat massa in mauris ornare congue. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est.  </p>\r\n', 1, '', 0, 1, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"audio\",\"gallery\":\"\",\"audio\":\"<iframe width=\\\"100%\\\" height=\\\"450\\\" scrolling=\\\"no\\\" frameborder=\\\"no\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/28830162&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true\\\"><\\/iframe>\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 776, '', '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', '*', '2018-02-20 05:55:40', '0000-00-00 00:00:00', 75, 258, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', 25, 7, 2, '', '', 79, '', 1),
(4, 'com_content.article', 'CMS have new LMS technology', 'cms-have-new-lms-technology', '<p>Joomla ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros.s. Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consectetur adipiscing elit. </p>\r\n', 1, '', 0, 1, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"gallery\",\"gallery\":\"{\\\"gallery_images\\\":[\\\"images\\/blog\\/blog06.jpg\\\",\\\"images\\/blog\\/blog05.jpg\\\",\\\"images\\/blog\\/blog04.jpg\\\"]}\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 776, '', '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', '*', '2018-02-20 05:55:40', '0000-00-00 00:00:00', 74, 259, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', 26, 8, 3, '', '', 79, '', 1),
(5, 'com_content.article', 'Oxford University Libraries', 'oxford-university-libraries', '<p><span class=\"field-item-single\">Varsita meets the needs of its students, academics and the international learing community. </span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros.</p>\r\n', 1, '', 0, 1, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"standard\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 776, '', '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', '*', '2018-02-20 05:55:40', '0000-00-00 00:00:00', 73, 260, '{\"image_intro\":\"images\\/blog\\/blog01.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/blog01.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', 82, 6, 4, '', '', 79, '', 1),
(6, 'com_content.article', 'Top innovation means promising future', 'top-innovation-means-promising-future', '<p>LMS Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse accumsan, ligula in hendrerit pulvinar, justo enim pulvinar mauris, eget cursus dolor augue a eros. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n', 1, '', 0, 1, '{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"post_format\":\"video\",\"gallery\":\"\",\"audio\":\"\",\"video\":\"http:\\/\\/vimeo.com\\/43426940\",\"link_title\":\"\",\"link_url\":\"\",\"quote_text\":\"\",\"quote_author\":\"\",\"post_status\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 776, '', '2018-02-20 05:55:40', 776, '2018-02-20 05:55:40', '*', '2018-02-20 05:55:40', '0000-00-00 00:00:00', 72, 261, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', 57, 7, 5, '', '', 79, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_history`
--

DROP TABLE IF EXISTS `#__ucm_history`;
CREATE TABLE `#__ucm_history` (
  `version_id` int(10) UNSIGNED NOT NULL,
  `ucm_item_id` int(10) UNSIGNED NOT NULL,
  `ucm_type_id` int(10) UNSIGNED NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `character_count` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__ucm_history`
--

INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(1, 19, 6, '', '2018-02-20 05:55:40', 776, 580, '8b8b28d0735048ef374cfed409baeca2e9c48a2a', '{\"id\":19,\"asset_id\":\"44\",\"parent_id\":\"1\",\"lft\":\"105\",\"rgt\":132,\"level\":1,\"path\":\"sample-data-articles\\/joomla\",\"extension\":\"com_content\",\"title\":\"Joomla!\",\"alias\":\"joomla\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 06:05:10\",\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2011-01-01 00:00:01\",\"modified_user_id\":\"864\",\"modified_time\":\"2015-02-02 06:05:15\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\"}', 0),
(2, 21, 6, '', '2018-02-20 05:55:40', 776, 872, '44c955d32c91be43379e62067ff88355a5e6afd7', '{\"id\":21,\"asset_id\":\"46\",\"parent_id\":\"19\",\"lft\":\"130\",\"rgt\":131,\"level\":2,\"path\":\"joomla\\/extensions\\/components\",\"extension\":\"com_content\",\"title\":\"Components\",\"alias\":\"components\",\"note\":\"\",\"description\":\"<p>Components are larger extensions that produce the major content for your site. Each component has one or more \\\"views\\\" that control how content is displayed. In the Joomla administrator there are additional extensions such as Menus, Redirection, and the extension managers.<\\/p>\",\"published\":\"1\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 06:05:17\",\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2011-01-01 00:00:01\",\"modified_user_id\":\"864\",\"modified_time\":\"2015-02-02 06:05:23\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\"}', 0),
(3, 79, 6, '', '2018-02-20 05:55:40', 776, 511, '633bb165d3f0f0ffc2722ee67a8a24736aadfb47', '{\"id\":79,\"asset_id\":179,\"parent_id\":\"1\",\"lft\":\"91\",\"rgt\":92,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Blog\",\"alias\":\"blog\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 06:12:46\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}', 0),
(4, 80, 6, '', '2018-02-20 05:55:40', 776, 511, 'd9e56992245d6c642c811b6be37a65ad944605d4', '{\"id\":80,\"asset_id\":191,\"parent_id\":\"1\",\"lft\":\"93\",\"rgt\":94,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"News\",\"alias\":\"news\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:42:14\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}', 0),
(5, 80, 6, '', '2018-02-20 05:55:40', 776, 551, 'b0c69f126552d2f470dab4c2637f32d2d55d04ca', '{\"id\":80,\"asset_id\":\"191\",\"parent_id\":\"79\",\"lft\":\"92\",\"rgt\":93,\"level\":2,\"path\":\"news\",\"extension\":\"com_content\",\"title\":\"News\",\"alias\":\"news\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 18:42:24\",\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:42:14\",\"modified_user_id\":\"864\",\"modified_time\":\"2015-02-02 18:42:30\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\"}', 0),
(6, 81, 6, '', '2018-02-20 05:55:40', 776, 520, 'c1186cda9e6fae853472a26d68bc50d2f9af3eef', '{\"id\":81,\"asset_id\":192,\"parent_id\":\"79\",\"lft\":\"94\",\"rgt\":95,\"level\":2,\"path\":null,\"extension\":\"com_content\",\"title\":\"Tutorial\",\"alias\":\"tutorial\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:42:46\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}', 0),
(7, 82, 6, '', '2018-02-20 05:55:40', 776, 516, '8433516aea93072c0f29f750669e5b4dfe733e72', '{\"id\":82,\"asset_id\":193,\"parent_id\":\"79\",\"lft\":\"96\",\"rgt\":97,\"level\":2,\"path\":null,\"extension\":\"com_content\",\"title\":\"Review\",\"alias\":\"review\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:42:56\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}', 0),
(8, 83, 6, '', '2018-02-20 05:55:40', 776, 518, 'c054624137f36fae4f0cc107c6e7caa47aeb8401', '{\"id\":83,\"asset_id\":194,\"parent_id\":\"79\",\"lft\":\"98\",\"rgt\":99,\"level\":2,\"path\":null,\"extension\":\"com_content\",\"title\":\"Updates\",\"alias\":\"updates\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"864\",\"created_time\":\"2015-02-02 18:43:15\",\"modified_user_id\":null,\"modified_time\":null,\"hits\":\"0\",\"language\":\"*\",\"version\":null}', 0),
(9, 71, 1, '', '2018-02-20 05:55:40', 776, 2452, '3199ad1fb625886490e0c300580c73a27ce5ad80', '{\"id\":71,\"asset_id\":195,\"title\":\"Sed non bibendum urna lorem ipsum dolor sit amet, consectetur adipiscing elit\",\"alias\":\"sed-non-bibendum-urna-lorem-ipsum-dolor-sit-amet-consectetur-adipiscing-elit\",\"introtext\":\"\",\"fulltext\":\"\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(10, 71, 1, '', '2018-02-20 05:55:40', 776, 3565, 'd515334bc8af0f508f8d49ed3f265247e6927098', '{\"id\":71,\"asset_id\":\"195\",\"title\":\"Sed non bibendum urna lorem ipsum dolor sit amet, consectetur adipiscing elit\",\"alias\":\"sed-non-bibendum-urna-lorem-ipsum-dolor-sit-amet-consectetur-adipiscing-elit\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 18:57:20\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 18:56:08\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(11, 71, 1, '', '2018-02-20 05:55:40', 776, 3506, '65f0cb164ef3547aea586502a546465a75009405', '{\"id\":71,\"asset_id\":\"195\",\"title\":\"Sed non bibendum urna lorem ipsum dolor sit amet\",\"alias\":\"sed-non-bibendum-urna-lorem-ipsum-dolor-sit-amet\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 19:27:38\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 19:27:11\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"link\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(12, 71, 1, '', '2018-02-20 05:55:40', 776, 3474, '83a23bb087b2f684a1a99ac8909d53860444eef9', '{\"id\":71,\"asset_id\":\"195\",\"title\":\"Doner spare ribs pastrami shank\",\"alias\":\"doner-spare-ribs-pastrami-shank\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 18:56:08\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:27:55\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 19:44:14\",\"publish_up\":\"2015-02-02 18:56:08\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"status\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"<blockquote class=\\\\\\\"twitter-tweet\\\\\\\" lang=\\\\\\\"en\\\\\\\"><p>Published a new blog entry One Month Extra for all JoomShaper Members in News. <a href=\\\\\\\"http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8\\\\\\\">http:\\\\\\/\\\\\\/t.co\\\\\\/2pQYdykKy8<\\\\\\/a><\\\\\\/p>&mdash; JoomShaper (@joomshaper) <a href=\\\\\\\"https:\\\\\\/\\\\\\/twitter.com\\\\\\/joomshaper\\\\\\/status\\\\\\/562210375480139777\\\\\\\">February 2, 2015<\\\\\\/a><\\\\\\/blockquote>\\\\r\\\\n<script async src=\\\\\\\"\\\\\\/\\\\\\/platform.twitter.com\\\\\\/widgets.js\\\\\\\" charset=\\\\\\\"utf-8\\\\\\\"><\\\\\\/script>\\\"}\",\"version\":4,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"5\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(13, 72, 1, '', '2018-02-20 05:55:40', 776, 2978, '2e634ee58bf5a238a9f23f8648ceb1740903121e', '{\"id\":72,\"asset_id\":196,\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/106306926\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(14, 72, 1, '', '2018-02-20 05:55:40', 776, 3015, 'dd4d438b486ad946a1e95cdd3e0fb3f6362dc0a0', '{\"id\":72,\"asset_id\":\"196\",\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:31:04\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:29:50\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/47505825\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(15, 72, 1, '', '2018-02-20 05:55:40', 776, 3015, 'd6a7362352a24b1ee69fcc4aa4377bf7d7de6c7a', '{\"id\":72,\"asset_id\":\"196\",\"title\":\"Jerky shank chicken boudin\",\"alias\":\"jerky-shank-chicken-boudin\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:31:45\",\"modified_by\":\"864\",\"checked_out\":\"864\",\"checked_out_time\":\"2015-02-02 20:31:40\",\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_layout\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"post_format\\\":\\\"video\\\",\\\"gallery\\\":\\\"\\\",\\\"audio\\\":\\\"\\\",\\\"video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/43426940\\\",\\\"link_title\\\":\\\"\\\",\\\"link_url\\\":\\\"\\\",\\\"quote_text\\\":\\\"\\\",\\\"quote_author\\\":\\\"\\\",\\\"post_status\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(16, 73, 1, '', '2018-02-20 05:55:40', 776, 3008, '460756e5114f53fbad57d5f6ae16e526d075d1d6', '{\"id\":73,\"asset_id\":197,\"title\":\"Jerky shank chicken boudin (2)\",\"alias\":\"jerky-shank-chicken-boudin-2\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>\\u00a0<\\/p>\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":0,\"catid\":\"79\",\"created\":\"2015-02-02 20:29:50\",\"created_by\":\"864\",\"created_by_alias\":\"\",\"modified\":\"2015-02-02 20:31:45\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2015-02-02 20:29:50\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/blog\\\\\\/blog01.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\