<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewTeacher extends JViewLegacy{
	
	protected $item;
	protected $params;

	function display($tpl = null) {
		// Assign data to the view
		$this->item = $this->get('Item');
		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		//get Component Params
		jimport('joomla.application.component.helper');
		$this->params = JComponentHelper::getParams('com_splms');

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}

		//teacher show contact 
		$this->show_contact = $this->params->get('teacher_contact', '');

		// Load courses & lesson Model
		$model 		   = JModelLegacy::getInstance( 'Coursescategories', 'SplmsModel' );
		$courses_model = JModelLegacy::getInstance( 'Courses', 'SplmsModel' );
		$lessons_model = JModelLegacy::getInstance( 'Lessons', 'SplmsModel' );

		// Get image thumb
		$this->user = JFactory::getUser();
		$lmsparams 	= JComponentHelper::getParams('com_splms');
		$this->thumb_size = strtolower($lmsparams->get('course_thumbnail', '480X300'));

		$this->lessons = $lessons_model->getTeacherLessons($this->item->id);

		$this->teacher_courses = array();
		foreach ($this->lessons as &$this->lesson) {
			$this->lessonCourse = $courses_model->getCourse($this->lesson->course_id);
			$this->isAuthorised = $courses_model->getIsbuycourse($this->user->id, $this->lesson->get_course_info->id);
			$this->teacher_courses[$this->lesson->get_course_info->id] = $this->lesson->get_course_info;
		}

		foreach ($this->teacher_courses as &$this->teacher_course) {
			// image thumb size
			$filename = basename($this->teacher_course->image);
			$path = JPATH_BASE .'/'. dirname($this->teacher_course->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $this->thumb_size . '.' . JFile::getExt($filename);
			$src = JURI::base(true) . '/' . dirname($this->teacher_course->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $this->thumb_size . '.' . JFile::getExt($filename);

			if(JFile::exists($path)) {
				$this->teacher_course->thumb = $src;
			} else {
				$this->teacher_course->thumb = JURI::root() . $this->teacher_course->image;
			}
		}

		// specialist in
		if (isset($this->item->specialist_in) && !empty($this->item->specialist_in) && !is_array($this->item->specialist_in) && SplmsHelper::isJson($this->item->specialist_in)) {
			$this->item->specialist_in = json_decode($this->item->specialist_in, TRUE);
		}

		//Generate Item Meta
        $itemMeta               = array();
        $itemMeta['title']      = $this->item->title;
        $cleanText              = $this->item->description;
        $itemMeta['metadesc']   = JHtml::_('string.truncate', JFilterOutput::cleanText($cleanText), 155);
        if ($this->item->image) {
        	$itemMeta['image']      = JURI::base() . $this->item->image;
        }
        
        SplmsHelper::itemMeta($itemMeta);
		parent::display($tpl);
	}
	
}
