<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

$doc = JFactory::getDocument();
$doc->addScript(JURI::root(true) . '/components/com_splms/assets/js/jquery.easypiechart.min.js');
$doc->addScript(JURI::root(true) . '/components/com_splms/assets/js/bootstrap-datepicker.min.js');
$doc->addScriptdeclaration('var splms_appointment_url="' . JURI::base() . 'index.php?option=com_splms";');

$doc->addStylesheet(JURI::root(true) . '/components/com_splms/assets/css/bootstrap-datepicker3.css');

?>

<div id="splms" class="splms view-splms-teacher splms-person">

	<div class="splms-row">
		<div class="splms-col-sm-4">
			<img src="<?php echo $this->item->image ?>" class="splms-person-image splms-img-responsive" alt="<?php echo $this->item->title; ?>">
		</div>

		<div class="splms-col-sm-8">
			<div class="splms-person-details">
				<h3 class="splms-person-title">
					<?php echo $this->item->title; ?>
				</h3>

				<?php if($this->item->designation){ ?>
					<p><?php echo $this->item->designation; ?></p>
				<?php } ?>

				<?php if (!empty($this->item->experience)) { ?>
				<p class="splms-teacher-experience">
					<?php echo JText::_('COM_SPLMS_COMMON_EXPERIENCE') . ': '; ?>
					<?php echo $this->item->experience; ?>
				</p>
				<?php } ?>

				<p class="splms-tecaher-lessons">
					<?php echo JText::_('COM_SPLMS_COMMON_TOTAL') . ': '; ?>
		        	<?php echo count($this->lessons); ?>
		        	<?php echo JText::_('COM_SPLMS_COMMON_LESSONS'); ?>
				</p>

				<?php if (!empty($this->item->email)) { ?>
					<p class="splms-person-email">
						<?php echo JText::_('COM_SPLMS_COMMON_EMAIL') . ': '; ?>
						<a href="mailto: <?php echo $this->item->email; ?>"><?php echo $this->item->email; ?></a>
					</p>
				<?php } ?>

				<?php if (!empty($this->item->website)) { ?>
					<p class="splms-person-website">
						<?php echo JText::_('COM_SPLMS_COMMON_WEBSITE') . ': '; ?>
						<a href="<?php echo $this->item->website; ?>" target="_blank"> <?php echo $this->item->website; ?> </a>
					</p>
				<?php } ?>

				<?php if ( (!empty($this->item->social_facebook)) ||
					(!empty($this->item->social_linkedin)) ||
					(!empty($this->item->social_twitter)) ||
					(!empty($this->item->social_gplus))) { ?>

					<ul class="splms-persion-social-icons">
						<?php if (!empty($this->item->social_facebook)) { ?>
						<li class="facebook">
							<a href="http://facebook.com/<?php echo $this->item->social_facebook; ?>" target="_blank">
								<i class="splms-icon-facebook"></i>
							</a>
						</li>
						<?php } if (!empty($this->item->social_linkedin)) {?>
						<li class="linkedin">
							<a href="http://linkedin.com/<?php echo $this->item->social_linkedin; ?>" target="_blank">
								<i class="splms-icon-linkedin"></i>
							</a>
						</li>
						<?php } if (!empty($this->item->social_twitter)) {?>
						<li class="twitter">
							<a href="http://twitter.com/<?php echo $this->item->social_twitter; ?>" target="_blank">
								<i class="splms-icon-twitter"></i>
							</a>
						</li>
						<?php } if (!empty($this->item->social_gplus)) {?>
						<li class="gplus">
							<a href="https://plus.google.com/<?php echo $this->item->social_gplus; ?>" target="_blank">
								<i class="splms-icon-google-plus"></i>
							</a>
						</li>
						<?php } ?>
					</ul>
				<?php } ?>

				<div class="splms-person-description">
					<?php echo $this->item->description; ?>
				</div>

				<?php if(isset($this->lessons) && count($this->lessons)) { ?>
					<div class="splms-teacher-lessons">
						<h3><?php echo JText::_('COM_SPLMS_LESOSNS_LIST'); ?></h3>
						<div class="splms-teacher-lessons-list">
							<ul>
								<?php foreach ($this->lessons as $lesson) { ?>

								<?php if ($lesson->lesson_type == 0 || $this->isAuthorised != '' || $this->lessonCourse->price == 0) { ?>
									<li>
										<span>
											<a href="<?php echo $lesson->lesson_url; ?>"><?php echo $lesson->title; ?>
											</a>
										</span>
										<span class="lesson-duration pull-right">
											<i class="splms-icon-time"></i> <?php echo JText::_('COM_SPLMS_COMMON_DURATION') . ': '; ?> <?php echo $lesson->video_duration; ?>
										</span>
									</li>
								<?php } else { ?>
									<li class="splms-lesson-unauthorised">
										<span>
											<i class="splms-icon-lock"></i>
											<?php echo $lesson->title; ?>
										</span>
										<span class="lesson-duration pull-right">
											<i class="splms-icon-time"></i> <?php echo JText::_('COM_SPLMS_COMMON_DURATION') . ': '; ?>
											<?php echo $lesson->video_duration; ?>
										</span>
									</li>
								<?php } ?>

								<?php } ?>
							</ul>
						</div>
					</div> <!-- //.splms-teacher-lessons -->
				<?php } ?>
			</div> <!-- //.splms-person-details -->
		</div> <!-- //.splms-col-sm-8 -->

		<div class="splms-col-sm-12">
			<?php if (!empty($this->item->specialist_in) && is_array($this->item->specialist_in)) { ?>
	            <div class="splms-person-progress">
	                <?php
	                $i = 1;
	                foreach ($this->item->specialist_in as $special_field) {
	                    $i = ($i == 5) ? 1 : $i;
	                    switch ($i) {
	                        case 1:
	                            $pie_color = '#8062FE';
	                            break;
	                        case 2:
	                            $pie_color = '#1DDBB7';
	                            break;
	                        case 3:
	                            $pie_color = '#FD7563';
	                            break;
	                        case 4:
	                            $pie_color = '#913A72';
	                            break;

	                        default:
	                            $pie_color = '#999999';
	                            break;
	                    } ?>
	                    <div class="splms-pie-chart" data-size="70" data-percent="<?php echo $special_field['specialist_number']; ?>" data-barcolor="<?php echo $pie_color; ?>" data-trackcolor="#f5f5f5">
	                        <div class="splms-chart-percent"><span><?php echo $special_field['specialist_number'] . '%'; ?></span></div>
	                        <div class="info"><?php echo $special_field['specialist_text']; ?></div>
	                    </div>
	                    <?php $i++;
	                } ?>
	            </div> <!-- //.splms-person-progress -->
	        <?php } ?>
		</div> <!-- //.splms-col-sm-12 -->

		<?php if ($this->show_contact && !empty($this->item->email)) { ?>
			<div class="splms-col-sm-12">
	        <div id="splms-teacher-contact-from" class="splms-teacher-contact-from">
	              <div class="contact-from-title-wrap splms-text-center">
	                  <div class="contact-from-title">
	                      <h2 class="title-heading"><?php echo JText::_('COM_SPLMS_PERSON_CONTACT_TITLE') . $this->item->title; ?></h2>
	                      <p class="title-subheading"><?php echo JText::_('COM_SPLMS_PERSON_CONTACT_TITLE_SUBTITLE'); ?></p>
	                  </div>
	              </div>
	              <form id="splms-teacher-contact-form">
				  		<div class="controls splms-row">
						  <div class="splms-col-sm-12 splms-col-xs-12">
								<label for="name"><?php echo JText::_('COM_SPLMS_PERSON_CONTACT_NAME_LABEL'); ?></label>
								<input type="text" name="name" id="name" placeholder="<?php echo JText::_('COM_SPLMS_PERSON_CONTACT_NAME_LABEL') ?>" required="required">
							</div> <!-- //.col-sm-12 -->
						</div>
						<div class="controls splms-row">
							<div class="splms-col-sm-6 splms-col-xs-12">
								<label for="email"><?php echo JText::_('COM_SPLMS_PERSON_CONTACT_EMAIL_LABEL'); ?></label>
								<input type="email" name="email" id="email" placeholder="<?php echo JText::_('COM_SPLMS_PERSON_CONTACT_EMAIL_LABEL') ?>" required="required">
							</div> <!-- //.col-sm-6 -->
							<div class="splms-col-sm-6 splms-col-xs-12">
								<label for="phone"><?php echo JText::_('COM_SPLMS_PERSON_CONTACT_PHONE_NUMBER_LABEL'); ?></label>
								<input type="tel" name="phone" id="phone" placeholder="<?php echo JText::_('COM_SPLMS_PERSON_CONTACT_PHONE_NUMBER_LABEL') ?>" required="required">
							</div> <!-- //.col-sm-6 -->
						</div> <!-- //.controls -->
						<div class="controls splms-row">
							<div class="splms-col-sm-12 splms-col-xs-12">
								<label for="subject"><?php echo JText::_('COM_SPLMS_PERSON_CONTACT_SUBJECT_LABEL'); ?></label>
								<input type="text" name="subject" id="subject" placeholder="<?php echo JText::_('COM_SPLMS_PERSON_CONTACT_SUBJECT_LABEL') ?>" required="required">
							</div> <!-- //.col-sm-12 -->
						</div> <!-- //.controls -->   
						<div class="controls splms-row">
							<div class="splms-col-sm-12 splms-col-xs-12">
								<label for="message"><?php echo JText::_('COM_SPLMS_PERSON_CONTACT_MESSAGE_LABEL'); ?></label>
								<textarea name="message" id="message" rows="5" class="sppb-form-control" placeholder="<?php echo JText::_('COM_SPLMS_PERSON_CONTACT_MESSAGE_LABEL') ?>" required="required"></textarea>
							</div> <!-- //.col-sm-12 -->
							<div class="splms-col-sm-12 splms-text-center splms-button-wrap splms-col-xs-12">
								<input type="hidden" name="teacher_email" value="<?php echo base64_encode($this->item->email); ?>">
								<button type="submit" id="contact-submit"  class="btn btn-primary"><?php echo JText::_('COM_SPLMS_PERSON_CONTACT_SUBMIT'); ?></button>
							</div> <!-- //.col-sm-12 -->
						</div> <!-- //.controls -->
	              </form>
	              <div style="display:none;margin-top:10px;" class="splms-cont-status"></div>
	        </div> <!-- END:: splms-trainer-appointment-from -->
			</div> <!-- //.splms-col-sm-12 -->
		<?php } ?>

	</div> <!-- //.splms-row -->
</div> <!-- //.splms view-splms-teacher -->
