<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewPurchases extends JViewLegacy{


	protected $items;
	protected $params;
	protected $layout_type;

	function display($tpl = null) {
		// Assign data to the view
		$this->items = $this->get('items');
		$this->pagination	= $this->get('Pagination');

		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		if($menu) {
			//$this->params->merge($menu->params);
		}

		$this->layout_type = str_replace('_', '-', $this->params->get('layout_type', 'default'));
		// Check for errors.
		if ($errors = $this->get('Errors') && count($errors = $this->get('Errors'))) {
			JLog::add(implode('<br />', $errors), JLog::WARNING, 'jerror');
			return false;
		}

		$user = JFactory::getUser();
		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
		
		//Loan Courses model
		$courses_model = JModelLegacy::getInstance( 'Courses', 'SplmsModel' );
		// load quiz model
		$quiz_model = JModelLegacy::getInstance( 'Quizquestions', 'SplmsModel' );
		// load certificate model
		$certificate_model = JModelLegacy::getInstance( 'Certificates', 'SplmsModel' );

		if($user->guest) {
			echo '<p class="alert alert-danger">' . JText::_('COM_SPLMS_PURCHASED_QUIZ_LOGIN') . '</p>';
			return;	
		}

		$purchased_course = $courses_model->getPurchasedCourse( $user->id );
		if (empty($purchased_course)) {
			echo '<p class="alert alert-warning">' . JText::_('COM_SPMS_NO_EMPTY_PURCHASED') . '</p>';
		}

		$this->purchases = $purchased_course;
		// quiz result
		$this->quiz_results = $quiz_model->getQuizResult( $user->id );

		if (empty($this->quiz_results)) {
			echo '<p class="alert alert-warning">' . JText::_('COM_SPMS_EMPTY_QUIZ_RESULT') . '</p>';
		}

		// certificates
		$this->user_certificates = $certificate_model->getCerficateById( $user->id );
		if (empty($this->user_certificates)) {
			echo '<p class="alert alert-warning">' . JText::_('COM_SPMS_EMPTY_CERTIFICATE') . '</p>';
		}

		parent::display($tpl);
	}

}
